/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BFileReader;
import com.scudata.dm.BlockInputStream;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.KeyWord;
import com.scudata.dm.LineImporter;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class BFileFetchCursor
extends ICursor {
    private static final String _$20 = "BFILE_BYTES_FIELD";
    private BFileReader _$19;
    private BFileReader _$18;
    private ObjectReader _$17;
    private LineImporter _$16;
    private String[] _$15;
    private byte[] _$14;
    private int[] _$13;
    private String _$12;
    private byte[] _$11;
    private boolean _$10;
    private boolean _$9;
    private int[] _$8;
    private int _$7;
    private DataStruct _$6;
    private byte[] _$5;
    private long _$4;
    private boolean _$3 = false;

    public BFileFetchCursor(FileObject file, String[] fields) {
        this._$19 = new BFileReader(file, fields, null);
        BFileReader reader2 = new BFileReader(file, fields, null);
        try {
            int len;
            this._$19.open();
            this._$8 = this._$19.getReadIndex();
            this._$7 = len = fields.length;
            String[] dsFields = Arrays.copyOf(fields, len + 1);
            dsFields[len] = _$20;
            this.dataStruct = new DataStruct(dsFields);
            this._$6 = this._$19.getFileDataStruct();
            reader2.open();
            this._$17 = reader2.getImporter();
        }
        catch (IOException e) {
            try {
                this._$19.close();
                reader2.close();
                this._$17.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
    }

    public BFileFetchCursor(FileObject fileObject, String[] fields, byte[] types, String s, String opt, Context ctx) {
        this._$14 = types;
        this._$12 = opt;
        this.ctx = ctx;
        if (fields != null) {
            int len;
            this._$15 = new String[fields.length];
            System.arraycopy(fields, 0, this._$15, 0, fields.length);
            this._$7 = len = fields.length;
            String[] dsFields = Arrays.copyOf(fields, len + 1);
            dsFields[len] = _$20;
            this.dataStruct = new DataStruct(dsFields);
        }
        boolean isCsv = false;
        if (opt != null) {
            if (opt.indexOf(116) != -1) {
                this._$10 = true;
            }
            if (opt.indexOf(99) != -1) {
                isCsv = true;
            }
            if (opt.indexOf(105) != -1) {
                this._$9 = true;
            }
        }
        if (s != null && s.length() > 0) {
            String charset = fileObject.getCharset();
            try {
                this._$11 = s.getBytes(charset);
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        } else {
            this._$11 = isCsv ? new byte[]{44} : FileObject.COL_SEPARATOR;
        }
        BlockInputStream is = fileObject.getBlockInputStream(Env.FILE_BUFSIZE);
        this._$17 = new ObjectReader(is, Env.FILE_BUFSIZE);
        this._$16 = this._$1(fileObject, fields);
        this._$4 = fileObject.size();
    }

    private LineImporter _$1(FileObject fileObject, String[] selFields) {
        if (this._$16 != null) {
            return this._$16;
        }
        if (fileObject == null) {
            return null;
        }
        BlockInputStream in = null;
        try {
            in = fileObject.getBlockInputStream();
            String charset = fileObject.getCharset();
            this._$16 = new LineImporter(in, charset, this._$11, this._$12);
            if (this._$10) {
                Object[] line = this._$16.readFirstLine();
                if (line == null) {
                    return null;
                }
                int titleLen = (int)this._$16.getCurrentPosition();
                this._$5 = new byte[titleLen];
                this._$17.read(this._$5);
                int fcount = line.length;
                String[] fieldNames = new String[fcount];
                for (int f = 0; f < fcount; ++f) {
                    fieldNames[f] = Variant.toString(line[f]);
                }
                DataStruct ds = this._$6 = new DataStruct(fieldNames);
                if (selFields != null) {
                    int i;
                    if (this._$9) {
                        this._$9 = selFields.length == 1;
                    }
                    int maxSeq = 0;
                    int[] index = new int[fcount];
                    for (i = 0; i < fcount; ++i) {
                        index[i] = -1;
                    }
                    int count = selFields.length;
                    for (i = 0; i < count; ++i) {
                        int q = ds.getFieldIndex(selFields[i]);
                        if (q >= 0) {
                            if (index[q] != -1) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(selFields[i] + mm.getMessage("ds.colNameRepeat"));
                            }
                            index[q] = i;
                            selFields[i] = ds.getFieldName(q);
                            if (q <= maxSeq) continue;
                            maxSeq = q;
                            continue;
                        }
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(selFields[i] + mm.getMessage("ds.fieldNotExist"));
                    }
                    if (++maxSeq < fcount) {
                        int[] tmp = new int[maxSeq];
                        System.arraycopy(index, 0, tmp, 0, maxSeq);
                        index = tmp;
                    }
                    this._$13 = index;
                    this._$16.setColSelectIndex(index);
                    this._$14 = new byte[maxSeq];
                    this._$16.setColTypes(this._$14, null);
                } else {
                    this.setDataStruct(ds);
                    if (this._$9 && fcount != 1) {
                        this._$9 = false;
                    }
                }
            } else if (selFields != null) {
                if (this._$9) {
                    this._$9 = selFields.length == 1;
                }
                int fcount = 0;
                int count = selFields.length;
                for (int i = 0; i < count; ++i) {
                    if (KeyWord.isFieldId(selFields[i])) {
                        int f = KeyWord.getFiledId(selFields[i]);
                        if (f <= fcount) continue;
                        fcount = f;
                        continue;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(selFields[i] + mm.getMessage("ds.fieldNotExist"));
                }
                int[] index = new int[fcount];
                for (int i = 0; i < fcount; ++i) {
                    index[i] = -1;
                }
                String[] fieldNames = new String[fcount];
                DataStruct ds = this._$6 = new DataStruct(fieldNames);
                int count2 = selFields.length;
                for (int i = 0; i < count2; ++i) {
                    int q = ds.getFieldIndex(selFields[i]);
                    if (q < 0) continue;
                    if (index[q] != -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(selFields[i] + mm.getMessage("ds.colNameRepeat"));
                    }
                    index[q] = i;
                    selFields[i] = ds.getFieldName(q);
                }
                this._$13 = index;
                this._$16.setColSelectIndex(index);
                this._$14 = new byte[fcount];
                this._$16.setColTypes(this._$14, null);
            }
            this._$17.seek(this._$16.getCurrentPosition());
            return this._$16;
        }
        catch (Exception e) {
            if (in != null && this._$16 == null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ie) {
                    // empty catch block
                }
            }
            this.close();
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e.getMessage(), e);
        }
    }

    public DataStruct getFileDataStruct() {
        return this._$6;
    }

    protected Sequence get(int n) {
        if (this._$16 != null) {
            return this._$1(n);
        }
        if (this._$19 == null || n < 1) {
            return null;
        }
        Sequence result = new Sequence(n);
        BFileReader reader = this._$19;
        ObjectReader in = this._$17;
        int[] fields = this._$8;
        DataStruct ds = this.dataStruct;
        int bytesIndex = this._$7;
        long lastPos = reader.position();
        try {
            Record rec;
            Object[] values;
            for (int count = 0; count < n && reader.readRecord(fields, values = (rec = new Record(ds)).getFieldValues()); ++count) {
                long pos = reader.position();
                int length = (int)(pos - lastPos);
                byte[] bytes = new byte[length];
                in.read(bytes);
                values[bytesIndex] = bytes;
                result.add(rec);
                lastPos = pos;
            }
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    private Sequence _$1(int n) {
        Sequence result = new Sequence(n);
        LineImporter importer = this._$16;
        ObjectReader in = this._$17;
        int[] selIndex = this._$13;
        DataStruct ds = this.dataStruct;
        int bytesIndex = this._$7;
        long lastPos = importer.getCurrentPosition();
        long fileSize = this._$4;
        try {
            for (int count = 0; count < n; ++count) {
                Record rec = new Record(ds);
                Object[] values = importer.readLine();
                if (values != null) {
                    byte[] bytes;
                    int curLen = values.length;
                    for (int f = 0; f < curLen; ++f) {
                        if (selIndex[f] == -1) continue;
                        rec.setNormalFieldValue(selIndex[f], values[f]);
                    }
                    long pos = importer.getCurrentPosition();
                    int length = (int)(pos - lastPos);
                    if (pos >= fileSize) {
                        bytes = new byte[length - 1];
                        in.read(bytes);
                    } else {
                        bytes = new byte[length - 2];
                        in.read(bytes);
                        in.read();
                        in.read();
                    }
                    rec.setNormalFieldValue(bytesIndex, bytes);
                    result.add(rec);
                    lastPos = pos;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    protected long skipOver(long n) {
        throw new RuntimeException();
    }

    public void close() {
        this._$3 = true;
        super.close();
        try {
            if (this._$16 != null) {
                if (this.ctx != null) {
                    this.ctx.removeResource(this);
                }
                try {
                    this._$16.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this._$16 = null;
            }
            if (this._$17 != null) {
                this._$17.close();
                this._$17 = null;
            }
            if (this._$19 != null) {
                this._$19.close();
                this._$19 = null;
            }
            if (this._$18 != null) {
                this._$18.close();
                this._$18 = null;
            }
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public byte[] getTitleBytes() {
        return this._$5;
    }

    public boolean isClosed() {
        return this._$3;
    }
}

