/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.IMultipath;
import com.scudata.dm.cursor.JoinxCursor;
import com.scudata.dm.cursor.JoinxCursor2;
import com.scudata.dm.cursor.JoinxCursor3;
import com.scudata.dm.cursor.MergeFilterCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.cursor.PJoinCursor;
import com.scudata.dm.op.Operation;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.Cursor;
import com.scudata.expression.Expression;
import com.scudata.parallel.ClusterCursor;
import com.scudata.resources.EngineMessage;
import java.util.ArrayList;

public class CSJoinxCursor3
extends ICursor {
    private ICursor _$13;
    private Expression[] _$12;
    private Expression[] _$11;
    private ICursor _$10;
    private DataStruct _$9 = null;
    private int _$8;
    private int _$7;
    private boolean _$6;
    private int _$5;
    private String[] _$4;
    private String _$3;

    public CSJoinxCursor3(ICursor cursor, Expression[] fields, Object fileTable, Expression[] keys, Expression[] exps, String[] expNames, String fname, Context ctx, int n, String option) {
        this._$13 = cursor;
        this._$12 = keys;
        this._$11 = exps;
        this.ctx = ctx;
        this._$5 = n;
        this._$3 = option;
        this._$4 = expNames;
        if (this._$5 < ICursor.FETCHCOUNT) {
            this._$5 = ICursor.FETCHCOUNT;
        }
        if (exps != null && expNames != null) {
            int len = expNames.length;
            for (int i = 0; i < len; ++i) {
                if (expNames[i] != null || exps[i] == null) continue;
                expNames[i] = exps[i].getFieldName();
            }
        }
        ICursor cursor2 = this._$1(fileTable);
        ICursor[] cursors = new ICursor[]{cursor, cursor2};
        String[] names = new String[]{null, null};
        if (keys == null) {
            String[] pkeys = cursor2.getDataStruct().getPrimary();
            int size = fields.length;
            if (pkeys == null || pkeys.length < size) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("joinx" + mm.getMessage("ds.lessKey"));
            }
            keys = new Expression[size];
            for (int i = 0; i < size; ++i) {
                keys[i] = new Expression(pkeys[i]);
            }
        }
        Expression[][] joinKeys = new Expression[][]{fields, keys};
        this._$10 = CSJoinxCursor3._$1(cursors, names, joinKeys, option, ctx);
    }

    private static ICursor _$1(ICursor[] cursors, String[] names, Expression[][] exps, String opt, Context ctx) {
        boolean isPJoin = false;
        boolean isIsect = false;
        boolean isDiff = false;
        if (opt != null) {
            if (opt.indexOf(112) != -1) {
                isPJoin = true;
            } else if (opt.indexOf(105) != -1) {
                isIsect = true;
            } else if (opt.indexOf(100) != -1) {
                isDiff = true;
            }
        }
        int count = cursors.length;
        boolean isCluster = true;
        boolean isMultipath = false;
        int pathCount = 1;
        for (int i = 0; i < count; ++i) {
            if (cursors[i] instanceof IMultipath) {
                if (i == 0) {
                    isMultipath = true;
                    pathCount = ((IMultipath)((Object)cursors[i])).getPathCount();
                } else if (pathCount != ((IMultipath)((Object)cursors[i])).getPathCount()) {
                    isMultipath = false;
                }
            } else {
                isMultipath = false;
            }
            if (cursors[i] instanceof ClusterCursor) continue;
            isCluster = false;
        }
        if (isCluster) {
            ClusterCursor[] tmp = new ClusterCursor[count];
            System.arraycopy(cursors, 0, tmp, 0, count);
            return ClusterCursor.joinx(tmp, exps, names, opt, ctx);
        }
        if (isMultipath && pathCount > 1) {
            int i;
            ICursor[] result = new ICursor[pathCount];
            ICursor[][] multiCursors = new ICursor[count][];
            for (i = 0; i < count; ++i) {
                IMultipath multipath = (IMultipath)((Object)cursors[i]);
                multiCursors[i] = multipath.getParallelCursors();
            }
            for (i = 0; i < pathCount; ++i) {
                Expression[][] tmpExps;
                int c;
                ICursor[] curs;
                if (isPJoin) {
                    curs = new ICursor[count];
                    for (c = 0; c < count; ++c) {
                        curs[c] = multiCursors[c][i];
                    }
                    result[i] = new PJoinCursor(curs, names);
                    continue;
                }
                if (isIsect || isDiff) {
                    curs = new ICursor[count];
                    for (c = 0; c < count; ++c) {
                        curs[c] = multiCursors[c][i];
                    }
                    Context tmpCtx = ctx.newComputeContext();
                    tmpExps = Operation.dupExpressions(exps, tmpCtx);
                    result[i] = new MergeFilterCursor(curs, tmpExps, opt, tmpCtx);
                    continue;
                }
                if (count == 2 && exps[0].length == 1) {
                    Context tmpCtx = ctx.newComputeContext();
                    Expression exp1 = Operation.dupExpression(exps[0][0], tmpCtx);
                    Expression exp2 = Operation.dupExpression(exps[1][0], tmpCtx);
                    result[i] = new JoinxCursor3(multiCursors[0][i], exp1, multiCursors[1][i], exp2, names, opt, tmpCtx);
                    continue;
                }
                curs = new ICursor[count];
                for (c = 0; c < count; ++c) {
                    curs[c] = multiCursors[c][i];
                }
                Context tmpCtx = ctx.newComputeContext();
                tmpExps = Operation.dupExpressions(exps, tmpCtx);
                result[i] = new JoinxCursor(curs, tmpExps, names, opt, tmpCtx);
            }
            return new MultipathCursors(result, ctx);
        }
        if (isPJoin) {
            return new PJoinCursor(cursors, names);
        }
        if (isIsect || isDiff) {
            return new MergeFilterCursor(cursors, exps, opt, ctx);
        }
        if (count == 2 && exps[0].length == 1) {
            return new JoinxCursor2(cursors[0], exps[0][0], cursors[1], exps[1][0], names, opt, ctx);
        }
        return new JoinxCursor(cursors, exps, names, opt, ctx);
    }

    void _$1() {
        if (this._$3 != null && (this._$3.indexOf(105) != -1 || this._$3.indexOf(100) != -1)) {
            Sequence temp = this._$10.peek(1);
            if (temp != null) {
                BaseRecord r = (BaseRecord)temp.getMem(1);
                this._$9 = r.dataStruct();
                this._$8 = 0;
            }
        } else {
            Sequence temp = this._$10.peek(1);
            if (temp != null) {
                BaseRecord r = (BaseRecord)temp.getMem(1);
                BaseRecord r1 = (BaseRecord)r.getNormalFieldValue(0);
                this._$8 = r1.getFieldCount();
                this._$7 = this._$11 == null ? 0 : this._$11.length;
                String[] names = new String[this._$8 + this._$7];
                System.arraycopy(r1.getFieldNames(), 0, names, 0, this._$8);
                System.arraycopy(this._$4, 0, names, this._$8, this._$7);
                this._$9 = new DataStruct(names);
            }
        }
    }

    private static String[] _$1(Expression[] dataExps, Expression[] newExps, Context ctx) {
        int len = dataExps.length;
        ArrayList<String> keys = new ArrayList<String>(len);
        for (int j = 0; j < len; ++j) {
            keys.add(dataExps[j].toString());
        }
        for (Expression exp : newExps) {
            exp.getUsedFields(ctx, keys);
        }
        String[] arr = new String[keys.size()];
        keys.toArray(arr);
        return arr;
    }

    private ICursor _$1(Object obj) {
        if (obj instanceof ColPhyTable) {
            String[] fields = CSJoinxCursor3._$1(this._$12, this._$11, this.ctx);
            return (Cursor)((ColPhyTable)obj).cursor(null, fields, null, null, null, null, null, this.ctx);
        }
        if (obj instanceof FileObject) {
            return new BFileCursor((FileObject)obj, null, null, null);
        }
        if (obj instanceof ICursor) {
            return (ICursor)obj;
        }
        return null;
    }

    public void resetContext(Context ctx) {
        if (this.ctx != ctx) {
            this._$11 = Operation.dupExpressions(this._$11, ctx);
            super.resetContext(ctx);
        }
    }

    protected Sequence get(int n) {
        Sequence temp;
        if (this._$6 || n < 1) {
            return null;
        }
        if (this._$9 == null) {
            this._$1();
        }
        if ((temp = this._$10.fetch(n)) == null || temp.length() == 0) {
            return null;
        }
        if (this._$8 == 0) {
            return temp;
        }
        Context ctx = this.ctx;
        Expression[] exps = this._$11;
        int len1 = this._$8;
        int len2 = this._$7;
        int len = temp.length();
        Table result = new Table(this._$9);
        for (int i = 1; i <= len; ++i) {
            BaseRecord r = (BaseRecord)temp.getMem(i);
            BaseRecord r1 = (BaseRecord)r.getNormalFieldValue(0);
            Object r2 = r.getNormalFieldValue(1);
            BaseRecord record = result.newLast(r1.getFieldValues());
            for (int f = 0; f < len2; ++f) {
                if (r2 == null) continue;
                if (r2 instanceof BaseRecord) {
                    record.setNormalFieldValue(f + len1, ((BaseRecord)r2).calc(exps[f], ctx));
                    continue;
                }
                if (!(r2 instanceof Sequence)) continue;
                record.setNormalFieldValue(f + len1, ((Sequence)r2).calc(exps[f], ctx));
            }
        }
        return result;
    }

    protected long skipOver(long n) {
        Sequence seq;
        if (this._$6 || n < 1L) {
            return 0L;
        }
        long total = 0L;
        while (n > 0L && (seq = n > (long)FETCHCOUNT ? this.get(FETCHCOUNT) : this.get((int)n)) != null && seq.length() != 0) {
            total += (long)seq.length();
            n -= (long)seq.length();
        }
        return total;
    }

    public synchronized void close() {
        super.close();
        this._$13.close();
        this._$6 = true;
    }

    public boolean reset() {
        super.close();
        this._$13.reset();
        this._$6 = false;
        return true;
    }

    public static ICursor MergeJoinx(ICursor cursor, Expression[][] fields, Object[] fileTable, Expression[][] keys, Expression[][] exps, String[][] expNames, String fname, Context ctx, int n, String option) {
        int i;
        if (fileTable == null) {
            return null;
        }
        option = option.indexOf(105) == -1 ? option + '1' : option.replaceAll("i", "");
        if (cursor instanceof MultipathCursors) {
            return CSJoinxCursor3.MultipathMergeJoinx((MultipathCursors)cursor, fields, fileTable, keys, exps, expNames, fname, ctx, n, option);
        }
        ICursor temp = null;
        FileObject tempFile = null;
        int fileCount = fileTable.length;
        try {
            for (i = 0; i < fileCount - 1; ++i) {
                temp = new CSJoinxCursor3(cursor, fields[i], fileTable[i], keys[i], exps[i], expNames[i], fname, ctx, n, option);
                tempFile = FileObject.createTempFileObject();
                cursor = new BFileCursor(tempFile, null, "x", ctx);
                tempFile.setFileSize(0L);
                Sequence table = temp.fetch(FETCHCOUNT);
                while (table != null && table.length() != 0) {
                    tempFile.exportSeries(table, "ab", null);
                    table = temp.fetch(FETCHCOUNT);
                }
                temp = null;
            }
        }
        catch (Exception e) {
            if (temp != null) {
                temp.close();
            }
            if (tempFile != null && tempFile.isExists()) {
                tempFile.delete();
            }
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e.getMessage(), e);
        }
        i = fileCount - 1;
        return new CSJoinxCursor3(cursor, fields[i], fileTable[i], keys[i], exps[i], expNames[i], fname, ctx, n, option);
    }

    private static MultipathCursors _$1(Object obj, MultipathCursors mcs, String[] fields, Context ctx) {
        if (obj instanceof ColPhyTable) {
            return (MultipathCursors)((ColPhyTable)obj).cursor(null, fields, null, null, null, null, mcs, "k", ctx);
        }
        if (obj instanceof MultipathCursors) {
            return (MultipathCursors)obj;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("joinx" + mm.getMessage("dw.needMCursor"));
    }

    public static ICursor MultipathMergeJoinx(MultipathCursors cursor, Expression[][] fields, Object[] fileTable, Expression[][] keys, Expression[][] exps, String[][] expNames, String fname, Context ctx, int n, String option) {
        ICursor[] cursors = cursor.getParallelCursors();
        int pathCount = cursor.getPathCount();
        ICursor[] results = new ICursor[pathCount];
        String[] names = CSJoinxCursor3._$1(keys[0], exps[0], ctx);
        ICursor[] fileTableCursors = CSJoinxCursor3._$1(fileTable[0], cursor, names, ctx).getParallelCursors();
        if (fileTableCursors == null) {
            for (int i = 0; i < pathCount; ++i) {
                Expression[][] fields_ = Operation.dupExpressions(fields, ctx);
                Expression[][] keys_ = Operation.dupExpressions(keys, ctx);
                Expression[][] exps_ = Operation.dupExpressions(exps, ctx);
                results[i] = CSJoinxCursor3.MergeJoinx(cursors[i], fields_, fileTable, keys_, exps_, expNames, fname, ctx, n, option);
            }
        } else {
            if (fileTable.length != 1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("joinx" + mm.getMessage("function.invalidParam"));
            }
            for (int i = 0; i < pathCount; ++i) {
                Expression[][] fields_ = Operation.dupExpressions(fields, ctx);
                Expression[][] keys_ = Operation.dupExpressions(keys, ctx);
                Expression[][] exps_ = Operation.dupExpressions(exps, ctx);
                results[i] = CSJoinxCursor3.MergeJoinx(cursors[i], fields_, new Object[]{fileTableCursors[i]}, keys_, exps_, expNames, fname, ctx, n, option);
            }
        }
        return new MultipathCursors(results, ctx);
    }
}

