/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.thread.Job;
import com.scudata.thread.ThreadPool;

class CursorReader
extends Job {
    private ThreadPool threadPool;
    private ICursor cursor;
    private int fetchCount;
    private Sequence table;

    public CursorReader(ThreadPool threadPool, ICursor cursor, int fetchCount) {
        this.threadPool = threadPool;
        this.cursor = cursor;
        this.fetchCount = fetchCount;
        threadPool.submit(this);
    }

    public Sequence getTable() {
        this.join();
        if (this.table != null) {
            Sequence table = this.table;
            this.table = null;
            this.threadPool.submit(this);
            return table;
        }
        return null;
    }

    public Sequence getTable(int n) {
        this.join();
        if (this.table != null) {
            Sequence result = this.table;
            this.table = null;
            if (this.fetchCount < n) {
                int diff = n - result.length();
                if (diff > 0) {
                    this.fetchCount = diff;
                    this.threadPool.submit(this);
                    this.join();
                    if (this.table != null) {
                        result = result.append(this.table);
                        this.table = null;
                    }
                }
                this.fetchCount = n;
            }
            this.threadPool.submit(this);
            return result;
        }
        return null;
    }

    public Sequence getCatch() {
        this.join();
        if (this.table != null) {
            Sequence table = this.table;
            this.table = null;
            return table;
        }
        return null;
    }

    @Override
    public void run() {
        this.table = this.fetchCount < 0x7FFFFFFE ? this.cursor.fetch(this.fetchCount) : this.cursor.fetch();
    }
}

