/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.common.DBConfig;
import com.scudata.common.DBInfo;
import com.scudata.common.DBSession;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.SQLTool;
import com.scudata.common.Sentence;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DBObject;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.resources.DataSetMessage;
import com.scudata.util.DatabaseUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class DBCursor
extends ICursor {
    private String _$19;
    private Object[] _$18;
    private byte[] _$17;
    private DBObject _$16;
    private ResultSet _$15 = null;
    private PreparedStatement _$14 = null;
    private Connection _$13 = null;
    private ResultSetMetaData _$12;
    private String _$11 = null;
    private String _$10 = null;
    private boolean _$9 = false;
    private boolean _$8 = true;
    private int _$7 = 0;
    private boolean _$6 = true;
    private boolean _$5 = false;
    private boolean _$4;
    private String _$3;

    public DBCursor(String sql, Object[] params, byte[] types, DBObject db, String opt, Context ctx) {
        this._$19 = sql;
        this._$18 = params;
        this._$17 = types;
        this._$16 = db;
        this.ctx = ctx;
        this._$3 = db.isLower() ? (opt == null ? "l" : opt + "l") : opt;
        this._$1(sql, params, types, db.getDbSession(), opt);
        if (ctx != null) {
            ctx.addResource(this);
        }
    }

    protected long skipOver(long n) {
        if (this._$15 == null || n == 0L) {
            return 0L;
        }
        long count = n;
        try {
            while (n > 0L && (this._$5 || !this._$15.isLast()) && this._$15.next()) {
                --n;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (n > 0L) {
            return count - n;
        }
        return count;
    }

    public synchronized void close() {
        super.close();
        if (this._$16 != null) {
            try {
                if (this.ctx != null) {
                    this.ctx.removeResource(this);
                }
                if (this._$15 != null) {
                    this._$15.close();
                }
                if (this._$14 != null) {
                    this._$14.close();
                }
                if (this._$3 != null && this._$3.indexOf(120) != -1 && this._$16.canClose()) {
                    this._$16.close();
                    this._$16 = null;
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
            finally {
                this._$15 = null;
                this._$14 = null;
                this._$13 = null;
                this._$12 = null;
                this.dataStruct = null;
            }
        }
    }

    protected Sequence get(int n) {
        if (this._$15 == null || n < 1) {
            return null;
        }
        Table table = n > INITSIZE ? new Table(this.dataStruct, INITSIZE) : new Table(this.dataStruct, n);
        try {
            int colCount = this._$12.getColumnCount();
            while (!(n <= 0 || !this._$5 && this._$15.isLast() || !this._$15.next() || !this._$5 && this._$15.isAfterLast())) {
                --n;
                this._$1(table, colCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (table.length() > 0) {
            if (this._$4) {
                return table.fieldValues(0);
            }
            return table;
        }
        return null;
    }

    private void _$1(String sql, Object[] params, byte[] types, DBSession dbs, String opt) {
        try {
            int pos;
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                this._$13 = (Connection)session;
            }
            if (this._$13 == null || this._$13.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", name));
            }
            if (dsConfig != null) {
                this._$11 = dsConfig.getDBCharset();
                this._$9 = dsConfig.getNeedTranSentence();
                this._$8 = dsConfig.getNeedTranContent();
                if ((this._$8 || this._$9) && this._$11 == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", name));
                }
                this._$10 = dsConfig.getClientCharset();
                if ((this._$8 || this._$9) && this._$10 == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", name));
                }
                this._$7 = dsConfig.getDBType();
            } else {
                this._$8 = false;
            }
            if (this._$9) {
                sql = new String(sql.getBytes(), this._$11);
            }
            int paramCount = params == null ? 0 : params.length;
            Object[] args = null;
            byte[] argTypes = null;
            if (paramCount > 0) {
                args = new Object[paramCount];
                argTypes = new byte[paramCount];
                pos = 0;
                for (int paramIndex = 0; paramIndex < paramCount; ++paramIndex) {
                    pos = Sentence.indexOf(sql, "?", pos + 1, 18);
                    args[paramIndex] = params[paramIndex];
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                    if (args[paramIndex] == null) continue;
                    if (args[paramIndex] instanceof Sequence && this._$8) {
                        Sequence l = (Sequence)args[paramIndex];
                        int size = l.length();
                        for (int i = 1; i <= size; ++i) {
                            Object o = l.get(i);
                            if (!(o instanceof String) || !this._$9) continue;
                            o = new String(((String)o).getBytes(), this._$11);
                            l.set(i, o);
                        }
                    } else if (args[paramIndex] instanceof String && this._$9) {
                        args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), this._$11);
                    }
                    if (!(args[paramIndex] instanceof Sequence)) continue;
                    Object[] objs = ((Sequence)args[paramIndex]).toArray();
                    int objCount = objs.length;
                    StringBuffer sb = new StringBuffer(2 * objCount);
                    for (int iObj = 0; iObj < objCount; ++iObj) {
                        sb.append("?,");
                    }
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    if (sb.length() > 1) {
                        sql = sql.substring(0, pos) + sb.toString() + sql.substring(pos + 1);
                    }
                    pos += sb.length();
                }
            }
            try {
                DBInfo info;
                int rsType = 1003;
                if (opt != null && opt.indexOf("z") > -1) {
                    rsType = 1004;
                }
                if (rsType == 1003) {
                    this._$5 = true;
                }
                if (this._$13.getClass().getName().equals("com.microsoft.sqlserver.jdbc.SQLServerConnection")) {
                    Class<?> clss = Class.forName("com.microsoft.sqlserver.jdbc.SQLServerResultSet");
                    Field fld = clss.getField("TYPE_SS_SERVER_CURSOR_FORWARD_ONLY");
                    if (opt != null && opt.indexOf("z") > -1) {
                        fld = clss.getField("TYPE_SS_SCROLL_KEYSET");
                    }
                    rsType = fld.getInt(null);
                }
                if ((info = dbs.getInfo()) != null && info.getDBType() == 15) {
                    Logger.info("Setting POSTGRESQL...");
                    this._$13.setAutoCommit(false);
                    this._$14 = this._$13.prepareStatement(sql, rsType, 1003);
                    this._$14.setFetchSize(1000);
                } else if (info != null && info.getDBType() == 20) {
                    Logger.info("Setting DBONE...");
                    this._$13.setAutoCommit(false);
                    this._$14 = this._$13.prepareStatement(sql, rsType, 1003);
                    this._$14.setFetchSize(1000);
                } else if (info != null && info.getDBType() == 2) {
                    this._$13.setAutoCommit(false);
                    this._$14 = this._$13.prepareStatement(sql, rsType, 1007);
                    this._$14.setFetchSize(1000);
                } else if (info != null && info.getDBType() == 10) {
                    this._$13.setAutoCommit(false);
                    this._$14 = this._$13.prepareStatement(sql);
                    this._$14.setFetchSize(1000);
                } else {
                    this._$14 = this._$13.prepareStatement(sql, rsType, 1007);
                }
            }
            catch (SQLException e) {
                Logger.debug(e.getMessage());
                String name2 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name2 = info.getName();
                }
                throw new RQException(mm.getMessage("error.sqlException", name2, sql), e);
            }
            if (args != null && args.length > 0) {
                pos = 0;
                for (int iArg = 0; iArg < args.length; ++iArg) {
                    ++pos;
                    try {
                        byte type = argTypes[iArg];
                        if (args[iArg] != null && args[iArg] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[iArg]).toArray();
                            for (int iObj = 0; iObj < objs.length; ++iObj) {
                                SQLTool.setObject(this._$7, this._$14, pos, objs[iObj], type);
                                ++pos;
                            }
                            --pos;
                            continue;
                        }
                        SQLTool.setObject(this._$7, this._$14, pos, args[iArg], type);
                        continue;
                    }
                    catch (Exception e) {
                        String name3 = "";
                        DBInfo info = dbs.getInfo();
                        if (info != null) {
                            name3 = info.getName();
                        }
                        throw new RQException(mm.getMessage("error.argIndex", name3, Integer.toString(iArg + 1)));
                    }
                }
            }
            try {
                this._$15 = this._$14.executeQuery();
            }
            catch (SQLException e) {
                Logger.debug(e.getMessage());
                String name4 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name4 = info.getName();
                }
                throw new RQException(mm.getMessage("error.sqlException", name4, sql));
            }
            boolean cleanFieldName = opt != null && opt.indexOf("c") > -1;
            DataStruct ds = this._$1(this._$15, this._$16.isLower(), cleanFieldName);
            if (opt != null && opt.indexOf("t") > -1) {
                int i;
                String[] fields = null;
                int colCount = this._$12.getColumnCount();
                String tableName = this._$12.getTableName(1);
                if (sql.indexOf(" as ") < 0) {
                    fields = new String[colCount];
                    String[][] tableCols = new String[colCount][];
                    for (int c = 1; c <= colCount; ++c) {
                        fields[c - 1] = this._$12.getColumnLabel(c);
                        String[] tCol = new String[]{this._$12.getColumnLabel(c)};
                        tableCols[c - 1] = tCol;
                    }
                } else {
                    String selCols = sql.substring(sql.indexOf("select") + 6, sql.indexOf("from")).trim();
                    String[] cols = selCols.split(",");
                    if (cols != null && cols.length > 0) {
                        int length = cols.length;
                        String[][] tableCols = new String[length][];
                        fields = new String[length];
                        for (i = 0; i < length; ++i) {
                            String col = cols[i];
                            if (col.indexOf(" as ") < 0) {
                                fields[i] = col;
                                String[] tCol = new String[]{col};
                                tableCols[i] = tCol;
                                continue;
                            }
                            String[] sets = col.split(" ");
                            fields[i] = sets[sets.length - 1];
                            String[] tCol = new String[]{sets[0]};
                            tableCols[i] = tCol;
                        }
                    }
                }
                if (opt != null && opt.indexOf("u") > -1) {
                    DatabaseMetaData dmd = this._$13.getMetaData();
                    this._$15 = dmd.getPrimaryKeys(this._$13.getCatalog(), null, tableName);
                    int count = 0;
                    ArrayList<String> nameList = new ArrayList<String>();
                    while (this._$15.next()) {
                        String keyName = this._$15.getString("COLUMN_NAME");
                        if (keyName == null || keyName.trim().length() <= 0) continue;
                        nameList.add(keyName);
                        ++count;
                    }
                    if (count > 0) {
                        String[] pks = new String[count];
                        for (i = 0; i < count; ++i) {
                            pks[i] = (String)nameList.get(i);
                        }
                        ds.setPrimary(pks);
                    }
                }
            }
            if (opt != null && opt.indexOf(105) != -1 && ds.getFieldCount() == 1) {
                this._$4 = true;
            }
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    private DataStruct _$1(ResultSet rs, boolean lowercase, boolean cleanFieldName) throws SQLException, UnsupportedEncodingException {
        if (rs == null) {
            return null;
        }
        this._$12 = rs.getMetaData();
        int colCount = this._$12.getColumnCount();
        int[] colTypes = new int[colCount];
        String[] colNames = new String[colCount];
        if (cleanFieldName) {
            int c;
            ArrayList<String> oldcns = new ArrayList<String>(colCount);
            ArrayList<String> cns = new ArrayList<String>(colCount);
            for (c = 1; c <= colCount; ++c) {
                String cn = null;
                cn = lowercase ? this._$12.getColumnLabel(c).toLowerCase() : this._$12.getColumnLabel(c);
                colTypes[c - 1] = this._$12.getColumnType(c);
                DatabaseUtil.cleanFieldName(cn, oldcns, cns, this._$12.getTableName(c));
            }
            for (c = 0; c < colCount; ++c) {
                String colName;
                colNames[c] = colName = (String)cns.get(c);
            }
        } else {
            for (int c = 1; c <= colCount; ++c) {
                colNames[c - 1] = lowercase ? this._$12.getColumnLabel(c).toLowerCase() : this._$12.getColumnLabel(c);
                colTypes[c - 1] = this._$12.getColumnType(c);
            }
        }
        if (this._$8 && (this._$10 == null || this._$10.trim().length() == 0)) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.toCharset"));
        }
        if (this._$10 != null) {
            this._$6 = this._$10.equalsIgnoreCase(this._$11) || this._$11 == null;
        }
        DataStruct ds = new DataStruct(colNames);
        this.setDataStruct(ds);
        return ds;
    }

    private void _$1(Table table, int colCount) throws SQLException, UnsupportedEncodingException {
        BaseRecord record = table.newLast();
        for (int n = 1; n <= colCount; ++n) {
            int type = 0;
            if (this._$7 == 1) {
                type = this._$12.getColumnType(n);
            }
            try {
                Object obj = DatabaseUtil.tranData(type, this._$7, this._$15, n, this._$8, this._$11, this._$10, this._$6, this._$3);
                record.set(n - 1, obj);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean reset() {
        this.close();
        if (this._$16 != null) {
            this._$1(this._$19, this._$18, this._$17, this._$16.getDbSession(), this._$3);
            if (this.ctx != null) {
                this.ctx.addResource(this);
            }
            return true;
        }
        return false;
    }
}

