/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.DataStruct;
import com.scudata.dm.ILineInput;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.util.Variant;
import java.io.IOException;

public class LineInputCursor
extends ICursor {
    private ILineInput _$6;
    private DataStruct _$5;
    private boolean _$4 = false;
    private boolean _$3 = false;

    public LineInputCursor(ILineInput lineInput, String opt) {
        this._$6 = lineInput;
        if (opt != null) {
            if (opt.indexOf(116) != -1) {
                this._$4 = true;
            }
            if (opt.indexOf(105) != -1) {
                this._$3 = true;
            }
        }
    }

    private Sequence _$1(ILineInput importer, int n) throws IOException {
        int initSize;
        int curLen;
        int fcount;
        Object[] line = importer.readLine();
        if (line == null) {
            return null;
        }
        if (this._$5 == null) {
            fcount = line.length;
            String[] fieldNames = new String[fcount];
            if (this._$4) {
                for (int f = 0; f < fcount; ++f) {
                    fieldNames[f] = Variant.toString(line[f]);
                }
                line = importer.readLine();
                if (line == null) {
                    return null;
                }
            }
            this._$5 = new DataStruct(fieldNames);
            this.setDataStruct(this._$5);
        } else {
            fcount = this._$5.getFieldCount();
        }
        if (this._$3 && fcount != 1) {
            this._$3 = false;
        }
        if ((curLen = line.length) > fcount) {
            curLen = fcount;
        }
        int n2 = initSize = n > INITSIZE ? INITSIZE : n;
        if (this._$3) {
            Sequence seq = new Sequence(initSize);
            seq.add(line[0]);
            for (int i = 1; i < n && (line = importer.readLine()) != null; ++i) {
                seq.add(line[0]);
            }
            return seq;
        }
        Table table = new Table(this._$5, initSize);
        BaseRecord r = table.newLast();
        for (int f = 0; f < curLen; ++f) {
            r.setNormalFieldValue(f, line[f]);
        }
        for (int i = 1; i < n && (line = importer.readLine()) != null; ++i) {
            r = table.newLast();
            curLen = line.length;
            if (curLen > fcount) {
                curLen = fcount;
            }
            for (int f = 0; f < curLen; ++f) {
                r.setNormalFieldValue(f, line[f]);
            }
        }
        return table;
    }

    protected Sequence get(int n) {
        if (n < 1 || this._$6 == null) {
            return null;
        }
        try {
            return this._$1(this._$6, n);
        }
        catch (IOException e) {
            this.close();
            throw new RQException(e.getMessage(), e);
        }
    }

    protected long skipOver(long n) {
        ILineInput importer = this._$6;
        if (n < 1L || importer == null) {
            return 0L;
        }
        try {
            if (this._$5 == null && this._$4) {
                Object[] line = importer.readLine();
                if (line == null) {
                    return 0L;
                }
                int fcount = line.length;
                String[] fieldNames = new String[fcount];
                for (int f = 0; f < fcount; ++f) {
                    fieldNames[f] = Variant.toString(line[f]);
                }
                this._$5 = new DataStruct(fieldNames);
            }
            int i = 0;
            while ((long)i < n) {
                if (!importer.skipLine()) {
                    return i;
                }
                ++i;
            }
        }
        catch (IOException e) {
            this.close();
            throw new RQException(e.getMessage(), e);
        }
        return n;
    }

    public synchronized void close() {
        super.close();
        if (this._$6 != null) {
            try {
                this._$6.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._$6 = null;
            this._$5 = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

