/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.GroupsSyncReader;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.IMultipath;
import com.scudata.dm.cursor.SyncCursor;
import com.scudata.dm.cursor.lIllIllIllIllIlI;
import com.scudata.dm.cursor.llllIllIIlIIllII;
import com.scudata.dm.op.Channel;
import com.scudata.dm.op.IGroupsResult;
import com.scudata.dm.op.IHugeGroupsResult;
import com.scudata.dm.op.IPipe;
import com.scudata.dm.op.MultipathChannel;
import com.scudata.dm.op.Operable;
import com.scudata.dm.op.Operation;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.GroupsJob;
import com.scudata.thread.GroupsJob2;
import com.scudata.thread.ThreadPool;
import com.scudata.util.CursorUtil;
import com.scudata.util.HashUtil;

public class MultipathCursors
extends ICursor
implements IMultipath {
    private ICursor[] _$6;
    private Sequence _$5;
    private llllIllIIlIIllII[] _$4;
    private boolean _$3 = false;

    public MultipathCursors(ICursor[] cursors, Context ctx) {
        this.setDataStruct(cursors[0].getDataStruct());
        if (this._$1(cursors)) {
            int len = cursors.length;
            for (int i = 0; i < len; ++i) {
                cursors[i] = new SyncCursor(cursors[i]);
                cursors[i].resetContext(ctx.newComputeContext());
            }
        } else {
            for (ICursor cursor : cursors) {
                cursor.resetContext(ctx.newComputeContext());
            }
        }
        this._$6 = cursors;
    }

    public MultipathCursors(ICursor[] cursors) {
        this._$6 = cursors;
        this.setDataStruct(cursors[0].getDataStruct());
    }

    public ICursor[] getCursors() {
        return this._$6;
    }

    public ICursor getPathCursor(int p) {
        return this._$6[p];
    }

    public int getPathCount() {
        return this._$6.length;
    }

    private boolean _$1(ICursor[] cursors) {
        int len = cursors.length;
        for (int i = 0; i < len; ++i) {
            ICursor cursor = cursors[i];
            for (int j = i + 1; j < len; ++j) {
                if (cursor != cursors[j]) continue;
                return true;
            }
        }
        return false;
    }

    public Operable addOperation(Operation op, Context ctx) {
        for (ICursor cursor : this._$6) {
            ctx = cursor.getContext();
            Operation dup = op.duplicate(ctx);
            cursor.addOperation(dup, ctx);
        }
        return this;
    }

    public ICursor[] getParallelCursors() {
        if (this._$4 != null) {
            int len = this._$6.length;
            for (int i = 0; i < len; ++i) {
                Sequence seq = this._$4[i].getCatch();
                if (this.cache != null) {
                    this.cache.addAll(seq);
                    seq = this.cache;
                    this.cache = null;
                }
                if (this._$6[i].cache == null) {
                    this._$6[i].cache = seq;
                    continue;
                }
                this._$6[i].cache.addAll(seq);
            }
            this._$4 = null;
        }
        return this._$6;
    }

    private Sequence _$1() {
        if (this._$5 != null) {
            return this._$5;
        }
        llllIllIIlIIllII[] readers = this._$4;
        int tcount = readers.length;
        for (int i = 0; i < tcount; ++i) {
            if (readers[i] == null) continue;
            Sequence cur = readers[i].getTable();
            if (cur != null) {
                if (this._$5 == null) {
                    this._$5 = cur;
                    continue;
                }
                this._$5 = MultipathCursors.append(this._$5, cur);
                continue;
            }
            readers[i] = null;
        }
        return this._$5;
    }

    protected Sequence get(int n) {
        Sequence result;
        if (this._$3 || n < 1) {
            return null;
        }
        if (this._$4 == null) {
            int avg;
            ICursor[] cursors = this._$6;
            int tcount = cursors.length;
            llllIllIIlIIllII[] readers = new llllIllIIlIIllII[tcount];
            this._$4 = readers;
            ThreadPool threadPool = ThreadPool.instance();
            if (n == 0x7FFFFFFE) {
                avg = n;
            } else {
                avg = n / tcount;
                if (avg < FETCHCOUNT) {
                    avg = FETCHCOUNT;
                } else if (n % tcount != 0) {
                    ++avg;
                }
            }
            for (int i = 0; i < tcount; ++i) {
                readers[i] = new llllIllIIlIIllII(threadPool, cursors[i], avg);
            }
        }
        if ((result = this._$1()) == null) {
            return null;
        }
        int len = result.length();
        if (len > n) {
            return result.split(1, n);
        }
        if (len == n) {
            this._$5 = null;
            return result;
        }
        this._$5 = null;
        Sequence cur;
        while ((cur = this._$1()) != null && cur.length() != 0) {
            int curLen = cur.length();
            if (len + curLen > n) {
                return MultipathCursors.append(result, cur.split(1, n - len));
            }
            if (len + curLen == n) {
                this._$5 = null;
                return MultipathCursors.append(result, cur);
            }
            this._$5 = null;
            result = MultipathCursors.append(result, cur);
            len += curLen;
        }
        return result;
    }

    protected long skipOver(long n) {
        Sequence result;
        if (this._$3 || n < 1L) {
            return 0L;
        }
        if (this._$4 == null) {
            if (n == Long.MAX_VALUE) {
                ICursor[] cursors = this._$6;
                int tcount = cursors.length;
                lIllIllIllIllIlI[] skipper = new lIllIllIllIllIlI[tcount];
                ThreadPool threadPool = ThreadPool.instance();
                for (int i = 0; i < tcount; ++i) {
                    skipper[i] = new lIllIllIllIllIlI(threadPool, cursors[i], Long.MAX_VALUE);
                }
                long total = 0L;
                for (int i = 0; i < tcount; ++i) {
                    total += skipper[i].getActualSkipCount();
                }
                return total;
            }
            ICursor[] cursors = this._$6;
            int tcount = cursors.length;
            llllIllIIlIIllII[] readers = new llllIllIIlIIllII[tcount];
            this._$4 = readers;
            ThreadPool threadPool = ThreadPool.instance();
            for (int i = 0; i < tcount; ++i) {
                readers[i] = new llllIllIIlIIllII(threadPool, cursors[i], FETCHCOUNT);
            }
        }
        if ((result = this._$1()) == null) {
            return 0L;
        }
        long len = result.length();
        if (len > n) {
            result.split(1, (int)n);
            return n;
        }
        if (len == n) {
            this._$5 = null;
            return n;
        }
        this._$5 = null;
        Sequence cur;
        while ((cur = this._$1()) != null && cur.length() != 0) {
            int curLen = cur.length();
            if (len + (long)curLen > n) {
                cur.split(1, (int)(n - len));
                return n;
            }
            if (len + (long)curLen == n) {
                this._$5 = null;
                return n;
            }
            this._$5 = null;
            len += (long)curLen;
        }
        return len;
    }

    public synchronized void close() {
        super.close();
        if (this._$6 != null) {
            int count = this._$6.length;
            for (int i = 0; i < count; ++i) {
                this._$6[i].close();
            }
            this._$5 = null;
            this._$4 = null;
            this._$3 = true;
        }
    }

    public boolean reset() {
        this.close();
        int count = this._$6.length;
        for (int i = 0; i < count; ++i) {
            if (this._$6[i].reset()) continue;
            return false;
        }
        this._$3 = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Table _$2(ICursor[] cursors, Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx, int groupCount) {
        int cursorCount = cursors.length;
        ThreadPool pool = ThreadPool.newInstance(cursorCount);
        GroupsJob[] jobs = new GroupsJob[cursorCount];
        IGroupsResult groupsResult = null;
        IGroupsResult[] groupsResults = new IGroupsResult[cursorCount - 1];
        try {
            int i;
            for (i = 0; i < cursorCount; ++i) {
                Context tmpCtx = ctx.newComputeContext();
                Expression[] tmpExps = Operation.dupExpressions(exps, tmpCtx);
                Expression[] tmpCalcExps = Operation.dupExpressions(calcExps, tmpCtx);
                jobs[i] = new GroupsJob(cursors[i], tmpExps, names, tmpCalcExps, calcNames, opt, tmpCtx);
                if (groupCount > 1) {
                    jobs[i].setGroupCount(groupCount);
                }
                pool.submit(jobs[i]);
            }
            for (i = 0; i < cursorCount; ++i) {
                jobs[i].join();
                if (i == 0) {
                    groupsResult = jobs[i].getGroupsResult();
                    continue;
                }
                groupsResults[i - 1] = jobs[i].getGroupsResult();
            }
        }
        finally {
            pool.shutdown();
        }
        return groupsResult.combineGroupsResult(groupsResults, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Table _$1(ICursor[] cursors, Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx, int groupCount) {
        int capacity = groupCount > 0 ? groupCount : 30000000;
        HashUtil hashUtil = new HashUtil(capacity);
        GroupsSyncReader cursorReader = new GroupsSyncReader(cursors, exps, hashUtil, ctx);
        capacity = hashUtil.getCapacity();
        int cursorCount = cursors.length / 2;
        if (cursorCount < 2) {
            cursorCount = 2;
        }
        ThreadPool pool = ThreadPool.newInstance(cursorCount);
        GroupsJob2[] jobs = new GroupsJob2[cursorCount];
        Table groupsResult = null;
        try {
            int i;
            for (i = 0; i < cursorCount; ++i) {
                Context tmpCtx = ctx.newComputeContext();
                Expression[] tmpExps = Operation.dupExpressions(exps, tmpCtx);
                Expression[] tmpCalcExps = Operation.dupExpressions(calcExps, tmpCtx);
                GroupsJob2 job = new GroupsJob2(cursorReader, tmpExps, names, tmpCalcExps, calcNames, opt, tmpCtx, capacity);
                job.setHashStart(i);
                job.setHashEnd(cursorCount);
                jobs[i] = job;
                pool.submit(jobs[i]);
            }
            for (i = 0; i < cursorCount; ++i) {
                jobs[i].join();
                if (i == 0) {
                    groupsResult = jobs[i].getGroupsResult().getResultTable();
                    continue;
                }
                Table t = jobs[i].getGroupsResult().getResultTable();
                groupsResult.addAll(t);
            }
        }
        finally {
            pool.shutdown();
        }
        if (opt == null || opt.indexOf(117) == -1) {
            int keyCount = exps.length;
            int[] fields = new int[keyCount];
            for (int i = 0; i < keyCount; ++i) {
                fields[i] = i;
            }
            groupsResult.sortFields(fields);
        }
        return groupsResult;
    }

    public IGroupsResult getGroupsResult(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx) {
        return this._$6[0].getGroupsResult(exps, names, calcExps, calcNames, opt, ctx);
    }

    public IHugeGroupsResult getHugeGroupsResult(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, int capacity, Context ctx) {
        return this._$6[0].getHugeGroupsResult(exps, names, calcExps, calcNames, opt, capacity, ctx);
    }

    public Table groups(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx) {
        if (this._$6.length == 1) {
            return this._$6[0].groups(exps, names, calcExps, calcNames, opt, ctx);
        }
        if (opt != null && opt.indexOf(115) != -1) {
            IHugeGroupsResult groupsResult = this._$6[0].getHugeGroupsResult(exps, names, calcExps, calcNames, opt, 0, ctx);
            return groupsResult.groups(this._$6);
        }
        return MultipathCursors._$2(this._$6, exps, names, calcExps, calcNames, opt, ctx, -1);
    }

    public Table groups(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx, int groupCount) {
        if (this._$6.length == 1) {
            return this._$6[0].groups(exps, names, calcExps, calcNames, opt, ctx, groupCount);
        }
        if (opt != null && opt.indexOf(115) != -1) {
            IHugeGroupsResult groupsResult = this._$6[0].getHugeGroupsResult(exps, names, calcExps, calcNames, opt, groupCount, ctx);
            return groupsResult.groups(this._$6);
        }
        if (opt != null && opt.indexOf(122) != -1) {
            return MultipathCursors._$1(this._$6, exps, names, calcExps, calcNames, opt, ctx, groupCount);
        }
        if (groupCount < 1 || exps == null || exps.length == 0) {
            return MultipathCursors._$2(this._$6, exps, names, calcExps, calcNames, opt, ctx, -1);
        }
        if (opt != null && opt.indexOf(110) != -1) {
            return MultipathCursors._$2(this._$6, exps, names, calcExps, calcNames, opt, ctx, groupCount);
        }
        return CursorUtil.fuzzyGroups(this, exps, names, calcExps, calcNames, opt, ctx, groupCount);
    }

    public Operable mergeJoinx(Function function, Expression[][] exps, ICursor[] codeCursors, Expression[][] codeExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        int pathCount = this._$6.length;
        int tableCount = codeCursors.length;
        for (int p = 0; p < pathCount; ++p) {
            ICursor[] curCodeCursors = new ICursor[tableCount];
            for (int t = 0; t < tableCount; ++t) {
                if (codeCursors[t] == null) continue;
                if (!(codeCursors[t] instanceof MultipathCursors)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("dw.mcsNotMatch"));
                }
                MultipathCursors mcs = (MultipathCursors)codeCursors[t];
                if (mcs.getPathCount() != pathCount) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("dw.mcsNotMatch"));
                }
                curCodeCursors[t] = mcs.getPathCursor(p);
            }
            ctx = this._$6[p].getContext();
            Expression[][] curExps = Operation.dupExpressions(exps, ctx);
            Expression[][] curCodeExps = Operation.dupExpressions(codeExps, ctx);
            Expression[][] curNewExps = Operation.dupExpressions(newExps, ctx);
            this._$6[p] = (ICursor)this._$6[p].mergeJoinx(function, curExps, curCodeCursors, curCodeExps, curNewExps, newNames, opt, ctx);
        }
        return this;
    }

    public Operable join(Function function, String fname, Expression[][] exps, Sequence[] codes, Expression[][] dataExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression[][] curExps = Operation.dupExpressions(exps, ctx);
            Expression[][] curDataExps = Operation.dupExpressions(dataExps, ctx);
            Expression[][] curNewExps = Operation.dupExpressions(newExps, ctx);
            subCursor.join(function, fname, curExps, codes, curDataExps, curNewExps, newNames, opt, ctx);
        }
        return this;
    }

    public Operable joinRemote(Function function, String fname, Expression[][] exps, Object[] codes, Expression[][] dataExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression[][] curExps = Operation.dupExpressions(exps, ctx);
            Expression[][] curDataExps = Operation.dupExpressions(dataExps, ctx);
            Expression[][] curNewExps = Operation.dupExpressions(newExps, ctx);
            subCursor.joinRemote(function, fname, curExps, codes, curDataExps, curNewExps, newNames, opt, ctx);
        }
        return this;
    }

    public Operable fjoin(Function function, Expression[] dimExps, String[] aliasNames, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression[] curDimExps = Operation.dupExpressions(dimExps, ctx);
            Expression[][] curNewExps = Operation.dupExpressions(newExps, ctx);
            subCursor.fjoin(function, curDimExps, aliasNames, curNewExps, newNames, opt, ctx);
        }
        return this;
    }

    public Operable pjoin(Function function, Expression[] srcKeyExps, Expression[] srcNewExps, String[] srcNewNames, ICursor[] joinCursors, String[] options, Expression[][] keyExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        int pathCount = this._$6.length;
        int tableCount = joinCursors.length;
        for (int p = 0; p < pathCount; ++p) {
            ICursor[] curCursors = new ICursor[tableCount];
            for (int t = 0; t < tableCount; ++t) {
                if (joinCursors[t] == null) continue;
                if (!(joinCursors[t] instanceof MultipathCursors)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("dw.mcsNotMatch"));
                }
                MultipathCursors mcs = (MultipathCursors)joinCursors[t];
                if (mcs.getPathCount() != pathCount) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("dw.mcsNotMatch"));
                }
                curCursors[t] = mcs.getPathCursor(p);
            }
            ctx = this._$6[p].getContext();
            Expression[] curSrcKeyExps = Operation.dupExpressions(srcKeyExps, ctx);
            Expression[] curSrcNewExps = Operation.dupExpressions(srcNewExps, ctx);
            Expression[][] curKeyExps = Operation.dupExpressions(keyExps, ctx);
            Expression[][] curNewExps = Operation.dupExpressions(newExps, ctx);
            this._$6[p].pjoin(function, curSrcKeyExps, curSrcNewExps, srcNewNames, curCursors, options, curKeyExps, curNewExps, newNames, opt, ctx);
        }
        return this;
    }

    public Operable filterJoin(Function function, Expression[][] exps, Sequence[] codes, Expression[][] dataExps, String opt, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression[][] curExps = Operation.dupExpressions(exps, ctx);
            Expression[][] curDataExps = Operation.dupExpressions(dataExps, ctx);
            subCursor.filterJoin(function, curExps, codes, curDataExps, opt, ctx);
        }
        return this;
    }

    public Operable diffJoin(Function function, Expression[][] exps, Sequence[] codes, Expression[][] dataExps, String opt, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression[][] curExps = Operation.dupExpressions(exps, ctx);
            Expression[][] curDataExps = Operation.dupExpressions(dataExps, ctx);
            subCursor.diffJoin(function, curExps, codes, curDataExps, opt, ctx);
        }
        return this;
    }

    public Operable select(Function function, Expression fltExp, String opt, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression curFilter = Operation.dupExpression(fltExp, ctx);
            subCursor.select(function, curFilter, opt, ctx);
        }
        return this;
    }

    public Operable select(Function function, Expression fltExp, String opt, IPipe pipe, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression curFilter = Operation.dupExpression(fltExp, ctx);
            subCursor.select(function, curFilter, opt, pipe, ctx);
        }
        return this;
    }

    public Operable derive(Function function, Expression[] exps, String[] names, String opt, int level, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression[] curExps = Operation.dupExpressions(exps, ctx);
            subCursor.derive(function, curExps, names, opt, level, ctx);
        }
        return this;
    }

    public Operable newTable(Function function, Expression[] newExps, String[] names, String opt, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression[] curExps = Operation.dupExpressions(newExps, ctx);
            subCursor.newTable(function, curExps, names, opt, ctx);
        }
        return this;
    }

    public Operable group(Function function, Expression[] exps, String opt, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression[] curExps = Operation.dupExpressions(exps, ctx);
            subCursor.group(function, curExps, opt, ctx);
        }
        return this;
    }

    public Operable group(Function function, Expression[] exps, Expression[] sortExps, String opt, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression[] curExps = Operation.dupExpressions(exps, ctx);
            Expression[] curSortExps = Operation.dupExpressions(sortExps, ctx);
            subCursor.group(function, curExps, curSortExps, opt, ctx);
        }
        return this;
    }

    public Operable group(Function function, Expression[] exps, String[] names, Expression[] newExps, String[] newNames, String opt, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression[] curExps = Operation.dupExpressions(exps, ctx);
            Expression[] curNewExps = Operation.dupExpressions(newExps, ctx);
            subCursor.group(function, curExps, names, curNewExps, newNames, opt, ctx);
        }
        return this;
    }

    public Operable group(Function function, Expression[] exps, String[] names, Expression[] sortExps, String[] sortNames, Expression[] newExps, String[] newNames, String opt, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression[] curExps = Operation.dupExpressions(exps, ctx);
            Expression[] curSortExps = Operation.dupExpressions(sortExps, ctx);
            Expression[] curNewExps = Operation.dupExpressions(newExps, ctx);
            subCursor.group(function, curExps, names, curSortExps, sortNames, curNewExps, newNames, opt, ctx);
        }
        return this;
    }

    public Operable switchFk(Function function, String[] fkNames, String[] timeFkNames, Sequence[] codes, Expression[] exps, Expression[] timeExps, String opt, Context ctx) {
        for (ICursor subCursor : this._$6) {
            ctx = subCursor.getContext();
            Expression[] curexps = Operation.dupExpressions(exps, ctx);
            Expression[] curTimeExps = Operation.dupExpressions(timeExps, ctx);
            subCursor.switchFk(function, fkNames, timeFkNames, codes, curexps, curTimeExps, opt, ctx);
        }
        return this;
    }

    public Channel newChannel(Context ctx, boolean doPush) {
        return new MultipathChannel(ctx, this, doPush);
    }

    public boolean canSkipBlock() {
        if (this._$6 != null) {
            for (ICursor subCursor : this._$6) {
                if (subCursor.canSkipBlock()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public IArray[] getSkipBlockInfo(String key) {
        int count = this._$6.length;
        IArray[] result = new ObjectArray[]{new ObjectArray(count)};
        for (int i = 0; i < count; ++i) {
            IArray[] obj = this._$6[i].getSkipBlockInfo(key);
            ((ObjectArray)result[0]).add(obj);
        }
        return result;
    }

    public void setSkipBlockInfo(String key, IArray[] values) {
        if (key == null || values == null) {
            return;
        }
        ObjectArray valueArray = (ObjectArray)values[0];
        int count = this._$6.length;
        for (int i = 0; i < count; ++i) {
            IArray[] val = (IArray[])valueArray.get(i + 1);
            this._$6[i].setSkipBlockInfo(key, val);
        }
    }
}

