/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.op;

import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.op.CsJoinxResult;
import com.scudata.dm.op.FetchResult;
import com.scudata.dm.op.GroupxResult;
import com.scudata.dm.op.IDResult;
import com.scudata.dm.op.IGroupsResult;
import com.scudata.dm.op.IPipe;
import com.scudata.dm.op.IResult;
import com.scudata.dm.op.IterateResult;
import com.scudata.dm.op.New;
import com.scudata.dm.op.Operable;
import com.scudata.dm.op.Operation;
import com.scudata.dm.op.Push;
import com.scudata.dm.op.SortxResult;
import com.scudata.dm.op.TotalResult;
import com.scudata.expression.Expression;
import java.util.ArrayList;

public class Channel
extends Operable
implements IPipe {
    protected Context ctx;
    private ArrayList<Operation> _$1;
    protected IResult result;
    protected New resultNew;
    protected int pkCount;

    public Channel(Context ctx) {
        this.ctx = ctx;
    }

    public Channel(Context ctx, ICursor cs) {
        this.ctx = ctx;
        Push push = new Push(this);
        cs.addOperation(push, ctx);
    }

    public void addPushToCursor(ICursor cs) {
        Push push = new Push(this);
        cs.addOperation(push, this.ctx);
    }

    public Operable addOperation(Operation op, Context ctx) {
        this.checkResultChannel();
        this.ctx = ctx;
        if (this._$1 == null) {
            this._$1 = new ArrayList();
        }
        this._$1.add(op);
        return this;
    }

    protected void checkResultChannel() {
        if (this.result != null) {
            throw new RQException("\u9644\u52a0\u7ed3\u679c\u96c6\u4e4b\u540e\u4e0d\u80fd\u518d\u7ee7\u7eed\u9644\u52a0\u5176\u5b83\u8fd0\u7b97");
        }
    }

    public synchronized void push(Sequence seq, Context ctx) {
        if (this._$1 != null) {
            for (Operation op : this._$1) {
                if (seq == null || seq.length() == 0) {
                    return;
                }
                seq = op.process(seq, ctx);
            }
        }
        if (this.result != null && seq != null) {
            this.result.push(seq, ctx);
        }
    }

    public void finish(Context ctx) {
        if (this._$1 == null) {
            if (this.result != null) {
                this.result.finish(ctx);
            }
        } else {
            Sequence seq = null;
            for (Operation op : this._$1) {
                if (seq == null) {
                    seq = op.finish(ctx);
                    continue;
                }
                seq = op.process(seq, ctx);
                Sequence tmp = op.finish(ctx);
                if (tmp == null) continue;
                if (seq != null) {
                    seq = ICursor.append(seq, tmp);
                    continue;
                }
                seq = tmp;
            }
            if (this.result != null) {
                if (seq != null) {
                    this.result.push(seq, ctx);
                }
                this.result.finish(ctx);
            }
        }
    }

    public Object result() {
        if (this.result == null) {
            return null;
        }
        Object val = this.result.result();
        this.result = null;
        if (this.resultNew == null) {
            return val;
        }
        if (val instanceof Sequence) {
            Sequence table = this.resultNew.process((Sequence)val, this.ctx);
            if (this.pkCount > 0 && table instanceof Table) {
                String[] pks = new String[this.pkCount];
                for (int i = 1; i <= this.pkCount; ++i) {
                    pks[i - 1] = "#" + i;
                }
                ((Table)table).setPrimary(pks);
                return table;
            }
            return table;
        }
        return val;
    }

    public Channel fetch() {
        this.checkResultChannel();
        this.result = new FetchResult();
        return this;
    }

    public Channel fetch(FileObject file) {
        this.checkResultChannel();
        this.result = new FetchResult(file);
        return this;
    }

    public Channel groups(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt) {
        this.checkResultChannel();
        this.result = IGroupsResult.instance(exps, names, calcExps, calcNames, null, opt, this.ctx);
        return this;
    }

    public Channel total(Expression[] calcExps) {
        this.groups(null, null, calcExps, null, null);
        this.result = new TotalResult(calcExps, this.ctx, (IGroupsResult)this.result);
        return this;
    }

    public Channel groupx(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, int capacity) {
        this.checkResultChannel();
        this.result = new GroupxResult(exps, names, calcExps, calcNames, opt, this.ctx, capacity);
        return this;
    }

    public Channel sortx(Expression[] exps, int capacity, String opt) {
        this.checkResultChannel();
        this.result = new SortxResult(exps, this.ctx, capacity, opt);
        return this;
    }

    public Channel joinx(Expression[][] fields, Object[] fileTable, Expression[][] keys, Expression[][] exps, String[][] expNames, String fname, Context ctx, String option, int capacity) {
        this.checkResultChannel();
        this.result = new CsJoinxResult(fields, fileTable, keys, exps, expNames, fname, ctx, option, capacity);
        return this;
    }

    public Channel iterate(Expression exp, Object initVal, Expression c, Context ctx) {
        this.checkResultChannel();
        this.result = new IterateResult(exp, initVal, c, ctx);
        return this;
    }

    public Channel id(Expression[] exps, int count, String opt) {
        this.checkResultChannel();
        this.result = new IDResult(exps, count, opt, this.ctx);
        return this;
    }

    public IResult getResult() {
        return this.result;
    }

    public void setResultNew(New op, int pkCount) {
        this.resultNew = op;
        this.pkCount = pkCount;
    }

    public Context getContext() {
        return this.ctx;
    }
}

