/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.op;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.op.Channel;
import com.scudata.dm.op.FilePipe;
import com.scudata.dm.op.IPipe;
import com.scudata.dm.op.Operation;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;

public class Groupn
extends Operation {
    private Expression _$3;
    private IPipe[] _$2;
    private Sequence[] _$1;

    public Groupn(Expression exp, Sequence result) {
        this(null, exp, result);
    }

    private Groupn(Function function, Expression exp, IPipe[] pipes) {
        super(function);
        this._$3 = exp;
        this._$2 = pipes;
        int count = pipes.length;
        this._$1 = new Sequence[count];
        for (int i = 1; i < count; ++i) {
            this._$1[i] = new Sequence(ICursor.FETCHCOUNT);
        }
    }

    public Groupn(Function function, Expression exp, Sequence out) {
        super(function);
        Object obj;
        int i;
        this._$3 = exp;
        int count = out.length();
        if (count == 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("groupn" + mm.getMessage("function.invalidParam"));
        }
        this._$2 = new IPipe[count + 1];
        if (out.getMem(1) instanceof Channel) {
            for (i = 1; i <= count; ++i) {
                obj = out.getMem(i);
                if (!(obj instanceof Channel)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("groupn" + mm.getMessage("function.paramTypeError"));
                }
                this._$2[i] = (Channel)obj;
            }
        } else {
            for (i = 1; i <= count; ++i) {
                obj = out.getMem(i);
                if (obj instanceof String) {
                    FileObject fo = new FileObject((String)obj);
                    this._$2[i] = new FilePipe(fo);
                    continue;
                }
                if (obj instanceof FileObject) {
                    this._$2[i] = new FilePipe((FileObject)obj);
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("groupn" + mm.getMessage("function.paramTypeError"));
            }
        }
        this._$1 = new Sequence[count + 1];
        for (i = 1; i <= count; ++i) {
            this._$1[i] = new Sequence(ICursor.FETCHCOUNT);
        }
    }

    public Operation duplicate(Context ctx) {
        Expression dupExp = Groupn.dupExpression(this._$3, ctx);
        return new Groupn(this.function, dupExp, this._$2);
    }

    public Sequence finish(Context ctx) {
        int len = this._$2.length;
        for (int i = 1; i < len; ++i) {
            this._$2[i].finish(ctx);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1(Sequence table, Expression exp, Context ctx, Sequence[] groups) {
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(table);
        stack.push(current);
        int gcount = groups.length;
        try {
            int len = table.length();
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                Object obj = exp.calculate(ctx);
                if (!(obj instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("groupn: " + mm.getMessage("engine.needIntExp"));
                }
                int index = ((Number)obj).intValue();
                if (index < 1 || index > gcount) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(index + mm.getMessage("engine.indexOutofBound"));
                }
                groups[index].add(table.getMem(i));
            }
        }
        finally {
            stack.pop();
        }
    }

    public Sequence process(Sequence seq, Context ctx) {
        Sequence[] groups = this._$1;
        Groupn._$1(seq, this._$3, ctx, groups);
        IPipe[] pipes = this._$2;
        int count = pipes.length;
        for (int i = 1; i < count; ++i) {
            pipes[i].push(groups[i], ctx);
            groups[i].clear();
        }
        return seq;
    }
}

