/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.op;

import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.op.Derive;
import com.scudata.dm.op.DiffJoin;
import com.scudata.dm.op.FilterJoin;
import com.scudata.dm.op.ForeignJoin;
import com.scudata.dm.op.Group;
import com.scudata.dm.op.Groups;
import com.scudata.dm.op.IPipe;
import com.scudata.dm.op.Join;
import com.scudata.dm.op.JoinRemote;
import com.scudata.dm.op.New;
import com.scudata.dm.op.Operation;
import com.scudata.dm.op.PrimaryJoin;
import com.scudata.dm.op.Select;
import com.scudata.dm.op.Switch;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;

public abstract class Operable {
    public abstract Operable addOperation(Operation var1, Context var2);

    public Operable select(Function function, Expression fltExp, String opt, Context ctx) {
        Select op = new Select(function, fltExp, opt);
        return this.addOperation(op, ctx);
    }

    public Operable select(Function function, Expression fltExp, String opt, IPipe pipe, Context ctx) {
        Select op = new Select(function, fltExp, opt, pipe);
        return this.addOperation(op, ctx);
    }

    public Operable filterJoin(Function function, Expression[][] exps, Sequence[] codes, Expression[][] dataExps, String opt, Context ctx) {
        FilterJoin op = new FilterJoin(function, exps, codes, dataExps, opt);
        return this.addOperation(op, ctx);
    }

    public Operable diffJoin(Function function, Expression[][] exps, Sequence[] codes, Expression[][] dataExps, String opt, Context ctx) {
        DiffJoin op = new DiffJoin(function, exps, codes, dataExps, opt);
        return this.addOperation(op, ctx);
    }

    public Operable join(Function function, String fname, Expression[][] exps, Sequence[] codes, Expression[][] dataExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        Join op = new Join(function, fname, exps, codes, dataExps, newExps, newNames, opt);
        return this.addOperation(op, ctx);
    }

    public Operable joinRemote(Function function, String fname, Expression[][] exps, Object[] codes, Expression[][] dataExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        JoinRemote op = new JoinRemote(function, fname, exps, codes, dataExps, newExps, newNames, opt);
        return this.addOperation(op, ctx);
    }

    public Operable fjoin(Function function, Expression[] dimExps, String[] aliasNames, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        ForeignJoin op = new ForeignJoin(function, dimExps, aliasNames, newExps, newNames, opt);
        return this.addOperation(op, ctx);
    }

    public Operable pjoin(Function function, Expression[] srcKeyExps, Expression[] srcNewExps, String[] srcNewNames, ICursor[] cursors, String[] options, Expression[][] keyExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        if (this instanceof ICursor) {
            ICursor cs = (ICursor)this;
            cs.setSkipBlock(srcKeyExps, cursors, options, keyExps, newExps, opt);
        }
        PrimaryJoin op = new PrimaryJoin(function, srcKeyExps, srcNewExps, srcNewNames, cursors, options, keyExps, newExps, newNames, opt, ctx);
        return this.addOperation(op, ctx);
    }

    public Operable mergeJoinx(Function function, Expression[][] exps, ICursor[] cursors, Expression[][] codeExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        throw new RuntimeException();
    }

    public Operable derive(Function function, Expression[] exps, String[] names, String opt, int level, Context ctx) {
        Derive op = new Derive(function, exps, names, opt, level);
        return this.addOperation(op, ctx);
    }

    public Operable newTable(Function function, Expression[] newExps, String[] names, String opt, Context ctx) {
        New op = new New(function, newExps, names, opt);
        return this.addOperation(op, ctx);
    }

    public Operable group(Function function, Expression[] exps, String opt, Context ctx) {
        Group op = new Group(function, exps, opt);
        return this.addOperation(op, ctx);
    }

    public Operable group(Function function, Expression[] exps, Expression[] sortExps, String opt, Context ctx) {
        Group op = new Group(function, exps, sortExps, opt);
        return this.addOperation(op, ctx);
    }

    public Operable group(Function function, Expression[] exps, String[] names, Expression[] newExps, String[] newNames, String opt, Context ctx) {
        Groups op = new Groups(function, exps, names, newExps, newNames, opt, ctx);
        return this.addOperation(op, ctx);
    }

    public Operable group(Function function, Expression[] exps, String[] names, Expression[] sortExps, String[] sortNames, Expression[] newExps, String[] newNames, String opt, Context ctx) {
        Groups op = new Groups(function, exps, names, sortExps, sortNames, newExps, newNames, opt, ctx);
        return this.addOperation(op, ctx);
    }

    public Operable switchFk(Function function, String[] fkNames, String[] timeFkNames, Sequence[] codes, Expression[] exps, Expression[] timeExps, String opt, Context ctx) {
        Switch op = new Switch(function, fkNames, timeFkNames, codes, exps, timeExps, opt);
        return this.addOperation(op, ctx);
    }
}

