/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.op;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;

public abstract class Operation {
    protected Function function;
    protected INormalCell currentCell;

    public Operation() {
    }

    public Operation(Function function) {
        ICellSet cs;
        this.function = function;
        ICellSet iCellSet = cs = function == null ? null : function.getCellSet();
        if (cs != null) {
            this.currentCell = cs.getCurrent();
        }
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public abstract Sequence process(Sequence var1, Context var2);

    public boolean isDecrease() {
        return false;
    }

    public Sequence finish(Context ctx) {
        return null;
    }

    public abstract Operation duplicate(Context var1);

    public static Expression dupExpression(Expression exp, Context ctx) {
        if (exp != null) {
            return exp.newExpression(ctx);
        }
        return null;
    }

    public static Expression[] dupExpressions(Expression[] exps, Context ctx) {
        if (exps == null) {
            return null;
        }
        int len = exps.length;
        Expression[] dupExps = new Expression[len];
        for (int i = 0; i < len; ++i) {
            if (exps[i] == null) continue;
            dupExps[i] = exps[i].newExpression(ctx);
        }
        return dupExps;
    }

    public static Expression[][] dupExpressions(Expression[][] exps, Context ctx) {
        if (exps == null) {
            return null;
        }
        int len = exps.length;
        Expression[][] dupExps = new Expression[len][];
        for (int i = 0; i < len; ++i) {
            dupExps[i] = Operation.dupExpressions(exps[i], ctx);
        }
        return dupExps;
    }

    public INormalCell getCurrentCell() {
        return this.currentCell;
    }

    public void setCurrentCell(INormalCell currentCell) {
        this.currentCell = currentCell;
    }
}

