/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.op;

import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.expression.Expression;
import com.scudata.expression.Gather;
import com.scudata.expression.Node;
import com.scudata.util.Variant;

class PrimaryJoinItem {
    private Context ctx;
    private ICursor cursor;
    private Expression[] keyExps;
    private Expression[] newExps;
    private Node[] gathers = null;
    private int joinType;
    private Current current;
    private Sequence data;
    private Object[] keyValues;
    private Object[] cacheKeyValues;
    private int keyCount = 0;
    private int newCount = 0;
    private int seq;
    private boolean isGather = false;
    private boolean isPrevMatch = false;

    public PrimaryJoinItem(ICursor cursor, Expression[] keyExps, Expression[] newExps, int joinType, Context ctx) {
        this.ctx = new Context(ctx);
        this.cursor = cursor;
        this.keyExps = keyExps;
        this.newExps = newExps;
        this.joinType = joinType;
        if (newExps != null) {
            this.newCount = newExps.length;
            Expression[] expressionArray = newExps;
            int n = newExps.length;
            int n2 = 0;
            while (n2 < n) {
                Expression exp = expressionArray[n2];
                if (exp.getHome() instanceof Gather) {
                    this.gathers = Sequence.prepareGatherMethods(newExps, ctx);
                    this.isGather = true;
                    break;
                }
                ++n2;
            }
        }
        this.keyCount = keyExps.length;
        this.keyValues = new Object[this.keyCount];
        this.cacheKeyValues = new Object[this.keyCount];
    }

    public void cacheData() {
        this.data = this.cursor.fuzzyFetch(ICursor.FETCHCOUNT);
        if (this.data != null && this.data.length() > 0) {
            ComputeStack stack = this.ctx.getComputeStack();
            if (this.current != null) {
                stack.pop();
            }
            this.current = new Current(this.data, 1);
            stack.push(this.current);
            this.seq = 1;
            int i = 0;
            while (i < this.keyCount) {
                this.keyValues[i] = this.keyExps[i].calculate(this.ctx);
                ++i;
            }
        } else {
            this.seq = -1;
        }
    }

    public Object[] getCurrentKeyValues() {
        if (this.seq > 0) {
            return this.keyValues;
        }
        return null;
    }

    private void calcNewValues(Object[] srcKeyValues, Object[] resultValues, int fieldIndex) {
        int newCount = this.newCount;
        if (newCount == 0) {
            return;
        }
        Context ctx = this.ctx;
        Node[] gathers = this.gathers;
        if (this.isGather) {
            int i;
            this.isPrevMatch = false;
            int i2 = 0;
            while (i2 < newCount) {
                resultValues[fieldIndex + i2] = gathers[i2].gather(ctx);
                ++i2;
            }
            Expression[] keyExps = this.keyExps;
            Object[] keyValues = this.keyValues;
            int keyCount = this.keyCount;
            block1: while (true) {
                ++this.seq;
                if (this.seq > this.data.length()) {
                    this.cacheData();
                    if (this.seq == -1) {
                        break;
                    }
                } else {
                    this.current.setCurrent(this.seq);
                    i = 0;
                    while (i < keyCount) {
                        keyValues[i] = keyExps[i].calculate(ctx);
                        ++i;
                    }
                }
                if (Variant.compareArrays(srcKeyValues, keyValues, keyCount) != 0) break;
                i = 0;
                while (true) {
                    if (i >= newCount) continue block1;
                    resultValues[fieldIndex + i] = gathers[i].gather(resultValues[fieldIndex + i], ctx);
                    ++i;
                }
                break;
            }
            i = 0;
            while (i < newCount) {
                resultValues[fieldIndex + i] = gathers[i].finish(resultValues[fieldIndex + i]);
                ++i;
            }
        } else {
            Expression[] newExps = this.newExps;
            int i = 0;
            while (i < newCount) {
                resultValues[fieldIndex + i] = newExps[i].calculate(ctx);
                ++i;
            }
        }
    }

    public void resetNewValues(Object[] resultValues, int fieldIndex) {
        int i = 0;
        int count = this.newCount;
        while (i < count) {
            resultValues[fieldIndex++] = null;
            ++i;
        }
    }

    public void popTop(Object[] resultValues, int fieldIndex) {
        int newCount = this.newCount;
        Context ctx = this.ctx;
        Node[] gathers = this.gathers;
        if (this.isGather) {
            int i;
            int i2 = 0;
            while (i2 < newCount) {
                resultValues[fieldIndex + i2] = gathers[i2].gather(ctx);
                ++i2;
            }
            Expression[] keyExps = this.keyExps;
            Object[] keyValues = this.keyValues;
            Object[] prevKeyValues = this.cacheKeyValues;
            int keyCount = this.keyCount;
            System.arraycopy(keyValues, 0, prevKeyValues, 0, keyCount);
            block1: while (true) {
                ++this.seq;
                if (this.seq > this.data.length()) {
                    this.cacheData();
                    if (this.seq == -1) {
                        break;
                    }
                } else {
                    this.current.setCurrent(this.seq);
                    i = 0;
                    while (i < keyCount) {
                        keyValues[i] = keyExps[i].calculate(ctx);
                        ++i;
                    }
                }
                if (Variant.compareArrays(prevKeyValues, keyValues, keyCount) != 0) break;
                i = 0;
                while (true) {
                    if (i >= newCount) continue block1;
                    resultValues[fieldIndex + i] = gathers[i].gather(resultValues[fieldIndex + i], ctx);
                    ++i;
                }
                break;
            }
            i = 0;
            while (i < newCount) {
                resultValues[fieldIndex + i] = gathers[i].finish(resultValues[fieldIndex + i]);
                ++i;
            }
        } else {
            Expression[] newExps = this.newExps;
            int i = 0;
            while (i < newCount) {
                resultValues[fieldIndex + i] = newExps[i].calculate(ctx);
                ++i;
            }
            ++this.seq;
            if (this.seq > this.data.length()) {
                this.cacheData();
            } else {
                this.current.setCurrent(this.seq);
                i = 0;
                while (i < this.keyCount) {
                    this.keyValues[i] = this.keyExps[i].calculate(ctx);
                    ++i;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean join(Object[] srcKeyValues, Object[] resultValues, int fieldIndex) {
        if (this.seq == -1) {
            return this.joinType != 0;
        }
        keyExps = this.keyExps;
        keyValues = this.keyValues;
        keyCount = this.keyCount;
        if (this.isPrevMatch) {
            this.isPrevMatch = false;
            ++this.seq;
            if (this.seq > this.data.length()) {
                this.cacheData();
                if (this.seq == -1) {
                    this.resetNewValues(resultValues, fieldIndex);
                    return this.joinType != 0;
                }
            } else {
                this.current.setCurrent(this.seq);
                i = 0;
                while (i < keyCount) {
                    keyValues[i] = keyExps[i].calculate(this.ctx);
                    ++i;
                }
            }
        }
        block1: while (true) {
            if ((cmp = Variant.compareArrays(srcKeyValues, keyValues, keyCount)) == 0) {
                this.isPrevMatch = true;
                if (this.joinType == 2) {
                    this.resetNewValues(resultValues, fieldIndex);
                    return false;
                }
                this.calcNewValues(srcKeyValues, resultValues, fieldIndex);
                return true;
            }
            if (cmp <= 0) break;
            ++this.seq;
            if (this.seq > this.data.length()) {
                this.cacheData();
                if (this.seq != -1) continue;
                this.resetNewValues(resultValues, fieldIndex);
                return this.joinType != 0;
            }
            this.current.setCurrent(this.seq);
            i = 0;
            while (true) {
                if (i < keyCount) ** break;
                continue block1;
                keyValues[i] = keyExps[i].calculate(this.ctx);
                ++i;
            }
            break;
        }
        this.resetNewValues(resultValues, fieldIndex);
        return this.joinType != 0;
    }

    /*
     * Unable to fully structure code
     */
    public boolean timeKeyJoin(Object[] srcKeyValues, Object[] resultValues, int fieldIndex) {
        block18: {
            if (this.seq == -1) {
                this.resetNewValues(resultValues, fieldIndex);
                return this.joinType != 0;
            }
            keyCount = this.keyCount;
            timeIndex = keyCount - 1;
            keyExps = this.keyExps;
            keyValues = this.keyValues;
            block0: while (true) {
                if ((cmp = Variant.compareArrays(srcKeyValues, keyValues, timeIndex)) < 0) {
                    this.resetNewValues(resultValues, fieldIndex);
                    return this.joinType != 0;
                }
                if (cmp <= 0) break;
                ++this.seq;
                if (this.seq > this.data.length()) {
                    this.cacheData();
                    if (this.seq != -1) continue;
                    this.resetNewValues(resultValues, fieldIndex);
                    return this.joinType != 0;
                }
                this.current.setCurrent(this.seq);
                i = 0;
                while (true) {
                    if (i < keyCount) ** break;
                    continue block0;
                    keyValues[i] = keyExps[i].calculate(this.ctx);
                    ++i;
                }
                break;
            }
            cmp = Variant.compare(srcKeyValues[timeIndex], keyValues[timeIndex], true);
            if (cmp < 0) {
                this.resetNewValues(resultValues, fieldIndex);
                return this.joinType != 0;
            }
            if (cmp == 0) {
                if (this.joinType == 2) {
                    this.resetNewValues(resultValues, fieldIndex);
                    return false;
                }
                this.calcNewValues(srcKeyValues, resultValues, fieldIndex);
                return true;
            }
            do {
                len = this.data.length();
                q = this.seq + 1;
                while (q <= len) {
                    this.current.setCurrent(q);
                    i = 0;
                    while (i < timeIndex) {
                        if (!Variant.isEquals(keyValues[i], keyExps[i].calculate(this.ctx))) {
                            this.seq = q - 1;
                            this.current.setCurrent(this.seq);
                            break block18;
                        }
                        ++i;
                    }
                    time = keyExps[timeIndex].calculate(this.ctx);
                    cmp = Variant.compare(srcKeyValues[timeIndex], time, true);
                    if (cmp < 0) {
                        this.seq = q - 1;
                        this.current.setCurrent(this.seq);
                        break block18;
                    }
                    if (cmp == 0) {
                        this.seq = q;
                        keyValues[timeIndex] = time;
                        break block18;
                    }
                    keyValues[timeIndex] = time;
                    ++q;
                }
                prevData = this.data;
                prevSeq = len;
                System.arraycopy(keyValues, 0, this.cacheKeyValues, 0, keyCount);
                this.cacheData();
                if (this.seq == -1) {
                    this.data = prevData;
                    this.seq = prevSeq;
                    System.arraycopy(this.cacheKeyValues, 0, keyValues, 0, keyCount);
                } else {
                    cmp = Variant.compareArrays(srcKeyValues, keyValues, keyCount);
                    if (cmp >= 0) continue;
                    this.data.insert(1, prevData.getMem(prevSeq));
                    System.arraycopy(this.cacheKeyValues, 0, keyValues, 0, keyCount);
                }
                break block18;
            } while (cmp != 0);
            if (this.joinType == 2) {
                this.resetNewValues(resultValues, fieldIndex);
                return false;
            }
            this.calcNewValues(srcKeyValues, resultValues, fieldIndex);
            return true;
        }
        if (this.joinType == 2) {
            this.resetNewValues(resultValues, fieldIndex);
            return false;
        }
        this.calcNewValues(srcKeyValues, resultValues, fieldIndex);
        return true;
    }
}

