/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.op;

import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.Sequence;
import com.scudata.dm.op.IPipe;
import com.scudata.dm.op.Operation;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.util.Variant;

public class Select
extends Operation {
    protected Expression fltExp;
    protected String opt;
    protected IPipe pipe;
    protected boolean isContinuous;
    protected boolean isFound;
    protected boolean isOrg;

    public Select(Expression fltExp, String opt) {
        this(null, fltExp, opt, null);
    }

    public Select(Function function, Expression fltExp, String opt) {
        this(function, fltExp, opt, null);
    }

    public Select(Function function, Expression fltExp, String opt, IPipe pipe) {
        super(function);
        this.fltExp = fltExp;
        this.opt = opt;
        this.pipe = pipe;
        if (opt != null) {
            this.isContinuous = opt.indexOf(99) != -1;
            this.isOrg = opt.indexOf(111) != -1;
        }
    }

    public boolean canCombineCalc() {
        return this.pipe == null && !this.isContinuous;
    }

    public Expression getFilterExpression() {
        return this.fltExp;
    }

    public void setFltExp(Expression fltExp) {
        this.fltExp = fltExp;
    }

    public boolean isDecrease() {
        return true;
    }

    public Operation duplicate(Context ctx) {
        Expression dupExp = Select.dupExpression(this.fltExp, ctx);
        return new Select(this.function, dupExp, this.opt, this.pipe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence process(Sequence seq, Context ctx) {
        Sequence result;
        block18: {
            Expression exp = this.fltExp;
            int len = seq.length();
            result = new Sequence();
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(seq);
            stack.push(current);
            try {
                if (this.isContinuous) {
                    Object obj;
                    int i;
                    if (this.isFound) {
                        for (int i2 = 1; i2 <= len; ++i2) {
                            current.setCurrent(i2);
                            Object obj2 = exp.calculate(ctx);
                            if (Variant.isTrue(obj2)) {
                                result.add(current.getCurrent());
                                continue;
                            }
                            break block18;
                        }
                        break block18;
                    }
                    for (i = 1; i <= len; ++i) {
                        current.setCurrent(i);
                        obj = exp.calculate(ctx);
                        if (!Variant.isTrue(obj)) continue;
                        this.isFound = true;
                        result.add(current.getCurrent());
                        break;
                    }
                    ++i;
                    while (i <= len) {
                        current.setCurrent(i);
                        obj = exp.calculate(ctx);
                        if (Variant.isTrue(obj)) {
                            result.add(current.getCurrent());
                            ++i;
                            continue;
                        }
                        break block18;
                    }
                    break block18;
                }
                if (this.pipe == null) {
                    for (int i = 1; i <= len; ++i) {
                        current.setCurrent(i);
                        Object obj = exp.calculate(ctx);
                        if (!Variant.isTrue(obj)) continue;
                        result.add(current.getCurrent());
                    }
                } else {
                    Sequence other = new Sequence();
                    for (int i = 1; i <= len; ++i) {
                        current.setCurrent(i);
                        Object obj = exp.calculate(ctx);
                        if (Variant.isTrue(obj)) {
                            result.add(current.getCurrent());
                            continue;
                        }
                        other.add(current.getCurrent());
                    }
                    if (other.length() != 0) {
                        this.pipe.push(other, ctx);
                    }
                }
            }
            finally {
                stack.pop();
            }
        }
        if (this.isOrg) {
            seq.setMems(result.getMems());
            return seq;
        }
        if (result.length() != 0) {
            return result;
        }
        return null;
    }

    public Sequence finish(Context ctx) {
        if (this.pipe != null) {
            this.pipe.finish(ctx);
        }
        return null;
    }

    public boolean hasPipe() {
        return this.pipe != null;
    }
}

