/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query;

import com.scudata.dm.query.QueryBody;
import com.scudata.dm.query.Select;
import java.util.List;

class And {
    private Select.Exp exp;
    private List<Select.FieldNode> fieldList;

    public And(Select.Exp exp, List<Select.FieldNode> fieldList) {
        this.exp = exp;
        this.fieldList = fieldList;
    }

    public boolean containTable(QueryBody table) {
        if (this.fieldList != null) {
            for (Select.FieldNode field : this.fieldList) {
                if (field.getTable() != table) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSingleTable(QueryBody table) {
        if (this.fieldList == null || this.fieldList.size() == 0) {
            return false;
        }
        for (Select.FieldNode field : this.fieldList) {
            if (field.getTable() == table) continue;
            return false;
        }
        return true;
    }

    public boolean isTable(QueryBody leftTable, QueryBody rightTable) {
        if (this.fieldList != null) {
            for (Select.FieldNode field : this.fieldList) {
                QueryBody table = field.getTable();
                if (table == leftTable || table == rightTable) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTable(List<QueryBody> tableList, int lastTable) {
        if (this.fieldList != null) {
            for (Select.FieldNode field : this.fieldList) {
                QueryBody table = field.getTable();
                int index = tableList.indexOf(table);
                if (index >= 0 && index <= lastTable) continue;
                return false;
            }
        }
        return true;
    }

    public Select.Exp getExp() {
        return this.exp;
    }
}

