/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query;

import com.scudata.cellset.ICellSet;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.query.And;
import com.scudata.dm.query.QueryBody;
import com.scudata.dm.query.Relation;
import com.scudata.dm.query.Select;
import com.scudata.dm.query.lIIlIIlIIlllllll;
import com.scudata.expression.Expression;
import java.util.ArrayList;
import java.util.List;

class Join
extends Relation {
    private String option = null;
    private Select.Exp on;

    public Join(Select select) {
        this.select = select;
    }

    public Join(Select select, String option) {
        this.select = select;
        this.option = option;
    }

    public Select.Exp getOn() {
        return this.on;
    }

    public void setOn(Select.Exp on) {
        this.on = on;
    }

    @Override
    public DataStruct getDataStruct() {
        throw new RuntimeException();
    }

    @Override
    public void getAllJoinTables(ArrayList<QueryBody> tableList) {
        this.left.getAllJoinTables(tableList);
        tableList.add(this.right);
    }

    @Override
    public void setJoinFieldName(String fieldName) {
        this.left.setJoinFieldName(fieldName);
        this.right.setJoinFieldName(fieldName);
    }

    private String[] createJoinFieldNames(ArrayList<QueryBody> tableList) {
        int count = tableList.size();
        String[] names = new String[count];
        String name = "join" + this.hashCode();
        int i = 0;
        while (i < count) {
            names[i] = String.valueOf(name) + "_" + (i + 1);
            ++i;
        }
        return names;
    }

    private Object xjoin(ArrayList<QueryBody> tableList) {
        String[] names = this.createJoinFieldNames(tableList);
        int count = tableList.size();
        Sequence[] datas = new Sequence[count];
        int i = 0;
        while (i < count) {
            Object data = tableList.get(i).getData();
            if (data instanceof Sequence) {
                datas[i] = (Sequence)data;
            } else if (data instanceof ICursor) {
                datas[i] = ((ICursor)data).fetch();
            }
            ++i;
        }
        i = 0;
        while (i < count) {
            tableList.get(i).setJoinFieldName(names[i]);
            ++i;
        }
        Context ctx = this.select.getContext();
        return Sequence.xjoin(datas, null, null, names, null, ctx);
    }

    private Object xjoin(ArrayList<QueryBody> tableList, Select.Exp where) {
        Table result;
        Expression exp;
        List<lIIlIIlIIlllllll> andList = where.splitAnd();
        int tableCount = tableList.size();
        QueryBody leftTable = tableList.get(0);
        QueryBody rightTable = tableList.get(1);
        Object leftData = leftTable.getData();
        Object rightData = rightTable.getData();
        String leftFilter = null;
        String rightFilter = null;
        boolean isJoin = true;
        ArrayList<Expression> leftExpList = new ArrayList<Expression>();
        ArrayList<Expression> rightExpList = new ArrayList<Expression>();
        String xjoinFilter = null;
        int i = andList.size() - 1;
        while (i >= 0) {
            String spl;
            And and = (And)((Object)andList.get(i));
            if (and.isSingleTable(rightTable)) {
                andList.remove(i);
                spl = and.getExp().toSPL();
                rightFilter = rightFilter == null ? spl : String.valueOf(spl) + "&&" + rightFilter;
            } else if (and.isSingleTable(leftTable)) {
                andList.remove(i);
                spl = and.getExp().toSPL();
                leftFilter = leftFilter == null ? spl : String.valueOf(spl) + "&&" + leftFilter;
            } else if (and.isTable(leftTable, rightTable)) {
                boolean b;
                andList.remove(i);
                Select.Exp exp2 = and.getExp();
                String spl2 = exp2.toSPL();
                xjoinFilter = xjoinFilter == null ? spl2 : String.valueOf(spl2) + "&&" + xjoinFilter;
                if (isJoin && !(b = exp2.splitJionExp(leftTable, rightTable, leftExpList, rightExpList))) {
                    isJoin = false;
                }
            }
            --i;
        }
        Context ctx = this.select.getContext();
        ICellSet cellSet = this.select.getCellSet();
        Sequence leftSeq = null;
        Sequence rightSeq = null;
        if (leftData instanceof Sequence) {
            leftSeq = (Sequence)leftData;
            if (leftFilter != null) {
                Expression exp3 = new Expression(cellSet, ctx, leftFilter);
                leftSeq = (Sequence)leftSeq.select(exp3, null, ctx);
            }
        } else if (leftData instanceof ICursor) {
            ICursor cs = (ICursor)leftData;
            if (leftFilter != null) {
                exp = new Expression(cellSet, ctx, leftFilter);
                cs.select(null, exp, null, ctx);
            }
            leftSeq = cs.fetch();
        }
        if (rightData instanceof Sequence) {
            rightSeq = (Sequence)rightData;
            if (rightFilter != null) {
                Expression exp4 = new Expression(cellSet, ctx, rightFilter);
                rightSeq = (Sequence)rightSeq.select(exp4, null, ctx);
            }
        } else if (rightData instanceof ICursor) {
            ICursor cs = (ICursor)rightData;
            if (rightFilter != null) {
                exp = new Expression(cellSet, ctx, rightFilter);
                cs.select(null, exp, null, ctx);
            }
            rightSeq = cs.fetch();
        }
        String[] allNames = this.createJoinFieldNames(tableList);
        Sequence[] sequences = new Sequence[]{leftSeq, rightSeq};
        String[] names = new String[]{allNames[0], allNames[1]};
        if (isJoin) {
            int fcount = leftExpList.size();
            Expression[] exps1 = new Expression[fcount];
            Expression[] exps2 = new Expression[fcount];
            leftExpList.toArray(exps1);
            rightExpList.toArray(exps2);
            Expression[][] totalExps = new Expression[][]{exps1, exps2};
            result = Sequence.join(sequences, totalExps, names, null, ctx);
        } else {
            Expression[] exps = new Expression[2];
            if (xjoinFilter != null) {
                exps[1] = new Expression(cellSet, ctx, xjoinFilter);
            }
            result = Sequence.xjoin(sequences, exps, null, names, null, ctx);
        }
        leftTable.setJoinFieldName(allNames[0]);
        rightTable.setJoinFieldName(allNames[1]);
        int t = 2;
        while (t < tableCount) {
            rightFilter = null;
            isJoin = true;
            leftExpList.clear();
            rightExpList.clear();
            xjoinFilter = null;
            rightTable = tableList.get(t);
            int i2 = andList.size() - 1;
            while (i2 >= 0) {
                And and = (And)((Object)andList.get(i2));
                if (and.isSingleTable(rightTable)) {
                    andList.remove(i2);
                    String spl = and.getExp().toSPL();
                    rightFilter = rightFilter == null ? spl : String.valueOf(spl) + "&&" + rightFilter;
                } else if (and.isTable(tableList, t)) {
                    boolean b;
                    andList.remove(i2);
                    Select.Exp exp5 = and.getExp();
                    String spl = exp5.toSPL();
                    xjoinFilter = xjoinFilter == null ? spl : String.valueOf(spl) + "&&" + xjoinFilter;
                    if (isJoin && !(b = exp5.splitJionExp(tableList, t, leftExpList, rightExpList))) {
                        isJoin = false;
                    }
                }
                --i2;
            }
            rightData = rightTable.getData();
            if (rightData instanceof Sequence) {
                rightSeq = (Sequence)rightData;
                if (rightFilter != null) {
                    Expression exp6 = new Expression(cellSet, ctx, rightFilter);
                    rightSeq = (Sequence)rightSeq.select(exp6, null, ctx);
                }
            } else if (rightData instanceof ICursor) {
                ICursor cs = (ICursor)rightData;
                if (rightFilter != null) {
                    Expression exp7 = new Expression(cellSet, ctx, rightFilter);
                    cs.select(null, exp7, null, ctx);
                }
                rightSeq = cs.fetch();
            }
            sequences[0] = result;
            sequences[1] = rightSeq;
            names[0] = "_1";
            names[1] = allNames[t];
            if (isJoin) {
                int fcount = leftExpList.size();
                Expression[] exps1 = new Expression[fcount];
                Expression[] exps2 = new Expression[fcount];
                leftExpList.toArray(exps1);
                rightExpList.toArray(exps2);
                Expression[][] totalExps = new Expression[][]{exps1, exps2};
                result = Sequence.join(sequences, totalExps, names, null, ctx);
            } else {
                Expression[] exps = new Expression[2];
                if (xjoinFilter != null) {
                    exps[1] = new Expression(cellSet, ctx, xjoinFilter);
                }
                result = Sequence.xjoin(sequences, exps, null, names, null, ctx);
            }
            rightTable.setJoinFieldName(allNames[t]);
            int curTableCount = t + 1;
            Expression[] newExps = new Expression[curTableCount];
            String[] newNames = new String[curTableCount];
            System.arraycopy(allNames, 0, newNames, 0, curTableCount);
            int i3 = 0;
            while (i3 < t) {
                newExps[i3] = new Expression(cellSet, ctx, "#1.#" + (i3 + 1));
                ++i3;
            }
            newExps[t] = new Expression(cellSet, ctx, "#2");
            result = result.newTable(newNames, newExps, ctx);
            ++t;
        }
        return result;
    }

    @Override
    public Object getData(Select.Exp where) {
        Table result;
        Expression exp;
        ArrayList<QueryBody> tableList = new ArrayList<QueryBody>();
        this.getAllJoinTables(tableList);
        if (this.on == null) {
            if (where == null) {
                return this.xjoin(tableList);
            }
            return this.xjoin(tableList, where);
        }
        Object leftData = this.left.getData();
        Object rightData = this.right.getData();
        int lastTable = tableList.size() - 1;
        List<lIIlIIlIIlllllll> andList = this.on.splitAnd();
        String leftFilter = null;
        String rightFilter = null;
        boolean isJoin = true;
        ArrayList<Expression> leftExpList = new ArrayList<Expression>();
        ArrayList<Expression> rightExpList = new ArrayList<Expression>();
        String xjoinFilter = null;
        int i = andList.size() - 1;
        while (i >= 0) {
            String spl;
            And and = (And)((Object)andList.get(i));
            if (and.isSingleTable(this.right)) {
                andList.remove(i);
                spl = and.getExp().toSPL();
                rightFilter = rightFilter == null ? spl : String.valueOf(spl) + "&&" + rightFilter;
            } else if (and.containTable(this.right)) {
                boolean b;
                andList.remove(i);
                Select.Exp exp2 = and.getExp();
                String spl2 = exp2.toSPL();
                xjoinFilter = xjoinFilter == null ? spl2 : String.valueOf(spl2) + "&&" + xjoinFilter;
                if (isJoin && !(b = exp2.splitJionExp(tableList, lastTable, leftExpList, rightExpList))) {
                    isJoin = false;
                }
            } else {
                andList.remove(i);
                spl = and.getExp().toSPL();
                leftFilter = leftFilter == null ? spl : String.valueOf(spl) + "&&" + leftFilter;
            }
            --i;
        }
        Context ctx = this.select.getContext();
        ICellSet cellSet = this.select.getCellSet();
        Sequence leftSeq = null;
        Sequence rightSeq = null;
        if (leftData instanceof Sequence) {
            leftSeq = (Sequence)leftData;
            if (leftFilter != null) {
                Expression exp3 = new Expression(cellSet, ctx, leftFilter);
                leftSeq = (Sequence)leftSeq.select(exp3, null, ctx);
            }
        } else if (leftData instanceof ICursor) {
            ICursor cs = (ICursor)leftData;
            if (leftFilter != null) {
                exp = new Expression(cellSet, ctx, leftFilter);
                cs.select(null, exp, null, ctx);
            }
            leftSeq = cs.fetch();
        }
        if (rightData instanceof Sequence) {
            rightSeq = (Sequence)rightData;
            if (rightFilter != null) {
                Expression exp4 = new Expression(cellSet, ctx, rightFilter);
                rightSeq = (Sequence)rightSeq.select(exp4, null, ctx);
            }
        } else if (rightData instanceof ICursor) {
            ICursor cs = (ICursor)rightData;
            if (rightFilter != null) {
                exp = new Expression(cellSet, ctx, rightFilter);
                cs.select(null, exp, null, ctx);
            }
            rightSeq = cs.fetch();
        }
        String name = "join" + this.hashCode();
        Sequence[] sequences = new Sequence[]{leftSeq, rightSeq};
        String[] names = new String[]{String.valueOf(name) + "_1", String.valueOf(name) + "_2"};
        int fcount = leftExpList.size();
        if (isJoin && fcount > 0) {
            Expression[] exps1 = new Expression[fcount];
            Expression[] exps2 = new Expression[fcount];
            leftExpList.toArray(exps1);
            rightExpList.toArray(exps2);
            Expression[][] totalExps = new Expression[][]{exps1, exps2};
            result = Sequence.join(sequences, totalExps, names, this.option, ctx);
        } else {
            Expression[] exps = new Expression[2];
            if (xjoinFilter != null) {
                exps[1] = new Expression(cellSet, ctx, xjoinFilter);
            }
            result = Sequence.xjoin(sequences, exps, null, names, this.option, ctx);
        }
        this.right.setJoinFieldName(names[1]);
        if (lastTable == 1) {
            this.left.setJoinFieldName(names[0]);
        } else {
            Expression[] newExps = new Expression[lastTable + 1];
            String[] newNames = new String[lastTable + 1];
            String[] leftNames = leftSeq.dataStruct().getFieldNames();
            System.arraycopy(leftNames, 0, newNames, 0, lastTable);
            newNames[lastTable] = names[1];
            int i2 = 0;
            while (i2 < lastTable) {
                newExps[i2] = new Expression(cellSet, ctx, "#1.#" + (i2 + 1));
                ++i2;
            }
            newExps[lastTable] = new Expression(cellSet, ctx, "#2");
            result = result.newTable(newNames, newExps, ctx);
        }
        if (where == null) {
            return result;
        }
        String spl = where.toSPL();
        Expression exp5 = new Expression(cellSet, ctx, spl);
        return result.select(exp5, null, ctx);
    }
}

