/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static File[] getCurrDirectoryFiles(String s) {
        return FileUtil.getFiles("./", s);
    }

    public static File[] getFiles(String s) {
        s = s.replaceAll("\\\\", "/");
        int index = s.lastIndexOf("/");
        String folder = s.substring(0, index + 1);
        String name = s.substring(index + 1);
        return FileUtil.getFiles(folder, name);
    }

    public static File[] getFiles(String dir, String s) {
        File file = new File(dir);
        s = s.replace('.', '#');
        s = s.replaceAll("#", "\\\\.");
        s = s.replace('*', '#');
        s = s.replaceAll("#", ".*");
        s = s.replace('?', '#');
        s = s.replaceAll("#", ".?");
        s = "^" + s + "$";
        Pattern p = Pattern.compile(s);
        ArrayList<File> list = FileUtil._$1(file, p, true);
        if (list == null) {
            return null;
        }
        File[] rtn = new File[list.size()];
        list.toArray(rtn);
        return rtn;
    }

    private static ArrayList<File> _$1(File file, Pattern p, boolean first) {
        if (file == null) {
            return null;
        }
        if (file.isFile()) {
            Matcher fMatcher = p.matcher(file.getName());
            if (fMatcher.matches()) {
                ArrayList<File> list = new ArrayList<File>();
                list.add(file);
                return list;
            }
        } else if (file.isDirectory()) {
            if (!first) {
                return null;
            }
            File[] files = file.listFiles();
            if (files != null && files.length > 0) {
                ArrayList<File> list = new ArrayList<File>();
                for (int i = 0; i < files.length; ++i) {
                    ArrayList<File> rlist = FileUtil._$1(files[i], p, false);
                    if (rlist == null) continue;
                    list.addAll(rlist);
                }
                return list;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        File[] fs = FileUtil.getFiles("d:\\test\\emps1.txt");
        for (int i = 0; i < fs.length; ++i) {
            System.out.println(fs[i].getAbsolutePath());
        }
    }
}

