/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.sql;

import com.scudata.common.Logger;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.sql.FixedParamFunInfo;
import com.scudata.dm.sql.FunInfo;
import com.scudata.dm.sql.simple.IFunction;
import com.scudata.expression.fn.Eval;
import com.scudata.util.Variant;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunInfoManager {
    public static final int COVER = 0;
    public static final int SKIP = 1;
    public static final int ERROR = 2;
    private static TreeMap<FunInfo, FunInfo> _$1 = new TreeMap();
    public static Map<String, Map<String, Map<Integer, String>>> dbMap = new HashMap<String, Map<String, Map<Integer, String>>>();
    public static final String ROOT = "STANDARD";
    public static final String NODE_FUNCTIONS = "FUNCTIONS";
    public static final String NODE_FUNCTION = "FUNCTION";
    public static final String KEY_TYPE = "type";
    public static final String TYPE_FIX = "FixParam";
    public static final String TYPE_ANY = "AnyParam";
    public static final String KEY_NAME = "name";
    public static final String KEY_PARAM_COUNT = "paramcount";
    public static final String NODE_INFO = "INFO";
    public static final String KEY_DB_TYPE = "dbtype";
    public static final String KEY_VALUE = "value";
    public static final String KEY_CLASS_NAME = "classname";
    public static final String KEY_SCRIPT = "script";

    private static void _$1(String dbtype, String name, int paramcount, String value) {
        Map<Integer, String> fn;
        name = name.toLowerCase();
        Map<String, Map<Integer, String>> db = dbMap.get(dbtype = dbtype.toUpperCase());
        if (db == null) {
            db = new HashMap<String, Map<Integer, String>>();
            dbMap.put(dbtype, db);
        }
        if ((fn = db.get(name)) == null) {
            fn = new HashMap<Integer, String>();
            db.put(name, fn);
        }
        fn.put(paramcount, value);
    }

    public static FixedParamFunInfo getFixedParamFunInfo(String name, int pcount) {
        FunInfo key = new FunInfo(name, pcount);
        return (FixedParamFunInfo)_$1.get(key);
    }

    public static FunInfo getFunInfo(String name, int pcount) {
        FunInfo key = new FunInfo(name, pcount);
        FunInfo val = _$1.get(key);
        if (val != null) {
            return val;
        }
        key.setParamCount(-1);
        return _$1.get(key);
    }

    public static void setFunInfo(FunInfo fi) {
        _$1.put(fi, fi);
    }

    private static void _$1(InputStream in, int sameMode) {
        Document xmlDocument;
        if (in == null) {
            return;
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            xmlDocument = docBuilder.parse(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RQException("Invalid input stream.");
        }
        NodeList nl = xmlDocument.getChildNodes();
        if (nl == null) {
            return;
        }
        Node funInfo = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equalsIgnoreCase(ROOT)) continue;
            funInfo = n;
        }
        if (funInfo == null) {
            return;
        }
        nl = funInfo.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String value;
            Node root = nl.item(i);
            if (root.getNodeType() != 1 || !root.getNodeName().equalsIgnoreCase(NODE_FUNCTIONS) || (value = FunInfoManager._$1(root, KEY_TYPE)) == null) continue;
            boolean isFix = value.equals(TYPE_FIX);
            NodeList funcNodes = root.getChildNodes();
            for (int j = 0; j < funcNodes.getLength(); ++j) {
                String name;
                Node funcNode = funcNodes.item(j);
                if (funcNode.getNodeType() != 1) continue;
                if (isFix) {
                    int paramCount;
                    name = FunInfoManager._$1(funcNode, KEY_NAME);
                    String sParamCount = FunInfoManager._$1(funcNode, KEY_PARAM_COUNT);
                    String defValue = FunInfoManager._$1(funcNode, KEY_VALUE);
                    try {
                        paramCount = Integer.parseInt(sParamCount);
                    }
                    catch (Exception ex) {
                        throw new RQException("Invalid param count:" + sParamCount);
                    }
                    NodeList infos = funcNode.getChildNodes();
                    for (int u = 0; u < infos.getLength(); ++u) {
                        Node info = infos.item(u);
                        if (info.getNodeType() != 1) continue;
                        String sDbType = FunInfoManager._$1(info, KEY_DB_TYPE);
                        String sValue = FunInfoManager._$1(info, KEY_VALUE);
                        if (sValue == null || sValue.trim().length() == 0) {
                            sValue = defValue;
                        }
                        if (sDbType == null || sDbType.trim().length() == 0) {
                            sDbType = "ESPROC";
                        }
                        FunInfoManager._$1(sDbType, name, paramCount, sValue);
                    }
                    continue;
                }
                name = FunInfoManager._$1(funcNode, KEY_NAME);
                String defValue = FunInfoManager._$1(funcNode, KEY_CLASS_NAME);
                int paramCount = -1;
                NodeList infos = funcNode.getChildNodes();
                for (int u = 0; u < infos.getLength(); ++u) {
                    Node info = infos.item(u);
                    if (info.getNodeType() != 1) continue;
                    String sDbType = FunInfoManager._$1(info, KEY_DB_TYPE);
                    String sValue = FunInfoManager._$1(info, KEY_CLASS_NAME);
                    if (sDbType == null || sDbType.trim().length() == 0) {
                        sDbType = "ESPROC";
                    }
                    if (sValue == null || sValue.trim().length() == 0) {
                        sValue = FunInfoManager._$1(info, KEY_SCRIPT);
                        if (sValue != null && sValue.length() > 0) {
                            FunInfoManager._$1(sDbType, name, -2, sValue);
                            continue;
                        }
                        FunInfoManager._$1(sDbType, name, paramCount, defValue);
                        continue;
                    }
                    FunInfoManager._$1(sDbType, name, paramCount, sValue);
                }
            }
        }
    }

    private static String _$1(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return null;
        }
        int i = attrs.getLength();
        for (int j = 0; j < i; ++j) {
            Node tmp = attrs.item(j);
            String sTmp = tmp.getNodeName();
            if (!sTmp.equalsIgnoreCase(attrName)) continue;
            return tmp.getNodeValue();
        }
        return null;
    }

    public static void clear() {
        _$1.clear();
    }

    public static Collection<FunInfo> getAllFunInfo() {
        return _$1.values();
    }

    public static boolean isFunction(String dbtype, String name) {
        Map<String, Map<Integer, String>> db = dbMap.get(dbtype.toUpperCase());
        if (db == null) {
            return false;
        }
        return db.get(name.toLowerCase()) != null;
    }

    public static String getFunctionExp(String dbtype, String name, String[] params) {
        Map<String, Map<Integer, String>> thisdb = dbMap.get(dbtype.toUpperCase());
        if (thisdb == null) {
            throw new RQException("unknown database : " + dbtype);
        }
        Map<Integer, String> typeFunctionMap = thisdb.get(name.toLowerCase());
        if (typeFunctionMap == null) {
            return null;
        }
        int pcount = params == null ? 0 : params.length;
        String formula = typeFunctionMap.get(pcount);
        if (formula != null) {
            if (formula.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                sb.append(name);
                sb.append("(");
                for (int i = 0; i < pcount; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(params[i]);
                }
                sb.append(")");
                return sb.toString();
            }
            if (formula.equalsIgnoreCase("N/A")) {
                throw new RQException("\u6b64\u51fd\u6570\u7cfb\u7edf\u6682\u4e0d\u652f\u6301:" + name);
            }
            if (pcount == 1) {
                formula = formula.replace("?1", "?");
                formula = formula.replace("?", "?1");
            }
            for (int i = 0; i < pcount; ++i) {
                formula = formula.replace("?" + (i + 1), params[i]);
            }
            return formula;
        }
        String className = typeFunctionMap.get(-1);
        if (className != null) {
            try {
                IFunction functionClass = (IFunction)Class.forName(className).newInstance();
                return functionClass.getFormula(params);
            }
            catch (Exception e) {
                throw new RQException("\u52a0\u8f7d\u975e\u56fa\u5b9a\u53c2\u6570\u4e2a\u6570\u7684\u51fd\u6570\u7684\u81ea\u5b9a\u4e49\u7c7b\u65f6\u51fa\u73b0\u9519\u8bef", e);
            }
        }
        className = typeFunctionMap.get(-2);
        if (className != null) {
            Sequence seq = new Sequence(1);
            seq.add(new Sequence(params));
            Context ctx = new Context();
            Object result = Eval.calc(className, seq, null, ctx);
            return Variant.toString(result);
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(dbMap.size());
    }

    static {
        try {
            InputStream in = FunInfoManager.class.getResourceAsStream("/com/scudata/dm/sql/function.xml");
            FunInfoManager._$1(in, 0);
        }
        catch (Exception e) {
            Logger.debug(e);
        }
    }
}

