/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.sql;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.sql.Token;
import com.scudata.resources.EngineMessage;
import java.util.ArrayList;

public final class Tokenizer {
    public static final char UNKNOWN = '\u0000';
    public static final char KEYWORD = '\u0001';
    public static final char IDENT = '\u0002';
    public static final char NUMBER = '\u0003';
    public static final char STRING = '\u0004';
    public static final char OPERATOR = '\u0005';
    public static final char LPAREN = '(';
    public static final char RPAREN = ')';
    public static final char COMMA = ',';
    public static final char DOT = '.';
    public static final char PARAMMARK = '?';
    private static final String _$3 = "+-*/=<>&|^%!~";
    public static final String COL_AS = " ";
    public static final String TABLE_AS = " ";
    private static final String[] _$2 = new String[]{"AND", "OR", "LIKE", "NOT"};
    private static final String[] _$1 = new String[]{"ALL", "AND", "AS", "ASC", "AT", "BETWEEN", "BOTTOM", "BY", "CALL", "CREATE", "DESC", "DISTINCT", "DROP", "END", "EXCEPT", "EXISTS", "ELSE", "FETCH", "FIRST", "FROM", "FULL", "GROUP", "HAVING", "IN", "INTERSECT", "IS", "INTO", "JOIN", "LIKE", "LEFT", "LIMIT", "MINUS", "NOT", "NULL", "ON", "ONLY", "OR", "ORDER", "ROWS", "RIGHT", "SELECT", "THEN", "TO", "TOP", "TABLE", "TEMPORARY", "TEMP", "UNION", "WHEN", "WHERE", "WITH"};

    public static int scanParen(Token[] tokens, int start, int next) {
        int deep = 0;
        for (int i = start + 1; i < next; ++i) {
            if (tokens[i].getType() == '(') {
                ++deep;
                continue;
            }
            if (tokens[i].getType() != ')') continue;
            if (deep == 0) {
                return i;
            }
            --deep;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("(,)" + mm.getMessage("Expression.illMatched"));
    }

    public static int scanComma(Token[] tokens, int start, int next) {
        for (int i = start; i < next; ++i) {
            char type = tokens[i].getType();
            if (type == ',') {
                return i;
            }
            if (type != '(') continue;
            i = Tokenizer.scanParen(tokens, i, next);
        }
        return -1;
    }

    public static String[] getStrings(Token[] tokens, int start, int next) {
        String[] ts = new String[next - start];
        for (int i = start; i < next; ++i) {
            ts[i - start] = tokens[i].getString();
        }
        return ts;
    }

    public static boolean isOperatorKeyWord(String name) {
        return Tokenizer.isKeyWord(name, _$2);
    }

    public static boolean isKeyWord(String id, String[] keyWords) {
        if (id == null) {
            return false;
        }
        id = id.toUpperCase();
        int len = keyWords.length;
        for (int i = 0; i < len; ++i) {
            if (!id.equals(keyWords[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isKeyWord(String id) {
        return Tokenizer.isKeyWord(id, _$1);
    }

    public static boolean isIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    public static boolean isIdentifierPart(char ch) {
        return Character.isJavaIdentifierPart(ch);
    }

    public static Token[] parse(String sql) {
        int curIndex = 0;
        int cmdLen = sql.length();
        ArrayList<Token> tokenList = new ArrayList<Token>();
        while (curIndex < cmdLen) {
            Token token;
            Token token2;
            String id;
            char ch = sql.charAt(curIndex);
            if (Character.isWhitespace(ch)) {
                ++curIndex;
                continue;
            }
            if (Tokenizer.isIdentifierStart(ch)) {
                Token token3;
                int next = Tokenizer._$2(sql, curIndex + 1);
                id = sql.substring(curIndex, next);
                String upId = id.toUpperCase();
                if (Tokenizer.isKeyWord(upId)) {
                    token3 = new Token('\u0001', upId, curIndex);
                    tokenList.add(token3);
                } else {
                    token3 = new Token('\u0002', id, curIndex);
                    tokenList.add(token3);
                }
                curIndex = next;
                continue;
            }
            if (Character.isDigit(ch)) {
                int next = Tokenizer.scanNumber(sql, curIndex + 1);
                id = sql.substring(curIndex, next);
                token2 = new Token('\u0003', id, curIndex);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '.') {
                int next = Tokenizer.scanNumber(sql, curIndex);
                id = sql.substring(curIndex, next);
                if (next > curIndex + 1) {
                    token2 = new Token('\u0003', id, curIndex);
                    tokenList.add(token2);
                } else {
                    token2 = new Token('.', id, curIndex);
                    tokenList.add(token2);
                }
                curIndex = next;
                continue;
            }
            if (ch == '\'') {
                int next = Tokenizer.scanString(sql, curIndex + 1);
                if (next < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("'" + mm.getMessage("Expression.illMatched"));
                }
                id = sql.substring(curIndex, next);
                token2 = new Token('\u0004', id, curIndex);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '\"') {
                int next = Tokenizer._$2(sql, curIndex);
                id = sql.substring(curIndex, next);
                token2 = new Token('\u0002', id, curIndex);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '?') {
                Token token4 = new Token('?', "?", curIndex);
                tokenList.add(token4);
                ++curIndex;
                continue;
            }
            if (_$3.indexOf(ch) != -1) {
                String id2 = sql.substring(curIndex, curIndex + 1);
                token = new Token('\u0005', id2, curIndex);
                tokenList.add(token);
                ++curIndex;
                continue;
            }
            if (ch == '(' || ch == ')' || ch == ',') {
                String id3 = sql.substring(curIndex, curIndex + 1);
                token = new Token(ch, id3, curIndex);
                tokenList.add(token);
                ++curIndex;
                continue;
            }
            int next = Tokenizer._$2(sql, curIndex + 1);
            token = new Token('\u0000', sql.substring(curIndex, next), curIndex);
            tokenList.add(token);
            curIndex = next;
        }
        int size = tokenList.size();
        Token[] tokens = new Token[size];
        tokenList.toArray(tokens);
        return tokens;
    }

    private static int _$2(String command, int start) {
        char ch;
        int len = command.length();
        if (start == len) {
            return start;
        }
        if (command.charAt(start) == '\"') {
            if ((start = Tokenizer._$1(command, start + 1)) < 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("\"" + mm.getMessage("Expression.illMatched"));
            }
            return start;
        }
        while (start < len && Tokenizer.isIdentifierPart(ch = command.charAt(start))) {
            ++start;
        }
        return start;
    }

    public static int scanNumber(String command, int start) {
        int len = command.length();
        while (start < len && Character.isDigit(command.charAt(start))) {
            ++start;
        }
        if (start < len && command.charAt(start) == '.') {
            ++start;
            while (start < len && Character.isDigit(command.charAt(start))) {
                ++start;
            }
        }
        return start;
    }

    public static int scanString(String command, int start) {
        int len = command.length();
        while (start < len) {
            if (command.charAt(start) == '\'' && (++start == len || command.charAt(start) != '\'')) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    private static int _$1(String command, int start) {
        int len = command.length();
        while (start < len) {
            if (command.charAt(start) == '\"' && (++start == len || command.charAt(start) != '\"')) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public static boolean isOperator(String ch) {
        return ch.length() == 1 && _$3.indexOf(ch) != -1;
    }
}

