/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.dw.BlockLink;
import com.scudata.dw.IBlockStorage;
import com.scudata.dw.LZ4Util;
import java.io.IOException;
import java.io.OutputStream;

public class BlockLinkWriter
extends OutputStream {
    private static final double _$8 = 0.75;
    private BlockLink _$7;
    private IBlockStorage _$6;
    private final int _$5;
    private final int _$4;
    private byte[] _$3;
    private int _$2;
    private LZ4Util _$1 = LZ4Util.instance();

    public BlockLinkWriter(BlockLink blockLink, boolean isAppend) throws IOException {
        this._$7 = blockLink;
        this._$6 = blockLink.getBlockStorage();
        this._$5 = this._$6.getBlockSize();
        this._$4 = this._$5 - 5;
        this._$2 = blockLink.getFreeIndex();
        this._$3 = new byte[this._$5];
        if (isAppend) {
            this._$2();
        }
    }

    int _$3() {
        return this._$4;
    }

    private void _$2() throws IOException {
        this._$6.loadBlock(this._$7._$3, this._$3);
    }

    public void finishWrite() throws IOException {
        this._$7._$2 = this._$2;
        this._$6.saveBlock(this._$7._$3, this._$3);
    }

    private void _$1() throws IOException {
        long nextBlock = this._$6.applyNewBlock();
        this._$1(this._$4, nextBlock);
        this._$6.saveBlock(this._$7._$3, this._$3);
        this._$1(this._$4, 0L);
        this._$7.appendBlock(nextBlock);
        this._$2 = 0;
    }

    public void write(int b) throws IOException {
        if (this._$2 == this._$4) {
            this._$1();
        }
        this._$3[this._$2++] = (byte)b;
    }

    public void writeInt32(int n) throws IOException {
        this.write(n >>> 24);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void write(byte[] buffer, int off, int len) throws IOException {
        int end = off + len;
        while (off < end) {
            int rest = end - off;
            int freeSize = this._$4 - this._$2;
            if (rest <= freeSize) {
                System.arraycopy(buffer, off, this._$3, this._$2, rest);
                this._$2 += rest;
                break;
            }
            System.arraycopy(buffer, off, this._$3, this._$2, freeSize);
            this._$1();
            off += freeSize;
        }
    }

    public long writeDataBlock(byte[] bytes) throws IOException {
        int srcCount = bytes.length;
        if (this._$6.isCompress()) {
            byte[] buffer = this._$1.compress(bytes);
            int count = this._$1.getCount();
            long pos = this._$7._$3 + (long)this._$2;
            if ((double)count / (double)srcCount < 0.75) {
                this.writeInt32(srcCount);
                this.writeInt32(count);
                this.write(buffer, 0, count);
            } else {
                this.writeInt32(srcCount);
                this.writeInt32(0);
                this.write(bytes, 0, srcCount);
            }
            return pos;
        }
        long pos = this._$7._$3 + (long)this._$2;
        this.writeInt32(srcCount);
        this.write(bytes, 0, srcCount);
        return pos;
    }

    public long writeDataBlock0(byte[] bytes) throws IOException {
        long pos = this._$7._$3 + (long)this._$2;
        this.write(bytes);
        return pos;
    }

    private long _$1(int i) {
        byte[] block = this._$3;
        return ((long)(block[i] & 0xFF) << 32) + ((long)(block[i + 1] & 0xFF) << 24) + (long)((block[i + 2] & 0xFF) << 16) + (long)((block[i + 3] & 0xFF) << 8) + (long)(block[i + 4] & 0xFF);
    }

    private void _$1(int i, long pos) {
        byte[] block = this._$3;
        block[i++] = (byte)(pos >>> 32);
        block[i++] = (byte)(pos >>> 24);
        block[i++] = (byte)(pos >>> 16);
        block[i++] = (byte)(pos >>> 8);
        block[i++] = (byte)(pos >>> 0);
    }

    public void rewriteBlocks(byte[] bytes) throws IOException {
        int len = bytes.length;
        int oldBlockCount = this._$7._$1;
        long blockPos = this._$7._$4;
        if (len <= this._$4) {
            this._$6.saveBlock(blockPos, bytes);
        } else {
            for (int i = 0; i < len; i += this._$4) {
                int rest = len - i;
                if (rest <= this._$4) {
                    this._$6.saveBlock(blockPos, bytes, i, rest);
                    break;
                }
                this._$6.loadBlock(blockPos, this._$3);
                long nextBlock = this._$1(this._$4);
                if (oldBlockCount > 0) {
                    --oldBlockCount;
                }
                if (nextBlock > blockPos && oldBlockCount > 0) {
                    this._$6.saveBlock(blockPos, bytes, i, this._$4);
                } else {
                    System.arraycopy(bytes, i, this._$3, 0, this._$4);
                    this._$1();
                    nextBlock = this._$7._$3;
                }
                blockPos = nextBlock;
            }
        }
    }

    public long writeDataBuffer(byte[] bytes) throws IOException {
        int count = bytes.length;
        long pos = this._$7._$3 + (long)this._$2;
        this.writeInt32(count);
        this.write(bytes, 0, count);
        return pos;
    }
}

