/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.IArray;
import com.scudata.array.LongArray;
import com.scudata.common.IntArrayList;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ConjxCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MergesCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.cursor.UpdateIdCursor;
import com.scudata.dw.BlockLink;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.BlockLinkWriter;
import com.scudata.dw.BufferReader;
import com.scudata.dw.BufferWriter;
import com.scudata.dw.ColComTable;
import com.scudata.dw.ColumnFilter;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.ComTable;
import com.scudata.dw.Cursor;
import com.scudata.dw.DataBlockWriterJob;
import com.scudata.dw.IDWCursor;
import com.scudata.dw.IFilter;
import com.scudata.dw.IlIIIIIlIlIlllIl;
import com.scudata.dw.IlIllllllIIllIIl;
import com.scudata.dw.IlllIllIlIIlIllI;
import com.scudata.dw.JoinTableCursor;
import com.scudata.dw.ModifyRecord;
import com.scudata.dw.PhyTable;
import com.scudata.expression.Constant;
import com.scudata.expression.Expression;
import com.scudata.expression.Node;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.mfn.serial.Sbs;
import com.scudata.expression.operator.Add;
import com.scudata.expression.operator.DotOperator;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.NotEquals;
import com.scudata.expression.operator.NotGreater;
import com.scudata.expression.operator.NotSmaller;
import com.scudata.expression.operator.Smaller;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.ThreadPool;
import com.scudata.util.Variant;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColPhyTable
extends PhyTable {
    private transient ColumnMetaData[] _$8;
    private transient ColumnMetaData[] _$7;
    private transient ColumnMetaData[] _$6;
    private transient ColumnMetaData[] _$5;
    private transient String[] _$4;
    private transient ColumnMetaData _$3;
    protected int sortedColStartIndex;
    private static final String _$2 = "_guidecol";

    public ColPhyTable(ComTable groupTable) {
        this.groupTable = groupTable;
        this.segmentBlockLink = new BlockLink(groupTable);
        this.modifyBlockLink1 = new BlockLink(groupTable);
        this.modifyBlockLink2 = new BlockLink(groupTable);
    }

    public ColPhyTable(ComTable groupTable, ColPhyTable parent) {
        this.groupTable = groupTable;
        this.parent = parent;
        this.segmentBlockLink = new BlockLink(groupTable);
        this.modifyBlockLink1 = new BlockLink(groupTable);
        this.modifyBlockLink2 = new BlockLink(groupTable);
    }

    public ColPhyTable(ComTable groupTable, String[] colNames) throws IOException {
        int i;
        this.groupTable = groupTable;
        this.tableName = "";
        this.segmentBlockLink = new BlockLink(groupTable);
        this.modifyBlockLink1 = new BlockLink(groupTable);
        this.modifyBlockLink2 = new BlockLink(groupTable);
        int count = colNames.length;
        this._$8 = new ColumnMetaData[count];
        int keyStart = -1;
        for (i = 0; i < count; ++i) {
            if (!colNames[i].startsWith(KEY_PREFIX)) continue;
            keyStart = i;
            break;
        }
        for (i = 0; i < count; ++i) {
            if (colNames[i].startsWith(KEY_PREFIX)) {
                String colName = colNames[i].substring(KEY_PREFIX.length());
                this._$8[i] = new ColumnMetaData(this, colName, true, true);
                continue;
            }
            this._$8[i] = i < keyStart ? new ColumnMetaData(this, colNames[i], true, false) : new ColumnMetaData(this, colNames[i], false, false);
        }
        this.init();
        if (this._$6 == null) {
            this.hasPrimaryKey = false;
            this.isSorted = false;
        }
        this.tableList = new ArrayList();
        this.reserve[0] = 4;
    }

    public ColPhyTable(ComTable groupTable, String[] colNames, int[] serialBytesLen) throws IOException {
        this.groupTable = groupTable;
        this.tableName = "";
        this.colNames = colNames;
        this.segmentBlockLink = new BlockLink(groupTable);
        this.modifyBlockLink1 = new BlockLink(groupTable);
        this.modifyBlockLink2 = new BlockLink(groupTable);
        int count = colNames.length;
        this._$8 = new ColumnMetaData[count];
        for (int i = 0; i < count; ++i) {
            this._$8[i] = new ColumnMetaData(this, colNames[i], serialBytesLen[i]);
        }
        this.init();
        if (this._$6 == null) {
            this.hasPrimaryKey = false;
            this.isSorted = false;
        }
        this.tableList = new ArrayList();
    }

    public ColPhyTable(ComTable groupTable, String[] colNames, int[] serialBytesLen, String tableName, ColPhyTable parent) throws IOException {
        this.groupTable = groupTable;
        this.parent = parent;
        this.tableName = tableName;
        this.colNames = colNames;
        this.segmentBlockLink = new BlockLink(groupTable);
        this.modifyBlockLink1 = new BlockLink(groupTable);
        this.modifyBlockLink2 = new BlockLink(groupTable);
        int count = colNames.length;
        this._$8 = new ColumnMetaData[count];
        for (int i = 0; i < count; ++i) {
            if (colNames[i].startsWith(KEY_PREFIX)) {
                String colName = colNames[i].substring(KEY_PREFIX.length());
                this._$8[i] = new ColumnMetaData(this, colName, true, true);
                continue;
            }
            this._$8[i] = new ColumnMetaData(this, colNames[i], false, false);
        }
        this.init();
        if (this.getAllSortedColumns() == null) {
            this.hasPrimaryKey = false;
            this.isSorted = false;
        }
        if (parent != null) {
            if (parent.parent != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.dsNotMatch"));
            }
            ColPhyTable primaryTable = parent;
            String[] primarySortedColNames = ((PhyTable)primaryTable).getSortedColNames();
            String[] primaryColNames = primaryTable.getColNames();
            ArrayList<String> collist = new ArrayList<String>();
            for (String name : primaryColNames) {
                collist.add(name);
            }
            int len = colNames.length;
            for (int i = 0; i < len; ++i) {
                if (!collist.contains(colNames[i])) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException(colNames[i] + mm.getMessage("dw.fieldSameToPrimaryTable"));
            }
            for (String name : primarySortedColNames) {
                collist.remove(name);
            }
            this.sortedColStartIndex = primarySortedColNames.length;
            this._$3 = new ColumnMetaData(this, tableName + _$2, false, false);
        }
        this.tableList = new ArrayList();
    }

    public ColPhyTable(ComTable groupTable, ColPhyTable parent, ColPhyTable src) throws IOException {
        this.groupTable = groupTable;
        this.parent = parent;
        System.arraycopy(src.reserve, 0, this.reserve, 0, this.reserve.length);
        this.segmentCol = src.segmentCol;
        this.segmentSerialLen = src.segmentSerialLen;
        this.tableName = src.tableName;
        this.colNames = src.colNames;
        this.segmentBlockLink = new BlockLink(groupTable);
        this.modifyBlockLink1 = new BlockLink(groupTable);
        this.modifyBlockLink2 = new BlockLink(groupTable);
        int count = this.colNames.length;
        this._$8 = new ColumnMetaData[count];
        ColumnMetaData[] srcCols = src.getColumns();
        for (int i = 0; i < count; ++i) {
            this._$8[i] = new ColumnMetaData(this, srcCols[i]);
        }
        this.init();
        if (this._$6 == null && this._$5 == null) {
            this.hasPrimaryKey = false;
            this.isSorted = false;
        }
        if (parent != null) {
            this._$3 = new ColumnMetaData(this, this.tableName + _$2, false, false);
        }
        this.dupIndexAdnCuboid(src);
        this.tableList = new ArrayList();
        for (PhyTable srcSub : src.tableList) {
            this.tableList.add(new ColPhyTable(groupTable, this, (ColPhyTable)srcSub));
        }
    }

    @Override
    protected void init() {
        ColumnMetaData[] columns = this._$8;
        int dimCount = 0;
        int keyCount = 0;
        int j = 0;
        this.colNames = new String[columns.length];
        for (ColumnMetaData col : columns) {
            if (col.isDim()) {
                ++dimCount;
            }
            if (col.isKey()) {
                ++keyCount;
            }
            this.colNames[j++] = col.getColName();
        }
        if (keyCount > 0) {
            this._$6 = new ColumnMetaData[dimCount];
            this._$4 = new String[keyCount];
            int i = 0;
            int k = 0;
            for (ColumnMetaData col : columns) {
                if (col.isDim()) {
                    this._$6[i++] = col;
                }
                if (!col.isKey()) continue;
                this._$4[k++] = col.getColName();
            }
        }
        if (this.parent != null) {
            String[] parentKeys = this.parent.getAllKeyColNames();
            if (keyCount > 0) {
                int parentKeyCount = parentKeys.length;
                String[] tmp = new String[parentKeyCount + keyCount];
                System.arraycopy(parentKeys, 0, tmp, 0, parentKeyCount);
                System.arraycopy(this._$4, 0, tmp, parentKeyCount, keyCount);
                this._$4 = tmp;
            } else {
                this._$4 = parentKeys;
            }
            String[] primarySortedColNames = this.parent.getSortedColNames();
            this.sortedColStartIndex = primarySortedColNames.length;
            this._$5 = new ColumnMetaData[this.sortedColStartIndex + dimCount];
            ColumnMetaData[] baseSortedCols = ((ColPhyTable)this.parent).getSortedColumns();
            int i = 0;
            if (baseSortedCols != null) {
                ColumnMetaData[] arr$ = baseSortedCols;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ColumnMetaData col = arr$[i$];
                    this._$5[i++] = col;
                }
            }
            if (this._$6 != null) {
                for (ColumnMetaData col : this._$6) {
                    this._$5[i++] = col;
                }
            }
            ColumnMetaData[] parentColumns = ((ColPhyTable)this.parent).getSortedColumns();
            this._$7 = new ColumnMetaData[parentColumns.length + columns.length];
            this.allColNames = new String[parentColumns.length + columns.length];
            i = 0;
            for (ColumnMetaData col : parentColumns) {
                this.allColNames[i] = col.getColName();
                this._$7[i++] = col;
            }
            for (ColumnMetaData col : columns) {
                this.allColNames[i] = col.getColName();
                this._$7[i++] = col;
            }
            this.ds = new DataStruct(this.allColNames);
        } else {
            this.ds = new DataStruct(this.colNames);
        }
    }

    public ColumnMetaData[] getColumns() {
        return this._$8;
    }

    public ColumnMetaData[] getAllColumns() {
        if (this.parent == null) {
            return this._$8;
        }
        return this._$7;
    }

    ColumnMetaData[] _$2() {
        if (this.parent == null) {
            return this._$8;
        }
        int baseColCount = ((ColPhyTable)this.parent)._$8.length;
        int len = baseColCount + this._$8.length;
        ColumnMetaData[] cols = new ColumnMetaData[len];
        System.arraycopy(((ColPhyTable)this.parent)._$8, 0, cols, 0, baseColCount);
        System.arraycopy(this._$8, 0, cols, baseColCount, this._$8.length);
        return cols;
    }

    public String[] getTotalColNames() {
        if (this.parent == null) {
            return this.colNames;
        }
        int baseColCount = this.parent.colNames.length;
        int len = baseColCount + this.colNames.length;
        String[] names = new String[len];
        System.arraycopy(this.parent.colNames, 0, names, 0, baseColCount);
        System.arraycopy(this.colNames, 0, names, baseColCount, this.colNames.length);
        return names;
    }

    public ColumnMetaData[] getSortedColumns() {
        return this._$6;
    }

    public ColumnMetaData[] getAllSortedColumns() {
        if (this.parent == null) {
            return this._$6;
        }
        return this._$5;
    }

    @Override
    public String[] getSortedColNames() {
        if (this._$6 == null) {
            return null;
        }
        int len = this._$6.length;
        String[] names = new String[len];
        for (int i = 0; i < len; ++i) {
            names[i] = this._$6[i].getColName();
        }
        return names;
    }

    @Override
    public String[] getAllSortedColNames() {
        if (this.parent == null) {
            return this.getSortedColNames();
        }
        if (this._$5 == null) {
            return null;
        }
        int len = this._$5.length;
        String[] names = new String[len];
        for (int i = 0; i < len; ++i) {
            names[i] = this._$5[i].getColName();
        }
        return names;
    }

    @Override
    public String[] getAllKeyColNames() {
        return this._$4;
    }

    public ColumnMetaData[] getColumns(String[] fields) {
        if (fields == null) {
            return this._$8;
        }
        ColumnMetaData[] columns = this._$8;
        int srcCount = columns.length;
        int count = fields.length;
        ColumnMetaData[] result = new ColumnMetaData[count];
        for (int i = 0; i < count; ++i) {
            int s;
            block4: {
                String field = fields[i];
                for (s = 0; s < srcCount; ++s) {
                    if (!columns[s].isColumn(field)) {
                        continue;
                    }
                    break block4;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException(field + mm.getMessage("ds.fieldNotExist"));
            }
            result[i] = columns[s];
        }
        return result;
    }

    @Override
    public int[] getSerialBytesLen() {
        int len = this._$8.length;
        int[] serialBytesLen = new int[len];
        for (int i = 0; i < len; ++i) {
            serialBytesLen[i] = this._$8[i].getSerialBytesLen();
        }
        return serialBytesLen;
    }

    public ColumnMetaData[] getColumns(Expression[] exps) {
        if (exps == null) {
            return this._$8;
        }
        ColumnMetaData[] columns = this._$8;
        int srcCount = columns.length;
        int count = exps.length;
        ColumnMetaData[] result = new ColumnMetaData[count];
        block0: for (int i = 0; i < count; ++i) {
            if (!(exps[i].getHome() instanceof UnknownSymbol)) continue;
            String col = exps[i].getIdentifierName();
            for (int s = 0; s < srcCount; ++s) {
                if (!columns[s].isColumn(col)) continue;
                result[i] = columns[s];
                continue block0;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(col + mm.getMessage("ds.fieldNotExist"));
        }
        return result;
    }

    public ArrayList<ColumnMetaData> getExpColumns(Expression[] exps) {
        if (exps == null) {
            return null;
        }
        ArrayList<ColumnMetaData> result = new ArrayList<ColumnMetaData>();
        ColumnMetaData[] columns = this._$8;
        int srcCount = columns.length;
        int count = exps.length;
        block0: for (int i = 0; i < count; ++i) {
            if (exps[i].getHome() instanceof DotOperator) {
                String col = null;
                Node left = exps[i].getHome().getLeft();
                Node right = exps[i].getHome().getRight();
                if (!(left instanceof UnknownSymbol) || !(right instanceof Sbs)) continue;
                col = ((UnknownSymbol)left).getName();
                for (int s = 0; s < srcCount; ++s) {
                    if (!columns[s].isColumn(col)) continue;
                    if (result.contains(columns[s])) continue block0;
                    result.add(columns[s]);
                    continue block0;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException(col + mm.getMessage("ds.fieldNotExist"));
            }
            if (!(exps[i].getHome() instanceof Add)) continue;
            String col1 = null;
            String col2 = null;
            Node obj1 = exps[i].getHome().getLeft();
            Node obj2 = exps[i].getHome().getRight();
            if (obj1 instanceof UnknownSymbol && obj2 instanceof UnknownSymbol) {
                col1 = ((UnknownSymbol)obj1).getName();
                col2 = ((UnknownSymbol)obj2).getName();
            }
            boolean b1 = false;
            boolean b2 = false;
            for (int s = 0; s < srcCount; ++s) {
                if (columns[s].isColumn(col1)) {
                    if (!result.contains(columns[s])) {
                        result.add(columns[s]);
                    }
                    b1 = true;
                }
                if (!columns[s].isColumn(col2)) continue;
                if (!result.contains(columns[s])) {
                    result.add(columns[s]);
                }
                b2 = true;
            }
            if (b1 && b2) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(col1 + " or " + col2 + mm.getMessage("ds.fieldNotExist"));
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public ColumnMetaData getColumn(String field) {
        ColumnMetaData[] columns;
        for (ColumnMetaData col : columns = this._$8) {
            if (!col.isColumn(field)) continue;
            return col;
        }
        return null;
    }

    public ColumnMetaData getGuideColumn() {
        return this._$3;
    }

    @Override
    protected void applyFirstBlock() throws IOException {
        if (this.segmentBlockLink.isEmpty()) {
            ColumnMetaData[] columns;
            this.segmentBlockLink.setFirstBlockPos(this.groupTable.applyNewBlock());
            for (ColumnMetaData col : columns = this._$8) {
                col._$1();
            }
            for (ColumnMetaData col : columns) {
                col._$2();
            }
            if (this.parent != null) {
                this._$3._$1();
                this._$3._$2();
            }
        }
    }

    @Override
    protected void prepareAppend() throws IOException {
        this.applyFirstBlock();
        this.segmentWriter = new BlockLinkWriter(this.segmentBlockLink, true);
        for (ColumnMetaData col : this._$8) {
            col.prepareWrite();
        }
        if (this.parent != null) {
            this._$3.prepareWrite();
        }
    }

    @Override
    protected void finishAppend() throws IOException {
        this.segmentWriter.finishWrite();
        this.segmentWriter = null;
        for (ColumnMetaData col : this._$8) {
            col.finishWrite();
        }
        if (this.parent != null) {
            this._$3.finishWrite();
        }
        this.groupTable._$3();
        this.updateIndex();
    }

    @Override
    public void readExternal(BufferReader reader) throws IOException {
        int i;
        reader.read(this.reserve);
        this.tableName = reader.readUTF();
        this.colNames = reader.readStrings();
        this.dataBlockCount = reader.readInt32();
        this.totalRecordCount = reader.readLong40();
        this.segmentBlockLink.readExternal(reader);
        this.curModifyBlock = reader.readByte();
        this.modifyBlockLink1.readExternal(reader);
        this.modifyBlockLink2.readExternal(reader);
        int count = reader.readInt();
        this._$8 = new ColumnMetaData[count];
        for (i = 0; i < count; ++i) {
            this._$8[i] = new ColumnMetaData(this);
            this._$8[i].readExternal(reader, this.reserve[0]);
        }
        count = reader.readInt();
        if (count > 0) {
            this.maxValues = new Object[count];
            for (i = 0; i < count; ++i) {
                this.maxValues[i] = reader.readObject();
            }
        }
        this.hasPrimaryKey = reader.readBoolean();
        this.isSorted = reader.readBoolean();
        boolean isPrimaryTable = reader.readBoolean();
        if (!isPrimaryTable) {
            this._$3 = new ColumnMetaData(this);
            this._$3.readExternal(reader, this.reserve[0]);
        }
        this.indexNames = reader.readStrings();
        if (this.indexNames == null) {
            this.indexFields = null;
            this.indexValueFields = null;
        } else {
            int i2;
            int indexCount = this.indexNames.length;
            this.indexFields = new String[indexCount][];
            for (i2 = 0; i2 < indexCount; ++i2) {
                this.indexFields[i2] = reader.readStrings();
            }
            this.indexValueFields = new String[indexCount][];
            for (i2 = 0; i2 < indexCount; ++i2) {
                this.indexValueFields[i2] = reader.readStrings();
            }
        }
        if (this.groupTable.reserve[0] > 2) {
            this.cuboids = reader.readStrings();
        }
        this.segmentCol = (String)reader.readObject();
        this.segmentSerialLen = reader.readInt();
        this.init();
        count = reader.readInt();
        this.tableList = new ArrayList(count);
        for (int i3 = 0; i3 < count; ++i3) {
            ColPhyTable table = new ColPhyTable(this.groupTable, this);
            ((PhyTable)table).readExternal(reader);
            this.tableList.add(table);
        }
    }

    @Override
    public void writeExternal(BufferWriter writer) throws IOException {
        int i;
        this.reserve[0] = 5;
        writer.write(this.reserve);
        writer.writeUTF(this.tableName);
        writer.writeStrings(this.colNames);
        writer.writeInt32(this.dataBlockCount);
        writer.writeLong40(this.totalRecordCount);
        this.segmentBlockLink.writeExternal(writer);
        writer.writeByte(this.curModifyBlock);
        this.modifyBlockLink1.writeExternal(writer);
        this.modifyBlockLink2.writeExternal(writer);
        ColumnMetaData[] columns = this._$8;
        int count = columns.length;
        writer.writeInt(count);
        for (i = 0; i < count; ++i) {
            columns[i].writeExternal(writer);
        }
        if (this.maxValues == null) {
            writer.writeInt(0);
        } else {
            writer.writeInt(this.maxValues.length);
            for (Object val : this.maxValues) {
                writer.writeObject(val);
            }
            writer.flush();
        }
        writer.writeBoolean(this.hasPrimaryKey);
        writer.writeBoolean(this.isSorted);
        writer.writeBoolean(this.parent == null);
        if (this.parent != null) {
            this._$3.writeExternal(writer);
        }
        writer.writeStrings(this.indexNames);
        if (this.indexNames != null) {
            int indexCount = this.indexNames.length;
            for (i = 0; i < indexCount; ++i) {
                writer.writeStrings(this.indexFields[i]);
            }
            indexCount = this.indexNames.length;
            for (i = 0; i < indexCount; ++i) {
                writer.writeStrings(this.indexValueFields[i]);
            }
        }
        writer.writeStrings(this.cuboids);
        writer.writeObject(this.segmentCol);
        writer.flush();
        writer.writeInt(this.segmentSerialLen);
        ArrayList tableList = this.tableList;
        count = tableList.size();
        writer.writeInt(count);
        for (int i2 = 0; i2 < count; ++i2) {
            ((PhyTable)tableList.get(i2)).writeExternal(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1(Sequence data, boolean[] isMyCol, LongArray recList) throws IOException {
        int j;
        ColumnMetaData[] columns = this._$7;
        int count = columns.length;
        Object[] minValues = new Object[count];
        Object[] maxValues = new Object[count];
        Object[] startValues = new Object[count];
        int[] dataTypeInfo = new int[count];
        BufferWriter bufferWriter = this._$3.getColDataBufferWriter();
        BufferWriter[] bufferWriters = new BufferWriter[count];
        DataBlockWriterJob[] jobs = new DataBlockWriterJob[count];
        ThreadPool pool = ThreadPool.newInstance(count);
        int end = data.length();
        try {
            int i;
            bufferWriter.write(32);
            for (i = 1; i <= end; ++i) {
                bufferWriter.writeLong(recList.getLong(i));
            }
            bufferWriter.writeBoolean(false);
            for (i = 0; i < count; ++i) {
                if (!isMyCol[i]) continue;
                bufferWriters[i] = columns[i].getColDataBufferWriter();
                Sequence dict = columns[i].getDict();
                jobs[i] = new DataBlockWriterJob(bufferWriters[i], data, dict, i, 1, end, maxValues, minValues, startValues, dataTypeInfo);
                pool.submit(jobs[i]);
            }
            for (i = 0; i < count; ++i) {
                if (!isMyCol[i]) continue;
                jobs[i].join();
            }
        }
        finally {
            pool.shutdown();
        }
        boolean doCheck = this.groupTable.isCheckDataPure();
        for (j = 0; j < count; ++j) {
            if (!isMyCol[j]) continue;
            columns[j].adjustDataType(dataTypeInfo[j], doCheck);
            columns[j].initDictArray();
        }
        if (recList.size() == 0) {
            bufferWriter.writeObject(null);
            for (j = 0; j < count; ++j) {
                if (!isMyCol[j]) continue;
                bufferWriters[j].writeObject(null);
            }
        }
        this._$3.appendColBlock(bufferWriter.finish());
        for (j = 0; j < count; ++j) {
            if (!isMyCol[j]) continue;
            columns[j].appendColBlock(bufferWriters[j].finish(), minValues[j], maxValues[j], startValues[j]);
        }
        this.appendSegmentBlock(end);
    }

    public void appendAttachedDataBlockV3(Sequence data, boolean[] isMyCol, LongArray recList) throws IOException {
        int j;
        ColumnMetaData[] columns = this._$7;
        int count = columns.length;
        int[] serialBytesLen = new int[count];
        Object[] minValues = null;
        Object[] maxValues = null;
        Object[] startValues = null;
        if (this._$6 != null) {
            minValues = new Object[count];
            maxValues = new Object[count];
            startValues = new Object[count];
        }
        BufferWriter bufferWriter = this._$3.getColDataBufferWriter();
        BufferWriter[] bufferWriters = new BufferWriter[count];
        for (int i = 0; i < count; ++i) {
            if (!isMyCol[i]) continue;
            serialBytesLen[i] = columns[i].getSerialBytesLen();
            bufferWriters[i] = columns[i].getColDataBufferWriter();
        }
        int end = data.length();
        for (int i = 1; i <= end; ++i) {
            Object obj;
            int j2;
            bufferWriter.writeObject(recList.get(i - 1));
            BaseRecord r = (BaseRecord)data.get(i);
            Object[] vals = r.getFieldValues();
            for (j2 = 0; j2 < count; ++j2) {
                if (!isMyCol[j2]) continue;
                obj = vals[j2];
                if (serialBytesLen[j2] > 0) {
                    if (obj instanceof SerialBytes) {
                        bufferWriters[j2].writeObject(obj);
                        continue;
                    }
                    Long val = obj instanceof Integer ? Long.valueOf((long)((Integer)obj).intValue() & 0xFFFFFFFFL) : (Long)obj;
                    bufferWriters[j2].writeObject(new SerialBytes(val, serialBytesLen[j2]));
                    continue;
                }
                bufferWriters[j2].writeObject(obj);
            }
            for (j2 = 0; j2 < count; ++j2) {
                if (!isMyCol[j2]) continue;
                obj = vals[j2];
                if (!columns[j2].isDim()) continue;
                if (Variant.compare(obj, maxValues[j2], true) > 0) {
                    maxValues[j2] = obj;
                }
                if (i == 1) {
                    minValues[j2] = obj;
                    startValues[j2] = obj;
                }
                if (Variant.compare(obj, minValues[j2], true) >= 0) continue;
                minValues[j2] = obj;
            }
        }
        if (recList.size() == 0) {
            bufferWriter.writeObject(null);
            for (j = 0; j < count; ++j) {
                if (!isMyCol[j]) continue;
                bufferWriters[j].writeObject(null);
            }
        }
        this._$3.appendColBlock(bufferWriter.finish());
        if (this._$6 == null) {
            for (j = 0; j < count; ++j) {
                if (!isMyCol[j]) continue;
                columns[j].appendColBlock(bufferWriters[j].finish());
            }
            this.appendSegmentBlock(end);
            return;
        }
        for (j = 0; j < count; ++j) {
            if (!isMyCol[j]) continue;
            if (!columns[j].isDim()) {
                columns[j].appendColBlock(bufferWriters[j].finish());
                continue;
            }
            columns[j].appendColBlock(bufferWriters[j].finish(), minValues[j], maxValues[j], startValues[j]);
        }
        this.appendSegmentBlock(end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1(Sequence data, int start, int end) throws IOException {
        int j;
        ColumnMetaData[] columns = this._$8;
        int count = columns.length;
        Object[] minValues = new Object[count];
        Object[] maxValues = new Object[count];
        Object[] startValues = new Object[count];
        int[] dataTypeInfo = new int[count];
        BufferWriter[] bufferWriters = new BufferWriter[count];
        DataBlockWriterJob[] jobs = new DataBlockWriterJob[count];
        ThreadPool pool = ThreadPool.newInstance(count);
        try {
            int i;
            for (i = 0; i < count; ++i) {
                bufferWriters[i] = columns[i].getColDataBufferWriter();
                Sequence dict = columns[i].getDict();
                jobs[i] = new DataBlockWriterJob(bufferWriters[i], data, dict, i, start, end, maxValues, minValues, startValues, dataTypeInfo);
                pool.submit(jobs[i]);
            }
            for (i = 0; i < count; ++i) {
                jobs[i].join();
            }
        }
        finally {
            pool.shutdown();
        }
        boolean doCheck = this.groupTable.isCheckDataPure();
        for (j = 0; j < count; ++j) {
            columns[j].adjustDataType(dataTypeInfo[j], doCheck);
            columns[j].initDictArray();
        }
        for (j = 0; j < count; ++j) {
            columns[j].appendColBlock(bufferWriters[j].finish(), minValues[j], maxValues[j], startValues[j]);
        }
        this.appendSegmentBlock(end - start + 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendDataBlockV3(Sequence data, int start, int end) throws IOException {
        int j;
        ColumnMetaData[] columns = this._$8;
        int count = columns.length;
        int[] serialBytesLen = new int[count];
        Object[] minValues = null;
        Object[] maxValues = null;
        Object[] startValues = null;
        if (this._$6 != null) {
            minValues = new Object[count];
            maxValues = new Object[count];
            startValues = new Object[count];
        }
        BufferWriter[] bufferWriters = new BufferWriter[count];
        for (int i = 0; i < count; ++i) {
            serialBytesLen[i] = columns[i].getSerialBytesLen();
            bufferWriters[i] = columns[i].getColDataBufferWriter();
        }
        IArray mems = data.getMems();
        int i = start;
        while (true) {
            if (i > end) {
                if (this._$6 == null) {
                    j = 0;
                    while (true) {
                        if (j >= count) {
                            this.appendSegmentBlock(end - start + 1);
                            return;
                        }
                        columns[j].appendColBlock(bufferWriters[j].finish());
                        ++j;
                    }
                }
                break;
            }
            BaseRecord r = (BaseRecord)mems.get(i);
            mems.set(i, null);
            Object[] vals = r.getFieldValues();
            for (int j2 = 0; j2 < count; ++j2) {
                Object obj = vals[j2];
                if (serialBytesLen[j2] > 0) {
                    if (!(obj instanceof SerialBytes)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("dw.needSerialBytes"));
                    }
                    if (((SerialBytes)obj).length() > serialBytesLen[j2]) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.indexOutofBound"));
                    }
                    bufferWriters[j2].writeObject(obj);
                } else {
                    bufferWriters[j2].writeObject(obj);
                }
                if (!columns[j2].isDim()) continue;
                if (Variant.compare(obj, maxValues[j2], true) > 0) {
                    maxValues[j2] = obj;
                }
                if (i == start) {
                    minValues[j2] = obj;
                    startValues[j2] = obj;
                }
                if (Variant.compare(obj, minValues[j2], true) >= 0) continue;
                minValues[j2] = obj;
            }
            ++i;
        }
        j = 0;
        while (true) {
            if (j >= count) {
                this.appendSegmentBlock(end - start + 1);
                return;
            }
            if (!columns[j].isDim()) {
                columns[j].appendColBlock(bufferWriters[j].finish());
            } else {
                columns[j].appendColBlock(bufferWriters[j].finish(), minValues[j], maxValues[j], startValues[j]);
            }
            ++j;
        }
    }

    private void _$4(ICursor cursor) throws IOException {
        Sequence data = cursor.fetch(MIN_BLOCK_RECORD_COUNT);
        while (data != null && data.length() > 0) {
            this._$1(data, 1, data.length());
            data = cursor.fetch(MIN_BLOCK_RECORD_COUNT);
        }
    }

    private void _$3(ICursor cursor) throws IOException {
        PhyTable primaryTable = this.parent;
        int pBlockCount = primaryTable.getDataBlockCount();
        int curBlockCount = this.dataBlockCount;
        int pkeyEndIndex = this.sortedColStartIndex;
        String[] primaryTableKeys = primaryTable.getSortedColNames();
        ArrayList<String> primaryTableKeyList = new ArrayList<String>();
        for (String name : primaryTableKeys) {
            primaryTableKeyList.add(name);
        }
        String[] colNames = this.getAllColNames();
        int fcount = colNames.length;
        boolean[] isMyCol = new boolean[fcount];
        for (int i = 0; i < fcount; ++i) {
            isMyCol[i] = !primaryTableKeyList.contains(colNames[i]);
        }
        if (primaryTable.totalRecordCount == 0L) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.baseTableNull"));
        }
        Cursor cs = (Cursor)primaryTable.cursor(primaryTableKeys);
        cs.setSegment(curBlockCount, curBlockCount + 1);
        Sequence pkeyData = cs.fetch(0x7FFFFFFE);
        int pkeyIndex = 1;
        int pkeyDataLen = pkeyData.length();
        IlllIllIlIIlIllI curPkey = (IlllIllIlIIlIllI)pkeyData.get(1);
        Object[] curPkeyVals = curPkey.getFieldValues();
        int sortedColCount = this._$5.length;
        Object[] tableMaxValues = this.maxValues;
        Object[] lastValues = new Object[sortedColCount];
        LongArray guideCol = new LongArray(MIN_BLOCK_RECORD_COUNT);
        Sequence seq = new Sequence(MIN_BLOCK_RECORD_COUNT);
        Sequence data = cursor.fetch(ICursor.FETCHCOUNT);
        Object[] vals = new Object[sortedColCount];
        int[] findex = this.getSortedColIndex();
        while (data != null && data.length() > 0) {
            int len = data.length();
            for (int i = 1; i <= len; ++i) {
                int cmp;
                BaseRecord r = (BaseRecord)data.get(i);
                for (int f = 0; f < sortedColCount; ++f) {
                    vals[f] = r.getNormalFieldValue(findex[f]);
                }
                while ((cmp = Variant.compareArrays(curPkeyVals, vals, pkeyEndIndex)) != 0) {
                    if (cmp < 0) {
                        if (++pkeyIndex > pkeyDataLen) {
                            this._$1(seq, isMyCol, guideCol);
                            seq.clear();
                            guideCol = new LongArray(MIN_BLOCK_RECORD_COUNT);
                            if (++curBlockCount >= pBlockCount) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(mm.getMessage("dw.appendNotMatch") + r.toString(null));
                            }
                            cs = (Cursor)primaryTable.cursor(primaryTableKeys);
                            cs.setSegment(curBlockCount, curBlockCount + 1);
                            pkeyData = cs.fetch(0x7FFFFFFE);
                            pkeyIndex = 1;
                            pkeyDataLen = pkeyData.length();
                        }
                        curPkey = (IlllIllIlIIlIllI)pkeyData.get(pkeyIndex);
                        curPkeyVals = curPkey.getFieldValues();
                        continue;
                    }
                    if (cmp <= 0) continue;
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("dw.appendNotMatch") + r.toString(null));
                }
                guideCol.add(curPkey.getRecordSeq());
                if (this.isSorted) {
                    if (tableMaxValues != null) {
                        cmp = Variant.compareArrays(vals, tableMaxValues, sortedColCount);
                        if (cmp < 0) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("dw.appendAttachedTable"));
                        }
                        if (cmp == 0) {
                            if (this.hasPrimaryKey) {
                                this.hasPrimaryKey = false;
                            }
                        } else {
                            System.arraycopy(vals, 0, tableMaxValues, 0, sortedColCount);
                        }
                    } else {
                        this.maxValues = new Object[sortedColCount];
                        tableMaxValues = this.maxValues;
                        System.arraycopy(vals, 0, tableMaxValues, 0, sortedColCount);
                    }
                }
                seq.add(r);
                System.arraycopy(vals, 0, lastValues, 0, sortedColCount);
            }
            data = cursor.fetch(ICursor.FETCHCOUNT);
        }
        if (seq.length() > 0) {
            this._$1(seq, isMyCol, guideCol);
        }
    }

    private void _$2(ICursor cursor) throws IOException {
        int recCount = 0;
        int sortedColCount = this._$6.length;
        Object[] tableMaxValues = this.maxValues;
        String segmentCol = this.getSegmentCol();
        int segmentSerialLen = this.getSegmentSerialLen();
        int segmentIndex = 0;
        for (int i = 0; i < sortedColCount; ++i) {
            if (!segmentCol.equals(this._$6[i].getColName())) continue;
            segmentIndex = i;
            break;
        }
        int cmpLen = segmentIndex + 1;
        int serialBytesLen = this._$6[segmentIndex].getSerialBytesLen();
        if (segmentSerialLen == 0 || segmentSerialLen > serialBytesLen) {
            segmentSerialLen = serialBytesLen;
        }
        Object[] lastValues = new Object[cmpLen];
        Object[] curValues = new Object[cmpLen];
        Sequence seq = new Sequence(MIN_BLOCK_RECORD_COUNT);
        Sequence data = cursor.fetch(ICursor.FETCHCOUNT);
        Object[] vals = new Object[sortedColCount];
        int[] findex = this.getSortedColIndex();
        while (data != null && data.length() > 0) {
            int len = data.length();
            for (int i = 1; i <= len; ++i) {
                BaseRecord r = (BaseRecord)data.get(i);
                for (int f = 0; f < sortedColCount; ++f) {
                    vals[f] = r.getNormalFieldValue(findex[f]);
                }
                if (recCount >= MIN_BLOCK_RECORD_COUNT) {
                    System.arraycopy(vals, 0, curValues, 0, cmpLen);
                    if (0 != Variant.compareArrays(lastValues, curValues, cmpLen)) {
                        this._$1(seq, 1, seq.length());
                        seq.clear();
                        recCount = 0;
                    }
                }
                if (this.isSorted) {
                    if (tableMaxValues != null) {
                        int cmp = Variant.compareArrays(vals, tableMaxValues, sortedColCount);
                        if (cmp < 0) {
                            this.hasPrimaryKey = false;
                            this.isSorted = false;
                            this.maxValues = null;
                        } else if (cmp == 0) {
                            if (this.hasPrimaryKey) {
                                this.hasPrimaryKey = false;
                            }
                        } else {
                            System.arraycopy(vals, 0, tableMaxValues, 0, sortedColCount);
                        }
                    } else {
                        this.maxValues = new Object[sortedColCount];
                        tableMaxValues = this.maxValues;
                        System.arraycopy(vals, 0, tableMaxValues, 0, sortedColCount);
                    }
                    if (this.tableList.size() > 0 && !this.hasPrimaryKey) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("dw.appendPrimaryTable"));
                    }
                }
                seq.add(r);
                System.arraycopy(vals, 0, lastValues, 0, cmpLen);
                ++recCount;
            }
            data = cursor.fetch(ICursor.FETCHCOUNT);
        }
        if (seq.length() > 0) {
            this._$1(seq, 1, seq.length());
        }
    }

    private void _$1(ICursor cursor) throws IOException {
        int recCount = 0;
        int sortedColCount = this._$6.length;
        Object[] tableMaxValues = this.maxValues;
        Object[] lastValues = new Object[sortedColCount];
        Sequence seq = new Sequence(MIN_BLOCK_RECORD_COUNT);
        Sequence data = cursor.fetch(ICursor.FETCHCOUNT);
        Object[] vals = new Object[sortedColCount];
        int[] findex = this.getSortedColIndex();
        while (data != null && data.length() > 0) {
            int len = data.length();
            for (int i = 1; i <= len; ++i) {
                BaseRecord r = (BaseRecord)data.get(i);
                for (int f = 0; f < sortedColCount; ++f) {
                    vals[f] = r.getNormalFieldValue(findex[f]);
                }
                if (recCount >= MAX_BLOCK_RECORD_COUNT) {
                    this._$1(seq, 1, MAX_BLOCK_RECORD_COUNT / 2);
                    seq = seq.get(MAX_BLOCK_RECORD_COUNT / 2 + 1, seq.length() + 1);
                    recCount = seq.length();
                } else if (recCount >= MIN_BLOCK_RECORD_COUNT) {
                    boolean doAppend = false;
                    if (0 != Variant.compareArrays(lastValues, vals, sortedColCount)) {
                        doAppend = true;
                    }
                    if (doAppend) {
                        this._$1(seq, 1, seq.length());
                        seq.clear();
                        recCount = 0;
                    }
                }
                if (this.isSorted) {
                    if (tableMaxValues != null) {
                        int cmp = Variant.compareArrays(vals, tableMaxValues, sortedColCount);
                        if (cmp < 0) {
                            this.hasPrimaryKey = false;
                            this.isSorted = false;
                            this.maxValues = null;
                        } else if (cmp == 0) {
                            if (this.hasPrimaryKey) {
                                this.hasPrimaryKey = false;
                            }
                        } else {
                            System.arraycopy(vals, 0, tableMaxValues, 0, sortedColCount);
                        }
                        if (this.tableList.size() > 0 && !this.hasPrimaryKey) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("dw.appendPrimaryTable"));
                        }
                    } else {
                        this.maxValues = new Object[sortedColCount];
                        tableMaxValues = this.maxValues;
                        System.arraycopy(vals, 0, tableMaxValues, 0, sortedColCount);
                    }
                }
                seq.add(r);
                System.arraycopy(vals, 0, lastValues, 0, sortedColCount);
                ++recCount;
            }
            data = cursor.fetch(ICursor.FETCHCOUNT);
        }
        if (seq.length() > 0) {
            this._$1(seq, 1, seq.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1(ICursor cursor, String opt) throws IOException {
        if (!this.isSingleTable()) {
            throw new RQException("'append@m' is unimplemented in annex table!");
        }
        Sequence data = cursor.peek(ICursor.FETCHCOUNT);
        if (data == null || data.length() <= 0) {
            return;
        }
        DataStruct ds = data.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        ColumnMetaData[] columns = this._$8;
        int colCount = columns.length;
        if (colCount != ds.getFieldCount()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        for (int i = 0; i < colCount; ++i) {
            if (ds.getFieldName(i).equals(columns[i].getColName())) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        ColComTable groupTable = (ColComTable)this.getGroupTable();
        File srcFile = groupTable.getFile();
        File tmpFile = File.createTempFile("tmpdata", "", srcFile.getParentFile());
        ColComTable tmpGroupTable = null;
        try {
            Context ctx = new Context();
            tmpGroupTable = new ColComTable(tmpFile, groupTable);
            PhyTable baseTable = tmpGroupTable.getBaseTable();
            int dcount = this._$6.length;
            Expression[] mergeExps = new Expression[dcount];
            for (int i = 0; i < dcount; ++i) {
                mergeExps[i] = new Expression(this._$6[i].getColName());
            }
            Cursor srcCursor = new Cursor(this);
            ICursor[] cursors = new ICursor[]{srcCursor, cursor};
            MergesCursor mergeCursor = new MergesCursor(cursors, mergeExps, ctx);
            String[] indexNames = baseTable.indexNames;
            String[] cuboids = baseTable.cuboids;
            baseTable.deleteIndex(null);
            baseTable.deleteCuboid(null);
            baseTable.append(mergeCursor);
            baseTable.appendCache();
            baseTable.indexNames = indexNames;
            baseTable.cuboids = cuboids;
            tmpGroupTable._$3();
            baseTable.close();
            groupTable.raf.close();
            if (!groupTable.file.delete()) {
                tmpFile.delete();
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.needCloseTable"));
            }
            tmpFile.renameTo(groupTable.file);
            groupTable.reopen();
            groupTable.baseTable.resetIndex(ctx);
            groupTable.baseTable.resetCuboid(ctx);
        }
        finally {
            if (tmpGroupTable != null) {
                tmpGroupTable.raf.close();
            }
        }
    }

    @Override
    public void append(ICursor cursor, String opt) throws IOException {
        if (opt != null && opt.indexOf(119) != -1) {
            int[] keys = this.getDataStruct().getPKIndex();
            int deleteField = this.getDeleteFieldIndex(null, null);
            cursor = new UpdateIdCursor(cursor, keys, deleteField);
        }
        if (this.isSorted && opt != null) {
            if (opt.indexOf(121) != -1) {
                Sequence data = cursor.fetch();
                ColPhyTable ctmd = (ColPhyTable)this.getSupplementTable(false);
                if (ctmd == null) {
                    this._$3(data);
                } else {
                    ctmd._$3(data);
                }
            } else if (opt.indexOf(97) != -1) {
                ColPhyTable ctmd = (ColPhyTable)this.getSupplementTable(true);
                ctmd._$1(cursor, opt);
            } else if (opt.indexOf(109) != -1) {
                this._$1(cursor, opt);
            } else {
                this.append(cursor);
                if (opt.indexOf(105) != -1) {
                    this.appendCache();
                }
            }
        } else if (opt != null) {
            if (opt.indexOf(121) != -1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            this.append(cursor);
            if (opt.indexOf(105) != -1) {
                this.appendCache();
            }
        } else {
            this.append(cursor);
        }
    }

    @Override
    public void append(ICursor cursor) throws IOException {
        this.getGroupTable().checkWritable();
        if (cursor == null) {
            return;
        }
        Sequence data = cursor.peek(MIN_BLOCK_RECORD_COUNT);
        if (data == null || data.length() <= 0) {
            return;
        }
        DataStruct ds = data.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        ColumnMetaData[] allColumns = this.parent == null ? this._$8 : this._$7;
        int count = allColumns.length;
        for (int i = 0; i < count; ++i) {
            if (ds.getFieldName(i).equals(allColumns[i].getColName())) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        if (data.length() < MIN_BLOCK_RECORD_COUNT) {
            if (this.appendCache == null) {
                this.appendCache = data;
            } else {
                this.appendCache.addAll(data);
            }
            data = null;
            cursor.close();
            if (this.appendCache.length() >= MIN_BLOCK_RECORD_COUNT) {
                this.appendCache();
            }
            return;
        }
        if (this.appendCache != null) {
            ICursor[] cursorArray = new ICursor[]{new MemoryCursor(this.appendCache), cursor};
            cursor = new ConjxCursor(cursorArray);
            this.appendCache = null;
        }
        this.prepareAppend();
        if (this.parent != null) {
            this.parent.appendCache();
            this._$3(cursor);
        } else if (this._$6 == null) {
            this._$4(cursor);
        } else if (this.getSegmentCol() == null) {
            this._$1(cursor);
        } else {
            this._$2(cursor);
        }
        this.finishAppend();
    }

    protected void appendSegmentBlock(int recordCount) throws IOException {
        ++this.dataBlockCount;
        this.totalRecordCount += (long)recordCount;
        this.segmentWriter.writeInt32(recordCount);
    }

    public int getColumnFilterPriority(ColumnMetaData col) {
        if (this._$6 != null) {
            int len = this._$6.length;
            for (int i = 0; i < len; ++i) {
                if (this._$6[i] != col) continue;
                return i;
            }
            return len;
        }
        return 0;
    }

    @Override
    public ICursor cursor() {
        ComTable groupTable = this.getGroupTable();
        groupTable.checkReadable();
        ICursor cs = this.parent != null ? JoinTableCursor.createAnnexCursor(this) : new Cursor(this);
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd == null) {
            return cs;
        }
        ICursor cs2 = tmd.cursor();
        return this._$1(cs, cs2);
    }

    @Override
    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, String opt, Context ctx) {
        PhyTable tmd;
        ComTable groupTable = this.getGroupTable();
        groupTable.checkReadable();
        ICursor cs = JoinTableCursor.createAnnexCursor(this, exps, fields, filter, fkNames, codes, ctx);
        if (cs == null) {
            cs = new Cursor(this, exps, fields, filter, fkNames, codes, opts, ctx);
        }
        if ((tmd = this.getSupplementTable(false)) == null) {
            return cs;
        }
        ICursor cs2 = tmd.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
        return this._$1(cs, cs2);
    }

    public IFilter getFirstDimFilter(Expression exp, Context ctx) {
        Object obj = Cursor.parseFilter(this, exp, ctx);
        if (obj instanceof IFilter) {
            ColumnMetaData firstDim = this.getSortedColumns()[0];
            IFilter filter = (IFilter)obj;
            if (!filter.isMultiFieldOr() && filter.getColumn() == firstDim) {
                return filter;
            }
            return null;
        }
        if (obj instanceof ArrayList) {
            ColumnMetaData firstDim = this.getSortedColumns()[0];
            ArrayList list = (ArrayList)obj;
            for (Object f : list) {
                IFilter filter;
                if (!(f instanceof IFilter) || (filter = (IFilter)f).isMultiFieldOr() || filter.getColumn() != firstDim) continue;
                return filter;
            }
        }
        return null;
    }

    public IFilter[] getSortedFieldFilters(Expression exp, Context ctx) {
        Object obj = Cursor.parseFilter(this, exp, ctx);
        if (obj instanceof IFilter) {
            IFilter filter = (IFilter)obj;
            if (filter.isMultiFieldOr()) {
                return null;
            }
            ColumnMetaData column = filter.getColumn();
            if (column == null || !column.hasMaxMinValues()) {
                return null;
            }
            return new IFilter[]{filter};
        }
        if (obj instanceof ArrayList) {
            ArrayList list = (ArrayList)obj;
            ArrayList<IFilter> filterList = new ArrayList<IFilter>();
            for (Object f : list) {
                ColumnMetaData column;
                IFilter filter;
                if (!(f instanceof IFilter) || (filter = (IFilter)f).isMultiFieldOr() || (column = filter.getColumn()) == null || !column.hasMaxMinValues()) continue;
                filterList.add(filter);
            }
            if (filterList.size() > 0) {
                Object[] filters = new IFilter[filterList.size()];
                filterList.toArray(filters);
                Arrays.sort(filters);
                return filters;
            }
            return null;
        }
        return null;
    }

    @Override
    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int pathCount, String opt, Context ctx) {
        ICursor[] cursors;
        if (pathCount < 2) {
            return this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
        }
        PhyTable tmd = this.getSupplementTable(false);
        int blockCount = this.getDataBlockCount();
        if (blockCount == 0) {
            if (tmd == null) {
                return new MemoryCursor(null);
            }
            return tmd.cursor(exps, fields, filter, fkNames, codes, opts, pathCount, opt, ctx);
        }
        IFilter[] filters = null;
        if (filter != null && this.parent == null && (opt == null || opt.indexOf(119) == -1)) {
            filters = this.getSortedFieldFilters(filter, ctx);
        }
        if (filters == null) {
            int avg = blockCount / pathCount;
            if (avg < 1) {
                avg = 1;
                pathCount = blockCount;
            }
            int mod = blockCount % pathCount;
            cursors = new ICursor[pathCount];
            int start = 0;
            for (int i = 0; i < pathCount; ++i) {
                ICursor cursor;
                int end = start + avg;
                if (i < mod) {
                    ++end;
                }
                if (filter != null) {
                    filter = filter.newExpression(ctx);
                }
                if ((cursor = JoinTableCursor.createAnnexCursor(this, exps, fields, filter, fkNames, codes, ctx)) == null) {
                    cursor = new Cursor(this, exps, fields, filter, fkNames, codes, opts, ctx);
                }
                if (cursor instanceof Cursor) {
                    ((Cursor)cursor).setSegment(start, end);
                } else {
                    ((JoinTableCursor)cursor).setSegment(start, end);
                }
                cursors[i] = cursor;
                start = end;
            }
        } else {
            IntArrayList list = new IntArrayList();
            int filterCount = filters.length;
            ObjectReader[] readers = new ObjectReader[filterCount];
            for (int f = 0; f < filterCount; ++f) {
                ColumnMetaData column = filters[f].getColumn();
                readers[f] = column.getSegmentReader();
            }
            try {
                for (int i = 0; i < blockCount; ++i) {
                    boolean match = true;
                    for (int f = 0; f < filterCount; ++f) {
                        readers[f].readLong40();
                        Object minValue = readers[f].readObject();
                        Object maxValue = readers[f].readObject();
                        readers[f].skipObject();
                        if (!match || filters[f].match(minValue, maxValue)) continue;
                        match = false;
                    }
                    if (!match) continue;
                    list.addInt(i);
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            blockCount = list.size();
            if (blockCount == 0) {
                return new MemoryCursor(null);
            }
            int avg = blockCount / pathCount;
            if (avg < 1) {
                cursors = new ICursor[blockCount];
                for (int i = 0; i < blockCount; ++i) {
                    filter = filter.newExpression(ctx);
                    Cursor cursor = new Cursor(this, exps, fields, filter, fkNames, codes, opts, ctx);
                    int b = list.getInt(i);
                    cursor.setSegment(b, b + 1);
                    cursors[i] = cursor;
                }
            } else {
                int mod = blockCount % pathCount;
                cursors = new ICursor[pathCount];
                int start = 0;
                for (int i = 0; i < pathCount; ++i) {
                    int end = start + avg;
                    if (i < mod) {
                        ++end;
                    }
                    filter = filter.newExpression(ctx);
                    Cursor cursor = new Cursor(this, exps, fields, filter, fkNames, codes, opts, ctx);
                    cursor.setSegment(list.getInt(start), list.getInt(end - 1) + 1);
                    cursors[i] = cursor;
                    start = end;
                }
            }
        }
        MultipathCursors mcs = new MultipathCursors(cursors, ctx);
        if (tmd == null) {
            return mcs;
        }
        String[] sortFields = ((IDWCursor)cursors[0]).getSortFields();
        if (sortFields != null) {
            ICursor cs2 = tmd.cursor(exps, fields, filter, fkNames, codes, opts, mcs, null, ctx);
            return this._$1(mcs, (MultipathCursors)cs2, sortFields);
        }
        ICursor cs2 = tmd.cursor(exps, fields, filter, fkNames, codes, opts, pathCount, opt, ctx);
        return this._$1(mcs, cs2);
    }

    @Override
    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int segSeq, int segCount, String opt, Context ctx) {
        IDWCursor cursor;
        this.getGroupTable().checkReadable();
        if (filter != null) {
            filter = filter.newExpression(ctx);
        }
        if ((cursor = (IDWCursor)JoinTableCursor.createAnnexCursor(this, exps, fields, filter, fkNames, codes, ctx)) == null) {
            cursor = new Cursor(this, exps, fields, filter, fkNames, codes, opts, ctx);
        }
        if (segCount < 2) {
            return cursor;
        }
        int startBlock = 0;
        int endBlock = -1;
        int avg = this.dataBlockCount / segCount;
        if (avg < 1) {
            if (segSeq <= this.dataBlockCount) {
                startBlock = segSeq - 1;
                endBlock = segSeq;
            }
        } else if (segSeq > 1) {
            endBlock = segSeq * avg;
            startBlock = endBlock - avg;
            int mod = this.dataBlockCount % segCount;
            int n = mod - (segCount - segSeq);
            if (n > 0) {
                endBlock += n;
                startBlock += n - 1;
            }
        } else {
            endBlock = avg;
        }
        cursor.setSegment(startBlock, endBlock);
        return cursor;
    }

    public static Sequence fetchToValue(IDWCursor cursor, String[] names, Object[] vals) {
        Sequence seq = cursor.getStartBlockData(ICursor.FETCHCOUNT);
        if (seq == null || seq.length() == 0) {
            return null;
        }
        int fcount = names.length;
        int[] findex = new int[fcount];
        DataStruct ds = ((BaseRecord)seq.getMem(1)).dataStruct();
        for (int f = 0; f < fcount; ++f) {
            findex[f] = ds.getFieldIndex(names[f]);
            if (findex[f] != -1) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(names[f] + mm.getMessage("ds.fieldNotExist"));
        }
        Sequence result = null;
        Object[] curVals = new Object[fcount];
        do {
            int len = seq.length();
            for (int i = 1; i <= len; ++i) {
                BaseRecord r = (BaseRecord)seq.getMem(i);
                for (int f = 0; f < fcount; ++f) {
                    curVals[f] = r.getNormalFieldValue(findex[f]);
                }
                if (Variant.compareArrays(curVals, vals) < 0) continue;
                if (i == 1) {
                    cursor.setCache(seq);
                    return result;
                }
                if (result == null) {
                    cursor.setCache(seq.split(i));
                    result = seq;
                } else {
                    cursor.setCache(seq.split(i));
                    result.addAll(seq);
                }
                return result;
            }
            if (result == null) {
                result = seq;
                continue;
            }
            result.addAll(seq);
        } while ((seq = cursor.getStartBlockData(ICursor.FETCHCOUNT)) != null && seq.length() != 0);
        return result;
    }

    @Override
    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, MultipathCursors mcs, String opt, Context ctx) {
        ICursor cs2;
        ColumnMetaData[] sortedCols;
        String[] dimFields;
        this.getGroupTable().checkReadable();
        ICursor[] srcCursors = mcs.getParallelCursors();
        int segCount = srcCursors.length;
        if (segCount == 1) {
            ICursor cs = this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
            ICursor[] cursors = new ICursor[]{cs};
            return new MultipathCursors(cursors, ctx);
        }
        Object[][] minValues = new Object[segCount][];
        int fcount = -1;
        for (int i = 1; i < segCount; ++i) {
            minValues[i] = srcCursors[i].getSegmentStartValues(opt);
            if (minValues[i] == null) continue;
            if (fcount == -1) {
                fcount = minValues[i].length;
                continue;
            }
            if (fcount == minValues[i].length) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
        }
        if (fcount == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
        }
        if (opt != null && opt.indexOf(107) != -1) {
            String[] keys = this.getAllKeyColNames();
            if (keys == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
            }
            fcount = 1;
            dimFields = new String[]{keys[0]};
            sortedCols = new ColumnMetaData[]{this.getColumn(keys[0])};
        } else {
            sortedCols = this.getAllSortedColumns();
            if (sortedCols.length < fcount) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
            }
            dimFields = new String[fcount];
            for (int f = 0; f < fcount; ++f) {
                dimFields[f] = sortedCols[f].getColName();
            }
        }
        int blockCount = this.getDataBlockCount();
        ICursor[] cursors = new ICursor[segCount];
        int startBlock = 0;
        int currentBlock = 0;
        int[] appendSegs = new int[segCount];
        for (int s = 0; s < segCount; ++s) {
            appendSegs[s] = -1;
        }
        try {
            ObjectReader[] readers = new ObjectReader[fcount];
            Object[] blockMinVals = new Object[fcount];
            Object[] blockMaxVals = new Object[fcount];
            Object[] prevMaxVals = new Object[fcount];
            for (int f = 0; f < fcount; ++f) {
                readers[f] = sortedCols[f].getSegmentReader();
                readers[f].readLong40();
                readers[f].skipObject();
                blockMaxVals[f] = readers[f].readObject();
                blockMinVals[f] = readers[f].readObject();
            }
            block6: for (int s = 0; s < segCount; ++s) {
                if (filter != null) {
                    filter = filter.newExpression(ctx);
                }
                Object[] nextMinValue = null;
                for (int nextSeg = s + 1; nextSeg < segCount && (nextMinValue = minValues[nextSeg]) == null; ++nextSeg) {
                }
                if (nextMinValue == null) {
                    cursors[s] = this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
                    ((IDWCursor)cursors[s]).setSegment(startBlock, blockCount);
                    startBlock = blockCount;
                    continue;
                }
                while (currentBlock < blockCount) {
                    int cmp = Variant.compareArrays(blockMinVals, nextMinValue);
                    if (cmp > 0) {
                        cursors[s] = this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
                        if (currentBlock > 0) {
                            ((IDWCursor)cursors[s]).setSegment(startBlock, currentBlock - 1);
                            startBlock = currentBlock - 1;
                            appendSegs[nextSeg] = s;
                            continue block6;
                        }
                        ((IDWCursor)cursors[s]).setSegment(0, 0);
                        continue block6;
                    }
                    if (cmp == 0) {
                        cursors[s] = this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
                        if (currentBlock > 0 && Variant.compareArrays(prevMaxVals, nextMinValue) >= 0) {
                            ((IDWCursor)cursors[s]).setSegment(startBlock, currentBlock - 1);
                            startBlock = currentBlock - 1;
                            appendSegs[nextSeg] = s;
                            continue block6;
                        }
                        ((IDWCursor)cursors[s]).setSegment(startBlock, currentBlock);
                        startBlock = currentBlock;
                        continue block6;
                    }
                    if (++currentBlock >= blockCount) continue;
                    Object[] tmp = prevMaxVals;
                    prevMaxVals = blockMaxVals;
                    blockMaxVals = tmp;
                    for (int f = 0; f < fcount; ++f) {
                        readers[f].readLong40();
                        readers[f].skipObject();
                        blockMaxVals[f] = readers[f].readObject();
                        blockMinVals[f] = readers[f].readObject();
                    }
                }
                cursors[s] = this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
                if (s + 1 == segCount) {
                    ((IDWCursor)cursors[s]).setSegment(startBlock, blockCount);
                    startBlock = blockCount;
                    continue;
                }
                ((IDWCursor)cursors[s]).setSegment(startBlock, blockCount - 1);
                startBlock = blockCount - 1;
                appendSegs[nextSeg] = s;
            }
            for (int i = segCount - 1; i > 0; --i) {
                if (appendSegs[i] == -1) continue;
                Sequence seq = ColPhyTable.fetchToValue((IDWCursor)cursors[i], dimFields, minValues[i]);
                ((IDWCursor)cursors[appendSegs[i]]).setAppendData(seq);
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        MultipathCursors result = new MultipathCursors(cursors, ctx);
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd == null) {
            return result;
        }
        String[] sortFields = ((IDWCursor)cursors[0]).getSortFields();
        if (sortFields != null) {
            cs2 = tmd.cursor(exps, fields, filter, fkNames, codes, opts, result, null, ctx);
            return this._$1(result, (MultipathCursors)cs2, sortFields);
        }
        cs2 = tmd.cursor(exps, fields, filter, fkNames, codes, opts, mcs, null, ctx);
        return this._$1(result, cs2);
    }

    private Sequence _$1(PhyTable stmd, Sequence data, String opt) throws IOException {
        Object r;
        DataStruct ds;
        boolean isUpdate = true;
        boolean isInsert = true;
        boolean isSave = true;
        Sequence result = null;
        if (opt != null) {
            if (opt.indexOf(105) != -1) {
                isUpdate = false;
            }
            if (opt.indexOf(117) != -1) {
                if (!isUpdate) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(opt + mm.getMessage("engine.optConflict"));
                }
                isInsert = false;
            }
            if (opt.indexOf(110) != -1) {
                result = new Sequence();
            }
            if (opt.indexOf(109) != -1) {
                isSave = false;
            }
        }
        if ((ds = data.dataStruct()) == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        if (!ds.isCompatible(this.ds)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        data.sortFields(this.getAllSortedColNames());
        this.appendCache();
        ColumnMetaData[] columns = this.getAllSortedColumns();
        int keyCount = columns.length;
        int[] keyIndex = new int[keyCount];
        for (int k = 0; k < keyCount; ++k) {
            keyIndex[k] = ds.getFieldIndex(columns[k].getColName());
            if (keyIndex[k] >= 0) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(columns[k].getColName() + mm.getMessage("ds.fieldNotExist"));
        }
        boolean isPrimaryTable = this.parent == null;
        int len = data.length();
        long[] seqs = new long[len + 1];
        int[] block = new int[len + 1];
        long[] recNum = null;
        int[] temp = new int[1];
        if (isPrimaryTable) {
            BaseRecord r2;
            int i;
            IlIIIIIlIlIlllIl searcher = new IlIIIIIlIlIlllIl(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (i = 1; i <= len; ++i) {
                    r2 = (BaseRecord)data.getMem(i);
                    seqs[i] = searcher.findNext(r2.getFieldValue(k));
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                for (i = 1; i <= len; ++i) {
                    r2 = (BaseRecord)data.getMem(i);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = r2.getFieldValue(keyIndex[k]);
                    }
                    seqs[i] = searcher.findNext(keyValues);
                }
            }
        } else {
            recNum = new long[len + 1];
            ColPhyTable baseTable = (ColPhyTable)this.groupTable.baseTable;
            IlIIIIIlIlIlllIl baseSearcher = new IlIIIIIlIlIlllIl(baseTable);
            IlIllllllIIllIIl searcher = new IlIllllllIIllIIl(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (int i = 1; i <= len; ++i) {
                    r = (BaseRecord)data.getMem(i);
                    seqs[i] = searcher.findNext(((BaseRecord)r).getFieldValue(k), temp);
                    block[i] = temp[0];
                    if (seqs[i] < 0L) {
                        long seq = baseSearcher.findNext(((BaseRecord)r).getFieldValue(k));
                        if (seq > 0L) {
                            recNum[i] = seq;
                            continue;
                        }
                        if (baseSearcher._$1()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(((BaseRecord)r).toString(null) + mm.getMessage("grouptable.invalidData"));
                        }
                        recNum[i] = 0L;
                        continue;
                    }
                    recNum[i] = searcher._$1();
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                int baseKeyCount = this.sortedColStartIndex;
                Object[] baseKeyValues = new Object[baseKeyCount];
                for (int i = 1; i <= len; ++i) {
                    BaseRecord r3 = (BaseRecord)data.getMem(i);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = r3.getFieldValue(keyIndex[k]);
                        if (k >= baseKeyCount) continue;
                        baseKeyValues[k] = keyValues[k];
                    }
                    seqs[i] = searcher.findNext(keyValues, temp);
                    block[i] = temp[0];
                    if (seqs[i] < 0L || block[i] > 0) {
                        long seq = baseSearcher.findNext(baseKeyValues);
                        if (seq > 0L) {
                            recNum[i] = seq;
                            continue;
                        }
                        if (baseSearcher._$1()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(r3.toString(null) + mm.getMessage("grouptable.invalidData"));
                        }
                        recNum[i] = 0L;
                        continue;
                    }
                    recNum[i] = searcher._$1();
                }
            }
        }
        Sequence append = new Sequence();
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        boolean needUpdateSubTable = false;
        if (modifyRecords == null) {
            this.modifyRecords = modifyRecords = new ArrayList(len);
            for (int i = 1; i <= len; ++i) {
                BaseRecord sr = (BaseRecord)data.getMem(i);
                if (seqs[i] > 0L) {
                    if (!isUpdate) continue;
                    r = new ModifyRecord(seqs[i], 0, sr.toRecord());
                    modifyRecords.add((ModifyRecord)r);
                    if (result == null) continue;
                    result.add(sr);
                    continue;
                }
                append.add(sr);
            }
        } else {
            int srcLen = modifyRecords.size();
            ArrayList<ModifyRecord> tmp = new ArrayList<ModifyRecord>(len + srcLen);
            int s = 0;
            int t = 1;
            while (s < srcLen && t <= len) {
                ModifyRecord mr = modifyRecords.get(s);
                long seq1 = mr.getRecordSeq();
                long seq2 = seqs[t];
                if (seq2 > 0L) {
                    if (seq1 < seq2) {
                        ++s;
                        tmp.add(mr);
                        continue;
                    }
                    if (seq1 == seq2) {
                        if (mr.getState() == 1) {
                            ++s;
                            tmp.add(mr);
                            continue;
                        }
                        if (mr.getState() == 0 && isUpdate || mr.getState() == -1 && isInsert) {
                            BaseRecord sr = (BaseRecord)data.getMem(t);
                            mr.setRecord(sr.toRecord(), 0);
                            if (result != null) {
                                result.add(sr);
                            }
                        }
                        ++s;
                        ++t;
                        tmp.add(mr);
                        continue;
                    }
                    if (isUpdate) {
                        BaseRecord sr = (BaseRecord)data.getMem(t);
                        mr = new ModifyRecord(seq2, 0, sr.toRecord());
                        tmp.add(mr);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                    ++t;
                    continue;
                }
                if (seq1 < (seq2 = -seq2)) {
                    ++s;
                    tmp.add(mr);
                    continue;
                }
                if (seq1 == seq2) {
                    if (mr.getState() == 1) {
                        int cmp = mr.getRecord().compare((BaseRecord)data.getMem(t), keyIndex);
                        if (cmp < 0) {
                            ++s;
                            tmp.add(mr);
                            continue;
                        }
                        if (cmp == 0) {
                            if (isUpdate) {
                                BaseRecord sr = (BaseRecord)data.getMem(t);
                                mr.setRecord(sr.toRecord());
                                if (result != null) {
                                    result.add(sr);
                                }
                            }
                            tmp.add(mr);
                            ++s;
                            ++t;
                            continue;
                        }
                        append.add(data.getMem(t));
                        ++t;
                        continue;
                    }
                    append.add(data.getMem(t));
                    ++t;
                    continue;
                }
                append.add(data.getMem(t));
                ++t;
            }
            while (s < srcLen) {
                tmp.add(modifyRecords.get(s));
                ++s;
            }
            while (t <= len) {
                BaseRecord sr = (BaseRecord)data.getMem(t);
                if (seqs[t] > 0L) {
                    if (isUpdate) {
                        ModifyRecord r4 = new ModifyRecord(seqs[t], 0, sr.toRecord());
                        tmp.add(r4);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                } else {
                    append.add(sr);
                }
                ++t;
            }
            this.modifyRecords = tmp;
            if (srcLen != tmp.size()) {
                needUpdateSubTable = true;
            }
        }
        if (!isPrimaryTable) {
            this._$1(this.parent.getModifyRecords());
            for (ModifyRecord r5 : modifyRecords) {
                if (r5.getState() != 1 || r5.getParentRecordSeq() != 0L) continue;
                this.modifyRecords = null;
                this.modifyRecords = this.getModifyRecords();
                MessageManager mm = EngineMessage.get();
                throw new RQException(r5.getRecord().toString(null) + mm.getMessage("grouptable.invalidData"));
            }
        }
        if (isSave) {
            this.saveModifyRecords();
        }
        if (isPrimaryTable && needUpdateSubTable) {
            ArrayList<PhyTable> tableList = this.getTableList();
            int size = tableList.size();
            for (int i = 0; i < size; ++i) {
                ColPhyTable t = (ColPhyTable)tableList.get(i);
                boolean needSave = t._$1(modifyRecords);
                if (!needSave) continue;
                t.saveModifyRecords();
            }
        }
        if (append.length() > 0) {
            Sequence seq = stmd.update(append, opt);
            if (result != null) {
                result.addAll(seq);
            }
        }
        if (isSave) {
            this.groupTable._$3();
        }
        return result;
    }

    @Override
    public Sequence update(Sequence data, String opt) throws IOException {
        Object r;
        long totalRecordCount;
        if (data != null) {
            data = new Sequence(data);
        }
        if (!this.hasPrimaryKey) {
            boolean hasY;
            boolean bl = hasY = opt != null && opt.indexOf(121) != -1;
            if (hasY) {
                this._$3(data);
            } else {
                this.append(new MemoryCursor(data));
            }
            return data;
        }
        ComTable groupTable = this.getGroupTable();
        groupTable.checkWritable();
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd != null) {
            return this._$1(tmd, data, opt);
        }
        boolean isInsert = true;
        boolean isUpdate = true;
        Sequence result = null;
        if (opt != null) {
            if (opt.indexOf(121) != -1) {
                return this._$1(data, opt);
            }
            if (opt.indexOf(105) != -1) {
                isUpdate = false;
            }
            if (opt.indexOf(117) != -1) {
                if (!isUpdate) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(opt + mm.getMessage("engine.optConflict"));
                }
                isInsert = false;
            }
            if (opt.indexOf(110) != -1) {
                result = new Sequence();
            }
        }
        if ((totalRecordCount = this.totalRecordCount) == 0L) {
            if (isInsert) {
                MemoryCursor cursor = new MemoryCursor(data);
                this.append(cursor);
                this.appendCache();
                if (result != null) {
                    result.addAll(data);
                }
            }
            return result;
        }
        DataStruct ds = data.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        if (!ds.isCompatible(this.ds)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        data.sortFields(this.getAllSortedColNames());
        this.appendCache();
        ColumnMetaData[] columns = this.getAllSortedColumns();
        int keyCount = columns.length;
        int[] keyIndex = new int[keyCount];
        for (int k = 0; k < keyCount; ++k) {
            keyIndex[k] = ds.getFieldIndex(columns[k].getColName());
            if (keyIndex[k] >= 0) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(columns[k].getColName() + mm.getMessage("ds.fieldNotExist"));
        }
        boolean isPrimaryTable = this.parent == null;
        int len = data.length();
        long[] seqs = new long[len + 1];
        int[] block = new int[len + 1];
        long[] recNum = null;
        int[] temp = new int[1];
        if (isPrimaryTable) {
            BaseRecord r2;
            int i;
            IlIIIIIlIlIlllIl searcher = new IlIIIIIlIlIlllIl(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (i = 1; i <= len; ++i) {
                    r2 = (BaseRecord)data.getMem(i);
                    seqs[i] = searcher.findNext(r2.getFieldValue(k));
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                for (i = 1; i <= len; ++i) {
                    r2 = (BaseRecord)data.getMem(i);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = r2.getFieldValue(keyIndex[k]);
                    }
                    seqs[i] = searcher.findNext(keyValues);
                }
            }
        } else {
            recNum = new long[len + 1];
            ColPhyTable baseTable = (ColPhyTable)this.groupTable.baseTable;
            IlIIIIIlIlIlllIl baseSearcher = new IlIIIIIlIlIlllIl(baseTable);
            IlIllllllIIllIIl searcher = new IlIllllllIIllIIl(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (int i = 1; i <= len; ++i) {
                    BaseRecord r3 = (BaseRecord)data.getMem(i);
                    seqs[i] = searcher.findNext(r3.getFieldValue(k), temp);
                    block[i] = temp[0];
                    if (seqs[i] < 0L) {
                        long seq = baseSearcher.findNext(r3.getFieldValue(k));
                        if (seq > 0L) {
                            recNum[i] = seq;
                            continue;
                        }
                        if (baseSearcher._$1()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(r3.toString(null) + mm.getMessage("grouptable.invalidData"));
                        }
                        recNum[i] = 0L;
                        continue;
                    }
                    recNum[i] = searcher._$1();
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                int baseKeyCount = this.sortedColStartIndex;
                Object[] baseKeyValues = new Object[baseKeyCount];
                for (int i = 1; i <= len; ++i) {
                    r = (BaseRecord)data.getMem(i);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = ((BaseRecord)r).getFieldValue(keyIndex[k]);
                        if (k >= baseKeyCount) continue;
                        baseKeyValues[k] = keyValues[k];
                    }
                    seqs[i] = searcher.findNext(keyValues, temp);
                    block[i] = temp[0];
                    if (seqs[i] < 0L || block[i] > 0) {
                        long seq = baseSearcher.findNext(baseKeyValues);
                        if (seq > 0L) {
                            recNum[i] = seq;
                            continue;
                        }
                        if (baseSearcher._$1()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(((BaseRecord)r).toString(null) + mm.getMessage("grouptable.invalidData"));
                        }
                        recNum[i] = 0L;
                        continue;
                    }
                    recNum[i] = searcher._$1();
                }
            }
        }
        Sequence append = new Sequence();
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        boolean needUpdateSubTable = false;
        if (modifyRecords == null) {
            this.modifyRecords = modifyRecords = new ArrayList(len);
            for (int i = 1; i <= len; ++i) {
                BaseRecord sr = (BaseRecord)data.getMem(i);
                if (seqs[i] > 0L) {
                    if (!isUpdate) continue;
                    ModifyRecord r4 = new ModifyRecord(seqs[i], 0, sr.toRecord());
                    modifyRecords.add(r4);
                    if (result == null) continue;
                    result.add(sr);
                    continue;
                }
                if (!isInsert) continue;
                long seq = -seqs[i];
                if (seq <= totalRecordCount || block[i] > 0) {
                    r = new ModifyRecord(seq, 1, sr.toRecord());
                    ((ModifyRecord)r).setBlock(block[i]);
                    if (!isPrimaryTable) {
                        ((ModifyRecord)r).setParentRecordSeq(recNum[i]);
                    }
                    modifyRecords.add((ModifyRecord)r);
                } else {
                    append.add(sr);
                }
                if (result == null) continue;
                result.add(sr);
            }
        } else {
            int srcLen = modifyRecords.size();
            ArrayList<ModifyRecord> tmp = new ArrayList<ModifyRecord>(len + srcLen);
            int s = 0;
            int t = 1;
            while (s < srcLen && t <= len) {
                ModifyRecord mr = modifyRecords.get(s);
                long seq1 = mr.getRecordSeq();
                long seq2 = seqs[t];
                if (seq2 > 0L) {
                    if (seq1 < seq2) {
                        ++s;
                        tmp.add(mr);
                        continue;
                    }
                    if (seq1 == seq2) {
                        if (mr.getState() == 1) {
                            ++s;
                            tmp.add(mr);
                            continue;
                        }
                        if (mr.getState() == 0 && isUpdate || mr.getState() == -1 && isInsert) {
                            BaseRecord sr = (BaseRecord)data.getMem(t);
                            mr.setRecord(sr.toRecord(), 0);
                            if (result != null) {
                                result.add(sr);
                            }
                        }
                        ++s;
                        ++t;
                        tmp.add(mr);
                        continue;
                    }
                    if (isUpdate) {
                        BaseRecord sr = (BaseRecord)data.getMem(t);
                        mr = new ModifyRecord(seq2, 0, sr.toRecord());
                        tmp.add(mr);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                    ++t;
                    continue;
                }
                if (seq1 < (seq2 = -seq2)) {
                    ++s;
                    tmp.add(mr);
                    continue;
                }
                if (seq1 == seq2) {
                    if (mr.getState() == 1) {
                        BaseRecord sr;
                        int cmp = mr.getRecord().compare((BaseRecord)data.getMem(t), keyIndex);
                        if (cmp < 0) {
                            ++s;
                            tmp.add(mr);
                            continue;
                        }
                        if (cmp == 0) {
                            if (isUpdate) {
                                sr = (BaseRecord)data.getMem(t);
                                mr.setRecord(sr.toRecord());
                                if (result != null) {
                                    result.add(sr);
                                }
                            }
                            tmp.add(mr);
                            ++s;
                            ++t;
                            continue;
                        }
                        if (isInsert) {
                            sr = (BaseRecord)data.getMem(t);
                            mr = new ModifyRecord(seq2, 1, sr.toRecord());
                            mr.setBlock(block[t]);
                            if (!isPrimaryTable) {
                                mr.setParentRecordSeq(recNum[t]);
                            }
                            modifyRecords.add(mr);
                            tmp.add(mr);
                            if (result != null) {
                                result.add(sr);
                            }
                        }
                        ++t;
                        continue;
                    }
                    if (isInsert) {
                        BaseRecord sr = (BaseRecord)data.getMem(t);
                        mr = new ModifyRecord(seq2, 1, sr.toRecord());
                        mr.setBlock(block[t]);
                        if (!isPrimaryTable) {
                            mr.setParentRecordSeq(recNum[t]);
                        }
                        modifyRecords.add(mr);
                        tmp.add(mr);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                    ++t;
                    continue;
                }
                if (isInsert) {
                    BaseRecord sr = (BaseRecord)data.getMem(t);
                    mr = new ModifyRecord(seq2, 1, sr.toRecord());
                    mr.setBlock(block[t]);
                    if (!isPrimaryTable) {
                        mr.setParentRecordSeq(recNum[t]);
                    }
                    modifyRecords.add(mr);
                    tmp.add(mr);
                    if (result != null) {
                        result.add(sr);
                    }
                }
                ++t;
            }
            while (s < srcLen) {
                tmp.add(modifyRecords.get(s));
                ++s;
            }
            while (t <= len) {
                BaseRecord sr = (BaseRecord)data.getMem(t);
                if (seqs[t] > 0L) {
                    if (isUpdate) {
                        ModifyRecord r5 = new ModifyRecord(seqs[t], 0, sr.toRecord());
                        tmp.add(r5);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                } else if (isInsert) {
                    long seq = -seqs[t];
                    if (seq <= totalRecordCount) {
                        ModifyRecord r6 = new ModifyRecord(seq, 1, sr.toRecord());
                        r6.setBlock(block[t]);
                        if (!isPrimaryTable) {
                            r6.setParentRecordSeq(recNum[t]);
                        }
                        modifyRecords.add(r6);
                        tmp.add(r6);
                    } else {
                        append.add(sr);
                    }
                    if (result != null) {
                        result.add(sr);
                    }
                }
                ++t;
            }
            this.modifyRecords = tmp;
            if (srcLen != tmp.size()) {
                needUpdateSubTable = true;
            }
        }
        if (!isPrimaryTable) {
            this._$1(this.parent.getModifyRecords());
            for (ModifyRecord r7 : modifyRecords) {
                if (r7.getState() != 1 || r7.getParentRecordSeq() != 0L) continue;
                this.modifyRecords = null;
                this.modifyRecords = this.getModifyRecords();
                MessageManager mm = EngineMessage.get();
                throw new RQException(r7.getRecord().toString(null) + mm.getMessage("grouptable.invalidData"));
            }
        }
        this.saveModifyRecords();
        if (isPrimaryTable && needUpdateSubTable) {
            ArrayList<PhyTable> tableList = this.getTableList();
            int size = tableList.size();
            for (int i = 0; i < size; ++i) {
                ColPhyTable t = (ColPhyTable)tableList.get(i);
                boolean needSave = t._$1(modifyRecords);
                if (!needSave) continue;
                t.saveModifyRecords();
            }
        }
        if (append.length() > 0) {
            MemoryCursor cursor = new MemoryCursor(append);
            this.append(cursor);
            this.appendCache();
        } else {
            groupTable._$3();
        }
        return result;
    }

    private void _$3(Sequence data) throws IOException {
        if (data == null || data.length() == 0) {
            return;
        }
        DataStruct ds = data.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        if (!ds.isCompatible(this.ds)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        int len = data.length();
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        if (modifyRecords == null) {
            this.modifyRecords = modifyRecords = new ArrayList(len);
        }
        BaseRecord r1 = (BaseRecord)data.get(1);
        String[] pks = this.getAllSortedColNames();
        int keyCount = pks == null ? 0 : pks.length;
        int[] keyIndex = new int[keyCount];
        for (int i = 0; i < keyCount; ++i) {
            keyIndex[i] = ds.getFieldIndex(pks[i]);
        }
        if (keyCount > 0 && this.maxValues != null && r1.compare(keyIndex, this.maxValues) < 0) {
            Object r;
            int i;
            long[] seqs = new long[len + 1];
            IlIIIIIlIlIlllIl searcher = new IlIIIIIlIlIlllIl(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (i = 1; i <= len; ++i) {
                    r = (BaseRecord)data.getMem(i);
                    seqs[i] = searcher.findNext(((BaseRecord)r).getFieldValue(k));
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                for (i = 1; i <= len; ++i) {
                    r = (BaseRecord)data.getMem(i);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = ((BaseRecord)r).getFieldValue(keyIndex[k]);
                    }
                    seqs[i] = searcher.findNext(keyValues);
                }
            }
            for (int i2 = 1; i2 <= len; ++i2) {
                BaseRecord sr = (BaseRecord)data.getMem(i2);
                if (seqs[i2] > 0L) {
                    r = new ModifyRecord(seqs[i2], 1, sr.toRecord());
                    modifyRecords.add((ModifyRecord)r);
                    continue;
                }
                r = new ModifyRecord(-seqs[i2], 1, sr.toRecord());
                modifyRecords.add((ModifyRecord)r);
            }
        } else {
            long seq = this.totalRecordCount + 1L;
            for (int i = 1; i <= len; ++i) {
                BaseRecord sr = (BaseRecord)data.getMem(i);
                ModifyRecord r = new ModifyRecord(seq, 1, sr.toRecord());
                modifyRecords.add(r);
            }
        }
    }

    private Sequence _$1(Sequence data, String opt) throws IOException {
        boolean isInsert = true;
        boolean isUpdate = true;
        Sequence result = null;
        if (opt != null) {
            if (opt.indexOf(105) != -1) {
                isUpdate = false;
            }
            if (opt.indexOf(117) != -1) {
                if (!isUpdate) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(opt + mm.getMessage("engine.optConflict"));
                }
                isInsert = false;
            }
            if (opt.indexOf(110) != -1) {
                result = new Sequence();
            }
        }
        long totalRecordCount = this.totalRecordCount;
        DataStruct ds = data.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        if (!ds.isCompatible(this.ds)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        data.sortFields(this.getAllSortedColNames());
        this.appendCache();
        ColumnMetaData[] columns = this.getAllSortedColumns();
        int keyCount = columns.length;
        int[] keyIndex = new int[keyCount];
        for (int k = 0; k < keyCount; ++k) {
            keyIndex[k] = ds.getFieldIndex(columns[k].getColName());
            if (keyIndex[k] >= 0) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(columns[k].getColName() + mm.getMessage("ds.fieldNotExist"));
        }
        boolean isPrimaryTable = this.parent == null;
        int len = data.length();
        long[] seqs = new long[len + 1];
        int[] block = new int[len + 1];
        long[] recNum = null;
        int[] temp = new int[1];
        if (isPrimaryTable) {
            BaseRecord r;
            int i;
            IlIIIIIlIlIlllIl searcher = new IlIIIIIlIlIlllIl(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (i = 1; i <= len; ++i) {
                    r = (BaseRecord)data.getMem(i);
                    seqs[i] = searcher.findNext(r.getFieldValue(k));
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                for (i = 1; i <= len; ++i) {
                    r = (BaseRecord)data.getMem(i);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = r.getFieldValue(keyIndex[k]);
                    }
                    seqs[i] = searcher.findNext(keyValues);
                }
            }
        } else {
            recNum = new long[len + 1];
            ColPhyTable baseTable = (ColPhyTable)this.groupTable.baseTable;
            IlIIIIIlIlIlllIl baseSearcher = new IlIIIIIlIlIlllIl(baseTable);
            IlIllllllIIllIIl searcher = new IlIllllllIIllIIl(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (int i = 1; i <= len; ++i) {
                    BaseRecord r = (BaseRecord)data.getMem(i);
                    seqs[i] = searcher.findNext(r.getFieldValue(k), temp);
                    block[i] = temp[0];
                    if (seqs[i] < 0L) {
                        long seq = baseSearcher.findNext(r.getFieldValue(k));
                        if (seq > 0L) {
                            recNum[i] = seq;
                            continue;
                        }
                        if (baseSearcher._$1()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(r.toString(null) + mm.getMessage("grouptable.invalidData"));
                        }
                        recNum[i] = 0L;
                        continue;
                    }
                    recNum[i] = searcher._$1();
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                int baseKeyCount = this.sortedColStartIndex;
                Object[] baseKeyValues = new Object[baseKeyCount];
                for (int i = 1; i <= len; ++i) {
                    BaseRecord r = (BaseRecord)data.getMem(i);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = r.getFieldValue(keyIndex[k]);
                        if (k >= baseKeyCount) continue;
                        baseKeyValues[k] = keyValues[k];
                    }
                    seqs[i] = searcher.findNext(keyValues, temp);
                    block[i] = temp[0];
                    if (seqs[i] < 0L || block[i] > 0) {
                        long seq = baseSearcher.findNext(baseKeyValues);
                        if (seq > 0L) {
                            recNum[i] = seq;
                            continue;
                        }
                        if (baseSearcher._$1()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(r.toString(null) + mm.getMessage("grouptable.invalidData"));
                        }
                        recNum[i] = 0L;
                        continue;
                    }
                    recNum[i] = searcher._$1();
                }
            }
        }
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        boolean needUpdateSubTable = false;
        if (modifyRecords == null) {
            this.modifyRecords = modifyRecords = new ArrayList(len);
            for (int i = 1; i <= len; ++i) {
                ModifyRecord r;
                BaseRecord sr = (BaseRecord)data.getMem(i);
                if (seqs[i] > 0L) {
                    if (!isUpdate) continue;
                    ModifyRecord r2 = new ModifyRecord(seqs[i], 0, sr.toRecord());
                    modifyRecords.add(r2);
                    if (result == null) continue;
                    result.add(sr);
                    continue;
                }
                if (!isInsert) continue;
                long seq = -seqs[i];
                if (seq <= totalRecordCount || block[i] > 0) {
                    r = new ModifyRecord(seq, 1, sr.toRecord());
                    r.setBlock(block[i]);
                    if (!isPrimaryTable) {
                        r.setParentRecordSeq(recNum[i]);
                    }
                    modifyRecords.add(r);
                } else {
                    r = new ModifyRecord(seq, 1, sr.toRecord());
                    r.setBlock(block[i]);
                    if (!isPrimaryTable) {
                        r.setParentRecordSeq(recNum[i]);
                    }
                    modifyRecords.add(r);
                }
                if (result == null) continue;
                result.add(sr);
            }
        } else {
            int srcLen = modifyRecords.size();
            ArrayList<ModifyRecord> tmp = new ArrayList<ModifyRecord>(len + srcLen);
            int s = 0;
            int t = 1;
            while (s < srcLen && t <= len) {
                ModifyRecord mr = modifyRecords.get(s);
                long seq1 = mr.getRecordSeq();
                long seq2 = seqs[t];
                if (seq2 > 0L) {
                    if (seq1 < seq2) {
                        ++s;
                        tmp.add(mr);
                        continue;
                    }
                    if (seq1 == seq2) {
                        if (mr.getState() == 1) {
                            ++s;
                            tmp.add(mr);
                            continue;
                        }
                        if (mr.getState() == 0 && isUpdate || mr.getState() == -1 && isInsert) {
                            BaseRecord sr = (BaseRecord)data.getMem(t);
                            mr.setRecord(sr.toRecord(), 0);
                            if (result != null) {
                                result.add(sr);
                            }
                        }
                        ++s;
                        ++t;
                        tmp.add(mr);
                        continue;
                    }
                    if (isUpdate) {
                        BaseRecord sr = (BaseRecord)data.getMem(t);
                        mr = new ModifyRecord(seq2, 0, sr.toRecord());
                        tmp.add(mr);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                    ++t;
                    continue;
                }
                if (seq1 < (seq2 = -seq2)) {
                    ++s;
                    tmp.add(mr);
                    continue;
                }
                if (seq1 == seq2) {
                    if (mr.getState() == 1) {
                        BaseRecord sr;
                        int cmp = mr.getRecord().compare((BaseRecord)data.getMem(t), keyIndex);
                        if (cmp < 0) {
                            ++s;
                            tmp.add(mr);
                            continue;
                        }
                        if (cmp == 0) {
                            if (isUpdate) {
                                sr = (BaseRecord)data.getMem(t);
                                mr.setRecord(sr.toRecord());
                                if (result != null) {
                                    result.add(sr);
                                }
                            }
                            tmp.add(mr);
                            ++s;
                            ++t;
                            continue;
                        }
                        if (isInsert) {
                            sr = (BaseRecord)data.getMem(t);
                            mr = new ModifyRecord(seq2, 1, sr.toRecord());
                            mr.setBlock(block[t]);
                            if (!isPrimaryTable) {
                                mr.setParentRecordSeq(recNum[t]);
                            }
                            modifyRecords.add(mr);
                            tmp.add(mr);
                            if (result != null) {
                                result.add(sr);
                            }
                        }
                        ++t;
                        continue;
                    }
                    if (isInsert) {
                        BaseRecord sr = (BaseRecord)data.getMem(t);
                        mr = new ModifyRecord(seq2, 1, sr.toRecord());
                        mr.setBlock(block[t]);
                        if (!isPrimaryTable) {
                            mr.setParentRecordSeq(recNum[t]);
                        }
                        modifyRecords.add(mr);
                        tmp.add(mr);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                    ++t;
                    continue;
                }
                if (isInsert) {
                    BaseRecord sr = (BaseRecord)data.getMem(t);
                    mr = new ModifyRecord(seq2, 1, sr.toRecord());
                    mr.setBlock(block[t]);
                    if (!isPrimaryTable) {
                        mr.setParentRecordSeq(recNum[t]);
                    }
                    modifyRecords.add(mr);
                    tmp.add(mr);
                    if (result != null) {
                        result.add(sr);
                    }
                }
                ++t;
            }
            while (s < srcLen) {
                tmp.add(modifyRecords.get(s));
                ++s;
            }
            while (t <= len) {
                BaseRecord sr = (BaseRecord)data.getMem(t);
                if (seqs[t] > 0L) {
                    if (isUpdate) {
                        ModifyRecord r = new ModifyRecord(seqs[t], 0, sr.toRecord());
                        tmp.add(r);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                } else if (isInsert) {
                    ModifyRecord r;
                    long seq = -seqs[t];
                    if (seq <= totalRecordCount) {
                        r = new ModifyRecord(seq, 1, sr.toRecord());
                        r.setBlock(block[t]);
                        if (!isPrimaryTable) {
                            r.setParentRecordSeq(recNum[t]);
                        }
                        modifyRecords.add(r);
                        tmp.add(r);
                    } else {
                        r = new ModifyRecord(seq, 1, sr.toRecord());
                        r.setBlock(block[t]);
                        if (!isPrimaryTable) {
                            r.setParentRecordSeq(recNum[t]);
                        }
                        modifyRecords.add(r);
                        tmp.add(r);
                    }
                    if (result != null) {
                        result.add(sr);
                    }
                }
                ++t;
            }
            this.modifyRecords = tmp;
            if (srcLen != tmp.size()) {
                needUpdateSubTable = true;
            }
        }
        if (!isPrimaryTable) {
            this._$1(this.parent.getModifyRecords());
            for (ModifyRecord r : modifyRecords) {
                if (r.getState() != 1 || r.getParentRecordSeq() != 0L) continue;
                this.modifyRecords = null;
                this.modifyRecords = this.getModifyRecords();
                MessageManager mm = EngineMessage.get();
                throw new RQException(r.getRecord().toString(null) + mm.getMessage("grouptable.invalidData"));
            }
        }
        if (isPrimaryTable && needUpdateSubTable) {
            ArrayList<PhyTable> tableList = this.getTableList();
            int size = tableList.size();
            for (int i = 0; i < size; ++i) {
                ColPhyTable t = (ColPhyTable)tableList.get(i);
                boolean needSave = t._$1(modifyRecords);
                if (!needSave) continue;
                t.saveModifyRecords();
            }
        }
        return result;
    }

    public void update(ICursor cursor, String opt) throws IOException {
        Sequence temp = cursor.peek(1);
        String[] fields = ((BaseRecord)temp.getMem(1)).getFieldNames();
        ColumnMetaData[] columns = this.getColumns(fields);
        BlockLinkReader rowCountReader = this.getSegmentReader();
        int blockCount = this.getDataBlockCount();
        long[] recordCountArray = new long[blockCount];
        try {
            for (int i = 0; i < blockCount; ++i) {
                recordCountArray[i] = rowCountReader.readInt32();
            }
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                rowCountReader.close();
            }
            catch (Exception e) {}
        }
        for (ColumnMetaData col : columns) {
            BlockLink blockLink = col.getSegmentBlockLink();
            blockLink.setFirstBlockPos(blockLink._$4);
            blockLink._$2 = 0;
            blockLink = col.getDataBlockLink();
            blockLink.setFirstBlockPos(blockLink._$4);
            blockLink._$2 = 0;
            col.getDict().clear();
            col.initDictArray();
        }
        for (ColumnMetaData col : columns) {
            col.prepareWrite();
        }
        int columnCount = columns.length;
        BufferWriter[] bufferWriters = new BufferWriter[columnCount];
        Object[] minValues = new Object[columnCount];
        Object[] maxValues = new Object[columnCount];
        Object[] startValues = new Object[columnCount];
        int[] dataTypeInfo = new int[columnCount];
        for (long count : recordCountArray) {
            Sequence data = cursor.fetch((int)count);
            int end = data.length();
            for (int i = 0; i < columnCount; ++i) {
                bufferWriters[i] = columns[i].getColDataBufferWriter();
                Sequence dict = columns[i].getDict();
                DataBlockWriterJob.writeDataBlock(bufferWriters[i], data, dict, i, 1, end, maxValues, minValues, startValues, dataTypeInfo);
                boolean doCheck = this.groupTable.isCheckDataPure();
                columns[i].adjustDataType(dataTypeInfo[i], doCheck);
                columns[i].initDictArray();
                columns[i].appendColBlock(bufferWriters[i].finish(), minValues[i], maxValues[i], startValues[i]);
            }
        }
        for (ColumnMetaData col : columns) {
            col.finishWrite();
        }
        this.groupTable._$3();
        this.updateIndex();
    }

    @Override
    public Sequence delete(Sequence data, String opt) throws IOException {
        int i;
        Object r;
        int i2;
        Object searcher;
        boolean isPrimaryTable;
        DataStruct ds;
        long totalRecordCount;
        boolean deleteByBaseKey = false;
        if (opt != null && opt.indexOf(115) != -1) {
            deleteByBaseKey = true;
        }
        if (!this.hasPrimaryKey && !deleteByBaseKey) {
            return null;
        }
        if (data != null) {
            data = new Sequence(data);
        }
        ComTable groupTable = this.getGroupTable();
        groupTable.checkWritable();
        Sequence result1 = null;
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd != null) {
            result1 = tmd.delete(data, "n");
            data = data.diff(result1, false);
        }
        this.appendCache();
        boolean nopt = false;
        boolean isSave = true;
        if (opt != null) {
            if (opt.indexOf(110) != -1) {
                nopt = true;
            }
            if (opt.indexOf(121) != -1) {
                isSave = false;
            }
        }
        if ((totalRecordCount = this.totalRecordCount) == 0L || data == null || data.length() == 0) {
            return nopt ? result1 : null;
        }
        Sequence result = null;
        if (nopt) {
            result = new Sequence();
        }
        if ((ds = data.dataStruct()) == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        ColumnMetaData[] columns = this.getAllSortedColumns();
        int keyCount = columns.length;
        if (deleteByBaseKey) {
            keyCount = this.sortedColStartIndex;
        }
        int[] keyIndex = new int[keyCount];
        for (int k = 0; k < keyCount; ++k) {
            keyIndex[k] = ds.getFieldIndex(columns[k].getColName());
            if (keyIndex[k] >= 0) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(columns[k].getColName() + mm.getMessage("ds.fieldNotExist"));
        }
        boolean bl = isPrimaryTable = this.parent == null;
        if (deleteByBaseKey) {
            data.sortFields(this.parent.getSortedColNames());
        } else {
            data.sortFields(this.getAllSortedColNames());
        }
        int len = data.length();
        long[] seqs = new long[len + 1];
        int[] temp = new int[1];
        LongArray seqList = null;
        Sequence seqListData = null;
        if (deleteByBaseKey) {
            seqList = new LongArray(len * 10);
            seqListData = new Sequence(len);
        }
        if (isPrimaryTable) {
            searcher = new IlIIIIIlIlIlllIl(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (i2 = 1; i2 <= len; ++i2) {
                    r = (BaseRecord)data.getMem(i2);
                    seqs[i2] = ((IlIIIIIlIlIlllIl)searcher).findNext(((BaseRecord)r).getFieldValue(k));
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                for (i2 = 1; i2 <= len; ++i2) {
                    r = (BaseRecord)data.getMem(i2);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = ((BaseRecord)r).getFieldValue(keyIndex[k]);
                    }
                    seqs[i2] = ((IlIIIIIlIlIlllIl)searcher).findNext(keyValues);
                }
            }
        } else {
            searcher = new IlIllllllIIllIIl(this);
            Object[] keyValues = new Object[keyCount];
            int baseKeyCount = this.sortedColStartIndex;
            Object[] baseKeyValues = new Object[baseKeyCount];
            i = 1;
            while (i <= len) {
                BaseRecord r2 = (BaseRecord)data.getMem(i);
                for (int k = 0; k < keyCount; ++k) {
                    keyValues[k] = r2.getFieldValue(keyIndex[k]);
                    if (k >= baseKeyCount) continue;
                    baseKeyValues[k] = keyValues[k];
                }
                if (deleteByBaseKey) {
                    long s = ((IlIllllllIIllIIl)searcher).findNext(keyValues, keyCount);
                    if (s <= 0L) {
                        ++i;
                        continue;
                    }
                    seqList.add(s);
                    seqListData.add(r2);
                    continue;
                }
                seqs[i] = ((IlIllllllIIllIIl)searcher).findNext(keyValues, temp);
                ++i;
            }
        }
        if (deleteByBaseKey) {
            len = seqList.size();
            if (0 == len) {
                return result;
            }
            seqs = seqList.getDatas();
            data = seqListData;
        }
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        boolean modified = true;
        if (modifyRecords == null) {
            modifyRecords = new ArrayList(len);
            for (i2 = 1; i2 <= len; ++i2) {
                if (seqs[i2] <= 0L) continue;
                r = new ModifyRecord(seqs[i2]);
                modifyRecords.add((ModifyRecord)r);
                if (result == null) continue;
                result.add(data.getMem(i2));
            }
            if (modifyRecords.size() > 0) {
                this.modifyRecords = modifyRecords;
            } else {
                modified = false;
            }
        } else {
            int srcLen = modifyRecords.size();
            ArrayList<ModifyRecord> tmp = new ArrayList<ModifyRecord>(len + srcLen);
            int s = 0;
            int t = 1;
            while (s < srcLen && t <= len) {
                int cmp;
                ModifyRecord mr = modifyRecords.get(s);
                long seq1 = mr.getRecordSeq();
                long seq2 = seqs[t];
                if (seq2 > 0L) {
                    if (seq1 < seq2) {
                        ++s;
                    } else if (seq1 == seq2) {
                        if (mr.getState() == 1) {
                            cmp = mr.getRecord().compare((BaseRecord)data.getMem(t), keyIndex);
                            if (cmp < 0) {
                                tmp.add(mr);
                            } else if (cmp == 0) {
                                if (result != null) {
                                    result.add(data.getMem(t));
                                }
                            } else {
                                if (result != null) {
                                    result.add(data.getMem(t));
                                }
                                ModifyRecord r3 = new ModifyRecord(seqs[t]);
                                tmp.add(r3);
                                tmp.add(mr);
                                ++t;
                            }
                            ++s;
                            continue;
                        }
                        if (result != null && mr.getState() == 0) {
                            result.add(data.getMem(t));
                        }
                        mr.setDelete();
                        ++s;
                        ++t;
                    } else {
                        mr = new ModifyRecord(seq2);
                        if (result != null) {
                            result.add(data.getMem(t));
                        }
                        ++t;
                    }
                    tmp.add(mr);
                    continue;
                }
                if (seq1 < (seq2 = -seq2)) {
                    ++s;
                    tmp.add(mr);
                    continue;
                }
                if (seq1 == seq2) {
                    if (mr.getState() == 1) {
                        cmp = mr.getRecord().compare((BaseRecord)data.getMem(t), keyIndex);
                        if (cmp < 0) {
                            ++s;
                            tmp.add(mr);
                            continue;
                        }
                        if (cmp == 0) {
                            if (result != null) {
                                result.add(data.getMem(t));
                            }
                            ++s;
                            ++t;
                            continue;
                        }
                        ++t;
                        continue;
                    }
                    ++s;
                    ++t;
                    tmp.add(mr);
                    continue;
                }
                ++t;
            }
            while (s < srcLen) {
                tmp.add(modifyRecords.get(s));
                ++s;
            }
            while (t <= len) {
                if (seqs[t] > 0L) {
                    if (result != null) {
                        result.add(data.getMem(t));
                    }
                    ModifyRecord r4 = new ModifyRecord(seqs[t]);
                    tmp.add(r4);
                }
                ++t;
            }
            this.modifyRecords = tmp;
        }
        if (modified) {
            if (isPrimaryTable) {
                ArrayList<PhyTable> tableList = this.getTableList();
                int size = tableList.size();
                for (i = 0; i < size; ++i) {
                    ColPhyTable t = (ColPhyTable)tableList.get(i);
                    t.delete(data, "s");
                    t._$2(data);
                }
                for (i = 0; i < size; ++i) {
                    ColPhyTable t = (ColPhyTable)tableList.get(i);
                    t._$1(this.modifyRecords);
                    t.saveModifyRecords();
                }
            }
            if (!deleteByBaseKey && isSave) {
                this.saveModifyRecords();
            }
        }
        if (!deleteByBaseKey && isSave) {
            groupTable._$3();
        }
        if (nopt) {
            result.addAll(result1);
        }
        return result;
    }

    private boolean _$1(ArrayList<ModifyRecord> baseModifyRecords) throws IOException {
        this.getGroupTable().checkWritable();
        if (baseModifyRecords == null) {
            return false;
        }
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        if (modifyRecords == null) {
            return false;
        }
        int len = this.sortedColStartIndex;
        int[] index = new int[len];
        int[] findex = this.getSortedColIndex();
        for (int i = 0; i < len; ++i) {
            index[i] = findex[i];
        }
        boolean find = false;
        int parentRecordSeq = 0;
        for (ModifyRecord mr : baseModifyRecords) {
            ++parentRecordSeq;
            Record mrec = mr.getRecord();
            if (mr.getState() == -1) continue;
            for (ModifyRecord r : modifyRecords) {
                Record rec;
                int cmp;
                if (r.getState() == -1 || (cmp = (rec = r.getRecord()).compare((BaseRecord)mrec, index)) != 0) continue;
                if (mr.getState() == 1) {
                    r.setParentRecordSeq(-parentRecordSeq);
                } else {
                    r.setParentRecordSeq(mr.getRecordSeq());
                }
                find = true;
            }
        }
        return find;
    }

    private boolean _$2(Sequence data) throws IOException {
        ArrayList<ModifyRecord> tmp = new ArrayList<ModifyRecord>();
        ArrayList<ModifyRecord> srcModifyRecords = new ArrayList<ModifyRecord>();
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        if (modifyRecords == null) {
            return false;
        }
        tmp.addAll(modifyRecords);
        int len = this.sortedColStartIndex;
        int[] index = new int[len];
        int[] findex = this.getSortedColIndex();
        for (int i = 0; i < len; ++i) {
            index[i] = findex[i];
        }
        len = data.length();
        boolean delete = false;
        for (int i = 1; i <= len; ++i) {
            BaseRecord mrec = (BaseRecord)data.get(i);
            srcModifyRecords.clear();
            srcModifyRecords.addAll(tmp);
            tmp.clear();
            for (ModifyRecord r : srcModifyRecords) {
                int cmp;
                Record rec;
                int state = r.getState();
                if (state == 0) {
                    rec = r.getRecord();
                    cmp = rec.compare(mrec, index);
                    if (cmp == 0) {
                        r.setDelete();
                        r.setRecord(null);
                        delete = true;
                    }
                    tmp.add(r);
                    continue;
                }
                if (state == 1) {
                    rec = r.getRecord();
                    cmp = rec.compare(mrec, index);
                    if (cmp == 0) {
                        delete = true;
                        continue;
                    }
                    tmp.add(r);
                    continue;
                }
                tmp.add(r);
            }
        }
        if (delete) {
            this.modifyRecords = tmp;
        }
        return delete;
    }

    private Object[][] _$1(Sequence values) {
        int valueLen = values.length();
        if (valueLen == 0) {
            return null;
        }
        ColumnMetaData[] cols = this.getSortedColumns();
        Object[][] dimValues = new Object[valueLen][];
        Object obj = values.getMem(1);
        if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            int dimCount = seq.length();
            if (dimCount > cols.length) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("find" + mm.getMessage("function.invalidParam"));
            }
            dimValues = new Object[valueLen][];
            for (int i = 1; i <= valueLen; ++i) {
                seq = (Sequence)values.getMem(i);
                dimValues[i - 1] = seq.toArray();
            }
        } else if (obj instanceof BaseRecord) {
            BaseRecord r = (BaseRecord)obj;
            int[] keyIndex = r.dataStruct().getPKIndex();
            if (keyIndex == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            int dimCount = keyIndex.length;
            if (dimCount > cols.length) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("find" + mm.getMessage("function.invalidParam"));
            }
            dimValues = new Object[valueLen][];
            for (int i = 1; i <= valueLen; ++i) {
                r = (BaseRecord)values.getMem(i);
                Object[] cur = new Object[dimCount];
                for (int f = 0; f < dimCount; ++f) {
                    cur[f] = r.getNormalFieldValue(keyIndex[f]);
                }
                dimValues[i - 1] = cur;
            }
        } else {
            boolean dimCount = true;
            dimValues = new Object[valueLen][];
            for (int i = 1; i <= valueLen; ++i) {
                dimValues[i - 1] = new Object[]{values.getMem(i)};
            }
        }
        return dimValues;
    }

    private Table _$1(Sequence values, String[] selFields) {
        String[] keys = this.getAllSortedColNames();
        Expression exp = new Expression("null.contain(" + keys[0] + ")");
        Sequence keyValues = new Sequence();
        int valueLen = values.length();
        keyValues = new Sequence();
        for (int i = 1; i <= valueLen; ++i) {
            Object obj = values.getMem(i);
            if (obj instanceof Sequence) {
                Sequence seq = (Sequence)obj;
                keyValues.add(seq.getMem(1));
                continue;
            }
            keyValues.add(obj);
        }
        Context ctx = new Context();
        exp.getHome().setLeft(new Constant(keyValues));
        Sequence temp = this.cursor(selFields, exp, ctx).fetch();
        if (temp == null) {
            return null;
        }
        Sequence result = new Sequence(valueLen);
        for (int i = 1; i <= valueLen; ++i) {
            result.add(temp.findByKey(values.getMem(i), false));
        }
        Table table = new Table(result.dataStruct());
        table.addAll(result);
        return table;
    }

    @Override
    public Table finds(Sequence values) throws IOException {
        return this.finds(values, null);
    }

    @Override
    public Table finds(Sequence values, String[] selFields) throws IOException {
        int f;
        int cmp;
        int f2;
        Object[][] dimValues;
        this.getGroupTable().checkReadable();
        if (!this.hasPrimaryKey()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.lessKey"));
        }
        if (this.getGroupTable().hasTimeKey()) {
            return this._$1(values, selFields);
        }
        if (this.parent != null || this.getModifyRecords() != null) {
            Expression exp;
            String[] keys = this.getAllSortedColNames();
            int keyCount = keys.length;
            Sequence keyValues = values;
            if (keyCount == 1) {
                exp = new Expression("null.contain(" + keys[0] + ")");
                Object obj = values.getMem(1);
                int valueLen = values.length();
                if (valueLen == 0) {
                    return null;
                }
                if (obj instanceof Sequence) {
                    Sequence seq = (Sequence)obj;
                    int dimCount = seq.length();
                    if (dimCount > keyCount) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("find" + mm.getMessage("function.invalidParam"));
                    }
                    keyValues = new Sequence();
                    for (int i = 1; i <= valueLen; ++i) {
                        seq = (Sequence)values.getMem(i);
                        keyValues.add(seq.getMem(1));
                    }
                }
            } else {
                String str = "null.contain([";
                for (int i = 0; i < keyCount; ++i) {
                    str = str + keys[i];
                    if (i == keyCount - 1) continue;
                    str = str + ",";
                }
                str = str + "])";
                exp = new Expression(str);
            }
            Context ctx = new Context();
            exp.getHome().setLeft(new Constant(keyValues));
            Sequence result = this.cursor(selFields, exp, ctx).fetch();
            if (result == null) {
                return null;
            }
            Table table = new Table(result.dataStruct());
            table.addAll(result);
            return table;
        }
        if (selFields == null) {
            selFields = this.getColNames();
        }
        if ((dimValues = this._$1(values)) == null) {
            return null;
        }
        int valueLen = dimValues.length;
        int dimCount = dimValues[0].length;
        ColumnMetaData[] cols = this.getSortedColumns();
        ArrayList<ColumnMetaData> list = new ArrayList<ColumnMetaData>();
        for (int i = 0; i < dimCount; ++i) {
            list.add(cols[i]);
        }
        for (String field : selFields) {
            ColumnMetaData col = this.getColumn(field);
            if (col == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(field + mm.getMessage("ds.fieldNotExist"));
            }
            if (list.contains(col)) continue;
            list.add(col);
        }
        int colCount = list.size();
        int[] findex = new int[colCount];
        ColumnMetaData[] columns = new ColumnMetaData[colCount];
        list.toArray(columns);
        DataStruct ds = new DataStruct(selFields);
        boolean hasKey = true;
        for (int i = 0; i < dimCount; ++i) {
            if (ds.getFieldIndex(cols[i].getColName()) != -1) continue;
            hasKey = false;
            break;
        }
        if (hasKey) {
            ds.setPrimary(this.getSortedColNames());
        }
        BlockLinkReader rowCountReader = this.getSegmentReader();
        BlockLinkReader[] colReaders = new BlockLinkReader[colCount];
        ObjectReader[] segmentReaders = new ObjectReader[colCount];
        for (int i = 0; i < colCount; ++i) {
            ColumnMetaData col = (ColumnMetaData)list.get(i);
            colReaders[i] = col.getColReader(false);
            segmentReaders[i] = col.getSegmentReader();
            findex[i] = ds.getFieldIndex(col.getColName());
        }
        int valueIndex = 0;
        Table table = new Table(ds, valueLen);
        int blockCount = this.getDataBlockCount();
        long[] prevPos = new long[colCount];
        long[] curPos = new long[colCount];
        Object[] curStartValues = new Object[dimCount];
        int prevCount = rowCountReader.readInt32();
        Object[] tmpDimValues = new Object[dimCount];
        for (f2 = 0; f2 < dimCount; ++f2) {
            prevPos[f2] = segmentReaders[f2].readLong40();
            segmentReaders[f2].skipObject();
            segmentReaders[f2].skipObject();
            segmentReaders[f2].skipObject();
        }
        for (f2 = dimCount; f2 < colCount; ++f2) {
            prevPos[f2] = segmentReaders[f2].readLong40();
            if (!columns[f2].hasMaxMinValues()) continue;
            segmentReaders[f2].skipObject();
            segmentReaders[f2].skipObject();
            segmentReaders[f2].skipObject();
        }
        IntArrayList indexList = new IntArrayList();
        for (int b = 1; b < blockCount; ++b) {
            int f3;
            int curCount = rowCountReader.readInt32();
            for (f3 = 0; f3 < dimCount; ++f3) {
                curPos[f3] = segmentReaders[f3].readLong40();
                segmentReaders[f3].skipObject();
                segmentReaders[f3].skipObject();
                curStartValues[f3] = segmentReaders[f3].readObject();
            }
            for (f3 = dimCount; f3 < colCount; ++f3) {
                curPos[f3] = segmentReaders[f3].readLong40();
                if (!columns[f3].hasMaxMinValues()) continue;
                segmentReaders[f3].skipObject();
                segmentReaders[f3].skipObject();
                segmentReaders[f3].skipObject();
            }
            Object[] curDimValues = dimValues[valueIndex];
            cmp = Variant.compareArrays(curStartValues, curDimValues);
            if (cmp > 0) {
                int count;
                BufferReader[] readers = new BufferReader[colCount];
                for (f = 0; f < dimCount; ++f) {
                    readers[f] = colReaders[f].readBlockData(prevPos[f], prevCount);
                }
                for (int i = 0; i < prevCount; ++i) {
                    int f4;
                    for (int f5 = 0; f5 < dimCount; ++f5) {
                        tmpDimValues[f5] = readers[f5].readObject();
                    }
                    cmp = Variant.compareArrays(tmpDimValues, curDimValues);
                    if (cmp == 0) {
                        BaseRecord r = table.newLast();
                        for (f4 = 0; f4 < dimCount; ++f4) {
                            if (findex[f4] == -1) continue;
                            r.setNormalFieldValue(findex[f4], curDimValues[f4]);
                        }
                        indexList.addInt(i);
                        if (++valueIndex != valueLen && Variant.compareArrays(curStartValues, curDimValues = dimValues[valueIndex]) > 0) continue;
                        break;
                    }
                    if (cmp <= 0) continue;
                    ++valueIndex;
                    while (valueIndex < valueLen) {
                        curDimValues = dimValues[valueIndex];
                        cmp = Variant.compareArrays(tmpDimValues, curDimValues);
                        if (cmp == 0) {
                            BaseRecord r = table.newLast();
                            for (f4 = 0; f4 < dimCount; ++f4) {
                                if (findex[f4] == -1) continue;
                                r.setNormalFieldValue(findex[f4], curDimValues[f4]);
                            }
                            indexList.addInt(i);
                            break;
                        }
                        if (cmp < 0) break;
                        ++valueIndex;
                    }
                    if (valueIndex == valueLen) break;
                }
                if ((count = indexList.size()) > 0) {
                    for (int f6 = dimCount; f6 < colCount; ++f6) {
                        readers[f6] = colReaders[f6].readBlockData(prevPos[f6], prevCount);
                    }
                    int prev = 0;
                    int i = 0;
                    int m = table.length() - count + 1;
                    while (i < count) {
                        BaseRecord r = (BaseRecord)table.getMem(m);
                        int index = indexList.getInt(i);
                        for (int f7 = dimCount; f7 < colCount; ++f7) {
                            for (int j = prev; j < index; ++j) {
                                readers[f7].skipObject();
                            }
                            r.setNormalFieldValue(findex[f7], readers[f7].readObject());
                        }
                        prev = index + 1;
                        ++i;
                        ++m;
                    }
                    indexList.clear();
                }
                if (valueIndex == valueLen) break;
            }
            prevCount = curCount;
            long[] tmpPos = prevPos;
            prevPos = curPos;
            curPos = tmpPos;
        }
        if (valueIndex < valueLen) {
            int count;
            int f8;
            BufferReader[] readers = new BufferReader[colCount];
            for (int f9 = 0; f9 < dimCount; ++f9) {
                readers[f9] = colReaders[f9].readBlockData(prevPos[f9], prevCount);
            }
            Object[] curDimValues = dimValues[valueIndex];
            for (int i = 0; i < prevCount; ++i) {
                BaseRecord r;
                for (f8 = 0; f8 < dimCount; ++f8) {
                    tmpDimValues[f8] = readers[f8].readObject();
                }
                cmp = Variant.compareArrays(tmpDimValues, curDimValues);
                if (cmp == 0) {
                    r = table.newLast();
                    for (f = 0; f < dimCount; ++f) {
                        if (findex[f] == -1) continue;
                        r.setNormalFieldValue(findex[f], curDimValues[f]);
                    }
                    indexList.addInt(i);
                    if (++valueIndex == valueLen) break;
                    curDimValues = dimValues[valueIndex];
                    continue;
                }
                if (cmp <= 0) continue;
                ++valueIndex;
                while (valueIndex < valueLen) {
                    curDimValues = dimValues[valueIndex];
                    cmp = Variant.compareArrays(tmpDimValues, curDimValues);
                    if (cmp == 0) {
                        r = table.newLast();
                        for (f = 0; f < dimCount; ++f) {
                            if (findex[f] == -1) continue;
                            r.setNormalFieldValue(findex[f], curDimValues[f]);
                        }
                        indexList.addInt(i);
                        break;
                    }
                    if (cmp < 0) break;
                    ++valueIndex;
                }
                if (valueIndex == valueLen) break;
            }
            if ((count = indexList.size()) > 0) {
                for (f8 = dimCount; f8 < colCount; ++f8) {
                    readers[f8] = colReaders[f8].readBlockData(prevPos[f8], prevCount);
                }
                int prev = 0;
                int i = 0;
                int m = table.length() - count + 1;
                while (i < count) {
                    BaseRecord r = (BaseRecord)table.getMem(m);
                    int index = indexList.getInt(i);
                    for (int f10 = dimCount; f10 < colCount; ++f10) {
                        for (int j = prev; j < index; ++j) {
                            readers[f10].skipObject();
                        }
                        r.setNormalFieldValue(findex[f10], readers[f10].readObject());
                    }
                    prev = index + 1;
                    ++i;
                    ++m;
                }
            }
        }
        return table;
    }

    public void getSegmentInfo(String[] keys, ArrayList<Integer> list, Sequence values, int n) throws IOException {
        ColumnMetaData[] columns = this.getColumns(keys);
        int colCount = keys.length;
        BlockLinkReader rowCountReader = this.getSegmentReader();
        ObjectReader[] segmentReaders = new ObjectReader[colCount];
        for (int i = 0; i < colCount; ++i) {
            segmentReaders[i] = columns[i].getSegmentReader();
        }
        int blockCount = this.getDataBlockCount();
        int sum = rowCountReader.readInt32();
        for (int f = 0; f < colCount; ++f) {
            segmentReaders[f].readLong40();
            segmentReaders[f].skipObject();
            segmentReaders[f].skipObject();
            segmentReaders[f].skipObject();
        }
        for (int i = 1; i < blockCount; ++i) {
            int cnt = rowCountReader.readInt32();
            if (sum + cnt > n) {
                list.add(sum);
                sum = cnt;
                Object[] vals = new Object[colCount];
                for (int f = 0; f < colCount; ++f) {
                    segmentReaders[f].readLong40();
                    segmentReaders[f].skipObject();
                    segmentReaders[f].skipObject();
                    vals[f] = segmentReaders[f].readObject();
                }
                values.add(vals);
                continue;
            }
            sum += cnt;
            for (int f = 0; f < colCount; ++f) {
                segmentReaders[f].readLong40();
                segmentReaders[f].skipObject();
                segmentReaders[f].skipObject();
                segmentReaders[f].skipObject();
            }
        }
        list.add(sum);
    }

    public void getSegmentInfo2(String[] keys, ArrayList<Integer> list, Sequence values, int n) throws IOException {
        ColumnMetaData[] columns = this.getColumns(keys);
        int colCount = keys.length;
        BlockLinkReader rowCountReader = this.getSegmentReader();
        ObjectReader[] segmentReaders = new ObjectReader[colCount];
        for (int i = 0; i < colCount; ++i) {
            segmentReaders[i] = columns[i].getSegmentReader();
        }
        int blockCount = this.getDataBlockCount();
        list.add(0);
        int sum = rowCountReader.readInt32();
        for (int f = 0; f < colCount; ++f) {
            segmentReaders[f].readLong40();
            segmentReaders[f].skipObject();
            segmentReaders[f].skipObject();
            segmentReaders[f].skipObject();
        }
        for (int i = 1; i < blockCount; ++i) {
            int cnt = rowCountReader.readInt32();
            if (sum + cnt > n) {
                if (i + 1 == blockCount) continue;
                list.add(i);
                list.add(i);
                sum = cnt;
                Object[] vals = new Object[colCount];
                for (int f = 0; f < colCount; ++f) {
                    segmentReaders[f].readLong40();
                    segmentReaders[f].skipObject();
                    segmentReaders[f].skipObject();
                    vals[f] = segmentReaders[f].readObject();
                }
                values.add(vals);
                continue;
            }
            sum += cnt;
            for (int f = 0; f < colCount; ++f) {
                segmentReaders[f].readLong40();
                segmentReaders[f].skipObject();
                segmentReaders[f].skipObject();
                segmentReaders[f].skipObject();
            }
        }
        list.add(blockCount);
    }

    @Override
    public Object[] getMaxMinValue(String key) throws IOException {
        if (this.totalRecordCount == 0L) {
            return null;
        }
        ColumnMetaData column = this.getColumn(key);
        if (column == null) {
            return null;
        }
        if (!column.hasMaxMinValues()) {
            Expression max = new Expression("max(" + key + ")");
            Expression min = new Expression("min(" + key + ")");
            Expression[] exps = new Expression[]{max, min};
            Table seq = this.cursor(new String[]{key}).groups(null, null, exps, null, null, new Context());
            return ((BaseRecord)seq.get(1)).getFieldValues();
        }
        ObjectReader segmentReader = column.getSegmentReader();
        int blockCount = this.getDataBlockCount();
        segmentReader.readLong40();
        Object min = segmentReader.readObject();
        Object max = segmentReader.readObject();
        segmentReader.skipObject();
        for (int i = 1; i < blockCount; ++i) {
            segmentReader.readLong40();
            Object obj = segmentReader.readObject();
            if (Variant.compare(obj, min) < 0) {
                min = obj;
            }
            if (Variant.compare(obj = segmentReader.readObject(), max) > 0) {
                max = obj;
            }
            segmentReader.skipObject();
        }
        return new Object[]{max, min};
    }

    public long[] getSegmentInfo() {
        BlockLinkReader rowCountReader = this.getSegmentReader();
        int blockCount = this.getDataBlockCount();
        long[] recCountOfSegment = new long[blockCount];
        long sum = 0L;
        try {
            for (int i = 0; i < blockCount; ++i) {
                recCountOfSegment[i] = sum += (long)rowCountReader.readInt32();
            }
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                rowCountReader.close();
            }
            catch (Exception e) {}
        }
        return recCountOfSegment;
    }

    @Override
    public void append(PhyTable other) throws IOException {
        int i;
        ColumnMetaData[] columns;
        if (!(other instanceof ColPhyTable)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        ColPhyTable table = (ColPhyTable)other;
        this.getGroupTable().checkWritable();
        table.getGroupTable().checkReadable();
        if (!table.getDataStruct().isCompatible(this.getDataStruct())) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        if (this.getModifyRecords() != null || table.getModifyRecords() != null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("grouptable.invalidData"));
        }
        Object[] startValues = null;
        if (this.isSorted) {
            columns = table.getSortedColumns();
            int count = columns.length;
            startValues = new Object[count];
            for (int i2 = 0; i2 < count; ++i2) {
                ObjectReader segmentReader = columns[i2].getSegmentReader();
                segmentReader.readLong40();
                segmentReader.skipObject();
                segmentReader.skipObject();
                startValues[i2] = segmentReader.readObject();
            }
        }
        if (this.hasPrimaryKey && (!table.hasPrimaryKey || Variant.compareArrays(this.maxValues, startValues) >= 0)) {
            this.hasPrimaryKey = false;
        }
        if (!(this.hasPrimaryKey || !this.isSorted || table.isSorted && Variant.compareArrays(this.maxValues, startValues) <= 0)) {
            this.isSorted = false;
        }
        this.prepareAppend();
        columns = this._$8;
        ColumnMetaData[] columns2 = table._$8;
        int colCount = columns.length;
        BlockLinkReader rowCountReader = table.getSegmentReader();
        BlockLinkReader[] colReaders2 = new BlockLinkReader[colCount];
        ObjectReader[] segmentReaders2 = new ObjectReader[colCount];
        byte[][] dictBuffer = new byte[colCount][];
        BufferWriter[] bufferWriters = new BufferWriter[colCount];
        for (int i3 = 0; i3 < colCount; ++i3) {
            colReaders2[i3] = columns2[i3].getColReader(true);
            segmentReaders2[i3] = columns2[i3].getSegmentReader();
            Sequence dict = columns2[i3].getDict();
            if (dict != null && dict.length() == 0) {
                dictBuffer[i3] = null;
                continue;
            }
            BufferWriter bufferWriter = columns[i3].getColDataBufferWriter();
            bufferWriter.writeObject(dict);
            dictBuffer[i3] = bufferWriter.finish();
            bufferWriters[i3] = bufferWriter;
        }
        int blockCount = table.getDataBlockCount();
        for (i = 0; i < blockCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                if (dictBuffer[j] == null) {
                    columns[j].copyColBlock(colReaders2[j], segmentReaders2[j]);
                    continue;
                }
                columns[j].copyColBlock(colReaders2[j], segmentReaders2[j], bufferWriters[j], dictBuffer[j]);
            }
            this.appendSegmentBlock(rowCountReader.readInt32());
        }
        this.finishAppend();
        rowCountReader.close();
        for (i = 0; i < colCount; ++i) {
            colReaders2[i].close();
            segmentReaders2[i].close();
        }
    }

    @Override
    public int getFirstBlockFromModifyRecord() {
        long minSeq = Long.MAX_VALUE;
        ArrayList<ModifyRecord> recs = this.getModifyRecords();
        if (recs != null) {
            for (ModifyRecord rec : recs) {
                long seq = rec.getRecordSeq();
                if (minSeq <= seq) continue;
                minSeq = seq;
            }
        }
        if (minSeq == Long.MAX_VALUE) {
            return -1;
        }
        long[] recCountOfSegment = this.getSegmentInfo();
        int len = recCountOfSegment.length;
        for (int i = 0; i < len; ++i) {
            if (minSeq > recCountOfSegment[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public long resetByBlock(int block) {
        BlockLinkReader rowCountReader = this.getSegmentReader();
        long sum = 0L;
        int blockSize = this.getGroupTable().blockSize;
        try {
            for (int i = 0; i < block; ++i) {
                int cnt = rowCountReader.readInt32();
                sum += (long)cnt;
            }
            this.segmentBlockLink._$3 = rowCountReader.position();
            this.segmentBlockLink._$2 = rowCountReader.getCaret();
            this.totalRecordCount = sum;
            this.dataBlockCount = block;
            this.modifyRecords.clear();
            this.saveModifyRecords();
            this.maxValues = null;
            long resetPos = 0L;
            for (ColumnMetaData col : this._$8) {
                ObjectReader reader;
                BlockLinkReader segmentReader = new BlockLinkReader(col.getSegmentBlockLink());
                try {
                    segmentReader.loadFirstBlock();
                    reader = new ObjectReader(segmentReader, blockSize - 5);
                }
                catch (IOException e) {
                    segmentReader.close();
                    throw new RQException(e.getMessage(), e);
                }
                for (int i = 0; i < block; ++i) {
                    reader.readLong40();
                    if (!col.hasMaxMinValues()) continue;
                    reader.readObject();
                    reader.readObject();
                    reader.readObject();
                }
                BlockLink blockLink = col.getSegmentBlockLink();
                blockLink._$2 = (int)(reader.position() % (long)blockSize);
                blockLink._$3 = segmentReader.position();
                long tempPos = reader.readLong40();
                if (resetPos < tempPos) {
                    resetPos = tempPos;
                }
                reader.close();
                segmentReader.close();
                blockLink = col.getDataBlockLink();
                blockLink._$2 = (int)(tempPos % (long)blockSize);
                blockLink._$3 = tempPos - tempPos % (long)blockSize;
            }
            if (this.parent != null) {
                ObjectReader reader;
                BlockLinkReader segmentReader = new BlockLinkReader(this._$3.getSegmentBlockLink());
                try {
                    segmentReader.loadFirstBlock();
                    reader = new ObjectReader(segmentReader, blockSize - 5);
                }
                catch (IOException e) {
                    segmentReader.close();
                    throw new RQException(e.getMessage(), e);
                }
                for (int i = 0; i < block; ++i) {
                    reader.readLong40();
                }
                BlockLink blockLink = this._$3.getSegmentBlockLink();
                blockLink._$2 = (int)(reader.position() % (long)blockSize);
                blockLink._$3 = segmentReader.position();
                long tempPos = reader.readLong40();
                if (resetPos < tempPos) {
                    resetPos = tempPos;
                }
                reader.close();
                segmentReader.close();
                blockLink = this._$3.getDataBlockLink();
                blockLink._$2 = (int)(tempPos % (long)blockSize);
                blockLink._$3 = tempPos - tempPos % (long)blockSize;
            }
            long l = resetPos - resetPos % (long)blockSize + (long)blockSize;
            return l;
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                rowCountReader.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    long[] _$1(String field, Node node, Context ctx) {
        ColumnMetaData col = this.getColumn(field);
        if (col == null || !col.isDim()) {
            return null;
        }
        int operator = 0;
        if (node instanceof Equals) {
            operator = 1;
        } else if (node instanceof Greater) {
            operator = 2;
        } else if (node instanceof NotSmaller) {
            operator = 3;
        } else if (node instanceof Smaller) {
            operator = 4;
        } else if (node instanceof NotGreater) {
            operator = 5;
        } else if (node instanceof NotEquals) {
            operator = 6;
        } else {
            return null;
        }
        Object value = node.getRight() instanceof UnknownSymbol ? node.getLeft().calculate(ctx) : node.getRight().calculate(ctx);
        long seq = 0L;
        int blockCount = this.dataBlockCount;
        ColumnFilter filter = new ColumnFilter(col, 0, operator, value);
        LongArray intervals = new LongArray(blockCount);
        BlockLinkReader rowCountReader = this.getSegmentReader();
        ObjectReader segmentReader = col.getSegmentReader();
        try {
            for (int i = 0; i < blockCount; ++i) {
                int recordCount = rowCountReader.readInt32();
                segmentReader.readLong40();
                Object minValue = segmentReader.readObject();
                Object maxValue = segmentReader.readObject();
                segmentReader.skipObject();
                if (filter.match(minValue, maxValue) && recordCount != 1) {
                    intervals.add(seq + 1L);
                    intervals.add(seq + (long)recordCount);
                }
                seq += (long)recordCount;
            }
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        if (intervals.size() == 0) {
            return null;
        }
        return intervals.getDatas();
    }

    @Override
    public void appendCache() throws IOException {
        if (this.appendCache == null) {
            return;
        }
        MemoryCursor cursor = new MemoryCursor(this.appendCache);
        this.prepareAppend();
        if (this.parent != null) {
            this.parent.appendCache();
            this._$3(cursor);
        } else if (this._$6 == null) {
            this._$4(cursor);
        } else if (this.getSegmentCol() == null) {
            this._$1(cursor);
        } else {
            this._$2(cursor);
        }
        this.appendCache = null;
        this.finishAppend();
    }

    @Override
    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int pathSeq, int pathCount, int pathCount2, String opt, Context ctx) {
        int avg;
        if (this.dataBlockCount < pathCount || pathCount2 < 2) {
            return this.cursor(exps, fields, filter, fkNames, codes, opts, pathSeq, pathCount, opt, ctx);
        }
        ICursor[] cursors = new ICursor[pathCount2];
        int count = avg = this.dataBlockCount / pathCount;
        if (pathSeq == pathCount) {
            count += this.dataBlockCount % pathCount;
        }
        int offset = (pathSeq - 1) * avg;
        if (count < pathCount2) {
            int i;
            for (i = 0; i < count; ++i) {
                if (filter != null) {
                    filter = filter.newExpression(ctx);
                }
                cursors[i] = this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
                ((IDWCursor)cursors[i]).setSegment(offset + i, offset + i + 1);
            }
            while (i < pathCount2) {
                if (filter != null) {
                    filter = filter.newExpression(ctx);
                }
                cursors[i] = this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
                ((IDWCursor)cursors[i]).setSegment(0, -1);
                ++i;
            }
        } else {
            int avg2 = count / pathCount2;
            for (int i = 0; i < pathCount2; ++i) {
                if (filter != null) {
                    filter = filter.newExpression(ctx);
                }
                cursors[i] = this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
                if (i != pathCount2 - 1) {
                    ((IDWCursor)cursors[i]).setSegment(offset + avg2 * i, offset + avg2 * (i + 1));
                    continue;
                }
                ((IDWCursor)cursors[i]).setSegment(offset + avg2 * i, offset + count);
            }
        }
        return new MultipathCursors(cursors, ctx);
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, ICursor cursor, int seg, Object[][] endValues, String opt, Context ctx) {
        this.getGroupTable().checkReadable();
        ArrayList<ICursor> csList = new ArrayList<ICursor>();
        ICursor[] srcs = cursor instanceof MultipathCursors ? ((MultipathCursors)cursor).getParallelCursors() : new ICursor[]{cursor};
        for (ICursor cs : srcs) {
            if (cs instanceof Cursor || cs instanceof JoinTableCursor) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
        }
        PhyTable table = ((IDWCursor)srcs[0]).getTableMetaData();
        String[] names = table.getAllSortedColNames();
        if (names == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
        }
        String segCol = table.getSegmentCol();
        if (segCol != null) {
            for (int i = names.length - 1; i >= 0; --i) {
                if (!names[i].equals(segCol)) continue;
                String[] tmp = new String[i + 1];
                System.arraycopy(names, 0, tmp, 0, i + 1);
                names = tmp;
                break;
            }
        }
        int fcount = names.length;
        if (seg != 0) {
            Record rec = new Record(cursor.getDataStruct());
            Sequence tempSeq = new Sequence();
            tempSeq.add(rec);
            csList.add(new MemoryCursor(tempSeq));
        }
        int firstNullIndex = -1;
        int len = srcs.length;
        for (int i = 0; i < len; ++i) {
            if (srcs[i].peek(1) == null && firstNullIndex < 0) {
                firstNullIndex = i;
            }
            csList.add(srcs[i]);
        }
        if (seg + 1 <= endValues.length) {
            Object[] objs = endValues[seg];
            Record rec = new Record(cursor.getDataStruct());
            for (int f = 0; f < fcount; ++f) {
                ((BaseRecord)rec).set(names[f], objs[f]);
            }
            Sequence tempSeq = new Sequence();
            tempSeq.add(rec);
            if (firstNullIndex < 0) {
                csList.add(new MemoryCursor(tempSeq));
            } else {
                csList.add(firstNullIndex, new MemoryCursor(tempSeq));
            }
        }
        srcs = new ICursor[csList.size()];
        csList.toArray(srcs);
        int segCount = srcs.length;
        ColumnMetaData[] sortedCols = this.getAllSortedColumns();
        if (sortedCols.length < fcount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
        }
        String[] dimFields = new String[fcount];
        for (int f = 0; f < fcount; ++f) {
            dimFields[f] = sortedCols[f].getColName();
        }
        Object[][] minValues = new Object[segCount][];
        int dataSegCount = segCount;
        for (int i = 0; i < segCount; ++i) {
            Sequence seq = srcs[i].peek(1);
            if (seq == null) {
                dataSegCount = i++;
                while (i < segCount) {
                    if (srcs[i].peek(1) != null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
                    }
                    ++i;
                }
                break;
            }
            BaseRecord r = (BaseRecord)seq.get(1);
            Object[] vals = new Object[fcount];
            minValues[i] = vals;
            for (int f = 0; f < fcount; ++f) {
                vals[f] = r.getFieldValue(names[f]);
            }
        }
        ObjectReader[] readers = new ObjectReader[fcount];
        for (int f = 0; f < fcount; ++f) {
            readers[f] = sortedCols[f].getSegmentReader();
        }
        int blockCount = this.getDataBlockCount();
        int s = 1;
        Object[] blockMinVals = new Object[fcount];
        ICursor[] cursors = new ICursor[segCount];
        boolean[] isEquals = new boolean[segCount];
        for (int i = dataSegCount; i < segCount; ++i) {
            Cursor cs = new Cursor(this, fields, filter, fkNames, codes, opts, ctx);
            cs.setSegment(0, -1);
            cursors[i] = cs;
        }
        try {
            Sequence seq;
            int i;
            ICursor cs;
            int startBlock = 0;
            for (int b = 0; b < blockCount && s < dataSegCount; ++b) {
                ICursor cs2;
                int cmp;
                for (int f = 0; f < fcount; ++f) {
                    readers[f].readLong40();
                    readers[f].skipObject();
                    readers[f].skipObject();
                    blockMinVals[f] = readers[f].readObject();
                }
                if (filter != null) {
                    filter = filter.newExpression(ctx);
                }
                if ((cmp = Variant.compareArrays(blockMinVals, minValues[s])) > 0) {
                    cursors[s - 1] = cs2 = this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
                    if (b > 0) {
                        ((IDWCursor)cs2).setSegment(startBlock, b - 1);
                        startBlock = b - 1;
                    } else {
                        ((IDWCursor)cs2).setSegment(startBlock, 0);
                        startBlock = 0;
                    }
                    isEquals[s] = false;
                    ++s;
                    continue;
                }
                if (cmp != 0) continue;
                cursors[s - 1] = cs2 = this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
                ((IDWCursor)cs2).setSegment(startBlock, b);
                startBlock = b;
                isEquals[s] = true;
                ++s;
            }
            if (s == dataSegCount) {
                if (filter != null) {
                    filter = filter.newExpression(ctx);
                }
                cursors[s - 1] = cs = this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
                ((IDWCursor)cs).setSegment(startBlock, blockCount);
                for (i = 1; i < s; ++i) {
                    if (isEquals[i]) continue;
                    seq = ColPhyTable.fetchToValue((IDWCursor)cursors[i], dimFields, minValues[i]);
                    ((IDWCursor)cursors[i - 1]).setAppendData(seq);
                }
            } else {
                if (filter != null) {
                    filter = filter.newExpression(ctx);
                }
                cursors[s - 1] = cs = this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
                ((IDWCursor)cs).setSegment(startBlock, blockCount - 1);
                for (i = 1; i < s; ++i) {
                    if (isEquals[i]) continue;
                    seq = ColPhyTable.fetchToValue((IDWCursor)cursors[i], dimFields, minValues[i]);
                    ((IDWCursor)cursors[i - 1]).setAppendData(seq);
                }
                if (filter != null) {
                    filter = filter.newExpression(ctx);
                }
                cursors[dataSegCount - 1] = new Cursor(this, exps, fields, filter, fkNames, codes, opts, ctx);
                ((IDWCursor)cursors[dataSegCount - 1]).setSegment(blockCount - 1, blockCount);
                Sequence seq2 = ColPhyTable.fetchToValue((IDWCursor)cursors[dataSegCount - 1], dimFields, minValues[s]);
                ((IDWCursor)cursors[s - 1]).setAppendData(seq2);
                while (s < dataSegCount - 1) {
                    if (filter != null) {
                        filter = filter.newExpression(ctx);
                    }
                    cursors[s] = new Cursor(this, exps, fields, filter, fkNames, codes, opts, ctx);
                    ((IDWCursor)cursors[s]).setSegment(blockCount - 1, blockCount - 1);
                    seq2 = ColPhyTable.fetchToValue((IDWCursor)cursors[dataSegCount - 1], dimFields, minValues[s + 1]);
                    ((IDWCursor)cursors[s]).setAppendData(seq2);
                    ++s;
                }
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        csList.clear();
        int len2 = cursors.length - 1;
        if (seg != 1) {
            for (int i = 1; i < len2; ++i) {
                csList.add(cursors[i]);
            }
        } else {
            for (int i = 0; i < len2; ++i) {
                csList.add(cursors[i]);
            }
        }
        if (seg + 1 > endValues.length) {
            csList.add(cursors[len2]);
        }
        cursors = new ICursor[csList.size()];
        csList.toArray(cursors);
        return new MultipathCursors(cursors, ctx);
    }

    @Override
    public void addColumn(String colName, Expression exp, Context ctx) {
        ColumnMetaData existCol;
        if (this.getModifyRecords() != null) {
            this.groupTable.reset(null, null, ctx, null);
        }
        if (null != (existCol = this.getColumn(colName)) && (existCol.isDim() || existCol.isKey() || this.getModifyRecords() != null)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("alter" + mm.getMessage("dw.columnNotEditable"));
        }
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd != null) {
            tmd.addColumn(colName, exp, ctx);
        }
        ColumnMetaData col = new ColumnMetaData(this, colName, false, false);
        ICursor cursor = this.cursor();
        BlockLinkReader rowCountReader = this.getSegmentReader();
        try {
            col._$1();
            col._$2();
            col.prepareWrite();
            int curBlock = 0;
            int endBlock = this.getDataBlockCount();
            while (curBlock < endBlock) {
                ++curBlock;
                int recordCount = rowCountReader.readInt32();
                Sequence data = cursor.fetch(recordCount);
                data = data.newTable(new String[]{""}, new Expression[]{exp}, ctx);
                Object[] minValues = new Object[1];
                Object[] maxValues = new Object[1];
                Object[] startValues = new Object[1];
                int[] dataTypeInfo = new int[1];
                BufferWriter bufferWriter = col.getColDataBufferWriter();
                Sequence dict = col.getDict();
                int len = data.length();
                DataBlockWriterJob.writeDataBlock(bufferWriter, data, dict, 0, 1, len, maxValues, minValues, startValues, dataTypeInfo);
                boolean doCheck = this.groupTable.isCheckDataPure();
                col.adjustDataType(dataTypeInfo[0], doCheck);
                col.appendColBlock(bufferWriter.finish(), minValues[0], maxValues[0], startValues[0]);
            }
            col.finishWrite();
            cursor.close();
            if (existCol != null) {
                for (ColumnMetaData column : this._$8) {
                    if (!column.getColName().equals(colName)) continue;
                    this._$8[i] = col;
                    break;
                }
                this.groupTable._$3();
            } else {
                ColumnMetaData[] newColumns = Arrays.copyOf(this._$8, this._$8.length + 1);
                String[] newColNames = Arrays.copyOf(this.colNames, this.colNames.length + 1);
                newColumns[this._$8.length] = col;
                newColNames[this._$8.length] = colName;
                this._$8 = newColumns;
                this.colNames = newColNames;
                this.groupTable._$3();
            }
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteColumn(String colName) {
        ColumnMetaData col;
        PhyTable tmd;
        if (this.getModifyRecords() != null) {
            this.groupTable.reset(null, null, new Context(), null);
        }
        if ((tmd = this.getSupplementTable(false)) != null) {
            tmd.deleteColumn(colName);
        }
        if ((col = this.getColumn(colName)) == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("alter" + mm.getMessage("dw.columnNotExist"));
        }
        if (col.isDim() || col.isKey()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("alter" + mm.getMessage("dw.columnNotEditable"));
        }
        ColumnMetaData[] newColumns = new ColumnMetaData[this._$8.length - 1];
        String[] newColNames = new String[this.colNames.length - 1];
        int i = 0;
        for (ColumnMetaData cmd : this._$8) {
            if (cmd == col) continue;
            newColumns[i] = cmd;
            newColNames[i++] = cmd.getColName();
        }
        this._$8 = newColumns;
        this.colNames = newColNames;
        try {
            this.groupTable._$3();
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }
}

