/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.common.MD5;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileGroup;
import com.scudata.dm.FileObject;
import com.scudata.dm.IFile;
import com.scudata.dm.LongArray;
import com.scudata.dm.NonLocalFile;
import com.scudata.dm.cursor.ConjxCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MergeCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.cursor.UpdateIdCursor;
import com.scudata.dm.cursor.UpdateMergeCursor;
import com.scudata.dw.BlockLink;
import com.scudata.dw.ColComTable;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.Cursor;
import com.scudata.dw.IBlockStorage;
import com.scudata.dw.IPhyTable;
import com.scudata.dw.JoinTableCursor;
import com.scudata.dw.PhyTable;
import com.scudata.dw.PhyTableGroup;
import com.scudata.dw.RowComTable;
import com.scudata.dw.RowCursor;
import com.scudata.dw.RowPhyTable;
import com.scudata.dw.StructManager;
import com.scudata.expression.mfn.dw.Append;
import com.scudata.expression.mfn.dw.CreateCursor;
import com.scudata.resources.EngineMessage;
import com.scudata.util.FileSyncManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComTable
implements IBlockStorage {
    public static final String SF_SUFFIX = ".ext";
    protected static int MIN_BLOCK_SIZE = 4096;
    protected FileObject fileObject;
    protected File file;
    protected RandomAccessFile raf;
    protected PhyTable baseTable;
    protected int blockSize;
    protected transient int enlargeSize;
    protected BlockLink headerBlockLink;
    protected byte[] reserve = new byte[32];
    protected long freePos = 0L;
    protected long fileSize;
    protected String writePswHash;
    protected String readPswHash;
    protected String distribute;
    protected StructManager structManager;
    protected transient Context ctx;
    private transient ComTable _$3;
    private transient Integer _$2;
    private transient int _$1;

    public static File getSupplementFile(File file) {
        String pathName = file.getAbsolutePath();
        pathName = pathName + SF_SUFFIX;
        return new File(pathName);
    }

    public ComTable dupStruct(File sf) {
        this.checkWritable();
        ComTable newGroupTable = null;
        try {
            newGroupTable = this instanceof ColComTable ? new ColComTable(sf, (ColComTable)this) : new RowComTable(sf, (RowComTable)this);
        }
        catch (Exception e) {
            if (newGroupTable != null) {
                newGroupTable.close();
            }
            sf.delete();
            throw new RQException(e.getMessage(), e);
        }
        return newGroupTable;
    }

    public ComTable getSupplement(boolean isCreate) {
        if (this.file == null) {
            return null;
        }
        if (this._$3 == null) {
            File sf = ComTable.getSupplementFile(this.file);
            if (sf.exists()) {
                try {
                    this._$3 = ComTable.open(sf, this.ctx);
                }
                catch (IOException e) {
                    throw new RQException(e);
                }
            } else if (isCreate) {
                this._$3 = this.dupStruct(sf);
            }
        }
        return this._$3;
    }

    public static ComTable open(File file, Context ctx) throws IOException {
        if (!file.exists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileNotExist", file.getAbsolutePath()));
        }
        RandomAccessFile raf = file.canWrite() ? new RandomAccessFile(file, "rw") : new RandomAccessFile(file, "r");
        try {
            raf.seek(6L);
            if (raf.length() == 0L) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            int flag = raf.read();
            if (flag == 114) {
                RowComTable rowComTable = new RowComTable(file, ctx);
                return rowComTable;
            }
            if (flag == 99 || flag == 67) {
                ColComTable colComTable = new ColComTable(file, ctx);
                return colComTable;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        finally {
            raf.close();
        }
    }

    public static ComTable open(FileObject fo, Context ctx) throws IOException {
        ComTable comTable;
        IFile ifile = fo.getFile();
        if (!ifile.exists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileNotExist", fo.getFileName()));
        }
        File file = fo.getLocalFile().file();
        if (file == null) {
            file = new NonLocalFile(fo.getFileName(), fo);
        }
        RandomAccessFile raf = ifile.getRandomAccessFile();
        raf.seek(6L);
        if (raf.length() == 0L) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        int flag = raf.read();
        if (flag == 114) {
            comTable = new RowComTable(file, raf, ctx);
        } else if (flag == 99 || flag == 67) {
            comTable = new ColComTable(file, raf, ctx);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        comTable.setFileObject(fo);
        return comTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComTable createGroupTable(File file) throws IOException {
        if (!file.exists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileNotExist", file.getAbsolutePath()));
        }
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            raf.seek(6L);
            if (raf.read() == 114) {
                RowComTable rowComTable = new RowComTable(file);
                return rowComTable;
            }
            ColComTable colComTable = new ColComTable(file);
            return colComTable;
        }
        finally {
            raf.close();
        }
    }

    public static PhyTable openBaseTable(File file, Context ctx) {
        try {
            ComTable groupTable = ComTable.open(file, ctx);
            return groupTable.getBaseTable();
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public static PhyTable openBaseTable(FileObject fo, Context ctx) {
        ComTable comTable;
        IFile ifile = fo.getFile();
        if (!ifile.exists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileNotExist", fo.getFileName()));
        }
        File file = fo.getLocalFile().file();
        try {
            RandomAccessFile raf = ifile.getRandomAccessFile();
            raf.seek(6L);
            comTable = raf.read() == 114 ? new RowComTable(file, raf, ctx) : new ColComTable(file, raf, ctx);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        Integer partition = fo.getPartition();
        if (partition != null && partition >= 0) {
            comTable.setPartition(partition);
        }
        comTable.setFileObject(fo);
        return comTable.getBaseTable();
    }

    public PhyTable getBaseTable() {
        return this.baseTable;
    }

    protected void setBlockSize(int size) {
        this.blockSize = size;
        this.enlargeSize = size * 16;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void delete() {
        this.checkWritable();
        ComTable sgt = this.getSupplement(false);
        if (sgt != null) {
            sgt.delete();
        }
        PhyTable table = this.getBaseTable();
        try {
            table.deleteIndex(null);
            table.deleteCuboid(null);
            ArrayList<PhyTable> tables = table.getTableList();
            for (PhyTable td : tables) {
                td.deleteIndex(null);
                td.deleteCuboid(null);
            }
            this.close();
            this.file.delete();
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.baseTable.appendCache();
            ArrayList<PhyTable> tables = this.baseTable.getTableList();
            for (PhyTable table : tables) {
                table.appendCache();
            }
            this.raf.close();
            if (this._$3 != null) {
                this._$3.close();
            }
            if (this.ctx != null) {
                this.ctx.removeResource(this);
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    protected abstract void readHeader() throws IOException;

    protected abstract void writeHeader() throws IOException;

    protected void flush() throws IOException {
        this.raf.getChannel().force(false);
    }

    void _$3() throws IOException {
        this.writeHeader();
        this.flush();
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public synchronized void loadBlock(long pos, byte[] block) throws IOException {
        this.raf.seek(pos);
        this.raf.readFully(block);
    }

    @Override
    public void saveBlock(long pos, byte[] block) throws IOException {
        this.raf.seek(pos);
        this.raf.write(block);
    }

    @Override
    public void saveBlock(long pos, byte[] block, int off, int len) throws IOException {
        this.raf.seek(pos);
        this.raf.write(block, off, len);
    }

    @Override
    public long applyNewBlock() throws IOException {
        long pos = this.freePos;
        if (pos >= this.fileSize) {
            this._$2();
        }
        this.freePos += (long)this.blockSize;
        return pos;
    }

    private void _$2() throws IOException {
        this.fileSize += (long)this.enlargeSize;
        this.raf.setLength(this.fileSize);
    }

    @Override
    public StructManager getStructManager() {
        return this.structManager;
    }

    int _$1(DataStruct ds) {
        return this.structManager.getDataStructID(ds);
    }

    DataStruct _$1(int id) {
        return this.structManager.getDataStruct(id);
    }

    public File getFile() {
        return this.file;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public void setFileObject(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    protected void beginTransaction(PhyTable table) throws IOException {
        byte[] bytes = new byte[this.blockSize];
        this.raf.seek(0L);
        this.raf.readFully(bytes);
        byte[] mac = MD5.get(bytes);
        String dir = this.file.getAbsolutePath() + "_TransactionLog";
        FileObject logFile = new FileObject(dir);
        logFile.delete();
        RandomAccessFile raf = new RandomAccessFile(logFile.getLocalFile().file(), "rw");
        raf.seek(0L);
        raf.write(bytes);
        raf.write(mac);
        raf.getChannel().force(false);
        raf.close();
        if (table != null) {
            if (table.indexNames == null) {
                return;
            }
            dir = this.file.getAbsolutePath() + "_I_TransactionLog";
            logFile = new FileObject(dir);
            logFile.delete();
            raf = new RandomAccessFile(logFile.getLocalFile().file(), "rw");
            raf.seek(0L);
            raf.writeUTF(table.tableName);
            raf.getChannel().force(false);
            raf.close();
        }
    }

    protected void commitTransaction(int step) {
        if (step == 1) {
            String dir = this.file.getAbsolutePath() + "_I_TransactionLog";
            FileObject logFile = new FileObject(dir);
            logFile.delete();
        } else {
            String dir = this.file.getAbsolutePath() + "_TransactionLog";
            FileObject logFile = new FileObject(dir);
            logFile.delete();
        }
    }

    protected void restoreTransaction() {
        String dir = this.file.getAbsolutePath() + "_TransactionLog";
        FileObject logFile = new FileObject(dir);
        if (logFile.isExists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(this.file.getName() + mm.getMessage("dw.needRollback"));
        }
        dir = this.file.getAbsolutePath() + "_I_TransactionLog";
        logFile = new FileObject(dir);
        if (logFile.isExists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(this.file.getName() + mm.getMessage("dw.needRollback"));
        }
    }

    public boolean reset(File file, String opt, Context ctx, String distribute) {
        return this.reset(file, opt, ctx, distribute, null, null);
    }

    private void _$1(PhyTable table, MultipathCursors mcs, Context ctx) throws IOException {
        int i;
        int num = mcs.getPathCount();
        ColPhyTable[] tables = new ColPhyTable[num];
        File[] files = new File[num];
        Thread[] threads = new Thread[num];
        tables[0] = (ColPhyTable)table;
        for (i = 1; i < num; ++i) {
            FileObject tmp = FileObject.createTempFileObject();
            files[i] = tmp.getLocalFile().file();
            ((ColPhyTable)table).getGroupTable().reset(files[i], "S", null, null);
            tables[i] = (ColPhyTable)ComTable.openBaseTable(files[i], ctx);
        }
        for (i = 0; i < num; ++i) {
            threads[i] = Append.newAppendThread(tables[i], mcs.getPathCursor(i), null);
            threads[i].start();
        }
        for (i = 0; i < num; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        for (i = 1; i < num; ++i) {
            table.append(tables[i]);
            tables[i].getGroupTable().delete();
        }
    }

    public boolean reset(File file, String opt, Context ctx, String distribute, Integer blockSize, ICursor cursor) {
        File newFile;
        this.checkWritable();
        if (distribute == null) {
            distribute = this.distribute;
        }
        boolean isCol = this instanceof ColComTable;
        boolean hasQ = false;
        boolean hasN = false;
        boolean hasW = false;
        boolean onlyDataStruct = false;
        boolean compress = false;
        boolean uncompress = false;
        boolean hasP = false;
        if (opt != null) {
            if (opt.indexOf(114) != -1) {
                isCol = false;
            } else if (opt.indexOf(99) != -1) {
                isCol = true;
            }
            if (opt.indexOf(117) != -1) {
                uncompress = true;
            }
            if (opt.indexOf(122) != -1) {
                compress = true;
            }
            if (opt.indexOf(119) != -1) {
                hasW = true;
            }
            if (opt.indexOf(83) != -1) {
                onlyDataStruct = true;
            }
            if (compress && uncompress) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(opt + mm.getMessage("engine.optConflict"));
            }
            if (opt.indexOf(113) != -1) {
                // empty if block
            }
            if (opt.indexOf(110) != -1) {
                hasN = true;
                if (file == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("reset" + mm.getMessage("function.invalidParam"));
                }
            }
            if (opt.indexOf(112) != -1 && cursor == null && isCol && !hasW) {
                hasP = true;
            }
        }
        ComTable sgt = this.getSupplement(false);
        if (hasQ && sgt != null) {
            sgt.reset(file, opt, ctx, distribute, blockSize, null);
            sgt.close();
            sgt = null;
        }
        String[] srcColNames = this.baseTable.getColNames();
        int len = srcColNames.length;
        String[] colNames = new String[len];
        if (this.baseTable instanceof ColPhyTable) {
            for (int i = 0; i < len; ++i) {
                ColumnMetaData col = ((ColPhyTable)this.baseTable).getColumn(srcColNames[i]);
                colNames[i] = col.isDim() ? "#" + srcColNames[i] : srcColNames[i];
            }
        } else {
            boolean[] isDim = ((RowPhyTable)this.baseTable).getDimIndex();
            for (int i = 0; i < len; ++i) {
                colNames[i] = isDim[i] ? "#" + srcColNames[i] : srcColNames[i];
            }
        }
        FileObject newFileObj = null;
        if (file == null) {
            newFileObj = new FileObject(this.file.getAbsolutePath());
            newFileObj = new FileObject(newFileObj.createTempFile(this.file.getName()));
            newFile = newFileObj.getLocalFile().file();
        } else {
            newFile = file;
        }
        String newOpt = "";
        String segmentCol = this.baseTable.getSegmentCol();
        if (segmentCol != null) {
            newOpt = newOpt + "p";
        }
        if (this.baseTable.groupTable.hasDeleteKey()) {
            newOpt = newOpt + "d";
        }
        ComTable newGroupTable = null;
        try {
            String[] indexNames;
            boolean needSeg;
            if (isCol) {
                newGroupTable = new ColComTable(newFile, colNames, distribute, newOpt, blockSize, ctx);
                if (compress) {
                    newGroupTable.setCompress(true);
                } else if (uncompress) {
                    newGroupTable.setCompress(false);
                } else {
                    newGroupTable.setCompress(this.isCompress());
                }
            } else {
                newGroupTable = new RowComTable(newFile, colNames, distribute, newOpt, blockSize, ctx);
            }
            boolean bl = needSeg = this.baseTable.segmentCol != null;
            if (needSeg) {
                newGroupTable.baseTable.setSegmentCol(this.baseTable.segmentCol, this.baseTable.segmentSerialLen);
            }
            PhyTable newBaseTable = newGroupTable.baseTable;
            ArrayList<PhyTable> tableList = this.baseTable.tableList;
            for (PhyTable t : tableList) {
                int i;
                srcColNames = t.getColNames();
                len = srcColNames.length;
                colNames = new String[len];
                if (t instanceof ColPhyTable) {
                    for (i = 0; i < len; ++i) {
                        ColumnMetaData col = ((ColPhyTable)t).getColumn(srcColNames[i]);
                        colNames[i] = col.isDim() ? "#" + srcColNames[i] : srcColNames[i];
                    }
                } else {
                    for (i = 0; i < len; ++i) {
                        boolean[] isDim = ((RowPhyTable)t).getDimIndex();
                        colNames[i] = isDim[i] ? "#" + srcColNames[i] : srcColNames[i];
                    }
                }
                newBaseTable.createAnnexTable(colNames, t.getSerialBytesLen(), t.tableName);
            }
            if (hasN) {
                newGroupTable._$3();
                newGroupTable.close();
                return Boolean.TRUE;
            }
            ICursor cs = null;
            if (hasQ) {
                cs = this.baseTable instanceof ColPhyTable ? new Cursor((ColPhyTable)this.baseTable) : new RowCursor((RowPhyTable)this.baseTable);
            } else if (!onlyDataStruct) {
                cs = hasP ? CreateCursor.createCursor(this.baseTable, null, "m", ctx) : this.baseTable.cursor();
            }
            int startBlock = -1;
            if (hasQ) {
                startBlock = this.baseTable.getFirstBlockFromModifyRecord();
                tableList = this.baseTable.tableList;
                for (PhyTable t : tableList) {
                    int blk = t.getFirstBlockFromModifyRecord();
                    if (startBlock == -1) {
                        startBlock = blk;
                        continue;
                    }
                    if (blk == -1 || startBlock <= blk) continue;
                    startBlock = blk;
                }
                if (startBlock < 0) {
                    newGroupTable.delete();
                    return Boolean.FALSE;
                }
                if (startBlock == 0) {
                    hasQ = false;
                } else {
                    ((Cursor)cs).setSegment(startBlock, this.baseTable.getDataBlockCount());
                }
            }
            if (cs != null && cursor != null) {
                DataStruct ds1 = cs.getDataStruct();
                DataStruct ds2 = cursor.peek(1).dataStruct();
                int count = ds1.getFieldCount();
                for (int i = 0; i < count; ++i) {
                    if (ds1.getFieldName(i).equals(ds2.getFieldName(i))) continue;
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("reset" + mm.getMessage("engine.dsNotMatch"));
                }
                if (hasW) {
                    int deleteField = this.baseTable.getDeleteFieldIndex(null, ds1.getFieldNames());
                    cursor = new UpdateIdCursor(cursor, ds1.getPKIndex(), deleteField);
                    ICursor[] cursors = new ICursor[]{cs, cursor};
                    cs = new UpdateMergeCursor(cursors, ds1.getPKIndex(), deleteField, ctx);
                } else if (newBaseTable.hasPrimaryKey()) {
                    ICursor[] cursors = new ICursor[]{cs, cursor};
                    cs = new MergeCursor(cursors, ds1.getPKIndex(), null, ctx);
                } else {
                    ICursor[] cursors = new ICursor[]{cs, cursor};
                    cs = new ConjxCursor(cursors);
                }
            }
            if (cs != null) {
                if (hasP && cs instanceof MultipathCursors) {
                    this._$1(newBaseTable, (MultipathCursors)cs, ctx);
                } else {
                    newBaseTable.append(cs);
                    newBaseTable.appendCache();
                }
            }
            for (PhyTable t : tableList) {
                PhyTable newTable = newBaseTable.getAnnexTable(t.tableName);
                cs = hasQ ? (t instanceof ColPhyTable ? new Cursor((ColPhyTable)t, t.allColNames) : new RowCursor((RowPhyTable)t, t.allColNames)) : t.cursor(t.allColNames);
                if (hasQ) {
                    ((JoinTableCursor)cs).setSegment(startBlock, t.getDataBlockCount());
                }
                newTable.append(cs);
                newTable.appendCache();
            }
            if (file != null) {
                newGroupTable.close();
                return Boolean.TRUE;
            }
            if (hasQ) {
                long freePos = this.baseTable.resetByBlock(startBlock);
                for (PhyTable t : tableList) {
                    long pos = t.resetByBlock(startBlock);
                    if (freePos >= pos) continue;
                    freePos = pos;
                }
                this.freePos = freePos;
                this._$3();
                this.readHeader();
                tableList = this.baseTable.tableList;
                cs = newBaseTable.cursor();
                this.baseTable.append(cs);
                ArrayList<PhyTable> newTableList = newBaseTable.tableList;
                for (int i = 0; i < tableList.size(); ++i) {
                    PhyTable t = newTableList.get(i);
                    cs = t.cursor(t.allColNames);
                    tableList.get(i).append(cs);
                }
                newGroupTable.close();
                newGroupTable.file.delete();
                this.baseTable.resetIndex(ctx);
                newTableList = this.baseTable.tableList;
                for (PhyTable table : newTableList) {
                    table.resetIndex(ctx);
                }
                return Boolean.TRUE;
            }
            if (sgt != null) {
                sgt.delete();
            }
            if ((indexNames = this.baseTable.indexNames) != null) {
                String[][] indexFields = this.baseTable.indexFields;
                String[][] indexValueFields = this.baseTable.indexValueFields;
                int size = indexNames.length;
                for (int j = 0; j < size; ++j) {
                    newBaseTable.addIndex(indexNames[j], indexFields[j], indexValueFields[j]);
                }
            }
            ArrayList<PhyTable> newTableList = newBaseTable.tableList;
            len = tableList.size();
            for (int i = 0; i < len; ++i) {
                PhyTable oldTable = tableList.get(i);
                PhyTable newTable = newTableList.get(i);
                indexNames = oldTable.indexNames;
                if (indexNames == null) continue;
                String[][] indexFields = oldTable.indexFields;
                String[][] indexValueFields = oldTable.indexValueFields;
                int size = indexNames.length;
                for (int j = 0; j < size; ++j) {
                    newTable.addIndex(indexNames[j], indexFields[j], indexValueFields[j]);
                }
            }
            String[] cuboids = this.baseTable.cuboids;
            if (cuboids != null) {
                for (String cuboid : cuboids) {
                    newBaseTable.addCuboid(cuboid);
                }
            }
            for (int i = 0; i < len; ++i) {
                PhyTable oldTable = tableList.get(i);
                PhyTable newTable = newTableList.get(i);
                cuboids = oldTable.cuboids;
                if (cuboids == null) continue;
                for (String addCuboid : cuboids) {
                    newTable.addCuboid(addCuboid);
                }
            }
        }
        catch (Exception e) {
            if (newGroupTable != null) {
                newGroupTable.close();
            }
            newFile.delete();
            throw new RQException(e.getMessage(), e);
        }
        String path = this.file.getAbsolutePath();
        this.close();
        boolean b = this.file.delete();
        if (!b) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("reset" + mm.getMessage("file.deleteFailed"));
        }
        newGroupTable.close();
        newFileObj.move(path, null);
        try {
            newGroupTable = ComTable.open(this.file, ctx);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        newGroupTable.baseTable.resetIndex(ctx);
        newGroupTable.baseTable.resetCuboid(ctx);
        ArrayList<PhyTable> newTableList = newGroupTable.baseTable.tableList;
        for (PhyTable table : newTableList) {
            table.resetIndex(ctx);
            table.resetCuboid(ctx);
        }
        newGroupTable.close();
        return Boolean.TRUE;
    }

    public boolean resetFileGroup(FileGroup fileGroup, String opt, Context ctx, String distribute, Integer blockSize, ICursor cursor) {
        String segmentCol;
        if (distribute == null) {
            distribute = this.distribute;
        }
        boolean isCol = this instanceof ColComTable;
        boolean uncompress = false;
        boolean hasW = false;
        if (opt != null) {
            if (opt.indexOf(114) != -1) {
                isCol = false;
            } else if (opt.indexOf(99) != -1) {
                isCol = true;
            }
            if (opt.indexOf(117) != -1) {
                uncompress = true;
            }
            if (opt.indexOf(122) != -1) {
                uncompress = false;
            }
            if (opt.indexOf(119) != -1) {
                hasW = false;
            }
        }
        String[] srcColNames = this.baseTable.getColNames();
        int len = srcColNames.length;
        String[] colNames = new String[len];
        if (this.baseTable instanceof ColPhyTable) {
            for (int i = 0; i < len; ++i) {
                ColumnMetaData col = ((ColPhyTable)this.baseTable).getColumn(srcColNames[i]);
                colNames[i] = col.isDim() ? "#" + srcColNames[i] : srcColNames[i];
            }
        } else {
            boolean[] isDim = ((RowPhyTable)this.baseTable).getDimIndex();
            for (int i = 0; i < len; ++i) {
                colNames[i] = isDim[i] ? "#" + srcColNames[i] : srcColNames[i];
            }
        }
        String newOpt = "";
        if (opt != null && opt.indexOf(121) != -1) {
            newOpt = "y";
        }
        if ((segmentCol = this.baseTable.getSegmentCol()) != null) {
            newOpt = "p";
        }
        newOpt = isCol ? newOpt + 'c' : newOpt + 'r';
        if (uncompress) {
            newOpt = newOpt + 'u';
        }
        if (this.baseTable.groupTable.hasDeleteKey()) {
            newOpt = newOpt + "d";
        }
        try {
            PhyTableGroup newTableGroup = fileGroup.create(colNames, distribute, newOpt, blockSize, ctx);
            ICursor cs = this.baseTable.cursor();
            if (cursor != null) {
                DataStruct ds1 = cs.getDataStruct();
                DataStruct ds2 = cursor.getDataStruct();
                int count = ds1.getFieldCount();
                for (int i = 0; i < count; ++i) {
                    if (ds1.getFieldName(i).equals(ds2.getFieldName(i))) continue;
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("reset" + mm.getMessage("engine.dsNotMatch"));
                }
                if (hasW) {
                    int deleteField = this.baseTable.getDeleteFieldIndex(null, ds1.getFieldNames());
                    ICursor[] cursors = new ICursor[]{cs, cursor};
                    cs = new UpdateMergeCursor(cursors, ds1.getPKIndex(), deleteField, ctx);
                } else if (this.baseTable.hasPrimaryKey()) {
                    ICursor[] cursors = new ICursor[]{cs, cursor};
                    cs = new MergeCursor(cursors, ds1.getPKIndex(), null, ctx);
                } else {
                    ICursor[] cursors = new ICursor[]{cs, cursor};
                    cs = new ConjxCursor(cursors);
                }
            }
            newTableGroup.append(cs, "xi");
            ArrayList<PhyTable> tableList = this.baseTable.tableList;
            for (PhyTable t : tableList) {
                len = t.colNames.length;
                colNames = Arrays.copyOf(t.colNames, len);
                if (t instanceof ColPhyTable) {
                    for (int i = 0; i < len; ++i) {
                        ColumnMetaData col = ((ColPhyTable)t).getColumn(colNames[i]);
                        if (!col.isDim()) continue;
                        colNames[i] = "#" + colNames[i];
                    }
                } else {
                    boolean[] isDim = ((RowPhyTable)t).getDimIndex();
                    for (int i = 0; i < len; ++i) {
                        if (!isDim[i]) continue;
                        colNames[i] = "#" + colNames[i];
                    }
                }
                IPhyTable newTable = newTableGroup.createAnnexTable(colNames, t.getSerialBytesLen(), t.tableName);
                String[] allColNames = Arrays.copyOf(srcColNames, srcColNames.length + t.colNames.length);
                System.arraycopy(t.colNames, 0, allColNames, srcColNames.length, t.colNames.length);
                cs = t.cursor(allColNames);
                newTable.append(cs, "xi");
            }
            newTableGroup.close();
            return Boolean.TRUE;
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public abstract long[] getBlockLinkInfo();

    public long[] cmpBlockLinkInfo(long[] blockLinkInfo) {
        long[] localBlockInfo = this.getBlockLinkInfo();
        int localSize = localBlockInfo.length / 4;
        int size = blockLinkInfo.length / 4;
        LongArray posArray = new LongArray(1024);
        for (int i = 0; i < size; ++i) {
            long firstBlockPos = blockLinkInfo[i * 4];
            long lastBlockPos = blockLinkInfo[i * 4 + 1];
            int freeIndex = (int)blockLinkInfo[i * 4 + 2];
            int blockCount = (int)blockLinkInfo[i * 4 + 3];
            if (firstBlockPos >= this.fileSize) continue;
            boolean find = false;
            for (int j = 0; j < localSize; ++j) {
                long localFirstBlockPos = localBlockInfo[j * 4];
                long localLastBlockPos = localBlockInfo[j * 4 + 1];
                int localFreeIndex = (int)localBlockInfo[j * 4 + 2];
                int localBlockCount = (int)localBlockInfo[j * 4 + 3];
                if (firstBlockPos != localFirstBlockPos) continue;
                find = true;
                if (lastBlockPos < localLastBlockPos) {
                    // empty if block
                }
                if (lastBlockPos == localLastBlockPos && freeIndex == localFreeIndex && blockCount == localBlockCount) break;
                posArray.add(localLastBlockPos);
                break;
            }
            if (find) continue;
            posArray.add(firstBlockPos);
        }
        if (posArray.size() == 0) {
            return null;
        }
        return posArray.toArray();
    }

    public long[] getSyncPosition(long[] positions) {
        LongArray posArray = new LongArray(1024);
        byte[] block = new byte[5];
        for (long pos : positions) {
            if (pos <= 1L) continue;
            try {
                while (pos > 1L) {
                    posArray.add(pos);
                    this.raf.seek(pos + (long)this.blockSize - 5L);
                    this.raf.read(block);
                    pos = ((long)(block[0] & 0xFF) << 32) + ((long)(block[1] & 0xFF) << 24) + (long)((block[2] & 0xFF) << 16) + (long)((block[3] & 0xFF) << 8) + (long)(block[4] & 0xFF);
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        if (posArray.size() == 0) {
            return null;
        }
        return posArray.toArray();
    }

    public long[] getModifyPosition() {
        int count = 1 + this.baseTable.tableList.size();
        long[] positions = new long[count * 2];
        int c = 0;
        positions[c++] = this.baseTable.modifyBlockLink1._$4;
        positions[c++] = this.baseTable.modifyBlockLink2._$4;
        for (PhyTable table : this.baseTable.tableList) {
            positions[c++] = table.modifyBlockLink1._$4;
            positions[c++] = table.modifyBlockLink2._$4;
        }
        LongArray posArray = new LongArray(1024);
        byte[] block = new byte[5];
        for (long pos : positions) {
            if (pos <= 1L) continue;
            try {
                while (pos > 1L) {
                    posArray.add(pos);
                    this.raf.seek(pos + (long)this.blockSize - 5L);
                    this.raf.read(block);
                    pos = ((long)(block[0] & 0xFF) << 32) + ((long)(block[1] & 0xFF) << 24) + (long)((block[2] & 0xFF) << 16) + (long)((block[3] & 0xFF) << 8) + (long)(block[4] & 0xFF);
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        if (posArray.size() == 0) {
            return null;
        }
        return posArray.toArray();
    }

    public long[] getHeaderPosition() {
        LongArray posArray = new LongArray(1024);
        byte[] block = new byte[5];
        long pos = 0L;
        try {
            do {
                posArray.add(pos);
                this.raf.seek(pos + (long)this.blockSize - 5L);
                this.raf.read(block);
            } while ((pos = ((long)(block[0] & 0xFF) << 32) + ((long)(block[1] & 0xFF) << 24) + (long)((block[2] & 0xFF) << 16) + (long)((block[3] & 0xFF) << 8) + (long)(block[4] & 0xFF)) > 1L);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        if (posArray.size() == 0) {
            return null;
        }
        return posArray.toArray();
    }

    void _$1(String writePsw, String readPsw) {
        MD5 md5;
        if (writePsw != null) {
            md5 = new MD5();
            this.writePswHash = md5.getMD5ofStr(writePsw);
        }
        if (readPsw != null) {
            md5 = new MD5();
            this.readPswHash = md5.getMD5ofStr(readPsw);
        }
    }

    public boolean hasPassword() {
        return this.writePswHash != null || this.readPswHash != null;
    }

    public void checkPassword(String psw) {
    }

    public void checkWritable() {
    }

    public void checkReadable() {
    }

    public boolean canWrite() {
        return true;
    }

    public boolean canRead() {
        return true;
    }

    Object _$1() {
        if (this.fileObject != null) {
            return FileSyncManager.getSyncObject(this.fileObject);
        }
        if (this.file != null) {
            return FileSyncManager.getSyncObject(this.file);
        }
        return this.raf;
    }

    public String getDistribute() {
        return this.distribute;
    }

    @Override
    public boolean isCompress() {
        return this.reserve[1] == 0;
    }

    public void setCompress(boolean isCompress) {
        this.reserve[1] = isCompress ? (byte)0 : 1;
    }

    public boolean isCheckDataPure() {
        return this.reserve[2] == 1;
    }

    public void setCheckDataPure(boolean isCheck) {
        this.reserve[2] = isCheck ? (byte)1 : 0;
    }

    public boolean hasTimeKey() {
        return this.reserve[3] == 1;
    }

    public void setTimeKey(boolean hasTimeKey) {
        this.reserve[3] = hasTimeKey ? (byte)1 : 0;
    }

    public boolean hasDeleteKey() {
        return this.reserve[4] == 1;
    }

    public void setDeleteKey(boolean hasDeleteKey) {
        this.reserve[4] = hasDeleteKey ? (byte)1 : 0;
    }

    public void setPartition(Integer partition) {
        this._$2 = partition;
    }

    public Integer getPartition() {
        return this._$2;
    }

    public void setRaf(RandomAccessFile raf) {
        this.raf = raf;
    }

    public RandomAccessFile getRaf() {
        return this.raf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openCursorEvent() {
        Object syncObj;
        Object object = syncObj = this._$1();
        synchronized (object) {
            ++this._$1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCursorEvent() {
        Object syncObj;
        Object object = syncObj = this._$1();
        synchronized (object) {
            --this._$1;
            if (this._$1 <= 0) {
                this.close();
            }
        }
    }

    public List<File> getFiles(boolean self, boolean auto) {
        List<File> files = null;
        ComTable sgt = this.getSupplement(false);
        if (sgt != null) {
            files = sgt.getFiles(true, auto);
        }
        if (files == null) {
            files = new ArrayList<File>();
        }
        PhyTable table = this.getBaseTable();
        String dir = this.getFile().getAbsolutePath() + "_";
        String tableName = table.tableName;
        if (auto) {
            File tmpFile;
            if (table.indexNames != null) {
                for (String name : table.indexNames) {
                    tmpFile = new File(dir + tableName + "_" + name);
                    files.add(tmpFile);
                }
            }
            if (table.cuboids != null) {
                for (String name : table.cuboids) {
                    tmpFile = new File(dir + tableName + "_CUBOID@" + name);
                    files.add(tmpFile);
                }
            }
        }
        if (self) {
            files.add(this.getFile());
        }
        return files;
    }
}

