/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.dm.Table;
import java.math.BigDecimal;
import java.util.Date;

public class DataBlockType {
    private static final double _$9 = 0.8;
    private static final int _$8 = 1;
    private static final int _$7 = 2;
    private static final int _$6 = 4;
    private static final int _$5 = 8;
    public static final int NULL = 0;
    public static final int INT = 16;
    public static final int INT8 = 17;
    public static final int INT16 = 18;
    public static final int INT32 = 20;
    public static final int LONG = 32;
    public static final int LONG8 = 33;
    public static final int LONG16 = 34;
    public static final int LONG32 = 36;
    public static final int LONG64 = 40;
    public static final int DOUBLE = 48;
    public static final int DOUBLE32 = 52;
    public static final int DOUBLE64 = 56;
    public static final int DATE = 64;
    public static final int SEQUENCE = 66;
    public static final int TABLE = 67;
    public static final int RECORD = 68;
    public static final int DECIMAL = 69;
    public static final int SERIALBYTES = 70;
    public static final int STRING = 80;
    public static final int STRING_ASSIC = 81;
    public static final int CONST = 96;
    public static final int OBJECT = 126;
    public static final int DICT = 127;
    public static final int EMPTY = 255;
    public static final int DICT_PUBLIC = 0;
    public static final int DICT_PRIVATE = 1;
    public static final int DICT_PRIVATE_CONST = 2;
    public static final int INC_BLOCK = 3;
    public static final int MAX_DICT_NUMBER = 127;
    private int _$4;
    private boolean _$3;
    private Sequence _$2;
    private int _$1;

    public DataBlockType(int type, boolean hasNull) {
        this.setType(type);
        this.setDataType(type);
        this.setHasNull(hasNull);
    }

    public DataBlockType(int type, int dataType, boolean hasNull) {
        this.setType(type);
        this.setDataType(dataType);
        this.setHasNull(hasNull);
    }

    public DataBlockType(int type, Sequence dict) {
        this.setType(type);
        this.setDict(dict);
    }

    public static DataBlockType getDataBlockType(Sequence data, int col, int start, int end) {
        Sequence seq = data.fieldValues(col);
        Object obj = null;
        for (int i = start; i <= end && (obj = seq.get(i)) == null; ++i) {
        }
        if (obj == null) {
            seq = new Sequence();
            seq.add(null);
            return new DataBlockType(0, true);
        }
        DataBlockType type = null;
        type = obj instanceof Integer ? DataBlockType._$13(seq, start, end) : (obj instanceof Long ? DataBlockType._$12(seq, start, end) : (obj instanceof Double ? DataBlockType._$11(seq, start, end) : (obj instanceof Date ? DataBlockType._$10(seq, start, end) : (obj instanceof String ? DataBlockType._$9(seq, start, end) : (obj instanceof Table ? DataBlockType._$7(seq, start, end) : (obj instanceof Sequence ? DataBlockType._$8(seq, start, end) : (obj instanceof BaseRecord ? DataBlockType._$6(seq, start, end) : (obj instanceof BigDecimal ? DataBlockType._$5(seq, start, end) : (obj instanceof SerialBytes ? DataBlockType._$4(seq, start, end) : new DataBlockType(126, false))))))))));
        if (type._$4 == 17 || type._$4 == 33 || type._$4 == 3) {
            return type;
        }
        DataBlockType dictType = DataBlockType._$14(seq, start, end);
        if (dictType != null) {
            dictType.setDataType(type.getType());
            dictType.setHasNull(type._$3);
            return dictType;
        }
        return type;
    }

    public static int getSequenceDataType(Sequence seq, int start, int end) {
        IArray mems = seq.getMems();
        if (mems instanceof IntArray) {
            return DataBlockType._$1(seq, start, end);
        }
        if (mems instanceof LongArray) {
            return DataBlockType._$2(seq, start, end);
        }
        if (mems instanceof DoubleArray) {
            return DataBlockType._$3(seq, start, end);
        }
        return 0;
    }

    private static DataBlockType _$14(Sequence data, int start, int end) {
        Sequence seq;
        try {
            seq = data.id("u");
        }
        catch (Exception e) {
            return null;
        }
        int len = seq.length();
        if (len > 127) {
            return null;
        }
        return new DataBlockType(127, seq);
    }

    private static int _$1(int v) {
        if (v >= -128 && v <= 127) {
            return 1;
        }
        if (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE) {
            return 2;
        }
        return 4;
    }

    private static int _$1(long v) {
        if (v >= -128L && v <= 127L) {
            return 1;
        }
        if (v >= -32768L && v <= 32767L) {
            return 2;
        }
        if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
            return 4;
        }
        return 8;
    }

    private static int _$1(double d, long v, int scale) {
        if (v <= 16383L) {
            return 2;
        }
        if (v <= 0x3FFFFFFFL) {
            return 4;
        }
        return 8;
    }

    private static int _$1(double d) {
        if (d > 0.0 && d <= 1.073741823E9) {
            double v = Math.ceil(d);
            if (v - d < 1.0E-6) {
                long l = (long)v;
                if (l % 100L == 0L) {
                    return DataBlockType._$1(d, l / 100L, 192);
                }
                return DataBlockType._$1(d, (long)v, 0);
            }
            double d1 = d * 100.0;
            v = Math.ceil(d1);
            if (v - d1 < 1.0E-6) {
                return DataBlockType._$1(d, (long)v, 64);
            }
            d1 = d * 10000.0;
            v = Math.ceil(d1);
            if (v - d1 < 1.0E-6) {
                return DataBlockType._$1(d, (long)v, 128);
            }
            return 8;
        }
        if (d == 0.0) {
            return 2;
        }
        return 8;
    }

    private static DataBlockType _$13(Sequence data, int start, int end) {
        int typeLength = 0;
        int maxTypeLength = 0;
        int maxTypeLengthCount = 0;
        boolean hasNull = false;
        boolean increasing = true;
        if (end - start > 16) {
            Object obj1 = data.get(start);
            Object obj2 = data.get(start + 1);
            if (obj1 != null && obj2 != null && obj1 instanceof Integer && obj2 instanceof Integer) {
                int lastVal = (Integer)obj2;
                int stepVal = (Integer)obj2 - (Integer)obj1;
                for (int i = start + 2; i <= end; ++i) {
                    Object obj = data.get(i);
                    if (obj == null || !(obj instanceof Integer)) {
                        increasing = false;
                        break;
                    }
                    int val = (Integer)obj;
                    if (stepVal != val - lastVal) {
                        increasing = false;
                        break;
                    }
                    lastVal = val;
                }
            } else {
                increasing = false;
            }
            if (increasing) {
                return new DataBlockType(3, 16, false);
            }
        }
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                hasNull = true;
                continue;
            }
            if (!(obj instanceof Integer)) {
                return new DataBlockType(126, hasNull);
            }
            Integer val = (Integer)obj;
            int tl = DataBlockType._$1(val);
            typeLength |= tl;
            if (tl > maxTypeLength) {
                maxTypeLength = tl;
                maxTypeLengthCount = 0;
            }
            if (tl != maxTypeLength) continue;
            ++maxTypeLengthCount;
        }
        if (typeLength == 1) {
            return new DataBlockType(17, hasNull);
        }
        if (typeLength == 2) {
            return new DataBlockType(18, hasNull);
        }
        if (typeLength == 4) {
            return new DataBlockType(20, hasNull);
        }
        double sum = end - start + 1;
        if ((double)maxTypeLengthCount / sum >= 0.8) {
            return new DataBlockType(0x10 | maxTypeLength, hasNull);
        }
        return new DataBlockType(16, hasNull);
    }

    private static DataBlockType _$12(Sequence data, int start, int end) {
        int typeLength = 0;
        int maxTypeLength = 0;
        int maxTypeLengthCount = 0;
        boolean hasNull = false;
        boolean Increasing = true;
        if (end - start > 16) {
            Object obj1 = data.get(start);
            Object obj2 = data.get(start + 1);
            if (obj1 != null && obj2 != null && obj1 instanceof Long && obj2 instanceof Long) {
                long lastVal = (Long)obj2;
                long stepVal = (Long)obj2 - (Long)obj1;
                for (int i = start + 2; i <= end; ++i) {
                    Object obj = data.get(i);
                    if (obj == null || !(obj instanceof Long)) {
                        Increasing = false;
                        break;
                    }
                    Long val = (Long)obj;
                    if (stepVal != val - lastVal) {
                        Increasing = false;
                        break;
                    }
                    lastVal = val;
                }
            } else {
                Increasing = false;
            }
            if (Increasing) {
                return new DataBlockType(3, 32, false);
            }
        }
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                hasNull = true;
                continue;
            }
            if (obj instanceof Integer) {
                obj = ((Integer)obj).longValue();
            }
            if (!(obj instanceof Long)) {
                return new DataBlockType(126, hasNull);
            }
            Long val = (Long)obj;
            int tl = DataBlockType._$1(val);
            typeLength |= tl;
            if (tl > maxTypeLength) {
                maxTypeLength = tl;
                maxTypeLengthCount = 0;
            }
            if (tl != maxTypeLength) continue;
            ++maxTypeLengthCount;
        }
        if (typeLength == 1) {
            return new DataBlockType(33, hasNull);
        }
        if (typeLength == 2) {
            return new DataBlockType(34, hasNull);
        }
        if (typeLength == 4) {
            return new DataBlockType(36, hasNull);
        }
        if (typeLength == 8) {
            return new DataBlockType(40, hasNull);
        }
        double sum = end - start + 1;
        if ((double)maxTypeLengthCount / sum >= 0.8) {
            return new DataBlockType(0x20 | maxTypeLength, hasNull);
        }
        return new DataBlockType(32, hasNull);
    }

    private static DataBlockType _$11(Sequence data, int start, int end) {
        int typeLength = 0;
        int typeLengthCount = 0;
        boolean hasNull = false;
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                hasNull = true;
                continue;
            }
            if (!(obj instanceof Double)) {
                return new DataBlockType(126, hasNull);
            }
            Double val = (Double)obj;
            int tl = DataBlockType._$1(val);
            typeLength |= tl;
            if (tl != 8) continue;
            ++typeLengthCount;
        }
        if (typeLength == 8) {
            return new DataBlockType(56, hasNull);
        }
        double sum = end - start + 1;
        if ((double)typeLengthCount / sum >= 0.8) {
            return new DataBlockType(56, hasNull);
        }
        return new DataBlockType(48, hasNull);
    }

    private static DataBlockType _$10(Sequence data, int start, int end) {
        boolean hasNull = false;
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                hasNull = true;
                continue;
            }
            if (obj instanceof Date) continue;
            return new DataBlockType(126, hasNull);
        }
        return new DataBlockType(64, hasNull);
    }

    private static DataBlockType _$9(Sequence data, int start, int end) {
        boolean hasNull = false;
        boolean isAssic = true;
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                hasNull = true;
                isAssic = false;
                continue;
            }
            if (!(obj instanceof String)) {
                return new DataBlockType(126, hasNull);
            }
            if (!isAssic) continue;
            String str = (String)obj;
            isAssic = StringUtils.isAssicString(str) && str.length() < 128;
        }
        if (isAssic) {
            return new DataBlockType(81, hasNull);
        }
        return new DataBlockType(80, hasNull);
    }

    private static DataBlockType _$8(Sequence data, int start, int end) {
        boolean hasNull = false;
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                hasNull = true;
                continue;
            }
            if (obj instanceof Sequence) continue;
            return new DataBlockType(126, hasNull);
        }
        return new DataBlockType(126, 66, hasNull);
    }

    private static DataBlockType _$7(Sequence data, int start, int end) {
        boolean hasNull = false;
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                hasNull = true;
                continue;
            }
            if (obj instanceof Table) continue;
            return DataBlockType._$8(data, start, end);
        }
        return new DataBlockType(126, 67, hasNull);
    }

    private static DataBlockType _$6(Sequence data, int start, int end) {
        boolean hasNull = false;
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                hasNull = true;
                continue;
            }
            if (obj instanceof BaseRecord) continue;
            return new DataBlockType(126, hasNull);
        }
        return new DataBlockType(126, 68, hasNull);
    }

    private static DataBlockType _$5(Sequence data, int start, int end) {
        boolean hasNull = false;
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                hasNull = true;
                continue;
            }
            if (obj instanceof BigDecimal) continue;
            return new DataBlockType(126, hasNull);
        }
        return new DataBlockType(126, 69, hasNull);
    }

    private static DataBlockType _$4(Sequence data, int start, int end) {
        boolean hasNull = false;
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                hasNull = true;
                continue;
            }
            if (obj instanceof SerialBytes) continue;
            return new DataBlockType(126, hasNull);
        }
        return new DataBlockType(70, hasNull);
    }

    public boolean isHasNull() {
        return this._$3;
    }

    public void setHasNull(boolean hasNull) {
        this._$3 = hasNull;
    }

    public int getType() {
        return this._$4;
    }

    public void setType(int type) {
        this._$4 = type;
    }

    public Sequence getDict() {
        return this._$2;
    }

    public void setDict(Sequence dict) {
        this._$2 = dict;
    }

    public int getDataType() {
        return this._$1;
    }

    public void setDataType(int dataType) {
        this._$1 = dataType;
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                return "Integer";
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 40: {
                return "Long";
            }
            case 48: 
            case 56: {
                return "Double";
            }
            case 64: {
                return "Date";
            }
            case 80: 
            case 81: {
                return "String";
            }
            case 66: {
                return "Sequence";
            }
            case 67: {
                return "Table";
            }
            case 68: {
                return "Record";
            }
            case 69: {
                return "BigDecimal";
            }
            case 255: {
                return "Empty";
            }
            case 70: {
                return "SerialBytes";
            }
            case 0: {
                return "Unknown";
            }
        }
        return "Object : " + type;
    }

    public static String getTypeLen(int type) {
        switch (type) {
            case 17: 
            case 33: {
                return "8";
            }
            case 18: 
            case 34: {
                return "16";
            }
            case 20: 
            case 36: {
                return "32";
            }
            case 40: 
            case 56: {
                return "64";
            }
            case 16: {
                return "VAR";
            }
            case 255: {
                return "0";
            }
            case 0: {
                return "8";
            }
            case 32: 
            case 48: 
            case 64: {
                return "VAR";
            }
            case 70: {
                return "128";
            }
        }
        return "";
    }

    public static Object dictToArray(Sequence dict, int dataType) {
        Object[] resultArray;
        int size = dict.length();
        switch (dataType) {
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                int[] intArray = new int[size + 1];
                for (int i = 1; i <= size; ++i) {
                    Object obj = dict.getMem(i);
                    if (obj != null) {
                        intArray[i] = ((Number)obj).intValue();
                        continue;
                    }
                    intArray[0] = i;
                }
                resultArray = intArray;
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 40: {
                long[] longArray = new long[size + 1];
                for (int i = 1; i <= size; ++i) {
                    Object obj = dict.getMem(i);
                    if (obj != null) {
                        longArray[i] = ((Number)obj).longValue();
                        continue;
                    }
                    longArray[0] = i;
                }
                resultArray = longArray;
                break;
            }
            case 48: 
            case 56: {
                double[] doubleArray = new double[size + 1];
                for (int i = 1; i <= size; ++i) {
                    Object obj = dict.getMem(i);
                    if (obj != null) {
                        doubleArray[i] = ((Number)obj).doubleValue();
                        continue;
                    }
                    doubleArray[0] = i;
                }
                resultArray = doubleArray;
                break;
            }
            case 64: {
                Date[] dateArray = new Date[size + 1];
                for (int i = 1; i <= size; ++i) {
                    Object obj = dict.getMem(i);
                    dateArray[i] = (Date)obj;
                }
                resultArray = dateArray;
                break;
            }
            case 80: 
            case 81: {
                String[] strArray = new String[size + 1];
                for (int i = 1; i <= size; ++i) {
                    Object obj = dict.getMem(i);
                    strArray[i] = (String)obj;
                }
                resultArray = strArray;
                break;
            }
            case 70: {
                SerialBytes[] serArray = new SerialBytes[size + 1];
                for (int i = 1; i <= size; ++i) {
                    Object obj = dict.getMem(i);
                    serArray[i] = (SerialBytes)obj;
                }
                resultArray = serArray;
                break;
            }
            default: {
                return ((ObjectArray)dict.getMems()).getDatas();
            }
        }
        return resultArray;
    }

    private static int _$3(Sequence data, int start, int end) {
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                return 0;
            }
            if (obj instanceof Double) continue;
            return 0;
        }
        return 56;
    }

    private static int _$2(Sequence data, int start, int end) {
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                return 0;
            }
            if (obj instanceof Long) continue;
            return 0;
        }
        return 40;
    }

    private static int _$1(Sequence data, int start, int end) {
        boolean has32 = false;
        for (int i = start; i <= end; ++i) {
            Object obj = data.get(i);
            if (obj == null) {
                return 0;
            }
            if (!(obj instanceof Integer)) {
                return 0;
            }
            Integer val = (Integer)obj;
            int tl = DataBlockType._$1(val);
            if (tl == 8) {
                return 0;
            }
            if (tl != 4) continue;
            has32 = true;
        }
        if (has32) {
            return 20;
        }
        return 18;
    }
}

