/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.IArray;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.dw.BufferWriter;
import com.scudata.dw.DataBlockType;
import com.scudata.thread.Job;
import com.scudata.util.Variant;
import java.io.IOException;

public class DataBlockWriterJob
extends Job {
    private BufferWriter _$10;
    private Sequence _$9;
    private Sequence _$8;
    private int _$7;
    private int _$6;
    private int _$5;
    private Object[] _$4;
    private Object[] _$3;
    private Object[] _$2;
    private int[] _$1;

    public DataBlockWriterJob(BufferWriter bufferWriter, Sequence data, Sequence dict, int col, int start, int end, Object[] maxValues, Object[] minValues, Object[] startValues, int[] dataType) {
        this._$10 = bufferWriter;
        this._$9 = data;
        this._$8 = dict;
        this._$7 = col;
        this._$6 = start;
        this._$5 = end;
        this._$4 = maxValues;
        this._$3 = minValues;
        this._$2 = startValues;
        this._$1 = dataType;
    }

    public void run() {
        try {
            DataBlockWriterJob.writeDataBlock(this._$10, this._$9, this._$8, this._$7, this._$6, this._$5, this._$4, this._$3, this._$2, this._$1);
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    private static void _$1(BufferWriter bufferWriter, Sequence data, Sequence dict, int col, int start, int end, int[] dataType) throws IOException {
        BaseRecord r;
        int i;
        boolean writeNull = false;
        boolean isConst = false;
        IArray mems = data.getMems();
        DataBlockType blockType = DataBlockType.getDataBlockType(data, col, start, end);
        dataType[col] = blockType.getDataType();
        if (blockType == null || blockType.getType() == 126) {
            bufferWriter.write(126);
            for (i = start; i <= end; ++i) {
                r = (BaseRecord)mems.get(i);
                Object[] vals = r.getFieldValues();
                Object obj = vals[col];
                bufferWriter.writeObject(obj);
            }
            bufferWriter.flush();
        } else {
            if (blockType.getType() == 3) {
                bufferWriter.write(3);
                BaseRecord r2 = (BaseRecord)mems.get(start);
                Object obj1 = r2.getNormalFieldValue(col);
                r2 = (BaseRecord)mems.get(start + 1);
                Object obj2 = r2.getNormalFieldValue(col);
                bufferWriter.writeObject(obj1);
                bufferWriter.flush();
                int step = obj1 instanceof Long ? (int)(((Number)obj2).longValue() - ((Number)obj1).longValue()) : ((Number)obj2).intValue() - ((Number)obj1).intValue();
                bufferWriter.writeInt(step);
                return;
            }
            if (blockType.getType() == 127) {
                bufferWriter.write(127);
                Sequence seq = blockType.getDict();
                if (DataBlockWriterJob._$1(dict, seq)) {
                    bufferWriter.write(0);
                    seq = dict;
                } else {
                    bufferWriter.write(1);
                    bufferWriter.writeObject(seq);
                    bufferWriter.flush();
                }
                bufferWriter.write(blockType.getDataType());
                byte[] pos = new byte[end - start + 1];
                int offset = 0;
                for (int i2 = start; i2 <= end; ++i2) {
                    r = (BaseRecord)mems.get(i2);
                    Object obj = r.getNormalFieldValue(col);
                    int idx = seq.firstIndexOf(obj);
                    pos[offset++] = (byte)idx;
                }
                isConst = DataBlockWriterJob._$1(pos);
                bufferWriter.writeBoolean(isConst);
                if (!isConst) {
                    bufferWriter.write(pos);
                } else {
                    pos = new byte[]{pos[0]};
                    bufferWriter.write(pos);
                }
            } else {
                int type = blockType.getType();
                bufferWriter.write(type);
                switch (type) {
                    default: {
                        for (int i3 = start; i3 <= end; ++i3) {
                            r = (BaseRecord)mems.get(i3);
                            Object obj = r.getNormalFieldValue(col);
                            bufferWriter.writeObject(obj);
                        }
                        bufferWriter.flush();
                        break;
                    }
                    case 17: 
                    case 33: {
                        writeNull = true;
                        for (int i4 = start; i4 <= end; ++i4) {
                            r = (BaseRecord)mems.get(i4);
                            Object obj = r.getNormalFieldValue(col);
                            if (obj == null) {
                                bufferWriter.write(0);
                                continue;
                            }
                            bufferWriter.write(((Number)obj).intValue());
                        }
                        break;
                    }
                    case 18: {
                        writeNull = true;
                        bufferWriter.writeNone();
                        for (int i5 = start; i5 <= end; ++i5) {
                            r = (BaseRecord)mems.get(i5);
                            Object obj = r.getNormalFieldValue(col);
                            if (obj == null) {
                                bufferWriter.writeLittleEndianShort(0);
                                continue;
                            }
                            bufferWriter.writeLittleEndianShort((Integer)obj);
                        }
                        break;
                    }
                    case 20: {
                        int i6;
                        writeNull = true;
                        for (i6 = 0; i6 < 3; ++i6) {
                            bufferWriter.writeNone();
                        }
                        for (i6 = start; i6 <= end; ++i6) {
                            r = (BaseRecord)mems.get(i6);
                            Object obj = r.getNormalFieldValue(col);
                            if (obj == null) {
                                bufferWriter.writeLittleEndianInt(0);
                                continue;
                            }
                            bufferWriter.writeLittleEndianInt((Integer)obj);
                        }
                        break;
                    }
                    case 34: {
                        writeNull = true;
                        bufferWriter.writeNone();
                        for (int i7 = start; i7 <= end; ++i7) {
                            r = (BaseRecord)mems.get(i7);
                            Object obj = r.getNormalFieldValue(col);
                            if (obj == null) {
                                bufferWriter.writeLittleEndianShort(0);
                                continue;
                            }
                            bufferWriter.writeLittleEndianShort(((Number)obj).intValue());
                        }
                        break;
                    }
                    case 36: {
                        int i8;
                        writeNull = true;
                        for (i8 = 0; i8 < 3; ++i8) {
                            bufferWriter.writeNone();
                        }
                        for (i8 = start; i8 <= end; ++i8) {
                            r = (BaseRecord)mems.get(i8);
                            Object obj = r.getNormalFieldValue(col);
                            if (obj == null) {
                                bufferWriter.writeLittleEndianInt(0);
                                continue;
                            }
                            bufferWriter.writeLittleEndianInt(((Number)obj).intValue());
                        }
                        break;
                    }
                    case 40: {
                        int i9;
                        writeNull = true;
                        for (i9 = 0; i9 < 7; ++i9) {
                            bufferWriter.writeNone();
                        }
                        for (i9 = start; i9 <= end; ++i9) {
                            r = (BaseRecord)mems.get(i9);
                            Object obj = r.getNormalFieldValue(col);
                            if (obj == null) {
                                bufferWriter.writeLittleEndianLong(0L);
                                continue;
                            }
                            bufferWriter.writeLittleEndianLong(((Number)obj).longValue());
                        }
                        break;
                    }
                    case 56: {
                        int i10;
                        writeNull = true;
                        for (i10 = 0; i10 < 7; ++i10) {
                            bufferWriter.writeNone();
                        }
                        for (i10 = start; i10 <= end; ++i10) {
                            long v;
                            r = (BaseRecord)mems.get(i10);
                            Object obj = r.getNormalFieldValue(col);
                            if (obj == null) {
                                v = Double.doubleToLongBits(0.0);
                                bufferWriter.writeLittleEndianLong(v);
                                continue;
                            }
                            v = Double.doubleToLongBits((Double)obj);
                            bufferWriter.writeLittleEndianLong(v);
                        }
                        break;
                    }
                    case 70: {
                        writeNull = true;
                        for (int i11 = start; i11 <= end; ++i11) {
                            r = (BaseRecord)mems.get(i11);
                            SerialBytes sb = (SerialBytes)r.getNormalFieldValue(col);
                            bufferWriter.writeLong64(sb.getValue1());
                            bufferWriter.writeLong64(sb.getValue2());
                        }
                        break;
                    }
                    case 81: {
                        String v;
                        Object obj;
                        int i12;
                        for (i12 = start; i12 <= end; ++i12) {
                            r = (BaseRecord)mems.get(i12);
                            obj = r.getNormalFieldValue(col);
                            v = (String)obj;
                            bufferWriter.write(v.length());
                        }
                        for (i12 = start; i12 <= end; ++i12) {
                            r = (BaseRecord)mems.get(i12);
                            obj = r.getNormalFieldValue(col);
                            v = (String)obj;
                            bufferWriter.write(v.getBytes());
                        }
                    }
                }
            }
        }
        if (writeNull) {
            bufferWriter.writeBoolean(blockType.isHasNull());
            if (blockType.isHasNull()) {
                for (i = start; i <= end; ++i) {
                    r = (BaseRecord)mems.get(i);
                    Object obj = r.getNormalFieldValue(col);
                    bufferWriter.writeBoolean(obj == null);
                }
            }
        }
    }

    public static void writeDataBlock(BufferWriter bufferWriter, Sequence data, Sequence dict, int col, int start, int end, Object[] maxValues, Object[] minValues, Object[] startValues, int[] dataType) throws IOException {
        IArray mems = data.getMems();
        for (int i = start; i <= end; ++i) {
            BaseRecord r = (BaseRecord)mems.get(i);
            Object obj = r.getNormalFieldValue(col);
            try {
                if (Variant.compare(obj, maxValues[col], true) > 0) {
                    maxValues[col] = obj;
                }
            }
            catch (RQException e) {
                maxValues[col] = null;
            }
            if (i == start) {
                minValues[col] = obj;
                startValues[col] = obj;
            }
            try {
                if (Variant.compare(obj, minValues[col], true) >= 0) continue;
                minValues[col] = obj;
                continue;
            }
            catch (RQException e) {
                maxValues[col] = null;
            }
        }
        DataBlockWriterJob._$1(bufferWriter, data, dict, col, start, end, dataType);
    }

    private static boolean _$1(Sequence column_dict, Sequence block_dict) {
        int len = block_dict.length();
        for (int i = 1; i <= len; ++i) {
            Object obj = block_dict.get(i);
            if (!(obj instanceof Sequence) && !(obj instanceof BaseRecord)) continue;
            return false;
        }
        if (column_dict.length() == 0) {
            column_dict.addAll(block_dict);
            return true;
        }
        Sequence newObjs = null;
        len = block_dict.length();
        for (int i = 1; i <= len; ++i) {
            Object obj = block_dict.get(i);
            if (column_dict.contains(obj, false)) continue;
            if (newObjs == null) {
                newObjs = new Sequence();
            }
            newObjs.add(obj);
        }
        if (newObjs != null) {
            if (column_dict.length() + newObjs.length() > 127) {
                return false;
            }
            column_dict.addAll(newObjs);
        }
        return true;
    }

    private static boolean _$1(byte[] pos) {
        int len = pos.length;
        if (len == 0) {
            return false;
        }
        byte p = pos[0];
        for (int i = 0; i < len; ++i) {
            if (p == pos[i]) continue;
            return false;
        }
        return true;
    }

    public static void convertDictData(Sequence dict, Sequence data) {
    }
}

