/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.ObjectArray;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.FindFilter;
import com.scudata.expression.Constant;
import com.scudata.expression.Expression;
import com.scudata.expression.Node;
import com.scudata.util.Variant;
import java.util.Arrays;

public class FindsFilter
extends FindFilter {
    protected boolean pfind;
    protected boolean doFilter;

    public FindsFilter(ColumnMetaData column, int priority, Sequence sequence, Node node, boolean pfind, boolean doFilter) {
        super(column, priority, sequence, node);
        this.pfind = pfind;
        this.doFilter = doFilter;
    }

    public boolean match(Object value) {
        if (this.pfind) {
            int pos = this.it.findPos(value);
            this.findResult = pos;
            if (this.doFilter) {
                return pos > 0;
            }
            return true;
        }
        this.findResult = this.it.find(value);
        if (this.doFilter) {
            return this.findResult != null;
        }
        return true;
    }

    public Object getFindResult() {
        return this.findResult;
    }

    public IArray getFindResultArray() {
        int[] pos = this.pos;
        int len = pos.length - 1;
        if (this.pfind) {
            return new IntArray(pos, null, len);
        }
        ObjectArray resultValue = new ObjectArray(len);
        for (int i = 1; i <= len; ++i) {
            if (pos[i] != 0) {
                resultValue.push(this.code.getMem(pos[i]));
                continue;
            }
            resultValue.push(null);
        }
        return resultValue;
    }

    public boolean match(Object minValue, Object maxValue) {
        if (this.doFilter && Variant.isEquals(minValue, maxValue)) {
            return this.it.find(minValue) != null;
        }
        return true;
    }

    public IArray calculateAll(Context ctx) {
        IArray key = this.right.calculateAll(ctx);
        int[] pos = this.it.findAllPos(key);
        int len = key.size();
        boolean[] result = new boolean[len + 1];
        if (this.doFilter) {
            for (int i = 1; i <= len; ++i) {
                result[i] = pos[i] != 0;
            }
        } else {
            Arrays.fill(result, true);
        }
        this.pos = pos;
        BoolArray resultArray = new BoolArray(result, len);
        resultArray.setTemporary(true);
        return resultArray;
    }

    public IArray calculateAnd(Context ctx, IArray leftResult) {
        BoolArray resultArray = leftResult.isTrue();
        IArray key = this.right.calculateAll(ctx);
        int[] pos = this.it.findAllPos(key, resultArray);
        int len = key.size();
        boolean[] resultDatas = resultArray.getDatas();
        if (this.doFilter) {
            for (int i = 1; i <= len; ++i) {
                resultDatas[i] = pos[i] > 0;
            }
        }
        this.pos = pos;
        return resultArray;
    }

    public int isValueRangeMatch(Context ctx) {
        if (this.doFilter) {
            return this.exp.isValueRangeMatch(ctx);
        }
        return 1;
    }

    public void initExp() {
        if (this.exp == null) {
            String s = "null.find(" + this.column.getColName() + ")";
            this.exp = new Expression(s);
            this.exp.getHome().setLeft(new Constant(this.code));
        }
    }
}

