/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.IArray;
import com.scudata.dm.Context;
import com.scudata.dw.ColumnMetaData;
import com.scudata.expression.Expression;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IFilter
implements Comparable<IFilter> {
    public static final int EQUAL = 1;
    public static final int GREATER = 2;
    public static final int GREATER_EQUAL = 3;
    public static final int LESS = 4;
    public static final int LESS_EQUAL = 5;
    public static final int NOT_EQUAL = 6;
    public static final int AND = 10;
    public static final int OR = 11;
    protected ColumnMetaData column;
    protected int priority;
    protected String columnName;
    public int colCount = 1;
    protected Expression exp;
    protected List<ColumnMetaData> columns;
    protected IArray dictMatchResult;

    public IFilter() {
    }

    public IFilter(ColumnMetaData column, int priority) {
        this.column = column;
        this.priority = priority;
        this.columnName = column.getColName();
    }

    public static int getInverseOP(int op) {
        switch (op) {
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return op;
    }

    public ColumnMetaData getColumn() {
        return this.column;
    }

    public String getColumnName() {
        if (this.columnName != null) {
            return this.columnName;
        }
        return this.column.getColName();
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isSameColumn(IFilter other) {
        if (this.columnName != null) {
            return this.columnName.equals(other.columnName);
        }
        return this.column == other.column;
    }

    public abstract boolean match(Object var1);

    public abstract boolean match(Object var1, Object var2);

    @Override
    public int compareTo(IFilter o) {
        if (this.priority < o.priority) {
            return -1;
        }
        if (this.priority > o.priority) {
            return 1;
        }
        return 0;
    }

    public boolean isMultiFieldOr() {
        return false;
    }

    public int getColCount() {
        return this.colCount;
    }

    public void setColCount(int colCount) {
        this.colCount = colCount;
    }

    public IArray calculateAll(Context ctx) {
        return this.exp.calculateAll(ctx);
    }

    public IArray calculateAnd(Context ctx, IArray leftResult) {
        return this.exp.calculateAnd(ctx, leftResult);
    }

    public int isValueRangeMatch(Context ctx) {
        return this.exp.isValueRangeMatch(ctx);
    }

    public List<ColumnMetaData> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnMetaData> columns) {
        this.columns = columns;
    }

    public void initExp() {
    }

    public Expression getExp() {
        return this.exp;
    }

    public void deepOptimize(Context ctx) {
        if (this.exp != null) {
            this.exp.deepOptimize(ctx);
        }
    }

    public IArray getDictMatchResult() {
        return this.dictMatchResult;
    }

    public void setDictMatchResult(IArray dictMatchResult) {
        this.dictMatchResult = dictMatchResult;
    }

    public boolean canSkipRow() {
        return this.dictMatchResult != null;
    }
}

