/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.LongArray;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.ObjectWriter;
import com.scudata.dm.RandomObjectWriter;
import com.scudata.dm.RandomOutputStream;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MergesCursor;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.BufferReader;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.IIIlIIIIlIIIIIlI;
import com.scudata.dw.ITableIndex;
import com.scudata.dw.IlllIlIIIlIlllll;
import com.scudata.dw.IndexCursor;
import com.scudata.dw.ModifyRecord;
import com.scudata.dw.PhyTable;
import com.scudata.dw.RowBufferWriter;
import com.scudata.dw.RowPhyTable;
import com.scudata.dw.lIIIIIlIlIlIIlIl;
import com.scudata.expression.Expression;
import com.scudata.expression.FieldId;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.Operator;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.fn.string.Like;
import com.scudata.expression.mfn.sequence.Contain;
import com.scudata.expression.operator.And;
import com.scudata.expression.operator.DotOperator;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.NotGreater;
import com.scudata.expression.operator.NotSmaller;
import com.scudata.expression.operator.Smaller;
import com.scudata.resources.EngineMessage;
import com.scudata.util.EnvUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhyTableIndex
implements ITableIndex {
    private static final int _$7 = -1;
    private static final int _$6 = 0;
    private static final int _$5 = 1;
    private static final int _$4 = 2;
    private static final int _$3 = 3;
    private static final int _$2 = 4;
    private static final int _$1 = 5;
    protected static final int BUFFER_SIZE = 1024;
    protected static final int BLOCK_START = -1;
    protected static final int BLOCK_END = -2;
    public static final int MAX_LEAF_BLOCK_COUNT = 1000;
    public static final int MAX_INTER_BLOCK_COUNT = 1000;
    public static final int MAX_ROOT_BLOCK_COUNT = 1000;
    public static final int MAX_SEC_RECORD_COUNT = 100000;
    public static final int FETCH_SIZE = 20;
    protected long recordCount = 0L;
    protected long index1RecordCount = 0L;
    protected long index1EndPos = 0L;
    protected String[] ifields;
    protected String name;
    protected PhyTable srcTable;
    protected FileObject indexFile;
    protected Object[] rootBlockMaxVals;
    protected long[] rootBlockPos;
    protected long internalBlockCount = 0L;
    protected Object[][] internalAllBlockMaxVals;
    protected long[][] internalAllBlockPos;
    protected Object[] rootBlockMaxVals2;
    protected long[] rootBlockPos2;
    protected long internalBlockCount2 = 0L;
    protected Object[][] internalAllBlockMaxVals2;
    protected long[][] internalAllBlockPos2;
    protected long rootItPos = 0L;
    protected long rootItPos2 = 0L;
    protected long indexPos = 0L;
    protected long indexPos2 = 0L;
    protected transient byte[][][] cachedBlockReader;
    protected transient byte[][][] cachedBlockReader2;
    protected transient boolean isPrimaryKey;
    protected transient int maxRecordLen;
    protected Expression filter;
    protected int positionCount;

    public PhyTableIndex(PhyTable table, String indexName) {
        table.getGroupTable().checkWritable();
        this.srcTable = table;
        this.name = indexName;
        String dir = table.getGroupTable().getFile().getAbsolutePath() + "_";
        this.indexFile = new FileObject(dir + table.getTableName() + "_" + indexName);
        this.positionCount = this.srcTable instanceof ColPhyTable ? 0 : (this.srcTable.parent == null ? 1 : 2);
    }

    public PhyTableIndex(PhyTable table, FileObject indexFile) {
        this.srcTable = table;
        this.indexFile = indexFile;
        this.positionCount = this.srcTable instanceof ColPhyTable ? 0 : (this.srcTable.parent == null ? 1 : 2);
    }

    protected void writeHeader(ObjectWriter writer) throws IOException {
        writer.write(114);
        writer.write(113);
        writer.write(100);
        writer.write(119);
        writer.write(105);
        writer.write(100);
        writer.write(120);
        writer.write(new byte[32]);
        writer.writeLong64(this.recordCount);
        writer.writeLong64(this.index1EndPos);
        writer.writeLong64(this.index1RecordCount);
        writer.writeLong64(this.rootItPos);
        writer.writeLong64(this.rootItPos2);
        writer.writeLong64(this.indexPos);
        writer.writeLong64(this.indexPos2);
        writer.writeStrings(this.ifields);
        if (this.filter != null) {
            writer.write(1);
            writer.writeUTF(this.filter.toString());
        } else {
            writer.write(0);
        }
    }

    protected void updateHeader(RandomObjectWriter writer) throws IOException {
        writer.position(39L);
        writer.writeLong64(this.recordCount);
        writer.writeLong64(this.index1EndPos);
        writer.writeLong64(this.index1RecordCount);
        writer.writeLong64(this.rootItPos);
        writer.writeLong64(this.rootItPos2);
        writer.writeLong64(this.indexPos);
        writer.writeLong64(this.indexPos2);
    }

    protected void readHeader(ObjectReader reader) throws IOException {
        if (reader.read() != 114 || reader.read() != 113 || reader.read() != 100 || reader.read() != 119 || reader.read() != 105 || reader.read() != 100 || reader.read() != 120) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        reader.readFully(new byte[32]);
        this.recordCount = reader.readLong64();
        this.index1EndPos = reader.readLong64();
        this.index1RecordCount = reader.readLong64();
        this.rootItPos = reader.readLong64();
        this.rootItPos2 = reader.readLong64();
        this.indexPos = reader.readLong64();
        this.indexPos2 = reader.readLong64();
        reader.readStrings();
        this.filter = reader.read() != 0 ? new Expression(reader.readUTF()) : null;
    }

    @Override
    public void setFields(String[] ifields, String[] vfields) {
        this.ifields = ifields;
    }

    public void create(String[] fields, String opt, Context ctx, Expression filter) {
        Expression[] exps;
        ICursor[] cursors;
        int size;
        ArrayList<ICursor> cursorList;
        int icount = fields.length;
        boolean isAppend = false;
        boolean isAdd = true;
        boolean isReset = false;
        if (this.indexFile.size() > 0L && (opt == null || opt != null && opt.indexOf(97) == -1)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(this.name + " " + mm.getMessage("dw.indexNameAlreadyExist"));
        }
        if (opt != null && opt.indexOf(97) != -1 && this.indexFile.size() > 0L) {
            isAppend = true;
            isAdd = false;
            isReset = opt.indexOf(114) != -1;
            InputStream is = this.indexFile.getInputStream();
            ObjectReader reader = new ObjectReader(is, 1024);
            try {
                this.readHeader(reader);
                filter = this.filter;
                if (this.recordCount == 0L) {
                    isReset = true;
                }
                if (this.recordCount - this.index1RecordCount > 100000L || isReset) {
                    isAppend = false;
                    this.rootItPos2 = 0L;
                    this.indexPos2 = 0L;
                    this.rootItPos = 0L;
                    this.indexPos = 0L;
                    this.index1EndPos = 0L;
                    reader.close();
                    this.indexFile.delete();
                } else {
                    if (fields.length != this.ifields.length || 0 != Variant.compareArrays(fields, this.ifields)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("index" + mm.getMessage("engine.dsNotMatch"));
                    }
                    cursorList = this.srcTable instanceof RowPhyTable ? this.sortRow(fields, ctx, filter) : this.sortCol(fields, ctx, filter);
                    size = cursorList.size();
                    if (size == 0) {
                        return;
                    }
                    if (size == 1) {
                        this.createIndexTable(cursorList.get(0), this.indexFile, true);
                    } else {
                        cursors = new ICursor[cursorList.size()];
                        cursorList.toArray(cursors);
                        exps = new Expression[icount + 1];
                        for (int i = 0; i < icount + 1; ++i) {
                            exps[i] = new Expression(ctx, "#" + (i + 1));
                        }
                        MergesCursor cursor = new MergesCursor(cursors, exps, ctx);
                        this.createIndexTable(cursor, this.indexFile, true);
                    }
                    this.srcTable.getTableMetaDataIndex(this.indexFile, null, false);
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ie) {}
            }
        }
        if (!isAppend) {
            FileObject tmpFile;
            this.filter = filter;
            boolean needDelete = false;
            if (this.indexFile.isExists()) {
                String tmpFileName = this.indexFile.createTempFile("tmp");
                tmpFile = new FileObject(tmpFileName);
                tmpFile.delete();
                needDelete = true;
            } else {
                tmpFile = this.indexFile;
            }
            this.recordCount = 0L;
            this.index1RecordCount = 0L;
            cursorList = this.srcTable instanceof RowPhyTable ? this.sortRow(fields, ctx, filter) : this.sortCol(fields, ctx, filter);
            size = cursorList.size();
            if (size == 0) {
                this.createIndexTable(new MemoryCursor(null), tmpFile, false);
            } else if (size == 1) {
                this.createIndexTable(cursorList.get(0), tmpFile, false);
            } else {
                cursors = new ICursor[size];
                cursorList.toArray(cursors);
                exps = new Expression[icount + 1];
                for (int i = 0; i < icount + 1; ++i) {
                    exps[i] = new Expression(ctx, "#" + (i + 1));
                }
                MergesCursor cursor = new MergesCursor(cursors, exps, ctx);
                this.createIndexTable(cursor, tmpFile, false);
            }
            this.srcTable.getTableMetaDataIndex(this.indexFile, null, false);
            if (needDelete) {
                this.indexFile.delete();
                tmpFile.move(this.indexFile.getFileName(), null);
            }
            if (opt != null && opt.indexOf(85) != -1) {
                isAdd = false;
            }
            try {
                if (isAdd) {
                    this.srcTable.addIndex(this.name, this.ifields, null);
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    protected int getGroupNum(IArray mems, int from, int fcount) {
        Object[] vals;
        int cmp;
        int len = mems.size();
        int count = 1;
        Record r = (Record)mems.get(from);
        Object[] firstVals = r.getFieldValues();
        for (int i = from + 1; i <= len && (cmp = Variant.compareArrays(firstVals, vals = (r = (Record)mems.get(i)).getFieldValues(), fcount)) == 0; ++i) {
            ++count;
        }
        return count;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createIndexTable(ICursor cursor, FileObject indexFile, boolean isAppends) {
        block111: {
            block110: {
                block109: {
                    os = indexFile.getRandomOutputStream(true);
                    writer = new RandomObjectWriter(os);
                    perCount = 1000L;
                    maxValues = new ArrayList<Record>();
                    blockCount = 0;
                    recCount = 0;
                    icount = this.ifields.length;
                    posCount = this.positionCount;
                    ctx = new Context();
                    ifs = new Expression[icount];
                    for (i = 0; i < icount; ++i) {
                        ifs[i] = new Expression("#" + (i + 1));
                    }
                    isPrimaryKey = false;
                    keyNames = this.srcTable.getAllSortedColNames();
                    if (this.srcTable.hasPrimaryKey && keyNames != null && this.ifields.length == keyNames.length) {
                        isPrimaryKey = true;
                        len = this.ifields.length;
                        for (i = 0; i < len; ++i) {
                            if (this.ifields[i].equals(keyNames[i])) continue;
                            isPrimaryKey = false;
                            break;
                        }
                    }
                    try {
                        if (isAppends) {
                            indexFile.setFileSize(this.indexPos2);
                            writer.position(this.indexPos2);
                        } else {
                            writer.position(0L);
                            this.writeHeader(writer);
                        }
                        r = null;
                        if (isPrimaryKey) {
                            table = cursor.fetch(20000);
                            if (table == null || table.length() == 0) {
                                writer.position(0L);
                                this.updateHeader(writer);
                                try {
                                    writer.close();
                                    return;
                                }
                                catch (IOException ie) {
                                    // empty catch block
                                    return;
                                }
                            }
                            break block109;
                        }
                        table = cursor.fetchGroup(ifs, 20000, ctx);
                        if (table == null) {
                            writer.position(0L);
                            this.updateHeader(writer);
                            try {
                                writer.close();
                                return;
                            }
                            catch (IOException ie) {
                                // empty catch block
                                return;
                            }
                        }
                        p = 1;
                        mems = table.getMems();
                        length = table.length();
lbl56:
                        // 2 sources

                        while (true) {
                            if (table != null && length != 0) {
                                writer.writeInt(-1);
                                count = 0;
                                break block110;
                            }
                            writer.writeInt(-2);
                            ** GOTO lbl81
                            break;
                        }
                    }
                    catch (IOException e) {
                        throw new RQException(e.getMessage(), e);
                    }
                    finally {
                        try {
                            writer.close();
                        }
                        catch (IOException ie) {}
                    }
                }
                while (true) {
                    if (table == null) ** GOTO lbl-1000
                    mems = table.getMems();
                    rest = mems.size();
                    recCount += rest;
                    if (rest != 0) {
                        p = 1;
                    } else lbl-1000:
                    // 2 sources

                    {
                        writer.writeInt(-2);
lbl81:
                        // 2 sources

                        srcRecordCount = this.recordCount = (long)recCount + this.index1RecordCount;
                        positions = new long[blockCount];
                        is = indexFile.getInputStream();
                        reader = new ObjectReader(is, 1024);
                        try {
                            this.readHeader(reader);
                            if (isAppends) {
                                reader.seek(this.indexPos2);
                            } else {
                                this.indexPos = reader.position();
                            }
                            reader.readInt();
                            i = 0;
lbl94:
                            // 2 sources

                            while (true) {
                                if (i < blockCount) {
                                    positions[i] = reader.position();
                                    break block111;
                                }
                                itPos = reader.position();
                                break;
                            }
                        }
                        catch (IOException e) {
                            throw new RQException(e.getMessage(), e);
                        }
                        finally {
                            try {
                                reader.close();
                            }
                            catch (IOException ie) {}
                        }
                        os = indexFile.getRandomOutputStream(true);
                        writer = new RandomObjectWriter(os);
                        try {
                            writer.position(itPos);
                            for (i = 0; i < blockCount; ++i) {
                                if (i % 1000 == 0) {
                                    if (blockCount - i >= 1000) {
                                        writer.writeInt(1000);
                                    } else {
                                        writer.writeInt(blockCount - i);
                                    }
                                }
                                for (f = 0; f < icount; ++f) {
                                    writer.writeObject(((Record)maxValues.get(i)).getNormalFieldValue(f));
                                }
                                writer.writeLong(positions[i]);
                            }
                        }
                        catch (IOException e) {
                            throw new RQException(e.getMessage(), e);
                        }
                        finally {
                            try {
                                writer.close();
                            }
                            catch (IOException ie) {}
                        }
                        rootBlockCount = blockCount / 1000;
                        rootMaxValues = new Record[rootBlockCount += blockCount % 1000 == 0 ? 0 : 1];
                        for (i = 0; i < rootBlockCount - 1; ++i) {
                            rootMaxValues[i] = (Record)maxValues.get((i + 1) * 1000 - 1);
                        }
                        rootMaxValues[rootBlockCount - 1] = (Record)maxValues.get(blockCount - 1);
                        rootPositions = new long[rootBlockCount];
                        is = indexFile.getInputStream();
                        reader = new ObjectReader(is, 1024);
                        try {
                            reader.seek(itPos);
                            for (i = 0; i < blockCount; ++i) {
                                if (i % 1000 == 0) {
                                    rootPositions[i / 1000] = reader.position();
                                    reader.readInt();
                                }
                                for (f = 0; f < icount; ++f) {
                                    reader.readObject();
                                }
                                reader.readLong();
                            }
                            itPos = reader.position();
                        }
                        catch (IOException e) {
                            throw new RQException(e.getMessage(), e);
                        }
                        finally {
                            try {
                                reader.close();
                            }
                            catch (IOException ie) {}
                        }
                        if (isAppends) {
                            this.rootItPos2 = itPos;
                            this.recordCount = srcRecordCount;
                        } else {
                            this.rootItPos = itPos;
                            this.rootItPos2 = 0L;
                            this.recordCount = srcRecordCount;
                            this.index1RecordCount = srcRecordCount;
                            this.index1EndPos = this.srcTable.getTotalRecordCount();
                        }
                        os = indexFile.getRandomOutputStream(true);
                        writer = new RandomObjectWriter(os);
                        try {
                            writer.position(itPos);
                            writer.writeInt(rootBlockCount);
                            for (i = 0; i < rootBlockCount; ++i) {
                                for (f = 0; f < icount; ++f) {
                                    writer.writeObject(rootMaxValues[i].getNormalFieldValue(f));
                                }
                                writer.writeLong(rootPositions[i]);
                            }
                            writer.writeLong64(blockCount);
                        }
                        catch (IOException e) {
                            throw new RQException(e.getMessage(), e);
                        }
                        finally {
                            try {
                                writer.close();
                            }
                            catch (IOException ie) {}
                        }
                        if (!isAppends) {
                            this.indexPos2 = indexFile.size();
                        }
                        os = indexFile.getRandomOutputStream(true);
                        writer = new RandomObjectWriter(os);
                        try {
                            writer.position(0L);
                            this.updateHeader(writer);
                            return;
                        }
                        catch (IOException e) {
                            throw new RQException(e.getMessage(), e);
                        }
                        finally {
                            try {
                                writer.close();
                            }
                            catch (IOException ie) {}
                        }
                    }
                    for (c = 0; c < 20; ++blockCount, ++c) {
                        writer.writeInt(-1);
                        count = rest >= 1000 ? 1000 : rest;
                        rest -= count;
                        for (j = 0; j < count; ++j) {
                            r = (Record)mems.get(p++);
                            writer.writeInt(1);
                            for (f = 0; f <= icount; ++f) {
                                writer.writeObject(r.getNormalFieldValue(f));
                            }
                            for (i = 1; i <= posCount; ++i) {
                                writer.writeObject(r.getNormalFieldValue(icount + i));
                            }
                        }
                        maxValues.add(r);
                        if (rest == 0) break;
                    }
                    table = cursor.fetch(20000);
                }
            }
            while ((long)count < perCount) {
                len = this.getGroupNum(mems, p, icount);
                recCount += len;
                count += len;
                r = (Record)mems.get(p);
                writer.writeInt(len);
                for (f = 0; f < icount; ++f) {
                    writer.writeObject(r.getNormalFieldValue(f));
                }
                for (i = 0; i < len; ++i) {
                    r = (Record)mems.get(i + p);
                    writer.writeObject(r.getNormalFieldValue(icount));
                    for (j = 1; j <= posCount; ++j) {
                        writer.writeObject(r.getNormalFieldValue(icount + j));
                    }
                }
                if ((p += len) <= length) continue;
                table = cursor.fetchGroup(ifs, 20000, ctx);
                if (table == null || table.length() == 0) {
                    length = 0;
                    break;
                }
                p = 1;
                mems = table.getMems();
                length = table.length();
            }
            ++blockCount;
            maxValues.add(r);
            ** while (true)
        }
        block84: while (true) {
            if ((count = reader.readInt()) < 1) {
                ++i;
                ** continue;
            }
            for (f = 0; f < icount; ++f) {
                reader.readObject();
            }
            j = 0;
            while (true) {
                if (j >= count) continue block84;
                reader.readLong();
                for (c = 0; c < posCount; ++c) {
                    reader.readLong();
                }
                ++j;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<ICursor> sortCol(String[] fields, Context ctx, Expression filter) {
        CTableCursor srcCursor = new CTableCursor(this.srcTable, fields, ctx, filter);
        try {
            int size;
            Table table;
            int icount = fields.length;
            DataStruct ds = this.srcTable.getDataStruct();
            this.ifields = new String[icount];
            boolean isPrimaryTable = this.srcTable.parent == null;
            String[] keyNames = this.srcTable.groupTable.baseTable.getSortedColNames();
            ArrayList<String> list = new ArrayList<String>();
            if (keyNames != null) {
                for (String name : keyNames) {
                    list.add(name);
                }
            }
            for (int i = 0; i < icount; ++i) {
                int id = ds.getFieldIndex(fields[i]);
                if (id == -1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fields[i] + mm.getMessage("ds.fieldNotExist"));
                }
                if (!isPrimaryTable && list.contains(fields[i])) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fields[i] + mm.getMessage("ds.fieldNotExist"));
                }
                this.ifields[i] = fields[i];
            }
            keyNames = this.srcTable.getAllSortedColNames();
            if (this.srcTable.isSorted && keyNames != null && keyNames.length >= fields.length) {
                boolean isKeyField = true;
                int len2 = fields.length;
                for (int i = 0; i < len2; ++i) {
                    if (fields[i].equals(keyNames[i])) continue;
                    isKeyField = false;
                    break;
                }
                if (isKeyField) {
                    if (this.index1EndPos > 0L) {
                        srcCursor.seek(this.index1EndPos);
                    }
                    ArrayList<ICursor> cursorList = new ArrayList<ICursor>();
                    cursorList.add(srcCursor);
                    srcCursor = null;
                    ArrayList<ICursor> len2 = cursorList;
                    return len2;
                }
            }
            int baseCount = 100000;
            boolean flag = false;
            ArrayList<ICursor> cursorList = new ArrayList<ICursor>();
            int[] sortFields = new int[icount + 1];
            for (int i = 0; i < icount + 1; ++i) {
                sortFields[i] = i;
            }
            if (this.index1EndPos > 0L) {
                srcCursor.seek(this.index1EndPos);
            }
            while ((table = (Table)srcCursor.get(baseCount)) != null && table.length() > 0) {
                this.recordCount += (long)table.length();
                if (table.length() < baseCount) break;
                table.sortFields(sortFields);
                FileObject tmp = FileObject.createTempFileObject();
                tmp.exportSeries(table, "b", null);
                BFileCursor bfc = new BFileCursor(tmp, null, "x", ctx);
                cursorList.add(bfc);
                table = null;
                if (flag || tmp.size() >= 0x3200000L) continue;
                baseCount = (int)((long)baseCount * (0x3200000L / tmp.size()));
                flag = true;
            }
            if ((size = cursorList.size()) == 0) {
                Object mc;
                if (table != null && table.length() > 0) {
                    table.sortFields(sortFields);
                    mc = new MemoryCursor(table);
                    cursorList.add((ICursor)mc);
                }
                mc = cursorList;
                return mc;
            }
            if (size > 1) {
                int bufSize = Env.getMergeFileBufSize(size);
                for (int i = 0; i < size; ++i) {
                    BFileCursor bfc = (BFileCursor)cursorList.get(i);
                    bfc.setFileBufferSize(bufSize);
                }
            }
            if (table != null && table.length() > 0) {
                table.sortFields(sortFields);
                MemoryCursor mc = new MemoryCursor(table);
                cursorList.add(mc);
            }
            ArrayList<ICursor> arrayList = cursorList;
            return arrayList;
        }
        finally {
            if (srcCursor != null) {
                srcCursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<ICursor> sortRow(String[] fields, Context ctx, Expression filter) {
        RTableCursor srcCursor = new RTableCursor(this.srcTable, fields, ctx, filter);
        try {
            Table table;
            int icount = fields.length;
            DataStruct ds = this.srcTable.getDataStruct();
            this.ifields = new String[icount];
            boolean isPrimaryTable = this.srcTable.parent == null;
            String[] keyNames = this.srcTable.groupTable.baseTable.getSortedColNames();
            ArrayList<String> list = new ArrayList<String>();
            if (keyNames != null) {
                for (String name : keyNames) {
                    list.add(name);
                }
            }
            for (int i = 0; i < icount; ++i) {
                int id = ds.getFieldIndex(fields[i]);
                if (id == -1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fields[i] + mm.getMessage("ds.fieldNotExist"));
                }
                if (!isPrimaryTable && list.contains(fields[i])) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fields[i] + mm.getMessage("ds.fieldNotExist"));
                }
                this.ifields[i] = fields[i];
            }
            keyNames = this.srcTable.getSortedColNames();
            if (this.srcTable.isSorted && keyNames != null && keyNames.length >= fields.length) {
                boolean isKeyField = true;
                int len2 = fields.length;
                for (int i = 0; i < len2; ++i) {
                    if (fields[i].equals(keyNames[i])) continue;
                    isKeyField = false;
                    break;
                }
                if (isKeyField) {
                    if (this.index1EndPos > 0L) {
                        srcCursor.seek(this.index1EndPos);
                    }
                    ArrayList<ICursor> cursorList = new ArrayList<ICursor>();
                    cursorList.add(srcCursor);
                    srcCursor = null;
                    ArrayList<ICursor> len2 = cursorList;
                    return len2;
                }
            }
            int baseCount = 100000;
            boolean flag = false;
            ArrayList<ICursor> cursorList = new ArrayList<ICursor>();
            long recordCount = 0L;
            int[] sortFields = new int[icount + 1];
            for (int i = 0; i < icount + 1; ++i) {
                sortFields[i] = i;
            }
            if (this.index1EndPos > 0L) {
                srcCursor.seek(this.index1EndPos);
            }
            while ((table = (Table)srcCursor.get(baseCount)) != null && table.length() > 0) {
                recordCount += (long)table.length();
                if (table.length() < baseCount) break;
                table.sortFields(sortFields);
                FileObject tmp = FileObject.createTempFileObject();
                tmp.exportSeries(table, "b", null);
                BFileCursor bfc = new BFileCursor(tmp, null, "x", ctx);
                cursorList.add(bfc);
                table = null;
                if (flag || tmp.size() >= 0x3200000L) continue;
                baseCount = (int)((long)baseCount * (0x3200000L / tmp.size()));
                flag = true;
            }
            this.recordCount = recordCount + this.index1RecordCount;
            int size = cursorList.size();
            if (size > 1) {
                int bufSize = Env.getMergeFileBufSize(size);
                for (int i = 0; i < size; ++i) {
                    BFileCursor bfc = (BFileCursor)cursorList.get(i);
                    bfc.setFileBufferSize(bufSize);
                }
            }
            if (table.length() > 0) {
                table.sortFields(sortFields);
                MemoryCursor mc = new MemoryCursor(table);
                cursorList.add(mc);
            }
            ArrayList<ICursor> arrayList = cursorList;
            return arrayList;
        }
        finally {
            if (srcCursor != null) {
                srcCursor.close();
            }
        }
    }

    private static int _$1(Object[] objs, Object key) {
        int low = 0;
        int high = objs.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = Variant.compare(objs[mid], key, true);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (low < objs.length) {
            return low;
        }
        return -1;
    }

    private static int _$1(Object[][] objs, Object[] keys, boolean isStart) {
        int keyCount = keys.length;
        int low = 0;
        int high = objs.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = Variant.compareArrays(objs[mid], keys, keyCount);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            if (isStart) {
                int i = mid - 1;
                while (i >= 0 && Variant.compareArrays(objs[i], keys, keyCount) == 0) {
                    mid = i--;
                }
            } else {
                int i = mid + 1;
                while (i <= high && Variant.compareArrays(objs[i], keys, keyCount) == 0) {
                    mid = i++;
                }
                if (mid < objs.length - 1) {
                    ++mid;
                }
            }
            return mid;
        }
        if (low < objs.length) {
            return low;
        }
        return -1;
    }

    private void _$1(Object[] key, int icount, boolean isStart, long[] pos, int[] index) {
        block21: {
            int j;
            IlllIlIIIlIlllll blockInfo;
            int i;
            block22: {
                block20: {
                    block18: {
                        block19: {
                            block17: {
                                i = 0;
                                index[0] = -1;
                                pos[0] = -1L;
                                index[1] = -1;
                                pos[1] = -1L;
                                blockInfo = new IlllIlIIIlIlllll(this, null);
                                if (icount != 1) break block17;
                                i = PhyTableIndex._$1(this.rootBlockMaxVals, key[0]);
                                if (i < 0) break block18;
                                if (this.internalAllBlockPos == null) {
                                    this._$1(this.indexFile, this.rootBlockPos[i], blockInfo);
                                } else {
                                    this._$1(false, i, blockInfo);
                                }
                                j = PhyTableIndex._$1(IlllIlIIIlIlllll._$2(blockInfo), key[0]);
                                break block19;
                            }
                            i = PhyTableIndex._$1((Object[][])this.rootBlockMaxVals, key, isStart);
                            if (i < 0) break block18;
                            if (this.internalAllBlockPos == null) {
                                this._$1(this.indexFile, this.rootBlockPos[i], blockInfo);
                            } else {
                                this._$1(false, i, blockInfo);
                            }
                            j = PhyTableIndex._$1((Object[][])IlllIlIIIlIlllll._$2(blockInfo), key, isStart);
                        }
                        if (j >= 0) {
                            index[0] = i * 1000 + j;
                            pos[0] = IlllIlIIIlIlllll._$1(blockInfo)[j];
                        }
                    }
                    if (this.rootItPos2 == 0L) {
                        return;
                    }
                    i = 0;
                    if (icount != 1) break block20;
                    i = PhyTableIndex._$1(this.rootBlockMaxVals2, key[0]);
                    if (i < 0) break block21;
                    if (this.internalAllBlockPos2 == null) {
                        this._$1(this.indexFile, this.rootBlockPos2[i], blockInfo);
                    } else {
                        this._$1(true, i, blockInfo);
                    }
                    j = PhyTableIndex._$1(IlllIlIIIlIlllll._$2(blockInfo), key[0]);
                    break block22;
                }
                i = PhyTableIndex._$1((Object[][])this.rootBlockMaxVals2, key, isStart);
                if (i < 0) break block21;
                if (this.internalAllBlockPos2 == null) {
                    this._$1(this.indexFile, this.rootBlockPos2[i], blockInfo);
                } else {
                    this._$1(true, i, blockInfo);
                }
                j = PhyTableIndex._$1((Object[][])IlllIlIIIlIlllll._$2(blockInfo), key, isStart);
            }
            if (j >= 0) {
                index[1] = i * 1000 + j;
                pos[1] = IlllIlIIIlIlllll._$1(blockInfo)[j];
            }
        }
    }

    protected void readBlockInfo(FileObject fo) {
        block21: {
            int rootBlockCount1 = 0;
            int rootBlockCount2 = 0;
            if (this.rootBlockMaxVals != null && (this.rootItPos2 == 0L || this.rootBlockMaxVals2 != null)) {
                return;
            }
            InputStream is = fo.getInputStream();
            ObjectReader reader = new ObjectReader(is, 1024);
            try {
                int f;
                Object[] vals;
                int i;
                Object[] maxValues;
                long[] positions;
                this.readHeader(reader);
                int icount = this.ifields.length;
                if (this.rootBlockMaxVals == null) {
                    reader.seek(this.rootItPos);
                    rootBlockCount1 = reader.readInt();
                    positions = new long[rootBlockCount1];
                    if (icount == 1) {
                        maxValues = new Object[rootBlockCount1];
                        for (i = 0; i < rootBlockCount1; ++i) {
                            maxValues[i] = reader.readObject();
                            positions[i] = reader.readLong();
                        }
                    } else {
                        maxValues = new Object[rootBlockCount1][];
                        for (i = 0; i < rootBlockCount1; ++i) {
                            vals = new Object[icount];
                            for (f = 0; f < icount; ++f) {
                                vals[f] = reader.readObject();
                            }
                            maxValues[i] = vals;
                            positions[i] = reader.readLong();
                        }
                    }
                    this.rootBlockMaxVals = maxValues;
                    this.rootBlockPos = positions;
                    this.internalBlockCount = reader.readLong64();
                }
                if (this.rootItPos2 == 0L || this.rootBlockMaxVals2 != null) break block21;
                reader.seek(this.rootItPos2);
                rootBlockCount2 = reader.readInt();
                positions = new long[rootBlockCount2];
                if (icount == 1) {
                    maxValues = new Object[rootBlockCount2];
                    for (i = 0; i < rootBlockCount2; ++i) {
                        maxValues[i] = reader.readObject();
                        positions[i] = reader.readLong();
                    }
                } else {
                    maxValues = new Object[rootBlockCount2][];
                    for (i = 0; i < rootBlockCount2; ++i) {
                        vals = new Object[icount];
                        for (f = 0; f < icount; ++f) {
                            vals[f] = reader.readObject();
                        }
                        maxValues[i] = vals;
                        positions[i] = reader.readLong();
                    }
                }
                this.rootBlockMaxVals2 = maxValues;
                this.rootBlockPos2 = positions;
                this.internalBlockCount2 = reader.readLong64();
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ie) {}
            }
        }
    }

    private void _$1(FileObject fo, long pos, IlllIlIIIlIlllll blockInfo) {
        InputStream is = fo.getInputStream();
        ObjectReader reader = new ObjectReader(is, 1024);
        try {
            Object[] maxValues;
            int icount = this.ifields.length;
            reader.seek(pos);
            int interBlockCount = reader.readInt();
            long[] positions = new long[interBlockCount];
            if (icount == 1) {
                maxValues = new Object[interBlockCount];
                for (int i = 0; i < interBlockCount; ++i) {
                    maxValues[i] = reader.readObject();
                    positions[i] = reader.readLong();
                }
            } else {
                maxValues = new Object[interBlockCount][];
                for (int i = 0; i < interBlockCount; ++i) {
                    Object[] vals = new Object[icount];
                    for (int f = 0; f < icount; ++f) {
                        vals[f] = reader.readObject();
                    }
                    maxValues[i] = vals;
                    positions[i] = reader.readLong();
                }
            }
            IlllIlIIIlIlllll._$1(blockInfo, maxValues);
            IlllIlIIIlIlllll._$1(blockInfo, positions);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
    }

    public long count() {
        InputStream is = this.indexFile.getInputStream();
        ObjectReader reader = new ObjectReader(is, 1024);
        try {
            this.readHeader(reader);
            long l = this.recordCount;
            return l;
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
    }

    public ICursor selectRow(long start, long end, String[] fields, String opt, Context ctx) {
        IndexCursor indexCursor;
        if (opt != null) {
            if (opt.indexOf(108) == -1) {
                ++start;
            }
            if (opt.indexOf(114) == -1) {
                --end;
            }
        }
        if (start < 1L || start > end) {
            return null;
        }
        InputStream is = this.indexFile.getInputStream();
        ObjectReader reader = new ObjectReader(is, 1024);
        try {
            long lcount;
            this.readHeader(reader);
            if (start > this.recordCount) {
                ICursor iCursor = null;
                return iCursor;
            }
            if (end > this.recordCount) {
                end = this.recordCount;
            }
            if ((lcount = end - start + 1L) > Integer.MAX_VALUE) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("ncursor" + mm.getMessage("engine.indexOutofBound"));
            }
            int count = (int)lcount;
            long[] srcPos = new long[count];
            reader.skip((start - 1L) * 8L);
            for (int i = 0; i < count; ++i) {
                srcPos[i] = reader.readLong64();
            }
            indexCursor = new IndexCursor(this.srcTable, fields, this.ifields, srcPos, opt, ctx);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
        return indexCursor;
    }

    public ICursor selectRow(long[] posArray, String[] fields, String opt, Context ctx) {
        IndexCursor indexCursor;
        InputStream is = this.indexFile.getInputStream();
        ObjectReader reader = new ObjectReader(is, 1024);
        try {
            long cur;
            this.readHeader(reader);
            long recordCount = this.recordCount;
            if (posArray[0] > recordCount) {
                ICursor iCursor = null;
                return iCursor;
            }
            int count = posArray.length;
            long[] srcPos = new long[count];
            long prev = 0L;
            for (int i = 0; i < count && (cur = posArray[i]) <= recordCount; ++i) {
                reader.skip((cur - prev - 1L) * 8L);
                srcPos[i] = reader.readLong64();
                prev = cur;
            }
            indexCursor = new IndexCursor(this.srcTable, fields, this.ifields, srcPos, opt, ctx);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
        return indexCursor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArray _$1(Expression exp, Object[] startVals, Object[] endVals, String[] fields, String opt, Context ctx) {
        boolean re;
        this.readBlockInfo(this.indexFile);
        boolean le = opt == null || opt.indexOf(108) == -1;
        boolean bl = re = opt == null || opt.indexOf(114) == -1;
        if (startVals == null) {
            if (endVals == null) {
                return this.select(exp, opt, ctx);
            }
        } else if (endVals != null) {
            if (startVals.length != endVals.length) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("function.paramCountNotMatch"));
            }
            int cmp = Variant.compareArrays(startVals, endVals);
            if (cmp > 0) {
                return null;
            }
            if (!(cmp != 0 || le && re)) {
                return null;
            }
        }
        if (startVals != null) {
            if (startVals.length > this.ifields.length) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
            }
        } else if (endVals.length > this.ifields.length) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
        }
        int icount = this.ifields.length;
        LongArray srcPos = null;
        LongArray srcPos2 = null;
        if (startVals == null) {
            int[] end = new int[2];
            long[] endPos = new long[2];
            this._$1(endVals, icount, false, endPos, end);
            if (end[0] < 0 && end[1] < 0 && exp == null) {
                return null;
            }
            InputStream is = this.indexFile.getInputStream();
            ObjectReader reader = new ObjectReader(is, 1024);
            try {
                srcPos = end[0] < 0 ? this._$1(reader, exp, ctx, 0, (int)(this.internalBlockCount - 1L), this.indexPos + 5L) : (icount == 1 ? this._$1(reader, endVals[0], end[0], re ? 3 : 4, exp, ctx, this.indexPos + 5L, endPos[0]) : this._$1(reader, endVals, end[0], re ? 3 : 4, exp, ctx, this.indexPos + 5L, endPos[0]));
                if (this.rootItPos2 != 0L) {
                    srcPos2 = end[1] < 0 ? this._$1(reader, exp, ctx, 0, (int)(this.internalBlockCount2 - 1L), this.indexPos2 + 5L) : (icount == 1 ? this._$1(reader, endVals[0], end[1], re ? 3 : 4, exp, ctx, this.indexPos2 + 5L, endPos[1]) : this._$1(reader, endVals, end[1], re ? 3 : 4, exp, ctx, this.indexPos2 + 5L, endPos[1]));
                }
                if (srcPos == null || srcPos.size() == 0) {
                    srcPos = srcPos2;
                    return srcPos;
                }
                if (srcPos2 == null) return srcPos;
                PhyTableIndex._$1(srcPos, srcPos2);
                return srcPos;
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ie) {}
            }
        }
        if (endVals == null) {
            int[] start = new int[2];
            long[] startPos = new long[2];
            this._$1(startVals, icount, true, startPos, start);
            if (start[0] < 0 && start[1] < 0) {
                return null;
            }
            InputStream is = this.indexFile.getInputStream();
            ObjectReader reader = new ObjectReader(is, 1024);
            try {
                if (start[0] >= 0) {
                    srcPos = icount == 1 ? this._$1(reader, startVals[0], start[0], le ? 1 : 2, exp, ctx, 0L, startPos[0]) : this._$1(reader, startVals, start[0], le ? 1 : 2, exp, ctx, 0L, startPos[0]);
                }
                if (this.rootItPos2 != 0L && start[1] >= 0) {
                    srcPos2 = icount == 1 ? this._$1(reader, startVals[0], start[1], le ? 1 : 2, exp, ctx, 0L, startPos[1]) : this._$1(reader, startVals, start[1], le ? 1 : 2, exp, ctx, 0L, startPos[1]);
                }
                if (srcPos == null || srcPos.size() == 0) {
                    srcPos = srcPos2;
                    return srcPos;
                }
                if (srcPos2 == null) return srcPos;
                PhyTableIndex._$1(srcPos, srcPos2);
                return srcPos;
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ie) {}
            }
        }
        int[] start = new int[2];
        long[] startPos = new long[2];
        int[] end = new int[2];
        long[] endPos = new long[2];
        this._$1(startVals, icount, true, startPos, start);
        if (start[0] < 0 && start[1] < 0) {
            return null;
        }
        this._$1(endVals, icount, false, endPos, end);
        InputStream is = this.indexFile.getInputStream();
        ObjectReader reader = new ObjectReader(is, 1024);
        try {
            if (start[0] >= 0) {
                srcPos = end[0] < 0 ? (icount == 1 ? this._$1(reader, startVals[0], start[0], le ? 1 : 2, exp, ctx, 0L, startPos[0]) : this._$1(reader, startVals, start[0], le ? 1 : 2, exp, ctx, 0L, startPos[0])) : (icount == 1 ? this._$1(reader, startVals[0], start[0], le, endVals[0], end[0], re, exp, ctx, startPos[0]) : this._$1(reader, startVals, start[0], le, endVals, end[0], re, exp, ctx, startPos[0]));
            }
            if (this.rootItPos2 != 0L && start[1] >= 0) {
                srcPos2 = end[1] < 0 ? (icount == 1 ? this._$1(reader, startVals[0], start[1], le ? 1 : 2, exp, ctx, 0L, startPos[1]) : this._$1(reader, startVals, start[1], le ? 1 : 2, exp, ctx, 0L, startPos[1])) : (icount == 1 ? this._$1(reader, startVals[0], start[1], le, endVals[0], end[1], re, exp, ctx, startPos[1]) : this._$1(reader, startVals, start[1], le, endVals, end[1], re, exp, ctx, startPos[1]));
            }
            if (srcPos == null || srcPos.size() == 0) {
                srcPos = srcPos2;
                return srcPos;
            } else {
                if (srcPos2 == null) return srcPos;
                PhyTableIndex._$1(srcPos, srcPos2);
            }
            return srcPos;
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
    }

    public LongArray select(Object[] startVals, Object[] endVals, String opt, Context ctx) {
        this.readBlockInfo(this.indexFile);
        boolean le = opt == null || opt.indexOf(108) == -1;
        boolean re = opt == null || opt.indexOf(114) == -1;
        int icount = this.ifields.length;
        LongArray srcPos = null;
        LongArray srcPos2 = null;
        if (startVals == null) {
            throw new RQException("icursor: never run to here!");
        }
        if (endVals == null) {
            throw new RQException("icursor: never run to here!");
        }
        if (startVals.length > this.ifields.length || endVals.length > this.ifields.length) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
        }
        if (startVals.length != endVals.length) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("psort" + mm.getMessage("function.paramCountNotMatch"));
        }
        int cmp = Variant.compareArrays(startVals, endVals);
        if (cmp > 0) {
            return new LongArray();
        }
        if (!(cmp != 0 || le && re)) {
            return new LongArray();
        }
        int[] start = new int[2];
        long[] startPos = new long[2];
        int[] end = new int[2];
        long[] endPos = new long[2];
        this._$1(startVals, icount, true, startPos, start);
        if (start[0] < 0 && start[1] < 0) {
            return new LongArray();
        }
        this._$1(endVals, icount, false, endPos, end);
        InputStream is = this.indexFile.getInputStream();
        ObjectReader reader = new ObjectReader(is, 1024);
        try {
            if (start[0] >= 0) {
                srcPos = end[0] < 0 ? (icount == 1 ? this._$1(reader, startVals[0], start[0], le ? 1 : 2, 0L, startPos[0]) : this._$1(reader, startVals, start[0], le ? 1 : 2, 0L, startPos[0])) : (icount == 1 ? this._$1(reader, startVals[0], start[0], le, endVals[0], end[0], re, startPos[0]) : this._$1(reader, startVals, start[0], le, endVals, end[0], re, startPos[0]));
            }
            if (this.rootItPos2 != 0L && start[1] >= 0) {
                srcPos2 = end[1] < 0 ? (icount == 1 ? this._$1(reader, startVals[0], start[1], le ? 1 : 2, 0L, startPos[1]) : this._$1(reader, startVals, start[1], le ? 1 : 2, 0L, startPos[1])) : (icount == 1 ? this._$1(reader, startVals[0], start[1], le, endVals[0], end[1], re, startPos[1]) : this._$1(reader, startVals, start[1], le, endVals, end[1], re, startPos[1]));
            }
            if (srcPos == null) {
                srcPos = new LongArray();
            }
            PhyTableIndex._$1(srcPos, srcPos2);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
        return srcPos;
    }

    public LongArray select(Object[] vals, String opt, Context ctx) {
        this.readBlockInfo(this.indexFile);
        int icount = this.ifields.length;
        int[] n = new int[2];
        long[] pos = new long[2];
        this._$1(vals, icount, true, pos, n);
        if (n[0] < 0 && n[1] < 0) {
            return null;
        }
        LongArray srcPos = null;
        LongArray srcPos2 = null;
        InputStream is = this.indexFile.getInputStream();
        ObjectReader reader = new ObjectReader(is, 1024);
        try {
            if (n[0] >= 0) {
                srcPos = icount == 1 ? this._$1(reader, vals[0], n[0], 0, 0L, pos[0]) : this._$1(reader, vals, n[0], 0, 0L, pos[0]);
            }
            if (this.rootItPos2 != 0L && n[1] >= 0) {
                srcPos2 = icount == 1 ? this._$1(reader, vals[0], n[1], 0, 0L, pos[1]) : this._$1(reader, vals, n[1], 0, 0L, pos[1]);
            }
            if (srcPos == null) {
                srcPos = new LongArray();
            }
            PhyTableIndex._$1(srcPos, srcPos2);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
        return srcPos;
    }

    public LongArray select(Sequence vals, String opt, Context ctx) {
        LongArray srcPos;
        if (vals == null || vals.length() == 0) {
            return null;
        }
        ObjectReader reader = null;
        if (this.cachedBlockReader == null) {
            InputStream is = this.indexFile.getInputStream();
            reader = new ObjectReader(is, 1024);
        }
        try {
            srcPos = this.ifields.length == 1 ? this._$2(reader, vals) : this._$1(reader, vals);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ie) {}
        }
        return srcPos;
    }

    @Override
    public ICursor select(Expression exp, String[] fields, String opt, Context ctx) {
        if (opt != null && opt.indexOf(115) != -1 && this.rootItPos2 != 0L) {
            int icount = this.ifields.length;
            int[] start = new int[2];
            long[] startPos = new long[2];
            int[] end = new int[2];
            startPos[0] = this.indexPos + 5L;
            startPos[1] = this.indexPos2 + 5L;
            start[1] = 0;
            start[0] = 0;
            end[0] = (int)(this.internalBlockCount - 1L);
            end[1] = (int)(this.internalBlockCount2 - 1L);
            InputStream is = this.indexFile.getInputStream();
            ObjectReader reader = new ObjectReader(is, 1024);
            IndexCursor cs1 = null;
            IndexCursor cs2 = null;
            LongArray srcPos = null;
            LongArray srcPos2 = null;
            ArrayList<ModifyRecord> mrl = PhyTable.getModifyRecord(this.srcTable, exp, ctx);
            try {
                if (start[0] >= 0 && (srcPos = this._$1(reader, exp, ctx, start[0], end[0], startPos[0])) != null && srcPos.size() != 0) {
                    cs1 = new IndexCursor(this.srcTable, fields, this.ifields, srcPos.toArray(), opt, ctx);
                    if (this.maxRecordLen != 0) {
                        cs1.setRowBufferSize(this.maxRecordLen);
                    }
                    cs1.setModifyRecordList(mrl);
                }
                if (this.rootItPos2 != 0L && start[1] >= 0 && (srcPos2 = this._$1(reader, exp, ctx, start[1], end[1], startPos[1])) != null && srcPos2.size() != 0) {
                    cs2 = new IndexCursor(this.srcTable, fields, this.ifields, srcPos2.toArray(), opt, ctx);
                    if (this.maxRecordLen != 0) {
                        cs2.setRowBufferSize(this.maxRecordLen);
                    }
                    cs2.setModifyRecordList(mrl);
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ie) {}
            }
            if (cs1 == null) {
                return cs2;
            }
            if (cs2 == null) {
                return cs1;
            }
            ICursor[] cursors = new ICursor[]{cs1, cs2};
            Expression[] exps = new Expression[icount];
            for (int i = 0; i < fields.length; ++i) {
                exps[i] = new Expression(ctx, "#" + (i + 1));
            }
            return new MergesCursor(cursors, exps, ctx);
        }
        LongArray srcPos = this.select(exp, opt, ctx);
        if (srcPos == null || srcPos.size() == 0) {
            return null;
        }
        if (this.isPrimaryKey) {
            opt = "s";
        }
        IndexCursor cs = new IndexCursor(this.srcTable, fields, this.ifields, srcPos.toArray(), opt, ctx);
        if (this.maxRecordLen != 0) {
            cs.setRowBufferSize(this.maxRecordLen);
        }
        return cs;
    }

    @Override
    public LongArray select(Expression exp, String opt, Context ctx) {
        Object[] keys;
        this.readBlockInfo(this.indexFile);
        int icount = this.ifields.length;
        if (icount == 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.unknownExpression") + exp.toString());
        }
        Node home = exp.getHome();
        if (home instanceof DotOperator) {
            Node left = home.getLeft();
            Node right = home.getRight();
            if (!(right instanceof Contain)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
            }
            Object obj = left.calculate(ctx);
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
            }
            Sequence series = (Sequence)obj;
            String str = ((Contain)right).getParamString();
            str = str.replaceAll("\\[", "");
            str = str.replaceAll("\\]", "");
            str = str.replaceAll(" ", "");
            Object[] split = str.split(",");
            if (icount != split.length) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("function.paramCountNotMatch"));
            }
            if (0 != Variant.compareArrays(this.ifields, split)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
            }
            series.sort("o");
            return this.select(series, opt, ctx);
        }
        if (home instanceof Like) {
            if (((Like)home).getParam().getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
            }
            IParam sub1 = ((Like)home).getParam().getSub(0);
            IParam sub2 = ((Like)home).getParam().getSub(1);
            String f = sub1.getLeafExpression().getIdentifierName();
            if (!f.equals(this.ifields[0])) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
            }
            String fmtExp = (String)sub2.getLeafExpression().calculate(ctx);
            int idx = fmtExp.indexOf("*");
            if (idx > 0) {
                fmtExp = fmtExp.substring(0, idx);
                return this.select(new String[]{fmtExp}, exp, opt, ctx);
            }
        }
        IIIlIIIIlIIIIIlI[] filters = new IIIlIIIIlIIIIIlI[icount];
        if (this._$1(exp.getHome(), filters, ctx)) {
            int last;
            for (last = icount - 1; last >= 0 && filters[last] == null; --last) {
            }
            boolean canOpt = true;
            for (int i = 0; i < last; ++i) {
                if (filters[i] != null && IIIlIIIIlIIIIIlI._$4(filters[i]) == 0) continue;
                canOpt = false;
                break;
            }
            if (canOpt) {
                if (IIIlIIIIlIIIIIlI._$4(filters[last]) == 0) {
                    Object[] vals = new Object[last + 1];
                    for (int i = 0; i <= last; ++i) {
                        vals[i] = IIIlIIIIlIIIIIlI._$3(filters[i]);
                    }
                    if (icount == last + 1) {
                        Sequence seq = new Sequence();
                        seq.addAll(vals);
                        if (icount == 1) {
                            return this.select(seq, opt, ctx);
                        }
                        Sequence series = new Sequence();
                        series.add(seq);
                        return this.select(series, opt, ctx);
                    }
                    return this.select(vals, opt, ctx);
                }
                if (IIIlIIIIlIIIIIlI._$4(filters[last]) != -1 && IIIlIIIIlIIIIIlI._$2(filters[last]) != -1) {
                    Object[] startVals = new Object[last + 1];
                    Object[] endVals = new Object[last + 1];
                    for (int i = 0; i <= last; ++i) {
                        startVals[i] = IIIlIIIIlIIIIIlI._$3(filters[i]);
                        endVals[i] = IIIlIIIIlIIIIIlI._$3(filters[i]);
                    }
                    endVals[last] = IIIlIIIIlIIIIIlI._$1(filters[last]);
                    if (opt == null) {
                        opt = "";
                    }
                    if (IIIlIIIIlIIIIIlI._$4(filters[last]) == 2) {
                        opt = opt + "l";
                    }
                    if (IIIlIIIIlIIIIIlI._$2(filters[last]) == 4) {
                        opt = opt + "r";
                    }
                    return this.select(startVals, endVals, opt, ctx);
                }
            }
        }
        Sequence vals = new Sequence(icount);
        IIIlIIIIlIIIIIlI ff = null;
        for (int i = 0; i < icount; ++i) {
            IIIlIIIIlIIIIIlI filter = new IIIlIIIIlIIIIIlI(this, null);
            this._$1(i, exp.getHome(), filter, ctx);
            if (IIIlIIIIlIIIIIlI._$4(filter) != 0) {
                ff = filter;
                break;
            }
            vals.add(IIIlIIIIlIIIIIlI._$3(filter));
        }
        int[] start = new int[2];
        long[] startPos = new long[2];
        int[] end = new int[2];
        long[] endPos = new long[2];
        startPos[0] = this.indexPos + 5L;
        startPos[1] = this.indexPos2 + 5L;
        start[1] = 0;
        start[0] = 0;
        end[0] = (int)(this.internalBlockCount - 1L);
        end[1] = (int)(this.internalBlockCount2 - 1L);
        int eqCount = vals.length();
        if (eqCount == 0) {
            if (ff != null && IIIlIIIIlIIIIIlI._$4(ff) != -1) {
                keys = new Object[]{IIIlIIIIlIIIIIlI._$3(ff)};
                this._$1(keys, icount, true, startPos, start);
                if (start[0] < 0 && start[1] < 0) {
                    return null;
                }
            }
            if (ff != null && IIIlIIIIlIIIIIlI._$2(ff) != -1) {
                keys = new Object[]{IIIlIIIIlIIIIIlI._$1(ff)};
                this._$1(keys, icount, false, endPos, end);
                if (end[0] < 0) {
                    end[0] = (int)(this.internalBlockCount - 1L);
                }
                if (end[1] < 0) {
                    end[1] = (int)(this.internalBlockCount2 - 1L);
                }
            }
        } else {
            if (ff == null || IIIlIIIIlIIIIIlI._$4(ff) == -1) {
                keys = vals.toArray();
                this._$1(keys, icount, true, startPos, start);
            } else {
                keys = new Object[eqCount + 1];
                vals.toArray(keys);
                keys[eqCount] = IIIlIIIIlIIIIIlI._$3(ff);
                this._$1(keys, eqCount + 1, true, startPos, start);
            }
            if (start[0] < 0 && start[1] < 0) {
                return null;
            }
            if (ff == null || IIIlIIIIlIIIIIlI._$2(ff) == -1) {
                if (icount == 1) {
                    end[0] = start[0];
                    end[1] = start[1];
                } else {
                    keys = vals.toArray();
                    this._$1(keys, icount, false, endPos, end);
                }
            } else {
                keys = new Object[eqCount + 1];
                vals.toArray(keys);
                keys[eqCount] = IIIlIIIIlIIIIIlI._$1(ff);
                this._$1(keys, icount, false, endPos, end);
            }
            if (end[0] < 0) {
                end[0] = (int)(this.internalBlockCount - 1L);
            }
            if (end[1] < 0) {
                end[1] = (int)(this.internalBlockCount2 - 1L);
            }
        }
        LongArray srcPos = null;
        LongArray srcPos2 = null;
        InputStream is = this.indexFile.getInputStream();
        ObjectReader reader = new ObjectReader(is, 1024);
        try {
            if (start[0] >= 0) {
                srcPos = this._$1(reader, exp, ctx, start[0], end[0], startPos[0]);
            }
            if (this.rootItPos2 != 0L && start[1] >= 0) {
                srcPos2 = this._$1(reader, exp, ctx, start[1], end[1], startPos[1]);
            }
            if (srcPos == null) {
                srcPos = new LongArray();
            }
            PhyTableIndex._$1(srcPos, srcPos2);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
        return srcPos;
    }

    private boolean _$1(int fieldIndex, Node node) {
        if (node instanceof UnknownSymbol) {
            if (this.ifields[fieldIndex].equals(((UnknownSymbol)node).getName())) {
                return true;
            }
        } else if (node instanceof FieldId) {
            return ((FieldId)node).getFieldIndex() == fieldIndex;
        }
        return false;
    }

    private boolean _$1(Node home, IIIlIIIIlIIIIIlI[] filters, Context ctx) {
        block40: {
            Node right;
            Node left;
            block43: {
                block42: {
                    block41: {
                        block39: {
                            if (!(home instanceof Operator)) {
                                return false;
                            }
                            left = home.getLeft();
                            right = home.getRight();
                            if (home instanceof And) {
                                if (!this._$1(left, filters, ctx)) {
                                    return false;
                                }
                                return this._$1(right, filters, ctx);
                            }
                            if (!(home instanceof Equals)) break block39;
                            int icount = this.ifields.length;
                            for (int i = 0; i < icount; ++i) {
                                if (this._$1(i, left)) {
                                    if (filters[i] != null) {
                                        return false;
                                    }
                                    filters[i] = new IIIlIIIIlIIIIIlI(this, null);
                                    IIIlIIIIlIIIIIlI._$2(filters[i], 0);
                                    IIIlIIIIlIIIIIlI._$2(filters[i], right.calculate(ctx));
                                    return true;
                                }
                                if (!this._$1(i, right)) continue;
                                if (filters[i] != null) {
                                    return false;
                                }
                                filters[i] = new IIIlIIIIlIIIIIlI(this, null);
                                IIIlIIIIlIIIIIlI._$2(filters[i], 0);
                                IIIlIIIIlIIIIIlI._$2(filters[i], left.calculate(ctx));
                                return true;
                            }
                            break block40;
                        }
                        if (!(home instanceof NotSmaller)) break block41;
                        int icount = this.ifields.length;
                        for (int i = 0; i < icount; ++i) {
                            if (this._$1(i, left)) {
                                if (filters[i] == null) {
                                    filters[i] = new IIIlIIIIlIIIIIlI(this, null);
                                } else if (IIIlIIIIlIIIIIlI._$4(filters[i]) != -1) {
                                    return false;
                                }
                                IIIlIIIIlIIIIIlI._$2(filters[i], 1);
                                IIIlIIIIlIIIIIlI._$2(filters[i], right.calculate(ctx));
                                return true;
                            }
                            if (!this._$1(i, right)) continue;
                            if (filters[i] == null) {
                                filters[i] = new IIIlIIIIlIIIIIlI(this, null);
                            } else if (IIIlIIIIlIIIIIlI._$2(filters[i]) != -1) {
                                return false;
                            }
                            IIIlIIIIlIIIIIlI._$1(filters[i], 3);
                            IIIlIIIIlIIIIIlI._$1(filters[i], left.calculate(ctx));
                            return true;
                        }
                        break block40;
                    }
                    if (!(home instanceof Greater)) break block42;
                    int icount = this.ifields.length;
                    for (int i = 0; i < icount; ++i) {
                        if (this._$1(i, left)) {
                            if (filters[i] == null) {
                                filters[i] = new IIIlIIIIlIIIIIlI(this, null);
                            } else if (IIIlIIIIlIIIIIlI._$4(filters[i]) != -1) {
                                return false;
                            }
                            IIIlIIIIlIIIIIlI._$2(filters[i], 2);
                            IIIlIIIIlIIIIIlI._$2(filters[i], right.calculate(ctx));
                            return true;
                        }
                        if (!this._$1(i, right)) continue;
                        if (filters[i] == null) {
                            filters[i] = new IIIlIIIIlIIIIIlI(this, null);
                        } else if (IIIlIIIIlIIIIIlI._$2(filters[i]) != -1) {
                            return false;
                        }
                        IIIlIIIIlIIIIIlI._$1(filters[i], 4);
                        IIIlIIIIlIIIIIlI._$1(filters[i], left.calculate(ctx));
                        return true;
                    }
                    break block40;
                }
                if (!(home instanceof NotGreater)) break block43;
                int icount = this.ifields.length;
                for (int i = 0; i < icount; ++i) {
                    if (this._$1(i, left)) {
                        if (filters[i] == null) {
                            filters[i] = new IIIlIIIIlIIIIIlI(this, null);
                        } else if (IIIlIIIIlIIIIIlI._$2(filters[i]) != -1) {
                            return false;
                        }
                        IIIlIIIIlIIIIIlI._$1(filters[i], 3);
                        IIIlIIIIlIIIIIlI._$1(filters[i], right.calculate(ctx));
                        return true;
                    }
                    if (!this._$1(i, right)) continue;
                    if (filters[i] == null) {
                        filters[i] = new IIIlIIIIlIIIIIlI(this, null);
                    } else if (IIIlIIIIlIIIIIlI._$4(filters[i]) != -1) {
                        return false;
                    }
                    IIIlIIIIlIIIIIlI._$2(filters[i], 1);
                    IIIlIIIIlIIIIIlI._$2(filters[i], left.calculate(ctx));
                    return true;
                }
                break block40;
            }
            if (!(home instanceof Smaller)) break block40;
            int icount = this.ifields.length;
            for (int i = 0; i < icount; ++i) {
                if (this._$1(i, left)) {
                    if (filters[i] == null) {
                        filters[i] = new IIIlIIIIlIIIIIlI(this, null);
                    } else if (IIIlIIIIlIIIIIlI._$2(filters[i]) != -1) {
                        return false;
                    }
                    IIIlIIIIlIIIIIlI._$1(filters[i], 4);
                    IIIlIIIIlIIIIIlI._$1(filters[i], right.calculate(ctx));
                    return true;
                }
                if (!this._$1(i, right)) continue;
                if (filters[i] == null) {
                    filters[i] = new IIIlIIIIlIIIIIlI(this, null);
                } else if (IIIlIIIIlIIIIIlI._$4(filters[i]) != -1) {
                    return false;
                }
                IIIlIIIIlIIIIIlI._$2(filters[i], 2);
                IIIlIIIIlIIIIIlI._$2(filters[i], left.calculate(ctx));
                return true;
            }
        }
        return false;
    }

    private void _$1(int fieldIndex, Node home, IIIlIIIIlIIIIIlI filter, Context ctx) {
        if (!(home instanceof Operator)) {
            return;
        }
        Node left = home.getLeft();
        Node right = home.getRight();
        if (home instanceof And) {
            this._$1(fieldIndex, left, filter, ctx);
            this._$1(fieldIndex, right, filter, ctx);
        } else if (home instanceof Equals) {
            if (this._$1(fieldIndex, left)) {
                IIIlIIIIlIIIIIlI._$2(filter, 0);
                IIIlIIIIlIIIIIlI._$2(filter, right.calculate(ctx));
            } else if (this._$1(fieldIndex, right)) {
                IIIlIIIIlIIIIIlI._$2(filter, 0);
                IIIlIIIIlIIIIIlI._$2(filter, left.calculate(ctx));
            }
        } else if (home instanceof NotSmaller) {
            if (this._$1(fieldIndex, left)) {
                IIIlIIIIlIIIIIlI._$2(filter, 1);
                IIIlIIIIlIIIIIlI._$2(filter, right.calculate(ctx));
            } else if (this._$1(fieldIndex, right)) {
                IIIlIIIIlIIIIIlI._$1(filter, 3);
                IIIlIIIIlIIIIIlI._$1(filter, left.calculate(ctx));
            }
        } else if (home instanceof Greater) {
            if (this._$1(fieldIndex, left)) {
                IIIlIIIIlIIIIIlI._$2(filter, 2);
                IIIlIIIIlIIIIIlI._$2(filter, right.calculate(ctx));
            } else if (this._$1(fieldIndex, right)) {
                IIIlIIIIlIIIIIlI._$1(filter, 4);
                IIIlIIIIlIIIIIlI._$1(filter, left.calculate(ctx));
            }
        } else if (home instanceof NotGreater) {
            if (this._$1(fieldIndex, left)) {
                IIIlIIIIlIIIIIlI._$1(filter, 3);
                IIIlIIIIlIIIIIlI._$1(filter, right.calculate(ctx));
            } else if (this._$1(fieldIndex, right)) {
                IIIlIIIIlIIIIIlI._$2(filter, 1);
                IIIlIIIIlIIIIIlI._$2(filter, left.calculate(ctx));
            }
        } else if (home instanceof Smaller) {
            if (this._$1(fieldIndex, left)) {
                IIIlIIIIlIIIIIlI._$1(filter, 4);
                IIIlIIIIlIIIIIlI._$1(filter, right.calculate(ctx));
            } else if (this._$1(fieldIndex, right)) {
                IIIlIIIIlIIIIIlI._$2(filter, 2);
                IIIlIIIIlIIIIIlI._$2(filter, left.calculate(ctx));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongArray _$1(ObjectReader reader, Expression exp, Context ctx, int start, int end, long startPos) throws IOException {
        int icount = this.ifields.length;
        int posCount = this.positionCount;
        reader.seek(startPos);
        LongArray posArray = new LongArray(1024);
        DataStruct ds = new DataStruct(this.ifields);
        Record r = new Record(ds);
        ComputeStack stack = ctx.getComputeStack();
        stack.push(r);
        try {
            while (start <= end) {
                int count;
                while ((count = reader.readInt()) > 0) {
                    int j;
                    int i;
                    for (int i2 = 0; i2 < icount; ++i2) {
                        r.setNormalFieldValue(i2, reader.readObject());
                    }
                    Object b = exp.calculate(ctx);
                    if (Variant.isTrue(b)) {
                        for (i = 0; i < count; ++i) {
                            posArray.add(reader.readLong());
                            for (j = 0; j < posCount; ++j) {
                                posArray.add(reader.readLong());
                            }
                        }
                        continue;
                    }
                    for (i = 0; i < count; ++i) {
                        reader.skipObject();
                        for (j = 0; j < posCount; ++j) {
                            reader.skipObject();
                        }
                    }
                }
                ++start;
            }
        }
        finally {
            stack.pop();
        }
        return posArray;
    }

    private LongArray _$1(ObjectReader reader, Object val, int seq, int type, long startPos, long seqPos) throws IOException {
        LongArray posArray = new LongArray(1024);
        int posCount = this.positionCount;
        block0 : switch (type) {
            case 0: {
                int j;
                int i;
                int cmp;
                int count;
                reader.seek(seqPos);
                block4: while (true) {
                    count = reader.readInt();
                    Object cur = reader.readObject();
                    cmp = Variant.compare(cur, val, true);
                    if (cmp >= 0) break;
                    i = 0;
                    while (true) {
                        if (i >= count) continue block4;
                        reader.skipObject();
                        for (j = 0; j < posCount; ++j) {
                            reader.skipObject();
                        }
                        ++i;
                    }
                    break;
                }
                if (cmp != 0) break;
                for (i = 0; i < count; ++i) {
                    posArray.add(reader.readLong());
                    for (j = 0; j < posCount; ++j) {
                        posArray.add(reader.readLong());
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                int j;
                int i;
                int cmp;
                int count;
                reader.seek(seqPos);
                block9: while (true) {
                    count = reader.readInt();
                    Object cur = reader.readObject();
                    cmp = Variant.compare(cur, val, true);
                    if (cmp >= 0) break;
                    i = 0;
                    while (true) {
                        if (i >= count) continue block9;
                        reader.skipObject();
                        for (j = 0; j < posCount; ++j) {
                            reader.skipObject();
                        }
                        ++i;
                    }
                    break;
                }
                if (cmp == 0) {
                    if (type == 1) {
                        for (i = 0; i < count; ++i) {
                            posArray.add(reader.readLong());
                            for (j = 0; j < posCount; ++j) {
                                posArray.add(reader.readLong());
                            }
                        }
                    } else {
                        for (i = 0; i < count; ++i) {
                            reader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                reader.skipObject();
                            }
                        }
                    }
                } else {
                    for (i = 0; i < count; ++i) {
                        posArray.add(reader.readLong());
                        for (j = 0; j < posCount; ++j) {
                            posArray.add(reader.readLong());
                        }
                    }
                }
                block18: while (true) {
                    if ((count = reader.readInt()) == -1) {
                        count = reader.readInt();
                    } else if (count == -2) break block0;
                    reader.readObject();
                    int i2 = 0;
                    while (true) {
                        if (i2 >= count) continue block18;
                        posArray.add(reader.readLong());
                        for (int j2 = 0; j2 < posCount; ++j2) {
                            posArray.add(reader.readLong());
                        }
                        ++i2;
                    }
                    break;
                }
            }
            default: {
                int j;
                int i;
                int cmp;
                int count;
                reader.seek(startPos);
                while (seq > 0) {
                    count = reader.readInt();
                    if (count == -1) {
                        --seq;
                        continue;
                    }
                    reader.readObject();
                    for (int i3 = 0; i3 < count; ++i3) {
                        posArray.add(reader.readLong());
                        for (int j3 = 0; j3 < posCount; ++j3) {
                            posArray.add(reader.readLong());
                        }
                    }
                }
                block24: while (true) {
                    count = reader.readInt();
                    Object cur = reader.readObject();
                    cmp = Variant.compare(cur, val, true);
                    if (cmp >= 0) break;
                    i = 0;
                    while (true) {
                        if (i >= count) continue block24;
                        posArray.add(reader.readLong());
                        for (j = 0; j < posCount; ++j) {
                            posArray.add(reader.readLong());
                        }
                        ++i;
                    }
                    break;
                }
                if (cmp != 0 || type != 3) break;
                for (i = 0; i < count; ++i) {
                    posArray.add(reader.readLong());
                    for (j = 0; j < posCount; ++j) {
                        posArray.add(reader.readLong());
                    }
                }
            }
        }
        return posArray;
    }

    private LongArray _$2(ObjectReader reader, Sequence vals) throws IOException {
        int i;
        LongArray tempPos = new LongArray(vals.length() * (this.positionCount + 1));
        int index = 1;
        int rootCount = this.rootBlockMaxVals.length;
        IlllIlIIIlIlllll blockInfo = new IlllIlIIIlIlllll(this, null);
        for (i = 0; i < rootCount; ++i) {
            if (this.cachedBlockReader == null) {
                if (this.internalAllBlockPos == null) {
                    this._$1(this.indexFile, this.rootBlockPos[i], blockInfo);
                } else {
                    this._$1(false, i, blockInfo);
                }
                index = this._$1(reader, vals, index, IlllIlIIIlIlllll._$2(blockInfo), IlllIlIIIlIlllll._$1(blockInfo), tempPos);
            } else {
                index = this._$1(vals, index, this.internalAllBlockMaxVals[i], this.cachedBlockReader[i], tempPos);
            }
            if (index < 0) break;
        }
        index = 1;
        if (this.rootBlockPos2 == null) {
            return tempPos;
        }
        rootCount = this.rootBlockMaxVals2.length;
        for (i = 0; i < rootCount; ++i) {
            if (this.cachedBlockReader2 == null) {
                if (this.internalAllBlockPos2 == null) {
                    this._$1(this.indexFile, this.rootBlockPos2[i], blockInfo);
                } else {
                    this._$1(true, i, blockInfo);
                }
                index = this._$1(reader, vals, index, IlllIlIIIlIlllll._$2(blockInfo), IlllIlIIIlIlllll._$1(blockInfo), tempPos);
            } else {
                index = this._$1(vals, index, this.internalAllBlockMaxVals2[i], this.cachedBlockReader2[i], tempPos);
            }
            if (index < 0) break;
        }
        return tempPos;
    }

    private int _$1(ObjectReader reader, Sequence vals, int srcIndex, Object[] blockMaxVals, long[] blockPos, LongArray outPos) throws IOException {
        IArray mems = vals.getMems();
        Object srcVal = mems.get(srcIndex);
        int block = PhyTableIndex._$1(blockMaxVals, srcVal);
        if (block < 0) {
            return srcIndex;
        }
        int posCount = this.positionCount;
        int blockCount = blockPos.length;
        reader.seek(blockPos[block]);
        int srcLen = mems.size();
        LongArray posArray = outPos;
        block0: while (true) {
            int j;
            int i;
            int count;
            block17: {
                if ((count = reader.readInt()) == -1) {
                    while (++block < blockCount) {
                        if (Variant.compare(blockMaxVals[block], srcVal, true) < 0) continue;
                        reader.seek(blockPos[block]);
                        count = reader.readInt();
                        break block17;
                    }
                    break;
                }
                if (count == -2) break;
            }
            Object cur = reader.readObject();
            int cmp = Variant.compare(cur, srcVal, true);
            if (cmp < 0) {
                i = 0;
                while (true) {
                    if (i >= count) continue block0;
                    reader.skipObject();
                    for (j = 0; j < posCount; ++j) {
                        reader.skipObject();
                    }
                    ++i;
                }
            }
            if (cmp == 0) {
                for (i = 0; i < count; ++i) {
                    posArray.add(reader.readLong());
                    for (j = 0; j < posCount; ++j) {
                        posArray.add(reader.readLong());
                    }
                }
                if (++srcIndex > srcLen) break;
                srcVal = mems.get(srcIndex);
                continue;
            }
            while (++srcIndex <= srcLen) {
                srcVal = mems.get(srcIndex);
                cmp = Variant.compare(cur, srcVal, true);
                if (cmp < 0) {
                    i = 0;
                    while (true) {
                        if (i >= count) continue block0;
                        reader.skipObject();
                        for (j = 0; j < posCount; ++j) {
                            reader.skipObject();
                        }
                        ++i;
                    }
                }
                if (cmp != 0) continue;
                for (i = 0; i < count; ++i) {
                    posArray.add(reader.readLong());
                    for (j = 0; j < posCount; ++j) {
                        posArray.add(reader.readLong());
                    }
                }
                if (++srcIndex > srcLen) break block0;
                srcVal = mems.get(srcIndex);
                continue block0;
            }
            break;
        }
        if (srcIndex > srcLen) {
            return -1;
        }
        return srcIndex;
    }

    private LongArray _$1(ObjectReader reader, Sequence vals) throws IOException {
        int i;
        LongArray srcPos = new LongArray(vals.length() * (this.positionCount + 1));
        int index = 1;
        int rootCount = this.rootBlockMaxVals.length;
        IlllIlIIIlIlllll blockInfo = new IlllIlIIIlIlllll(this, null);
        for (i = 0; i < rootCount; ++i) {
            if (this.cachedBlockReader == null) {
                if (this.internalAllBlockPos == null) {
                    this._$1(this.indexFile, this.rootBlockPos[i], blockInfo);
                } else {
                    this._$1(false, i, blockInfo);
                }
                index = this._$1(reader, vals, index, (Object[][])IlllIlIIIlIlllll._$2(blockInfo), IlllIlIIIlIlllll._$1(blockInfo), srcPos);
            } else {
                index = this._$1(vals, index, (Object[][])this.internalAllBlockMaxVals[i], this.cachedBlockReader[i], srcPos);
            }
            if (index < 0) break;
        }
        index = 1;
        if (this.rootBlockPos2 == null) {
            return srcPos;
        }
        rootCount = this.rootBlockMaxVals2.length;
        for (i = 0; i < rootCount; ++i) {
            if (this.cachedBlockReader == null) {
                if (this.internalAllBlockPos2 == null) {
                    this._$1(this.indexFile, this.rootBlockPos2[i], blockInfo);
                } else {
                    this._$1(true, i, blockInfo);
                }
                index = this._$1(reader, vals, index, (Object[][])IlllIlIIIlIlllll._$2(blockInfo), IlllIlIIIlIlllll._$1(blockInfo), srcPos);
            } else {
                index = this._$1(vals, index, (Object[][])this.internalAllBlockMaxVals2[i], this.cachedBlockReader2[i], srcPos);
            }
            if (index < 0) break;
        }
        return srcPos;
    }

    /*
     * Unable to fully structure code
     */
    private int _$1(ObjectReader reader, Sequence vals, int srcIndex, Object[][] blockMaxVals, long[] blockPos, LongArray outPos) throws IOException {
        block21: {
            mems = vals.getMems();
            srcVal = mems.get(srcIndex);
            isSequence = false;
            srcKeyCount = 1;
            if (srcVal instanceof Sequence) {
                isSequence = true;
                srcKeys = ((Sequence)srcVal).toArray();
                srcKeyCount = srcKeys.length;
            } else {
                srcKeys = new Object[]{srcVal};
            }
            block = PhyTableIndex._$1(blockMaxVals, srcKeys, true);
            if (block < 0) {
                return srcIndex;
            }
            posCount = this.positionCount;
            blockCount = blockPos.length;
            reader.seek(blockPos[block]);
            icount = this.ifields.length;
            keys = new Object[icount];
            srcLen = mems.size();
            posArray = new LongArray(srcLen);
            block0: while (true) lbl-1000:
            // 5 sources

            {
                block23: {
                    block22: {
                        block20: {
                            if ((count = reader.readInt()) == -1) {
                                while (++block < blockCount) {
                                    if (Variant.compareArrays(blockMaxVals[block], srcKeys, srcKeyCount) < 0) continue;
                                    reader.seek(blockPos[block]);
                                    count = reader.readInt();
                                    break block20;
                                }
                                break block21;
                            }
                            if (count == -2) break block21;
                        }
                        for (i = 0; i < icount; ++i) {
                            keys[i] = reader.readObject();
                        }
                        cmp = Variant.compareArrays(keys, srcKeys, srcKeyCount);
                        if (cmp >= 0) break block22;
                        i = 0;
                        while (true) {
                            if (i >= count) ** GOTO lbl-1000
                            reader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                reader.skipObject();
                            }
                            ++i;
                        }
                    }
                    if (cmp != 0) break block23;
                    i = 0;
                    while (true) {
                        if (i >= count) ** GOTO lbl-1000
                        posArray.add(reader.readLong());
                        for (j = 0; j < posCount; ++j) {
                            posArray.add(reader.readLong());
                        }
                        ++i;
                    }
                }
                while (++srcIndex <= srcLen) {
                    block24: {
                        srcVal = mems.get(srcIndex);
                        if (isSequence) {
                            ((Sequence)srcVal).toArray(srcKeys);
                        } else {
                            srcKeys[0] = srcVal;
                        }
                        cmp = Variant.compareArrays(keys, srcKeys, srcKeyCount);
                        if (cmp >= 0) break block24;
                        i = 0;
                        while (true) {
                            if (i >= count) ** GOTO lbl-1000
                            reader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                reader.skipObject();
                            }
                            ++i;
                        }
                    }
                    if (cmp != 0) continue;
                    i = 0;
lbl78:
                    // 2 sources

                    while (true) {
                        if (i >= count) continue block0;
                        break;
                    }
                }
                break block21;
                break;
            }
            posArray.add(reader.readLong());
            for (j = 0; j < posCount; ++j) {
                posArray.add(reader.readLong());
            }
            ++i;
            ** while (true)
        }
        for (i = 0; i < posArray.size(); ++i) {
            outPos.add(posArray.get(i));
        }
        if (srcIndex > srcLen) {
            return -1;
        }
        return srcIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private LongArray _$1(ObjectReader reader, Object val, int seq, int type, Expression exp, Context ctx, long startPos, long seqPos) throws IOException {
        block74: {
            if (exp == null) {
                return this._$1(reader, val, seq, type, startPos, seqPos);
            }
            posArray = new LongArray(1024);
            ds = new DataStruct(this.ifields);
            r = new Record(ds);
            posCount = this.positionCount;
            stack = ctx.getComputeStack();
            stack.push(r);
            try {
                switch (type) {
                    case 0: {
                        reader.seek(seqPos);
                        block8: while (true) {
                            count = reader.readInt();
                            cur = reader.readObject();
                            cmp = Variant.compare(cur, val, true);
                            if (cmp >= 0) break;
                            i = 0;
                            while (true) {
                                if (i >= count) continue block8;
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                                ++i;
                            }
                            break;
                        }
                        if (cmp == 0) {
                            r.setNormalFieldValue(0, cur);
                            b = exp.calculate(ctx);
                            if (Variant.isTrue(b)) {
                                for (i = 0; i < count; ++i) {
                                    posArray.add(reader.readLong());
                                    for (j = 0; j < posCount; ++j) {
                                        posArray.add(reader.readLong());
                                    }
                                }
                            }
                        }
                        break;
                    }
                    case 5: {
                        reader.seek(startPos);
                        findFirst = false;
                        block13: while (true) {
                            if ((count = reader.readInt()) != -1) ** GOTO lbl45
                            count = reader.readInt();
                            ** GOTO lbl46
lbl45:
                            // 1 sources

                            if (count == -2) ** GOTO lbl69
lbl46:
                            // 2 sources

                            cur = reader.readObject();
                            r.setNormalFieldValue(0, cur);
                            b = exp.calculate(ctx);
                            if (Variant.isTrue(b)) {
                                findFirst = true;
                                i = 0;
                                while (true) {
                                    if (i >= count) continue block13;
                                    posArray.add(reader.readLong());
                                    for (j = 0; j < posCount; ++j) {
                                        posArray.add(reader.readLong());
                                    }
                                    ++i;
                                }
                            }
                            for (i = 0; i < count; ++i) {
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                            }
                            if (findFirst) break;
                        }
                        findFirst = false;
lbl69:
                        // 2 sources

                        if (!findFirst) {
                            ** break;
lbl71:
                            // 1 sources

                            break;
                        }
                        block18: while (true) {
                            if ((count = reader.readInt()) != -1) ** GOTO lbl76
                            count = reader.readInt();
                            ** GOTO lbl-1000
lbl76:
                            // 1 sources

                            if (count == -2) {
                                ** break;
lbl78:
                                // 1 sources

                            } else lbl-1000:
                            // 2 sources

                            {
                                cur = reader.readObject();
                                r.setNormalFieldValue(0, cur);
                                b = exp.calculate(ctx);
                                if (Variant.isTrue(b)) {
                                    i = 0;
                                    while (true) {
                                        if (i >= count) continue block18;
                                        posArray.add(reader.readLong());
                                        for (j = 0; j < posCount; ++j) {
                                            posArray.add(reader.readLong());
                                        }
                                        ++i;
                                    }
                                }
                            }
                            break block74;
                            break;
                        }
                    }
                    case 1: 
                    case 2: {
                        reader.seek(seqPos);
                        block21: while (true) {
                            count = reader.readInt();
                            cur = reader.readObject();
                            cmp = Variant.compare(cur, val, true);
                            if (cmp >= 0) break;
                            i = 0;
                            while (true) {
                                if (i >= count) continue block21;
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                                ++i;
                            }
                            break;
                        }
                        if (cmp == 0) {
                            if (type == 1) {
                                r.setNormalFieldValue(0, cur);
                                b = exp.calculate(ctx);
                                if (Variant.isTrue(b)) {
                                    for (i = 0; i < count; ++i) {
                                        posArray.add(reader.readLong());
                                        for (j = 0; j < posCount; ++j) {
                                            posArray.add(reader.readLong());
                                        }
                                    }
                                } else {
                                    for (i = 0; i < count; ++i) {
                                        reader.skipObject();
                                        for (j = 0; j < posCount; ++j) {
                                            reader.skipObject();
                                        }
                                    }
                                }
                            } else {
                                for (i = 0; i < count; ++i) {
                                    reader.skipObject();
                                    for (j = 0; j < posCount; ++j) {
                                        reader.skipObject();
                                    }
                                }
                            }
                        } else {
                            r.setNormalFieldValue(0, cur);
                            b = exp.calculate(ctx);
                            if (Variant.isTrue(b)) {
                                for (i = 0; i < count; ++i) {
                                    posArray.add(reader.readLong());
                                    for (j = 0; j < posCount; ++j) {
                                        posArray.add(reader.readLong());
                                    }
                                }
                            } else {
                                for (i = 0; i < count; ++i) {
                                    reader.skipObject();
                                    for (j = 0; j < posCount; ++j) {
                                        reader.skipObject();
                                    }
                                }
                            }
                        }
                        block34: while (true) lbl-1000:
                        // 3 sources

                        {
                            if ((count = reader.readInt()) == -1) {
                                count = reader.readInt();
                            } else if (count == -2) {
                                ** break;
lbl157:
                                // 1 sources

                                break block74;
                            }
                            cur = reader.readObject();
                            r.setNormalFieldValue(0, cur);
                            b = exp.calculate(ctx);
                            if (!Variant.isTrue(b)) ** GOTO lbl171
                            i = 0;
                            while (true) {
                                if (i >= count) ** GOTO lbl-1000
                                posArray.add(reader.readLong());
                                for (j = 0; j < posCount; ++j) {
                                    posArray.add(reader.readLong());
                                }
                                ++i;
                            }
lbl171:
                            // 1 sources

                            i = 0;
                            while (true) {
                                if (i >= count) continue block34;
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                    default: {
                        reader.seek(startPos);
                        while (seq > 0) {
                            count = reader.readInt();
                            if (count == -1) {
                                --seq;
                                continue;
                            }
                            cur = reader.readObject();
                            r.setNormalFieldValue(0, cur);
                            b = exp.calculate(ctx);
                            if (Variant.isTrue(b)) {
                                for (i = 0; i < count; ++i) {
                                    posArray.add(reader.readLong());
                                    for (j = 0; j < posCount; ++j) {
                                        posArray.add(reader.readLong());
                                    }
                                }
                                continue;
                            }
                            for (i = 0; i < count; ++i) {
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                            }
                        }
                        block44: while (true) lbl-1000:
                        // 3 sources

                        {
                            count = reader.readInt();
                            cur = reader.readObject();
                            cmp = Variant.compare(cur, val, true);
                            if (cmp >= 0) break;
                            r.setNormalFieldValue(0, cur);
                            b = exp.calculate(ctx);
                            if (!Variant.isTrue(b)) ** GOTO lbl222
                            i = 0;
                            while (true) {
                                if (i >= count) ** GOTO lbl-1000
                                posArray.add(reader.readLong());
                                for (j = 0; j < posCount; ++j) {
                                    posArray.add(reader.readLong());
                                }
                                ++i;
                            }
lbl222:
                            // 1 sources

                            i = 0;
                            while (true) {
                                if (i >= count) continue block44;
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                                ++i;
                            }
                            break;
                        }
                        if (cmp == 0 && type == 3) {
                            r.setNormalFieldValue(0, cur);
                            b = exp.calculate(ctx);
                            if (Variant.isTrue(b)) {
                                for (i = 0; i < count; ++i) {
                                    posArray.add(reader.readLong());
                                    for (j = 0; j < posCount; ++j) {
                                        posArray.add(reader.readLong());
                                    }
                                }
                            }
                        }
                        break;
                    }
                }
            }
            finally {
                stack.pop();
            }
        }
        return posArray;
    }

    /*
     * Unable to fully structure code
     */
    private LongArray _$1(ObjectReader reader, Object[] vals, int seq, int type, long startPos, long seqPos) throws IOException {
        posArray = new LongArray(1024);
        sc = vals.length;
        icount = this.ifields.length;
        posCount = this.positionCount;
        keys = new Object[icount];
        block0 : switch (type) {
            case 0: {
                reader.seek(seqPos);
                block4: while (true) lbl-1000:
                // 3 sources

                {
                    if ((count = reader.readInt()) == -1) {
                        count = reader.readInt();
                    } else if (count == -2) break block0;
                    for (i = 0; i < icount; ++i) {
                        keys[i] = reader.readObject();
                    }
                    cmp = Variant.compareArrays(keys, vals, sc);
                    if (cmp >= 0) ** GOTO lbl28
                    i = 0;
                    while (true) {
                        if (i >= count) ** GOTO lbl-1000
                        reader.skipObject();
                        for (j = 0; j < posCount; ++j) {
                            reader.skipObject();
                        }
                        ++i;
                    }
lbl28:
                    // 1 sources

                    if (cmp != 0) break block0;
                    i = 0;
                    while (true) {
                        if (i >= count) continue block4;
                        posArray.add(reader.readLong());
                        for (j = 0; j < posCount; ++j) {
                            posArray.add(reader.readLong());
                        }
                        ++i;
                    }
                    break;
                }
            }
            case 1: 
            case 2: {
                reader.seek(seqPos);
                block10: while (true) {
                    if ((count = reader.readInt()) == -1) {
                        count = reader.readInt();
                    } else if (count == -2) break block0;
                    for (i = 0; i < icount; ++i) {
                        keys[i] = reader.readObject();
                    }
                    cmp = Variant.compareArrays(keys, vals, sc);
                    if (cmp <= 0 && (cmp != 0 || type != 1)) ** GOTO lbl57
                    for (i = 0; i < count; ++i) {
                        posArray.add(reader.readLong());
                        for (j = 0; j < posCount; ++j) {
                            posArray.add(reader.readLong());
                        }
                    }
                    ** GOTO lbl66
lbl57:
                    // 1 sources

                    i = 0;
lbl58:
                    // 2 sources

                    while (true) {
                        if (i >= count) continue block10;
                        break;
                    }
                    break;
                }
                reader.skipObject();
                for (j = 0; j < posCount; ++j) {
                    reader.skipObject();
                }
                ++i;
                ** continue;
lbl66:
                // 1 sources

                block16: while (true) {
                    if ((count = reader.readInt()) == -1) {
                        count = reader.readInt();
                    } else if (count == -2) break block0;
                    for (i = 0; i < icount; ++i) {
                        reader.readObject();
                    }
                    i = 0;
                    while (true) {
                        if (i >= count) continue block16;
                        posArray.add(reader.readLong());
                        for (j = 0; j < posCount; ++j) {
                            posArray.add(reader.readLong());
                        }
                        ++i;
                    }
                    break;
                }
            }
            default: {
                reader.seek(startPos);
                while (seq > 0) {
                    count = reader.readInt();
                    if (count == -1) {
                        --seq;
                        continue;
                    }
                    if (count == -2) break;
                    for (i = 0; i < icount; ++i) {
                        keys[i] = reader.readObject();
                    }
                    cmp = Variant.compareArrays(keys, vals, sc);
                    if (cmp < 0) {
                        for (i = 0; i < count; ++i) {
                            posArray.add(reader.readLong());
                            for (j = 0; j < posCount; ++j) {
                                posArray.add(reader.readLong());
                            }
                        }
                        continue;
                    }
                    if (cmp == 0 && type == 3) {
                        for (i = 0; i < count; ++i) {
                            posArray.add(reader.readLong());
                            for (j = 0; j < posCount; ++j) {
                                posArray.add(reader.readLong());
                            }
                        }
                    } else {
                        for (i = 0; i < count; ++i) {
                            reader.readLong();
                            for (j = 0; j < posCount; ++j) {
                                reader.readLong();
                            }
                        }
                    }
                    break;
                }
                block28: while (true) lbl-1000:
                // 3 sources

                {
                    if ((count = reader.readInt()) == -1) {
                        count = reader.readInt();
                    } else if (count == -2) break block0;
                    for (i = 0; i < icount; ++i) {
                        keys[i] = reader.readObject();
                    }
                    cmp = Variant.compareArrays(keys, vals, sc);
                    if (cmp >= 0) ** GOTO lbl140
                    i = 0;
                    while (true) {
                        if (i >= count) ** GOTO lbl-1000
                        posArray.add(reader.readLong());
                        for (j = 0; j < posCount; ++j) {
                            posArray.add(reader.readLong());
                        }
                        ++i;
                    }
lbl140:
                    // 1 sources

                    if (cmp != 0 || type != 3) break block0;
                    i = 0;
                    while (true) {
                        if (i >= count) continue block28;
                        posArray.add(reader.readLong());
                        for (j = 0; j < posCount; ++j) {
                            posArray.add(reader.readLong());
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return posArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private LongArray _$1(ObjectReader reader, Object[] vals, int seq, int type, Expression exp, Context ctx, long startPos, long seqPos) throws IOException {
        block75: {
            if (exp == null) {
                return this._$1(reader, vals, seq, type, startPos, seqPos);
            }
            posArray = new LongArray(1024);
            sc = vals.length;
            icount = this.ifields.length;
            posCount = this.positionCount;
            keys = new Object[icount];
            ds = new DataStruct(this.ifields);
            r = new Record(ds);
            stack = ctx.getComputeStack();
            stack.push(r);
            try {
                switch (type) {
                    case 0: {
                        reader.seek(seqPos);
                        block7: while (true) {
                            if ((count = reader.readInt()) != -1) ** GOTO lbl20
                            count = reader.readInt();
                            ** GOTO lbl-1000
lbl20:
                            // 1 sources

                            if (count == -2) {
                                ** break;
lbl22:
                                // 1 sources

                            } else lbl-1000:
                            // 3 sources

                            {
                                for (i = 0; i < icount; ++i) {
                                    keys[i] = reader.readObject();
                                }
                                cmp = Variant.compareArrays(keys, vals, sc);
                                if (cmp < 0) {
                                    i = 0;
                                    while (true) {
                                        if (i >= count) continue block7;
                                        reader.skipObject();
                                        for (j = 0; j < posCount; ++j) {
                                            reader.skipObject();
                                        }
                                        ++i;
                                    }
                                }
                                if (cmp == 0) {
                                    r.setStart(0, keys);
                                    b = exp.calculate(ctx);
                                    if (Variant.isTrue(b)) {
                                        i = 0;
                                        while (true) {
                                            if (i >= count) continue block7;
                                            posArray.add(reader.readLong());
                                            for (j = 0; j < posCount; ++j) {
                                                posArray.add(reader.readLong());
                                            }
                                            ++i;
                                        }
                                    }
                                    i = 0;
                                    while (true) {
                                        if (i < count) ** break;
                                        continue block7;
                                        reader.skipObject();
                                        for (j = 0; j < posCount; ++j) {
                                            reader.skipObject();
                                        }
                                        ++i;
                                    }
                                }
                            }
                            break block75;
                            break;
                        }
                    }
                    case 1: 
                    case 2: {
                        reader.seek(seqPos);
                        block15: while (true) {
                            if ((count = reader.readInt()) == -1) {
                                count = reader.readInt();
                            } else if (count == -2) {
                                ** break;
lbl69:
                                // 1 sources

                                break block75;
                            }
                            for (i = 0; i < icount; ++i) {
                                keys[i] = reader.readObject();
                            }
                            cmp = Variant.compareArrays(keys, vals, sc);
                            if (cmp <= 0 && (cmp != 0 || type != 1)) ** GOTO lbl92
                            r.setStart(0, keys);
                            b = exp.calculate(ctx);
                            if (Variant.isTrue(b)) {
                                for (i = 0; i < count; ++i) {
                                    posArray.add(reader.readLong());
                                    for (j = 0; j < posCount; ++j) {
                                        posArray.add(reader.readLong());
                                    }
                                }
                            } else {
                                for (i = 0; i < count; ++i) {
                                    reader.skipObject();
                                    for (j = 0; j < posCount; ++j) {
                                        reader.skipObject();
                                    }
                                }
                            }
                            ** GOTO lbl101
lbl92:
                            // 1 sources

                            i = 0;
lbl93:
                            // 2 sources

                            while (true) {
                                if (i >= count) continue block15;
                                break;
                            }
                            break;
                        }
                        reader.skipObject();
                        for (j = 0; j < posCount; ++j) {
                            reader.skipObject();
                        }
                        ++i;
                        ** continue;
lbl101:
                        // 2 sources

                        block23: while (true) lbl-1000:
                        // 3 sources

                        {
                            if ((count = reader.readInt()) == -1) {
                                count = reader.readInt();
                            } else if (count == -2) {
                                ** break;
lbl107:
                                // 1 sources

                                break block75;
                            }
                            for (i = 0; i < icount; ++i) {
                                keys[i] = reader.readObject();
                            }
                            r.setStart(0, keys);
                            b = exp.calculate(ctx);
                            if (!Variant.isTrue(b)) ** GOTO lbl123
                            i = 0;
                            while (true) {
                                if (i >= count) ** GOTO lbl-1000
                                posArray.add(reader.readLong());
                                for (j = 0; j < posCount; ++j) {
                                    posArray.add(reader.readLong());
                                }
                                ++i;
                            }
lbl123:
                            // 1 sources

                            i = 0;
                            while (true) {
                                if (i >= count) continue block23;
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                    default: {
                        reader.seek(startPos);
                        while (seq > 0) {
                            count = reader.readInt();
                            if (count == -1) {
                                --seq;
                                continue;
                            }
                            for (i = 0; i < icount; ++i) {
                                keys[i] = reader.readObject();
                            }
                            cmp = Variant.compareArrays(keys, vals, sc);
                            if (cmp < 0) {
                                r.setStart(0, keys);
                                b = exp.calculate(ctx);
                                if (Variant.isTrue(b)) {
                                    for (i = 0; i < count; ++i) {
                                        posArray.add(reader.readLong());
                                        for (j = 0; j < posCount; ++j) {
                                            posArray.add(reader.readLong());
                                        }
                                    }
                                    continue;
                                }
                                for (i = 0; i < count; ++i) {
                                    reader.skipObject();
                                    for (j = 0; j < posCount; ++j) {
                                        reader.skipObject();
                                    }
                                }
                                continue;
                            }
                            if (cmp == 0 && type == 3) {
                                r.setStart(0, keys);
                                b = exp.calculate(ctx);
                                if (Variant.isTrue(b)) {
                                    for (i = 0; i < count; ++i) {
                                        posArray.add(reader.readLong());
                                        for (j = 0; j < posCount; ++j) {
                                            posArray.add(reader.readLong());
                                        }
                                    }
                                } else {
                                    for (i = 0; i < count; ++i) {
                                        reader.skipObject();
                                        for (j = 0; j < posCount; ++j) {
                                            reader.skipObject();
                                        }
                                    }
                                }
                            } else {
                                for (i = 0; i < count; ++i) {
                                    reader.skipObject();
                                    for (j = 0; j < posCount; ++j) {
                                        reader.skipObject();
                                    }
                                }
                            }
                            break;
                        }
                        block41: while (true) lbl-1000:
                        // 5 sources

                        {
                            if ((count = reader.readInt()) == -1) {
                                count = reader.readInt();
                            } else if (count == -2) {
                                ** break;
lbl192:
                                // 1 sources

                                break block75;
                            }
                            for (i = 0; i < icount; ++i) {
                                keys[i] = reader.readObject();
                            }
                            cmp = Variant.compareArrays(keys, vals, sc);
                            if (cmp >= 0) ** GOTO lbl219
                            r.setStart(0, keys);
                            b = exp.calculate(ctx);
                            if (!Variant.isTrue(b)) ** GOTO lbl210
                            i = 0;
                            while (true) {
                                if (i >= count) ** GOTO lbl-1000
                                posArray.add(reader.readLong());
                                for (j = 0; j < posCount; ++j) {
                                    posArray.add(reader.readLong());
                                }
                                ++i;
                            }
lbl210:
                            // 1 sources

                            i = 0;
                            while (true) {
                                if (i >= count) ** GOTO lbl-1000
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                                ++i;
                            }
lbl219:
                            // 1 sources

                            if (cmp != 0 || type != 3) break block75;
                            r.setStart(0, keys);
                            b = exp.calculate(ctx);
                            if (!Variant.isTrue(b)) ** GOTO lbl232
                            i = 0;
                            while (true) {
                                if (i >= count) ** GOTO lbl-1000
                                posArray.add(reader.readLong());
                                for (j = 0; j < posCount; ++j) {
                                    posArray.add(reader.readLong());
                                }
                                ++i;
                            }
lbl232:
                            // 1 sources

                            i = 0;
                            while (true) {
                                if (i >= count) continue block41;
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                }
            }
            finally {
                stack.pop();
            }
        }
        return posArray;
    }

    private LongArray _$1(ObjectReader reader, Object startVal, int start, boolean le, Object endVal, int end, boolean re, long startPos) throws IOException {
        int j;
        int i;
        int cmp;
        Object cur;
        int count;
        LongArray posArray = new LongArray(1024);
        int posCount = this.positionCount;
        reader.seek(startPos);
        block0: while (true) {
            count = reader.readInt();
            cur = reader.readObject();
            cmp = Variant.compare(cur, startVal, true);
            if (cmp >= 0) break;
            i = 0;
            while (true) {
                if (i >= count) continue block0;
                reader.skipObject();
                for (j = 0; j < posCount; ++j) {
                    reader.skipObject();
                }
                ++i;
            }
            break;
        }
        if (cmp == 0) {
            if (le) {
                for (i = 0; i < count; ++i) {
                    posArray.add(reader.readLong());
                    for (j = 0; j < posCount; ++j) {
                        posArray.add(reader.readLong());
                    }
                }
            } else {
                for (i = 0; i < count; ++i) {
                    reader.skipObject();
                    for (j = 0; j < posCount; ++j) {
                        reader.skipObject();
                    }
                }
            }
        } else {
            cmp = Variant.compare(cur, endVal, true);
            if (cmp < 0) {
                for (i = 0; i < count; ++i) {
                    posArray.add(reader.readLong());
                    for (j = 0; j < posCount; ++j) {
                        posArray.add(reader.readLong());
                    }
                }
            } else {
                if (cmp == 0 && re) {
                    for (i = 0; i < count; ++i) {
                        posArray.add(reader.readLong());
                        for (j = 0; j < posCount; ++j) {
                            posArray.add(reader.readLong());
                        }
                    }
                    return posArray;
                }
                return null;
            }
        }
        while (start < end) {
            count = reader.readInt();
            if (count == -1) {
                ++start;
                continue;
            }
            reader.readObject();
            for (int i2 = 0; i2 < count; ++i2) {
                posArray.add(reader.readLong());
                for (int j2 = 0; j2 < posCount; ++j2) {
                    posArray.add(reader.readLong());
                }
            }
        }
        while ((count = reader.readInt()) >= 1) {
            cur = reader.readObject();
            cmp = Variant.compare(cur, endVal, true);
            if (cmp < 0) {
                for (i = 0; i < count; ++i) {
                    posArray.add(reader.readLong());
                    for (j = 0; j < posCount; ++j) {
                        posArray.add(reader.readLong());
                    }
                }
                continue;
            }
            if (cmp != 0 || !re) break;
            for (i = 0; i < count; ++i) {
                posArray.add(reader.readLong());
                for (j = 0; j < posCount; ++j) {
                    posArray.add(reader.readLong());
                }
            }
            break;
        }
        return posArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private LongArray _$1(ObjectReader reader, Object startVal, int start, boolean le, Object endVal, int end, boolean re, Expression exp, Context ctx, long startPos) throws IOException {
        block53: {
            if (exp == null) {
                return this._$1(reader, startVal, start, le, endVal, end, re, startPos);
            }
            posArray = new LongArray(1024);
            posCount = this.positionCount;
            reader.seek(startPos);
            ds = new DataStruct(this.ifields);
            r = new Record(ds);
            stack = ctx.getComputeStack();
            stack.push(r);
            try {
                while (true) {
                    count = reader.readInt();
                    cur = reader.readObject();
                    cmp = Variant.compare(cur, startVal, true);
                    if (cmp < 0) {
                        for (i = 0; i < count; ++i) {
                            reader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                reader.skipObject();
                            }
                        }
                        continue;
                    }
                    if (cmp == 0) {
                        if (le) {
                            r.setNormalFieldValue(0, cur);
                            b = exp.calculate(ctx);
                            if (Variant.isTrue(b)) {
                                for (i = 0; i < count; ++i) {
                                    posArray.add(reader.readLong());
                                    for (j = 0; j < posCount; ++j) {
                                        posArray.add(reader.readLong());
                                    }
                                }
                            } else {
                                for (i = 0; i < count; ++i) {
                                    reader.skipObject();
                                    for (j = 0; j < posCount; ++j) {
                                        reader.skipObject();
                                    }
                                }
                            }
                        } else {
                            for (i = 0; i < count; ++i) {
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                            }
                        }
                        break;
                    }
                    cmp = Variant.compare(cur, endVal, true);
                    if (cmp < 0) {
                        r.setNormalFieldValue(0, cur);
                        b = exp.calculate(ctx);
                        if (Variant.isTrue(b)) {
                            for (i = 0; i < count; ++i) {
                                posArray.add(reader.readLong());
                                for (j = 0; j < posCount; ++j) {
                                    posArray.add(reader.readLong());
                                }
                            }
                        } else {
                            for (i = 0; i < count; ++i) {
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                            }
                        }
                        break;
                    }
                    if (cmp == 0 && re) {
                        r.setNormalFieldValue(0, cur);
                        b = exp.calculate(ctx);
                        if (Variant.isTrue(b)) {
                            for (i = 0; i < count; ++i) {
                                posArray.add(reader.readLong());
                                for (j = 0; j < posCount; ++j) {
                                    posArray.add(reader.readLong());
                                }
                            }
                            i = posArray;
                            return i;
                        }
                        i = null;
                        return i;
                    }
                    b = null;
                    return b;
                }
                while (start < end) {
                    count = reader.readInt();
                    if (count == -1) {
                        ++start;
                        continue;
                    }
                    cur = reader.readObject();
                    r.setNormalFieldValue(0, cur);
                    b = exp.calculate(ctx);
                    if (Variant.isTrue(b)) {
                        for (i = 0; i < count; ++i) {
                            posArray.add(reader.readLong());
                            for (j = 0; j < posCount; ++j) {
                                posArray.add(reader.readLong());
                            }
                        }
                        continue;
                    }
                    for (i = 0; i < count; ++i) {
                        reader.skipObject();
                        for (j = 0; j < posCount; ++j) {
                            reader.skipObject();
                        }
                    }
                }
                block26: while (true) lbl-1000:
                // 3 sources

                {
                    block54: {
                        if ((count = reader.readInt()) < 1) {
                            break block53;
                        }
                        cur = reader.readObject();
                        cmp = Variant.compare(cur, endVal, true);
                        if (cmp >= 0) break;
                        r.setNormalFieldValue(0, cur);
                        b = exp.calculate(ctx);
                        if (!Variant.isTrue(b)) break block54;
                        i = 0;
                        while (true) {
                            if (i >= count) ** GOTO lbl-1000
                            posArray.add(reader.readLong());
                            for (j = 0; j < posCount; ++j) {
                                posArray.add(reader.readLong());
                            }
                            ++i;
                        }
                    }
                    i = 0;
                    while (true) {
                        if (i >= count) continue block26;
                        reader.skipObject();
                        for (j = 0; j < posCount; ++j) {
                            reader.skipObject();
                        }
                        ++i;
                    }
                    break;
                }
                if (cmp == 0 && re) {
                    r.setNormalFieldValue(0, cur);
                    b = exp.calculate(ctx);
                    if (Variant.isTrue(b)) {
                        for (i = 0; i < count; ++i) {
                            posArray.add(reader.readLong());
                            for (j = 0; j < posCount; ++j) {
                                posArray.add(reader.readLong());
                            }
                        }
                    } else {
                        for (i = 0; i < count; ++i) {
                            reader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                reader.skipObject();
                            }
                        }
                    }
                }
            }
            finally {
                stack.pop();
            }
        }
        return posArray;
    }

    /*
     * Unable to fully structure code
     */
    private LongArray _$1(ObjectReader reader, Object[] startVals, int start, boolean le, Object[] endVals, int end, boolean re, long startPos) throws IOException {
        block35: {
            block34: {
                posArray = new LongArray(1024);
                icount = this.ifields.length;
                posCount = this.positionCount;
                sc = startVals.length;
                keys = new Object[icount];
                reader.seek(startPos);
                block0: while (true) lbl-1000:
                // 3 sources

                {
                    block36: {
                        if ((count = reader.readInt()) == -1) {
                            count = reader.readInt();
                            ++start;
                        } else if (count == -2) {
                            return posArray;
                        }
                        for (i = 0; i < icount; ++i) {
                            keys[i] = reader.readObject();
                        }
                        cmp = Variant.compareArrays(keys, startVals, sc);
                        if (cmp >= 0) break block36;
                        i = 0;
                        while (true) {
                            if (i >= count) ** GOTO lbl-1000
                            reader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                reader.skipObject();
                            }
                            ++i;
                        }
                    }
                    if (cmp != 0) break block34;
                    if (le) {
                        for (i = 0; i < count; ++i) {
                            posArray.add(reader.readLong());
                            for (j = 0; j < posCount; ++j) {
                                posArray.add(reader.readLong());
                            }
                        }
                        break block35;
                    }
                    i = 0;
lbl39:
                    // 2 sources

                    while (true) {
                        if (i >= count) continue block0;
                        break;
                    }
                    break;
                }
                reader.skipObject();
                for (j = 0; j < posCount; ++j) {
                    reader.skipObject();
                }
                ++i;
                ** while (true)
            }
            cmp = Variant.compareArrays(keys, endVals, sc);
            if (cmp < 0 || cmp == 0 && re) {
                for (i = 0; i < count; ++i) {
                    posArray.add(reader.readLong());
                    for (j = 0; j < posCount; ++j) {
                        posArray.add(reader.readLong());
                    }
                }
            } else {
                return null;
            }
        }
        while (start < end) {
            count = reader.readInt();
            if (count == -1) {
                ++start;
                continue;
            }
            if (count == -2) break;
            for (i = 0; i < icount; ++i) {
                keys[i] = reader.readObject();
            }
            cmp = Variant.compareArrays(keys, endVals, sc);
            if (cmp < 0) {
                for (i = 0; i < count; ++i) {
                    posArray.add(reader.readLong());
                    for (j = 0; j < posCount; ++j) {
                        posArray.add(reader.readLong());
                    }
                }
                continue;
            }
            if (cmp == 0 && re) {
                for (i = 0; i < count; ++i) {
                    posArray.add(reader.readLong());
                    for (j = 0; j < posCount; ++j) {
                        posArray.add(reader.readLong());
                    }
                }
            } else {
                for (i = 0; i < count; ++i) {
                    reader.readLong();
                    for (j = 0; j < posCount; ++j) {
                        reader.readLong();
                    }
                }
            }
            break;
        }
        block18: while (true) {
            if ((count = reader.readInt()) == -1) {
                count = reader.readInt();
            } else if (count == -2) break;
            for (i = 0; i < icount; ++i) {
                keys[i] = reader.readObject();
            }
            cmp = Variant.compareArrays(keys, endVals, sc);
            if (cmp >= 0 && (cmp != 0 || !re)) break;
            i = 0;
            while (true) {
                if (i >= count) continue block18;
                posArray.add(reader.readLong());
                for (j = 0; j < posCount; ++j) {
                    posArray.add(reader.readLong());
                }
                ++i;
            }
            break;
        }
        return posArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private LongArray _$1(ObjectReader reader, Object[] startVals, int start, boolean le, Object[] endVals, int end, boolean re, Expression exp, Context ctx, long startPos) throws IOException {
        block61: {
            if (exp == null) {
                return this._$1(reader, startVals, start, le, endVals, end, re, startPos);
            }
            posArray = new LongArray(1024);
            icount = this.ifields.length;
            posCount = this.positionCount;
            sc = startVals.length;
            keys = new Object[icount];
            reader.seek(startPos);
            ds = new DataStruct(this.ifields);
            r = new Record(ds);
            stack = ctx.getComputeStack();
            stack.push(r);
            try {
                while (true) {
                    if ((count = reader.readInt()) == -1) {
                        count = reader.readInt();
                        ++start;
                    } else if (count == -2) {
                        if (posArray.size() > 0) {
                            var21_21 = posArray;
                            return var21_21;
                        }
                        var21_22 = null;
                        return var21_22;
                    }
                    for (i = 0; i < icount; ++i) {
                        keys[i] = reader.readObject();
                    }
                    cmp = Variant.compareArrays(keys, startVals, sc);
                    if (cmp < 0) {
                        for (i = 0; i < count; ++i) {
                            reader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                reader.skipObject();
                            }
                        }
                        continue;
                    }
                    if (cmp == 0) {
                        if (le) {
                            r.setStart(0, keys);
                            b = exp.calculate(ctx);
                            if (Variant.isTrue(b)) {
                                for (i = 0; i < count; ++i) {
                                    posArray.add(reader.readLong());
                                    for (j = 0; j < posCount; ++j) {
                                        posArray.add(reader.readLong());
                                    }
                                }
                            } else {
                                for (i = 0; i < count; ++i) {
                                    reader.skipObject();
                                    for (j = 0; j < posCount; ++j) {
                                        reader.skipObject();
                                    }
                                }
                            }
                            break;
                        }
                        for (i = 0; i < count; ++i) {
                            reader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                reader.skipObject();
                            }
                        }
                        continue;
                    }
                    cmp = Variant.compareArrays(keys, endVals, sc);
                    if (cmp < 0 || cmp == 0 && re) {
                        r.setStart(0, keys);
                        b = exp.calculate(ctx);
                        if (Variant.isTrue(b)) {
                            for (i = 0; i < count; ++i) {
                                posArray.add(reader.readLong());
                                for (j = 0; j < posCount; ++j) {
                                    posArray.add(reader.readLong());
                                }
                            }
                        } else {
                            for (i = 0; i < count; ++i) {
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                            }
                        }
                        break;
                    }
                    b = null;
                    return b;
                }
                while (start < end) {
                    count = reader.readInt();
                    if (count == -1) {
                        ++start;
                        continue;
                    }
                    for (i = 0; i < icount; ++i) {
                        keys[i] = reader.readObject();
                    }
                    cmp = Variant.compareArrays(keys, endVals, sc);
                    if (cmp < 0) {
                        r.setStart(0, keys);
                        b = exp.calculate(ctx);
                        if (Variant.isTrue(b)) {
                            for (i = 0; i < count; ++i) {
                                posArray.add(reader.readLong());
                                for (j = 0; j < posCount; ++j) {
                                    posArray.add(reader.readLong());
                                }
                            }
                            continue;
                        }
                        for (i = 0; i < count; ++i) {
                            reader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                reader.skipObject();
                            }
                        }
                        continue;
                    }
                    if (cmp == 0 && re) {
                        r.setStart(0, keys);
                        b = exp.calculate(ctx);
                        if (Variant.isTrue(b)) {
                            for (i = 0; i < count; ++i) {
                                posArray.add(reader.readLong());
                                for (j = 0; j < posCount; ++j) {
                                    posArray.add(reader.readLong());
                                }
                            }
                        } else {
                            for (i = 0; i < count; ++i) {
                                reader.skipObject();
                                for (j = 0; j < posCount; ++j) {
                                    reader.skipObject();
                                }
                            }
                        }
                    } else {
                        for (i = 0; i < count; ++i) {
                            reader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                reader.skipObject();
                            }
                        }
                    }
                    break;
                }
                block32: while (true) lbl-1000:
                // 3 sources

                {
                    block62: {
                        if ((count = reader.readInt()) == -1) {
                            count = reader.readInt();
                        } else if (count == -2) {
                            break;
                        }
                        for (i = 0; i < icount; ++i) {
                            keys[i] = reader.readObject();
                        }
                        cmp = Variant.compareArrays(keys, endVals, sc);
                        if (cmp >= 0 && (cmp != 0 || !re)) break block61;
                        r.setStart(0, keys);
                        b = exp.calculate(ctx);
                        if (!Variant.isTrue(b)) break block62;
                        i = 0;
                        while (true) {
                            if (i >= count) ** GOTO lbl-1000
                            posArray.add(reader.readLong());
                            for (j = 0; j < posCount; ++j) {
                                posArray.add(reader.readLong());
                            }
                            ++i;
                        }
                    }
                    i = 0;
                    while (true) {
                        if (i >= count) continue block32;
                        reader.skipObject();
                        for (j = 0; j < posCount; ++j) {
                            reader.skipObject();
                        }
                        ++i;
                    }
                    break;
                }
            }
            finally {
                stack.pop();
            }
        }
        return posArray;
    }

    private static void _$1(LongArray a, LongArray b) {
        if (b == null) {
            return;
        }
        int size = b.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            a.add(b.get(i));
        }
    }

    @Override
    public synchronized void loadAllBlockInfo() {
        int i;
        if (this.internalAllBlockPos != null) {
            return;
        }
        this.readBlockInfo(this.indexFile);
        int rootCount = this.rootBlockMaxVals.length;
        this.internalAllBlockMaxVals = new Object[rootCount][];
        this.internalAllBlockPos = new long[rootCount][];
        IlllIlIIIlIlllll blockInfo = new IlllIlIIIlIlllll(this, null);
        for (i = 0; i < rootCount; ++i) {
            this._$1(this.indexFile, this.rootBlockPos[i], blockInfo);
            this.internalAllBlockMaxVals[i] = IlllIlIIIlIlllll._$2(blockInfo);
            this.internalAllBlockPos[i] = IlllIlIIIlIlllll._$1(blockInfo);
        }
        if (this.rootBlockPos2 != null) {
            rootCount = this.rootBlockMaxVals2.length;
            this.internalAllBlockMaxVals2 = new Object[rootCount][];
            this.internalAllBlockPos2 = new long[rootCount][];
            for (i = 0; i < rootCount; ++i) {
                this._$1(this.indexFile, this.rootBlockPos2[i], blockInfo);
                this.internalAllBlockMaxVals2[i] = IlllIlIIIlIlllll._$2(blockInfo);
                this.internalAllBlockPos2[i] = IlllIlIIIlIlllll._$1(blockInfo);
            }
        }
    }

    @Override
    public synchronized void loadAllKeys() {
        ObjectReader reader;
        InputStream is;
        int i;
        int i2;
        if (this.internalAllBlockPos != null) {
            return;
        }
        boolean isPrimaryKey = false;
        String[] keyNames = this.srcTable.getAllSortedColNames();
        if (this.srcTable.hasPrimaryKey && keyNames != null && this.ifields.length == keyNames.length) {
            isPrimaryKey = true;
            int len = this.ifields.length;
            for (int i3 = 0; i3 < len; ++i3) {
                if (this.ifields[i3].equals(keyNames[i3])) continue;
                isPrimaryKey = false;
                break;
            }
        }
        this.isPrimaryKey = isPrimaryKey;
        this.readBlockInfo(this.indexFile);
        int rootCount = this.rootBlockMaxVals.length;
        this.internalAllBlockMaxVals = new Object[rootCount][];
        this.internalAllBlockPos = new long[rootCount][];
        IlllIlIIIlIlllll blockInfo = new IlllIlIIIlIlllll(this, null);
        for (i2 = 0; i2 < rootCount; ++i2) {
            this._$1(this.indexFile, this.rootBlockPos[i2], blockInfo);
            this.internalAllBlockMaxVals[i2] = IlllIlIIIlIlllll._$2(blockInfo);
            this.internalAllBlockPos[i2] = IlllIlIIIlIlllll._$1(blockInfo);
        }
        if (this.rootBlockPos2 != null) {
            rootCount = this.rootBlockMaxVals2.length;
            this.internalAllBlockMaxVals2 = new Object[rootCount][];
            this.internalAllBlockPos2 = new long[rootCount][];
            for (i2 = 0; i2 < rootCount; ++i2) {
                this._$1(this.indexFile, this.rootBlockPos2[i2], blockInfo);
                this.internalAllBlockMaxVals2[i2] = IlllIlIIIlIlllll._$2(blockInfo);
                this.internalAllBlockPos2[i2] = IlllIlIIIlIlllll._$1(blockInfo);
            }
        }
        int icount = this.ifields.length;
        int posCount = this.positionCount;
        boolean needRecNum = true;
        if (this.srcTable instanceof RowPhyTable) {
            needRecNum = this.srcTable.getModifyRecords() != null;
        }
        this.cachedBlockReader = new byte[rootCount][][];
        int parallelNum = Env.getParallelNum();
        if (parallelNum > 8) {
            parallelNum = 8;
        }
        if (parallelNum > rootCount) {
            parallelNum = rootCount;
        }
        int avg = rootCount / parallelNum;
        Thread[] threads = new Thread[parallelNum];
        for (i = 0; i < parallelNum; ++i) {
            is = this.indexFile.getInputStream();
            reader = new ObjectReader(is, 1024);
            threads[i] = i + 1 == parallelNum ? PhyTableIndex._$1(needRecNum, this.cachedBlockReader, this.internalAllBlockPos, reader, icount, i * avg, rootCount, posCount) : PhyTableIndex._$1(needRecNum, this.cachedBlockReader, this.internalAllBlockPos, reader, icount, i * avg, (i + 1) * avg, posCount);
            threads[i].start();
        }
        for (i = 0; i < parallelNum; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new RQException(e);
            }
        }
        if (this.rootBlockPos2 != null) {
            this.cachedBlockReader2 = new byte[rootCount][][];
            parallelNum = Env.getParallelNum();
            if (parallelNum > 8) {
                parallelNum = 8;
            }
            rootCount = this.rootBlockMaxVals2.length;
            this.cachedBlockReader2 = new byte[rootCount][][];
            if (parallelNum > rootCount) {
                parallelNum = rootCount;
            }
            avg = rootCount / parallelNum;
            threads = new Thread[parallelNum];
            for (i = 0; i < parallelNum; ++i) {
                is = this.indexFile.getInputStream();
                reader = new ObjectReader(is, 1024);
                threads[i] = i + 1 == parallelNum ? PhyTableIndex._$1(needRecNum, this.cachedBlockReader2, this.internalAllBlockPos2, reader, icount, i * avg, rootCount, posCount) : PhyTableIndex._$1(needRecNum, this.cachedBlockReader2, this.internalAllBlockPos2, reader, icount, i * avg, (i + 1) * avg, posCount);
                threads[i].start();
            }
            for (i = 0; i < parallelNum; ++i) {
                try {
                    threads[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RQException(e);
                }
            }
        }
        try {
            boolean isRow = this.srcTable.parent == null && this.srcTable instanceof RowPhyTable;
            RowBufferWriter writer = new RowBufferWriter(null);
            int maxLen = 0;
            ICursor cs = this.srcTable.cursor();
            Sequence table = cs.fetch(ICursor.FETCHCOUNT);
            while (table != null && table.length() != 0) {
                if (isRow) {
                    IArray mems = table.getMems();
                    int size = mems.size();
                    for (int j = 1; j <= size; ++j) {
                        Record r = (Record)mems.get(j);
                        Object[] vals = r.getFieldValues();
                        int len = 9;
                        writer.reset();
                        for (Object obj : vals) {
                            writer.writeObject(obj);
                        }
                        if ((len += writer.getCount()) <= maxLen) continue;
                        maxLen = len;
                    }
                }
                table = null;
            }
            cs.close();
            this.maxRecordLen = maxLen + maxLen;
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        Runtime rt = Runtime.getRuntime();
        EnvUtil.runGC(rt);
    }

    private static Thread _$1(boolean needRecNum, byte[][][] cachedBlockReader, long[][] internalAllBlockPos, ObjectReader reader, int icount, int start, int end, int posCount) {
        return new lIIIIIlIlIlIIlIl(start, end, internalAllBlockPos, cachedBlockReader, reader, icount, needRecNum, posCount);
    }

    @Override
    public void unloadAllBlockInfo() {
        this.internalAllBlockMaxVals = null;
        this.internalAllBlockPos = null;
        this.internalAllBlockMaxVals2 = null;
        this.internalAllBlockPos2 = null;
        Runtime rt = Runtime.getRuntime();
        EnvUtil.runGC(rt);
    }

    private int _$2(Sequence vals, int srcIndex, Object[] blockMaxVals, byte[][] blockBuffers, LongArray outPos) throws IOException {
        IArray mems = vals.getMems();
        Object srcVal = mems.get(srcIndex);
        int block = PhyTableIndex._$1(blockMaxVals, srcVal);
        if (block < 0) {
            return srcIndex;
        }
        int blockCount = blockBuffers.length;
        BufferReader bufferReader = new BufferReader(null, blockBuffers[block]);
        int srcLen = mems.size();
        LongArray posArray = outPos;
        long firstPos = -1L;
        block0: while (true) {
            block17: {
                int count;
                if ((count = bufferReader.readInt()) == -1) {
                    while (++block < blockCount) {
                        if (Variant.compare(blockMaxVals[block], srcVal, true) < 0) continue;
                        bufferReader = new BufferReader(null, blockBuffers[block]);
                        firstPos = -1L;
                        count = bufferReader.readInt();
                        break block17;
                    }
                    break;
                }
                if (count == -2) break;
            }
            Object cur = bufferReader.readObject();
            int cmp = Variant.compare(cur, srcVal, true);
            if (cmp < 0) {
                bufferReader.skipObject();
                if (firstPos == -1L) {
                    firstPos = bufferReader.readLong();
                    continue;
                }
                bufferReader.skipObject();
                continue;
            }
            if (cmp == 0) {
                posArray.add(bufferReader.readLong());
                if (firstPos == -1L) {
                    firstPos = bufferReader.readLong();
                    posArray.add(firstPos);
                } else {
                    posArray.add(bufferReader.readLong() + firstPos);
                }
                if (++srcIndex > srcLen) break;
                srcVal = mems.get(srcIndex);
                if (Variant.compare(blockMaxVals[block], srcVal, true) >= 0) continue;
                while (++block < blockCount) {
                    if (Variant.compare(blockMaxVals[block], srcVal, true) < 0) continue;
                    bufferReader = new BufferReader(null, blockBuffers[block]);
                    firstPos = -1L;
                    continue block0;
                }
            } else {
                while (++srcIndex <= srcLen) {
                    srcVal = mems.get(srcIndex);
                    cmp = Variant.compare(cur, srcVal, true);
                    if (cmp < 0) {
                        bufferReader.skipObject();
                        if (firstPos == -1L) {
                            firstPos = bufferReader.readLong();
                            continue block0;
                        }
                        bufferReader.skipObject();
                        continue block0;
                    }
                    if (cmp != 0) continue;
                    posArray.add(bufferReader.readLong());
                    if (firstPos == -1L) {
                        firstPos = bufferReader.readLong();
                        posArray.add(firstPos);
                    } else {
                        posArray.add(bufferReader.readLong() + firstPos);
                    }
                    if (++srcIndex > srcLen) break block0;
                    srcVal = mems.get(srcIndex);
                    continue block0;
                }
            }
            break;
        }
        if (srcIndex > srcLen) {
            return -1;
        }
        return srcIndex;
    }

    private int _$1(Sequence vals, int srcIndex, Object[] blockMaxVals, byte[][] blockBuffers, LongArray outPos) throws IOException {
        if (this.positionCount == 1 && this.isPrimaryKey) {
            return this._$2(vals, srcIndex, blockMaxVals, blockBuffers, outPos);
        }
        IArray mems = vals.getMems();
        Object srcVal = mems.get(srcIndex);
        int block = PhyTableIndex._$1(blockMaxVals, srcVal);
        if (block < 0) {
            return srcIndex;
        }
        int posCount = this.positionCount;
        int blockCount = blockBuffers.length;
        BufferReader bufferReader = new BufferReader(null, blockBuffers[block]);
        int srcLen = mems.size();
        LongArray posArray = outPos;
        long firstPos = -1L;
        block0: while (true) {
            long pos;
            int j;
            int i;
            int count;
            block26: {
                if ((count = bufferReader.readInt()) == -1) {
                    while (++block < blockCount) {
                        if (Variant.compare(blockMaxVals[block], srcVal, true) < 0) continue;
                        bufferReader = new BufferReader(null, blockBuffers[block]);
                        firstPos = -1L;
                        count = bufferReader.readInt();
                        break block26;
                    }
                    break;
                }
                if (count == -2) break;
            }
            Object cur = bufferReader.readObject();
            int cmp = Variant.compare(cur, srcVal, true);
            if (cmp < 0) {
                i = 0;
                while (true) {
                    if (i >= count) continue block0;
                    bufferReader.skipObject();
                    for (j = 0; j < posCount; ++j) {
                        if (firstPos == -1L) {
                            firstPos = bufferReader.readLong();
                            continue;
                        }
                        bufferReader.skipObject();
                    }
                    ++i;
                }
            }
            if (cmp == 0) {
                for (i = 0; i < count; ++i) {
                    posArray.add(bufferReader.readLong());
                    for (j = 0; j < posCount; ++j) {
                        pos = bufferReader.readLong();
                        if (firstPos == -1L) {
                            firstPos = pos;
                        } else {
                            pos += firstPos;
                        }
                        posArray.add(pos);
                    }
                }
                if (++srcIndex > srcLen) break;
                srcVal = mems.get(srcIndex);
                if (Variant.compare(blockMaxVals[block], srcVal, true) >= 0) continue;
                while (++block < blockCount) {
                    if (Variant.compare(blockMaxVals[block], srcVal, true) < 0) continue;
                    bufferReader = new BufferReader(null, blockBuffers[block]);
                    firstPos = -1L;
                    continue block0;
                }
            } else {
                while (++srcIndex <= srcLen) {
                    srcVal = mems.get(srcIndex);
                    cmp = Variant.compare(cur, srcVal, true);
                    if (cmp < 0) {
                        i = 0;
                        while (true) {
                            if (i >= count) continue block0;
                            bufferReader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                if (firstPos == -1L) {
                                    firstPos = bufferReader.readLong();
                                    continue;
                                }
                                bufferReader.skipObject();
                            }
                            ++i;
                        }
                    }
                    if (cmp != 0) continue;
                    for (i = 0; i < count; ++i) {
                        posArray.add(bufferReader.readLong());
                        for (j = 0; j < posCount; ++j) {
                            pos = bufferReader.readLong();
                            if (firstPos == -1L) {
                                firstPos = pos;
                            } else {
                                pos += firstPos;
                            }
                            posArray.add(pos);
                        }
                    }
                    if (++srcIndex > srcLen) break block0;
                    srcVal = mems.get(srcIndex);
                    continue block0;
                }
            }
            break;
        }
        if (srcIndex > srcLen) {
            return -1;
        }
        return srcIndex;
    }

    /*
     * Unable to fully structure code
     */
    private int _$1(Sequence vals, int srcIndex, Object[][] blockMaxVals, byte[][] blockBuffers, LongArray outPos) throws IOException {
        block26: {
            mems = vals.getMems();
            srcVal = mems.get(srcIndex);
            isSequence = false;
            srcKeyCount = 1;
            if (srcVal instanceof Sequence) {
                isSequence = true;
                srcKeys = ((Sequence)srcVal).toArray();
                srcKeyCount = srcKeys.length;
            } else {
                srcKeys = new Object[]{srcVal};
            }
            block = PhyTableIndex._$1(blockMaxVals, srcKeys, true);
            if (block < 0) {
                return srcIndex;
            }
            posCount = this.positionCount;
            blockCount = blockBuffers.length;
            bufferReader = new BufferReader(null, blockBuffers[block]);
            icount = this.ifields.length;
            keys = new Object[icount];
            srcLen = mems.size();
            posArray = new LongArray(srcLen);
            firstPos = -1L;
            block0: while (true) lbl-1000:
            // 5 sources

            {
                block28: {
                    block27: {
                        block25: {
                            if ((count = bufferReader.readInt()) == -1) {
                                while (++block < blockCount) {
                                    if (Variant.compareArrays(blockMaxVals[block], srcKeys, srcKeyCount) < 0) continue;
                                    bufferReader = new BufferReader(null, blockBuffers[block]);
                                    firstPos = -1L;
                                    count = bufferReader.readInt();
                                    break block25;
                                }
                                break block26;
                            }
                            if (count == -2) break block26;
                        }
                        for (i = 0; i < icount; ++i) {
                            keys[i] = bufferReader.readObject();
                        }
                        cmp = Variant.compareArrays(keys, srcKeys, srcKeyCount);
                        if (cmp >= 0) break block27;
                        i = 0;
                        while (true) {
                            if (i >= count) ** GOTO lbl-1000
                            bufferReader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                if (firstPos == -1L) {
                                    firstPos = bufferReader.readLong();
                                    continue;
                                }
                                bufferReader.skipObject();
                            }
                            ++i;
                        }
                    }
                    if (cmp != 0) break block28;
                    i = 0;
                    while (true) {
                        if (i >= count) ** GOTO lbl-1000
                        posArray.add(bufferReader.readLong());
                        for (j = 0; j < posCount; ++j) {
                            pos = bufferReader.readLong();
                            if (firstPos == -1L) {
                                firstPos = pos;
                            } else {
                                pos += firstPos;
                            }
                            posArray.add(pos);
                        }
                        ++i;
                    }
                }
                while (++srcIndex <= srcLen) {
                    block29: {
                        srcVal = mems.get(srcIndex);
                        if (isSequence) {
                            ((Sequence)srcVal).toArray(srcKeys);
                        } else {
                            srcKeys[0] = srcVal;
                        }
                        cmp = Variant.compareArrays(keys, srcKeys, srcKeyCount);
                        if (cmp >= 0) break block29;
                        i = 0;
                        while (true) {
                            if (i >= count) ** GOTO lbl-1000
                            bufferReader.skipObject();
                            for (j = 0; j < posCount; ++j) {
                                if (firstPos == -1L) {
                                    firstPos = bufferReader.readLong();
                                    continue;
                                }
                                bufferReader.skipObject();
                            }
                            ++i;
                        }
                    }
                    if (cmp != 0) continue;
                    i = 0;
lbl91:
                    // 2 sources

                    while (true) {
                        if (i >= count) continue block0;
                        break;
                    }
                }
                break block26;
                break;
            }
            posArray.add(bufferReader.readLong());
            for (j = 0; j < posCount; ++j) {
                pos = bufferReader.readLong();
                if (firstPos == -1L) {
                    firstPos = pos;
                } else {
                    pos += firstPos;
                }
                posArray.add(pos);
            }
            ++i;
            ** while (true)
        }
        outPos = posArray;
        if (srcIndex > srcLen) {
            return -1;
        }
        return srcIndex;
    }

    private void _$1(boolean isSec, int i, IlllIlIIIlIlllll blockInfo) {
        if (!isSec) {
            IlllIlIIIlIlllll._$1(blockInfo, this.internalAllBlockMaxVals[i]);
            IlllIlIIIlIlllll._$1(blockInfo, this.internalAllBlockPos[i]);
        } else {
            IlllIlIIIlIlllll._$1(blockInfo, this.internalAllBlockMaxVals2[i]);
            IlllIlIIIlIlllll._$1(blockInfo, this.internalAllBlockPos2[i]);
        }
    }

    public LongArray select(String[] key, Expression exp, String opt, Context ctx) {
        int[] start = new int[2];
        long[] startPos = new long[2];
        LongArray srcPos = null;
        LongArray srcPos2 = null;
        startPos[0] = this.indexPos + 5L;
        startPos[1] = this.indexPos2 + 5L;
        start[1] = 0;
        start[0] = 0;
        this._$1(key, 1, true, startPos, start);
        if (start[0] < 0 && start[1] < 0) {
            return new LongArray();
        }
        InputStream is = this.indexFile.getInputStream();
        ObjectReader reader = new ObjectReader(is, 1024);
        try {
            if (start[0] >= 0) {
                srcPos = this._$1(reader, (Object)key[0], -1, 5, exp, ctx, startPos[0], -1L);
            }
            if (this.rootItPos2 != 0L && start[1] >= 0) {
                srcPos2 = this._$1(reader, (Object)key[0], -1, 5, exp, ctx, startPos[1], -1L);
            }
            if (srcPos == null) {
                srcPos = new LongArray();
            }
            PhyTableIndex._$1(srcPos, srcPos2);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
        return srcPos;
    }

    @Override
    public int getMaxRecordLen() {
        return this.maxRecordLen;
    }

    @Override
    public boolean hasSecIndex() {
        return this.rootBlockPos2 != null;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public void dup(PhyTable table) {
        String dir = table.getGroupTable().getFile().getAbsolutePath() + "_";
        FileObject indexFile = new FileObject(dir + table.getTableName() + "_" + this.name);
        RandomOutputStream os = indexFile.getRandomOutputStream(true);
        RandomObjectWriter writer = new RandomObjectWriter(os);
        try {
            this.writeHeader(writer);
            writer.close();
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getIndexStruct() {
        InputStream is = this.indexFile.getInputStream();
        ObjectReader reader = new ObjectReader(is, 1024);
        try {
            this.readHeader(reader);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
        Record rec = new Record(new DataStruct(INDEX_FIELD_NAMES));
        rec.setNormalFieldValue(0, this.name);
        rec.setNormalFieldValue(1, 0);
        rec.setNormalFieldValue(2, new Sequence(this.ifields));
        rec.setNormalFieldValue(3, null);
        rec.setNormalFieldValue(4, this.filter == null ? null : this.filter.toString());
        return rec;
    }

    public static boolean isCompatible(String[] fieldNames, String[] ifields) {
        if (fieldNames == null || ifields == null) {
            return false;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String str : ifields) {
            list.add(str);
        }
        for (String str : fieldNames) {
            if (list.contains(str)) continue;
            return false;
        }
        return true;
    }

    public static String[][] readIndexFields(FileObject indexFile) {
        String[][] names = new String[2][];
        ObjectReader reader = null;
        try {
            InputStream is = indexFile.getInputStream();
            reader = new ObjectReader(is, 1024);
            if (reader.read() != 114 || reader.read() != 113 || reader.read() != 100 || reader.read() != 119 || reader.read() != 105 || reader.read() != 100) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            int flag = reader.read();
            reader.readFully(new byte[32]);
            reader.readLong64();
            reader.readLong64();
            reader.readLong64();
            if (flag != 104) {
                reader.readLong64();
                reader.readLong64();
                reader.readLong64();
                reader.readLong64();
            }
            names[0] = reader.readStrings();
            if (flag == 118) {
                names[1] = reader.readStrings();
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return names;
    }

    public static Object getIndexStruct(FileObject indexFile) {
        Object[] ifields = null;
        Object[] vfields = null;
        String filter = null;
        Record rec = new Record(new DataStruct(INDEX_FIELD_NAMES2));
        ObjectReader reader = null;
        try {
            InputStream is = indexFile.getInputStream();
            reader = new ObjectReader(is, 1024);
            if (reader.read() != 114 || reader.read() != 113 || reader.read() != 100 || reader.read() != 119 || reader.read() != 105 || reader.read() != 100) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            int flag = reader.read();
            reader.readFully(new byte[32]);
            reader.readLong64();
            reader.readLong64();
            reader.readLong64();
            if (flag != 104) {
                reader.readLong64();
                reader.readLong64();
                reader.readLong64();
                reader.readLong64();
            }
            ifields = reader.readStrings();
            if (flag == 120) {
                rec.setNormalFieldValue(0, 0);
            } else if (flag == 118) {
                rec.setNormalFieldValue(0, 0);
                vfields = reader.readStrings();
            } else if (flag == 119) {
                rec.setNormalFieldValue(0, null);
            } else if (flag == 104) {
                int h = reader.readInt32();
                reader.readInt32();
                reader.readInt32();
                rec.setNormalFieldValue(0, h);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            if (reader.read() != 0) {
                filter = reader.readUTF();
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        rec.setNormalFieldValue(1, new Sequence(ifields));
        rec.setNormalFieldValue(2, new Sequence(vfields));
        rec.setNormalFieldValue(3, filter);
        return rec;
    }

    protected class RTableCursor
    extends ICursor {
        public static final String POS_FIELDNAME = "rq_file_pos_";
        public static final String SEQ_FIELDNAME = "rq_file_seq_";
        private long _$22;
        private RowPhyTable _$21;
        private String[] _$20;
        private Expression _$19;
        DataStruct _$18;
        private BlockLinkReader _$17;
        private ObjectReader _$16;
        private ObjectReader _$15;
        private int _$14;
        private int _$13 = 0;
        private Sequence _$12;
        private boolean _$11 = false;
        private boolean _$10;
        private RTableCursor _$9;
        private Record _$8;
        private long _$7;
        private DataStruct _$6;
        private int[] _$5;
        private boolean[] _$4;

        public RTableCursor(PhyTable table, String[] fields, Context ctx, Expression filter) {
            this._$21 = (RowPhyTable)table;
            this._$20 = fields;
            this.ctx = ctx;
            this._$19 = filter;
            this._$1();
        }

        private void _$1(Node node) {
            if (node == null) {
                return;
            }
            if (node instanceof UnknownSymbol) {
                String f = ((UnknownSymbol)node).getName();
                int id = this._$6.getFieldIndex(f);
                if (id >= 0) {
                    this._$4[id] = true;
                }
                return;
            }
            this._$1(node.getLeft());
            this._$1(node.getRight());
        }

        private void _$1() {
            String[] fields;
            this._$14 = this._$21.getDataBlockCount();
            if (this._$20 == null) {
                this._$20 = this._$21.getColNames();
            }
            this._$17 = this._$21.getRowReader(true);
            this._$15 = new ObjectReader(this._$17, this._$21.groupTable.getBlockSize() - 5);
            this._$16 = this._$21.getSegmentObjectReader();
            this._$22 = this._$21.groupTable.getBlockSize() - 5;
            this._$10 = this._$21.parent == null;
            int len = this._$20.length;
            if (this._$10) {
                fields = Arrays.copyOf(this._$20, len += 2);
                fields[len - 2] = SEQ_FIELDNAME;
                fields[len - 1] = POS_FIELDNAME;
            } else {
                fields = Arrays.copyOf(this._$20, len += 3);
                fields[len - 3] = SEQ_FIELDNAME;
                fields[len - 2] = "rq_file_pos_0";
                fields[len - 1] = "rq_file_pos_1";
            }
            this._$18 = new DataStruct(fields);
            if (!this._$10) {
                String[] field = Arrays.copyOf(this._$21.parent.getSortedColNames(), 1);
                this._$9 = new RTableCursor(this._$21.parent, field, this.ctx, null);
                Sequence pkeyData = this._$9.fetch(1);
                this._$8 = (Record)pkeyData.get(1);
                this._$7 = (Long)this._$8.getNormalFieldValue(1);
            }
            int colCount = this._$20.length;
            String[] fullFields = this._$21.getAllColNames();
            this._$5 = new int[colCount];
            this._$4 = new boolean[fullFields.length];
            this._$6 = new DataStruct(fullFields);
            for (int i = 0; i < colCount; ++i) {
                int id;
                this._$5[i] = id = this._$6.getFieldIndex(fields[i]);
                if (id < 0) continue;
                this._$4[id] = true;
            }
            if (this._$19 != null) {
                this._$1(this._$19.getHome());
            }
        }

        private long _$1(long pseq) {
            while (pseq != this._$7) {
                Sequence pkeyData = this._$9.fetch(1);
                if (pkeyData == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("index " + mm.getMessage("grouptable.invalidData"));
                }
                this._$8 = (Record)pkeyData.get(1);
                this._$7 = (Long)this._$8.getNormalFieldValue(1);
            }
            return (Long)this._$8.getNormalFieldValue(2);
        }

        private long _$1(BlockLinkReader rowReader, ObjectReader rowDataReader) throws IOException {
            rowDataReader.hasNext();
            return rowReader.position() + rowDataReader.position() % this._$22;
        }

        protected Sequence get(int n) {
            if (this._$11 || n < 1) {
                return null;
            }
            Sequence cache = this._$12;
            if (cache != null) {
                int len = cache.length();
                if (len > n) {
                    this._$12 = cache.split(n + 1);
                    return cache;
                }
                if (len == n) {
                    this._$12 = null;
                    return cache;
                }
            } else {
                cache = new Table(this._$18, n);
            }
            int curBlock = this._$13;
            int dataBlockCount = this._$14;
            BlockLinkReader rowReader = this._$17;
            ObjectReader segmentReader = this._$16;
            int colCount = this._$20.length;
            String[] fullFields = this._$21.getAllColNames();
            int allCount = fullFields.length;
            int keyCount = this._$21.getAllSortedColNamesLength();
            DataStruct ds = this._$18;
            IArray mems = cache.getMems();
            this._$12 = null;
            ComputeStack stack = null;
            Expression filter = this._$19;
            DataStruct fullDs = this._$6;
            int[] fieldsIndex = this._$5;
            boolean[] needRead = this._$4;
            Object[] values = new Object[allCount];
            ObjectReader rowDataReader = this._$15;
            long pseq = 0L;
            boolean isPrimaryTable = this._$10;
            int startIndex = isPrimaryTable ? 0 : this._$21.parent.getSortedColNames().length;
            if (filter != null) {
                stack = this.ctx.getComputeStack();
            }
            try {
                while (curBlock < dataBlockCount) {
                    Record r;
                    int f;
                    long seq;
                    long pos;
                    int i;
                    int recordCount;
                    ++curBlock;
                    rowDataReader.readInt32();
                    if (filter != null) {
                        recordCount = segmentReader.readInt32();
                        segmentReader.readLong40();
                        for (i = 0; i < keyCount; ++i) {
                            segmentReader.skipObject();
                            segmentReader.skipObject();
                        }
                        if (recordCount == 0) {
                            rowDataReader.skipObject();
                            continue;
                        }
                        for (i = 0; i < recordCount; ++i) {
                            Record r2 = new Record(ds);
                            Record cmpr = new Record(fullDs);
                            pos = this._$1(rowReader, rowDataReader);
                            seq = rowDataReader.readLong();
                            if (!isPrimaryTable) {
                                pseq = rowDataReader.readLong();
                            }
                            for (int f2 = startIndex; f2 < allCount; ++f2) {
                                if (needRead[f2]) {
                                    cmpr.setNormalFieldValue(f2, rowDataReader.readObject());
                                    continue;
                                }
                                rowDataReader.skipObject();
                            }
                            stack.push(cmpr);
                            Object b = filter.calculate(this.ctx);
                            if (Variant.isTrue(b)) {
                                for (f = 0; f < colCount; ++f) {
                                    r2.setNormalFieldValue(f, cmpr.getFieldValue(fieldsIndex[f]));
                                }
                                r2.setNormalFieldValue(colCount, seq);
                                if (!isPrimaryTable) {
                                    r2.setNormalFieldValue(colCount + 2, pos);
                                    r2.setNormalFieldValue(colCount + 1, this._$1(pseq));
                                } else {
                                    r2.setNormalFieldValue(colCount + 1, pos);
                                }
                                mems.add(r2);
                            }
                            stack.pop();
                            if (mems.size() != n) continue;
                            ++i;
                            break;
                        }
                        if (mems.size() != n) continue;
                        Table tmp = new Table(ds, ICursor.FETCHCOUNT);
                        this._$12 = tmp;
                        mems = tmp.getMems();
                        while (i < recordCount) {
                            r = new Record(ds);
                            Record cmpr = new Record(fullDs);
                            pos = this._$1(rowReader, rowDataReader);
                            seq = rowDataReader.readLong();
                            if (!isPrimaryTable) {
                                pseq = rowDataReader.readLong();
                            }
                            for (int f3 = startIndex; f3 < allCount; ++f3) {
                                if (needRead[f3]) {
                                    cmpr.setNormalFieldValue(f3, rowDataReader.readObject());
                                    continue;
                                }
                                rowDataReader.skipObject();
                            }
                            stack.push(cmpr);
                            Object b = filter.calculate(this.ctx);
                            if (Variant.isTrue(b)) {
                                for (int f4 = 0; f4 < colCount; ++f4) {
                                    r.setNormalFieldValue(f4, cmpr.getFieldValue(fieldsIndex[f4]));
                                }
                                r.setNormalFieldValue(colCount, seq);
                                if (!isPrimaryTable) {
                                    r.setNormalFieldValue(colCount + 2, pos);
                                    r.setNormalFieldValue(colCount + 1, this._$1(pseq));
                                } else {
                                    r.setNormalFieldValue(colCount + 1, pos);
                                }
                                mems.add(r);
                            }
                            stack.pop();
                            if (mems.size() == n) {
                                ++i;
                                break;
                            }
                            ++i;
                        }
                        if (mems.size() == 0) {
                            this._$12 = null;
                        }
                    } else {
                        recordCount = segmentReader.readInt32();
                        segmentReader.readLong40();
                        for (i = 0; i < keyCount; ++i) {
                            segmentReader.skipObject();
                            segmentReader.skipObject();
                        }
                        if (recordCount == 0) {
                            rowDataReader.skipObject();
                            continue;
                        }
                        int diff = n - cache.length();
                        if (recordCount > diff) {
                            int i2;
                            for (i2 = 0; i2 < diff; ++i2) {
                                int f5;
                                r = new Record(ds);
                                pos = this._$1(rowReader, rowDataReader);
                                seq = rowDataReader.readLong();
                                if (!isPrimaryTable) {
                                    pseq = rowDataReader.readLong();
                                }
                                for (f5 = startIndex; f5 < allCount; ++f5) {
                                    if (needRead[f5]) {
                                        values[f5] = rowDataReader.readObject();
                                        continue;
                                    }
                                    rowDataReader.skipObject();
                                }
                                for (f5 = 0; f5 < colCount; ++f5) {
                                    r.setNormalFieldValue(f5, values[fieldsIndex[f5]]);
                                }
                                r.setNormalFieldValue(colCount, seq);
                                if (!isPrimaryTable) {
                                    r.setNormalFieldValue(colCount + 2, pos);
                                    r.setNormalFieldValue(colCount + 1, this._$1(pseq));
                                } else {
                                    r.setNormalFieldValue(colCount + 1, pos);
                                }
                                mems.add(r);
                            }
                            Table tmp = new Table(ds, ICursor.FETCHCOUNT);
                            this._$12 = tmp;
                            mems = tmp.getMems();
                            while (i2 < recordCount) {
                                Record r3 = new Record(ds);
                                pos = this._$1(rowReader, rowDataReader);
                                seq = rowDataReader.readLong();
                                if (!isPrimaryTable) {
                                    pseq = rowDataReader.readLong();
                                }
                                for (f = startIndex; f < allCount; ++f) {
                                    if (needRead[f]) {
                                        values[f] = rowDataReader.readObject();
                                        continue;
                                    }
                                    rowDataReader.skipObject();
                                }
                                for (f = 0; f < colCount; ++f) {
                                    r3.setNormalFieldValue(f, values[fieldsIndex[f]]);
                                }
                                r3.setNormalFieldValue(colCount, seq);
                                if (!isPrimaryTable) {
                                    r3.setNormalFieldValue(colCount + 2, pos);
                                    r3.setNormalFieldValue(colCount + 1, this._$1(pseq));
                                } else {
                                    r3.setNormalFieldValue(colCount + 1, pos);
                                }
                                mems.add(r3);
                                ++i2;
                            }
                        } else {
                            for (int i3 = 0; i3 < recordCount; ++i3) {
                                int f6;
                                r = new Record(ds);
                                pos = this._$1(rowReader, rowDataReader);
                                seq = rowDataReader.readLong();
                                if (!isPrimaryTable) {
                                    pseq = rowDataReader.readLong();
                                }
                                for (f6 = startIndex; f6 < allCount; ++f6) {
                                    if (needRead[f6]) {
                                        values[f6] = rowDataReader.readObject();
                                        continue;
                                    }
                                    rowDataReader.skipObject();
                                }
                                for (f6 = 0; f6 < colCount; ++f6) {
                                    r.setNormalFieldValue(f6, values[fieldsIndex[f6]]);
                                }
                                r.setNormalFieldValue(colCount, seq);
                                if (!isPrimaryTable) {
                                    r.setNormalFieldValue(colCount + 2, pos);
                                    r.setNormalFieldValue(colCount + 1, this._$1(pseq));
                                } else {
                                    r.setNormalFieldValue(colCount + 1, pos);
                                }
                                mems.add(r);
                            }
                            if (diff != recordCount) continue;
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            this._$13 = curBlock;
            if (cache.length() > 0) {
                return cache;
            }
            return null;
        }

        protected long skipOver(long n) {
            if (this._$11 || n < 1L) {
                return 0L;
            }
            boolean isPrimaryTable = this._$10;
            int curBlock = this._$13;
            int dataBlockCount = this._$14;
            ObjectReader segmentReader = this._$16;
            int allCount = this._$21.getColNames().length;
            int keyCount = this._$21.getAllSortedColNamesLength();
            int skipCount = 0;
            ObjectReader rowDataReader = this._$15;
            try {
                while (curBlock < dataBlockCount) {
                    int i;
                    ++curBlock;
                    rowDataReader.readInt32();
                    int recordCount = segmentReader.readInt32();
                    segmentReader.readLong40();
                    for (i = 0; i < keyCount; ++i) {
                        segmentReader.skipObject();
                        segmentReader.skipObject();
                    }
                    if (recordCount == 0) {
                        rowDataReader.skipObject();
                        continue;
                    }
                    for (i = 0; i < recordCount; ++i) {
                        rowDataReader.readLong();
                        if (!isPrimaryTable) {
                            rowDataReader.readLong();
                        }
                        for (int f = 0; f < allCount; ++f) {
                            rowDataReader.readObject();
                        }
                    }
                    if (n != (long)(skipCount += recordCount)) continue;
                    break;
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            this._$13 = curBlock;
            return skipCount;
        }

        public long seek(long n) {
            return this.skipOver(n);
        }

        public void close() {
            super.close();
            this._$11 = true;
            this._$12 = null;
            try {
                this._$16.close();
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
            finally {
                this._$17 = null;
            }
        }

        public boolean reset() {
            this.close();
            this._$11 = false;
            this._$13 = 0;
            return true;
        }
    }

    protected class CTableCursor
    extends ICursor {
        public static final String POS_FIELDNAME = "rq_file_pos_";
        private ColPhyTable _$16;
        private String[] _$15;
        private Expression _$14;
        DataStruct _$13;
        private BlockLinkReader _$12;
        private BlockLinkReader[] _$11;
        private ObjectReader[] _$10;
        private ColumnMetaData[] _$9;
        private int _$8;
        private int _$7 = 0;
        private Sequence _$6;
        private boolean _$5 = false;
        private long _$4 = 0L;

        public CTableCursor(PhyTable table, String[] fields, Context ctx, Expression filter) {
            this._$16 = (ColPhyTable)table;
            this._$15 = fields;
            this.ctx = ctx;
            this._$14 = filter;
            this._$1();
        }

        private void _$1() {
            int i;
            this._$8 = this._$16.getDataBlockCount();
            if (this._$15 == null) {
                this._$15 = this._$16.getColNames();
            }
            this._$9 = this._$14 != null ? this._$16.getColumns() : this._$16.getColumns(this._$15);
            String[] fields = Arrays.copyOf(this._$15, this._$15.length + 1);
            fields[this._$15.length] = POS_FIELDNAME;
            this._$13 = new DataStruct(fields);
            int colCount = this._$9.length;
            this._$12 = this._$16.getSegmentReader();
            this._$11 = new BlockLinkReader[colCount];
            for (i = 0; i < colCount; ++i) {
                this._$11[i] = this._$9[i].getColReader(true);
            }
            this._$10 = new ObjectReader[colCount];
            for (i = 0; i < colCount; ++i) {
                this._$10[i] = this._$9[i].getSegmentReader();
            }
        }

        protected Sequence get(int n) {
            int i;
            if (this._$5 || n < 1) {
                return null;
            }
            Sequence cache = this._$6;
            if (cache != null) {
                int len = cache.length();
                if (len > n) {
                    this._$6 = cache.split(n + 1);
                    return cache;
                }
                if (len == n) {
                    this._$6 = null;
                    return cache;
                }
            } else {
                cache = new Table(this._$13, n);
            }
            int curBlock = this._$7;
            int dataBlockCount = this._$8;
            BlockLinkReader rowCountReader = this._$12;
            BlockLinkReader[] colReaders = this._$11;
            int colCount = colReaders.length;
            BufferReader[] bufReaders = new BufferReader[colCount];
            DataStruct ds = this._$13;
            IArray mems = cache.getMems();
            this._$6 = null;
            ComputeStack stack = null;
            Expression filter = this._$14;
            DataStruct fullDs = null;
            String[] fields = this._$15;
            int fieldsLen = fields.length;
            int[] fieldsIndex = new int[fieldsLen];
            if (filter != null) {
                stack = this.ctx.getComputeStack();
                String[] fullFields = this._$16.getColNames();
                fullDs = new DataStruct(fullFields);
                for (i = 0; i < fieldsLen; ++i) {
                    fieldsIndex[i] = fullDs.getFieldIndex(fields[i]);
                }
            }
            try {
                while (curBlock < dataBlockCount) {
                    Record r;
                    int f;
                    int f2;
                    ++curBlock;
                    if (filter != null) {
                        int recordCount = rowCountReader.readInt32();
                        for (f2 = 0; f2 < colCount; ++f2) {
                            bufReaders[f2] = colReaders[f2].readBlockData(recordCount);
                        }
                        for (i = 0; i < recordCount; ++i) {
                            Record r2 = new Record(ds);
                            Record cmpr = new Record(fullDs);
                            ++this._$4;
                            for (int f3 = 0; f3 < colCount; ++f3) {
                                cmpr.setNormalFieldValue(f3, bufReaders[f3].readObject());
                            }
                            stack.push(cmpr);
                            Object b = filter.calculate(this.ctx);
                            if (Variant.isTrue(b)) {
                                for (f = 0; f < fieldsLen; ++f) {
                                    r2.setNormalFieldValue(f, cmpr.getFieldValue(fieldsIndex[f]));
                                }
                                r2.setNormalFieldValue(fieldsLen, new Long(this._$4));
                                mems.add(r2);
                            }
                            stack.pop();
                            if (mems.size() != n) continue;
                            ++i;
                            break;
                        }
                        if (mems.size() != n) continue;
                        Table tmp = new Table(ds, ICursor.FETCHCOUNT);
                        this._$6 = tmp;
                        mems = tmp.getMems();
                        while (i < recordCount) {
                            r = new Record(ds);
                            Record cmpr = new Record(fullDs);
                            ++this._$4;
                            for (int f4 = 0; f4 < colCount; ++f4) {
                                cmpr.setNormalFieldValue(f4, bufReaders[f4].readObject());
                            }
                            stack.push(cmpr);
                            Object b = filter.calculate(this.ctx);
                            if (Variant.isTrue(b)) {
                                for (int f5 = 0; f5 < fieldsLen; ++f5) {
                                    r.setNormalFieldValue(f5, cmpr.getFieldValue(fieldsIndex[f5]));
                                }
                                r.setNormalFieldValue(fieldsLen, new Long(this._$4));
                                mems.add(r);
                            }
                            stack.pop();
                            if (mems.size() == n) {
                                ++i;
                                break;
                            }
                            ++i;
                        }
                        if (mems.size() == 0) {
                            this._$6 = null;
                        }
                    } else {
                        int recordCount = rowCountReader.readInt32();
                        for (f2 = 0; f2 < colCount; ++f2) {
                            bufReaders[f2] = colReaders[f2].readBlockData(recordCount);
                        }
                        int diff = n - cache.length();
                        if (recordCount > diff) {
                            int i2;
                            for (i2 = 0; i2 < diff; ++i2) {
                                r = new Record(ds);
                                for (int f6 = 0; f6 < colCount; ++f6) {
                                    r.setNormalFieldValue(f6, bufReaders[f6].readObject());
                                }
                                r.setNormalFieldValue(colCount, new Long(++this._$4));
                                mems.add(r);
                            }
                            Table tmp = new Table(ds, ICursor.FETCHCOUNT);
                            this._$6 = tmp;
                            mems = tmp.getMems();
                            while (i2 < recordCount) {
                                Record r3 = new Record(ds);
                                for (f = 0; f < colCount; ++f) {
                                    r3.setNormalFieldValue(f, bufReaders[f].readObject());
                                }
                                r3.setNormalFieldValue(colCount, new Long(++this._$4));
                                mems.add(r3);
                                ++i2;
                            }
                        } else {
                            for (int i3 = 0; i3 < recordCount; ++i3) {
                                r = new Record(ds);
                                for (int f7 = 0; f7 < colCount; ++f7) {
                                    r.setNormalFieldValue(f7, bufReaders[f7].readObject());
                                }
                                r.setNormalFieldValue(colCount, new Long(++this._$4));
                                mems.add(r);
                            }
                            if (diff != recordCount) continue;
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            this._$7 = curBlock;
            if (cache.length() > 0) {
                return cache;
            }
            return null;
        }

        protected long skipOver(long n) {
            return 0L;
        }

        public long seek(long n) {
            if (this._$5 || n < 1L) {
                return 0L;
            }
            int curBlock = this._$7;
            int dataBlockCount = this._$8;
            long skipCount = 0L;
            if (this._$6 != null) {
                skipCount = this._$6.length();
                if (skipCount > n) {
                    this._$6 = this._$6.split((int)n + 1);
                    return n;
                }
                if (skipCount == n) {
                    this._$6 = null;
                    return n;
                }
                this._$6 = null;
            }
            BlockLinkReader rowCountReader = this._$12;
            BlockLinkReader[] colReaders = this._$11;
            int colCount = colReaders.length;
            try {
                long pos;
                for (int i = 0; i < colCount; ++i) {
                    pos = this._$10[i].readLong40();
                    if (this._$9[i].hasMaxMinValues()) {
                        this._$10[i].skipObject();
                        this._$10[i].skipObject();
                        this._$10[i].skipObject();
                    }
                    colReaders[i].seek(pos);
                }
                while (curBlock < dataBlockCount) {
                    long diff;
                    ++curBlock;
                    int recordCount = rowCountReader.readInt32();
                    if ((long)recordCount > (diff = n - skipCount)) {
                        diff /= 0L;
                        continue;
                    }
                    for (int i = 0; i < colCount; ++i) {
                        pos = this._$10[i].readLong40();
                        if (this._$9[i].hasMaxMinValues()) {
                            this._$10[i].skipObject();
                            this._$10[i].skipObject();
                            this._$10[i].skipObject();
                        }
                        colReaders[i].seek(pos);
                    }
                    skipCount += (long)recordCount;
                    if (diff != (long)recordCount) continue;
                    break;
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            this._$4 += skipCount;
            this._$7 = curBlock;
            return skipCount;
        }

        public void close() {
            super.close();
            this._$5 = true;
            this._$6 = null;
            try {
                if (this._$10 != null) {
                    for (ObjectReader reader : this._$10) {
                        reader.close();
                    }
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
            finally {
                this._$12 = null;
                this._$11 = null;
                this._$10 = null;
            }
        }

        public boolean reset() {
            this.close();
            this._$5 = false;
            this._$7 = 0;
            return true;
        }
    }
}

