/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.common.RQException;
import com.scudata.dm.ObjectReader;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ColumnMetaData;
import com.scudata.util.Variant;
import java.io.IOException;

class RecordSeqSearcher2 {
    private ColPhyTable table;
    private ColPhyTable baseTable;
    private long prevRecordCount = 0L;
    private long basePrevRecordCount = 0L;
    private int curBlock = -1;
    private int totalBlockCount;
    private BlockLinkReader rowCountReader;
    private BlockLinkReader baseRowCountReader;
    private BlockLinkReader[] colReaders;
    private ObjectReader[] segmentReaders;
    private long[] positions;
    private Object[] minValues;
    private Object[] maxValues;
    private int curRecordCount = 0;
    private int curIndex = -1;
    private int baseCurRecordCount = 0;
    private Object[][] blockKeyValues;
    private boolean isEnd = false;
    private int baseKeyCount;
    private ColumnMetaData guideColumn;
    private BlockLinkReader guideColReader;
    private ObjectReader guideSegmentReader;
    private long guidePosition;
    private long[] guideVals;

    public RecordSeqSearcher2(ColPhyTable table) {
        this.table = table;
        this.baseTable = (ColPhyTable)table.groupTable.baseTable;
        this.init();
    }

    private void init() {
        this.totalBlockCount = this.table.getDataBlockCount();
        this.baseKeyCount = this.table.sortedColStartIndex;
        if (this.totalBlockCount == 0) {
            this.isEnd = true;
            return;
        }
        ColumnMetaData[] columns = this.table.getAllSortedColumns();
        int keyCount = columns.length;
        this.rowCountReader = this.table.getSegmentReader();
        this.baseRowCountReader = this.baseTable.getSegmentReader();
        this.colReaders = new BlockLinkReader[keyCount];
        this.segmentReaders = new ObjectReader[keyCount];
        this.positions = new long[keyCount];
        this.minValues = new Object[keyCount];
        this.maxValues = new Object[keyCount];
        this.blockKeyValues = new Object[keyCount][];
        int k = 0;
        while (k < keyCount) {
            this.colReaders[k] = columns[k].getColReader(true);
            this.segmentReaders[k] = columns[k].getSegmentReader();
            ++k;
        }
        this.guideColumn = this.table.getGuideColumn();
        this.guideColReader = this.guideColumn.getColReader(true);
        this.guideSegmentReader = this.guideColumn.getSegmentReader();
        this.nextBlock();
    }

    private boolean nextBlock() {
        this.prevRecordCount += (long)this.curRecordCount;
        this.curIndex = -1;
        this.basePrevRecordCount += (long)this.baseCurRecordCount;
        if (++this.curBlock == this.totalBlockCount) {
            this.isEnd = true;
            return false;
        }
        try {
            this.curRecordCount = this.rowCountReader.readInt32();
            this.baseCurRecordCount = this.baseRowCountReader.readInt32();
            this.guidePosition = this.guideSegmentReader.readLong40();
            int keyCount = this.segmentReaders.length;
            int k = 0;
            while (k < keyCount) {
                this.positions[k] = this.segmentReaders[k].readLong40();
                this.minValues[k] = this.segmentReaders[k].readObject();
                this.maxValues[k] = this.segmentReaders[k].readObject();
                this.segmentReaders[k].skipObject();
                ++k;
            }
            return true;
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadKeyValues() {
        try {
            keyCount = this.colReaders.length;
            count = this.curRecordCount + 1;
            guideVals = new long[count];
            this.guideVals = guideVals;
            greader = this.guideColReader.readBlockData(this.guidePosition, this.curRecordCount);
            i = 1;
            while (i < count) {
                guideVals[i] = (Long)greader.readObject();
                ++i;
            }
            k = 0;
            while (k < this.baseKeyCount) {
                baseCount = 1;
                basePrevRecordCount = this.basePrevRecordCount;
                reader = this.colReaders[k].readBlockData(this.positions[k], this.baseCurRecordCount);
                vals = new Object[count];
                this.blockKeyValues[k] = vals;
                obj = reader.readObject();
                i = 1;
                ** GOTO lbl28
                {
                    ++baseCount;
                    obj = reader.readObject();
                    do {
                        if (basePrevRecordCount + (long)baseCount != guideVals[i]) continue block4;
                        vals[i] = obj;
                        ++i;
lbl28:
                        // 2 sources

                    } while (i < count);
                }
                ++k;
            }
            k = this.baseKeyCount;
            while (k < keyCount) {
                reader = this.colReaders[k].readBlockData(this.positions[k], this.curRecordCount);
                vals = new Object[count];
                this.blockKeyValues[k] = vals;
                i = 1;
                while (i < count) {
                    vals[i] = reader.readObject();
                    ++i;
                }
                ++k;
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    public long findNext(Object keyValue, int[] block) {
        int cmp;
        block[0] = -1;
        if (this.isEnd) {
            return -this.prevRecordCount - 1L;
        }
        if (this.curIndex != -1) {
            int cmp2 = Variant.compare(keyValue, this.maxValues[0]);
            if (cmp2 > 0) {
                this.nextBlock();
                return this.findNext(keyValue, block);
            }
            Object[] values = this.blockKeyValues[0];
            int i = this.curIndex;
            int end = this.curRecordCount;
            while (i <= end) {
                cmp2 = Variant.compare(keyValue, values[i]);
                if (cmp2 == 0) {
                    this.curIndex = i;
                    return this.prevRecordCount + (long)i;
                }
                if (cmp2 < 0) {
                    this.curIndex = i;
                    return -this.prevRecordCount - (long)i;
                }
                ++i;
            }
            this.curIndex = this.curRecordCount;
            block[0] = this.curBlock + 1;
            return -this.prevRecordCount - (long)this.curIndex;
        }
        while ((cmp = Variant.compare(keyValue, this.maxValues[0])) > 0) {
            if (this.nextBlock()) continue;
            return -this.prevRecordCount - 1L;
        }
        if (cmp == 0) {
            this.curIndex = this.curRecordCount;
            return this.prevRecordCount + (long)this.curRecordCount;
        }
        this.loadKeyValues();
        this.curIndex = 1;
        return this.findNext(keyValue, block);
    }

    public long findNext(Object[] keyValues, int[] block) {
        int cmp;
        block[0] = -1;
        if (this.isEnd) {
            return -this.prevRecordCount - 1L;
        }
        if (this.curRecordCount == 0 && (cmp = Variant.compareArrays(keyValues, this.maxValues, this.baseKeyCount)) <= 0) {
            block[0] = this.curBlock + 1;
            return -this.prevRecordCount;
        }
        if (this.curIndex != -1) {
            cmp = this.curRecordCount == 0 ? Variant.compareArrays(keyValues, this.maxValues, this.baseKeyCount) : Variant.compareArrays(keyValues, this.maxValues);
            if (cmp > 0) {
                this.nextBlock();
                return this.findNext(keyValues, block);
            }
            if (cmp == 0) {
                if (this.curRecordCount == 0) {
                    block[0] = this.curBlock + 1;
                    return -this.prevRecordCount;
                }
                this.curIndex = this.curRecordCount;
                return this.prevRecordCount + (long)this.curIndex;
            }
            Object[][] blockKeyValues = this.blockKeyValues;
            int keyCount = keyValues.length;
            int i = this.curIndex;
            int end = this.curRecordCount;
            while (i <= end) {
                block13: {
                    int k = 0;
                    while (k < keyCount) {
                        cmp = Variant.compare(keyValues[k], blockKeyValues[k][i]);
                        if (cmp <= 0) {
                            if (cmp < 0) {
                                this.curIndex = i;
                                return -this.prevRecordCount - (long)i;
                            }
                            ++k;
                            continue;
                        }
                        break block13;
                    }
                    this.curIndex = i;
                    return this.prevRecordCount + (long)i;
                }
                ++i;
            }
            this.curIndex = this.curRecordCount;
            block[0] = this.curBlock + 1;
            return -this.prevRecordCount - (long)this.curIndex;
        }
        while ((cmp = this.curRecordCount == 0 ? Variant.compareArrays(keyValues, this.maxValues, this.baseKeyCount) : Variant.compareArrays(keyValues, this.maxValues)) > 0) {
            if (this.nextBlock()) continue;
            return -this.prevRecordCount - 1L;
        }
        if (cmp == 0) {
            if (this.curRecordCount == 0) {
                block[0] = this.curBlock + 1;
                return -this.prevRecordCount;
            }
            this.curIndex = this.curRecordCount;
            return this.prevRecordCount + (long)this.curRecordCount;
        }
        this.loadKeyValues();
        this.curIndex = 1;
        return this.findNext(keyValues, block);
    }

    public long findNext(Object[] keyValues, int keyLen) {
        int cmp;
        if (this.isEnd) {
            return -this.prevRecordCount - 1L;
        }
        if (this.curIndex != -1) {
            int cmp2 = Variant.compareArrays(keyValues, this.maxValues, keyLen);
            if (cmp2 > 0) {
                this.nextBlock();
                return this.findNext(keyValues, keyLen);
            }
            Object[][] blockKeyValues = this.blockKeyValues;
            int i = this.curIndex;
            int end = this.curRecordCount;
            while (i <= end) {
                block8: {
                    int k = 0;
                    while (k < keyLen) {
                        cmp2 = Variant.compare(keyValues[k], blockKeyValues[k][i]);
                        if (cmp2 <= 0) {
                            if (cmp2 < 0) {
                                this.curIndex = i + 1;
                                return -this.prevRecordCount - (long)i;
                            }
                            ++k;
                            continue;
                        }
                        break block8;
                    }
                    this.curIndex = i + 1;
                    return this.prevRecordCount + (long)i;
                }
                ++i;
            }
            this.nextBlock();
            return this.findNext(keyValues, keyLen);
        }
        while ((cmp = Variant.compareArrays(keyValues, this.maxValues, keyLen)) > 0) {
            if (this.nextBlock()) continue;
            return -this.prevRecordCount - 1L;
        }
        this.loadKeyValues();
        this.curIndex = 1;
        return this.findNext(keyValues, keyLen);
    }

    long getRecNum() {
        if (this.isEnd || this.guideVals == null) {
            return 0L;
        }
        return this.guideVals[this.curIndex];
    }

    public boolean isEnd() {
        return this.isEnd;
    }
}

