/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.LongArray;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.ObjectWriter;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ConjxCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MergesCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dw.BlockLink;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.BlockLinkWriter;
import com.scudata.dw.BufferReader;
import com.scudata.dw.BufferWriter;
import com.scudata.dw.ColumnFilter;
import com.scudata.dw.ComTable;
import com.scudata.dw.IDWCursor;
import com.scudata.dw.IlllIllIlIIlIllI;
import com.scudata.dw.IllllIIlIIllIlll;
import com.scudata.dw.ModifyRecord;
import com.scudata.dw.PhyTable;
import com.scudata.dw.RowBufferWriter;
import com.scudata.dw.RowComTable;
import com.scudata.dw.RowCursor;
import com.scudata.dw.llIIllIllIIIIIlI;
import com.scudata.expression.Constant;
import com.scudata.expression.Expression;
import com.scudata.expression.Node;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.NotEquals;
import com.scudata.expression.operator.NotGreater;
import com.scudata.expression.operator.NotSmaller;
import com.scudata.expression.operator.Smaller;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowPhyTable
extends PhyTable {
    protected transient String[] sortedColNames;
    private transient String[] _$2;
    protected transient String[] allKeyColNames;
    protected BlockLink dataBlockLink;
    protected transient BlockLinkWriter colWriter;
    protected transient ObjectWriter objectWriter;
    protected int sortedColStartIndex;
    protected boolean[] isDim;
    protected boolean[] isKey;
    protected int[] serialBytesLen;

    public RowPhyTable(ComTable groupTable) {
        this.groupTable = groupTable;
        this.dataBlockLink = new BlockLink(groupTable);
        this.segmentBlockLink = new BlockLink(groupTable);
        this.modifyBlockLink1 = new BlockLink(groupTable);
        this.modifyBlockLink2 = new BlockLink(groupTable);
    }

    public RowPhyTable(ComTable groupTable, RowPhyTable parent) {
        this.groupTable = groupTable;
        this.parent = parent;
        this.dataBlockLink = new BlockLink(groupTable);
        this.segmentBlockLink = new BlockLink(groupTable);
        this.modifyBlockLink1 = new BlockLink(groupTable);
        this.modifyBlockLink2 = new BlockLink(groupTable);
    }

    public RowPhyTable(ComTable groupTable, String[] colNames) throws IOException {
        int i;
        String[] tmp = new String[colNames.length];
        System.arraycopy(colNames, 0, tmp, 0, colNames.length);
        colNames = tmp;
        this.groupTable = groupTable;
        this.tableName = "";
        this.dataBlockLink = new BlockLink(groupTable);
        this.segmentBlockLink = new BlockLink(groupTable);
        this.modifyBlockLink1 = new BlockLink(groupTable);
        this.modifyBlockLink2 = new BlockLink(groupTable);
        int len = colNames.length;
        this.isDim = new boolean[len];
        this.isKey = new boolean[len];
        this.serialBytesLen = new int[len];
        int keyStart = -1;
        for (i = 0; i < len; ++i) {
            if (!colNames[i].startsWith(KEY_PREFIX)) continue;
            keyStart = i;
            break;
        }
        for (i = 0; i < len; ++i) {
            if (colNames[i].startsWith(KEY_PREFIX)) {
                colNames[i] = colNames[i].substring(KEY_PREFIX.length());
                this.isDim[i] = true;
                this.isKey[i] = true;
                continue;
            }
            if (i >= keyStart) continue;
            this.isDim[i] = true;
        }
        this.colNames = colNames;
        this.init();
        if (this.sortedColNames == null) {
            this.hasPrimaryKey = false;
            this.isSorted = false;
        }
        this.tableList = new ArrayList();
    }

    public RowPhyTable(ComTable groupTable, String[] colNames, int[] serialBytesLen, String tableName, RowPhyTable parent) throws IOException {
        String[] tmp = new String[colNames.length];
        System.arraycopy(colNames, 0, tmp, 0, colNames.length);
        colNames = tmp;
        this.groupTable = groupTable;
        this.tableName = tableName;
        this.parent = parent;
        this.dataBlockLink = new BlockLink(groupTable);
        this.segmentBlockLink = new BlockLink(groupTable);
        this.modifyBlockLink1 = new BlockLink(groupTable);
        this.modifyBlockLink2 = new BlockLink(groupTable);
        this.serialBytesLen = serialBytesLen;
        int len = colNames.length;
        this.isDim = new boolean[len];
        this.isKey = new boolean[len];
        for (int i = 0; i < len; ++i) {
            String name = colNames[i];
            if (name.startsWith("#")) {
                colNames[i] = name.substring(1);
                this.isKey[i] = true;
                this.isDim[i] = true;
                continue;
            }
            this.isKey[i] = false;
            this.isDim[i] = false;
        }
        this.colNames = colNames;
        this.init();
        if (this.getAllSortedColNames() == null) {
            this.hasPrimaryKey = false;
            this.isSorted = false;
        }
        if (parent != null) {
            if (parent.parent != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.dsNotMatch"));
            }
            RowPhyTable primaryTable = parent;
            String[] primarySortedColNames = ((PhyTable)primaryTable).getSortedColNames();
            String[] primaryColNames = primaryTable.getColNames();
            ArrayList<String> collist = new ArrayList<String>();
            for (String name : primaryColNames) {
                collist.add(name);
            }
            for (int i = 0; i < len; ++i) {
                if (!collist.contains(colNames[i])) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException(colNames[i] + mm.getMessage("dw.fieldSameToPrimaryTable"));
            }
            for (String name : primarySortedColNames) {
                collist.remove(name);
            }
            this.sortedColStartIndex = primarySortedColNames.length;
        }
        this.tableList = new ArrayList();
    }

    public RowPhyTable(ComTable groupTable, RowPhyTable parent, RowPhyTable src) throws IOException {
        this.groupTable = groupTable;
        this.parent = parent;
        System.arraycopy(src.reserve, 0, this.reserve, 0, this.reserve.length);
        this.segmentCol = src.segmentCol;
        this.segmentSerialLen = src.segmentSerialLen;
        this.tableName = src.tableName;
        this.colNames = src.colNames;
        this.isDim = src.isDim;
        this.isKey = src.isKey;
        this.serialBytesLen = src.serialBytesLen;
        this.dataBlockLink = new BlockLink(groupTable);
        this.segmentBlockLink = new BlockLink(groupTable);
        this.modifyBlockLink1 = new BlockLink(groupTable);
        this.modifyBlockLink2 = new BlockLink(groupTable);
        this.init();
        if (this.getAllSortedColNames() == null) {
            this.hasPrimaryKey = false;
            this.isSorted = false;
        }
        this.tableList = new ArrayList();
        for (PhyTable srcSub : src.tableList) {
            this.tableList.add(new RowPhyTable(groupTable, this, (RowPhyTable)srcSub));
        }
    }

    @Override
    protected void init() {
        int i;
        int j;
        String[] col = this.colNames;
        int dimCount = this.getDimCount();
        int keyCount = this.getKeyCount();
        int count = col.length;
        if (dimCount > 0) {
            this.sortedColNames = new String[dimCount];
            j = 0;
            for (i = 0; i < count; ++i) {
                if (!this.isDim(col[i])) continue;
                this.sortedColNames[j++] = col[i];
            }
        }
        if (keyCount > 0) {
            this.allKeyColNames = new String[keyCount];
            j = 0;
            for (i = 0; i < count; ++i) {
                if (!this.isKey(col[i])) continue;
                this.allKeyColNames[j++] = col[i];
            }
        }
        if (this.parent != null) {
            PhyTable primaryTable = this.parent;
            String[] primarySortedColNames = primaryTable.getAllSortedColNames();
            this.sortedColStartIndex = primarySortedColNames.length;
            this.allColNames = new String[this.sortedColStartIndex + this.colNames.length];
            int i2 = 0;
            for (String colName : primarySortedColNames) {
                this.allColNames[i2++] = colName;
            }
            for (String colName : this.colNames) {
                this.allColNames[i2++] = colName;
            }
            this._$2 = new String[this.sortedColStartIndex + dimCount];
            i2 = 0;
            if (primarySortedColNames != null) {
                for (String colName : primarySortedColNames) {
                    this._$2[i2++] = colName;
                }
            }
            if (this.sortedColNames != null) {
                for (String colName : this.sortedColNames) {
                    this._$2[i2++] = colName;
                }
            }
            this.ds = new DataStruct(this.getAllColNames());
        } else {
            this.ds = new DataStruct(this.colNames);
        }
    }

    @Override
    public String[] getSortedColNames() {
        return this.sortedColNames;
    }

    @Override
    public String[] getAllKeyColNames() {
        return this.allKeyColNames;
    }

    @Override
    protected void applyFirstBlock() throws IOException {
        if (this.segmentBlockLink.isEmpty()) {
            this.segmentBlockLink.setFirstBlockPos(this.groupTable.applyNewBlock());
            if (this.dataBlockLink.isEmpty()) {
                this.dataBlockLink.setFirstBlockPos(this.groupTable.applyNewBlock());
            }
        }
    }

    @Override
    protected void prepareAppend() throws IOException {
        this.applyFirstBlock();
        this.colWriter = new BlockLinkWriter(this.dataBlockLink, true);
        this.segmentWriter = new BlockLinkWriter(this.segmentBlockLink, true);
        this.objectWriter = new ObjectWriter(this.segmentWriter, this.groupTable.getBlockSize() - 5);
    }

    @Override
    protected void finishAppend() throws IOException {
        this.colWriter.finishWrite();
        this.colWriter = null;
        this.objectWriter.flush();
        this.segmentWriter.finishWrite();
        this.segmentWriter = null;
        this.objectWriter = null;
        this.groupTable._$3();
        this.updateIndex();
    }

    @Override
    public void readExternal(BufferReader reader) throws IOException {
        int i;
        reader.read(this.reserve);
        this.tableName = reader.readUTF();
        this.colNames = reader.readStrings();
        this.dataBlockCount = reader.readInt32();
        this.totalRecordCount = reader.readLong40();
        this.segmentBlockLink.readExternal(reader);
        this.dataBlockLink.readExternal(reader);
        this.curModifyBlock = reader.readByte();
        this.modifyBlockLink1.readExternal(reader);
        this.modifyBlockLink2.readExternal(reader);
        int count = reader.readInt();
        this.colNames = new String[count];
        for (i = 0; i < count; ++i) {
            this.colNames[i] = reader.readUTF();
        }
        this.serialBytesLen = new int[count];
        for (i = 0; i < count; ++i) {
            this.serialBytesLen[i] = reader.readInt();
        }
        this.isDim = new boolean[count];
        for (i = 0; i < count; ++i) {
            this.isDim[i] = reader.readBoolean();
        }
        if (this.reserve[0] > 0) {
            this.isKey = new boolean[count];
            for (i = 0; i < count; ++i) {
                this.isKey[i] = reader.readBoolean();
            }
        }
        if ((count = reader.readInt()) > 0) {
            this.maxValues = new Object[count];
            for (i = 0; i < count; ++i) {
                this.maxValues[i] = reader.readObject();
            }
        }
        this.hasPrimaryKey = reader.readBoolean();
        this.isSorted = reader.readBoolean();
        this.indexNames = reader.readStrings();
        if (this.indexNames == null) {
            this.indexFields = null;
            this.indexValueFields = null;
        } else {
            int i2;
            int indexCount = this.indexNames.length;
            this.indexFields = new String[indexCount][];
            for (i2 = 0; i2 < indexCount; ++i2) {
                this.indexFields[i2] = reader.readStrings();
            }
            this.indexValueFields = new String[indexCount][];
            for (i2 = 0; i2 < indexCount; ++i2) {
                this.indexValueFields[i2] = reader.readStrings();
            }
        }
        if (this.groupTable.reserve[0] > 2) {
            this.cuboids = reader.readStrings();
        }
        this.segmentCol = (String)reader.readObject();
        this.segmentSerialLen = reader.readInt();
        this.init();
        count = reader.readInt();
        this.tableList = new ArrayList(count);
        for (i = 0; i < count; ++i) {
            RowPhyTable table = new RowPhyTable(this.groupTable, this);
            ((PhyTable)table).readExternal(reader);
            this.tableList.add(table);
        }
    }

    @Override
    public void writeExternal(BufferWriter writer) throws IOException {
        int i;
        this.reserve[0] = 1;
        writer.write(this.reserve);
        writer.writeUTF(this.tableName);
        writer.writeStrings(this.colNames);
        writer.writeInt32(this.dataBlockCount);
        writer.writeLong40(this.totalRecordCount);
        this.segmentBlockLink.writeExternal(writer);
        this.dataBlockLink.writeExternal(writer);
        writer.writeByte(this.curModifyBlock);
        this.modifyBlockLink1.writeExternal(writer);
        this.modifyBlockLink2.writeExternal(writer);
        String[] colNames = this.colNames;
        int count = colNames.length;
        writer.writeInt(count);
        for (i = 0; i < count; ++i) {
            writer.writeUTF(colNames[i]);
        }
        for (i = 0; i < count; ++i) {
            writer.writeInt(this.serialBytesLen[i]);
        }
        for (i = 0; i < count; ++i) {
            writer.writeBoolean(this.isDim[i]);
        }
        for (i = 0; i < count; ++i) {
            writer.writeBoolean(this.isKey[i]);
        }
        if (this.maxValues == null) {
            writer.writeInt(0);
        } else {
            writer.writeInt(this.maxValues.length);
            for (Object val : this.maxValues) {
                writer.writeObject(val);
            }
            writer.flush();
        }
        writer.writeBoolean(this.hasPrimaryKey);
        writer.writeBoolean(this.isSorted);
        writer.writeStrings(this.indexNames);
        if (this.indexNames != null) {
            int i2;
            int indexCount = this.indexNames.length;
            for (i2 = 0; i2 < indexCount; ++i2) {
                writer.writeStrings(this.indexFields[i2]);
            }
            indexCount = this.indexNames.length;
            for (i2 = 0; i2 < indexCount; ++i2) {
                writer.writeStrings(this.indexValueFields[i2]);
            }
        }
        writer.writeStrings(this.cuboids);
        writer.writeObject(this.segmentCol);
        writer.flush();
        writer.writeInt(this.segmentSerialLen);
        ArrayList tableList = this.tableList;
        count = tableList.size();
        writer.writeInt(count);
        for (int i3 = 0; i3 < count; ++i3) {
            ((PhyTable)tableList.get(i3)).writeExternal(writer);
        }
    }

    private void _$1(Sequence data, boolean[] isMyCol, LongArray recList) throws IOException {
        int count = this.allColNames.length;
        boolean[] isDim = this.getDimIndex();
        Object[] minValues = null;
        Object[] maxValues = null;
        if (this.sortedColNames != null) {
            minValues = new Object[count];
            maxValues = new Object[count];
        }
        RowBufferWriter bufferWriter = new RowBufferWriter(this.groupTable.getStructManager());
        long recNum = this.totalRecordCount;
        int end = data.length();
        for (int i = 1; i <= end; ++i) {
            Object obj;
            int j;
            bufferWriter.writeObject(++recNum);
            bufferWriter.writeObject(recList.get(i - 1));
            Record r = (Record)data.get(i);
            Object[] vals = r.getFieldValues();
            for (j = 0; j < count; ++j) {
                if (!isMyCol[j]) continue;
                obj = vals[j];
                bufferWriter.writeObject(obj);
            }
            for (j = 0; j < count; ++j) {
                if (!isMyCol[j]) continue;
                obj = vals[j];
                if (!isDim[j]) continue;
                if (Variant.compare(obj, maxValues[j], true) > 0) {
                    maxValues[j] = obj;
                }
                if (i == 1) {
                    minValues[j] = obj;
                }
                if (Variant.compare(obj, minValues[j], true) >= 0) continue;
                minValues[j] = obj;
            }
        }
        if (recList.size() == 0) {
            bufferWriter.writeObject(null);
        }
        if (this.sortedColNames == null) {
            long pos = this.colWriter.writeDataBuffer(bufferWriter.finish());
            this.appendSegmentBlock(end);
            this.objectWriter.writeLong40(pos);
        } else {
            long pos = this.colWriter.writeDataBuffer(bufferWriter.finish());
            this.appendSegmentBlock(end);
            this.objectWriter.writeLong40(pos);
            for (int i = 0; i < count; ++i) {
                if (!isMyCol[i] || !isDim[i]) continue;
                this.objectWriter.writeObject(minValues[i]);
                this.objectWriter.writeObject(maxValues[i]);
            }
        }
    }

    protected void appendDataBlock(Sequence data, int start, int end) throws IOException {
        int count = this.colNames.length;
        boolean[] isDim = this.getDimIndex();
        Object[] minValues = null;
        Object[] maxValues = null;
        if (this.sortedColNames != null) {
            minValues = new Object[count];
            maxValues = new Object[count];
        }
        RowBufferWriter bufferWriter = new RowBufferWriter(this.groupTable.getStructManager());
        long recNum = this.totalRecordCount;
        for (int i = start; i <= end; ++i) {
            Record r = (Record)data.get(i);
            Object[] vals = r.getFieldValues();
            bufferWriter.writeObject(++recNum);
            for (int j = 0; j < count; ++j) {
                Object obj = vals[j];
                bufferWriter.writeObject(obj);
                if (!isDim[j]) continue;
                if (Variant.compare(obj, maxValues[j], true) > 0) {
                    maxValues[j] = obj;
                }
                if (i == start) {
                    minValues[j] = obj;
                }
                if (Variant.compare(obj, minValues[j], true) >= 0) continue;
                minValues[j] = obj;
            }
        }
        if (this.sortedColNames == null) {
            long pos = this.colWriter.writeDataBuffer(bufferWriter.finish());
            this.appendSegmentBlock(end - start + 1);
            this.objectWriter.writeLong40(pos);
        } else {
            long pos = this.colWriter.writeDataBuffer(bufferWriter.finish());
            this.appendSegmentBlock(end - start + 1);
            this.objectWriter.writeLong40(pos);
            for (int i = 0; i < count; ++i) {
                if (!isDim[i]) continue;
                this.objectWriter.writeObject(minValues[i]);
                this.objectWriter.writeObject(maxValues[i]);
            }
        }
    }

    private void _$4(ICursor cursor) throws IOException {
        Sequence data = cursor.fetch(MIN_BLOCK_RECORD_COUNT);
        while (data != null && data.length() > 0) {
            this.appendDataBlock(data, 1, data.length());
            data = cursor.fetch(MIN_BLOCK_RECORD_COUNT);
        }
    }

    private void _$3(ICursor cursor) throws IOException {
        PhyTable primaryTable = this.parent;
        int pBlockCount = primaryTable.getDataBlockCount();
        int curBlockCount = this.dataBlockCount;
        int pkeyEndIndex = this.sortedColStartIndex;
        String[] primaryTableKeys = primaryTable.getSortedColNames();
        ArrayList<String> primaryTableKeyList = new ArrayList<String>();
        for (String name : primaryTableKeys) {
            primaryTableKeyList.add(name);
        }
        String[] colNames = this.getAllColNames();
        int fcount = colNames.length;
        boolean[] isMyCol = new boolean[fcount];
        for (int i = 0; i < fcount; ++i) {
            isMyCol[i] = !primaryTableKeyList.contains(colNames[i]);
        }
        if (primaryTable.totalRecordCount == 0L) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.baseTableNull"));
        }
        RowCursor cs = (RowCursor)primaryTable.cursor(primaryTableKeys);
        cs.setSegment(curBlockCount, curBlockCount + 1);
        Sequence pkeyData = cs.fetch(0x7FFFFFFE);
        int pkeyIndex = 1;
        int pkeyDataLen = pkeyData.length();
        IlllIllIlIIlIllI curPkey = (IlllIllIlIIlIllI)pkeyData.get(1);
        Object[] curPkeyVals = curPkey.getFieldValues();
        String[] allSortedColNames = this.getAllSortedColNames();
        int sortedColCount = allSortedColNames.length;
        Object[] tableMaxValues = this.maxValues;
        Object[] lastValues = new Object[sortedColCount];
        LongArray guideCol = new LongArray(MIN_BLOCK_RECORD_COUNT);
        Sequence seq = new Sequence(MIN_BLOCK_RECORD_COUNT);
        Sequence data = cursor.fetch(ICursor.FETCHCOUNT);
        Object[] vals = new Object[sortedColCount];
        int[] findex = new int[sortedColCount];
        DataStruct ds = data.dataStruct();
        for (int f = 0; f < sortedColCount; ++f) {
            findex[f] = ds.getFieldIndex(allSortedColNames[f]);
        }
        while (data != null && data.length() > 0) {
            int len = data.length();
            for (int i = 1; i <= len; ++i) {
                MessageManager mm;
                int cmp;
                Record r = (Record)data.get(i);
                for (int f = 0; f < sortedColCount; ++f) {
                    Object obj;
                    vals[f] = obj = r.getNormalFieldValue(findex[f]);
                }
                while ((cmp = Variant.compareArrays(curPkeyVals, vals, pkeyEndIndex)) != 0) {
                    if (cmp < 0) {
                        if (++pkeyIndex > pkeyDataLen) {
                            this._$1(seq, isMyCol, guideCol);
                            seq.clear();
                            guideCol = new LongArray(MIN_BLOCK_RECORD_COUNT);
                            if (++curBlockCount >= pBlockCount) {
                                mm = EngineMessage.get();
                                throw new RQException(mm.getMessage("dw.appendNotMatch") + r.toString(null));
                            }
                            cs = (RowCursor)primaryTable.cursor(primaryTableKeys);
                            cs.setSegment(curBlockCount, curBlockCount + 1);
                            pkeyData = cs.fetch(0x7FFFFFFE);
                            pkeyIndex = 1;
                            pkeyDataLen = pkeyData.length();
                        }
                        curPkey = (IlllIllIlIIlIllI)pkeyData.get(pkeyIndex);
                        curPkeyVals = curPkey.getFieldValues();
                        continue;
                    }
                    if (cmp <= 0) continue;
                    mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("dw.appendNotMatch") + r.toString(null));
                }
                guideCol.add(curPkey.getRecordSeq());
                if (this.isSorted) {
                    if (tableMaxValues != null) {
                        cmp = Variant.compareArrays(vals, tableMaxValues, sortedColCount);
                        if (cmp < 0) {
                            mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("dw.appendAttachedTable"));
                        }
                        if (cmp == 0) {
                            if (this.hasPrimaryKey) {
                                this.hasPrimaryKey = false;
                            }
                        } else {
                            System.arraycopy(vals, 0, tableMaxValues, 0, sortedColCount);
                        }
                    } else {
                        this.maxValues = new Object[sortedColCount];
                        tableMaxValues = this.maxValues;
                        System.arraycopy(vals, 0, tableMaxValues, 0, sortedColCount);
                    }
                }
                seq.add(r);
                System.arraycopy(vals, 0, lastValues, 0, sortedColCount);
            }
            data = cursor.fetch(ICursor.FETCHCOUNT);
        }
        if (seq.length() > 0) {
            this._$1(seq, isMyCol, guideCol);
        }
    }

    private void _$2(ICursor cursor) throws IOException {
        int recCount = 0;
        int sortedColCount = this.sortedColNames.length;
        Object[] tableMaxValues = this.maxValues;
        String[] sortedColNames = this.sortedColNames;
        String segmentCol = this.groupTable.baseTable.getSegmentCol();
        int segmentSerialLen = this.groupTable.baseTable.getSegmentSerialLen();
        int segmentIndex = 0;
        for (int i = 0; i < sortedColCount; ++i) {
            if (!segmentCol.equals(sortedColNames[i])) continue;
            segmentIndex = i;
            break;
        }
        int cmpLen = segmentIndex + 1;
        int serialBytesLen = this.getSerialBytesLen(segmentIndex);
        if (segmentSerialLen == 0 || segmentSerialLen > serialBytesLen) {
            segmentSerialLen = serialBytesLen;
        }
        Object[] lastValues = new Object[cmpLen];
        Object[] curValues = new Object[cmpLen];
        Sequence seq = new Sequence(MIN_BLOCK_RECORD_COUNT);
        Sequence data = cursor.fetch(ICursor.FETCHCOUNT);
        Object[] vals = new Object[sortedColCount];
        int[] findex = this.getSortedColIndex();
        while (data != null && data.length() > 0) {
            int len = data.length();
            for (int i = 1; i <= len; ++i) {
                Object obj;
                Record r = (Record)data.get(i);
                for (int f = 0; f < sortedColCount; ++f) {
                    vals[f] = r.getNormalFieldValue(findex[f]);
                }
                if (recCount >= MIN_BLOCK_RECORD_COUNT) {
                    if (serialBytesLen < 1) {
                        System.arraycopy(vals, 0, curValues, 0, cmpLen);
                    } else {
                        System.arraycopy(vals, 0, curValues, 0, segmentIndex);
                        obj = vals[segmentIndex];
                        Long val = obj instanceof Integer ? Long.valueOf((long)((Integer)obj).intValue() & 0xFFFFFFFFL) : (Long)obj;
                        curValues[segmentIndex] = val >>> (serialBytesLen - segmentSerialLen) * 8;
                    }
                    if (0 != Variant.compareArrays(lastValues, curValues, cmpLen)) {
                        this.appendDataBlock(seq, 1, seq.length());
                        seq.clear();
                        recCount = 0;
                    }
                }
                if (this.isSorted) {
                    if (tableMaxValues != null) {
                        int cmp = Variant.compareArrays(vals, tableMaxValues, sortedColCount);
                        if (cmp < 0) {
                            this.isSorted = false;
                            this.maxValues = null;
                        } else if (cmp != 0) {
                            System.arraycopy(vals, 0, tableMaxValues, 0, sortedColCount);
                        }
                        if (this.tableList.size() > 0 && !this.hasPrimaryKey) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("dw.appendPrimaryTable"));
                        }
                    } else {
                        this.maxValues = new Object[sortedColCount];
                        tableMaxValues = this.maxValues;
                        System.arraycopy(vals, 0, tableMaxValues, 0, sortedColCount);
                    }
                }
                seq.add(r);
                if (serialBytesLen < 1) {
                    System.arraycopy(vals, 0, lastValues, 0, cmpLen);
                } else {
                    System.arraycopy(vals, 0, lastValues, 0, segmentIndex);
                    obj = vals[segmentIndex];
                    Long val = obj instanceof Integer ? Long.valueOf((long)((Integer)obj).intValue() & 0xFFFFFFFFL) : (Long)obj;
                    lastValues[segmentIndex] = val >>> (serialBytesLen - segmentSerialLen) * 8;
                }
                ++recCount;
            }
            data = cursor.fetch(ICursor.FETCHCOUNT);
        }
        if (seq.length() > 0) {
            this.appendDataBlock(seq, 1, seq.length());
        }
    }

    private void _$1(ICursor cursor) throws IOException {
        int recCount = 0;
        int sortedColCount = this.sortedColNames.length;
        Object[] tableMaxValues = this.maxValues;
        Object[] lastValues = new Object[sortedColCount];
        Sequence seq = new Sequence(MIN_BLOCK_RECORD_COUNT);
        Sequence data = cursor.fetch(ICursor.FETCHCOUNT);
        Object[] vals = new Object[sortedColCount];
        int[] findex = this.getSortedColIndex();
        while (data != null && data.length() > 0) {
            int len = data.length();
            for (int i = 1; i <= len; ++i) {
                Record r = (Record)data.get(i);
                for (int f = 0; f < sortedColCount; ++f) {
                    vals[f] = r.getNormalFieldValue(findex[f]);
                }
                if (recCount >= MAX_BLOCK_RECORD_COUNT) {
                    this.appendDataBlock(seq, 1, MAX_BLOCK_RECORD_COUNT / 2);
                    seq = seq.get(MAX_BLOCK_RECORD_COUNT / 2 + 1, seq.length() + 1);
                    recCount = seq.length();
                } else if (recCount >= MIN_BLOCK_RECORD_COUNT) {
                    boolean doAppend = true;
                    int segLen = sortedColCount > 1 ? sortedColCount / 2 : 1;
                    for (int c = 0; c < segLen; ++c) {
                        int cmp = Variant.compare(lastValues[c], vals[c], true);
                        if (cmp != 0) continue;
                        doAppend = false;
                        break;
                    }
                    if (doAppend) {
                        this.appendDataBlock(seq, 1, seq.length());
                        seq.clear();
                        recCount = 0;
                    }
                }
                if (this.isSorted) {
                    if (tableMaxValues != null) {
                        int cmp = Variant.compareArrays(vals, tableMaxValues, sortedColCount);
                        if (cmp < 0) {
                            this.isSorted = false;
                            this.maxValues = null;
                        } else if (cmp != 0) {
                            System.arraycopy(vals, 0, tableMaxValues, 0, sortedColCount);
                        }
                        if (this.tableList.size() > 0 && !this.hasPrimaryKey) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("dw.appendPrimaryTable"));
                        }
                    } else {
                        this.maxValues = new Object[sortedColCount];
                        tableMaxValues = this.maxValues;
                        System.arraycopy(vals, 0, tableMaxValues, 0, sortedColCount);
                    }
                }
                seq.add(r);
                System.arraycopy(vals, 0, lastValues, 0, sortedColCount);
                ++recCount;
            }
            data = cursor.fetch(ICursor.FETCHCOUNT);
        }
        if (seq.length() > 0) {
            this.appendDataBlock(seq, 1, seq.length());
        }
    }

    @Override
    public void append(ICursor cursor) throws IOException {
        if (cursor == null) {
            return;
        }
        this.getGroupTable().checkWritable();
        Sequence data = cursor.peek(MIN_BLOCK_RECORD_COUNT);
        if (data == null || data.length() <= 0) {
            return;
        }
        DataStruct ds = data.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        String[] colNames = this.getAllColNames();
        int count = colNames.length;
        for (int i = 0; i < count; ++i) {
            if (ds.getFieldName(i).equals(colNames[i])) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        if (data.length() < MIN_BLOCK_RECORD_COUNT) {
            if (this.appendCache == null) {
                this.appendCache = data;
            } else {
                this.appendCache.addAll(data);
            }
            data = null;
            cursor.close();
            if (this.appendCache.length() >= MIN_BLOCK_RECORD_COUNT) {
                this.appendCache();
            }
            return;
        }
        if (this.appendCache != null) {
            ICursor[] cursorArray = new ICursor[]{new MemoryCursor(this.appendCache), cursor};
            cursor = new ConjxCursor(cursorArray);
            this.appendCache = null;
        }
        this.prepareAppend();
        if (this.parent != null) {
            this.parent.appendCache();
            this._$3(cursor);
        } else if (this.sortedColNames == null) {
            this._$4(cursor);
        } else if (this.groupTable.baseTable.getSegmentCol() == null) {
            this._$1(cursor);
        } else {
            this._$2(cursor);
        }
        this.finishAppend();
    }

    protected void appendSegmentBlock(int recordCount) throws IOException {
        ++this.dataBlockCount;
        this.totalRecordCount += (long)recordCount;
        this.objectWriter.writeInt32(recordCount);
    }

    int _$1(String name) {
        if (this.sortedColNames != null) {
            int len = this.sortedColNames.length;
            for (int i = 0; i < len; ++i) {
                if (this.sortedColNames[i] != name) continue;
                return i;
            }
            return len;
        }
        return 0;
    }

    @Override
    public ICursor cursor() {
        this.getGroupTable().checkReadable();
        RowCursor cs = new RowCursor(this);
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd == null) {
            return cs;
        }
        ICursor cs2 = tmd.cursor();
        return this._$1((ICursor)cs, cs2);
    }

    @Override
    public ICursor cursor(String[] fields) {
        this.getGroupTable().checkReadable();
        RowCursor cs = new RowCursor(this, fields);
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd == null) {
            return cs;
        }
        ICursor cs2 = tmd.cursor(fields);
        return this._$1((ICursor)cs, cs2);
    }

    @Override
    public ICursor cursor(String[] fields, Expression exp, Context ctx) {
        this.getGroupTable().checkReadable();
        RowCursor cs = new RowCursor(this, fields, exp, ctx);
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd == null) {
            return cs;
        }
        ICursor cs2 = tmd.cursor(fields, exp, ctx);
        return this._$1((ICursor)cs, cs2);
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, Context ctx) {
        this.getGroupTable().checkReadable();
        RowCursor cs = new RowCursor(this, null, filter, exps, fields, ctx);
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd == null) {
            return cs;
        }
        ICursor cs2 = tmd.cursor(exps, fields, filter, null, null, null, null, ctx);
        return this._$1((ICursor)cs, cs2);
    }

    public ICursor cursor(String[] fields, Expression filter, Context ctx, int segSeq, int segCount) {
        this.getGroupTable().checkReadable();
        return this.cursor(null, fields, filter, ctx, segSeq, segCount);
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, Context ctx, int segSeq, int segCount) {
        String[] fetchFields;
        this.getGroupTable().checkReadable();
        if (filter != null) {
            filter = filter.newExpression(ctx);
        }
        if (exps != null) {
            int colCount = exps.length;
            fetchFields = new String[colCount];
            for (int i = 0; i < colCount; ++i) {
                if (exps[i] == null) {
                    exps[i] = Expression.NULL;
                }
                if (!(exps[i].getHome() instanceof UnknownSymbol)) continue;
                fetchFields[i] = exps[i].getIdentifierName();
            }
        } else {
            fetchFields = fields;
            fields = null;
        }
        RowCursor cursor = new RowCursor(this, fetchFields, filter, exps, fields, ctx);
        if (segCount < 2) {
            return cursor;
        }
        int startBlock = 0;
        int endBlock = -1;
        int avg = this.dataBlockCount / segCount;
        if (avg < 1) {
            if (segSeq <= this.dataBlockCount) {
                startBlock = segSeq - 1;
                endBlock = segSeq;
            }
        } else if (segSeq > 1) {
            endBlock = segSeq * avg;
            startBlock = endBlock - avg;
            int mod = this.dataBlockCount % segCount;
            int n = mod - (segCount - segSeq);
            if (n > 0) {
                endBlock += n;
                startBlock += n - 1;
            }
        } else {
            endBlock = avg;
        }
        cursor.setSegment(startBlock, endBlock);
        return cursor;
    }

    public ICursor cursor(String[] fields, Expression exp, MultipathCursors mcs, Context ctx) {
        this.getGroupTable().checkReadable();
        MessageManager mm = EngineMessage.get();
        throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
    }

    public ICursor cursor(String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, Context ctx) {
        if (fkNames == null) {
            return this.cursor(fields, filter, ctx);
        }
        throw new RQException("K:T param is unimplemented in row group table!");
    }

    public ICursor cursor(String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, Context ctx, int pathCount) {
        if (fkNames == null) {
            return this.cursor(fields, filter, ctx, pathCount);
        }
        throw new RQException("K:T param is unimplemented in row group table!");
    }

    public ICursor cursor(String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, Context ctx, int pathSeq, int pathCount) {
        if (fkNames == null) {
            return this.cursor(fields, filter, ctx, pathSeq, pathCount);
        }
        throw new RQException("K:T param is unimplemented in row group table!");
    }

    @Override
    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, String opt, Context ctx) {
        if (fkNames == null) {
            return this.cursor(exps, fields, filter, ctx);
        }
        throw new RQException("K:T param is unimplemented in row group table!");
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, Context ctx, int pathCount) {
        if (fkNames == null) {
            return this.cursor(exps, fields, filter, ctx, pathCount);
        }
        throw new RQException("K:T param is unimplemented in row group table!");
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, Context ctx, int pathSeq, int pathCount) {
        if (fkNames == null) {
            return this.cursor(exps, fields, filter, ctx, pathSeq, pathCount);
        }
        throw new RQException("K:T param is unimplemented in row group table!");
    }

    public ICursor cursor(String[] fields, Expression exp, String[] fkNames, Sequence[] codes, String[] opts, MultipathCursors mcs, String opt, Context ctx) {
        if (fkNames == null) {
            return this.cursor(fields, exp, mcs, ctx);
        }
        throw new RQException("K:T param is unimplemented in row group table!");
    }

    private Sequence _$1(PhyTable stmd, Sequence data, String opt) throws IOException {
        Object r;
        DataStruct ds;
        boolean isUpdate = true;
        boolean isInsert = true;
        Sequence result = null;
        if (opt != null) {
            if (opt.indexOf(105) != -1) {
                isUpdate = false;
            }
            if (opt.indexOf(117) != -1) {
                if (!isUpdate) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(opt + mm.getMessage("engine.optConflict"));
                }
                isInsert = false;
            }
            if (opt.indexOf(110) != -1) {
                result = new Sequence();
            }
        }
        if ((ds = data.dataStruct()) == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        if (!ds.isCompatible(this.ds)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        data.sortFields(this.getAllSortedColNames());
        this.appendCache();
        String[] columns = this.getAllSortedColNames();
        int keyCount = columns.length;
        int[] keyIndex = new int[keyCount];
        for (int k = 0; k < keyCount; ++k) {
            keyIndex[k] = ds.getFieldIndex(columns[k]);
            if (keyIndex[k] >= 0) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(columns[k] + mm.getMessage("ds.fieldNotExist"));
        }
        boolean isPrimaryTable = this.parent == null;
        int len = data.length();
        long[] seqs = new long[len + 1];
        int[] block = new int[len + 1];
        long[] recNum = null;
        int[] temp = new int[1];
        if (isPrimaryTable) {
            Record r2;
            int i;
            llIIllIllIIIIIlI searcher = new llIIllIllIIIIIlI(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (i = 1; i <= len; ++i) {
                    r2 = (Record)data.getMem(i);
                    seqs[i] = searcher.findNext(r2.getFieldValue(k));
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                for (i = 1; i <= len; ++i) {
                    r2 = (Record)data.getMem(i);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = r2.getFieldValue(keyIndex[k]);
                    }
                    seqs[i] = searcher.findNext(keyValues);
                }
            }
        } else {
            recNum = new long[len + 1];
            RowPhyTable baseTable = (RowPhyTable)this.groupTable.baseTable;
            llIIllIllIIIIIlI baseSearcher = new llIIllIllIIIIIlI(baseTable);
            IllllIIlIIllIlll searcher = new IllllIIlIIllIlll(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (int i = 1; i <= len; ++i) {
                    r = (Record)data.getMem(i);
                    seqs[i] = searcher.findNext(((Record)r).getFieldValue(k), temp);
                    block[i] = temp[0];
                    if (seqs[i] < 0L) {
                        long seq = baseSearcher.findNext(((Record)r).getFieldValue(k));
                        if (seq > 0L) {
                            recNum[i] = seq;
                            continue;
                        }
                        if (baseSearcher._$1()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(((Record)r).toString(null) + mm.getMessage("grouptable.invalidData"));
                        }
                        recNum[i] = 0L;
                        continue;
                    }
                    recNum[i] = searcher._$1();
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                int baseKeyCount = this.sortedColStartIndex;
                Object[] baseKeyValues = new Object[baseKeyCount];
                for (int i = 1; i <= len; ++i) {
                    Record r3 = (Record)data.getMem(i);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = r3.getFieldValue(keyIndex[k]);
                        if (k >= baseKeyCount) continue;
                        baseKeyValues[k] = keyValues[k];
                    }
                    seqs[i] = searcher.findNext(keyValues, temp);
                    block[i] = temp[0];
                    if (seqs[i] < 0L || block[i] > 0) {
                        long seq = baseSearcher.findNext(baseKeyValues);
                        if (seq > 0L) {
                            recNum[i] = seq;
                            continue;
                        }
                        if (baseSearcher._$1()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(r3.toString(null) + mm.getMessage("grouptable.invalidData"));
                        }
                        recNum[i] = 0L;
                        continue;
                    }
                    recNum[i] = searcher._$1();
                }
            }
        }
        Sequence append = new Sequence();
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        boolean needUpdateSubTable = false;
        if (modifyRecords == null) {
            this.modifyRecords = modifyRecords = new ArrayList(len);
            for (int i = 1; i <= len; ++i) {
                Record sr = (Record)data.getMem(i);
                if (seqs[i] > 0L) {
                    if (!isUpdate) continue;
                    r = new ModifyRecord(seqs[i], 0, sr);
                    modifyRecords.add((ModifyRecord)r);
                    if (result == null) continue;
                    result.add(sr);
                    continue;
                }
                append.add(sr);
            }
        } else {
            int srcLen = modifyRecords.size();
            ArrayList<ModifyRecord> tmp = new ArrayList<ModifyRecord>(len + srcLen);
            int s = 0;
            int t = 1;
            while (s < srcLen && t <= len) {
                ModifyRecord mr = modifyRecords.get(s);
                long seq1 = mr.getRecordSeq();
                long seq2 = seqs[t];
                if (seq2 > 0L) {
                    if (seq1 < seq2) {
                        ++s;
                        tmp.add(mr);
                        continue;
                    }
                    if (seq1 == seq2) {
                        if (mr.getState() == 1) {
                            ++s;
                            tmp.add(mr);
                            continue;
                        }
                        if (mr.getState() == 0 && isUpdate || mr.getState() == -1 && isInsert) {
                            Record sr = (Record)data.getMem(t);
                            mr.setRecord(sr, 0);
                            if (result != null) {
                                result.add(sr);
                            }
                        }
                        ++s;
                        ++t;
                        tmp.add(mr);
                        continue;
                    }
                    if (isUpdate) {
                        Record sr = (Record)data.getMem(t);
                        mr = new ModifyRecord(seq2, 0, sr);
                        tmp.add(mr);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                    ++t;
                    continue;
                }
                if (seq1 < (seq2 = -seq2)) {
                    ++s;
                    tmp.add(mr);
                    continue;
                }
                if (seq1 == seq2) {
                    if (mr.getState() == 1) {
                        int cmp = mr.getRecord().compare((BaseRecord)((Record)data.getMem(t)), keyIndex);
                        if (cmp < 0) {
                            ++s;
                            tmp.add(mr);
                            continue;
                        }
                        if (cmp == 0) {
                            if (isUpdate) {
                                Record sr = (Record)data.getMem(t);
                                mr.setRecord(sr);
                                if (result != null) {
                                    result.add(sr);
                                }
                            }
                            tmp.add(mr);
                            ++s;
                            ++t;
                            continue;
                        }
                        append.add(data.getMem(t));
                        ++t;
                        continue;
                    }
                    append.add(data.getMem(t));
                    ++t;
                    continue;
                }
                append.add(data.getMem(t));
                ++t;
            }
            while (s < srcLen) {
                tmp.add(modifyRecords.get(s));
                ++s;
            }
            while (t <= len) {
                Record sr = (Record)data.getMem(t);
                if (seqs[t] > 0L) {
                    if (isUpdate) {
                        ModifyRecord r4 = new ModifyRecord(seqs[t], 0, sr);
                        tmp.add(r4);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                } else {
                    append.add(sr);
                }
                ++t;
            }
            this.modifyRecords = tmp;
            if (srcLen != tmp.size()) {
                needUpdateSubTable = true;
            }
        }
        if (!isPrimaryTable) {
            this._$1(this.parent.getModifyRecords());
            for (ModifyRecord r5 : modifyRecords) {
                if (r5.getState() != 1 || r5.getParentRecordSeq() != 0L) continue;
                this.modifyRecords = null;
                this.modifyRecords = this.getModifyRecords();
                MessageManager mm = EngineMessage.get();
                throw new RQException(r5.getRecord().toString(null) + mm.getMessage("grouptable.invalidData"));
            }
        }
        this.saveModifyRecords();
        if (isPrimaryTable && needUpdateSubTable) {
            ArrayList<PhyTable> tableList = this.getTableList();
            int size = tableList.size();
            for (int i = 0; i < size; ++i) {
                RowPhyTable t = (RowPhyTable)tableList.get(i);
                boolean needSave = t._$1(modifyRecords);
                if (!needSave) continue;
                t.saveModifyRecords();
            }
        }
        if (append.length() > 0) {
            Sequence seq = stmd.update(append, opt);
            if (result != null) {
                result.addAll(seq);
            }
        }
        this.groupTable._$3();
        return result;
    }

    @Override
    public Sequence update(Sequence data, String opt) throws IOException {
        Object r;
        long totalRecordCount;
        if (!this.hasPrimaryKey) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.lessKey"));
        }
        ComTable groupTable = this.getGroupTable();
        groupTable.checkWritable();
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd != null) {
            return this._$1(tmd, data, opt);
        }
        boolean isInsert = true;
        boolean isUpdate = true;
        Sequence result = null;
        if (opt != null) {
            if (opt.indexOf(105) != -1) {
                isUpdate = false;
            }
            if (opt.indexOf(117) != -1) {
                if (!isUpdate) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(opt + mm.getMessage("engine.optConflict"));
                }
                isInsert = false;
            }
            if (opt.indexOf(110) != -1) {
                result = new Sequence();
            }
        }
        if ((totalRecordCount = this.totalRecordCount) == 0L) {
            if (isInsert) {
                MemoryCursor cursor = new MemoryCursor(data);
                this.append(cursor);
                this.appendCache();
                if (result != null) {
                    result.addAll(data);
                }
            }
            return result;
        }
        DataStruct ds = data.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        if (!ds.isCompatible(this.ds)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        data.sortFields(this.getAllSortedColNames());
        this.appendCache();
        String[] columns = this.getAllSortedColNames();
        int keyCount = columns.length;
        int[] keyIndex = new int[keyCount];
        for (int k = 0; k < keyCount; ++k) {
            keyIndex[k] = ds.getFieldIndex(columns[k]);
            if (keyIndex[k] >= 0) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(columns[k] + mm.getMessage("ds.fieldNotExist"));
        }
        boolean isPrimaryTable = this.parent == null;
        int len = data.length();
        long[] seqs = new long[len + 1];
        int[] block = new int[len + 1];
        long[] recNum = null;
        int[] temp = new int[1];
        if (isPrimaryTable) {
            Record r2;
            int i;
            llIIllIllIIIIIlI searcher = new llIIllIllIIIIIlI(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (i = 1; i <= len; ++i) {
                    r2 = (Record)data.getMem(i);
                    seqs[i] = searcher.findNext(r2.getFieldValue(k));
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                for (i = 1; i <= len; ++i) {
                    r2 = (Record)data.getMem(i);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = r2.getFieldValue(keyIndex[k]);
                    }
                    seqs[i] = searcher.findNext(keyValues);
                }
            }
        } else {
            recNum = new long[len + 1];
            RowPhyTable baseTable = (RowPhyTable)this.groupTable.baseTable;
            llIIllIllIIIIIlI baseSearcher = new llIIllIllIIIIIlI(baseTable);
            IllllIIlIIllIlll searcher = new IllllIIlIIllIlll(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (int i = 1; i <= len; ++i) {
                    Record r3 = (Record)data.getMem(i);
                    seqs[i] = searcher.findNext(r3.getFieldValue(k), temp);
                    block[i] = temp[0];
                    if (seqs[i] < 0L) {
                        long seq = baseSearcher.findNext(r3.getFieldValue(k));
                        if (seq > 0L) {
                            recNum[i] = seq;
                            continue;
                        }
                        if (baseSearcher._$1()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(r3.toString(null) + mm.getMessage("grouptable.invalidData"));
                        }
                        recNum[i] = 0L;
                        continue;
                    }
                    recNum[i] = searcher._$1();
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                int baseKeyCount = this.sortedColStartIndex;
                Object[] baseKeyValues = new Object[baseKeyCount];
                for (int i = 1; i <= len; ++i) {
                    r = (Record)data.getMem(i);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = ((Record)r).getFieldValue(keyIndex[k]);
                        if (k >= baseKeyCount) continue;
                        baseKeyValues[k] = keyValues[k];
                    }
                    seqs[i] = searcher.findNext(keyValues, temp);
                    block[i] = temp[0];
                    if (seqs[i] < 0L || block[i] > 0) {
                        long seq = baseSearcher.findNext(baseKeyValues);
                        if (seq > 0L) {
                            recNum[i] = seq;
                            continue;
                        }
                        if (baseSearcher._$1()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(((Record)r).toString(null) + mm.getMessage("grouptable.invalidData"));
                        }
                        recNum[i] = 0L;
                        continue;
                    }
                    recNum[i] = searcher._$1();
                }
            }
        }
        Sequence append = new Sequence();
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        boolean needUpdateSubTable = false;
        if (modifyRecords == null) {
            this.modifyRecords = modifyRecords = new ArrayList(len);
            for (int i = 1; i <= len; ++i) {
                Record sr = (Record)data.getMem(i);
                if (seqs[i] > 0L) {
                    if (!isUpdate) continue;
                    ModifyRecord r4 = new ModifyRecord(seqs[i], 0, sr);
                    if (!isPrimaryTable) {
                        r4.setParentRecordSeq(recNum[i]);
                    }
                    modifyRecords.add(r4);
                    if (result == null) continue;
                    result.add(sr);
                    continue;
                }
                if (!isInsert) continue;
                long seq = -seqs[i];
                if (seq <= totalRecordCount || block[i] > 0) {
                    r = new ModifyRecord(seq, 1, sr);
                    ((ModifyRecord)r).setBlock(block[i]);
                    if (!isPrimaryTable) {
                        ((ModifyRecord)r).setParentRecordSeq(recNum[i]);
                    }
                    modifyRecords.add((ModifyRecord)r);
                } else {
                    append.add(sr);
                }
                if (result == null) continue;
                result.add(sr);
            }
        } else {
            int srcLen = modifyRecords.size();
            ArrayList<ModifyRecord> tmp = new ArrayList<ModifyRecord>(len + srcLen);
            int s = 0;
            int t = 1;
            while (s < srcLen && t <= len) {
                ModifyRecord mr = modifyRecords.get(s);
                long seq1 = mr.getRecordSeq();
                long seq2 = seqs[t];
                if (seq2 > 0L) {
                    if (seq1 < seq2) {
                        ++s;
                        tmp.add(mr);
                        continue;
                    }
                    if (seq1 == seq2) {
                        if (mr.getState() == 1) {
                            ++s;
                            tmp.add(mr);
                            continue;
                        }
                        if (mr.getState() == 0 && isUpdate || mr.getState() == -1 && isInsert) {
                            Record sr = (Record)data.getMem(t);
                            mr.setRecord(sr, 0);
                            if (!isPrimaryTable) {
                                mr.setParentRecordSeq(recNum[t]);
                            }
                            if (result != null) {
                                result.add(sr);
                            }
                        }
                        ++s;
                        ++t;
                        tmp.add(mr);
                        continue;
                    }
                    if (isUpdate) {
                        Record sr = (Record)data.getMem(t);
                        mr = new ModifyRecord(seq2, 0, sr);
                        if (!isPrimaryTable) {
                            mr.setParentRecordSeq(recNum[t]);
                        }
                        tmp.add(mr);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                    ++t;
                    continue;
                }
                if (seq1 < (seq2 = -seq2)) {
                    ++s;
                    tmp.add(mr);
                    continue;
                }
                if (seq1 == seq2) {
                    if (mr.getState() == 1) {
                        Record sr;
                        int cmp = mr.getRecord().compare((BaseRecord)((Record)data.getMem(t)), keyIndex);
                        if (cmp < 0) {
                            ++s;
                            tmp.add(mr);
                            continue;
                        }
                        if (cmp == 0) {
                            if (isUpdate) {
                                sr = (Record)data.getMem(t);
                                mr.setRecord(sr);
                                if (result != null) {
                                    result.add(sr);
                                }
                            }
                            tmp.add(mr);
                            ++s;
                            ++t;
                            continue;
                        }
                        if (isInsert) {
                            sr = (Record)data.getMem(t);
                            mr = new ModifyRecord(seq2, 1, sr);
                            mr.setBlock(block[t]);
                            if (!isPrimaryTable) {
                                mr.setParentRecordSeq(recNum[t]);
                            }
                            modifyRecords.add(mr);
                            tmp.add(mr);
                            if (result != null) {
                                result.add(sr);
                            }
                        }
                        ++t;
                        continue;
                    }
                    if (isInsert) {
                        Record sr = (Record)data.getMem(t);
                        mr = new ModifyRecord(seq2, 1, sr);
                        mr.setBlock(block[t]);
                        if (!isPrimaryTable) {
                            mr.setParentRecordSeq(recNum[t]);
                        }
                        modifyRecords.add(mr);
                        tmp.add(mr);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                    ++t;
                    continue;
                }
                if (isInsert) {
                    Record sr = (Record)data.getMem(t);
                    mr = new ModifyRecord(seq2, 1, sr);
                    mr.setBlock(block[t]);
                    if (!isPrimaryTable) {
                        mr.setParentRecordSeq(recNum[t]);
                    }
                    modifyRecords.add(mr);
                    tmp.add(mr);
                    if (result != null) {
                        result.add(sr);
                    }
                }
                ++t;
            }
            while (s < srcLen) {
                tmp.add(modifyRecords.get(s));
                ++s;
            }
            while (t <= len) {
                Record sr = (Record)data.getMem(t);
                if (seqs[t] > 0L) {
                    if (isUpdate) {
                        ModifyRecord r5 = new ModifyRecord(seqs[t], 0, sr);
                        tmp.add(r5);
                        if (result != null) {
                            result.add(sr);
                        }
                    }
                } else if (isInsert) {
                    long seq = -seqs[t];
                    if (seq <= totalRecordCount) {
                        ModifyRecord r6 = new ModifyRecord(seq, 1, sr);
                        r6.setBlock(block[t]);
                        if (!isPrimaryTable) {
                            r6.setParentRecordSeq(recNum[t]);
                        }
                        modifyRecords.add(r6);
                        tmp.add(r6);
                    } else {
                        append.add(sr);
                    }
                    if (result != null) {
                        result.add(sr);
                    }
                }
                ++t;
            }
            this.modifyRecords = tmp;
            if (srcLen != tmp.size()) {
                needUpdateSubTable = true;
            }
        }
        if (!isPrimaryTable) {
            this._$1(this.parent.getModifyRecords());
            for (ModifyRecord r7 : modifyRecords) {
                if (r7.getState() != 1 || r7.getParentRecordSeq() != 0L) continue;
                this.modifyRecords = null;
                this.modifyRecords = this.getModifyRecords();
                MessageManager mm = EngineMessage.get();
                throw new RQException(r7.getRecord().toString(null) + mm.getMessage("grouptable.invalidData"));
            }
        }
        this.saveModifyRecords();
        if (isPrimaryTable && needUpdateSubTable) {
            ArrayList<PhyTable> tableList = this.getTableList();
            int size = tableList.size();
            for (int i = 0; i < size; ++i) {
                RowPhyTable t = (RowPhyTable)tableList.get(i);
                boolean needSave = t._$1(modifyRecords);
                if (!needSave) continue;
                t.saveModifyRecords();
            }
        }
        if (append.length() > 0) {
            MemoryCursor cursor = new MemoryCursor(append);
            this.append(cursor);
        } else {
            groupTable._$3();
        }
        return result;
    }

    @Override
    public Sequence delete(Sequence data, String opt) throws IOException {
        int i;
        Object r;
        int i2;
        Object searcher;
        boolean isPrimaryTable;
        DataStruct ds;
        if (!this.hasPrimaryKey) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.lessKey"));
        }
        ComTable groupTable = this.getGroupTable();
        groupTable.checkWritable();
        Sequence result1 = null;
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd != null) {
            result1 = tmd.delete(data, "n");
            data = data.diff(result1, false);
        }
        this.appendCache();
        boolean nopt = opt != null && opt.indexOf(110) != -1;
        long totalRecordCount = this.totalRecordCount;
        if (totalRecordCount == 0L || data == null || data.length() == 0) {
            return nopt ? result1 : null;
        }
        Sequence result = null;
        if (nopt) {
            result = new Sequence();
        }
        boolean deleteByBaseKey = false;
        if (opt != null && opt.indexOf(115) != -1) {
            deleteByBaseKey = true;
        }
        if ((ds = data.dataStruct()) == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        String[] columns = this.getAllSortedColNames();
        int keyCount = columns.length;
        if (deleteByBaseKey) {
            keyCount = this.sortedColStartIndex;
        }
        int[] keyIndex = new int[keyCount];
        for (int k = 0; k < keyCount; ++k) {
            keyIndex[k] = ds.getFieldIndex(columns[k]);
            if (keyIndex[k] >= 0) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(columns[k] + mm.getMessage("ds.fieldNotExist"));
        }
        boolean bl = isPrimaryTable = this.parent == null;
        if (deleteByBaseKey) {
            data.sortFields(this.parent.getSortedColNames());
        } else {
            data.sortFields(this.getAllSortedColNames());
        }
        int len = data.length();
        long[] seqs = new long[len + 1];
        int[] temp = new int[1];
        LongArray seqList = null;
        Sequence seqListData = null;
        if (deleteByBaseKey) {
            seqList = new LongArray(len * 10);
            seqList.add(0L);
            seqListData = new Sequence(len);
        }
        if (isPrimaryTable) {
            searcher = new llIIllIllIIIIIlI(this);
            if (keyCount == 1) {
                int k = keyIndex[0];
                for (i2 = 1; i2 <= len; ++i2) {
                    r = (Record)data.getMem(i2);
                    seqs[i2] = ((llIIllIllIIIIIlI)searcher).findNext(((Record)r).getFieldValue(k));
                }
            } else {
                Object[] keyValues = new Object[keyCount];
                for (i2 = 1; i2 <= len; ++i2) {
                    r = (Record)data.getMem(i2);
                    for (int k = 0; k < keyCount; ++k) {
                        keyValues[k] = ((Record)r).getFieldValue(keyIndex[k]);
                    }
                    seqs[i2] = ((llIIllIllIIIIIlI)searcher).findNext(keyValues);
                }
            }
        } else {
            searcher = new IllllIIlIIllIlll(this);
            Object[] keyValues = new Object[keyCount];
            int baseKeyCount = this.sortedColStartIndex;
            Object[] baseKeyValues = new Object[baseKeyCount];
            i = 1;
            while (i <= len) {
                Record r2 = (Record)data.getMem(i);
                for (int k = 0; k < keyCount; ++k) {
                    keyValues[k] = r2.getFieldValue(keyIndex[k]);
                    if (k >= baseKeyCount) continue;
                    baseKeyValues[k] = keyValues[k];
                }
                if (deleteByBaseKey) {
                    long s = ((IllllIIlIIllIlll)searcher).findNext(keyValues, keyCount);
                    if (s <= 0L) {
                        ++i;
                        continue;
                    }
                    seqList.add(s);
                    seqListData.add(r2);
                    continue;
                }
                seqs[i] = ((IllllIIlIIllIlll)searcher).findNext(keyValues, temp);
                ++i;
            }
        }
        if (deleteByBaseKey) {
            len = seqList.size() - 1;
            if (0 == len) {
                return result;
            }
            seqs = seqList.toArray();
            data = seqListData;
        }
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        boolean modified = true;
        if (modifyRecords == null) {
            modifyRecords = new ArrayList(len);
            for (i2 = 1; i2 <= len; ++i2) {
                if (seqs[i2] <= 0L) continue;
                r = new ModifyRecord(seqs[i2]);
                modifyRecords.add((ModifyRecord)r);
                if (result == null) continue;
                result.add(data.getMem(i2));
            }
            if (modifyRecords.size() > 0) {
                this.modifyRecords = modifyRecords;
            } else {
                modified = false;
            }
        } else {
            int srcLen = modifyRecords.size();
            ArrayList<ModifyRecord> tmp = new ArrayList<ModifyRecord>(len + srcLen);
            int s = 0;
            int t = 1;
            while (s < srcLen && t <= len) {
                int cmp;
                ModifyRecord mr = modifyRecords.get(s);
                long seq1 = mr.getRecordSeq();
                long seq2 = seqs[t];
                if (seq2 > 0L) {
                    if (seq1 < seq2) {
                        ++s;
                    } else if (seq1 == seq2) {
                        if (mr.getState() == 1) {
                            cmp = mr.getRecord().compare((BaseRecord)((Record)data.getMem(t)), keyIndex);
                            if (cmp < 0) {
                                tmp.add(mr);
                            } else if (cmp == 0) {
                                if (result != null) {
                                    result.add(data.getMem(t));
                                }
                            } else {
                                if (result != null) {
                                    result.add(data.getMem(t));
                                }
                                ModifyRecord r3 = new ModifyRecord(seqs[t]);
                                tmp.add(r3);
                                tmp.add(mr);
                                ++t;
                            }
                            ++s;
                            continue;
                        }
                        if (result != null && mr.getState() == 0) {
                            result.add(data.getMem(t));
                        }
                        mr.setDelete();
                        ++s;
                        ++t;
                    } else {
                        mr = new ModifyRecord(seq2);
                        if (result != null) {
                            result.add(data.getMem(t));
                        }
                        ++t;
                    }
                    tmp.add(mr);
                    continue;
                }
                if (seq1 < (seq2 = -seq2)) {
                    ++s;
                    tmp.add(mr);
                    continue;
                }
                if (seq1 == seq2) {
                    if (mr.getState() == 1) {
                        cmp = mr.getRecord().compare((BaseRecord)((Record)data.getMem(t)), keyIndex);
                        if (cmp < 0) {
                            ++s;
                            tmp.add(mr);
                            continue;
                        }
                        if (cmp == 0) {
                            if (result != null) {
                                result.add(data.getMem(t));
                            }
                            ++s;
                            ++t;
                            continue;
                        }
                        ++t;
                        continue;
                    }
                    ++s;
                    ++t;
                    tmp.add(mr);
                    continue;
                }
                ++t;
            }
            while (s < srcLen) {
                tmp.add(modifyRecords.get(s));
                ++s;
            }
            while (t <= len) {
                if (seqs[t] > 0L) {
                    if (result != null) {
                        result.add(data.getMem(t));
                    }
                    ModifyRecord r4 = new ModifyRecord(seqs[t]);
                    tmp.add(r4);
                }
                ++t;
            }
            this.modifyRecords = tmp;
        }
        if (modified) {
            if (isPrimaryTable) {
                ArrayList<PhyTable> tableList = this.getTableList();
                int size = tableList.size();
                for (i = 0; i < size; ++i) {
                    RowPhyTable t = (RowPhyTable)tableList.get(i);
                    t.delete(data, "s");
                    t._$1(data);
                }
                for (i = 0; i < size; ++i) {
                    RowPhyTable t = (RowPhyTable)tableList.get(i);
                    t._$1(this.modifyRecords);
                    t.saveModifyRecords();
                }
            }
            if (!deleteByBaseKey) {
                this.saveModifyRecords();
            }
        }
        if (!deleteByBaseKey) {
            groupTable._$3();
        }
        if (nopt) {
            result.addAll(result1);
        }
        return result;
    }

    private boolean _$1(ArrayList<ModifyRecord> baseModifyRecords) throws IOException {
        this.getGroupTable().checkWritable();
        if (baseModifyRecords == null) {
            return false;
        }
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        if (modifyRecords == null) {
            return false;
        }
        int len = this.sortedColStartIndex;
        int[] index = new int[len];
        int[] findex = this.getSortedColIndex();
        for (int i = 0; i < len; ++i) {
            index[i] = findex[i];
        }
        boolean find = false;
        int parentRecordSeq = 0;
        for (ModifyRecord mr : baseModifyRecords) {
            ++parentRecordSeq;
            Record mrec = mr.getRecord();
            if (mr.getState() == -1) continue;
            for (ModifyRecord r : modifyRecords) {
                Record rec;
                int cmp;
                if (r.getState() == -1 || (cmp = (rec = r.getRecord()).compare((BaseRecord)mrec, index)) != 0) continue;
                if (mr.getState() == 1) {
                    r.setParentRecordSeq(-parentRecordSeq);
                } else {
                    r.setParentRecordSeq(mr.getRecordSeq());
                }
                find = true;
            }
        }
        return find;
    }

    private boolean _$1(Sequence data) throws IOException {
        ArrayList<ModifyRecord> tmp = new ArrayList<ModifyRecord>();
        ArrayList<ModifyRecord> srcModifyRecords = new ArrayList<ModifyRecord>();
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        if (modifyRecords == null) {
            return false;
        }
        tmp.addAll(modifyRecords);
        int len = this.sortedColStartIndex;
        int[] index = new int[len];
        int[] findex = this.getSortedColIndex();
        for (int i = 0; i < len; ++i) {
            index[i] = findex[i];
        }
        len = data.length();
        boolean delete = false;
        for (int i = 1; i <= len; ++i) {
            Record mrec = (Record)data.get(i);
            srcModifyRecords.clear();
            srcModifyRecords.addAll(tmp);
            tmp.clear();
            for (ModifyRecord r : srcModifyRecords) {
                int cmp;
                Record rec;
                int state = r.getState();
                if (state == 0) {
                    rec = r.getRecord();
                    cmp = rec.compare((BaseRecord)mrec, index);
                    if (cmp == 0) {
                        r.setDelete();
                        r.setRecord(null);
                        delete = true;
                    }
                    tmp.add(r);
                    continue;
                }
                if (state == 1) {
                    rec = r.getRecord();
                    cmp = rec.compare((BaseRecord)mrec, index);
                    if (cmp == 0) {
                        delete = true;
                        continue;
                    }
                    tmp.add(r);
                    continue;
                }
                tmp.add(r);
            }
        }
        if (delete) {
            this.modifyRecords = tmp;
        }
        return delete;
    }

    public BlockLinkReader getRowReader(boolean isLoadFirstBlock) {
        BlockLinkReader reader = new BlockLinkReader(this.dataBlockLink);
        reader._$2(4096);
        if (isLoadFirstBlock) {
            try {
                reader.loadFirstBlock();
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        return reader;
    }

    public ObjectReader getSegmentObjectReader() {
        BlockLinkReader segmentReader = new BlockLinkReader(this.segmentBlockLink);
        try {
            segmentReader.loadFirstBlock();
            return new ObjectReader(segmentReader, this.groupTable.getBlockSize() - 5);
        }
        catch (IOException e) {
            segmentReader.close();
            throw new RQException(e.getMessage(), e);
        }
    }

    public boolean[] getDimIndex() {
        String[] col = this.getAllColNames();
        boolean[] isDim = new boolean[col.length];
        int len = col.length;
        for (int i = 0; i < len; ++i) {
            isDim[i] = this.isDim(col[i]);
        }
        return isDim;
    }

    public boolean isDim(String colName) {
        boolean[] isDim = this.isDim;
        String[] colNames = this.colNames;
        int len = colNames.length;
        for (int i = 0; i < len; ++i) {
            if (!colName.equals(colNames[i])) continue;
            return isDim[i];
        }
        return false;
    }

    protected boolean isKey(String colName) {
        boolean[] isKey = this.isDim;
        String[] colNames = this.colNames;
        int len = colNames.length;
        for (int i = 0; i < len; ++i) {
            if (!colName.equals(colNames[i])) continue;
            return isKey[i];
        }
        return false;
    }

    protected int getDimCount() {
        boolean[] isDim = this.isDim;
        int len = isDim.length;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (!isDim[i]) continue;
            ++count;
        }
        return count;
    }

    protected int getKeyCount() {
        boolean[] isKey = this.isKey;
        int len = isKey.length;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (!isKey[i]) continue;
            ++count;
        }
        return count;
    }

    protected int getSerialBytesLen(int index) {
        return this.serialBytesLen[index];
    }

    @Override
    public int[] getSerialBytesLen() {
        return this.serialBytesLen;
    }

    @Override
    public String[] getAllSortedColNames() {
        if (this.parent == null) {
            return this.getSortedColNames();
        }
        return this._$2;
    }

    public String[] getTotalColNames() {
        if (this.parent == null) {
            return this.colNames;
        }
        int len = this.getTotalColCount();
        int baseColCount = this.parent.colNames.length;
        String[] names = new String[len];
        System.arraycopy(this.parent.colNames, 0, names, 0, baseColCount);
        System.arraycopy(this.colNames, 0, names, baseColCount, this.colNames.length);
        return names;
    }

    public int getTotalColCount() {
        if (this.parent == null) {
            return this.colNames.length;
        }
        return this.parent.colNames.length + this.colNames.length;
    }

    public int[] getTotalSerialBytesLen() {
        if (this.parent == null) {
            return this.serialBytesLen;
        }
        int len = this.getTotalColCount();
        int[] baseSerialBytesLen = this.parent.getSerialBytesLen();
        int baseColCount = baseSerialBytesLen.length;
        int[] serialBytesLen = new int[len];
        System.arraycopy(baseSerialBytesLen, 0, serialBytesLen, 0, baseColCount);
        System.arraycopy(this.serialBytesLen, 0, serialBytesLen, baseColCount, this.serialBytesLen.length);
        return serialBytesLen;
    }

    public ICursor cursor(String[] fields, Expression filter, Context ctx, int pathCount) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, Context ctx, int pathCount) {
        return this.cursor(exps, fields, filter, null, null, null, pathCount, null, ctx);
    }

    @Override
    public Table finds(Sequence values) throws IOException {
        return this.finds(values, null);
    }

    @Override
    public Table finds(Sequence values, String[] selFields) throws IOException {
        Expression exp;
        this.getGroupTable().checkReadable();
        if (!this.hasPrimaryKey()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.lessKey"));
        }
        String[] keys = this.getAllSortedColNames();
        int keyCount = keys.length;
        Sequence keyValues = values;
        if (keyCount == 1) {
            exp = new Expression("null.contain(" + keys[0] + ")");
            Object obj = values.getMem(1);
            int valueLen = values.length();
            if (valueLen == 0) {
                return null;
            }
            if (obj instanceof Sequence) {
                Sequence seq = (Sequence)obj;
                int dimCount = seq.length();
                if (dimCount > keyCount) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("find" + mm.getMessage("function.invalidParam"));
                }
                keyValues = new Sequence();
                for (int i = 1; i <= valueLen; ++i) {
                    seq = (Sequence)values.getMem(i);
                    keyValues.add(seq.getMem(1));
                }
            }
        } else {
            String str = "null.contain([";
            for (int i = 0; i < keyCount; ++i) {
                str = str + keys[i];
                if (i == keyCount - 1) continue;
                str = str + ",";
            }
            str = str + "])";
            exp = new Expression(str);
        }
        Context ctx = new Context();
        exp.getHome().setLeft(new Constant(keyValues));
        Sequence result = this.cursor(selFields, exp, ctx).fetch();
        if (result == null) {
            return null;
        }
        Table table = new Table(result.dataStruct());
        table.addAll(result);
        return table;
    }

    @Override
    public int getFirstBlockFromModifyRecord() {
        return 0;
    }

    @Override
    public long resetByBlock(int block) {
        return 0L;
    }

    @Override
    long[] _$1(String field, Node node, Context ctx) {
        if (!this.isDim(field) || this.parent != null) {
            return null;
        }
        int operator = 0;
        if (node instanceof Equals) {
            operator = 1;
        } else if (node instanceof Greater) {
            operator = 2;
        } else if (node instanceof NotSmaller) {
            operator = 3;
        } else if (node instanceof Smaller) {
            operator = 4;
        } else if (node instanceof NotGreater) {
            operator = 5;
        } else if (node instanceof NotEquals) {
            operator = 6;
        } else {
            return null;
        }
        Object value = node.getRight() instanceof UnknownSymbol ? node.getLeft().calculate(ctx) : node.getRight().calculate(ctx);
        int blockCount = this.dataBlockCount;
        ColumnFilter filter = new ColumnFilter(field, 0, operator, value);
        LongArray intervals = new LongArray();
        ObjectReader segmentReader = this.getSegmentObjectReader();
        int index = -1;
        String[] colNames = this.colNames;
        for (int i = 0; i < colNames.length; ++i) {
            if (!field.equals(colNames[i])) continue;
            index = i;
            break;
        }
        try {
            boolean flag = false;
            Object maxValue = null;
            Object minValue = null;
            int keyCount = this.getAllSortedColNamesLength();
            for (int i = 0; i < blockCount; ++i) {
                int recordCount = segmentReader.readInt32();
                long pos = segmentReader.readLong40();
                if (flag) {
                    intervals.add(pos - 1L);
                }
                flag = false;
                for (int k = 0; k < keyCount; ++k) {
                    if (k == index) {
                        minValue = segmentReader.readObject();
                        maxValue = segmentReader.readObject();
                        continue;
                    }
                    segmentReader.skipObject();
                    segmentReader.skipObject();
                }
                if (!filter.match(minValue, maxValue) || recordCount == 1) continue;
                intervals.add(pos);
                flag = true;
            }
            if (flag) {
                intervals.add(this.getGroupTable().fileSize);
            }
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        if (intervals.size() == 0) {
            return null;
        }
        return intervals.toArray();
    }

    @Override
    public void append(ICursor cursor, String opt) throws IOException {
        if (this.isSorted && opt != null) {
            if (opt.indexOf(97) != -1) {
                RowPhyTable ctmd = (RowPhyTable)this.getSupplementTable(true);
                ctmd._$1(cursor, opt);
            } else if (opt.indexOf(109) != -1) {
                this._$1(cursor, opt);
            } else {
                this.append(cursor);
                if (opt.indexOf(105) != -1) {
                    this.appendCache();
                }
            }
        } else {
            this.append(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1(ICursor cursor, String opt) throws IOException {
        if (!this.isSingleTable()) {
            throw new RQException("'append@m' is unimplemented in annex table!");
        }
        Sequence data = cursor.peek(ICursor.FETCHCOUNT);
        if (data == null || data.length() <= 0) {
            return;
        }
        DataStruct ds = data.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        String[] columns = this.colNames;
        int colCount = columns.length;
        if (colCount != ds.getFieldCount()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        for (int i = 0; i < colCount; ++i) {
            if (ds.getFieldName(i).equals(columns[i])) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        RowComTable groupTable = (RowComTable)this.getGroupTable();
        File srcFile = groupTable.getFile();
        File tmpFile = File.createTempFile("tmpdata", "", srcFile.getParentFile());
        try {
            Context ctx = new Context();
            String[] colNames = (String[])this.colNames.clone();
            for (int i = 0; i < colNames.length; ++i) {
                if (!this.isDim[i]) continue;
                colNames[i] = "#" + colNames[i];
            }
            RowComTable tmpGroupTable = new RowComTable(tmpFile, colNames, groupTable.getDistribute(), null, ctx);
            tmpGroupTable.writePswHash = groupTable.writePswHash;
            tmpGroupTable.readPswHash = groupTable.readPswHash;
            PhyTable baseTable = tmpGroupTable.getBaseTable();
            if (this.segmentCol != null) {
                baseTable.setSegmentCol(this.segmentCol, this.segmentSerialLen);
            }
            int dcount = this.sortedColNames.length;
            Expression[] mergeExps = new Expression[dcount];
            for (int i = 0; i < dcount; ++i) {
                mergeExps[i] = new Expression(this.sortedColNames[i]);
            }
            RowCursor srcCursor = new RowCursor(this);
            ICursor[] cursors = new ICursor[]{srcCursor, cursor};
            MergesCursor mergeCursor = new MergesCursor(cursors, mergeExps, ctx);
            baseTable.append(mergeCursor);
            baseTable.close();
            groupTable.raf.close();
            groupTable.file.delete();
            tmpFile.renameTo(groupTable.file);
            groupTable.reopen();
        }
        finally {
            tmpFile.delete();
        }
    }

    @Override
    public void appendCache() throws IOException {
        if (this.appendCache == null) {
            return;
        }
        MemoryCursor cursor = new MemoryCursor(this.appendCache);
        this.prepareAppend();
        if (this.parent != null) {
            this.parent.appendCache();
            this._$3(cursor);
        } else if (this.sortedColNames == null) {
            this._$4(cursor);
        } else if (this.groupTable.baseTable.getSegmentCol() == null) {
            this._$1(cursor);
        } else {
            this._$2(cursor);
        }
        this.finishAppend();
        this.appendCache = null;
    }

    public ICursor cursor(String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, Context ctx, int pathSeq, int pathCount, int pathCount2) {
        this.getGroupTable().checkReadable();
        MessageManager mm = EngineMessage.get();
        throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
    }

    public ICursor cursor(String[] fields, Expression exp, String[] fkNames, Sequence[] codes, String[] opts, ICursor cs, int seg, Object[][] endValues, Context ctx) {
        this.getGroupTable().checkReadable();
        MessageManager mm = EngineMessage.get();
        throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
    }

    @Override
    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int pathCount, String opt, Context ctx) {
        ICursor cs2;
        if (fkNames != null || codes != null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
        }
        if (pathCount < 2) {
            return this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
        }
        PhyTable tmd = this.getSupplementTable(false);
        int blockCount = this.getDataBlockCount();
        if (blockCount == 0) {
            if (tmd == null) {
                return new MemoryCursor(null);
            }
            return tmd.cursor(exps, fields, filter, fkNames, codes, opts, pathCount, opt, ctx);
        }
        int avg = blockCount / pathCount;
        if (avg < 1) {
            avg = 1;
            pathCount = blockCount;
        }
        int mod = blockCount % pathCount;
        ICursor[] cursors = new ICursor[pathCount];
        int start = 0;
        for (int i = 0; i < pathCount; ++i) {
            int end = start + avg;
            if (i < mod) {
                ++end;
            }
            if (filter != null) {
                filter = filter.newExpression(ctx);
            }
            RowCursor cursor = new RowCursor(this, null, filter, exps, fields, ctx);
            cursor.setSegment(start, end);
            cursors[i] = cursor;
            start = end;
        }
        MultipathCursors mcs = new MultipathCursors(cursors, ctx);
        if (tmd == null) {
            return mcs;
        }
        String[] sortFields = ((IDWCursor)cursors[0]).getSortFields();
        if (sortFields != null) {
            cs2 = tmd.cursor(exps, fields, filter, fkNames, codes, opts, mcs, opt, ctx);
            return this._$1(mcs, (MultipathCursors)cs2, sortFields);
        }
        cs2 = tmd.cursor(exps, fields, filter, fkNames, codes, opts, pathCount, opt, ctx);
        return this._$1(mcs, cs2);
    }

    @Override
    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int segSeq, int segCount, String opt, Context ctx) {
        this.getGroupTable().checkReadable();
        if (filter != null) {
            filter = filter.newExpression(ctx);
        }
        RowCursor cursor = new RowCursor(this, null, filter, exps, fields, ctx);
        if (segCount < 2) {
            return cursor;
        }
        int startBlock = 0;
        int endBlock = -1;
        int avg = this.dataBlockCount / segCount;
        if (avg < 1) {
            if (segSeq <= this.dataBlockCount) {
                startBlock = segSeq - 1;
                endBlock = segSeq;
            }
        } else if (segSeq > 1) {
            endBlock = segSeq * avg;
            startBlock = endBlock - avg;
            int mod = this.dataBlockCount % segCount;
            int n = mod - (segCount - segSeq);
            if (n > 0) {
                endBlock += n;
                startBlock += n - 1;
            }
        } else {
            endBlock = avg;
        }
        cursor.setSegment(startBlock, endBlock);
        return cursor;
    }

    @Override
    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, MultipathCursors mcs, String opt, Context ctx) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
    }

    @Override
    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int pathSeq, int pathCount, int pathCount2, String opt, Context ctx) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, ICursor cs, int seg, Object[][] endValues, Context ctx) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
    }

    @Override
    public void addColumn(String colName, Expression exp, Context ctx) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
    }

    @Override
    public void deleteColumn(String colName) {
    }

    @Override
    public Object[] getMaxMinValue(String key) throws IOException {
        if (this.totalRecordCount == 0L) {
            return null;
        }
        boolean[] isDim = this.isDim;
        String[] colNames = this.colNames;
        int len = colNames.length;
        boolean isColumn = false;
        int col = -1;
        for (int i = 0; i < len; ++i) {
            if (!key.equals(colNames[i])) continue;
            isColumn = true;
            col = i;
            break;
        }
        if (!isColumn) {
            return null;
        }
        if (!isDim[col]) {
            Expression max = new Expression("max(" + key + ")");
            Expression min = new Expression("min(" + key + ")");
            Expression[] exps = new Expression[]{max, min};
            Table seq = this.cursor(new String[]{key}).groups(null, null, exps, null, null, new Context());
            return ((Record)seq.get(1)).getFieldValues();
        }
        ObjectReader segmentReader = this.getSegmentObjectReader();
        int colCount = this.getAllColNames().length;
        int blockCount = this.getDataBlockCount();
        Object max = null;
        Object min = null;
        segmentReader.readLong40();
        for (int c = 0; c < colCount; ++c) {
            Object minValue = segmentReader.readObject();
            Object maxValue = segmentReader.readObject();
            if (c != col) continue;
            min = minValue;
            max = maxValue;
        }
        for (int i = 1; i < blockCount; ++i) {
            segmentReader.readLong40();
            for (int c = 0; c < colCount; ++c) {
                Object minValue = segmentReader.readObject();
                Object maxValue = segmentReader.readObject();
                if (c != col) continue;
                if (Variant.compare(minValue, min) < 0) {
                    min = minValue;
                }
                segmentReader.readObject();
                if (Variant.compare(maxValue, max) <= 0) continue;
                max = maxValue;
            }
        }
        return new Object[]{max, min};
    }

    @Override
    public void append(PhyTable table) throws IOException {
        throw new RuntimeException();
    }
}

