/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.common.RQException;
import com.scudata.dm.DataStruct;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.BufferReader;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.Cursor;
import com.scudata.dw.FindFilter;
import com.scudata.dw.IFilter;
import com.scudata.dw.IlllIllIlIIlIllI;
import java.io.IOException;

public class RvsCursor
extends ICursor {
    private Cursor _$13;
    private IFilter[] _$12;
    private FindFilter[] _$11;
    private BlockLinkReader[] _$10;
    private LongArray[] _$9;
    private IntArray _$8;
    private int _$7;
    private Sequence _$6;
    private DataStruct _$5;
    private int[] _$4;
    private boolean _$3 = false;

    public RvsCursor(Cursor src) {
        this._$13 = src;
        this._$1();
    }

    private void _$1() {
        Cursor cs = this._$13;
        ObjectReader[] segmentReaders = cs.getSegmentReaders();
        ColumnMetaData[] columns = cs.getColumns();
        IFilter[] filters = cs.getFilters();
        int filterCount = filters == null ? 0 : filters.length;
        int curBlock = cs.getCurBlock();
        int endBlock = cs.getEndBlock();
        int blockCount = endBlock - curBlock + 1;
        BlockLinkReader rowCountReader = cs.getRowCountReader();
        this._$10 = cs.getColReaders();
        int colCount = this._$10.length;
        long[] positions = new long[colCount];
        LongArray[] posArray = new LongArray[colCount];
        for (int i = 0; i < colCount; ++i) {
            posArray[i] = new LongArray(blockCount);
        }
        IntArray recordCountArray = new IntArray(blockCount);
        if (segmentReaders == null) {
            segmentReaders = new ObjectReader[colCount];
            for (int i = 0; i < colCount; ++i) {
                segmentReaders[i] = columns[i].getSegmentReader();
            }
        }
        try {
            while (curBlock < endBlock) {
                int f;
                ++curBlock;
                int recordCount = rowCountReader.readInt32();
                boolean sign = true;
                for (f = 0; f < filterCount; ++f) {
                    positions[f] = segmentReaders[f].readLong40();
                    if (!columns[f].hasMaxMinValues()) continue;
                    Object minValue = segmentReaders[f].readObject();
                    Object maxValue = segmentReaders[f].readObject();
                    segmentReaders[f].skipObject();
                    if (filters[f].match(minValue, maxValue)) continue;
                    ++f;
                    sign = false;
                    break;
                }
                while (f < colCount) {
                    positions[f] = segmentReaders[f].readLong40();
                    if (columns[f].hasMaxMinValues()) {
                        segmentReaders[f].skipObject();
                        segmentReaders[f].skipObject();
                        segmentReaders[f].skipObject();
                    }
                    ++f;
                }
                if (!sign) continue;
                for (int i = 0; i < colCount; ++i) {
                    posArray[i].addLong(positions[i]);
                }
                recordCountArray.addInt(recordCount);
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        this._$5 = this._$13.ds;
        this._$4 = this._$13.getSeqs();
        this._$12 = filters;
        this._$11 = cs.findFilters;
        this._$9 = posArray;
        this._$8 = recordCountArray;
        this._$7 = posArray[0].size();
    }

    private int _$1(int n) {
        return this._$13.getInitSize(n);
    }

    protected Sequence get(int n) {
        Sequence seq;
        try {
            seq = this.getData(n);
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        if (seq != null) {
            if (seq.length() > n) {
                Sequence result = seq.split(1, n);
                this._$6 = seq;
                return result;
            }
            return seq;
        }
        return null;
    }

    protected Sequence getData(int n) throws IOException {
        if (this._$3 || n < 1) {
            return null;
        }
        Sequence cache = this._$6;
        if (cache != null) {
            int len = cache.length();
            if (len > n) {
                this._$6 = cache.split(n + 1);
                return cache;
            }
            if (len == n) {
                this._$6 = null;
                return cache;
            }
        } else {
            cache = new Table(this._$5, this._$1(n));
        }
        int curBlock = this._$7;
        BlockLinkReader[] colReaders = this._$10;
        int colCount = colReaders.length;
        long[] positions = new long[colCount];
        BufferReader[] bufReaders = new BufferReader[colCount];
        LongArray[] posArray = this._$9;
        IntArray recordCountArray = this._$8;
        IFilter[] filters = this._$12;
        FindFilter[] findFilters = this._$11;
        int[] seqs = this._$4;
        DataStruct ds = this._$5;
        IArray mems = cache.getMems();
        this._$6 = null;
        while (curBlock > 0) {
            int i;
            int[] nextRows = new int[colCount];
            Object[] fvalues = new Object[colCount];
            for (int f = 0; f < colCount; ++f) {
                bufReaders[f] = null;
                positions[f] = posArray[f].getLong(curBlock);
            }
            int recordCount = recordCountArray.getInt(curBlock);
            --curBlock;
            if (filters == null) {
                int i2;
                for (int f = 0; f < colCount; ++f) {
                    bufReaders[f] = colReaders[f].readBlockData(positions[f], recordCount);
                }
                Table tmpData = new Table(ds, ICursor.FETCHCOUNT);
                IArray tempMems = tmpData.getMems();
                for (i2 = 0; i2 < recordCount; ++i2) {
                    IlllIllIlIIlIllI r = new IlllIllIlIIlIllI(ds);
                    for (int f = 0; f < colCount; ++f) {
                        r.setNormalFieldValue(f, bufReaders[f].readObject());
                    }
                    tempMems.add(r);
                }
                for (i2 = recordCount; i2 > 0; --i2) {
                    mems.add(tempMems.get(i2));
                }
                int diff = n - cache.length();
                if (diff < 0) {
                    this._$6 = cache.split(n + 1);
                    break;
                }
                if (diff != 0) continue;
                break;
            }
            int filterCount = filters.length;
            Table tmpData = new Table(ds, ICursor.FETCHCOUNT);
            IArray tempMems = tmpData.getMems();
            block6: for (i = 0; i < recordCount; ++i) {
                int f;
                for (f = 0; f < filterCount; ++f) {
                    if (bufReaders[f] == null) {
                        bufReaders[f] = colReaders[f].readBlockData(positions[f], recordCount);
                    }
                    for (int j = nextRows[f]; j < i; ++j) {
                        bufReaders[f].skipObject();
                    }
                    nextRows[f] = i + 1;
                    fvalues[f] = bufReaders[f].readObject();
                    if (!filters[f].match(fvalues[f])) continue block6;
                }
                Record r = new Record(ds);
                tempMems.add(r);
                for (f = 0; f < filterCount; ++f) {
                    if (seqs[f] == -1) continue;
                    if (findFilters == null || findFilters[f] == null) {
                        r.setNormalFieldValue(seqs[f], fvalues[f]);
                        continue;
                    }
                    r.setNormalFieldValue(seqs[f], findFilters[f].getFindResult());
                }
                while (f < colCount) {
                    if (bufReaders[f] == null) {
                        bufReaders[f] = colReaders[f].readBlockData(positions[f], recordCount);
                    }
                    for (int j = nextRows[f]; j < i; ++j) {
                        bufReaders[f].skipObject();
                    }
                    nextRows[f] = i + 1;
                    if (seqs[f] != -1) {
                        r.setNormalFieldValue(seqs[f], bufReaders[f].readObject());
                    } else {
                        bufReaders[f].skipObject();
                    }
                    ++f;
                }
            }
            for (i = tempMems.size(); i > 0; --i) {
                mems.add(tempMems.get(i));
            }
            int diff = n - cache.length();
            if (diff < 0) {
                this._$6 = cache.split(n + 1);
                break;
            }
            if (diff != 0) continue;
            break;
        }
        this._$7 = curBlock;
        if (cache.length() > 0) {
            return cache;
        }
        return null;
    }

    protected long skipOver(long n) {
        Sequence data;
        long count = 0L;
        for (long rest = n; rest != 0L && (data = rest > (long)FETCHCOUNT ? this.get(FETCHCOUNT) : this.get((int)rest)) != null; rest -= (long)data.length()) {
            count += (long)data.length();
        }
        return count;
    }

    public void close() {
        super.close();
        this._$13.close();
        this._$3 = true;
        this._$6 = null;
        this._$13 = null;
        this._$10 = null;
    }

    public boolean reset() {
        throw new RuntimeException();
    }
}

