/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.LongArray;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.ObjectWriter;
import com.scudata.dm.RandomObjectWriter;
import com.scudata.dm.RandomOutputStream;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.op.Select;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.IndexCursor;
import com.scudata.dw.ModifyRecord;
import com.scudata.dw.PhyTable;
import com.scudata.dw.PhyTableIndex;
import com.scudata.dw.RowPhyTable;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.fn.string.Like;
import com.scudata.resources.EngineMessage;
import com.scudata.util.EnvUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableFulltextIndex
extends PhyTableIndex {
    private static final int _$9 = 1000;
    private long _$8;

    public TableFulltextIndex(PhyTable table, FileObject indexFile) {
        this(table, indexFile, null);
    }

    public TableFulltextIndex(PhyTable table, String indexName) {
        this(table, indexName, null);
    }

    public TableFulltextIndex(PhyTable table, FileObject indexFile, Integer limit) {
        super(table, indexFile);
        long total = table.totalRecordCount;
        this._$8 = limit == null ? total : (long)limit.intValue();
    }

    public TableFulltextIndex(PhyTable table, String indexName, Integer limit) {
        super(table, indexName);
        long total = table.totalRecordCount;
        this._$8 = limit == null ? total : (long)limit.intValue();
    }

    @Override
    protected void writeHeader(ObjectWriter writer) throws IOException {
        writer.write(114);
        writer.write(113);
        writer.write(100);
        writer.write(119);
        writer.write(105);
        writer.write(100);
        writer.write(119);
        writer.write(new byte[32]);
        writer.writeLong64(this.recordCount);
        writer.writeLong64(this.index1EndPos);
        writer.writeLong64(this.index1RecordCount);
        writer.writeLong64(this.rootItPos);
        writer.writeLong64(this.rootItPos2);
        writer.writeLong64(this.indexPos);
        writer.writeLong64(this.indexPos2);
        writer.writeStrings(this.ifields);
        if (this.filter != null) {
            writer.write(1);
            writer.writeUTF(this.filter.toString());
        } else {
            writer.write(0);
        }
    }

    @Override
    protected void readHeader(ObjectReader reader) throws IOException {
        if (reader.read() != 114 || reader.read() != 113 || reader.read() != 100 || reader.read() != 119 || reader.read() != 105 || reader.read() != 100 || reader.read() != 119) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        reader.readFully(new byte[32]);
        this.recordCount = reader.readLong64();
        this.index1EndPos = reader.readLong64();
        this.index1RecordCount = reader.readLong64();
        this.rootItPos = reader.readLong64();
        this.rootItPos2 = reader.readLong64();
        this.indexPos = reader.readLong64();
        this.indexPos2 = reader.readLong64();
        reader.readStrings();
        this.filter = reader.read() != 0 ? new Expression(reader.readUTF()) : null;
    }

    private boolean _$1(HashMap<String, Long> strCounters, String key) {
        if (strCounters.containsKey(key)) {
            Long cnt = strCounters.get(key) + 1L;
            if (cnt >= this._$8) {
                return true;
            }
            strCounters.put(key, cnt);
        } else {
            strCounters.put(key, 1L);
        }
        return false;
    }

    private boolean _$1(char word) {
        return word >= '0' && word <= 'z';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<ICursor> sort(String[] fields, Context ctx, Expression filter) {
        boolean isColTable = this.srcTable instanceof ColPhyTable;
        ICursor srcCursor = isColTable ? new PhyTableIndex.CTableCursor(this.srcTable, fields, ctx, filter) : new PhyTableIndex.RTableCursor(this.srcTable, fields, ctx, filter);
        try {
            BFileCursor bfc;
            int i;
            Sequence table;
            int icount = fields.length;
            DataStruct ds = this.srcTable.getDataStruct();
            this.ifields = new String[icount];
            boolean isPrimaryTable = this.srcTable.parent == null;
            String[] keyNames = this.srcTable.groupTable.baseTable.getSortedColNames();
            ArrayList<String> list = new ArrayList<String>();
            if (keyNames != null) {
                for (String name : keyNames) {
                    list.add(name);
                }
            }
            for (int i2 = 0; i2 < icount; ++i2) {
                int id = ds.getFieldIndex(fields[i2]);
                if (id == -1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fields[i2] + mm.getMessage("ds.fieldNotExist"));
                }
                if (!isPrimaryTable && list.contains(fields[i2])) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fields[i2] + mm.getMessage("ds.fieldNotExist"));
                }
                this.ifields[i2] = fields[i2];
            }
            Runtime rt = Runtime.getRuntime();
            int baseCount = 100000;
            boolean flag = false;
            HashMap<String, Long> strCounters = new HashMap<String, Long>();
            int fieldsCount = isColTable ? ((PhyTableIndex.CTableCursor)srcCursor)._$13.getFieldCount() : ((PhyTableIndex.RTableCursor)srcCursor)._$18.getFieldCount();
            ArrayList<ICursor> cursorList = new ArrayList<ICursor>();
            int[] sortFields = new int[icount + 1];
            for (int i3 = 0; i3 < icount + 1; ++i3) {
                sortFields[i3] = i3;
            }
            if (this.index1EndPos > 0L) {
                if (this.srcTable instanceof ColPhyTable) {
                    ((PhyTableIndex.CTableCursor)srcCursor).seek(this.index1EndPos);
                } else {
                    ((PhyTableIndex.RTableCursor)srcCursor).seek(this.index1EndPos);
                }
            }
            while ((table = isColTable ? ((PhyTableIndex.CTableCursor)srcCursor).get(baseCount) : ((PhyTableIndex.RTableCursor)srcCursor).get(baseCount)) != null && table.length() > 0) {
                this.recordCount += (long)table.length();
                ds = table.dataStruct();
                Table subTable = new Table(ds);
                IArray mems = table.getMems();
                int length = table.length();
                for (i = 1; i <= length; ++i) {
                    Record r = (Record)mems.get(i);
                    Object[] objs = r.getFieldValues();
                    if (objs[0] == null) continue;
                    if (!(objs[0] instanceof String)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("index" + mm.getMessage("function.paramTypeError"));
                    }
                    String ifield = ((String)objs[0]).toLowerCase();
                    list.clear();
                    int strLen = ifield.length();
                    for (int j = 0; j < strLen; ++j) {
                        String str;
                        char ch1 = ifield.charAt(j);
                        if (ch1 == ' ') continue;
                        if (this._$1(ch1)) {
                            if (j + 2 >= strLen) continue;
                            char ch2 = ifield.charAt(j + 1);
                            char ch3 = ifield.charAt(j + 2);
                            if (!this._$1(ch2) || !this._$1(ch3)) continue;
                            Object[] vals = new Object[fieldsCount];
                            for (int f = 1; f < fieldsCount; ++f) {
                                vals[f] = objs[f];
                            }
                            String str3 = new String("" + ch1 + ch2 + ch3);
                            if (list.contains(str3) || this._$1(strCounters, str3)) continue;
                            vals[0] = str3;
                            subTable.newLast(vals);
                            list.add(str3);
                            continue;
                        }
                        if (ch1 <= '\u00ff' || list.contains(str = new String("" + ch1)) || this._$1(strCounters, str)) continue;
                        Object[] vals = new Object[fieldsCount];
                        for (int f = 1; f < fieldsCount; ++f) {
                            vals[f] = objs[f];
                        }
                        vals[0] = str;
                        subTable.newLast(vals);
                        list.add(str);
                    }
                }
                if (subTable != null && subTable.length() != 0) {
                    subTable.sortFields(sortFields);
                    FileObject tmp = FileObject.createTempFileObject();
                    tmp.exportSeries(subTable, "b", null);
                    bfc = new BFileCursor(tmp, null, "x", ctx);
                    cursorList.add(bfc);
                    subTable = null;
                    if (!flag && tmp.size() < 0x3200000L) {
                        baseCount = (int)((long)baseCount * (0x3200000L / tmp.size()));
                        flag = true;
                    }
                }
                table = null;
                EnvUtil.runGC(rt);
            }
            int size = cursorList.size();
            if (size > 1) {
                int bufSize = Env.getMergeFileBufSize(size);
                for (i = 0; i < size; ++i) {
                    bfc = (BFileCursor)cursorList.get(i);
                    bfc.setFileBufferSize(bufSize);
                }
            }
            ArrayList<ICursor> arrayList = cursorList;
            return arrayList;
        }
        finally {
            if (srcCursor != null) {
                srcCursor.close();
            }
        }
    }

    @Override
    protected ArrayList<ICursor> sortCol(String[] fields, Context ctx, Expression filter) {
        return this.sort(fields, ctx, filter);
    }

    @Override
    protected ArrayList<ICursor> sortRow(String[] fields, Context ctx, Expression filter) {
        return this.sort(fields, ctx, filter);
    }

    @Override
    protected void createIndexTable(ICursor cursor, FileObject indexFile, boolean isAppends) {
        int i;
        long itPos;
        int f;
        RandomOutputStream os = indexFile.getRandomOutputStream(true);
        RandomObjectWriter writer = new RandomObjectWriter(os);
        long perCount = 1000L;
        ArrayList<Record> maxValues = new ArrayList<Record>();
        int blockCount = 0;
        Context ctx = new Context();
        int icount = this.ifields.length;
        int posCount = this.positionCount;
        Expression[] ifs = new Expression[icount];
        for (int i2 = 0; i2 < icount; ++i2) {
            ifs[i2] = new Expression("#" + (i2 + 1));
        }
        try {
            if (isAppends) {
                indexFile.setFileSize(this.indexPos2);
                writer.position(this.indexPos2);
            } else {
                writer.position(0L);
                this.writeHeader(writer);
            }
            Record r = null;
            Sequence table = cursor.fetchGroup(ifs, 1000, ctx);
            if (table == null || table.length() == 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("index" + mm.getMessage("function.invalidParam"));
            }
            int p = 1;
            IArray mems = table.getMems();
            int length = table.length();
            while (table != null && length != 0) {
                writer.writeInt(-1);
                int count = 0;
                while ((long)count < perCount) {
                    int len = this.getGroupNum(mems, p, icount);
                    count += len;
                    r = (Record)mems.get(p);
                    writer.writeInt(len);
                    for (int f2 = 0; f2 < icount; ++f2) {
                        writer.writeObject(r.getNormalFieldValue(f2));
                    }
                    for (int i3 = 0; i3 < len; ++i3) {
                        r = (Record)mems.get(i3 + p);
                        writer.writeObject(r.getNormalFieldValue(icount));
                        for (int j = 1; j <= posCount; ++j) {
                            writer.writeObject(r.getNormalFieldValue(icount + j));
                        }
                    }
                    if ((p += len) <= length) continue;
                    table = cursor.fetchGroup(ifs, 1000, ctx);
                    if (table == null || table.length() == 0) break;
                    p = 1;
                    mems = table.getMems();
                    length = table.length();
                }
                ++blockCount;
                maxValues.add(r);
            }
            writer.writeInt(-2);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ie) {}
        }
        long[] positions = new long[blockCount];
        InputStream is = indexFile.getInputStream();
        ObjectReader reader = new ObjectReader(is, 1024);
        try {
            this.readHeader(reader);
            if (isAppends) {
                reader.seek(this.indexPos2);
            } else {
                this.indexPos = reader.position();
            }
            reader.readInt();
            for (int i4 = 0; i4 < blockCount; ++i4) {
                int count;
                positions[i4] = reader.position();
                while ((count = reader.readInt()) >= 1) {
                    for (f = 0; f < icount; ++f) {
                        reader.readObject();
                    }
                    for (int j = 0; j < count; ++j) {
                        reader.readLong();
                        for (int c = 0; c < posCount; ++c) {
                            reader.readLong();
                        }
                    }
                }
            }
            itPos = reader.position();
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
        os = indexFile.getRandomOutputStream(true);
        writer = new RandomObjectWriter(os);
        try {
            writer.position(itPos);
            for (int i5 = 0; i5 < blockCount; ++i5) {
                if (i5 % 1000 == 0) {
                    if (blockCount - i5 >= 1000) {
                        writer.writeInt(1000);
                    } else {
                        writer.writeInt(blockCount - i5);
                    }
                }
                for (int f3 = 0; f3 < icount; ++f3) {
                    writer.writeObject(((Record)maxValues.get(i5)).getNormalFieldValue(f3));
                }
                writer.writeLong(positions[i5]);
            }
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ie) {}
        }
        int rootBlockCount = blockCount / 1000;
        Record[] rootMaxValues = new Record[rootBlockCount += blockCount % 1000 == 0 ? 0 : 1];
        for (i = 0; i < rootBlockCount - 1; ++i) {
            rootMaxValues[i] = (Record)maxValues.get((i + 1) * 1000 - 1);
        }
        rootMaxValues[rootBlockCount - 1] = (Record)maxValues.get(blockCount - 1);
        long[] rootPositions = new long[rootBlockCount];
        is = indexFile.getInputStream();
        reader = new ObjectReader(is, 1024);
        try {
            reader.seek(itPos);
            for (i = 0; i < blockCount; ++i) {
                if (i % 1000 == 0) {
                    rootPositions[i / 1000] = reader.position();
                    reader.readInt();
                }
                for (f = 0; f < icount; ++f) {
                    reader.readObject();
                }
                reader.readLong();
            }
            itPos = reader.position();
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
        if (isAppends) {
            this.rootItPos2 = itPos;
            this.recordCount = this.srcTable.getTotalRecordCount();
        } else {
            this.rootItPos = itPos;
            this.rootItPos2 = 0L;
            this.index1RecordCount = this.recordCount = this.srcTable.getTotalRecordCount();
            this.index1EndPos = this.srcTable.getTotalRecordCount();
        }
        os = indexFile.getRandomOutputStream(true);
        writer = new RandomObjectWriter(os);
        try {
            writer.position(itPos);
            writer.writeInt(rootBlockCount);
            for (int i6 = 0; i6 < rootBlockCount; ++i6) {
                for (f = 0; f < icount; ++f) {
                    writer.writeObject(rootMaxValues[i6].getNormalFieldValue(f));
                }
                writer.writeLong(rootPositions[i6]);
            }
            writer.writeLong64(blockCount);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ie) {}
        }
        if (!isAppends) {
            this.indexPos2 = indexFile.size();
        }
        os = indexFile.getRandomOutputStream(true);
        writer = new RandomObjectWriter(os);
        try {
            writer.position(0L);
            this.updateHeader(writer);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ie) {}
        }
    }

    @Override
    public ICursor select(Expression exp, String[] fields, String opt, Context ctx) {
        this.readBlockInfo(this.indexFile);
        int icount = this.ifields.length;
        if (icount == 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.unknownExpression") + exp.toString());
        }
        Node home = exp.getHome();
        if (home instanceof Like && ((Like)home).getParam().getSubSize() == 2) {
            IParam sub1 = ((Like)home).getParam().getSub(0);
            IParam sub2 = ((Like)home).getParam().getSub(1);
            String f = sub1.getLeafExpression().getIdentifierName();
            if (f.equals(this.ifields[0])) {
                String fmtExp = (String)sub2.getLeafExpression().calculate(ctx);
                int idx = fmtExp.indexOf("*");
                if (idx != 0) {
                    return this.srcTable.cursor(fields, exp, ctx);
                }
                idx = (fmtExp = fmtExp.substring(1)).indexOf("*");
                if (idx != fmtExp.length() - 1) {
                    return this.srcTable.cursor(fields, exp, ctx);
                }
                idx = (fmtExp = fmtExp.substring(0, fmtExp.length() - 1)).indexOf("*");
                if (idx >= 0) {
                    return this.srcTable.cursor(fields, exp, ctx);
                }
                String regex = "[a-zA-Z0-9]+";
                if (fmtExp.matches(regex) && fmtExp.length() < 3) {
                    return this.srcTable.cursor(fields, exp, ctx);
                }
                LongArray tempPos = this.select(exp, opt, ctx);
                ArrayList<ModifyRecord> mrl = PhyTable.getModifyRecord(this.srcTable, exp, ctx);
                if (tempPos != null && tempPos.size() > 0) {
                    IndexCursor cs = new IndexCursor(this.srcTable, fields, this.ifields, tempPos.toArray(), opt, ctx);
                    if (cs instanceof IndexCursor) {
                        cs.setModifyRecordList(mrl);
                        if (this.maxRecordLen != 0) {
                            cs.setRowBufferSize(this.maxRecordLen);
                        }
                    }
                    Expression tempExp = new Expression("like@c(" + f + ",\"*" + fmtExp + "*\")");
                    Select select = new Select(tempExp, null);
                    cs.addOperation(select, ctx);
                    return cs;
                }
                if (mrl == null) {
                    return null;
                }
                return new IndexCursor(this.srcTable, fields, this.ifields, null, opt, ctx);
            }
        }
        return this.srcTable.cursor(fields, exp, ctx);
    }

    @Override
    public LongArray select(Expression exp, String opt, Context ctx) {
        String f = this.ifields[0];
        IParam sub2 = ((Like)exp.getHome()).getParam().getSub(1);
        String fmtExp = (String)sub2.getLeafExpression().calculate(ctx);
        fmtExp = fmtExp.substring(1, fmtExp.length() - 1).toLowerCase();
        boolean isRow = this.srcTable instanceof RowPhyTable;
        long[] recCountOfSegment = null;
        if (!isRow) {
            recCountOfSegment = ((ColPhyTable)this.srcTable).getSegmentInfo();
        }
        String regex = "[a-zA-Z0-9]+";
        String search = "";
        LongArray tempPos = null;
        int strLen = fmtExp.length();
        int p = 0;
        int j = 0;
        while (j < strLen) {
            String str3;
            String str = fmtExp.substring(j, j + 1);
            p = j + 1;
            if (str.matches(regex) && j + 2 < strLen && (str3 = fmtExp.substring(j, j + 3)).matches(regex)) {
                str = str3;
                p = j + 3;
            }
            ++j;
            if (search.indexOf(str) >= 0) continue;
            search = fmtExp.substring(0, p);
            Expression tempExp = new Expression(f + "==\"" + str + "\"");
            LongArray srcPos = super.select(tempExp, opt, null);
            if (srcPos == null || srcPos.size() == 0) {
                tempPos = null;
                break;
            }
            boolean sort = true;
            if (!this.hasSecIndex()) {
                sort = false;
            }
            if (isRow) {
                if ((tempPos = PhyTable._$1(tempPos, srcPos.toArray(), this.getPositionCount(), sort)).size() > 1000) continue;
                break;
            }
            long[] arr = srcPos.toArray();
            if (sort) {
                Arrays.sort(arr);
            }
            if (PhyTable.getBlockCount(tempPos = PhyTable._$1(tempPos, arr), recCountOfSegment) > 10) continue;
            break;
        }
        if (tempPos == null) {
            tempPos = new LongArray();
        }
        return tempPos;
    }

    @Override
    public void dup(PhyTable table) {
        String dir = table.getGroupTable().getFile().getAbsolutePath() + "_";
        FileObject indexFile = new FileObject(dir + table.getTableName() + "_" + this.name);
        RandomOutputStream os = indexFile.getRandomOutputStream(true);
        RandomObjectWriter writer = new RandomObjectWriter(os);
        try {
            this.writeHeader(writer);
            writer.close();
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    @Override
    public Object getIndexStruct() {
        InputStream is = this.indexFile.getInputStream();
        ObjectReader reader = new ObjectReader(is, 1024);
        try {
            this.readHeader(reader);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ie) {}
        }
        Record rec = new Record(new DataStruct(INDEX_FIELD_NAMES));
        rec.setNormalFieldValue(0, this.name);
        rec.setNormalFieldValue(1, null);
        rec.setNormalFieldValue(2, new Sequence(this.ifields));
        rec.setNormalFieldValue(3, null);
        rec.setNormalFieldValue(4, this.filter == null ? null : this.filter.toString());
        return rec;
    }
}

