/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw.compress;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.HashIndexTable;
import com.scudata.dm.IndexTable;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dw.MemoryTable;
import com.scudata.dw.compress.BigDecimalColumn;
import com.scudata.dw.compress.Column;
import com.scudata.dw.compress.DateColumn;
import com.scudata.dw.compress.DateTimeColumn;
import com.scudata.dw.compress.DoubleColumn;
import com.scudata.dw.compress.IntColumn;
import com.scudata.dw.compress.LongColumn;
import com.scudata.dw.compress.NullColumn;
import com.scudata.dw.compress.RefColumn;
import com.scudata.dw.compress.SeqRefColumn;
import com.scudata.dw.compress.StringColumn;
import com.scudata.dw.compress.TimeColumn;
import com.scudata.expression.CurrentSeq;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnList
implements IArray {
    private Column[] _$3;
    private DataStruct _$2;
    private int _$1;

    public ColumnList() {
    }

    public ColumnList(DataStruct ds, Column[] columns, int size) {
        this._$2 = ds;
        this._$3 = columns;
        this._$1 = size;
    }

    public ColumnList(ICursor cs) {
        Sequence data = cs.peek(1);
        if (data == null || data.length() <= 0) {
            return;
        }
        BaseRecord rec = (BaseRecord)data.get(1);
        int count = rec.getFieldCount();
        this._$2 = rec.dataStruct();
        Column[] columns = new Column[count];
        this._$3 = columns;
        int total = 0;
        data = cs.fetch(ICursor.FETCHCOUNT);
        while (data != null && data.length() > 0) {
            this._$1 = data.length();
            for (int i = 1; i <= this._$1; ++i) {
                rec = (BaseRecord)data.get(i);
                Object[] objs = rec.getFieldValues();
                for (int c = 0; c < count; ++c) {
                    if (columns[c] == null) {
                        if (objs[c] == null) continue;
                        Object obj = objs[c];
                        if (obj instanceof Integer) {
                            columns[c] = new IntColumn();
                        } else if (obj instanceof Long) {
                            columns[c] = new LongColumn();
                        } else if (obj instanceof Double) {
                            columns[c] = new DoubleColumn();
                        } else if (obj instanceof BigDecimal) {
                            columns[c] = new BigDecimalColumn();
                        } else if (obj instanceof String) {
                            columns[c] = new StringColumn();
                        } else if (obj instanceof Date) {
                            columns[c] = new DateColumn();
                        } else if (obj instanceof Timestamp) {
                            columns[c] = new DateTimeColumn();
                        } else if (obj instanceof Time) {
                            columns[c] = new TimeColumn();
                        } else if (obj instanceof BaseRecord) {
                            columns[c] = new RefColumn();
                        }
                        for (int j = 0; j < total + i - 1; ++j) {
                            columns[c].addData(null);
                        }
                        columns[c].addData(obj);
                        continue;
                    }
                    columns[c].addData(objs[c]);
                }
            }
            total += this._$1;
            data = cs.fetch(ICursor.FETCHCOUNT);
        }
        for (int c = 0; c < count; ++c) {
            if (columns[c] != null) continue;
            columns[c] = new NullColumn();
        }
        this._$1 = total;
    }

    public ColumnList(ICursor cs, int n) {
        Sequence data = cs.peek(1);
        if (data == null || data.length() <= 0) {
            return;
        }
        BaseRecord rec = (BaseRecord)data.get(1);
        int count = rec.getFieldCount();
        this._$2 = rec.dataStruct();
        Column[] columns = new Column[count];
        this._$3 = columns;
        int total = 0;
        int rest = n;
        int fetchCount = rest >= ICursor.FETCHCOUNT ? ICursor.FETCHCOUNT : rest;
        data = cs.fetch(fetchCount);
        while (data != null && data.length() > 0) {
            this._$1 = data.length();
            for (int i = 1; i <= this._$1; ++i) {
                rec = (BaseRecord)data.get(i);
                Object[] objs = rec.getFieldValues();
                for (int c = 0; c < count; ++c) {
                    if (columns[c] == null) {
                        if (objs[c] == null) continue;
                        Object obj = objs[c];
                        if (obj instanceof Integer) {
                            columns[c] = new IntColumn();
                        } else if (obj instanceof Long) {
                            columns[c] = new LongColumn();
                        } else if (obj instanceof Double) {
                            columns[c] = new DoubleColumn();
                        } else if (obj instanceof BigDecimal) {
                            columns[c] = new BigDecimalColumn();
                        } else if (obj instanceof String) {
                            columns[c] = new StringColumn();
                        } else if (obj instanceof Date) {
                            columns[c] = new DateColumn();
                        } else if (obj instanceof Timestamp) {
                            columns[c] = new DateTimeColumn();
                        } else if (obj instanceof Time) {
                            columns[c] = new TimeColumn();
                        } else if (obj instanceof BaseRecord) {
                            columns[c] = new RefColumn();
                        }
                        for (int j = 0; j < total + i - 1; ++j) {
                            columns[c].addData(null);
                        }
                        columns[c].addData(obj);
                        continue;
                    }
                    columns[c].addData(objs[c]);
                }
            }
            rest -= this._$1;
            if ((total += this._$1) >= n) break;
            fetchCount = rest >= ICursor.FETCHCOUNT ? ICursor.FETCHCOUNT : rest;
            data = cs.fetch(fetchCount);
        }
        for (int c = 0; c < count; ++c) {
            if (columns[c] != null) continue;
            columns[c] = new NullColumn();
        }
        this._$1 = total;
    }

    public DataStruct dataStruct() {
        return this._$2;
    }

    @Override
    public Object get(int index) {
        Record record = new Record(this._$2);
        Column[] columns = this._$3;
        int count = columns.length;
        for (int c = 0; c < count; ++c) {
            record.set(c, columns[c].getData(index));
        }
        return record;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this._$1];
        int size = this._$1;
        for (int i = 1; i <= size; ++i) {
            result[i - 1] = this.get(i);
        }
        return result;
    }

    @Override
    public void toArray(Object[] a) {
        for (int i = 1; i <= this._$1; ++i) {
            a[i - 1] = this.get(i);
        }
    }

    public void switchFk(String[] fkNames, Sequence[] codes, Expression[] exps, String opt, Context ctx) {
        boolean isIsect = false;
        boolean isDiff = false;
        if (opt != null) {
            if (opt.indexOf(105) != -1) {
                isIsect = true;
            } else if (opt.indexOf(100) != -1) {
                isDiff = true;
            }
        }
        if (isIsect || isDiff) {
            this._$1(fkNames, codes, exps, isDiff, ctx);
        } else {
            this._$1(fkNames, codes, exps, ctx);
        }
    }

    private IndexTable[] _$1(Sequence[] codes, Expression[] exps, Context ctx) {
        int count = codes.length;
        IndexTable[] indexTables = new IndexTable[count];
        for (int i = 0; i < count; ++i) {
            Sequence code = codes[i];
            Expression exp = null;
            if (exps != null && exps.length > i) {
                exp = exps[i];
            }
            if (exp != null && exp.getHome() instanceof CurrentSeq) continue;
            indexTables[i] = code.getIndexTable(exp, ctx);
            if (indexTables[i] != null) continue;
            indexTables[i] = code.newIndexTable(exp, ctx);
        }
        return indexTables;
    }

    private void _$1(String[] fkNames, Sequence[] codes, Expression[] exps, Context ctx) {
        DataStruct ds = this._$2;
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        int fkCount = fkNames.length;
        int[] fkIndex = new int[fkCount];
        for (int f = 0; f < fkCount; ++f) {
            fkIndex[f] = ds.getFieldIndex(fkNames[f]);
            if (fkIndex[f] != -1) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(fkNames[f] + mm.getMessage("ds.fieldNotExist"));
        }
        int len = this._$1;
        IndexTable[] indexTables = this._$1(codes, exps, ctx);
        for (int f = 0; f < fkCount; ++f) {
            int seq;
            int i;
            int codeLen;
            int i2;
            Column column;
            int fk = fkIndex[f];
            IndexTable indexTable = indexTables[f];
            Column oldColumn = this._$3[fk];
            Sequence code = codes[f];
            if (code instanceof MemoryTable && ((MemoryTable)code).isCompressTable()) {
                column = new SeqRefColumn(code);
                if (indexTable != null) {
                    for (i2 = 1; i2 <= len; ++i2) {
                        Object key = oldColumn.getData(i2);
                        int seq2 = ((HashIndexTable)indexTable).findPos(key);
                        ((SeqRefColumn)column).addData(seq2);
                    }
                } else {
                    codeLen = code.length();
                    for (i = 1; i <= len; ++i) {
                        Object val = oldColumn.getData(i);
                        if (!(val instanceof Number)) continue;
                        seq = ((Number)val).intValue();
                        if (seq > 0 && seq <= codeLen) {
                            ((SeqRefColumn)column).addData(seq);
                            continue;
                        }
                        ((SeqRefColumn)column).addData(-1);
                    }
                }
                this._$3[fk] = column;
                continue;
            }
            column = new RefColumn();
            if (indexTable != null) {
                for (i2 = 1; i2 <= len; ++i2) {
                    Object key = oldColumn.getData(i2);
                    Object obj = indexTable.find(key);
                    ((RefColumn)column).addData(obj);
                }
            } else {
                codeLen = code.length();
                for (i = 1; i <= len; ++i) {
                    Object val = oldColumn.getData(i);
                    if (!(val instanceof Number)) continue;
                    seq = ((Number)val).intValue();
                    if (seq > 0 && seq <= codeLen) {
                        ((RefColumn)column).addData(code.getMem(seq));
                        continue;
                    }
                    ((RefColumn)column).addData(null);
                }
            }
            this._$3[fk] = column;
        }
    }

    private void _$1(int fk) {
        Column[] newColumns = (Column[])this._$3.clone();
        for (int i = 0; i < newColumns.length; ++i) {
            newColumns[i] = this._$3[i].clone();
        }
        int size = this._$1;
        int total = 0;
        int count = this._$3.length;
        Column[] columns = this._$3;
        Column col = columns[fk];
        for (int i = 1; i <= size; ++i) {
            if (col.getData(i) == null) continue;
            for (int j = 0; j < count; ++j) {
                if (newColumns[j] instanceof NullColumn) continue;
                if (newColumns[j] instanceof SeqRefColumn) {
                    int seq = ((SeqRefColumn)columns[j]).getSeq(i);
                    ((SeqRefColumn)newColumns[j]).addData(seq);
                    continue;
                }
                newColumns[j].addData(columns[j].getData(i));
            }
            ++total;
        }
        this._$3 = newColumns;
        this._$1 = total;
    }

    private void _$1(String[] fkNames, Sequence[] codes, Expression[] exps, boolean isDiff, Context ctx) {
        DataStruct ds = this._$2;
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        int fkCount = fkNames.length;
        int[] fkIndex = new int[fkCount];
        for (int f = 0; f < fkCount; ++f) {
            fkIndex[f] = ds.getFieldIndex(fkNames[f]);
            if (fkIndex[f] != -1) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(fkNames[f] + mm.getMessage("ds.fieldNotExist"));
        }
        IndexTable[] indexTables = this._$1(codes, exps, ctx);
        for (int f = 0; f < fkCount; ++f) {
            int seq;
            int i;
            int codeLen;
            int i2;
            Column column;
            int fk = fkIndex[f];
            IndexTable indexTable = indexTables[f];
            Column oldColumn = this._$3[fk];
            Sequence code = codes[f];
            int len = this._$1;
            if (code instanceof MemoryTable && ((MemoryTable)code).isCompressTable()) {
                column = new SeqRefColumn(code);
                if (indexTable != null) {
                    for (i2 = 1; i2 <= len; ++i2) {
                        Object key = oldColumn.getData(i2);
                        int seq2 = ((HashIndexTable)indexTable).findPos(key);
                        if (isDiff) {
                            if (seq2 <= 0) continue;
                            ((SeqRefColumn)column).addData(-1);
                            continue;
                        }
                        ((SeqRefColumn)column).addData(seq2);
                    }
                } else {
                    codeLen = code.length();
                    for (i = 1; i <= len; ++i) {
                        Object val = oldColumn.getData(i);
                        if (!(val instanceof Number)) continue;
                        seq = ((Number)val).intValue();
                        if (isDiff) {
                            if (seq <= 0 || seq > codeLen) continue;
                            ((SeqRefColumn)column).addData(-1);
                            continue;
                        }
                        if (seq > 0 && seq <= codeLen) {
                            ((SeqRefColumn)column).addData(seq);
                            continue;
                        }
                        ((SeqRefColumn)column).addData(-1);
                    }
                }
                this._$3[fk] = column;
            } else {
                column = new RefColumn();
                if (indexTable != null) {
                    for (i2 = 1; i2 <= len; ++i2) {
                        Object key = oldColumn.getData(i2);
                        Object obj = indexTable.find(key);
                        if (isDiff) {
                            if (obj == null) continue;
                            ((RefColumn)column).addData(null);
                            continue;
                        }
                        ((RefColumn)column).addData(obj);
                    }
                } else {
                    codeLen = code.length();
                    for (i = 1; i <= len; ++i) {
                        Object val = oldColumn.getData(i);
                        if (!(val instanceof Number)) continue;
                        seq = ((Number)val).intValue();
                        if (isDiff) {
                            if (seq <= 0 || seq > codeLen) continue;
                            ((RefColumn)column).addData(-1);
                            continue;
                        }
                        if (seq > 0 && seq <= codeLen) {
                            ((RefColumn)column).addData(seq);
                            continue;
                        }
                        ((RefColumn)column).addData(-1);
                    }
                }
                this._$3[fk] = column;
            }
            this._$1(fk);
        }
    }

    public Column[] getColumns() {
        return this._$3;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public byte[] serialize() throws IOException {
        return null;
    }

    @Override
    public void fillRecord(byte[] bytes) throws IOException, ClassNotFoundException {
    }

    @Override
    public String getDataType() {
        return null;
    }

    @Override
    public void add(Object o) {
    }

    @Override
    public void addAll(Object[] array) {
    }

    @Override
    public void addAll(IArray array) {
    }

    @Override
    public void addAll(IArray array, int count) {
    }

    @Override
    public void addAll(IArray array, int index, int count) {
    }

    @Override
    public void insert(int index, Object o) {
    }

    @Override
    public void insertAll(int pos, IArray array) {
    }

    @Override
    public void insertAll(int pos, Object[] array) {
    }

    @Override
    public void push(Object o) {
    }

    @Override
    public void pushNull() {
    }

    @Override
    public void push(IArray array, int index) {
    }

    @Override
    public void add(IArray array, int index) {
    }

    @Override
    public void set(int curIndex, IArray array, int index) {
    }

    @Override
    public IArray get(int[] indexArray) {
        return null;
    }

    @Override
    public IArray get(int start, int end) {
        return null;
    }

    @Override
    public IArray get(IArray indexArray) {
        return null;
    }

    @Override
    public int getInt(int index) {
        return 0;
    }

    @Override
    public long getLong(int index) {
        return 0L;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public BoolArray isTrue() {
        return null;
    }

    @Override
    public BoolArray isFalse() {
        return null;
    }

    @Override
    public boolean isTrue(int index) {
        return false;
    }

    @Override
    public boolean isFalse(int index) {
        return false;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public void setTemporary(boolean ifTemporary) {
    }

    @Override
    public void remove(int index) {
    }

    @Override
    public void remove(int[] seqs) {
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
    }

    @Override
    public int size() {
        return this._$1;
    }

    @Override
    public int count() {
        return 0;
    }

    @Override
    public Object ifn() {
        return null;
    }

    @Override
    public void set(int index, Object obj) {
    }

    @Override
    public void clear() {
    }

    @Override
    public int binarySearch(Object elem) {
        return 0;
    }

    @Override
    public int binarySearch(Object elem, int start, int end) {
        return 0;
    }

    @Override
    public boolean contains(Object elem) {
        return false;
    }

    @Override
    public void contains(boolean isSorted, IArray array, BoolArray result) {
    }

    @Override
    public boolean objectContains(Object elem) {
        return false;
    }

    @Override
    public int firstIndexOf(Object elem, int start) {
        return 0;
    }

    @Override
    public int lastIndexOf(Object elem, int start) {
        return 0;
    }

    @Override
    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        return null;
    }

    @Override
    public IArray dup() {
        return null;
    }

    @Override
    public IArray newInstance(int count) {
        return null;
    }

    @Override
    public IArray abs() {
        return null;
    }

    @Override
    public IArray negate() {
        return null;
    }

    @Override
    public IArray not() {
        return null;
    }

    @Override
    public boolean isNumberArray() {
        return false;
    }

    @Override
    public IArray memberAdd(IArray array) {
        return null;
    }

    @Override
    public IArray memberAdd(Object value) {
        return null;
    }

    @Override
    public IArray memberSubtract(IArray array) {
        return null;
    }

    @Override
    public IArray memberMultiply(IArray array) {
        return null;
    }

    @Override
    public IArray memberMultiply(Object value) {
        return null;
    }

    @Override
    public IArray memberDivide(IArray array) {
        return null;
    }

    @Override
    public IArray memberMod(IArray array) {
        return null;
    }

    @Override
    public IArray memberIntDivide(IArray array) {
        return null;
    }

    @Override
    public BoolArray calcRelation(IArray array, int relation) {
        return null;
    }

    @Override
    public BoolArray calcRelation(Object value, int relation) {
        return null;
    }

    @Override
    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
    }

    @Override
    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
    }

    @Override
    public IArray bitwiseAnd(IArray array) {
        return null;
    }

    @Override
    public IArray bitwiseOr(IArray array) {
        return null;
    }

    @Override
    public IArray bitwiseXOr(IArray array) {
        return null;
    }

    @Override
    public IArray bitwiseNot() {
        return null;
    }

    @Override
    public int memberCompare(int index1, int index2) {
        return 0;
    }

    @Override
    public boolean isMemberEquals(int index1, int index2) {
        throw new RuntimeException();
    }

    @Override
    public int compareTo(IArray array) {
        return 0;
    }

    @Override
    public int hashCode(int index) {
        return 0;
    }

    @Override
    public Object sum() {
        return null;
    }

    @Override
    public Object average() {
        return null;
    }

    @Override
    public Object max() {
        return null;
    }

    @Override
    public Object min() {
        return null;
    }

    @Override
    public void reserve(int start, int end) {
    }

    @Override
    public IArray split(int pos) {
        return null;
    }

    @Override
    public IArray split(int from, int to) {
        return null;
    }

    @Override
    public void trimToSize() {
    }

    @Override
    public IArray select(IArray signArray) {
        return null;
    }

    @Override
    public IArray select(int start, int end, IArray signArray) {
        return null;
    }

    @Override
    public boolean isEquals(int curIndex, IArray array, int index) {
        return false;
    }

    @Override
    public int compareTo(int curIndex, IArray array, int index) {
        return 0;
    }

    @Override
    public IArray memberAdd(int curIndex, IArray array, int index) {
        return null;
    }

    @Override
    public void sort() {
    }

    @Override
    public void sort(Comparator<Object> comparator) {
    }

    @Override
    public boolean hasRecord() {
        return false;
    }

    @Override
    public boolean isPmt(boolean isPure) {
        return false;
    }

    @Override
    public IArray rvs() {
        return null;
    }

    @Override
    public void removeLast() {
    }

    @Override
    public boolean isEquals(int curIndex, Object value) {
        return false;
    }

    @Override
    public int compareTo(int curIndex, Object value) {
        return 0;
    }

    @Override
    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        return null;
    }

    @Override
    public IntArray ptopRank(int count, boolean ignoreNull, boolean iopt) {
        return null;
    }

    @Override
    public void setSize(int size) {
    }

    @Override
    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        return null;
    }

    @Override
    public ObjectArray toObjectArray() {
        return null;
    }

    @Override
    public IArray toPureArray() {
        return null;
    }

    public IArray reserve() {
        return this;
    }

    @Override
    public IArray reserve(boolean refOrigin) {
        return this;
    }

    @Override
    public boolean containTrue() {
        return false;
    }

    @Override
    public IArray combine(IArray signArray, IArray other) {
        return null;
    }

    @Override
    public IArray combine(IArray signArray, Object value) {
        return null;
    }

    @Override
    public Object pos(IArray array, String opt) {
        return ArrayUtil.pos(this, array, opt);
    }

    @Override
    public int bit1() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public int bit1(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public int getNextEqualCount(int index) {
        throw new RuntimeException();
    }
}

