/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw.compress;

import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dw.BufferReader;
import com.scudata.dw.compress.Column;
import com.scudata.resources.EngineMessage;
import com.scudata.util.HashUtil;
import java.io.IOException;
import java.util.ArrayList;

public class IntColumn
extends Column {
    private static final int _$3 = Integer.MIN_VALUE;
    private ArrayList<int[]> _$2 = new ArrayList(1024);
    private int _$1 = 8192;

    public void addData(Object data) {
        int value;
        if (data instanceof Number) {
            value = ((Number)data).intValue();
        } else if (data == null) {
            value = Integer.MIN_VALUE;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.colTypeDif"));
        }
        if (this._$1 < 8192) {
            int[] block = this._$2.get(this._$2.size() - 1);
            block[this._$1++] = value;
        } else {
            int[] block = new int[8192];
            block[0] = value;
            this._$2.add(block);
            this._$1 = 1;
        }
    }

    public Object getData(int row) {
        int[] block;
        int value;
        if ((value = (block = this._$2.get(--row / 8192))[row % 8192]) != Integer.MIN_VALUE) {
            return ObjectCache.getInteger(value);
        }
        return null;
    }

    public int getValue(int row) {
        int[] block = this._$2.get(--row / 8192);
        int value = block[row % 8192];
        return value;
    }

    public Column clone() {
        return new IntColumn();
    }

    public void appendData(BufferReader br) throws IOException {
        this.addData(br.readObject());
    }

    public int[] makeHashCode(HashUtil hashUtil) {
        int[] hashCol = new int[hashUtil.getCapacity()];
        int row = 1;
        int len = this._$2.size();
        for (int i = 0; i < len; ++i) {
            int[] array = this._$2.get(i);
            int arrayLen = array.length;
            for (int j = 0; j < arrayLen; ++j) {
                int hash = hashUtil.hashCode(array[j]);
                hashCol[hash] = row++;
            }
        }
        return hashCol;
    }
}

