/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.ExcelVersionCompatibleUtilGetter;
import com.scudata.excel.SheetInfo;
import com.scudata.excel.SheetObject;
import com.scudata.excel.SheetXls;
import com.scudata.excel.XlsFileObject;
import com.scudata.resources.AppMessage;
import com.scudata.resources.EngineMessage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Map;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.OLE2NotOfficeXmlFileException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FileXls
extends XlsFileObject {
    Workbook wb = null;
    FileObject fo = null;
    private String pwd = null;
    private DataFormat dataFormat;
    private boolean isXls = true;
    private FormulaEvaluator evaluator = null;
    private static final int BUFF_SIZE = 500;

    public FileXls(FileObject fo, String pwd, byte fileType) {
        this.fo = fo;
        this.pwd = pwd;
        this.fileType = fileType;
        InputStream in = null;
        InputStream is = null;
        BufferedInputStream bis = null;
        POIFSFileSystem pfs = null;
        try {
            try {
                if (fileType == 2) {
                    this.isXls = false;
                    this.wb = new SXSSFWorkbook(500);
                } else {
                    boolean hasPwd = StringUtils.isValidString(pwd);
                    in = fo.getInputStream();
                    if (!hasPwd && !in.markSupported()) {
                        in = new PushbackInputStream(in, 8);
                    }
                    bis = new BufferedInputStream(in, Env.FILE_BUFSIZE);
                    if (hasPwd) {
                        String fileName = fo.getFileName();
                        if (fileName != null && fileName.toLowerCase().endsWith(".xls")) {
                            this.isXls = true;
                            Biff8EncryptionKey.setCurrentUserPassword((String)pwd);
                            this.wb = new HSSFWorkbook((InputStream)bis);
                        } else {
                            this.isXls = false;
                            pfs = new POIFSFileSystem((InputStream)bis);
                            is = ExcelUtils.decrypt(pfs, pwd);
                            this.wb = new XSSFWorkbook(is);
                        }
                    } else if (!ExcelUtils.isXlsxFile(fo)) {
                        this.isXls = true;
                        Biff8EncryptionKey.setCurrentUserPassword((String)pwd);
                        this.wb = new HSSFWorkbook((InputStream)bis);
                    } else {
                        this.isXls = false;
                        if (StringUtils.isValidString(pwd)) {
                            pfs = new POIFSFileSystem((InputStream)bis);
                            is = ExcelUtils.decrypt(pfs, pwd);
                            this.wb = new XSSFWorkbook(is);
                        } else {
                            this.wb = new XSSFWorkbook((InputStream)bis);
                        }
                    }
                }
                this.evaluator = this.wb.getCreationHelper().createFormulaEvaluator();
                this.dataFormat = this.wb.createDataFormat();
                this.initTableInfo();
            }
            catch (RQException e) {
                throw e;
            }
            catch (OLE2NotOfficeXmlFileException e) {
                if (pwd == null) {
                    throw new RQException(AppMessage.get().getMessage("xlsximporter.ole2nopwd"), e);
                }
                throw new RQException(AppMessage.get().getMessage("xlsximporter.ole2pwd"), e);
            }
            catch (EncryptedDocumentException e) {
                if (pwd == null) {
                    throw new RQException(AppMessage.get().getMessage("xlsximporter.xlsnopwd"), e);
                }
                throw new RQException(AppMessage.get().getMessage("xlsximporter.xlsinvalidpwd"), e);
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Throwable throwable) {}
            }
            if (pfs != null) {
                try {
                    pfs.close();
                }
                catch (Exception exception) {}
            }
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
    }

    public Workbook getWorkbook() {
        return this.wb;
    }

    @Override
    public boolean supportCursor() {
        return this.fileType == 2;
    }

    private void initTableInfo() {
        int sheetCount = ExcelVersionCompatibleUtilGetter.getInstance().getNumberOfSheets(this.wb);
        int i = 0;
        while (i < sheetCount) {
            SheetInfo si = this.getSheetInfo(this.wb.getSheetAt(i));
            this.newLast(new Object[]{this.wb.getSheetName(i), new Integer(si.getRowCount()), new Integer(si.getColCount())});
            ++i;
        }
    }

    private SheetInfo getSheetInfo(Sheet sheet) {
        int colCount = 0;
        int rowCount = sheet.getLastRowNum() + 1;
        if (rowCount > 0) {
            int i = 0;
            while (i < rowCount) {
                Row row = sheet.getRow(i);
                if (row != null) {
                    colCount = Math.max(colCount, row.getLastCellNum());
                }
                ++i;
            }
        }
        SheetInfo si = new SheetInfo(sheet.getSheetName());
        si.setRowCount(rowCount);
        si.setColCount(colCount);
        return si;
    }

    @Override
    public void xlswrite(FileObject fo, String pwd) {
        if (this.fileType == 2) {
            throw new RQException("xlswrite" + AppMessage.get().getMessage("filexls.wwrite"));
        }
        this.output(fo, pwd);
    }

    private void output(FileObject fo, String pwd) {
        if (this.wb != null && fo != null) {
            OutputStream out = null;
            try {
                try {
                    if (this.isXls) {
                        Biff8EncryptionKey.setCurrentUserPassword((String)pwd);
                    }
                    out = fo.getBufferedOutputStream(false);
                    this.wb.write(out);
                }
                catch (Exception e) {
                    throw new RQException(e.getMessage());
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.isXls) {
                    Biff8EncryptionKey.setCurrentUserPassword(null);
                }
            }
            if (pwd != null && !this.isXls) {
                ExcelUtils.encrypt(fo, pwd);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Sheet getSheet(Object s, boolean createSheet, boolean deleteOldSheet) {
        Sheet sheet;
        if (this.fileType == 2) {
            createSheet = true;
        }
        if (s == null && !createSheet) {
            s = new Integer(1);
        }
        if (s instanceof Number) {
            String name;
            int sheetCount;
            int index = ((Number)s).intValue();
            if (index > (sheetCount = ExcelVersionCompatibleUtilGetter.getInstance().getNumberOfSheets(this.wb)) || index < 1) {
                if (!createSheet) throw new RQException(AppMessage.get().getMessage("excel.nosheetindex", String.valueOf(index)));
                name = "Sheet" + index;
                sheet = this.wb.createSheet(name);
                this.newLast(new Object[]{name, new Integer(0), new Integer(0)});
            } else {
                sheet = this.wb.getSheetAt(index - 1);
                if (deleteOldSheet) {
                    String oldName = sheet.getSheetName();
                    this.wb.removeSheetAt(index - 1);
                    this.removeSheet(oldName);
                    this.insert(index, new Object[]{oldName, new Integer(0), new Integer(0)});
                    sheet = this.wb.createSheet(oldName);
                    this.wb.setSheetOrder(oldName, index - 1);
                    this.wb.setActiveSheet(index - 1);
                    this.wb.setSelectedTab(index - 1);
                }
            }
            if (sheet != null) return sheet;
            if (!createSheet) throw new RQException(AppMessage.get().getMessage("excel.nosheetindex", String.valueOf(index)));
            name = "Sheet" + index;
            sheet = this.wb.createSheet(name);
            this.newLast(new Object[]{name, new Integer(0), new Integer(0)});
            return sheet;
        } else if (s instanceof String) {
            String name = (String)s;
            sheet = this.wb.getSheet(name);
            if (sheet == null) {
                if (!createSheet) throw new RQException(AppMessage.get().getMessage("excel.nosheetname", name));
                sheet = this.wb.createSheet(name);
                this.newLast(new Object[]{name, new Integer(0), new Integer(0)});
                return sheet;
            } else {
                if (!deleteOldSheet) return sheet;
                int index = this.wb.getSheetIndex(sheet);
                this.wb.removeSheetAt(index);
                this.removeSheet(name);
                sheet = this.wb.createSheet(name);
                this.wb.setSheetOrder(name, index);
                this.wb.setActiveSheet(index);
                this.wb.setSelectedTab(index);
                this.insert(index + 1, new Object[]{name, new Integer(0), new Integer(0)});
            }
            return sheet;
        } else {
            if (s != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xlsimport" + mm.getMessage("function.paramTypeError"));
            }
            String name = this.getNewSheetName();
            sheet = this.wb.createSheet(name);
            this.newLast(new Object[]{name, new Integer(0), new Integer(0)});
        }
        return sheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SheetObject getSheetObject(Object s, boolean createSheet, boolean deleteOldSheet) {
        Sheet sheet = this.getSheet(s, createSheet, deleteOldSheet);
        int sheetIndex = this.wb.getSheetIndex(sheet);
        SheetObject sx = (SheetObject)this.sheets.get(new Integer(sheetIndex));
        if (deleteOldSheet) {
            sx = null;
            this.sheets.remove(sheetIndex);
        }
        if (sx == null) {
            Map map = this.sheets;
            synchronized (map) {
                sx = new SheetXls(this, sheet, this.dataFormat, this.isXls, this.evaluator);
                int len = this.length();
                int i = 1;
                while (i <= len) {
                    BaseRecord r = this.getRecord(i);
                    if (sx.sheetInfo.getSheetName().equals(r.getFieldValue(0))) {
                        sx.sheetInfo.setRowCount((Integer)r.getFieldValue(1));
                        sx.sheetInfo.setColCount((Integer)r.getFieldValue(2));
                    }
                    ++i;
                }
                this.sheets.put(new Integer(sheetIndex), sx);
            }
        }
        return sx;
    }

    @Override
    public void xlsclose() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.sheets.clear();
        if (this.wb instanceof SXSSFWorkbook) {
            this.output(this.fo, this.pwd);
        }
        if (this.wb != null) {
            try {
                this.wb.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.isClosed = true;
    }

    public void cloneSheet(String s, String s1) {
        int sheetIndex = this.wb.getSheetIndex(s);
        Sheet sheet = this.wb.cloneSheet(sheetIndex);
        BaseRecord sheetInfo = this.getRecord(sheetIndex + 1);
        int targetSheetIndex = this.wb.getSheetIndex(sheet);
        this.wb.setSheetName(targetSheetIndex, s1);
        this.insert(targetSheetIndex + 1, new Object[]{s1, sheetInfo.getFieldValue(1), sheetInfo.getFieldValue(2)});
    }
}

