/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.DataStruct;
import com.scudata.dm.cursor.ICursor;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.ExcelVersionCompatibleUtilGetter;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SheetHandler
extends DefaultHandler {
    private final SharedStrings sst;
    private final StylesTable styles;
    private String lastContents;
    private String cellType;
    private boolean inlineStr;
    private final LruCache<Integer, String> lruCache = new LruCache(50);
    private Object[] rowData = new Object[255];
    private int row = -1;
    private int col = 0;
    private int endCol = 0;
    private DataStruct ds = null;
    private int[] indexes = null;
    private String style = null;
    private int colCount = 0;
    private String[] fields;
    private int startRow = 0;
    private int endRow = 0;
    private boolean removeBlank = false;
    public static final Boolean ENDING_OBJECT = Boolean.FALSE;
    private ArrayBlockingQueue<Object> que = new ArrayBlockingQueue(ICursor.FETCHCOUNT);
    private boolean bTitle;

    protected SheetHandler(StylesTable styles, SharedStrings sst, String[] fields, int startRow, int endRow, boolean removeBlank, boolean bTitle, ArrayBlockingQueue<Object> que) {
        this.sst = sst;
        this.styles = styles;
        this.fields = fields;
        this.startRow = startRow;
        this.endRow = endRow;
        this.removeBlank = removeBlank;
        this.bTitle = bTitle;
        this.que = que;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("row")) {
            String orow = attributes.getValue("r");
            int newRow = this.row + 1;
            if (orow instanceof String) {
                newRow = Integer.parseInt(orow) - 1;
            }
            if (newRow < this.startRow) {
                return;
            }
            if (newRow > this.startRow && this.row == -1 && !this.removeBlank) {
                try {
                    if (this.fields != null && this.fields.length > 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(String.valueOf(this.fields[0]) + mm.getMessage("ds.fieldNotExist"));
                    }
                    this.que.put(ENDING_OBJECT);
                    return;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.ds != null && this.row != -1 && newRow - this.row > 1) {
                try {
                    int i = 0;
                    int count = newRow - this.row;
                    while (i < count) {
                        this.que.put(new Object[this.ds.getFieldCount()]);
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.row = newRow;
            this.col = 0;
            this.rowData = this.ds != null ? new Object[this.ds.getFieldCount()] : new Object[255];
        } else if (name.equals("c")) {
            this.cellType = attributes.getValue("t");
            this.inlineStr = this.cellType != null && this.cellType.equals("inlineStr");
            this.style = attributes.getValue("s");
            String r = attributes.getValue("r");
            int firstDigit = -1;
            int c = 0;
            while (c < r.length()) {
                if (Character.isDigit(r.charAt(c))) {
                    firstDigit = c;
                    break;
                }
                ++c;
            }
            this.col = ExcelUtils.nameToColumn(r.substring(0, firstDigit));
            this.endCol = Math.max(this.col, this.endCol);
        }
        this.lastContents = "";
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equals("row")) {
            if (this.row < this.startRow) {
                return;
            }
            try {
                int f;
                int fcount;
                if (this.endRow > 0 && this.row > this.endRow) {
                    this.que.put(ENDING_OBJECT);
                    return;
                }
                int n = fcount = this.rowData == null ? 0 : this.endCol + 1;
                if (fcount == 0) {
                    this.que.put(ENDING_OBJECT);
                    return;
                }
                if (this.ds == null) {
                    String[] items;
                    if (this.bTitle) {
                        items = new String[fcount];
                        f = 0;
                        while (f < fcount) {
                            items[f] = this.rowData[f] == null ? "col" + (f + 1) : Variant.toString(this.rowData[f]);
                            ++f;
                        }
                        this.ds = new DataStruct(items);
                    } else {
                        items = new String[fcount];
                        this.ds = new DataStruct(items);
                    }
                    if (this.fields != null && this.fields.length > 0) {
                        this.indexes = new int[fcount];
                        int i = 0;
                        while (i < fcount) {
                            this.indexes[i] = -1;
                            ++i;
                        }
                        i = 0;
                        int count = this.fields.length;
                        while (i < count) {
                            int q = this.ds.getFieldIndex(this.fields[i]);
                            if (q < 0) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(String.valueOf(this.fields[i]) + mm.getMessage("ds.fieldNotExist"));
                            }
                            if (this.indexes[q] != -1) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(String.valueOf(this.fields[i]) + mm.getMessage("ds.colNameRepeat"));
                            }
                            this.indexes[q] = i;
                            this.fields[i] = this.ds.getFieldName(q);
                            ++i;
                        }
                    }
                    this.colCount = this.fields != null && this.fields.length > 0 ? this.fields.length : this.ds.getFieldCount();
                }
                Object[] line = new Object[this.colCount];
                f = 0;
                int count = fcount;
                while (f < count) {
                    if (this.indexes == null) {
                        if (f < this.colCount) {
                            line[f] = this.rowData[f];
                        }
                    } else if (this.indexes.length > f && this.indexes[f] != -1) {
                        line[this.indexes[f]] = this.rowData[f];
                    }
                    ++f;
                }
                ++this.row;
                this.que.put(line);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("v") || this.inlineStr && name.equals("c")) {
            if (this.col > this.rowData.length - 1) {
                if (this.ds != null) {
                    return;
                }
                Object[] newData = new Object[this.rowData.length + 50];
                System.arraycopy(this.rowData, 0, newData, 0, this.rowData.length);
                this.rowData = newData;
            }
            if (this.cellType != null) {
                if ("s".equals(this.cellType)) {
                    Integer idx = Integer.valueOf(this.lastContents);
                    this.lastContents = (String)this.lruCache.get(idx);
                    if (this.lastContents == null && !this.lruCache.containsKey(idx)) {
                        RichTextString rts = ExcelVersionCompatibleUtilGetter.getInstance().getItemAt(this.sst, idx);
                        this.lastContents = rts == null ? null : rts.toString();
                        this.lruCache.put(idx, this.lastContents);
                    }
                    this.rowData[this.col] = this.lastContents;
                    return;
                }
                if ("b".equals(this.cellType)) {
                    this.rowData[this.col] = Integer.parseInt(this.lastContents) == 1 ? Boolean.TRUE : Boolean.FALSE;
                    return;
                }
                if ("str".equals(this.cellType) || "e".equals(this.cellType)) {
                    this.rowData[this.col] = this.lastContents;
                    return;
                }
            }
            try {
                double d = Double.parseDouble(this.lastContents);
                if (this.style != null && this.style.trim().length() > 0) {
                    String f;
                    short i;
                    XSSFCellStyle cellStyle = this.styles.getStyleAt(Integer.parseInt(this.style));
                    if (DateUtil.isValidExcelDate((double)d) && ExcelUtils.isADateFormat(i = cellStyle.getDataFormat(), f = cellStyle.getDataFormatString())) {
                        java.util.Date dd;
                        java.util.Date date = dd = DateUtil.getJavaDate((double)d);
                        int dateType = ExcelUtils.getDateType(i, f);
                        if (dateType == 0) {
                            date = new Date(dd.getTime());
                        } else if (dateType == 1) {
                            date = new Time(dd.getTime());
                        } else if (dateType == 2) {
                            date = new Timestamp(dd.getTime());
                        }
                        this.rowData[this.col] = date;
                        return;
                    }
                }
                this.rowData[this.col] = ExcelUtils.getNumericCellValue(d);
            }
            catch (Exception ex) {
                this.rowData[this.col] = this.lastContents;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = String.valueOf(this.lastContents) + new String(ch, start, length);
    }

    private class LruCache<A, B>
    extends LinkedHashMap<A, B> {
        private static final long serialVersionUID = 1L;
        private final int maxEntries;

        public LruCache(int maxEntries) {
            super(maxEntries + 1, 1.0f, true);
            this.maxEntries = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<A, B> eldest) {
            return super.size() > this.maxEntries;
        }
    }
}

