/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.excel.BreakException;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.SheetInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SheetInfoHandler
extends DefaultHandler {
    private SheetInfo sheetInfo;

    SheetInfoHandler(SheetInfo si) {
        this.sheetInfo = si;
        this.sheetInfo.setRowCount(0);
        this.sheetInfo.setColCount(0);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("dimension")) {
            String ref = attributes.getValue("ref");
            if (StringUtils.isValidString(ref)) {
                int sepIndex = ref.indexOf(":");
                int rowCount = 0;
                int colCount = 0;
                if (sepIndex > -1) {
                    String v = ref.substring(sepIndex + 1, ref.length());
                    String s = v.replaceAll("[\\d]", "");
                    colCount = ExcelUtils.nameToColumn(s) + 1;
                    rowCount = ExcelUtils.getLabelNumber(v);
                    this.sheetInfo.setRowCount(rowCount);
                    this.sheetInfo.setColCount(colCount);
                } else {
                    Logger.debug("Invalid sheet dimension of " + this.sheetInfo.getSheetName() + ": " + ref);
                }
            } else {
                Logger.debug("The sheet dimension of " + this.sheetInfo.getSheetName() + " is empty");
            }
            throw new BreakException();
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }
}

