/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.CellLocation;
import com.scudata.common.Matrix;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.excel.ExcelTool;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.ExcelVersionCompatibleUtilGetter;
import com.scudata.excel.FileXls;
import com.scudata.excel.IXlsExporter;
import com.scudata.excel.IXlsImporter;
import com.scudata.excel.RowAndCellStyle;
import com.scudata.excel.SheetInfo;
import com.scudata.excel.SheetObject;
import com.scudata.expression.Expression;
import com.scudata.resources.AppMessage;
import com.scudata.util.Variant;
import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Shape;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class SheetXls
extends SheetObject {
    FileXls xlsFile;
    private Sheet sheet = null;
    private DataFormat dataFormat;
    private FormulaEvaluator evaluator;
    private volatile boolean writeTitle;
    private volatile boolean isAppend;
    private Map<String, byte[]> graphMap = null;
    private RowAndCellStyle dataStyle;
    private CellStyle[] colStyles;
    private HashMap<Integer, CellStyle> styles = new HashMap();
    private volatile boolean resetDataStyle = true;
    private static final String ROW_COL_SEP = "_";

    public SheetXls(FileXls xlsFile, Sheet sheet, DataFormat dataFormat, boolean isXls, FormulaEvaluator evaluator) {
        this.xlsFile = xlsFile;
        this.sheet = sheet;
        this.dataFormat = dataFormat;
        this.isXls = isXls;
        this.evaluator = evaluator;
        this.sheetInfo = new SheetInfo(sheet.getSheetName());
    }

    public int getMaxRowCount() {
        if (this.isXls) {
            return 65536;
        }
        return 0x100000;
    }

    public int getMaxColCount() {
        if (this.isXls) {
            return 256;
        }
        return 16384;
    }

    public synchronized void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        this.sheet.shiftRows(startRow, endRow, n, copyRowHeight, resetOriginalRowHeight);
    }

    public void writeLine(int row, Object[] line) {
        this.writeLine(row, line, 0, line == null ? 0 : line.length);
    }

    public void writeLine(int currRow, Object[] items, int startCol, int endCol) {
        if (this.sheet == null || items == null || items.length == 0) {
            return;
        }
        Row row = null;
        if (currRow <= this.sheet.getLastRowNum()) {
            row = this.sheet.getRow(currRow);
        }
        if (row == null) {
            row = this.sheet.createRow(currRow);
        }
        RowAndCellStyle rowAndCellStyle = null;
        CellStyle[] cellStyles = null;
        CellStyle rowStyle = null;
        if (this.isAppend) {
            rowAndCellStyle = this.writeTitle ? this.getRowStyle(currRow) : this.dataStyle;
        }
        if (rowAndCellStyle != null) {
            rowStyle = rowAndCellStyle.rowStyle;
            cellStyles = rowAndCellStyle.cellStyles;
        }
        this.writeRowData(row, items, startCol, endCol, rowStyle, cellStyles);
        if (this.writeTitle) {
            this.writeTitle = false;
        } else if (this.isAppend && this.resetDataStyle) {
            this.resetDataStyle(row);
        }
    }

    public Object[] readLine(int currRow) {
        if (currRow > this.sheet.getLastRowNum()) {
            return null;
        }
        Row row = this.sheet.getRow(currRow);
        return ExcelUtils.getRowData(row, this.dataFormat, this.evaluator);
    }

    public int totalCount() {
        return this.sheet.getLastRowNum() + 1;
    }

    public int getStartRow(boolean hasTitle) {
        int lastRow;
        block10: {
            lastRow = this.sheet.getLastRowNum();
            if (lastRow >= 0) break block10;
            return 0;
        }
        try {
            int startRow;
            int lastContentRow = -1;
            int colCount = 0;
            int r = lastRow;
            while (r >= 0) {
                Row row = this.sheet.getRow(r);
                if (row != null) {
                    short lastCol = row.getLastCellNum();
                    colCount = Math.max(lastCol, colCount);
                    if (!ExcelUtils.isEmptyRow(row, lastCol)) {
                        lastContentRow = r;
                        break;
                    }
                }
                --r;
            }
            if (hasTitle) {
                if (lastContentRow == -1) {
                    lastContentRow = 0;
                }
                startRow = lastContentRow;
                this.dataStyle = this.getRowStyle(lastContentRow + 1);
            } else {
                startRow = lastContentRow == -1 ? 0 : lastContentRow + 1;
                this.dataStyle = lastContentRow < lastRow ? this.getRowStyle(lastContentRow + 1) : this.getRowStyle(lastContentRow);
            }
            this.colStyles = new CellStyle[colCount];
            int c = 0;
            while (c < colCount) {
                this.colStyles[c] = this.sheet.getColumnStyle(c);
                ++c;
            }
            return startRow;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public Object xlsimport(String[] fields, int startRow, int endRow, String opt) throws IOException {
        IXlsImporter xlsImporter = new IXlsImporter(){

            @Override
            public Object[] readLine(int row, boolean isN, boolean isW) throws IOException {
                Object[] line = SheetXls.this.readLine(row);
                if (line == null) {
                    return null;
                }
                if (isN) {
                    int i = 0;
                    while (i < line.length) {
                        line[i] = ExcelUtils.trim(line[i], isW);
                        ++i;
                    }
                }
                return line;
            }

            @Override
            public int totalCount() {
                return SheetXls.this.totalCount();
            }

            @Override
            public void setStartRow(int startRow) {
            }
        };
        return ExcelTool.fileXlsImport(fields, startRow, endRow, opt, xlsImporter);
    }

    public void xlsexport(Sequence series, Expression[] exps, String[] names, int startRow, String opt, Context ctx) throws IOException {
        this.writeTitle = opt != null && opt.indexOf("t") != -1;
        this.isAppend = opt != null && opt.indexOf("a") != -1;
        IXlsExporter xlsExporter = new IXlsExporter(){

            @Override
            public void writeLine(int row, Object[] items) throws IOException {
                SheetXls.this.writeLine(row, items);
            }
        };
        int[] rc = ExcelTool.fileXlsExport(series, exps, names, startRow, opt, ctx, xlsExporter);
        if (rc != null) {
            this.sheetInfo.setRowCount(Math.max(this.sheetInfo.getRowCount(), rc[0]));
            this.sheetInfo.setColCount(Math.max(this.sheetInfo.getColCount(), rc[1]));
        }
    }

    public void xlsexport(ICursor cursor, Expression[] exps, String[] names, int startRow, String opt, Context ctx) throws IOException {
        this.writeTitle = opt != null && opt.indexOf("t") != -1;
        this.isAppend = opt != null && opt.indexOf("a") != -1;
        IXlsExporter xlsExporter = new IXlsExporter(){

            @Override
            public void writeLine(int row, Object[] items) throws IOException {
                SheetXls.this.writeLine(row, items);
            }
        };
        int[] rc = ExcelTool.fileXlsExport(cursor, exps, names, startRow, opt, ctx, xlsExporter);
        if (rc != null) {
            this.sheetInfo.setRowCount(Math.max(this.sheetInfo.getRowCount(), rc[0]));
            this.sheetInfo.setColCount(Math.max(this.sheetInfo.getColCount(), rc[1]));
        }
    }

    private synchronized Map<String, byte[]> getGraphMap() {
        if (this.graphMap == null) {
            this.graphMap = new HashMap<String, byte[]>();
            if (this.sheet != null) {
                if (this.isXls) {
                    for (Shape shape : this.sheet.getDrawingPatriarch()) {
                        Picture picture;
                        PictureData pdata;
                        if (!(shape instanceof Picture) || (pdata = (picture = (Picture)shape).getPictureData()) == null) continue;
                        ClientAnchor cAnchor = picture.getClientAnchor();
                        String key = String.valueOf(cAnchor.getRow1()) + ROW_COL_SEP + cAnchor.getCol1();
                        this.graphMap.put(key, pdata.getData());
                    }
                } else if (this.sheet instanceof XSSFSheet) {
                    ExcelVersionCompatibleUtilGetter.getInstance().getSheetPictures((XSSFSheet)this.sheet, this.graphMap);
                }
            }
        }
        return this.graphMap;
    }

    public Object getCells(CellLocation pos1, CellLocation pos2, boolean isGraph, boolean isW, boolean isP, boolean isN) {
        try {
            int endCol;
            int endRow;
            int startRow = pos1.getRow() - 1;
            int startCol = pos1.getCol() - 1;
            if (isGraph) {
                return this.getCellGraph(startRow, startCol);
            }
            if (pos2 != null) {
                endRow = pos2.getRow() - 1;
                endCol = pos2.getCol() - 1;
            } else {
                endRow = startRow;
                endCol = startCol;
            }
            if (isW) {
                return this.getCellsW(startRow, startCol, endRow, endCol, isP, isN);
            }
            return this.getCells(startRow, startCol, endRow, endCol, isN);
        }
        catch (Exception ex) {
            throw new RQException(ex.getMessage(), ex);
        }
    }

    private Object getCells(int startRow, int startCol, int endRow, int endCol, boolean isN) {
        int colCount = -1;
        StringBuffer buf = new StringBuffer();
        int i = startRow;
        while (i <= endRow) {
            Object[] line;
            if (i >= this.getMaxRowCount()) break;
            if (i > startRow) {
                buf.append(ExcelTool.ROW_SEP);
            }
            if ((line = this.readLine(i)) != null && line.length != 0) {
                if (colCount == -1) {
                    colCount = endCol - startCol + 1;
                }
                Object[] cutLine = new Object[colCount];
                int c = 0;
                while (c < colCount) {
                    if (startCol + c < line.length) {
                        cutLine[c] = line[startCol + c];
                        if (isN) {
                            cutLine[c] = ExcelUtils.trim(cutLine[c], false);
                        }
                    }
                    ++c;
                }
                c = 0;
                while (c < cutLine.length) {
                    String val;
                    if (c > 0) {
                        buf.append("\t");
                    }
                    if ((val = Variant.toExportString(cutLine[c])) == null) {
                        val = "";
                    }
                    buf.append((Object)val);
                    ++c;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    private Object getCellsW(int startRow, int startCol, int endRow, int endCol, boolean isP, boolean isN) {
        int colCount = -1;
        Sequence seq = new Sequence();
        int i = startRow;
        while (i <= endRow) {
            Object[] line = this.readLine(i);
            Sequence subSeq = new Sequence();
            if (line == null || line.length == 0) {
                seq.add(subSeq);
            } else {
                if (colCount == -1) {
                    colCount = endCol - startCol + 1;
                }
                Object[] cutLine = new Object[colCount];
                int c = 0;
                while (c < colCount) {
                    if (startCol + c < line.length) {
                        cutLine[c] = line[startCol + c];
                        if (isN) {
                            cutLine[c] = ExcelUtils.trim(cutLine[c], true);
                        }
                    }
                    ++c;
                }
                c = 0;
                while (c < cutLine.length) {
                    subSeq.add(cutLine[c]);
                    ++c;
                }
                seq.add(subSeq);
            }
            ++i;
        }
        if (isP) {
            seq = ExcelUtils.transpose(seq);
        }
        return seq;
    }

    public void setCells(CellLocation pos1, CellLocation pos2, Object content, boolean isRowInsert, boolean isGraph) {
        block19: {
            int totalCount;
            int startCol;
            int startRow;
            block14: {
                startRow = pos1.getRow() - 1;
                startCol = pos1.getCol() - 1;
                if (isGraph) {
                    this.setCellGraph(startRow, startCol, (byte[])content);
                    return;
                }
                totalCount = this.totalCount();
                if (!(content instanceof Sequence)) break block14;
                Sequence seq = (Sequence)content;
                int rowCount = seq.length();
                if (isRowInsert) {
                    if (totalCount + rowCount - 1 > this.getMaxRowCount()) {
                        throw new RQException("xlscell" + AppMessage.get().getMessage("filexls.morethanmax", this.getMaxRowCount()));
                    }
                    if (startRow < totalCount - 1) {
                        this.shiftRows(startRow + 1, totalCount - 1, rowCount, false, false);
                    }
                    ++startRow;
                }
                int endRow = startRow + rowCount;
                int lastCol = startCol;
                if (pos2 != null) {
                    endRow = Math.min(pos2.getRow(), endRow);
                }
                int r = startRow;
                while (r < endRow) {
                    block15: {
                        Object[] line;
                        int endCol;
                        block17: {
                            Object rowData;
                            block18: {
                                block16: {
                                    if (r >= this.getMaxRowCount()) break;
                                    rowData = seq.get(r - startRow + 1);
                                    if (rowData == null) break block15;
                                    if (!(rowData instanceof Sequence)) break block16;
                                    Sequence rowSeq = (Sequence)rowData;
                                    int colCount = rowSeq.length();
                                    if (colCount == 0) break block15;
                                    endCol = startCol + colCount;
                                    line = new Object[colCount];
                                    int c = 0;
                                    while (c < colCount) {
                                        line[c] = rowSeq.get(c + 1);
                                        ++c;
                                    }
                                    break block17;
                                }
                                if (!(rowData instanceof BaseRecord)) break block18;
                                BaseRecord record = (BaseRecord)rowData;
                                line = record.getFieldValues();
                                if (line == null || line.length == 0) break block15;
                                endCol = startCol + line.length;
                                break block17;
                            }
                            line = new Object[]{rowData};
                            endCol = 1;
                        }
                        lastCol = Math.max(lastCol, endCol);
                        this.writeLine(r, line, startCol, endCol);
                    }
                    ++r;
                }
                this.sheetInfo.setRowCount(this.sheetInfo.getRowCount() + rowCount);
                this.sheetInfo.setColCount(Math.max(this.sheetInfo.getColCount(), lastCol));
                break block19;
            }
            if (content instanceof Matrix) {
                Matrix matrix = (Matrix)content;
                int rowCount = matrix.getRowSize();
                if (isRowInsert) {
                    if (totalCount + rowCount - 1 > this.getMaxRowCount()) {
                        throw new RQException("xlscell" + AppMessage.get().getMessage("filexls.morethanmax", this.getMaxRowCount()));
                    }
                    if (startRow < totalCount - 1) {
                        this.shiftRows(startRow + 1, totalCount - 1, rowCount, false, false);
                    }
                    ++startRow;
                }
                int endRow = startRow + rowCount;
                int endCol = startCol + matrix.getColSize();
                if (pos2 != null) {
                    int pos2Row = pos2.getRow();
                    if (isRowInsert) {
                        ++pos2Row;
                    }
                    endRow = Math.min(pos2Row, endRow);
                    endCol = Math.min(pos2.getCol(), endCol);
                }
                int r = startRow;
                while (r < endRow) {
                    if (r >= this.getMaxRowCount()) break;
                    Object[] line = matrix.getRow(r - startRow);
                    this.writeLine(r, line, startCol, endCol);
                    ++r;
                }
                this.sheetInfo.setRowCount(this.sheetInfo.getRowCount() + rowCount);
                this.sheetInfo.setColCount(Math.max(this.sheetInfo.getColCount(), endCol));
            }
        }
    }

    public void rename(String sheetName) {
        Workbook wb = this.xlsFile.getWorkbook();
        int sheetIndex = wb.getSheetIndex(this.sheet);
        wb.setSheetName(sheetIndex, sheetName);
        this.sheetInfo.setSheetName(sheetName);
    }

    @Override
    public void close() {
    }

    private Object getCellGraph(int row, int col) {
        Map<String, byte[]> map = this.getGraphMap();
        byte[] data = map.get(String.valueOf(row) + ROW_COL_SEP + col);
        return data;
    }

    private void setCellGraph(int row, int col, byte[] data) {
        HSSFClientAnchor anchor;
        if (this.sheet == null) {
            return;
        }
        Workbook wb = this.xlsFile.getWorkbook();
        if (this.isXls) {
            anchor = new HSSFClientAnchor(0, 0, 1023, 255, (short)col, row, (short)col, row);
            HSSFPatriarch hssfPatriarch = ((HSSFSheet)this.sheet).getDrawingPatriarch();
            if (hssfPatriarch == null) {
                hssfPatriarch = ((HSSFSheet)this.sheet).createDrawingPatriarch();
            }
            hssfPatriarch.createPicture((ClientAnchor)anchor, wb.addPicture(data, 6));
        } else {
            anchor = new XSSFClientAnchor(0, 0, 1023, 255, col, row, col + 1, row + 1);
            XSSFDrawing xssfPatriarch = ((XSSFSheet)this.sheet).getDrawingPatriarch();
            if (xssfPatriarch == null) {
                xssfPatriarch = ((XSSFSheet)this.sheet).createDrawingPatriarch();
            }
            xssfPatriarch.createPicture((ClientAnchor)anchor, wb.addPicture(data, 6));
        }
        Map<String, byte[]> map = this.getGraphMap();
        map.put(String.valueOf(row) + ROW_COL_SEP + col, data);
    }

    private RowAndCellStyle getRowStyle(int r) {
        Row hr = this.sheet.getRow(r);
        if (hr == null) {
            return null;
        }
        RowAndCellStyle style = new RowAndCellStyle();
        style.rowStyle = hr.getRowStyle();
        int lastCol = hr.getLastCellNum();
        if (lastCol > 0) {
            CellStyle[] cellStyles = new CellStyle[lastCol];
            int c = 0;
            while (c < lastCol) {
                Cell cell = hr.getCell(c);
                if (cell != null) {
                    cellStyles[c] = cell.getCellStyle();
                }
                ++c;
            }
            style.cellStyles = cellStyles;
        }
        style.rowHeight = hr.getHeightInPoints();
        return style;
    }

    private void writeRowData(Row row, Object[] items, int startCol, int endCol, CellStyle rowStyle, CellStyle[] cellStyles) {
        if (items == null || items.length == 0) {
            return;
        }
        CellStyle rowOrColStyle = null;
        int currCol = startCol;
        while (currCol < endCol) {
            Object value;
            CellStyle cellStyle;
            Cell cell = row.getCell(currCol);
            if (cell == null) {
                cellStyle = null;
                cell = row.createCell(currCol);
                if (cellStyles != null && cellStyles.length > currCol) {
                    cellStyle = cellStyles[currCol];
                    cell.setCellStyle(cellStyle);
                }
            } else {
                cellStyle = cell.getCellStyle();
            }
            if (cellStyle == null) {
                if (rowStyle != null) {
                    cell.setCellStyle(rowStyle);
                    rowOrColStyle = rowStyle;
                } else if (this.colStyles != null && currCol < this.colStyles.length && this.colStyles[currCol] != null) {
                    cell.setCellStyle(this.colStyles[currCol]);
                    rowOrColStyle = this.colStyles[currCol];
                }
            }
            if ((value = items[currCol - startCol]) instanceof Date) {
                cell.setCellValue((Date)value);
                DataFormat dFormat = this.xlsFile.getWorkbook().createDataFormat();
                if (cellStyle == null && !ExcelUtils.isCellDateFormatted(cell, dFormat)) {
                    CellStyle style = null;
                    short format = 49;
                    format = value instanceof Timestamp ? (short)dFormat.getFormat(Env.getDateTimeFormat()) : (value instanceof Time ? (short)dFormat.getFormat(Env.getTimeFormat()) : (short)dFormat.getFormat(Env.getDateFormat()));
                    style = this.styles.get(new Integer(currCol));
                    if (style == null) {
                        style = this.xlsFile.getWorkbook().createCellStyle();
                        if (rowOrColStyle != null) {
                            style.cloneStyleFrom(rowOrColStyle);
                        }
                        style.setDataFormat(format);
                        this.styles.put(new Integer(currCol), style);
                    }
                    cell.setCellStyle(style);
                }
            } else if (value instanceof String) {
                String sValue = (String)value;
                if (ExcelUtils.isNumeric(sValue)) {
                    cell.setCellType(CellType.STRING);
                }
                cell.setCellValue(sValue);
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else if (value != null) {
                String s = value.toString();
                try {
                    double d = Double.parseDouble(s);
                    cell.setCellValue(d);
                }
                catch (Throwable e1) {
                    cell.setCellValue(s);
                }
            }
            ++currCol;
        }
        if (rowStyle != null) {
            row.setRowStyle(rowStyle);
        }
    }

    private void resetDataStyle(Row row) {
        int lastCol;
        if (this.dataStyle == null) {
            this.dataStyle = new RowAndCellStyle();
        }
        if ((lastCol = row.getLastCellNum()) > 0) {
            CellStyle[] cellStyles = new CellStyle[lastCol];
            int c = 0;
            while (c < lastCol) {
                Cell cell = row.getCell(c);
                if (cell != null) {
                    cellStyles[c] = cell.getCellStyle();
                }
                ++c;
            }
            this.dataStyle.cellStyles = cellStyles;
        }
        this.resetDataStyle = false;
    }
}

