/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.Logger;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.ExcelVersionCompatibleUtilGetter;
import com.scudata.excel.IExcelTool;
import com.scudata.excel.RowAndCellStyle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class XlsExporter
implements IExcelTool {
    private HSSFWorkbook wb = null;
    private HSSFSheet sheet = null;
    private FileObject fo = null;
    private HashMap<Integer, HSSFCellStyle> styles = new HashMap();
    private boolean hasTitle;
    private boolean writeTitle;
    private boolean isAppend;
    private boolean isK;
    private boolean resetDataStyle = true;
    private int currRow = 0;
    private int maxWriteCount = 65536;
    private RowAndCellStyle dataStyle;
    private HSSFCellStyle[] colStyles;
    private String pwd;
    private boolean sheetExists = false;

    public XlsExporter(FileObject fo, boolean hasTitle, boolean isAppend, Object sheetName, String pwd, boolean isK) {
        this.fo = fo;
        this.hasTitle = hasTitle;
        this.writeTitle = hasTitle;
        this.isAppend = isAppend;
        this.isK = isK;
        this.pwd = pwd;
        InputStream is = null;
        try {
            try {
                int sheetIndex;
                Biff8EncryptionKey.setCurrentUserPassword((String)pwd);
                if (fo.isExists() && (isAppend || isK)) {
                    is = fo.getInputStream();
                    this.wb = new HSSFWorkbook(is);
                    if (StringUtils.isValidString(sheetName)) {
                        this.sheet = this.wb.getSheet((String)sheetName);
                        if (this.sheet == null) {
                            this.sheet = this.wb.createSheet();
                            sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                            this.wb.setSheetName(sheetIndex, (String)sheetName);
                        } else {
                            this.sheetExists = true;
                            this.loadStyles();
                        }
                    } else {
                        int sheetCount = ExcelVersionCompatibleUtilGetter.getInstance().getNumberOfSheets((Workbook)this.wb);
                        if (sheetCount <= 0) {
                            this.sheet = this.wb.createSheet();
                            int sheetIndex2 = this.wb.getSheetIndex((Sheet)this.sheet);
                            this.wb.setSheetName(sheetIndex2, "Sheet1");
                        } else {
                            this.sheetExists = true;
                            this.sheet = this.wb.getSheetAt(0);
                            this.loadStyles();
                        }
                    }
                } else {
                    this.wb = new HSSFWorkbook();
                    this.sheet = this.wb.createSheet();
                    sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                    this.wb.setSheetName(sheetIndex, StringUtils.isValidString(sheetName) ? (String)sheetName : "Sheet1");
                }
                sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                this.wb.setActiveSheet(sheetIndex);
                this.wb.setSelectedTab(sheetIndex);
            }
            catch (Exception e) {
                throw new RQException(e.getMessage());
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
    }

    @Override
    public int getMaxLineCount() {
        return this.maxWriteCount;
    }

    @Override
    public void writeLine(Object[] items) {
        if (this.sheet == null) {
            return;
        }
        HSSFRow hssfRow = null;
        if (this.currRow <= this.sheet.getLastRowNum()) {
            hssfRow = this.sheet.getRow(this.currRow);
        }
        if (hssfRow == null) {
            hssfRow = this.sheet.createRow(this.currRow);
        }
        RowAndCellStyle rowStyle = null;
        if (this.isAppend) {
            rowStyle = this.writeTitle ? this.getRowStyle(this.currRow) : this.dataStyle;
        }
        this.writeRowData((Row)hssfRow, items, rowStyle == null ? null : rowStyle.rowStyle, rowStyle == null ? null : rowStyle.cellStyles);
        if (this.writeTitle) {
            this.writeTitle = false;
        } else if (this.sheetExists && this.isAppend && this.resetDataStyle) {
            this.resetDataStyle(hssfRow);
        }
        ++this.currRow;
    }

    private void resetDataStyle(HSSFRow hssfRow) {
        int lastCol;
        if (this.dataStyle == null) {
            this.dataStyle = new RowAndCellStyle();
        }
        if ((lastCol = hssfRow.getLastCellNum()) > 0) {
            HSSFCellStyle[] cellStyles = new HSSFCellStyle[lastCol];
            int c = 0;
            while (c < lastCol) {
                HSSFCell cell = hssfRow.getCell(c);
                if (cell != null) {
                    cellStyles[c] = cell.getCellStyle();
                }
                ++c;
            }
            this.dataStyle.cellStyles = cellStyles;
        }
        this.resetDataStyle = false;
    }

    private void writeRowData(Row hssfRow, Object[] items, CellStyle rowStyle, CellStyle[] cellStyles) {
        if (items == null || items.length == 0) {
            return;
        }
        CellStyle rowOrColStyle = null;
        int currCol = 0;
        int maxCol = items.length;
        while (currCol < maxCol) {
            Object value;
            CellStyle cellStyle;
            Cell cell = hssfRow.getCell(currCol);
            if (cell == null) {
                cell = hssfRow.createCell(currCol);
                cellStyle = null;
                if (cellStyles != null && cellStyles.length > currCol) {
                    cellStyle = cellStyles[currCol];
                    cell.setCellStyle(cellStyle);
                }
            } else {
                cellStyle = cell.getCellStyle();
            }
            if (cellStyle == null) {
                if (rowStyle != null) {
                    cell.setCellStyle(rowStyle);
                    rowOrColStyle = rowStyle;
                } else if (this.colStyles != null && currCol < this.colStyles.length && this.colStyles[currCol] != null) {
                    cell.setCellStyle((CellStyle)this.colStyles[currCol]);
                    rowOrColStyle = this.colStyles[currCol];
                }
            }
            try {
                Method m = HSSFCell.class.getMethod("setEncoding", Short.TYPE);
                if (m != null) {
                    m.invoke((Object)cell, new Short(1));
                }
            }
            catch (Exception m) {
                // empty catch block
            }
            if ((value = items[currCol]) instanceof Date) {
                if (value instanceof Time) {
                    cell.setCellValue(ExcelUtils.getExcelTimeDouble((Time)value));
                } else {
                    cell.setCellValue((Date)value);
                }
                HSSFDataFormat dFormat = this.wb.createDataFormat();
                if (cellStyle == null && !ExcelUtils.isCellDateFormatted(cell, (DataFormat)dFormat)) {
                    HSSFCellStyle style = null;
                    short format = 49;
                    format = value instanceof Timestamp ? (short)dFormat.getFormat(Env.getDateTimeFormat()) : (value instanceof Time ? (short)dFormat.getFormat(Env.getTimeFormat()) : (short)dFormat.getFormat(Env.getDateFormat()));
                    style = this.styles.get(new Integer(currCol));
                    if (style == null) {
                        style = this.wb.createCellStyle();
                        if (rowOrColStyle != null) {
                            style.cloneStyleFrom(rowOrColStyle);
                        }
                        style.setDataFormat(format);
                        this.styles.put(new Integer(currCol), style);
                    }
                    cell.setCellStyle((CellStyle)style);
                }
            } else if (value instanceof String) {
                String sValue = (String)value;
                if (ExcelUtils.isNumeric(sValue)) {
                    cell.setCellType(CellType.STRING);
                }
                cell.setCellValue(sValue);
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else if (value != null) {
                String s = value.toString();
                try {
                    double d = Double.parseDouble(s);
                    cell.setCellValue(d);
                }
                catch (Throwable e1) {
                    cell.setCellValue(s);
                }
            }
            ++currCol;
        }
        if (rowStyle != null) {
            hssfRow.setRowStyle(rowStyle);
        }
    }

    private RowAndCellStyle getRowStyle(int r) {
        HSSFRow hr = this.sheet.getRow(r);
        if (hr == null) {
            return null;
        }
        RowAndCellStyle style = new RowAndCellStyle();
        style.rowStyle = hr.getRowStyle();
        int lastCol = hr.getLastCellNum();
        if (lastCol > 0) {
            HSSFCellStyle[] cellStyles = new HSSFCellStyle[lastCol];
            int c = 0;
            while (c < lastCol) {
                HSSFCell cell = hr.getCell(c);
                if (cell != null) {
                    cellStyles[c] = cell.getCellStyle();
                }
                ++c;
            }
            style.cellStyles = cellStyles;
        }
        style.rowHeight = hr.getHeightInPoints();
        return style;
    }

    @Override
    public void setSheet(String sheetName) {
        this.currRow = 0;
        int index = 1;
        while (this.wb.getSheet("Sheet" + index) != null) {
            ++index;
        }
        String newName = "Sheet" + index;
        this.sheet = this.wb.createSheet();
        int sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
        this.wb.setSheetName(sheetIndex, newName);
    }

    @Override
    public void setSheet(int index) {
    }

    @Override
    public int totalCount() {
        return 0;
    }

    @Override
    public void setStartRow(int start) {
    }

    @Override
    public void setFetchCount(int fetchCount) {
    }

    @Override
    public void output() {
        if (this.wb != null && this.fo != null) {
            Biff8EncryptionKey.setCurrentUserPassword((String)this.pwd);
            OutputStream out = null;
            try {
                try {
                    out = this.fo.getBufferedOutputStream(false);
                    this.wb.write(out);
                }
                catch (Exception e) {
                    throw new RQException(e.getMessage());
                }
            }
            finally {
                Biff8EncryptionKey.setCurrentUserPassword(null);
                try {
                    this.wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void close() throws IOException {
        this.output();
    }

    @Override
    public Object[] readLine() {
        return null;
    }

    private void loadStyles() {
        if (this.isAppend) {
            this.loadStylesA();
        } else if (this.isK) {
            this.loadStylesK();
        }
    }

    private void loadStylesA() {
        if (this.sheet == null) {
            return;
        }
        try {
            int lastRow = this.sheet.getLastRowNum();
            if (lastRow < 0) {
                return;
            }
            int lastContentRow = -1;
            int colCount = 0;
            int r = lastRow;
            while (r >= 0) {
                HSSFRow hr = this.sheet.getRow(r);
                if (hr != null) {
                    short lastCol = hr.getLastCellNum();
                    colCount = Math.max(lastCol, colCount);
                    if (!ExcelUtils.isEmptyRow((Row)hr, lastCol)) {
                        lastContentRow = r;
                        break;
                    }
                }
                --r;
            }
            if (this.hasTitle) {
                if (lastContentRow == -1) {
                    lastContentRow = 0;
                }
                this.currRow = lastContentRow;
                this.dataStyle = this.getRowStyle(lastContentRow + 1);
            } else {
                this.currRow = lastContentRow == -1 ? 0 : lastContentRow + 1;
                this.dataStyle = lastContentRow < lastRow ? this.getRowStyle(lastContentRow + 1) : this.getRowStyle(lastContentRow);
            }
            this.maxWriteCount -= this.currRow + 1;
            this.colStyles = new HSSFCellStyle[colCount];
            int c = 0;
            while (c < colCount) {
                this.colStyles[c] = this.sheet.getColumnStyle(c);
                ++c;
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private void loadStylesK() {
        if (this.sheet == null) {
            return;
        }
        try {
            int lastRow = this.sheet.getLastRowNum();
            if (lastRow < 0) {
                return;
            }
            int colCount = 0;
            int r = lastRow;
            while (r >= 0) {
                HSSFRow hr = this.sheet.getRow(r);
                if (hr != null) {
                    int lastCol = hr.getLastCellNum();
                    colCount = Math.max(lastCol, colCount);
                    int c = 0;
                    while (c <= lastCol) {
                        HSSFCell cell = hr.getCell(c);
                        if (cell != null) {
                            cell.setBlank();
                            cell.removeCellComment();
                            cell.removeFormula();
                            cell.removeHyperlink();
                        }
                        ++c;
                    }
                }
                --r;
            }
            this.currRow = 0;
            this.dataStyle = this.hasTitle ? this.getRowStyle(1) : this.getRowStyle(0);
            this.maxWriteCount -= this.currRow + 1;
            this.colStyles = new HSSFCellStyle[colCount];
            int c = 0;
            while (c < colCount) {
                this.colStyles[c] = this.sheet.getColumnStyle(c);
                ++c;
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }
}

