/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.RQException;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.IExcelTool;
import com.scudata.resources.AppMessage;
import java.io.InputStream;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;

public class XlsImporter
implements IExcelTool {
    private HSSFWorkbook wb = null;
    private HSSFSheet sheet = null;
    private int currRow;
    private HSSFDataFormat dataFormat;
    private FormulaEvaluator evaluator;
    private int maxRow;

    public XlsImporter(InputStream fis, String pwd) {
        try {
            try {
                Biff8EncryptionKey.setCurrentUserPassword((String)pwd);
                this.wb = new HSSFWorkbook(fis);
                this.sheet = this.wb.getSheetAt(0);
                this.dataFormat = this.wb.createDataFormat();
            }
            catch (EncryptedDocumentException e) {
                if (pwd == null) {
                    throw new RQException(AppMessage.get().getMessage("xlsximporter.xlsnopwd"), e);
                }
                throw new RQException(AppMessage.get().getMessage("xlsximporter.xlsinvalidpwd"), e);
            }
            catch (Exception e) {
                throw new RQException(e.getMessage());
            }
        }
        finally {
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
    }

    @Override
    public int getMaxLineCount() {
        return 65536;
    }

    @Override
    public void setSheet(String name) {
        HSSFSheet s = this.wb.getSheet(name);
        if (s == null) {
            throw new RQException(AppMessage.get().getMessage("excel.nosheetname", name));
        }
        this.sheet = s;
    }

    @Override
    public void setSheet(int index) {
        HSSFSheet s = this.wb.getSheetAt(index);
        if (s == null) {
            throw new RQException(AppMessage.get().getMessage("excel.nosheetindex", String.valueOf(index)));
        }
        this.sheet = s;
    }

    @Override
    public int totalCount() {
        return this.sheet.getLastRowNum() + 1;
    }

    @Override
    public void setStartRow(int start) {
        this.currRow = start;
    }

    @Override
    public void setFetchCount(int fetchCount) {
        this.maxRow = this.currRow + fetchCount - 1;
        if (this.maxRow > this.sheet.getLastRowNum()) {
            this.maxRow = this.sheet.getLastRowNum();
        }
    }

    @Override
    public Object[] readLine() {
        if (this.sheet != null) {
            if (this.maxRow == 0) {
                this.maxRow = this.sheet.getLastRowNum();
            }
            if (this.currRow > this.maxRow) {
                return null;
            }
            HSSFRow hssfRow = this.sheet.getRow(this.currRow);
            ++this.currRow;
            return ExcelUtils.getRowData((Row)hssfRow, (DataFormat)this.dataFormat, this.evaluator);
        }
        return null;
    }

    @Override
    public void output() {
    }

    @Override
    public void writeLine(Object[] items) {
    }

    private void formulaEvaluate() {
        if (this.evaluator != null) {
            return;
        }
        this.evaluator = this.wb.getCreationHelper().createFormulaEvaluator();
        if (this.evaluator != null) {
            this.evaluator.clearAllCachedResultValues();
            this.evaluator.evaluateAll();
        }
    }
}

