/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.CellLocation;
import com.scudata.common.Matrix;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.FileObject;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.ExcelVersionCompatibleUtilGetter;
import com.scudata.resources.AppMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class XlsPaste {
    private HSSFWorkbook wb = null;
    private HSSFSheet sheet = null;
    private FileObject fo = null;
    private String pwd = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XlsPaste(FileObject fo, Object sheetName, CellLocation pos, Matrix data, boolean isRowInsert, String pwd) {
        this.fo = fo;
        this.pwd = pwd;
        InputStream is = null;
        try {
            try {
                int sheetIndex;
                Biff8EncryptionKey.setCurrentUserPassword((String)pwd);
                if (fo.isExists()) {
                    is = fo.getInputStream();
                    this.wb = new HSSFWorkbook(is);
                    if (StringUtils.isValidString(sheetName)) {
                        this.sheet = this.wb.getSheet((String)sheetName);
                        if (this.sheet == null) {
                            this.sheet = this.wb.createSheet();
                            sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                            this.wb.setSheetName(sheetIndex, (String)sheetName);
                        }
                    } else if (sheetName != null && sheetName instanceof Integer) {
                        int sheetCount;
                        sheetIndex = (Integer)sheetName;
                        if (sheetIndex >= (sheetCount = ExcelVersionCompatibleUtilGetter.getInstance().getNumberOfSheets((Workbook)this.wb))) throw new RQException(AppMessage.get().getMessage("excel.nosheetindex", String.valueOf(sheetIndex)));
                        this.sheet = this.wb.getSheetAt(sheetIndex);
                    } else {
                        int sheetCount = ExcelVersionCompatibleUtilGetter.getInstance().getNumberOfSheets((Workbook)this.wb);
                        if (sheetCount <= 0) {
                            this.sheet = this.wb.createSheet();
                            int sheetIndex2 = this.wb.getSheetIndex((Sheet)this.sheet);
                            this.wb.setSheetName(sheetIndex2, "Sheet1");
                        } else {
                            this.sheet = this.wb.getSheetAt(0);
                        }
                    }
                } else {
                    this.wb = new HSSFWorkbook();
                    this.sheet = this.wb.createSheet();
                    sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                    this.wb.setSheetName(sheetIndex, StringUtils.isValidString(sheetName) ? (String)sheetName : "Sheet1");
                }
                sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                this.wb.setActiveSheet(sheetIndex);
                this.wb.setSelectedTab(sheetIndex);
                this.paste(pos, data, isRowInsert);
                return;
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        finally {
            Biff8EncryptionKey.setCurrentUserPassword(null);
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void paste(CellLocation pos, Matrix data, boolean isRowInsert) {
        int startRow = pos.getRow() - 1;
        int startCol = pos.getCol() - 1;
        if (isRowInsert) {
            if (startRow < this.sheet.getLastRowNum()) {
                this.sheet.shiftRows(startRow + 1, this.sheet.getLastRowNum(), data.getRowSize(), true, false);
            }
            ++startRow;
        }
        int r = startRow;
        while (r < startRow + data.getRowSize()) {
            if (r >= 65536) break;
            HSSFRow hr = this.sheet.getRow(r);
            if (hr == null) {
                hr = this.sheet.createRow(r);
            }
            int c = startCol;
            while (c < startCol + data.getColSize()) {
                Object value;
                HSSFCell cell = hr.getCell(c);
                if (cell == null) {
                    cell = hr.createCell(c);
                }
                if ((value = data.get(r - startRow, c - startCol)) instanceof Date) {
                    cell.setCellValue((Date)value);
                } else if (value instanceof String) {
                    String sValue = (String)value;
                    if (ExcelUtils.isNumeric(sValue)) {
                        cell.setCellType(CellType.STRING);
                    }
                    cell.setCellValue(sValue);
                } else if (value instanceof Boolean) {
                    cell.setCellValue(((Boolean)value).booleanValue());
                } else if (value == null) {
                    cell.setCellValue("");
                } else {
                    String s = value.toString();
                    try {
                        double d = Double.parseDouble(s);
                        cell.setCellValue(d);
                    }
                    catch (Throwable e1) {
                        cell.setCellValue(s);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    public void output() {
        if (this.wb != null && this.fo != null) {
            OutputStream out = null;
            try {
                try {
                    Biff8EncryptionKey.setCurrentUserPassword((String)this.pwd);
                    out = this.fo.getBufferedOutputStream(false);
                    this.wb.write(out);
                }
                catch (Exception e) {
                    throw new RQException(e.getMessage(), e);
                }
            }
            finally {
                try {
                    this.wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                Biff8EncryptionKey.setCurrentUserPassword(null);
            }
        }
    }
}

