/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.Logger;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.ExcelVersionCompatibleUtilGetter;
import com.scudata.excel.IExcelTool;
import com.scudata.excel.RowAndCellStyle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxExporter
implements IExcelTool {
    private XSSFWorkbook wb = null;
    private XSSFSheet sheet = null;
    private FileObject fo = null;
    private HashMap<Integer, CellStyle> styles = new HashMap();
    private boolean hasTitle;
    private boolean writeTitle;
    private boolean isAppend;
    private boolean isK;
    private boolean resetDataStyle = true;
    private int currRow = 0;
    private int maxWriteCount = 0x100000;
    private RowAndCellStyle dataStyle;
    private CellStyle[] colStyles;
    private String pwd;
    private boolean sheetExists = false;

    public XlsxExporter(FileObject fo, boolean hasTitle, boolean isAppend, Object sheetName, String pwd, boolean isK) {
        this.fo = fo;
        this.hasTitle = hasTitle;
        this.writeTitle = hasTitle;
        this.isAppend = isAppend;
        this.isK = isK;
        this.pwd = pwd;
        InputStream is = null;
        POIFSFileSystem pfs = null;
        InputStream in = null;
        try {
            try {
                int sheetIndex;
                if (fo.isExists() && (isAppend || isK)) {
                    is = fo.getInputStream();
                    if (pwd != null) {
                        pfs = new POIFSFileSystem(is);
                        in = ExcelUtils.decrypt(pfs, pwd);
                        this.wb = new XSSFWorkbook(in);
                    } else {
                        this.wb = new XSSFWorkbook(is);
                    }
                    if (StringUtils.isValidString(sheetName)) {
                        this.sheet = this.wb.getSheet((String)sheetName);
                        if (this.sheet == null) {
                            this.sheet = this.wb.createSheet();
                            sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                            this.wb.setSheetName(sheetIndex, (String)sheetName);
                        } else {
                            this.sheetExists = true;
                            this.loadStyles();
                        }
                    } else {
                        int sheetCount = ExcelVersionCompatibleUtilGetter.getInstance().getNumberOfSheets((Workbook)this.wb);
                        if (sheetCount <= 0) {
                            this.sheet = this.wb.createSheet();
                            int sheetIndex2 = this.wb.getSheetIndex((Sheet)this.sheet);
                            this.wb.setSheetName(sheetIndex2, "Sheet1");
                        } else {
                            this.sheetExists = true;
                            this.sheet = this.wb.getSheetAt(0);
                            this.loadStyles();
                        }
                    }
                } else {
                    this.wb = new XSSFWorkbook();
                    this.sheet = this.wb.createSheet();
                    sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                    this.wb.setSheetName(sheetIndex, StringUtils.isValidString(sheetName) ? (String)sheetName : "Sheet1");
                }
                sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                this.wb.setActiveSheet(sheetIndex);
                this.wb.setSelectedTab(sheetIndex);
            }
            catch (Exception e) {
                throw new RQException(e.getMessage());
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (pfs != null) {
                try {
                    pfs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public int getMaxLineCount() {
        return this.maxWriteCount;
    }

    @Override
    public void writeLine(Object[] items) {
        if (this.sheet == null) {
            return;
        }
        XSSFRow row = null;
        if (this.currRow <= this.sheet.getLastRowNum()) {
            row = this.sheet.getRow(this.currRow);
        }
        if (row == null) {
            row = this.sheet.createRow(this.currRow);
        }
        RowAndCellStyle rowStyle = null;
        if (this.isAppend) {
            rowStyle = this.writeTitle ? this.getRowStyle(this.currRow) : this.dataStyle;
        }
        this.writeRowData(row, items, rowStyle == null ? null : rowStyle.rowStyle, rowStyle == null ? null : rowStyle.cellStyles);
        if (this.writeTitle) {
            this.writeTitle = false;
        } else if (this.sheetExists && this.isAppend && this.resetDataStyle) {
            this.resetDataStyle(row);
        }
        ++this.currRow;
    }

    private void resetDataStyle(XSSFRow row) {
        int lastCol;
        if (this.dataStyle == null) {
            this.dataStyle = new RowAndCellStyle();
        }
        if ((lastCol = row.getLastCellNum()) > 0) {
            CellStyle[] cellStyles = new CellStyle[lastCol];
            int c = 0;
            while (c < lastCol) {
                XSSFCell cell = row.getCell(c);
                if (cell != null) {
                    cellStyles[c] = cell.getCellStyle();
                }
                ++c;
            }
            this.dataStyle.cellStyles = cellStyles;
        }
        this.resetDataStyle = false;
    }

    private void writeRowData(XSSFRow row, Object[] items, CellStyle rowStyle, CellStyle[] cellStyles) {
        if (items == null || items.length == 0) {
            return;
        }
        CellStyle rowOrColStyle = null;
        int currCol = 0;
        int maxCol = items.length;
        while (currCol < maxCol) {
            Object value;
            XSSFCellStyle cellStyle;
            XSSFCell cell = row.getCell(currCol);
            if (cell == null) {
                cellStyle = null;
                cell = row.createCell(currCol);
                if (cellStyles != null && cellStyles.length > currCol) {
                    cellStyle = cellStyles[currCol];
                    cell.setCellStyle((CellStyle)cellStyle);
                }
            } else {
                cellStyle = cell.getCellStyle();
            }
            if (cellStyle == null) {
                if (rowStyle != null) {
                    cell.setCellStyle(rowStyle);
                    rowOrColStyle = rowStyle;
                } else if (this.colStyles != null && currCol < this.colStyles.length && this.colStyles[currCol] != null) {
                    cell.setCellStyle(this.colStyles[currCol]);
                    rowOrColStyle = this.colStyles[currCol];
                }
            }
            if ((value = items[currCol]) instanceof Date) {
                if (value instanceof Time) {
                    cell.setCellValue(ExcelUtils.getExcelTimeDouble((Time)value));
                } else {
                    cell.setCellValue((Date)value);
                }
                XSSFDataFormat dFormat = this.wb.createDataFormat();
                if (cellStyle == null && !ExcelUtils.isCellDateFormatted((Cell)cell, (DataFormat)dFormat)) {
                    CellStyle style = null;
                    short format = 49;
                    format = value instanceof Timestamp ? (short)dFormat.getFormat(Env.getDateTimeFormat()) : (value instanceof Time ? (short)dFormat.getFormat(Env.getTimeFormat()) : (short)dFormat.getFormat(Env.getDateFormat()));
                    style = this.styles.get(new Integer(currCol));
                    if (style == null) {
                        style = this.wb.createCellStyle();
                        if (rowOrColStyle != null) {
                            style.cloneStyleFrom(rowOrColStyle);
                        }
                        style.setDataFormat(format);
                        this.styles.put(new Integer(currCol), style);
                    }
                    cell.setCellStyle(style);
                }
            } else if (value instanceof String) {
                String sValue = (String)value;
                if (ExcelUtils.isNumeric(sValue)) {
                    cell.setCellType(CellType.STRING);
                }
                cell.setCellValue(sValue);
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else if (value != null) {
                String s = value.toString();
                try {
                    double d = Double.parseDouble(s);
                    cell.setCellValue(d);
                }
                catch (Throwable e1) {
                    cell.setCellValue(s);
                }
            }
            ++currCol;
        }
        if (rowStyle != null) {
            row.setRowStyle(rowStyle);
        }
    }

    private RowAndCellStyle getRowStyle(int r) {
        XSSFRow hr = this.sheet.getRow(r);
        if (hr == null) {
            return null;
        }
        RowAndCellStyle style = new RowAndCellStyle();
        style.rowStyle = hr.getRowStyle();
        int lastCol = hr.getLastCellNum();
        if (lastCol > 0) {
            CellStyle[] cellStyles = new CellStyle[lastCol];
            int c = 0;
            while (c < lastCol) {
                XSSFCell cell = hr.getCell(c);
                if (cell != null) {
                    cellStyles[c] = cell.getCellStyle();
                }
                ++c;
            }
            style.cellStyles = cellStyles;
        }
        style.rowHeight = hr.getHeightInPoints();
        return style;
    }

    @Override
    public void setSheet(String sheetName) {
        this.currRow = 0;
        int index = 1;
        while (this.wb.getSheet("Sheet" + index) != null) {
            ++index;
        }
        String newName = "Sheet" + index;
        this.sheet = this.wb.createSheet();
        int sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
        this.wb.setSheetName(sheetIndex, newName);
    }

    @Override
    public void setSheet(int index) {
    }

    @Override
    public int totalCount() {
        return 0;
    }

    @Override
    public void setStartRow(int start) {
    }

    @Override
    public void setFetchCount(int fetchCount) {
    }

    @Override
    public void output() {
        if (this.wb != null && this.fo != null) {
            OutputStream out = null;
            try {
                try {
                    out = this.fo.getBufferedOutputStream(false);
                    this.wb.write(out);
                }
                catch (Exception e) {
                    throw new RQException(e.getMessage());
                }
            }
            finally {
                try {
                    this.wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.pwd != null) {
                ExcelUtils.encrypt(this.fo, this.pwd);
            }
        }
    }

    public void close() throws IOException {
        this.output();
    }

    @Override
    public Object[] readLine() {
        return null;
    }

    private void loadStyles() {
        if (this.isAppend) {
            this.loadStylesA();
        } else if (this.isK) {
            this.loadStylesK();
        }
    }

    private void loadStylesA() {
        if (this.sheet == null) {
            return;
        }
        try {
            int lastRow = this.sheet.getLastRowNum();
            if (lastRow < 0) {
                return;
            }
            int lastContentRow = -1;
            int colCount = 0;
            int r = lastRow;
            while (r >= 0) {
                XSSFRow hr = this.sheet.getRow(r);
                if (hr != null) {
                    short lastCol = hr.getLastCellNum();
                    colCount = Math.max(lastCol, colCount);
                    if (!ExcelUtils.isEmptyRow((Row)hr, lastCol)) {
                        lastContentRow = r;
                        break;
                    }
                }
                --r;
            }
            if (this.hasTitle) {
                if (lastContentRow == -1) {
                    lastContentRow = 0;
                }
                this.currRow = lastContentRow;
                this.dataStyle = this.getRowStyle(lastContentRow + 1);
            } else {
                this.currRow = lastContentRow == -1 ? 0 : lastContentRow + 1;
                this.dataStyle = lastContentRow < lastRow ? this.getRowStyle(lastContentRow + 1) : this.getRowStyle(lastContentRow);
            }
            this.maxWriteCount -= this.currRow + 1;
            this.colStyles = new CellStyle[colCount];
            int c = 0;
            while (c < colCount) {
                this.colStyles[c] = this.sheet.getColumnStyle(c);
                ++c;
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private void loadStylesK() {
        if (this.sheet == null) {
            return;
        }
        try {
            int lastRow = this.sheet.getLastRowNum();
            if (lastRow < 0) {
                return;
            }
            int colCount = 0;
            int r = lastRow;
            while (r >= 0) {
                XSSFRow hr = this.sheet.getRow(r);
                if (hr != null) {
                    int lastCol = hr.getLastCellNum();
                    colCount = Math.max(lastCol, colCount);
                    int c = 0;
                    while (c <= lastCol) {
                        XSSFCell cell = hr.getCell(c);
                        if (cell != null) {
                            cell.setBlank();
                            cell.removeCellComment();
                            cell.removeFormula();
                            cell.removeHyperlink();
                        }
                        ++c;
                    }
                }
                --r;
            }
            this.currRow = 0;
            this.dataStyle = this.hasTitle ? this.getRowStyle(1) : this.getRowStyle(0);
            this.maxWriteCount -= this.currRow + 1;
            this.colStyles = new CellStyle[colCount];
            int c = 0;
            while (c < colCount) {
                this.colStyles[c] = this.sheet.getColumnStyle(c);
                ++c;
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }
}

