/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.CellLocation;
import com.scudata.common.Matrix;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.FileObject;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.ExcelVersionCompatibleUtilGetter;
import com.scudata.resources.AppMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxPaste {
    private XSSFWorkbook wb = null;
    private XSSFSheet sheet = null;
    private FileObject fo = null;
    private String pwd = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XlsxPaste(FileObject fo, Object sheetName, CellLocation pos, Matrix data, boolean isRowInsert, String pwd) {
        this.fo = fo;
        this.pwd = pwd;
        POIFSFileSystem pfs = null;
        InputStream is = null;
        InputStream in = null;
        try {
            try {
                if (fo.isExists()) {
                    is = fo.getInputStream();
                    if (pwd != null) {
                        pfs = new POIFSFileSystem(is);
                        EncryptionInfo info = new EncryptionInfo(pfs);
                        Decryptor d = Decryptor.getInstance((EncryptionInfo)info);
                        if (!d.verifyPassword(pwd)) {
                            throw new RQException(AppMessage.get().getMessage("excel.invalidpwd", pwd));
                        }
                        in = d.getDataStream(pfs);
                        this.wb = new XSSFWorkbook(in);
                    } else {
                        this.wb = new XSSFWorkbook(is);
                    }
                    if (StringUtils.isValidString(sheetName)) {
                        this.sheet = this.wb.getSheet((String)sheetName);
                        if (this.sheet == null) {
                            this.sheet = this.wb.createSheet();
                            int sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                            this.wb.setSheetName(sheetIndex, (String)sheetName);
                        }
                    } else if (sheetName != null && sheetName instanceof Integer) {
                        int sheetCount;
                        int sheetIndex = (Integer)sheetName;
                        if (sheetIndex >= (sheetCount = ExcelVersionCompatibleUtilGetter.getInstance().getNumberOfSheets((Workbook)this.wb))) throw new RQException("Sheet index out of range : " + sheetIndex);
                        this.sheet = this.wb.getSheetAt(sheetIndex);
                    } else {
                        int sheetCount = ExcelVersionCompatibleUtilGetter.getInstance().getNumberOfSheets((Workbook)this.wb);
                        if (sheetCount <= 0) {
                            this.sheet = this.wb.createSheet();
                            int sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                            this.wb.setSheetName(sheetIndex, "Sheet1");
                        } else {
                            this.sheet = this.wb.getSheetAt(0);
                        }
                    }
                } else {
                    this.wb = new XSSFWorkbook();
                    this.sheet = this.wb.createSheet();
                    int sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                    this.wb.setSheetName(sheetIndex, StringUtils.isValidString(sheetName) ? (String)sheetName : "Sheet1");
                }
                int sheetIndex = this.wb.getSheetIndex((Sheet)this.sheet);
                this.wb.setActiveSheet(sheetIndex);
                this.wb.setSelectedTab(sheetIndex);
                this.paste(pos, data, isRowInsert);
                return;
            }
            catch (RQException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RQException(e.getMessage());
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (pfs != null) {
                try {
                    pfs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void paste(CellLocation pos, Matrix data, boolean isRowInsert) {
        int startRow = pos.getRow() - 1;
        int startCol = pos.getCol() - 1;
        if (isRowInsert) {
            if (startRow < this.sheet.getLastRowNum()) {
                this.sheet.shiftRows(startRow + 1, this.sheet.getLastRowNum(), data.getRowSize(), true, false);
            }
            ++startRow;
        }
        int r = startRow;
        while (r < startRow + data.getRowSize()) {
            if (r >= 0x100000) break;
            XSSFRow hr = this.sheet.getRow(r);
            if (hr == null) {
                hr = this.sheet.createRow(r);
            }
            int c = startCol;
            while (c < startCol + data.getColSize()) {
                Object value;
                XSSFCell cell = hr.getCell(c);
                if (cell == null) {
                    cell = hr.createCell(c);
                }
                if ((value = data.get(r - startRow, c - startCol)) instanceof Date) {
                    cell.setCellValue((Date)value);
                } else if (value instanceof String) {
                    String sValue = (String)value;
                    if (ExcelUtils.isNumeric(sValue)) {
                        cell.setCellType(CellType.STRING);
                    }
                    cell.setCellValue(sValue);
                } else if (value instanceof Boolean) {
                    cell.setCellValue(((Boolean)value).booleanValue());
                } else if (value == null) {
                    cell.setCellValue("");
                } else {
                    String s = value.toString();
                    try {
                        double d = Double.parseDouble(s);
                        cell.setCellValue(d);
                    }
                    catch (Throwable e1) {
                        cell.setCellValue(s);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    public void output() {
        if (this.wb != null && this.fo != null) {
            OutputStream out = null;
            try {
                try {
                    out = this.fo.getBufferedOutputStream(false);
                    this.wb.write(out);
                }
                catch (Exception e) {
                    throw new RQException(e.getMessage());
                }
            }
            finally {
                try {
                    this.wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.pwd != null) {
                this.encrypt();
            }
        }
    }

    private void encrypt() {
        block45: {
            POIFSFileSystem fs;
            block44: {
                fs = new POIFSFileSystem();
                InputStream in = null;
                OPCPackage opc = null;
                OutputStream os = null;
                try {
                    try {
                        EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
                        Encryptor enc = info.getEncryptor();
                        enc.confirmPassword(this.pwd);
                        in = this.fo.getInputStream();
                        opc = OPCPackage.open((InputStream)in);
                        os = enc.getDataStream(fs);
                        opc.save(os);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (opc != null) {
                            try {
                                opc.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block44;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (opc != null) {
                        try {
                            opc.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (opc != null) {
                    try {
                        opc.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            OutputStream out = null;
            try {
                try {
                    out = this.fo.getOutputStream(false);
                    fs.writeFilesystem(out);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (out == null) break block45;
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

