/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.app.config.ConfigUtil;
import com.scudata.common.Logger;
import com.scudata.common.RQException;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.ILineInput;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.XlsxSSheetParser;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.eventusermodel.XSSFReader;

public class XlsxSImporter
implements ILineInput {
    private OPCPackage xlsxPackage;
    private XlsxSSheetParser sheetParser;

    public XlsxSImporter(FileObject fo, String[] fields, int startRow, int endRow, Object s, String opt) {
        this(fo, fields, startRow, endRow, s, opt, null);
    }

    public XlsxSImporter(FileObject fo, String[] fields, int startRow, int endRow, Object s, String opt, String pwd) {
        InputStream is = null;
        InputStream in = null;
        POIFSFileSystem pfs = null;
        BufferedInputStream bis = null;
        try {
            try {
                String filePath = fo.getFileName();
                if (fo.isRemoteFile()) {
                    is = fo.getInputStream();
                    if (pwd != null) {
                        pfs = new POIFSFileSystem(is);
                        in = ExcelUtils.decrypt(pfs, pwd);
                        this.xlsxPackage = OPCPackage.open((InputStream)in);
                    } else {
                        this.xlsxPackage = OPCPackage.open((InputStream)is);
                    }
                } else {
                    filePath = ConfigUtil.getPath(Env.getMainPath(), filePath);
                    if (pwd != null) {
                        is = new FileInputStream(filePath);
                        pfs = new POIFSFileSystem(is);
                        in = ExcelUtils.decrypt(pfs, pwd);
                        this.xlsxPackage = OPCPackage.open((InputStream)in);
                    } else {
                        this.xlsxPackage = OPCPackage.open((String)filePath, (PackageAccess)PackageAccess.READ);
                    }
                }
                XSSFReader xssfReader = new XSSFReader(this.xlsxPackage);
                this.sheetParser = new XlsxSSheetParser(xssfReader, fields, startRow, endRow, s, opt);
            }
            catch (RQException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (pfs != null) {
                try {
                    pfs.close();
                }
                catch (Throwable throwable) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Throwable throwable) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public Object[] readLine() {
        return this.sheetParser.readLine();
    }

    @Override
    public boolean skipLine() throws IOException {
        return this.sheetParser.skipLine();
    }

    @Override
    public void close() throws IOException {
        this.sheetParser.close();
        try {
            this.xlsxPackage.close();
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }
}

