/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.dm.Context;
import com.scudata.dm.DBObject;
import com.scudata.dm.Sequence;
import com.scudata.expression.Node;
import com.scudata.util.Variant;

public class Constant
extends Node {
    protected Object value;

    public Constant(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public byte calcExpValueType(Context ctx) {
        if (this.value instanceof DBObject) {
            return 1;
        }
        return 101;
    }

    public boolean append(Constant c) {
        if (this.value instanceof String && c.value instanceof String) {
            this.value = (String)this.value + (String)c.value;
            return true;
        }
        return false;
    }

    public Object calculate(Context ctx) {
        return this.value;
    }

    public IArray calculateAll(Context ctx) {
        Sequence sequence = ctx.getComputeStack().getTopSequence();
        return new ConstArray(this.value, sequence.length());
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        return this.calculateAll(ctx);
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        BoolArray result = leftResult.isTrue();
        if (Variant.isFalse(this.value)) {
            int size = result.size();
            for (int i = 1; i <= size; ++i) {
                result.set(i, false);
            }
        }
        return result;
    }

    public boolean isMonotone() {
        return true;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

