/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.NumberArray;
import com.scudata.array.ObjectArray;
import com.scudata.cellset.INormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.FieldId;
import com.scudata.expression.FieldRef;
import com.scudata.expression.Function;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementRef
extends Function {
    private Node _$2;
    private Expression _$1;

    public ElementRef() {
        this.priority = 18;
    }

    @Override
    public void checkValidity() {
        if (this._$2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("operator.missingleftOperation"));
        }
        this._$2.checkValidity();
        if (this.param != null && this.param.isLeaf()) {
            this._$1 = this.param.getLeafExpression();
        }
    }

    @Override
    public void setLeft(Node node) {
        this._$2 = node;
    }

    @Override
    public Node getLeft() {
        return this._$2;
    }

    @Override
    protected boolean containParam(String name) {
        if (this._$2.containParam(name)) {
            return true;
        }
        return super.containParam(name);
    }

    @Override
    protected void getUsedParams(Context ctx, ParamList resultList) {
        this._$2.getUsedParams(ctx, resultList);
        super.getUsedParams(ctx, resultList);
    }

    @Override
    public void getUsedFields(Context ctx, List<String> resultList) {
        this._$2.getUsedFields(ctx, resultList);
        super.getUsedFields(ctx, resultList);
    }

    @Override
    protected void getUsedCells(List<INormalCell> resultList) {
        this._$2.getUsedCells(resultList);
        super.getUsedCells(resultList);
    }

    @Override
    public void reset() {
        this._$2.reset();
        super.reset();
    }

    @Override
    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        this._$2 = this._$2.optimize(ctx);
        return this;
    }

    @Override
    public Object calculate(Context ctx) {
        Object result1 = this._$2.calculate(ctx);
        if (result1 == null) {
            return null;
        }
        if (!(result1 instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("dot.seriesLeft"));
        }
        if (this._$1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("function.invalidParam"));
        }
        Object o = this._$1.calculate(ctx);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Sequence)result1).get(((Number)o).intValue());
        }
        if (o instanceof Sequence) {
            return ((Sequence)result1).get((Sequence)o);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("()" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public Object assign(Object value, Context ctx) {
        Object result1 = this._$2.calculate(ctx);
        if (!(result1 instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("dot.seriesLeft"));
        }
        if (this._$1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("function.invalidParam"));
        }
        Sequence srcSeries = (Sequence)result1;
        int len = srcSeries.length();
        Object pval = this._$1.calculate(ctx);
        if (pval instanceof Number) {
            int index = ((Number)pval).intValue();
            if (index > len) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(index + mm.getMessage("engine.indexOutofBound"));
            }
            srcSeries.set(index, value);
        } else if (pval instanceof Sequence) {
            Sequence posSeries = (Sequence)pval;
            int count = posSeries.length();
            if (value instanceof Sequence) {
                Sequence tseq = (Sequence)value;
                if (count != tseq.length()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.memCountNotMatch"));
                }
                for (int i = 1; i <= count; ++i) {
                    Object posObj = posSeries.get(i);
                    if (!(posObj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needIntSeries"));
                    }
                    int index = ((Number)posObj).intValue();
                    if (index > len) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(index + mm.getMessage("engine.indexOutofBound"));
                    }
                    srcSeries.set(index, tseq.get(i));
                }
            } else {
                for (int i = 1; i <= count; ++i) {
                    Object posObj = posSeries.get(i);
                    if (!(posObj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needIntSeries"));
                    }
                    int index = ((Number)posObj).intValue();
                    if (index > len) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(index + mm.getMessage("engine.indexOutofBound"));
                    }
                    srcSeries.set(index, value);
                }
            }
        } else if (pval != null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("function.paramTypeError"));
        }
        return value;
    }

    @Override
    public Object addAssign(Object value, Context ctx) {
        Object result1 = this._$2.calculate(ctx);
        if (!(result1 instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("dot.seriesLeft"));
        }
        if (this._$1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("function.invalidParam"));
        }
        Sequence srcSeries = (Sequence)result1;
        int len = srcSeries.length();
        Object pval = this._$1.calculate(ctx);
        if (pval instanceof Number) {
            int index = ((Number)pval).intValue();
            if (index > len) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(index + mm.getMessage("engine.indexOutofBound"));
            }
            Object result = Variant.add(srcSeries.getMem(index), value);
            srcSeries.set(index, result);
            return result;
        }
        if (pval == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("()" + mm.getMessage("function.paramTypeError"));
    }

    public IArray getFieldArray(Context ctx, FieldRef fieldRef) {
        IArray sequenceArray = this._$2.calculateAll(ctx);
        if (this._$1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("function.invalidParam"));
        }
        IArray posArray = this._$1.calculateAll(ctx);
        int len = sequenceArray.size();
        if (sequenceArray instanceof ConstArray) {
            Object obj = sequenceArray.get(1);
            if (obj instanceof Sequence) {
                return ((Sequence)obj).getFieldValueArray(posArray, fieldRef.getName());
            }
            if (obj == null) {
                return new ConstArray(null, len);
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("dot.seriesLeft"));
        }
        ObjectArray result = new ObjectArray(len);
        for (int i = 1; i <= len; ++i) {
            Object obj = sequenceArray.get(i);
            if (obj == null) {
                result.push(null);
                continue;
            }
            if (!(obj instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("()" + mm.getMessage("dot.seriesLeft"));
            }
            Sequence sequence = (Sequence)obj;
            if (posArray instanceof NumberArray) {
                obj = sequence.get(posArray.getInt(i));
            } else {
                obj = posArray.get(i);
                if (obj instanceof Number) {
                    obj = sequence.get(((Number)obj).intValue());
                } else if (obj instanceof Sequence) {
                    obj = sequence.get((Sequence)obj);
                } else if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("()" + mm.getMessage("function.paramTypeError"));
                }
            }
            result.push(obj);
        }
        return fieldRef.getFieldArray(result);
    }

    public IArray getFieldArray(Context ctx, FieldId fieldId) {
        IArray sequenceArray = this._$2.calculateAll(ctx);
        if (this._$1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("function.invalidParam"));
        }
        IArray posArray = this._$1.calculateAll(ctx);
        int len = sequenceArray.size();
        if (sequenceArray instanceof ConstArray) {
            Object obj = sequenceArray.get(1);
            if (obj instanceof Sequence) {
                return ((Sequence)obj).getFieldValueArray(posArray, fieldId.getFieldIndex());
            }
            if (obj == null) {
                return new ConstArray(null, len);
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("dot.seriesLeft"));
        }
        ObjectArray result = new ObjectArray(len);
        for (int i = 1; i <= len; ++i) {
            Object obj = sequenceArray.get(i);
            if (obj == null) {
                result.push(null);
                continue;
            }
            if (!(obj instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("()" + mm.getMessage("dot.seriesLeft"));
            }
            Sequence sequence = (Sequence)obj;
            if (posArray instanceof NumberArray) {
                obj = sequence.get(posArray.getInt(i));
            } else {
                obj = posArray.get(i);
                if (obj instanceof Number) {
                    obj = sequence.get(((Number)obj).intValue());
                } else if (obj instanceof Sequence) {
                    obj = sequence.get((Sequence)obj);
                } else if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("()" + mm.getMessage("function.paramTypeError"));
                }
            }
            result.push(obj);
        }
        return fieldId.getFieldArray(ctx, result);
    }

    @Override
    public IArray calculateAll(Context ctx) {
        IArray sequenceArray = this._$2.calculateAll(ctx);
        if (this._$1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("function.invalidParam"));
        }
        IArray posArray = this._$1.calculateAll(ctx);
        int len = sequenceArray.size();
        if (sequenceArray instanceof ConstArray) {
            Object obj = sequenceArray.get(1);
            if (obj == null) {
                return new ConstArray(null, len);
            }
            if (!(obj instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("()" + mm.getMessage("dot.seriesLeft"));
            }
            Sequence sequence = (Sequence)obj;
            if (posArray instanceof NumberArray) {
                IArray result = sequence.getMemberArray((NumberArray)posArray);
                result.setTemporary(true);
                return result;
            }
            ObjectArray result = new ObjectArray(len);
            result.setTemporary(true);
            for (int i = 1; i <= len; ++i) {
                obj = posArray.get(i);
                if (obj instanceof Number) {
                    obj = sequence.get(((Number)obj).intValue());
                } else if (obj instanceof Sequence) {
                    obj = sequence.get((Sequence)obj);
                } else if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("()" + mm.getMessage("function.paramTypeError"));
                }
                result.push(obj);
            }
            return result;
        }
        ObjectArray result = new ObjectArray(len);
        result.setTemporary(true);
        for (int i = 1; i <= len; ++i) {
            Object obj = sequenceArray.get(i);
            if (obj == null) {
                result.push(null);
                continue;
            }
            if (!(obj instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("()" + mm.getMessage("dot.seriesLeft"));
            }
            Sequence sequence = (Sequence)obj;
            if (!posArray.isNull(i)) {
                if (posArray instanceof NumberArray) {
                    obj = sequence.get(posArray.getInt(i));
                } else {
                    obj = posArray.get(i);
                    if (obj instanceof Number) {
                        obj = sequence.get(((Number)obj).intValue());
                    } else if (obj instanceof Sequence) {
                        obj = sequence.get((Sequence)obj);
                    } else {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("()" + mm.getMessage("function.paramTypeError"));
                    }
                }
            }
            result.push(obj);
        }
        return result;
    }

    @Override
    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        return this.calculateAll(ctx);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        IArray sequenceArray = this._$2.calculateAll(ctx);
        if (this._$1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("function.invalidParam"));
        }
        IArray posArray = this._$1.calculateAll(ctx);
        if (!posArray.isNumberArray()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("function.paramTypeError"));
        }
        BoolArray result = leftResult.isTrue();
        int resultSize = result.size();
        if (sequenceArray instanceof ConstArray) {
            Object obj = sequenceArray.get(1);
            if (obj instanceof Sequence) {
                IArray mems = ((Sequence)obj).getMems();
                for (int i = 1; i <= resultSize; ++i) {
                    if (!result.isTrue(i) || !posArray.isNull(i) && !mems.isFalse(posArray.getInt(i))) continue;
                    result.set(i, false);
                }
                return result;
            } else {
                if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("()" + mm.getMessage("dot.seriesLeft"));
                }
                for (int i = 1; i <= resultSize; ++i) {
                    result.set(i, false);
                }
            }
            return result;
        }
        for (int i = 1; i <= resultSize; ++i) {
            if (!result.isTrue(i)) continue;
            Object obj = sequenceArray.get(i);
            if (obj == null) {
                result.set(i, false);
                continue;
            }
            if (!(obj instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("()" + mm.getMessage("dot.seriesLeft"));
            }
            Sequence sequence = (Sequence)obj;
            if (!posArray.isNull(i) && sequence.isTrue(posArray.getInt(i))) continue;
            result.set(i, false);
        }
        return result;
    }

    @Override
    public int isValueRangeMatch(Context ctx) {
        IArray sequenceArray = this._$2.calculateRange(ctx);
        if (!(sequenceArray instanceof ConstArray)) {
            return 0;
        }
        Object obj = sequenceArray.get(1);
        if (obj == null) {
            return -1;
        }
        if (!(obj instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("dot.seriesLeft"));
        }
        if (this._$1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("()" + mm.getMessage("function.invalidParam"));
        }
        IArray array = this._$1.calculateRange(ctx);
        if (array == null) {
            return 0;
        }
        Sequence sequence = (Sequence)obj;
        Object maxValue = array.get(2);
        int end = 0;
        if (!(maxValue instanceof Number)) {
            if (maxValue == null) {
                return -1;
            }
            return 0;
        }
        end = ((Number)maxValue).intValue();
        Object minValue = array.get(1);
        int start = 0;
        if (minValue instanceof Number) {
            start = ((Number)minValue).intValue();
        } else if (minValue != null) {
            return 0;
        }
        if (end < 1) {
            return -1;
        }
        if (start > 0) {
            if (end - start <= 500) {
                boolean hasTrue = false;
                boolean hasFalse = false;
                for (int i = start; i <= end; ++i) {
                    if (sequence.isTrue(i)) {
                        if (hasFalse) {
                            return 0;
                        }
                        hasTrue = true;
                        continue;
                    }
                    if (hasTrue) {
                        return 0;
                    }
                    hasFalse = true;
                }
                return hasTrue ? 1 : -1;
            }
            return 0;
        }
        if (end - start <= 500) {
            for (int i = 1; i <= end; ++i) {
                if (!sequence.isTrue(i)) continue;
                return 0;
            }
            return -1;
        }
        return 0;
    }

    public Expression getExp() {
        return this._$1;
    }
}

