/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.CellLocation;
import com.scudata.common.DBSession;
import com.scudata.common.Escape;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DBObject;
import com.scudata.dm.DataStruct;
import com.scudata.dm.KeyWord;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.expression.ArgNode;
import com.scudata.expression.ArgParam;
import com.scudata.expression.CSVariable;
import com.scudata.expression.Calc;
import com.scudata.expression.ConstParam;
import com.scudata.expression.Constant;
import com.scudata.expression.CreateRecord;
import com.scudata.expression.CurrentCell;
import com.scudata.expression.CurrentCellSeq;
import com.scudata.expression.CurrentElement;
import com.scudata.expression.CurrentElementId;
import com.scudata.expression.CurrentSeq;
import com.scudata.expression.DfxFunction;
import com.scudata.expression.ElementRef;
import com.scudata.expression.FieldFuzzyRef;
import com.scudata.expression.FieldId;
import com.scudata.expression.FieldRef;
import com.scudata.expression.ForCellCurSeq;
import com.scudata.expression.Function;
import com.scudata.expression.FunctionLib;
import com.scudata.expression.FuzzyFieldRef;
import com.scudata.expression.Gather;
import com.scudata.expression.IParam;
import com.scudata.expression.IterateParam;
import com.scudata.expression.MemberFunction;
import com.scudata.expression.Move;
import com.scudata.expression.Moves;
import com.scudata.expression.Node;
import com.scudata.expression.Operator;
import com.scudata.expression.SubVal;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.ValueList;
import com.scudata.expression.VarParam;
import com.scudata.expression.fn.PCSFunction;
import com.scudata.expression.operator.Add;
import com.scudata.expression.operator.AddAssign;
import com.scudata.expression.operator.And;
import com.scudata.expression.operator.Assign;
import com.scudata.expression.operator.Comma;
import com.scudata.expression.operator.Conj;
import com.scudata.expression.operator.ConjAssign;
import com.scudata.expression.operator.Diff;
import com.scudata.expression.operator.Divide;
import com.scudata.expression.operator.DivideAssign;
import com.scudata.expression.operator.DotOperator;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.ISect;
import com.scudata.expression.operator.ISectAssign;
import com.scudata.expression.operator.IntDivideAssign;
import com.scudata.expression.operator.MemAdd;
import com.scudata.expression.operator.MemDivide;
import com.scudata.expression.operator.MemIntDivide;
import com.scudata.expression.operator.MemMod;
import com.scudata.expression.operator.MemMultiply;
import com.scudata.expression.operator.MemSubtract;
import com.scudata.expression.operator.Mod;
import com.scudata.expression.operator.ModAssign;
import com.scudata.expression.operator.Multiply;
import com.scudata.expression.operator.MultiplyAssign;
import com.scudata.expression.operator.Negative;
import com.scudata.expression.operator.Not;
import com.scudata.expression.operator.NotEquals;
import com.scudata.expression.operator.NotGreater;
import com.scudata.expression.operator.NotSmaller;
import com.scudata.expression.operator.Or;
import com.scudata.expression.operator.Plus;
import com.scudata.expression.operator.Smaller;
import com.scudata.expression.operator.Subtract;
import com.scudata.expression.operator.SubtractAssign;
import com.scudata.expression.operator.Union;
import com.scudata.expression.operator.UnionAssign;
import com.scudata.resources.EngineMessage;
import com.scudata.util.EnvUtil;
import com.scudata.util.Variant;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expression {
    public static final Expression NULL = new Expression(new Constant(null));
    public static final byte TYPE_DB = 1;
    public static final byte TYPE_FILE = 2;
    public static final byte TYPE_SEQUENCE = 3;
    public static final byte TYPE_TABLE = 4;
    public static final byte TYPE_CURSOR = 5;
    public static final byte TYPE_OTHER = 101;
    public static final byte TYPE_UNKNOWN = 102;
    public static final boolean DoOptimize = true;
    private String _$5;
    private int _$4;
    private Node _$3;
    private ICellSet _$2;
    private boolean _$1;

    public Expression(String str) {
        this(null, null, str);
    }

    public Expression(Context ctx, String str) {
        this(null, ctx, str);
    }

    public Expression(ICellSet cs, Context ctx, String str) {
        this(cs, ctx, str, true, true);
    }

    public Expression(ICellSet cs, Context ctx, String str, boolean opt) {
        this(cs, ctx, str, opt, true);
    }

    public Expression(ICellSet cs, Context ctx, String str, boolean opt, boolean doMacro) {
        this._$2 = cs;
        String string = this._$5 = doMacro ? Expression.replaceMacros(str, cs, ctx) : str;
        if (this._$5 != null) {
            try {
                this._$1(cs, ctx);
            }
            catch (RQException re) {
                MessageManager mm = EngineMessage.get();
                re.setMessage(mm.getMessage("Expression.inExp", this._$5) + re.getMessage());
                throw re;
            }
        }
        if (this._$3 == null) {
            this._$3 = new Constant(null);
        } else {
            this._$3.checkValidity();
            if (opt) {
                this._$3 = this._$3.optimize(ctx);
            }
        }
        this._$1 = this._$3.canCalculateAll();
    }

    public Expression(Node node) {
        this._$3 = node;
        this._$1 = node.canCalculateAll();
    }

    public Node getHome() {
        return this._$3;
    }

    public boolean isConstExpression() {
        return this._$3 instanceof Constant;
    }

    public Object calculate(Context ctx) {
        return this._$3.calculate(ctx);
    }

    public INormalCell calculateCell(Context ctx) {
        return this._$3.calculateCell(ctx);
    }

    public void assign(Object value, Context ctx) {
        this._$3.assign(value, ctx);
    }

    public String toString() {
        return this._$5;
    }

    public String getIdentifierName() {
        int end;
        if (this._$5 != null && (end = this._$5.length() - 1) > 0 && this._$5.charAt(0) == '\'' && this._$5.charAt(end) == '\'') {
            return this._$5.substring(1, end);
        }
        return this._$5;
    }

    public String getFieldName() {
        return this.getFieldName(null);
    }

    public String getFieldName(DataStruct ds) {
        if (this._$3 instanceof DotOperator) {
            Node right = this._$3.getRight();
            if (right instanceof FieldRef) {
                String name = ((FieldRef)right).getName();
                if (name.charAt(0) == '\'' && name.charAt(name.length() - 1) == '\'') {
                    return name.substring(1, name.length() - 1);
                }
                return name;
            }
            return this._$5;
        }
        if (ds != null && this._$3 instanceof FieldId) {
            int c = ((FieldId)this._$3).getFieldIndex();
            if (c < ds.getFieldCount()) {
                return ds.getFieldName(c);
            }
            return this._$5;
        }
        return this.getIdentifierName();
    }

    public int getFieldIndex(DataStruct ds) {
        int index = ds.getFieldIndex(this._$5);
        if (index != -1) {
            return index;
        }
        return Expression._$1(this._$3, ds);
    }

    private static int _$1(Node home, DataStruct ds) {
        if (home instanceof DotOperator) {
            Node left = home.getLeft();
            if (left instanceof DotOperator || Expression._$1(left, ds) != -1) {
                return -1;
            }
            Node right = home.getRight();
            if (right instanceof FieldRef) {
                String fieldName = ((FieldRef)right).getName();
                return ds.getFieldIndex(fieldName);
            }
        } else {
            int c;
            if (home instanceof UnknownSymbol) {
                String fieldName = ((UnknownSymbol)home).getName();
                return ds.getFieldIndex(fieldName);
            }
            if (home instanceof FieldId && (c = ((FieldId)home).getFieldIndex()) < ds.getFieldCount()) {
                return c;
            }
        }
        return -1;
    }

    public void optimize(Context ctx) {
        this._$3 = this._$3.optimize(ctx);
    }

    public void deepOptimize(Context ctx) {
        this._$3 = this._$3.deepOptimize(ctx);
    }

    public boolean containParam(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return this._$3.containParam(name);
    }

    public void getUsedParams(Context ctx, ParamList resultList) {
        this._$3.getUsedParams(ctx, resultList);
    }

    public void getUsedFields(Context ctx, List<String> resultList) {
        this._$3.getUsedFields(ctx, resultList);
    }

    public String[] toFields() {
        Node node = this.getHome();
        if (node instanceof UnknownSymbol) {
            String[] res = new String[]{((UnknownSymbol)node).getName()};
            return res;
        }
        if (!(node instanceof ValueList)) {
            return null;
        }
        ValueList firList = (ValueList)node;
        IParam param = firList.getParam();
        if (null == param) {
            return null;
        }
        int count = param.getSubSize();
        if (0 >= count) {
            return null;
        }
        String[] res = new String[count];
        for (int i = 0; i < count; ++i) {
            res[i] = param.getSub(i).getLeafExpression().getIdentifierName();
        }
        return res;
    }

    public void getUsedCells(List<INormalCell> resultList) {
        this._$3.getUsedCells(resultList);
    }

    public byte getExpValueType(Context ctx) {
        Node right;
        for (right = this._$3; right != null && right.getPriority() < 18; right = right.getRight()) {
        }
        return right == null ? (byte)101 : right.calcExpValueType(ctx);
    }

    private void _$1(ICellSet cs, Context ctx) {
        int len = this._$5.length();
        int inBrackets = 0;
        Node preNode = null;
        block23: while (this._$4 < len) {
            Node right;
            char c = this._$5.charAt(this._$4);
            if (Character.isWhitespace(c)) {
                ++this._$4;
                continue;
            }
            Node node = null;
            switch (c) {
                case '(': {
                    if (preNode != null && !(preNode instanceof Operator)) {
                        node = new ElementRef();
                        ((Function)node).setParameter(cs, ctx, this._$1());
                        break;
                    }
                    if (preNode instanceof DotOperator) {
                        node = new Calc();
                        ((Function)node).setParameter(cs, ctx, this._$1());
                        break;
                    }
                    ++inBrackets;
                    ++this._$4;
                    continue block23;
                }
                case ')': {
                    if (--inBrackets < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("(,)" + mm.getMessage("Expression.illMatched"));
                    }
                    ++this._$4;
                    continue block23;
                }
                case '+': {
                    ++this._$4;
                    if (this._$4 < len && this._$5.charAt(this._$4) == '+') {
                        node = new MemAdd();
                        ++this._$4;
                        break;
                    }
                    if (this._$4 < len && this._$5.charAt(this._$4) == '=') {
                        node = new AddAssign();
                        ++this._$4;
                        break;
                    }
                    if (preNode != null && !(preNode instanceof Operator)) {
                        node = new Add();
                        break;
                    }
                    node = new Plus();
                    break;
                }
                case '-': {
                    ++this._$4;
                    if (this._$4 < len && this._$5.charAt(this._$4) == '-') {
                        node = new MemSubtract();
                        ++this._$4;
                        break;
                    }
                    if (this._$4 < len && this._$5.charAt(this._$4) == '=') {
                        node = new SubtractAssign();
                        ++this._$4;
                        break;
                    }
                    if (preNode != null && !(preNode instanceof Operator)) {
                        node = new Subtract();
                        break;
                    }
                    node = new Negative();
                    break;
                }
                case '*': {
                    if (preNode == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("\"*\"" + mm.getMessage("operator.missingLeftOperation"));
                    }
                    ++this._$4;
                    if (this._$4 < len && this._$5.charAt(this._$4) == '*') {
                        node = new MemMultiply();
                        ++this._$4;
                        break;
                    }
                    if (this._$4 < len && this._$5.charAt(this._$4) == '=') {
                        node = new MultiplyAssign();
                        ++this._$4;
                        break;
                    }
                    node = new Multiply();
                    break;
                }
                case '/': {
                    MessageManager mm;
                    if (preNode == null) {
                        MessageManager mm2 = EngineMessage.get();
                        throw new RQException("\"*\"" + mm2.getMessage("operator.missingLeftOperation"));
                    }
                    ++this._$4;
                    if (this._$4 < len) {
                        char nextChar = this._$5.charAt(this._$4);
                        if (nextChar == '/') {
                            node = new MemDivide();
                            ++this._$4;
                            break;
                        }
                        if (nextChar == '=') {
                            node = new DivideAssign();
                            ++this._$4;
                            break;
                        }
                        if (nextChar == '*') {
                            this._$4 = Expression._$1(this._$5, this._$4);
                            if (this._$4 == -1) {
                                mm = EngineMessage.get();
                                throw new RQException(mm.getMessage("Expression.unknownExpression") + "/*");
                            }
                            ++this._$4;
                            continue block23;
                        }
                        node = new Divide();
                        break;
                    }
                    node = new Divide();
                    break;
                }
                case '%': {
                    ++this._$4;
                    if (this._$4 < len && this._$5.charAt(this._$4) == '%') {
                        node = new MemMod();
                        ++this._$4;
                        break;
                    }
                    if (this._$4 < len && this._$5.charAt(this._$4) == '=') {
                        node = new ModAssign();
                        ++this._$4;
                        break;
                    }
                    node = new Mod();
                    break;
                }
                case '=': {
                    ++this._$4;
                    if (this._$4 < len && this._$5.charAt(this._$4) == '=') {
                        node = new Equals();
                        ++this._$4;
                        break;
                    }
                    node = new Assign();
                    break;
                }
                case '!': {
                    ++this._$4;
                    if (this._$4 < len && this._$5.charAt(this._$4) == '=') {
                        node = new NotEquals();
                        ++this._$4;
                        break;
                    }
                    node = new Not();
                    break;
                }
                case '>': {
                    ++this._$4;
                    if (this._$4 < len && this._$5.charAt(this._$4) == '=') {
                        node = new NotSmaller();
                        ++this._$4;
                        break;
                    }
                    node = new Greater();
                    break;
                }
                case '<': {
                    ++this._$4;
                    if (this._$4 < len && this._$5.charAt(this._$4) == '=') {
                        node = new NotGreater();
                        ++this._$4;
                        break;
                    }
                    node = new Smaller();
                    break;
                }
                case '&': {
                    ++this._$4;
                    if (this._$4 < len && this._$5.charAt(this._$4) == '&') {
                        node = new And();
                        ++this._$4;
                        break;
                    }
                    if (this._$4 < len && this._$5.charAt(this._$4) == '=') {
                        node = new UnionAssign();
                        ++this._$4;
                        break;
                    }
                    node = new Union();
                    break;
                }
                case '^': {
                    ++this._$4;
                    if (this._$4 < len && this._$5.charAt(this._$4) == '=') {
                        node = new ISectAssign();
                        ++this._$4;
                        break;
                    }
                    node = new ISect();
                    break;
                }
                case '|': {
                    ++this._$4;
                    if (this._$4 < len && this._$5.charAt(this._$4) == '|') {
                        node = new Or();
                        ++this._$4;
                        break;
                    }
                    if (this._$4 < len && this._$5.charAt(this._$4) == '=') {
                        node = new ConjAssign();
                        ++this._$4;
                        break;
                    }
                    node = new Conj();
                    break;
                }
                case '\\': {
                    ++this._$4;
                    if (this._$4 < len && this._$5.charAt(this._$4) == '\\') {
                        node = new MemIntDivide();
                        ++this._$4;
                        break;
                    }
                    if (this._$4 < len && this._$5.charAt(this._$4) == '=') {
                        node = new IntDivideAssign();
                        ++this._$4;
                        break;
                    }
                    node = new Diff();
                    break;
                }
                case ',': {
                    node = new Comma();
                    ++this._$4;
                    break;
                }
                case '.': {
                    if (preNode == null || preNode instanceof Operator) {
                        ++this._$4;
                        String id = '.' + this._$2();
                        Object obj = Variant.parse(id);
                        if (obj instanceof String) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("Expression.unknownExpression") + id);
                        }
                        node = new Constant(obj);
                        break;
                    }
                    node = new DotOperator();
                    ++this._$4;
                    break;
                }
                case '\"': {
                    MessageManager mm;
                    int dqmatch = Sentence.scanQuotation(this._$5, this._$4);
                    if (dqmatch == -1) {
                        mm = EngineMessage.get();
                        throw new RQException("\"" + mm.getMessage("Expression.illMatched"));
                    }
                    String str = this._$5.substring(this._$4 + 1, dqmatch);
                    this._$4 = dqmatch + 1;
                    node = new Constant(Escape.remove(str));
                    break;
                }
                case '\'': {
                    int qmatch = Sentence.scanQuotation(this._$5, this._$4);
                    if (qmatch == -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("'" + mm.getMessage("Expression.illMatched"));
                    }
                    String strID = this._$5.substring(this._$4 + 1, qmatch);
                    this._$4 = qmatch + 1;
                    if (preNode instanceof DotOperator) {
                        node = new FieldRef(strID);
                        break;
                    }
                    node = new UnknownSymbol(strID);
                    break;
                }
                case '[': {
                    int match = Sentence.scanBracket(this._$5, this._$4);
                    if (match == -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("[,]" + mm.getMessage("Expression.illMatched"));
                    }
                    node = preNode == null || preNode instanceof Operator ? new ValueList() : new Move();
                    ((Function)node).setParameter(cs, ctx, this._$5.substring(this._$4 + 1, match));
                    this._$4 = match + 1;
                    break;
                }
                case '{': {
                    int match = Sentence.scanBrace(this._$5, this._$4);
                    if (match == -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("{,}" + mm.getMessage("Expression.illMatched"));
                    }
                    node = preNode == null || preNode instanceof Operator ? new CreateRecord() : new Moves();
                    ((Function)node).setParameter(cs, ctx, this._$5.substring(this._$4 + 1, match));
                    this._$4 = match + 1;
                    break;
                }
                default: {
                    node = this._$1(cs, ctx, preNode);
                }
            }
            if (preNode instanceof Constant && node instanceof Constant && ((Constant)preNode).append((Constant)node)) continue;
            node.setInBrackets(inBrackets);
            preNode = node;
            if (this._$3 == null) {
                this._$3 = node;
                continue;
            }
            Node parent = null;
            for (right = this._$3; right != null && right.getPriority() < node.getPriority(); right = right.getRight()) {
                parent = right;
            }
            node.setLeft(right);
            if (parent != null) {
                parent.setRight(node);
                continue;
            }
            this._$3 = node;
        }
        if (inBrackets > 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("(,)" + mm.getMessage("Expression.illMatched"));
        }
    }

    private Node _$1(ICellSet cs, Context ctx, Node preNode) {
        Object value;
        DBSession dbs;
        Param var;
        int index;
        int match;
        String id = this._$2();
        int idLen = id.length();
        if (idLen < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.unknownExpression") + this._$5.charAt(this._$4));
        }
        if (KeyWord.isCurrentElement(id)) {
            return new CurrentElement();
        }
        if (KeyWord.isIterateParam(id)) {
            return new IterateParam();
        }
        if (KeyWord.isCurrentSeq(id)) {
            return new CurrentSeq();
        }
        if (KeyWord.isFieldId(id)) {
            return new FieldId(id);
        }
        if (KeyWord.isCurrentCellSeq(id)) {
            return new CurrentCellSeq();
        }
        if (KeyWord.isElementId(id)) {
            return new CurrentElementId(id);
        }
        if (KeyWord.isArg(id)) {
            return new ArgNode(id);
        }
        if (preNode instanceof DotOperator) {
            return this._$1(cs, id, ctx);
        }
        if (id.startsWith("#")) {
            INormalCell cell;
            if (cs instanceof PgmCellSet && (cell = cs.getCell(id.substring(1))) != null) {
                return new ForCellCurSeq((PgmCellSet)cs, cell.getRow(), cell.getCol());
            }
            return new FieldFuzzyRef(id.substring(1));
        }
        if (id.equals("$") && this._$1('[') && (match = Sentence.scanBracket(this._$5, index = this._$5.indexOf(91, this._$4))) != -1) {
            this._$4 = match + 1;
            return new Constant(Escape.remove(this._$5.substring(index + 1, match).trim()));
        }
        if (cs != null) {
            INormalCell cell = cs.getCell(id);
            if (cell != null) {
                return new CSVariable(cell);
            }
            if (KeyWord.isCurrentCell(id)) {
                return new CurrentCell(cs);
            }
            if (KeyWord.isSubCodeBlock(id) && cs instanceof PgmCellSet) {
                return new SubVal((PgmCellSet)cs);
            }
        }
        if ((var = EnvUtil.getParam(id, ctx)) != null) {
            Object val = var.getValue();
            if (val instanceof DBSession) {
                return new Constant(new DBObject((DBSession)val));
            }
            byte kind = var.getKind();
            switch (kind) {
                case 0: {
                    return new VarParam(var);
                }
                case 1: {
                    return new ArgParam(var);
                }
            }
            return new ConstParam(id, var.getValue());
        }
        if (this._$1('(')) {
            PgmCellSet.FuncInfo funcInfo;
            int atIdx = id.indexOf(64);
            String fnName = id;
            String fnOpt = null;
            if (atIdx != -1) {
                fnName = id.substring(0, atIdx);
                fnOpt = id.substring(atIdx + 1);
            }
            if (FunctionLib.isFnName(fnName)) {
                Function fn = FunctionLib.newFunction(fnName);
                fn.setOption(fnOpt);
                fn.setParameter(cs, ctx, this._$1());
                return fn;
            }
            DfxFunction dfx = Context.getDFXFunction(fnName, ctx);
            if (dfx != null) {
                String param = this._$1();
                return dfx.newFunction(cs, ctx, fnOpt, param);
            }
            if (cs instanceof PgmCellSet && (funcInfo = ((PgmCellSet)cs).getFuncInfo(fnName)) != null) {
                PCSFunction fn = new PCSFunction(funcInfo);
                fn.setOption(fnOpt);
                fn.setParameter(cs, ctx, this._$1());
                return fn;
            }
        }
        if (ctx != null && (dbs = ctx.getDBSession(id)) != null) {
            return new Constant(new DBObject(dbs));
        }
        if (this._$1('.') && this._$2(id)) {
            int prevPos = this._$4++;
            if (this._$1('(')) {
                this._$4 = prevPos;
            } else {
                Object obj = Variant.parse(id + '.' + this._$2());
                if (obj instanceof String) {
                    this._$4 = prevPos;
                } else {
                    return new Constant(obj);
                }
            }
        }
        if ((value = Variant.parse(id)) instanceof String) {
            return new UnknownSymbol((String)value);
        }
        return new Constant(value);
    }

    private Node _$1(ICellSet cs, String id, Context ctx) {
        if (this._$1('(')) {
            int atIdx = id.indexOf(64);
            String fnName = id;
            String fnOpt = null;
            if (atIdx == 0) {
                fnOpt = id.substring(1);
                Calc calc = new Calc();
                calc.setOption(fnOpt);
                calc.setParameter(cs, ctx, this._$1());
                return calc;
            }
            if (atIdx != -1) {
                fnName = id.substring(0, atIdx);
                fnOpt = id.substring(atIdx + 1);
            }
            if (FunctionLib.isMemberFnName(fnName)) {
                MemberFunction mfn = FunctionLib.newMemberFunction(fnName);
                mfn.setOption(fnOpt);
                mfn.setParameter(cs, ctx, this._$1());
                return mfn;
            }
        }
        if (id.startsWith("#")) {
            return new FuzzyFieldRef(id.substring(1));
        }
        return new FieldRef(id);
    }

    private boolean _$1(char c) {
        int len = this._$5.length();
        for (int i = this._$4; i < len; ++i) {
            if (this._$5.charAt(i) == c) {
                return true;
            }
            if (Character.isWhitespace(this._$5.charAt(i))) continue;
            return false;
        }
        return false;
    }

    private boolean _$2(String num) {
        int length = num.length();
        for (int i = 0; i < length; ++i) {
            char c = num.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private String _$2() {
        char c;
        int len = this._$5.length();
        int begin = this._$4;
        while (this._$4 < len && !KeyWord.isSymbol(c = this._$5.charAt(this._$4))) {
            ++this._$4;
        }
        return this._$5.substring(begin, this._$4);
    }

    private static int _$1(String str, int start) {
        int len = str.length() - 1;
        for (int i = start + 1; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '*') {
                if (str.charAt(i + 1) != '/') continue;
                return i + 1;
            }
            if (ch != '/' || str.charAt(i + 1) != '*' || (i = Expression._$1(str, i + 1)) != -1) continue;
            return -1;
        }
        return -1;
    }

    private String _$1() {
        char c;
        int len = this._$5.length();
        while (this._$4 < len && Character.isWhitespace(c = this._$5.charAt(this._$4))) {
            ++this._$4;
        }
        if (this._$4 == len) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.missingParam"));
        }
        c = this._$5.charAt(this._$4);
        if (c != '(') {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.missingParam"));
        }
        int match = Expression.scanParenthesis(this._$5, this._$4);
        if (match == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("(,)" + mm.getMessage("Expression.illMatched"));
        }
        String param = this._$5.substring(this._$4 + 1, match);
        this._$4 = match + 1;
        return param;
    }

    public static String replaceMacros(String text, ICellSet cs, Context ctx) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        StringBuffer newStr = null;
        PgmCellSet pcs = null;
        if (cs instanceof PgmCellSet) {
            pcs = (PgmCellSet)cs;
        }
        int idx = 0;
        while (idx < len) {
            char c = text.charAt(idx);
            if (c == '\'' || c == '\"') {
                int match = Sentence.scanQuotation(text, idx);
                if (match < 0) {
                    if (newStr != null) {
                        newStr.append(c);
                    }
                    ++idx;
                    continue;
                }
                if (newStr != null) {
                    newStr.append(text.substring(idx, match + 1));
                }
                idx = match + 1;
                continue;
            }
            if (KeyWord.isSymbol(c)) {
                if (newStr != null) {
                    newStr.append(c);
                }
                ++idx;
                continue;
            }
            int last = KeyWord.scanId(text, idx + 1);
            char lc = text.charAt(last - 1);
            if (last < len && lc == '$') {
                MessageManager mm;
                char nc = text.charAt(last);
                if (nc == '{') {
                    int match = Sentence.scanBrace(text, last);
                    if (match == -1) {
                        mm = EngineMessage.get();
                        throw new RQException("{,}" + mm.getMessage("Expression.illMatched"));
                    }
                    if (newStr == null) {
                        newStr = new StringBuffer(len + 80);
                        newStr.append(text.substring(0, idx));
                    }
                    newStr.append(text.substring(idx, last - 1));
                    newStr.append(Expression._$1(text.substring(last + 1, match), cs, ctx));
                    idx = match + 1;
                    continue;
                }
                if (nc == '(') {
                    int match = Expression.scanParenthesis(text, last);
                    if (match == -1) {
                        mm = EngineMessage.get();
                        throw new RQException("(,)" + mm.getMessage("Expression.illMatched"));
                    }
                    if (pcs == null) {
                        mm = EngineMessage.get();
                        throw new RQException("$()" + mm.getMessage("Expression.missingCs"));
                    }
                    String strCell = text.substring(last + 1, match).trim();
                    String retStr = pcs.getMacroReplaceString(strCell);
                    if (newStr == null) {
                        newStr = new StringBuffer(len + 80);
                        newStr.append(text.substring(0, idx));
                    }
                    newStr.append(text.substring(idx, last - 1));
                    newStr.append(retStr);
                    idx = match + 1;
                    continue;
                }
                if (newStr != null) {
                    newStr.append(text.substring(idx, last));
                }
                idx = last;
                continue;
            }
            String subStr = text.substring(idx, last);
            String cellId = Expression._$1(subStr);
            if (cellId == null) {
                if (newStr != null) {
                    newStr.append(subStr);
                }
            } else {
                if (newStr == null) {
                    newStr = new StringBuffer(len + 80);
                    newStr.append(text.substring(0, idx));
                }
                newStr.append(cellId);
            }
            idx = last;
        }
        return newStr == null ? text : newStr.toString();
    }

    public static boolean containMacro(String text) {
        if (text == null) {
            return false;
        }
        int len = text.length();
        int idx = 0;
        while (idx < len) {
            char c = text.charAt(idx);
            if (c == '\'' || c == '\"') {
                int match = Sentence.scanQuotation(text, idx);
                if (match < 0) {
                    return false;
                }
                idx = match + 1;
                continue;
            }
            if (KeyWord.isSymbol(c)) {
                ++idx;
                continue;
            }
            int last = KeyWord.scanId(text, idx + 1);
            char lc = text.charAt(last - 1);
            if (last < len && lc == '$') {
                int match;
                char nc = text.charAt(last);
                if (nc == '{') {
                    match = Sentence.scanBrace(text, last);
                    return match != -1;
                }
                if (nc == '(') {
                    match = Expression.scanParenthesis(text, last);
                    if (match == -1) {
                        return false;
                    }
                    idx = match + 1;
                    continue;
                }
                idx = last;
                continue;
            }
            idx = last;
        }
        return false;
    }

    private static String _$1(String text) {
        if (text.length() < 3) {
            return null;
        }
        char ch = text.charAt(0);
        if (ch == '#') {
            ch = text.charAt(1);
            if (ch == '$') {
                int idx2 = text.indexOf(36, 3);
                if (idx2 == -1) {
                    String strId = text.substring(2);
                    if (CellLocation.parse(strId) != null) {
                        return '#' + text.substring(2);
                    }
                    return null;
                }
                String strCell = text.substring(2, idx2) + text.substring(idx2 + 1);
                if (CellLocation.parse(strCell) != null) {
                    return '#' + strCell;
                }
                return null;
            }
            int idx1 = text.indexOf(36, 2);
            if (idx1 == -1) {
                return null;
            }
            String strCell = text.substring(1, idx1) + text.substring(idx1 + 1);
            if (CellLocation.parse(strCell) != null) {
                return '#' + strCell;
            }
            return null;
        }
        if (ch == '$') {
            int idx2 = text.indexOf(36, 2);
            if (idx2 == -1) {
                String strId = text.substring(1);
                if (CellLocation.parse(strId) != null) {
                    return text.substring(1);
                }
                return null;
            }
            String strCell = text.substring(1, idx2) + text.substring(idx2 + 1);
            return CellLocation.parse(strCell) == null ? null : strCell;
        }
        int idx1 = text.indexOf(36);
        if (idx1 == -1) {
            return null;
        }
        String strCell = text.substring(0, idx1) + text.substring(idx1 + 1);
        return CellLocation.parse(strCell) == null ? null : strCell;
    }

    private static String _$1(String str, ICellSet cs, Context ctx) {
        Expression exp = new Expression(cs, ctx, str);
        Object obj = exp.calculate(ctx);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj == null) {
            return "";
        }
        return Variant.toString(obj);
    }

    public Expression newExpression(Context ctx) {
        if (this._$5 != null) {
            return new Expression(this._$2, ctx, this._$5, true, false);
        }
        return new Expression(this._$3);
    }

    public static int scanParenthesis(String str, int start) {
        int len = str.length();
        int i = start + 1;
        block6: while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '(': {
                    i = Expression.scanParenthesis(str, i);
                    if (i < 0) {
                        return -1;
                    }
                    ++i;
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    int q = Sentence.scanQuotation(str, i, '\\');
                    if (q < 0) {
                        ++i;
                        continue block6;
                    }
                    i = q + 1;
                    continue block6;
                }
                case '[': {
                    int q;
                    if (i > start && str.charAt(i - 1) == '$') {
                        q = Sentence.scanBracket(str, i, '\\');
                        if (q < 0) {
                            ++i;
                            continue block6;
                        }
                        i = q + 1;
                        continue block6;
                    }
                    ++i;
                    continue block6;
                }
                case ')': {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static boolean ifIs(Object obj, Class<?> base) {
        if (null == obj) {
            return false;
        }
        return obj.getClass() == base || null != obj.getClass() && obj.getClass().getSuperclass() == base;
    }

    public static String replaceFunc(String src, String func, String newStr) {
        return StringUtils.replace(src, func, newStr);
    }

    public static ArrayList<Object> getSpecFunc(Operator op, Class<?> base) {
        ArrayList<Object> classes;
        Node left = op.getLeft();
        if (Expression.ifIs(left, base)) {
            classes = new ArrayList<Node>();
            classes.add(left);
        } else {
            classes = left instanceof Function ? Expression.getSpecFunc((Function)left, base) : (left instanceof Operator ? Expression.getSpecFunc((Operator)left, base) : new ArrayList());
        }
        Node right = op.getRight();
        if (Expression.ifIs(right, base)) {
            classes.add(right);
        } else if (right instanceof Function) {
            classes.addAll(Expression.getSpecFunc((Function)right, base));
        } else if (right instanceof Operator) {
            classes.addAll(Expression.getSpecFunc((Operator)right, base));
        }
        return classes;
    }

    public static ArrayList<Object> getSpecFunc(Function fun, Class<?> base) {
        ArrayList<Object> funcs;
        Node left = fun.getLeft();
        if (left == null) {
            funcs = new ArrayList<Node>();
        } else if (Expression.ifIs(left, base)) {
            funcs = new ArrayList();
            funcs.add(left);
        } else {
            funcs = left instanceof Function ? Expression.getSpecFunc((Function)left, base) : (left instanceof Operator ? Expression.getSpecFunc((Operator)left, base) : new ArrayList());
        }
        IParam par = fun.getParam();
        if (null == par) {
            return funcs;
        }
        int subCount = par.getSubSize();
        if (0 == subCount) {
            if (Expression.ifIs(fun, base)) {
                funcs.add(fun);
            } else if (par instanceof Function) {
                funcs.addAll(Expression.getSpecFunc((Function)((Object)par), base));
            } else if (par instanceof Operator) {
                funcs.addAll(Expression.getSpecFunc((Operator)((Object)par), base));
            } else if (par instanceof Expression) {
                funcs.addAll(Expression.getSpecFunc((Expression)((Object)par), base));
            } else if (par.isLeaf()) {
                funcs.addAll(Expression.getSpecFunc(par.getLeafExpression(), base));
            } else {
                funcs.addAll(Expression.getSpecFunc(par, base));
            }
        }
        IParam sub = null;
        for (int i = 0; i < subCount; ++i) {
            sub = par.getSub(i);
            if (null == sub) continue;
            if (Expression.ifIs(sub, base)) {
                funcs.add(sub);
                continue;
            }
            if (sub instanceof Function) {
                funcs.addAll(Expression.getSpecFunc((Function)((Object)sub), base));
                continue;
            }
            if (sub instanceof Operator) {
                funcs.addAll(Expression.getSpecFunc((Operator)((Object)sub), base));
                continue;
            }
            if (sub instanceof Expression) {
                funcs.addAll(Expression.getSpecFunc((Expression)((Object)sub), base));
                continue;
            }
            if (sub.isLeaf()) {
                funcs.addAll(Expression.getSpecFunc(sub.getLeafExpression(), base));
                continue;
            }
            funcs.addAll(Expression.getSpecFunc(sub, base));
        }
        return funcs;
    }

    public static ArrayList<Object> getSpecFunc(IParam param, Class<?> base) {
        ArrayList<Object> funcs = new ArrayList<Object>();
        int subCount = param.getSubSize();
        IParam sub = null;
        for (int i = 0; i < subCount; ++i) {
            sub = param.getSub(i);
            if (null == sub) continue;
            if (Expression.ifIs(sub, base)) {
                funcs.add(sub);
                continue;
            }
            if (sub instanceof Function) {
                funcs.addAll(Expression.getSpecFunc((Function)((Object)sub), base));
                continue;
            }
            if (sub instanceof Operator) {
                funcs.addAll(Expression.getSpecFunc((Operator)((Object)sub), base));
                continue;
            }
            if (sub instanceof Expression) {
                funcs.addAll(Expression.getSpecFunc((Expression)((Object)sub), base));
                continue;
            }
            if (sub.isLeaf()) {
                funcs.addAll(Expression.getSpecFunc(sub.getLeafExpression(), base));
                continue;
            }
            funcs.addAll(Expression.getSpecFunc(sub, base));
        }
        return funcs;
    }

    public static ArrayList<Object> getSpecFunc(Expression exp, Class<?> base) {
        ArrayList<Object> funcs = new ArrayList<Object>();
        Node home = exp.getHome();
        if (null == home) {
            return funcs;
        }
        if (Expression.ifIs(home, base)) {
            funcs.add(home);
        } else if (home instanceof Function) {
            funcs.addAll(Expression.getSpecFunc((Function)home, base));
        } else if (home instanceof Operator) {
            funcs.addAll(Expression.getSpecFunc((Operator)home, base));
        }
        return funcs;
    }

    public static boolean sameExpression(String exp1, String exp2) {
        int len = exp1.length();
        int set = 0;
        boolean bstr = false;
        for (int i = 0; i < len; ++i) {
            char ch1 = exp1.charAt(i);
            char ch2 = exp2.charAt(set);
            if (!bstr && ' ' == ch1) continue;
            if (!bstr && ' ' == ch2) {
                while (' ' == ch2) {
                    ch2 = exp2.charAt(++set);
                }
            }
            if (ch1 != ch2) {
                return false;
            }
            if ('\"' != ch1 && '\'' != ch1) continue;
            bstr = !bstr;
        }
        return true;
    }

    public static ArrayList<String> gatherParam(Operator op) {
        ArrayList<String> temp;
        ArrayList<Object> gathers = new ArrayList<String>();
        Node left = op.getLeft();
        if (left instanceof Gather) {
            String str = ((Gather)left).getFunctionString();
            gathers.add(0, str);
        } else if (left instanceof Function) {
            temp = Expression.gatherParam((Function)left);
            temp.addAll(gathers);
            gathers = temp;
        } else if (left instanceof Operator) {
            temp = Expression.gatherParam((Operator)left);
            temp.addAll(gathers);
            gathers = temp;
        }
        Node right = op.getRight();
        if (right instanceof Gather) {
            String str = ((Gather)right).getFunctionString();
            gathers.add(str);
        } else if (right instanceof Function) {
            gathers.addAll(Expression.gatherParam((Function)right));
        } else if (right instanceof Operator) {
            gathers.addAll(Expression.gatherParam((Operator)right));
        }
        return gathers;
    }

    public static ArrayList<String> gatherParam(Function fun) {
        ArrayList<String> gathers = new ArrayList<String>();
        IParam par = fun.getParam();
        if (null == par) {
            return gathers;
        }
        int subCount = par.getSubSize();
        if (0 == subCount) {
            if (par instanceof Gather) {
                String str = ((Gather)((Object)par)).getFunctionString();
                gathers.add(str);
            } else if (par instanceof Function) {
                gathers.addAll(Expression.gatherParam((Function)((Object)par)));
            } else if (par instanceof Operator) {
                gathers.addAll(Expression.gatherParam((Operator)((Object)par)));
            } else if (par instanceof Expression) {
                gathers.addAll(Expression.gatherParam((Expression)((Object)par)));
            } else if (par.isLeaf()) {
                gathers.addAll(Expression.gatherParam(par.getLeafExpression()));
            } else {
                gathers.addAll(Expression.gatherParam(par));
            }
        }
        IParam sub = null;
        for (int i = 0; i < subCount; ++i) {
            sub = par.getSub(i);
            if (null == sub) continue;
            if (sub instanceof Gather) {
                String str = ((Gather)((Object)sub)).getFunctionString();
                gathers.add(str);
                continue;
            }
            if (sub instanceof Function) {
                gathers.addAll(Expression.gatherParam((Function)((Object)sub)));
                continue;
            }
            if (sub instanceof Operator) {
                gathers.addAll(Expression.gatherParam((Operator)((Object)sub)));
                continue;
            }
            if (sub instanceof Expression) {
                gathers.addAll(Expression.gatherParam((Expression)((Object)sub)));
                continue;
            }
            if (sub.isLeaf()) {
                gathers.addAll(Expression.gatherParam(sub.getLeafExpression()));
                continue;
            }
            gathers.addAll(Expression.gatherParam(sub));
        }
        return gathers;
    }

    public static ArrayList<String> gatherParam(IParam param) {
        ArrayList<String> gathers = new ArrayList<String>();
        int subCount = param.getSubSize();
        IParam sub = null;
        for (int i = 0; i < subCount; ++i) {
            sub = param.getSub(i);
            if (null == sub) continue;
            if (sub instanceof Gather) {
                String str = ((Gather)((Object)sub)).getFunctionString();
                gathers.add(str);
                continue;
            }
            if (sub instanceof Function) {
                gathers.addAll(Expression.gatherParam((Function)((Object)sub)));
                continue;
            }
            if (sub instanceof Operator) {
                gathers.addAll(Expression.gatherParam((Operator)((Object)sub)));
                continue;
            }
            if (sub instanceof Expression) {
                gathers.addAll(Expression.gatherParam((Expression)((Object)sub)));
                continue;
            }
            if (sub.isLeaf()) {
                gathers.addAll(Expression.gatherParam(sub.getLeafExpression()));
                continue;
            }
            gathers.addAll(Expression.gatherParam(sub));
        }
        return gathers;
    }

    public static ArrayList<String> gatherParam(Expression exp) {
        ArrayList<String> gathers = new ArrayList<String>();
        Node home = exp.getHome();
        if (null == home) {
            return gathers;
        }
        if (home instanceof Gather) {
            String str = ((Gather)home).getFunctionString();
            gathers.add(str);
        } else if (home instanceof Function) {
            gathers.addAll(Expression.gatherParam((Function)home));
        } else if (home instanceof Operator) {
            gathers.addAll(Expression.gatherParam((Operator)home));
        }
        return gathers;
    }

    public IArray calculateAll(Context ctx) {
        if (this._$1) {
            return this._$3.calculateAll(ctx);
        }
        Current current = ctx.getComputeStack().getTopCurrent();
        int len = current.length();
        ObjectArray array = new ObjectArray(len);
        array.setTemporary(true);
        for (int i = 1; i <= len; ++i) {
            current.setCurrent(i);
            Object value = this._$3.calculate(ctx);
            array.push(value);
        }
        return array;
    }

    public boolean canCalculateAll() {
        return this._$1;
    }

    public IArray calculateRange(Context ctx) {
        return this._$3.calculateRange(ctx);
    }

    public int isValueRangeMatch(Context ctx) {
        return this._$3.isValueRangeMatch(ctx);
    }

    public IArray calculateAnd(Context ctx, IArray leftResult) {
        if (leftResult == null) {
            return this._$3.calculateAll(ctx);
        }
        return this._$3.calculateAnd(ctx, leftResult);
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        return this._$3.calculateAll(ctx, signArray, sign);
    }

    public boolean isMonotone() {
        return this._$3.isMonotone();
    }

    public void reset() {
        this._$3.reset();
    }
}

