/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.cellset.ICellSet;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public abstract class MemberFunction
extends Function {
    protected MemberFunction next;
    protected Node left;

    public abstract boolean isLeftTypeMatch(Object var1);

    public abstract void setDotLeftObject(Object var1);

    public void setLeft(Node node) {
        this.left = node;
    }

    public Node getLeft() {
        return this.left;
    }

    public void setParameter(ICellSet cs, Context ctx, String param) {
        super.setParameter(cs, ctx, param);
        if (this.next != null) {
            this.next.setParameter(cs, ctx, param);
        }
    }

    public void setOption(String opt) {
        super.setOption(opt);
        if (this.next != null) {
            this.next.setOption(opt);
        }
    }

    public MemberFunction getNextFunction() {
        return this.next;
    }

    public void setNextFunction(MemberFunction fn) {
        this.next = fn;
    }

    public boolean isSequenceFunction() {
        return this.next == null ? false : this.next.isSequenceFunction();
    }

    public boolean ifModifySequence() {
        return this.next == null ? true : this.next.isSequenceFunction();
    }

    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
            if (this.next != null) {
                this.next.optimize(ctx);
            }
        }
        return this;
    }

    protected static void parseJoinParam(IParam param, int index, Expression[][] exps, Object[] codes, Expression[][] dataExps, Expression[][] newExps, String[][] newNames, Context ctx) {
        int size = param.getSubSize();
        if (size < 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("join" + mm.getMessage("function.invalidParam"));
        }
        IParam sub = param.getSub(0);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("join" + mm.getMessage("function.invalidParam"));
        }
        if (sub.isLeaf()) {
            exps[index] = new Expression[]{sub.getLeafExpression()};
        } else {
            int expCount = sub.getSubSize();
            Expression[] tmps = new Expression[expCount];
            exps[index] = tmps;
            for (int i = 0; i < expCount; ++i) {
                IParam p = sub.getSub(i);
                if (p == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("join" + mm.getMessage("function.invalidParam"));
                }
                tmps[i] = p.getLeafExpression();
            }
        }
        sub = param.getSub(1);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("join" + mm.getMessage("function.invalidParam"));
        }
        if (sub.isLeaf()) {
            codes[index] = sub.getLeafExpression().calculate(ctx);
        } else {
            IParam p = sub.getSub(0);
            if (p == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("join" + mm.getMessage("function.invalidParam"));
            }
            codes[index] = p.getLeafExpression().calculate(ctx);
            int expCount = sub.getSubSize() - 1;
            Expression[] tmps = new Expression[expCount];
            dataExps[index] = tmps;
            for (int i = 0; i < expCount; ++i) {
                p = sub.getSub(i + 1);
                if (p == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("join" + mm.getMessage("function.invalidParam"));
                }
                tmps[i] = p.getLeafExpression();
            }
        }
        int expCount = size - 2;
        Expression[] tmpExps = new Expression[expCount];
        String[] tmpNames = new String[expCount];
        newExps[index] = tmpExps;
        newNames[index] = tmpNames;
        for (int i = 0; i < expCount; ++i) {
            MessageManager mm;
            IParam p = param.getSub(i + 2);
            if (p == null) {
                mm = EngineMessage.get();
                throw new RQException("join" + mm.getMessage("function.invalidParam"));
            }
            if (p.isLeaf()) {
                tmpExps[i] = p.getLeafExpression();
                continue;
            }
            if (p.getSubSize() != 2) {
                mm = EngineMessage.get();
                throw new RQException("join" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = p.getSub(0);
            if (sub0 == null) {
                MessageManager mm2 = EngineMessage.get();
                throw new RQException("join" + mm2.getMessage("function.invalidParam"));
            }
            tmpExps[i] = sub0.getLeafExpression();
            IParam sub1 = p.getSub(1);
            if (sub1 == null) continue;
            tmpNames[i] = sub1.getLeafExpression().getIdentifierName();
        }
    }

    protected static void parseJoinxParam(IParam param, int index, Expression[][] exps, Object[] codes, Expression[][] dataExps, Expression[][] newExps, String[][] newNames, Context ctx) {
        int size = param.getSubSize();
        if (size < 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("joinx" + mm.getMessage("function.invalidParam"));
        }
        IParam sub = param.getSub(0);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("joinx" + mm.getMessage("function.invalidParam"));
        }
        if (sub.isLeaf()) {
            exps[index] = new Expression[]{sub.getLeafExpression()};
        } else {
            int expCount = sub.getSubSize();
            Expression[] tmps = new Expression[expCount];
            exps[index] = tmps;
            for (int i = 0; i < expCount; ++i) {
                IParam p = sub.getSub(i);
                if (p == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("joinx" + mm.getMessage("function.invalidParam"));
                }
                tmps[i] = p.getLeafExpression();
            }
        }
        sub = param.getSub(1);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("joinx" + mm.getMessage("function.invalidParam"));
        }
        if (sub.isLeaf()) {
            codes[index] = sub.getLeafExpression().calculate(ctx);
        } else {
            IParam p = sub.getSub(0);
            if (p == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("joinx" + mm.getMessage("function.invalidParam"));
            }
            codes[index] = p.getLeafExpression().calculate(ctx);
            int expCount = sub.getSubSize() - 1;
            Expression[] tmps = new Expression[expCount];
            dataExps[index] = tmps;
            for (int i = 0; i < expCount; ++i) {
                p = sub.getSub(i + 1);
                if (p == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("joinx" + mm.getMessage("function.invalidParam"));
                }
                tmps[i] = p.getLeafExpression();
            }
        }
        int expCount = size - 2;
        Expression[] tmpExps = new Expression[expCount];
        String[] tmpNames = new String[expCount];
        newExps[index] = tmpExps;
        newNames[index] = tmpNames;
        for (int i = 0; i < expCount; ++i) {
            MessageManager mm;
            IParam p = param.getSub(i + 2);
            if (p == null) {
                mm = EngineMessage.get();
                throw new RQException("joinx" + mm.getMessage("function.invalidParam"));
            }
            if (p.isLeaf()) {
                tmpExps[i] = p.getLeafExpression();
                continue;
            }
            if (p.getSubSize() != 2) {
                mm = EngineMessage.get();
                throw new RQException("joinx" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = p.getSub(0);
            if (sub0 == null) {
                MessageManager mm2 = EngineMessage.get();
                throw new RQException("joinx" + mm2.getMessage("function.invalidParam"));
            }
            tmpExps[i] = sub0.getLeafExpression();
            IParam sub1 = p.getSub(1);
            if (sub1 == null) continue;
            tmpNames[i] = sub1.getLeafExpression().getIdentifierName();
        }
    }

    protected static void parseSwitchParam(IParam param, int i, String[] fkNames, Object[] codes, Expression[] exps, Context ctx) {
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("switch" + mm.getMessage("function.missingParam"));
        }
        if (param.isLeaf()) {
            fkNames[i] = param.getLeafExpression().getIdentifierName();
            return;
        }
        int size = param.getSubSize();
        if (size > 3) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("switch" + mm.getMessage("function.invalidParam"));
        }
        IParam sub = param.getSub(0);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("switch" + mm.getMessage("function.invalidParam"));
        }
        fkNames[i] = sub.getLeafExpression().getIdentifierName();
        sub = param.getSub(1);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("switch" + mm.getMessage("function.invalidParam"));
        }
        if (sub.isLeaf()) {
            codes[i] = sub.getLeafExpression().calculate(ctx);
            if (codes[i] == null) {
                codes[i] = new Sequence();
            }
            if (size > 2 && (sub = param.getSub(2)) != null) {
                exps[i] = sub.getLeafExpression();
            }
        } else {
            IParam sub1;
            if (sub.getSubSize() != 2 || size > 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("switch" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = sub.getSub(0);
            if (sub0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("switch" + mm.getMessage("function.invalidParam"));
            }
            codes[i] = sub0.getLeafExpression().calculate(ctx);
            if (codes[i] == null) {
                codes[i] = new Sequence();
            }
            if ((sub1 = sub.getSub(1)) != null) {
                exps[i] = sub1.getLeafExpression();
            }
        }
    }

    protected static void parseSwitchParam(IParam param, int i, String[] fkNames, String[] timeFkNames, Object[] codes, Expression[] exps, Expression[] timeExps, Context ctx) {
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("switch" + mm.getMessage("function.missingParam"));
        }
        if (param.isLeaf()) {
            fkNames[i] = param.getLeafExpression().getIdentifierName();
            return;
        }
        if (param.getSubSize() != 2 || param.getType() != ',') {
            MessageManager mm = EngineMessage.get();
            throw new RQException("switch" + mm.getMessage("function.invalidParam"));
        }
        IParam sub = param.getSub(0);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("switch" + mm.getMessage("function.invalidParam"));
        }
        if (sub.isLeaf()) {
            fkNames[i] = sub.getLeafExpression().getIdentifierName();
        } else if (sub.getSubSize() == 2) {
            IParam sub0 = sub.getSub(0);
            IParam sub1 = sub.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("switch" + mm.getMessage("function.invalidParam"));
            }
            fkNames[i] = sub0.getLeafExpression().getIdentifierName();
            timeFkNames[i] = sub1.getLeafExpression().getIdentifierName();
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException("switch" + mm.getMessage("function.invalidParam"));
        }
        sub = param.getSub(1);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("switch" + mm.getMessage("function.invalidParam"));
        }
        if (sub.isLeaf()) {
            codes[i] = sub.getLeafExpression().calculate(ctx);
            if (codes[i] == null) {
                codes[i] = new Sequence();
            }
        } else {
            IParam sub2;
            IParam sub1;
            int size = sub.getSubSize();
            if (size > 3) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("switch" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = sub.getSub(0);
            if (sub0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("switch" + mm.getMessage("function.invalidParam"));
            }
            codes[i] = sub0.getLeafExpression().calculate(ctx);
            if (codes[i] == null) {
                codes[i] = new Sequence();
            }
            if ((sub1 = sub.getSub(1)) != null) {
                exps[i] = sub1.getLeafExpression();
            }
            if (size > 2 && (sub2 = sub.getSub(2)) != null) {
                timeExps[i] = sub2.getLeafExpression();
            }
        }
    }

    protected IArray calculateAll(IArray leftArray, Context ctx) {
        Current current = ctx.getComputeStack().getTopCurrent();
        int len = current.length();
        ObjectArray array = new ObjectArray(len);
        array.setTemporary(true);
        block0: for (int i = 1; i <= len; ++i) {
            current.setCurrent(i);
            Object leftValue = leftArray.get(i);
            if (leftValue == null) {
                array.push(null);
                continue;
            }
            if (leftValue instanceof Number && this.isSequenceFunction()) {
                int n = ((Number)leftValue).intValue();
                leftValue = n > 0 ? new Sequence(1, n) : new Sequence(0);
            }
            for (MemberFunction right = this; right != null; right = right.getNextFunction()) {
                if (!right.isLeftTypeMatch(leftValue)) continue;
                right.setDotLeftObject(leftValue);
                Object value = right.calculate(ctx);
                array.push(value);
                continue block0;
            }
            String fnName = this.getFunctionName();
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dot.leftTypeError", Variant.getDataType(leftValue), fnName));
        }
        return array;
    }

    protected BoolArray calculateAnd(IArray leftArray, Context ctx, IArray leftResult) {
        Current current = ctx.getComputeStack().getTopCurrent();
        int len = current.length();
        BoolArray result = leftResult.isTrue();
        block0: for (int i = 1; i <= len; ++i) {
            if (!leftResult.isTrue(i)) continue;
            current.setCurrent(i);
            Object leftValue = leftArray.get(i);
            if (leftValue == null) {
                result.set(i, false);
                continue;
            }
            if (leftValue instanceof Number && this.isSequenceFunction()) {
                int n = ((Number)leftValue).intValue();
                leftValue = n > 0 ? new Sequence(1, n) : new Sequence(0);
            }
            for (MemberFunction right = this; right != null; right = right.getNextFunction()) {
                if (!right.isLeftTypeMatch(leftValue)) continue;
                right.setDotLeftObject(leftValue);
                Object value = right.calculate(ctx);
                if (!Variant.isFalse(value)) continue block0;
                result.set(i, false);
                continue block0;
            }
            String fnName = this.getFunctionName();
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dot.leftTypeError", Variant.getDataType(leftValue), fnName));
        }
        return result;
    }

    protected IArray calculateAll(IArray leftArray, Context ctx, IArray signArray, boolean sign) {
        int size = signArray.size();
        ObjectArray result = new ObjectArray(size);
        result.setTemporary(true);
        Current current = ctx.getComputeStack().getTopCurrent();
        block0: for (int i = 1; i <= size; ++i) {
            if (signArray.isTrue(i) == sign) {
                current.setCurrent(i);
                Object leftValue = leftArray.get(i);
                if (leftValue == null) {
                    result.push(null);
                    continue;
                }
                if (leftValue instanceof Number && this.isSequenceFunction()) {
                    int n = ((Number)leftValue).intValue();
                    leftValue = n > 0 ? new Sequence(1, n) : new Sequence(0);
                }
                for (MemberFunction right = this; right != null; right = right.getNextFunction()) {
                    if (!right.isLeftTypeMatch(leftValue)) continue;
                    right.setDotLeftObject(leftValue);
                    Object value = right.calculate(ctx);
                    result.push(value);
                    continue block0;
                }
                String fnName = this.getFunctionName();
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dot.leftTypeError", Variant.getDataType(leftValue), fnName));
            }
            result.push(null);
        }
        return result;
    }

    public IArray calculateAll(Context ctx) {
        return this.calculateAll(this.left.calculateAll(ctx), ctx);
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        IArray leftArray = this.left.calculateAll(ctx, signArray, sign);
        return this.calculateAll(leftArray, ctx, signArray, sign);
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        IArray leftArray = this.left.calculateAll(ctx, leftResult, true);
        return this.calculateAnd(leftArray, ctx, leftResult);
    }
}

