/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.cellset.INormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.MemberFunction;
import com.scudata.expression.Move;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    public static final byte PRI_CMA = 1;
    public static final byte PRI_EVL = 2;
    public static final byte PRI_LINK = 4;
    public static final byte PRI_OR = 5;
    public static final byte PRI_AND = 6;
    public static final byte PRI_BOR = 7;
    public static final byte PRI_BXOR = 8;
    public static final byte PRI_BAND = 9;
    public static final byte PRI_IN = 10;
    public static final byte PRI_EQ = 10;
    public static final byte PRI_NEQ = 10;
    public static final byte PRI_GT = 11;
    public static final byte PRI_SL = 11;
    public static final byte PRI_NGT = 11;
    public static final byte PRI_NSL = 11;
    public static final byte PRI_ADD = 13;
    public static final byte PRI_SUB = 13;
    public static final byte PRI_MUL = 14;
    public static final byte PRI_DIV = 14;
    public static final byte PRI_MOD = 14;
    public static final byte PRI_NOT = 16;
    public static final byte PRI_NEGT = 17;
    public static final byte PRI_PLUS = 17;
    public static final byte PRI_SUF = 18;
    public static final byte PRI_NUM = 19;
    public static final byte PRI_BRK = 20;
    protected int priority = 19;

    public void setInBrackets(int inBrackets) {
        this.priority += inBrackets * 20;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setLeft(Node node) {
        if (node != null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.logicError"));
        }
    }

    public void setRight(Node node) {
        if (node != null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.logicError"));
        }
    }

    public Node getLeft() {
        return null;
    }

    public Node getRight() {
        return null;
    }

    public void setDotLeftObject(Object obj) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Expression.logicError"));
    }

    public void releaseDotLeftObject() {
    }

    public boolean isSequenceFunction() {
        return false;
    }

    public boolean isLeftTypeMatch(Object obj) {
        return true;
    }

    public MemberFunction getNextFunction() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Expression.logicError"));
    }

    public abstract Object calculate(Context var1);

    public INormalCell calculateCell(Context ctx) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("engine.needCellExp"));
    }

    protected boolean containParam(String name) {
        return false;
    }

    protected void getUsedParams(Context ctx, ParamList resultList) {
    }

    public void getUsedFields(Context ctx, List<String> resultList) {
    }

    protected void getUsedCells(List<INormalCell> resultList) {
    }

    public boolean ifModifySequence() {
        return true;
    }

    public Node optimize(Context ctx, boolean optSequence) {
        return this.optimize(ctx);
    }

    public Node optimize(Context ctx) {
        return this;
    }

    public Node deepOptimize(Context ctx) {
        return this.optimize(ctx);
    }

    public Object assign(Object value, Context ctx) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("assign.needVar"));
    }

    public Object addAssign(Object value, Context ctx) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("assign.needVar"));
    }

    public byte calcExpValueType(Context ctx) {
        return 101;
    }

    public Object move(Move node, Context ctx) {
        Object obj = this.calculate(ctx);
        if (!(obj instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("dot.seriesLeft"));
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = stack.getSequenceCurrent((Sequence)obj);
        if (current == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("engine.seriesNotInStack"));
        }
        int index = node.calculateIndex(current, ctx);
        return index > 0 ? current.get(index) : null;
    }

    public Object moveAssign(Move node, Object value, Context ctx) {
        Object obj = this.calculate(ctx);
        if (!(obj instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("dot.seriesLeft"));
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = stack.getSequenceCurrent((Sequence)obj);
        if (current == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("engine.seriesNotInStack"));
        }
        int index = node.calculateIndex(current, ctx);
        if (index > 0) {
            current.assign(index, value);
        }
        return value;
    }

    public Object moves(Move node, Context ctx) {
        int startSeq;
        Object obj = this.calculate(ctx);
        if (!(obj instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("dot.seriesLeft"));
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = stack.getSequenceCurrent((Sequence)obj);
        if (current == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("engine.seriesNotInStack"));
        }
        int[] range = node.calculateIndexRange(current, ctx);
        if (range == null) {
            return new Sequence(0);
        }
        int endSeq = range[1];
        Sequence result = new Sequence(endSeq - startSeq + 1);
        for (startSeq = range[0]; startSeq <= endSeq; ++startSeq) {
            result.add(current.get(startSeq));
        }
        return result;
    }

    public boolean isFunction(String name) {
        return false;
    }

    public void prepare(Context ctx) {
    }

    public Object gather(Context ctx) {
        return this.calculate(ctx);
    }

    public Object gather(Object oldValue, Context ctx) {
        return oldValue;
    }

    public IArray gather(IArray result, int[] resultSeqs, Context ctx) {
        IArray array = this.calculateAll(ctx);
        if (result == null) {
            result = array.newInstance(8191);
        }
        int len = array.size();
        for (int i = 1; i <= len; ++i) {
            if (result.size() >= resultSeqs[i]) continue;
            result.add(array, i);
        }
        return result;
    }

    public void gather2(IArray result, IArray result2, int[] seqs, Context ctx) {
    }

    public Expression getRegatherExpression(int q) {
        String str = "#" + q;
        return new Expression(str);
    }

    public boolean needFinish1() {
        return false;
    }

    public Object finish1(Object val) {
        return val;
    }

    public IArray finish1(IArray array) {
        return array;
    }

    public boolean needFinish() {
        return false;
    }

    public Object finish(Object val) {
        return val;
    }

    public IArray finish(IArray array) {
        return array;
    }

    public void checkValidity() {
    }

    public boolean canCalculateAll() {
        return true;
    }

    public IArray calculateAll(Context ctx) {
        Current current = ctx.getComputeStack().getTopCurrent();
        int len = current.length();
        ObjectArray array = new ObjectArray(len);
        array.setTemporary(true);
        for (int i = 1; i <= len; ++i) {
            current.setCurrent(i);
            Object value = this.calculate(ctx);
            array.push(value);
        }
        return array;
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        Current current = ctx.getComputeStack().getTopCurrent();
        int len = current.length();
        ObjectArray array = new ObjectArray(len);
        array.setTemporary(true);
        for (int i = 1; i <= len; ++i) {
            if (signArray.isTrue(i) == sign) {
                current.setCurrent(i);
                Object value = this.calculate(ctx);
                array.push(value);
                continue;
            }
            array.push(null);
        }
        return array;
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        BoolArray result = leftResult.isTrue();
        int size = result.size();
        Current current = ctx.getComputeStack().getTopCurrent();
        for (int i = 1; i <= size; ++i) {
            if (!result.isTrue(i)) continue;
            current.setCurrent(i);
            Object value = this.calculate(ctx);
            if (!Variant.isFalse(value)) continue;
            result.set(i, false);
        }
        return result;
    }

    public boolean isMonotone() {
        return false;
    }

    public IArray calculateRange(Context ctx) {
        if (this.isMonotone()) {
            return this.calculateAll(ctx);
        }
        return null;
    }

    public int isValueRangeMatch(Context ctx) {
        return 0;
    }

    public void reset() {
    }
}

