/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Between
extends Function {
    private Expression _$3;
    private Expression _$2;
    private Expression _$1;

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("between" + mm.getMessage("function.missingParam"));
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("between" + mm.getMessage("function.invalidParam"));
        }
        IParam sub0 = this.param.getSub(0);
        IParam sub1 = this.param.getSub(1);
        if (sub0 == null || sub1 == null || sub1.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("between" + mm.getMessage("function.invalidParam"));
        }
        this._$3 = sub0.getLeafExpression();
        IParam startParam = sub1.getSub(0);
        IParam endParam = sub1.getSub(1);
        if (startParam == null || endParam == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("between" + mm.getMessage("function.invalidParam"));
        }
        this._$2 = startParam.getLeafExpression();
        this._$1 = endParam.getLeafExpression();
    }

    public Object calculate(Context ctx) {
        Object val = this._$3.calculate(ctx);
        Object startVal = this._$2.calculate(ctx);
        int cmp = Variant.compare(val, startVal, true);
        if (this.option == null || this.option.indexOf(98) == -1) {
            if (cmp > 0) {
                Object endVal = this._$1.calculate(ctx);
                cmp = Variant.compare(val, endVal, true);
                if (cmp < 0) {
                    return Boolean.TRUE;
                }
                if (cmp == 0) {
                    return this.option == null || this.option.indexOf(114) == -1;
                }
                return Boolean.FALSE;
            }
            if (cmp == 0) {
                return this.option == null || this.option.indexOf(108) == -1;
            }
            return Boolean.FALSE;
        }
        if (cmp > 0) {
            Object endVal = this._$1.calculate(ctx);
            cmp = Variant.compare(val, endVal, true);
            if (cmp < 0) {
                return ObjectCache.getInteger(0);
            }
            if (cmp == 0) {
                if (this.option.indexOf(114) == -1) {
                    return ObjectCache.getInteger(0);
                }
                return ObjectCache.getInteger(1);
            }
            return ObjectCache.getInteger(1);
        }
        if (cmp == 0) {
            if (this.option.indexOf(108) == -1) {
                return ObjectCache.getInteger(0);
            }
            return ObjectCache.getInteger(-1);
        }
        return ObjectCache.getInteger(-1);
    }

    public IArray calculateAll(Context ctx) {
        boolean isBinary = false;
        int leftRelation = 3;
        int rightRelation = 5;
        if (this.option != null) {
            if (this.option.indexOf(98) != -1) {
                isBinary = true;
            }
            if (this.option.indexOf(108) != -1) {
                leftRelation = 2;
            }
            if (this.option.indexOf(114) != -1) {
                rightRelation = 4;
            }
        }
        IArray array = this._$3.calculateAll(ctx);
        IArray startArray = this._$2.calculateAll(ctx);
        BoolArray result = array.calcRelation(startArray, leftRelation);
        IArray endArray = this._$1.calculateAll(ctx, result, true);
        if (isBinary) {
            int i;
            int size = result.size();
            int[] values = new int[size + 1];
            boolean[] signs = result.getDatas();
            for (i = 1; i <= size; ++i) {
                values[i] = signs[i] ? 0 : -1;
            }
            array.calcRelations(endArray, rightRelation, result, true);
            for (i = 1; i <= size; ++i) {
                if (values[i] != 0 || signs[i]) continue;
                values[i] = 1;
            }
            return new IntArray(values, null, size);
        }
        array.calcRelations(endArray, rightRelation, result, true);
        return result;
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        boolean isBinary = false;
        int leftRelation = 3;
        int rightRelation = 5;
        if (this.option != null) {
            if (this.option.indexOf(98) != -1) {
                isBinary = true;
            }
            if (this.option.indexOf(108) != -1) {
                leftRelation = 2;
            }
            if (this.option.indexOf(114) != -1) {
                rightRelation = 4;
            }
        }
        BoolArray result = ArrayUtil.booleanValue(signArray, sign);
        IArray array = this._$3.calculateAll(ctx, result, true);
        IArray startArray = this._$2.calculateAll(ctx, result, true);
        array.calcRelations(startArray, leftRelation, result, true);
        IArray endArray = this._$1.calculateAll(ctx, result, true);
        if (isBinary) {
            int i;
            int size = result.size();
            int[] values = new int[size + 1];
            boolean[] signs = result.getDatas();
            for (i = 1; i <= size; ++i) {
                values[i] = signs[i] ? 0 : -1;
            }
            array.calcRelations(endArray, rightRelation, result, true);
            for (i = 1; i <= size; ++i) {
                if (values[i] != 0 || signs[i]) continue;
                values[i] = 1;
            }
            return new IntArray(values, null, size);
        }
        array.calcRelations(endArray, rightRelation, result, true);
        return result;
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        int leftRelation = 3;
        int rightRelation = 5;
        if (this.option != null) {
            if (this.option.indexOf(108) != -1) {
                leftRelation = 2;
            }
            if (this.option.indexOf(114) != -1) {
                rightRelation = 4;
            }
        }
        BoolArray result = leftResult.isTrue();
        IArray array = this._$3.calculateAll(ctx, result, true);
        IArray startArray = this._$2.calculateAll(ctx, result, true);
        array.calcRelations(startArray, leftRelation, result, true);
        IArray endArray = this._$1.calculateAll(ctx, result, true);
        array.calcRelations(endArray, rightRelation, result, true);
        return result;
    }

    public int isValueRangeMatch(Context ctx) {
        IArray array = this._$3.calculateRange(ctx);
        if (array == null) {
            return 0;
        }
        IArray startArray = this._$2.calculateRange(ctx);
        if (!(startArray instanceof ConstArray)) {
            return 0;
        }
        IArray endArray = this._$1.calculateRange(ctx);
        if (!(endArray instanceof ConstArray)) {
            return 0;
        }
        boolean containLeft = true;
        boolean containRight = true;
        if (this.option != null) {
            if (this.option.indexOf(108) != -1) {
                containLeft = false;
            }
            if (this.option.indexOf(114) != -1) {
                containRight = false;
            }
        }
        Object startVal = startArray.get(1);
        Object endVal = endArray.get(1);
        Object minVal = array.get(1);
        int cmp = Variant.compare(minVal, startVal, true);
        if (cmp > 0 || cmp == 0 && containLeft) {
            cmp = Variant.compare(minVal, endVal, true);
            if (cmp < 0 || cmp == 0 && containRight) {
                Object maxValue = array.get(2);
                cmp = Variant.compare(maxValue, endVal, true);
                if (cmp < 0 || cmp == 0 && containRight) {
                    return 1;
                }
                return 0;
            }
            return -1;
        }
        Object maxValue = array.get(2);
        cmp = Variant.compare(maxValue, startVal, true);
        if (cmp > 0 || cmp == 0 && containLeft) {
            return 0;
        }
        return -1;
    }
}

