/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.expression.fn.lIlIlIlIlllIIIII;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharEncodingDetect
extends lIlIlIlIlllIIIII {
    int[] _$1 = new int[TOTALTYPES];
    public boolean debug = false;

    public static void main(String[] argc) {
        int result = OTHER;
        CharEncodingDetect sinodetector = new CharEncodingDetect();
        for (int i = 0; i < argc.length; ++i) {
            if (argc[i].startsWith("http://")) {
                try {
                    result = sinodetector.detectEncoding(new URL(argc[i]));
                }
                catch (Exception e) {
                    System.err.println("Bad URL " + e.toString());
                }
            } else {
                if (argc[i].equals("-d")) {
                    sinodetector.debug = true;
                    continue;
                }
                result = sinodetector.detectEncoding(new File(argc[i]));
            }
            System.out.println(nicename[result]);
        }
    }

    public int detectEncoding(URL testurl) {
        byte[] rawtext = new byte[10000];
        int bytesread = 0;
        int byteoffset = 0;
        int guess = OTHER;
        try {
            InputStream chinesestream = testurl.openStream();
            while ((bytesread = chinesestream.read(rawtext, byteoffset, rawtext.length - byteoffset)) > 0) {
                byteoffset += bytesread;
            }
            chinesestream.close();
            guess = this._$1(rawtext, 0);
        }
        catch (Exception e) {
            System.err.println("Error loading or using URL " + e.toString());
            guess = -1;
        }
        return guess;
    }

    public int detectEncoding(File testfile) {
        byte[] rawtext = new byte[(int)testfile.length()];
        try {
            FileInputStream chinesefile = new FileInputStream(testfile);
            chinesefile.read(rawtext);
            chinesefile.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
        }
        return this._$1(rawtext, 0);
    }

    public int detectEncoding(byte[] rawtext) {
        return this._$1(rawtext, 0);
    }

    public int detectEncoding(byte[] rawtext, int lang) {
        return this._$1(rawtext, lang);
    }

    private int _$1(byte[] rawtext, int lang) {
        if (lang == LANG.CHINESE.ordinal()) {
            this._$1[CharEncodingDetect.GB2312] = this._$18(rawtext);
            this._$1[CharEncodingDetect.GBK] = this._$17(rawtext);
            this._$1[CharEncodingDetect.GB18030] = this._$16(rawtext);
            this._$1[CharEncodingDetect.HZ] = this._$15(rawtext);
            this._$1[CharEncodingDetect.BIG5] = this._$14(rawtext);
            this._$1[CharEncodingDetect.CNS11643] = this._$12(rawtext);
            this._$1[CharEncodingDetect.ISO2022CN] = this._$11(rawtext);
            this._$1[CharEncodingDetect.UTF8] = this._$10(rawtext);
            this._$1[CharEncodingDetect.UNICODE] = this._$9(rawtext);
            this._$1[CharEncodingDetect.UNICODE_ESCAPE] = this._$1(rawtext);
            this._$1[CharEncodingDetect.ASCII] = this._$8(rawtext);
        } else if (lang == LANG.SIMPLIFIED_CHINESE.ordinal()) {
            this._$1[CharEncodingDetect.GB2312] = this._$18(rawtext);
            this._$1[CharEncodingDetect.GB18030] = this._$16(rawtext);
            this._$1[CharEncodingDetect.ASCII] = this._$8(rawtext);
            this._$1[CharEncodingDetect.UTF8] = this._$10(rawtext);
            this._$1[CharEncodingDetect.UNICODE] = this._$9(rawtext);
            this._$1[CharEncodingDetect.UNICODE_ESCAPE] = this._$1(rawtext);
        } else if (lang == LANG.TRADITIONAL_CHINESE.ordinal()) {
            this._$1[CharEncodingDetect.BIG5] = this._$14(rawtext);
            this._$1[CharEncodingDetect.CNS11643] = this._$12(rawtext);
            this._$1[CharEncodingDetect.ASCII] = this._$8(rawtext);
            this._$1[CharEncodingDetect.UTF8] = this._$10(rawtext);
            this._$1[CharEncodingDetect.UNICODE] = this._$9(rawtext);
            this._$1[CharEncodingDetect.UNICODE_ESCAPE] = this._$1(rawtext);
        } else if (lang == LANG.JAPANESE.ordinal()) {
            this._$1[CharEncodingDetect.SJIS] = this._$2(rawtext);
            this._$1[CharEncodingDetect.EUC_JP] = this._$4(rawtext);
            this._$1[CharEncodingDetect.ISO2022JP] = this._$3(rawtext);
            this._$1[CharEncodingDetect.ASCII] = this._$8(rawtext);
            this._$1[CharEncodingDetect.UTF8] = this._$10(rawtext);
            this._$1[CharEncodingDetect.UNICODE] = this._$9(rawtext);
        } else if (lang == LANG.KOREAN.ordinal()) {
            this._$1[CharEncodingDetect.ISO2022KR] = this._$5(rawtext);
            this._$1[CharEncodingDetect.EUC_KR] = this._$7(rawtext);
            this._$1[CharEncodingDetect.CP949] = this._$6(rawtext);
            this._$1[CharEncodingDetect.ASCII] = this._$8(rawtext);
            this._$1[CharEncodingDetect.UTF8] = this._$10(rawtext);
            this._$1[CharEncodingDetect.UNICODE] = this._$9(rawtext);
        } else {
            this._$1[CharEncodingDetect.GB2312] = this._$18(rawtext);
            this._$1[CharEncodingDetect.GBK] = this._$17(rawtext);
            this._$1[CharEncodingDetect.GB18030] = this._$16(rawtext);
            this._$1[CharEncodingDetect.HZ] = this._$15(rawtext);
            this._$1[CharEncodingDetect.BIG5] = this._$14(rawtext);
            this._$1[CharEncodingDetect.CNS11643] = this._$12(rawtext);
            this._$1[CharEncodingDetect.ISO2022CN] = this._$11(rawtext);
            this._$1[CharEncodingDetect.UTF8] = this._$10(rawtext);
            this._$1[CharEncodingDetect.UNICODE] = this._$9(rawtext);
            this._$1[CharEncodingDetect.EUC_KR] = this._$7(rawtext);
            this._$1[CharEncodingDetect.CP949] = this._$6(rawtext);
            this._$1[CharEncodingDetect.JOHAB] = 0;
            this._$1[CharEncodingDetect.ISO2022KR] = this._$5(rawtext);
            this._$1[CharEncodingDetect.ASCII] = this._$8(rawtext);
            this._$1[CharEncodingDetect.SJIS] = this._$2(rawtext);
            this._$1[CharEncodingDetect.EUC_JP] = this._$4(rawtext);
            this._$1[CharEncodingDetect.ISO2022JP] = this._$3(rawtext);
            this._$1[CharEncodingDetect.UNICODET] = 0;
            this._$1[CharEncodingDetect.UNICODE_ESCAPE] = this._$1(rawtext);
            this._$1[CharEncodingDetect.ISO2022CN_GB] = 0;
            this._$1[CharEncodingDetect.ISO2022CN_CNS] = 0;
            this._$1[CharEncodingDetect.OTHER] = 0;
        }
        int maxscore = 0;
        int encoding_guess = OTHER;
        for (int index = 0; index < TOTALTYPES; ++index) {
            if (this.debug && this._$1[index] > 0) {
                System.err.println("Encoding " + nicename[index] + " score " + this._$1[index]);
            }
            if (this._$1[index] <= maxscore) continue;
            encoding_guess = index;
            maxscore = this._$1[index];
        }
        if (maxscore <= 50) {
            encoding_guess = OTHER;
        }
        return encoding_guess;
    }

    public List<String> autoDetectEncoding(byte[] rawtext) {
        this._$1[CharEncodingDetect.GB2312] = this._$18(rawtext);
        this._$1[CharEncodingDetect.GBK] = this._$17(rawtext);
        this._$1[CharEncodingDetect.GB18030] = this._$16(rawtext);
        this._$1[CharEncodingDetect.HZ] = this._$15(rawtext);
        this._$1[CharEncodingDetect.BIG5] = this._$14(rawtext);
        this._$1[CharEncodingDetect.CNS11643] = this._$12(rawtext);
        this._$1[CharEncodingDetect.ISO2022CN] = this._$11(rawtext);
        this._$1[CharEncodingDetect.UTF8] = this._$10(rawtext);
        this._$1[CharEncodingDetect.UNICODE] = this._$9(rawtext);
        this._$1[CharEncodingDetect.EUC_KR] = this._$7(rawtext);
        this._$1[CharEncodingDetect.CP949] = this._$6(rawtext);
        this._$1[CharEncodingDetect.JOHAB] = 0;
        this._$1[CharEncodingDetect.ISO2022KR] = this._$5(rawtext);
        this._$1[CharEncodingDetect.ASCII] = this._$8(rawtext);
        this._$1[CharEncodingDetect.SJIS] = this._$2(rawtext);
        this._$1[CharEncodingDetect.EUC_JP] = this._$4(rawtext);
        this._$1[CharEncodingDetect.ISO2022JP] = this._$3(rawtext);
        this._$1[CharEncodingDetect.UNICODET] = 0;
        this._$1[CharEncodingDetect.UNICODE_ESCAPE] = this._$1(rawtext);
        this._$1[CharEncodingDetect.ISO2022CN_GB] = 0;
        this._$1[CharEncodingDetect.ISO2022CN_CNS] = 0;
        this._$1[CharEncodingDetect.OTHER] = 0;
        int maxscore = 0;
        int encoding_guess = OTHER;
        ArrayList<String> lls = new ArrayList<String>();
        for (int index = 0; index < TOTALTYPES; ++index) {
            if (this.debug && this._$1[index] > 0) {
                System.err.println("Encoding " + nicename[index] + " score " + this._$1[index]);
            }
            if (this._$1[index] < maxscore) continue;
            encoding_guess = index;
            if (this._$1[index] > maxscore) {
                lls.clear();
            }
            maxscore = this._$1[index];
            lls.add(nicename[index]);
        }
        if (maxscore <= 50) {
            encoding_guess = OTHER;
            lls.clear();
            lls.add("OTHER");
        }
        return lls;
    }

    int _$18(byte[] rawtext) {
        int rawtextlen = 0;
        int dbchars = 1;
        int gbchars = 1;
        long gbfreq = 0L;
        long totalfreq = 1L;
        float rangeval = 0.0f;
        float freqval = 0.0f;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen - 1; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -9 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                ++gbchars;
                totalfreq += 500L;
                int row = rawtext[i] + 256 - 161;
                int column = rawtext[i + 1] + 256 - 161;
                gbfreq = 15 <= row && row < 55 ? (gbfreq += 435L) : (55 <= row && row < 87 ? (gbfreq += 234L) : (gbfreq += 50L));
            }
            ++i;
        }
        rangeval = 50.0f * ((float)gbchars / (float)dbchars);
        freqval = 50.0f * ((float)gbfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    int _$17(byte[] rawtext) {
        int rawtextlen = 0;
        int dbchars = 1;
        int gbchars = 1;
        long gbfreq = 0L;
        long totalfreq = 1L;
        float rangeval = 0.0f;
        float freqval = 0.0f;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen - 1; ++i) {
            int column;
            int row;
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -9 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                ++gbchars;
                totalfreq += 500L;
                row = rawtext[i] + 256 - 161;
                column = rawtext[i + 1] + 256 - 161;
                gbfreq = 15 <= row && row < 55 ? (gbfreq += 435L) : (55 <= row && row < 87 ? (gbfreq += 234L) : (gbfreq += 50L));
            } else if (-127 <= rawtext[i] && rawtext[i] <= -2 && (-128 <= rawtext[i + 1] && rawtext[i + 1] <= -2 || 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126)) {
                ++gbchars;
                totalfreq += 500L;
                row = rawtext[i] + 256 - 129;
                column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] + 256 - 64;
                gbfreq += 185L;
            }
            ++i;
        }
        rangeval = 50.0f * ((float)gbchars / (float)dbchars);
        freqval = 50.0f * ((float)gbfreq / (float)totalfreq);
        return (int)(rangeval + freqval) - 1;
    }

    int _$16(byte[] rawtext) {
        int rawtextlen = 0;
        int dbchars = 1;
        int gbchars = 1;
        long gbfreq = 0L;
        long totalfreq = 1L;
        float rangeval = 0.0f;
        float freqval = 0.0f;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen - 1; ++i) {
            int column;
            int row;
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (i + 1 < rawtextlen && -95 <= rawtext[i] && rawtext[i] <= -9 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                ++gbchars;
                totalfreq += 500L;
                row = rawtext[i] + 256 - 161;
                column = rawtext[i + 1] + 256 - 161;
                gbfreq = 15 <= row && row < 55 ? (gbfreq += 435L) : (55 <= row && row < 87 ? (gbfreq += 234L) : (gbfreq += 50L));
            } else if (i + 1 < rawtextlen && -127 <= rawtext[i] && rawtext[i] <= -2 && (-128 <= rawtext[i + 1] && rawtext[i + 1] <= -2 || 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126)) {
                ++gbchars;
                totalfreq += 500L;
                row = rawtext[i] + 256 - 129;
                column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] + 256 - 64;
                gbfreq += 185L;
            } else if (i + 3 < rawtextlen && -127 <= rawtext[i] && rawtext[i] <= -2 && 48 <= rawtext[i + 1] && rawtext[i + 1] <= 57 && -127 <= rawtext[i + 2] && rawtext[i + 2] <= -2 && 48 <= rawtext[i + 3] && rawtext[i + 3] <= 57) {
                ++gbchars;
            }
            ++i;
        }
        rangeval = 50.0f * ((float)gbchars / (float)dbchars);
        freqval = 50.0f * ((float)gbfreq / (float)totalfreq);
        return (int)(rangeval + freqval) - 1;
    }

    int _$15(byte[] rawtext) {
        int hzchars = 0;
        int dbchars = 1;
        long hzfreq = 0L;
        long totalfreq = 1L;
        float rangeval = 0.0f;
        float freqval = 0.0f;
        int hzstart = 0;
        int hzend = 0;
        int rawtextlen = rawtext.length;
        block0: for (int i = 0; i < rawtextlen; ++i) {
            if (rawtext[i] != 126) continue;
            if (rawtext[i + 1] == 123) {
                ++hzstart;
                i += 2;
                while (i < rawtextlen - 1 && rawtext[i] != 10 && rawtext[i] != 13) {
                    int column;
                    int row;
                    if (rawtext[i] == 126 && rawtext[i + 1] == 125) {
                        ++hzend;
                        ++i;
                        continue block0;
                    }
                    if (33 <= rawtext[i] && rawtext[i] <= 119 && 33 <= rawtext[i + 1] && rawtext[i + 1] <= 119) {
                        hzchars += 2;
                        row = rawtext[i] - 33;
                        column = rawtext[i + 1] - 33;
                        totalfreq += 500L;
                        hzfreq = 15 <= row && row < 55 ? (hzfreq += 435L) : (55 <= row && row < 87 ? (hzfreq += 234L) : (hzfreq += 50L));
                    } else if (161 <= rawtext[i] && rawtext[i] <= 247 && 161 <= rawtext[i + 1] && rawtext[i + 1] <= 247) {
                        hzchars += 2;
                        row = rawtext[i] + 256 - 161;
                        column = rawtext[i + 1] + 256 - 161;
                        totalfreq += 500L;
                        hzfreq = 15 <= row && row < 55 ? (hzfreq += 435L) : (55 <= row && row < 87 ? (hzfreq += 234L) : (hzfreq += 50L));
                    }
                    dbchars += 2;
                    i += 2;
                }
                continue;
            }
            if (rawtext[i + 1] == 125) {
                ++hzend;
                ++i;
                continue;
            }
            if (rawtext[i + 1] != 126) continue;
            ++i;
        }
        rangeval = hzstart > 4 ? 50.0f : (hzstart > 1 ? 41.0f : (hzstart > 0 ? 39.0f : 0.0f));
        freqval = 50.0f * ((float)hzfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    int _$14(byte[] rawtext) {
        int rawtextlen = 0;
        int dbchars = 1;
        int bfchars = 1;
        float rangeval = 0.0f;
        float freqval = 0.0f;
        long bffreq = 0L;
        long totalfreq = 1L;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen - 1; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -7 && (64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 || -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2)) {
                ++bfchars;
                totalfreq += 500L;
                int row = rawtext[i] + 256 - 161;
                int column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] + 256 - 97;
                bffreq = 3 <= row && row <= 37 ? (bffreq += 436L) : (bffreq += 50L);
            }
            ++i;
        }
        rangeval = 50.0f * ((float)bfchars / (float)dbchars);
        freqval = 50.0f * ((float)bffreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    int _$13(byte[] rawtext) {
        int rawtextlen = 0;
        int dbchars = 1;
        int bfchars = 1;
        long bffreq = 0L;
        long totalfreq = 1L;
        float rangeval = 0.0f;
        float freqval = 0.0f;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen - 1; ++i) {
            int column;
            int row;
            if (rawtext[i] >= 128) continue;
            ++dbchars;
            if (161 <= rawtext[i] && rawtext[i] <= 249 && (64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 || 161 <= rawtext[i + 1] && rawtext[i + 1] <= 254)) {
                ++bfchars;
                totalfreq += 500L;
                row = rawtext[i] - 161;
                column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] - 97;
                bffreq = 3 <= row && row <= 37 ? (bffreq += 436L) : (bffreq += 50L);
            } else if (129 <= rawtext[i] && rawtext[i] <= 254 && (64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 || 128 <= rawtext[i + 1] && rawtext[i + 1] <= 254)) {
                ++bfchars;
                totalfreq += 500L;
                row = rawtext[i] - 129;
                column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] - 64;
                bffreq += 185L;
            }
            ++i;
        }
        rangeval = 50.0f * ((float)bfchars / (float)dbchars);
        freqval = 50.0f * ((float)bffreq / (float)totalfreq);
        return (int)(rangeval + freqval) - 1;
    }

    int _$12(byte[] rawtext) {
        int rawtextlen = 0;
        int dbchars = 1;
        int cnschars = 1;
        long cnsfreq = 0L;
        long totalfreq = 1L;
        float rangeval = 0.0f;
        float freqval = 0.0f;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen - 1; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (i + 3 < rawtextlen && -114 == rawtext[i] && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -80 && -95 <= rawtext[i + 2] && rawtext[i + 2] <= -2 && -95 <= rawtext[i + 3] && rawtext[i + 3] <= -2) {
                ++cnschars;
                i += 3;
                continue;
            }
            if (-95 > rawtext[i] || rawtext[i] > -2 || -95 > rawtext[i + 1] || rawtext[i + 1] > -2) continue;
            ++cnschars;
            totalfreq += 500L;
            int row = rawtext[i] + 256 - 161;
            int column = rawtext[i + 1] + 256 - 161;
            cnsfreq = 35 <= row && row <= 92 ? (cnsfreq += 435L) : (cnsfreq += 50L);
            ++i;
        }
        rangeval = 50.0f * ((float)cnschars / (float)dbchars);
        freqval = 50.0f * ((float)cnsfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    int _$11(byte[] rawtext) {
        int rawtextlen = 0;
        int dbchars = 1;
        int isochars = 1;
        long isofreq = 0L;
        long totalfreq = 1L;
        float rangeval = 0.0f;
        float freqval = 0.0f;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen - 1; ++i) {
            int column;
            int row;
            if (i + 3 >= rawtextlen || rawtext[i] != 27) continue;
            if (rawtext[i + 1] == 36 && rawtext[i + 2] == 41 && rawtext[i + 3] == 65) {
                i += 4;
                while (rawtext[i] != 27 && i < rawtextlen - 1) {
                    ++dbchars;
                    if (33 <= rawtext[i] && rawtext[i] <= 119 && 33 <= rawtext[i + 1] && rawtext[i + 1] <= 119) {
                        ++isochars;
                        row = rawtext[i] - 33;
                        column = rawtext[i + 1] - 33;
                        totalfreq += 500L;
                        if (15 <= row && row < 55) {
                            isofreq += 435L;
                        } else if (55 <= row && row < 87) {
                            isofreq += 234L;
                        }
                        ++i;
                    }
                    ++i;
                }
            } else if (rawtext[i + 1] == 36 && rawtext[i + 2] == 41 && rawtext[i + 3] == 71) {
                i += 4;
                while (rawtext[i] != 27) {
                    ++dbchars;
                    if (33 <= rawtext[i] && rawtext[i] <= 126 && 33 <= rawtext[i + 1] && rawtext[i + 1] <= 126) {
                        ++isochars;
                        totalfreq += 500L;
                        row = rawtext[i] - 33;
                        column = rawtext[i + 1] - 33;
                        isofreq = 35 <= row && row <= 92 ? (isofreq += 435L) : (isofreq += 150L);
                        ++i;
                    }
                    ++i;
                }
            }
            if (rawtext[i] != 27 || i + 2 >= rawtextlen || rawtext[i + 1] != 40 || rawtext[i + 2] != 66) continue;
            i += 2;
        }
        rangeval = 50.0f * ((float)isochars / (float)dbchars);
        freqval = 50.0f * ((float)isofreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    int _$10(byte[] rawtext) {
        int score = 0;
        int rawtextlen = 0;
        int goodbytes = 0;
        int asciibytes = 0;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen; ++i) {
            if ((rawtext[i] & 0x7F) == rawtext[i]) {
                ++asciibytes;
                continue;
            }
            if (i + 1 < rawtextlen && -64 <= rawtext[i] && rawtext[i] <= -33 && -128 <= rawtext[i + 1] && rawtext[i + 1] <= -65) {
                goodbytes += 2;
                ++i;
                continue;
            }
            if (i + 2 >= rawtextlen || -32 > rawtext[i] || rawtext[i] > -17 || -128 > rawtext[i + 1] || rawtext[i + 1] > -65 || -128 > rawtext[i + 2] || rawtext[i + 2] > -65) continue;
            goodbytes += 3;
            i += 2;
        }
        if (asciibytes == rawtextlen) {
            return 0;
        }
        score = (int)(100.0f * ((float)goodbytes / (float)(rawtextlen - asciibytes)));
        if (score > 98) {
            return score;
        }
        if (score > 95 && goodbytes > 30) {
            return score;
        }
        return 0;
    }

    int _$9(byte[] rawtext) {
        if (rawtext.length > 1 && -2 == rawtext[0] && -1 == rawtext[1] || -1 == rawtext[0] && -2 == rawtext[1]) {
            return 100;
        }
        return 0;
    }

    int _$8(byte[] rawtext) {
        int score = 75;
        int rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen; ++i) {
            if (rawtext[i] < 0) {
                score -= 5;
            } else if (rawtext[i] == 27) {
                score -= 5;
            }
            if (score > 0) continue;
            return 0;
        }
        return score;
    }

    int _$7(byte[] rawtext) {
        int rawtextlen = 0;
        int dbchars = 1;
        int krchars = 1;
        long krfreq = 0L;
        long totalfreq = 1L;
        float rangeval = 0.0f;
        float freqval = 0.0f;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen - 1; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -2 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                ++krchars;
                totalfreq += 500L;
                int row = rawtext[i] + 256 - 161;
                int column = rawtext[i + 1] + 256 - 161;
                krfreq = row >= 15 && row < 40 ? (krfreq += 436L) : (krfreq += 50L);
            }
            ++i;
        }
        rangeval = 50.0f * ((float)krchars / (float)dbchars);
        freqval = 50.0f * ((float)krfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    int _$6(byte[] rawtext) {
        int rawtextlen = 0;
        int dbchars = 1;
        int krchars = 1;
        long krfreq = 0L;
        long totalfreq = 1L;
        float rangeval = 0.0f;
        float freqval = 0.0f;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen - 1; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-127 <= rawtext[i] && rawtext[i] <= -2 && (65 <= rawtext[i + 1] && rawtext[i + 1] <= 90 || 97 <= rawtext[i + 1] && rawtext[i + 1] <= 122 || -127 <= rawtext[i + 1] && rawtext[i + 1] <= -2)) {
                ++krchars;
                totalfreq += 500L;
                if (-95 <= rawtext[i] && rawtext[i] <= -2 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                    int row = rawtext[i] + 256 - 161;
                    int column = rawtext[i + 1] + 256 - 161;
                    krfreq = row >= 15 && row < 40 ? (krfreq += 436L) : (krfreq += 50L);
                } else {
                    krfreq += 235L;
                }
            }
            ++i;
        }
        rangeval = 50.0f * ((float)krchars / (float)dbchars);
        freqval = 50.0f * ((float)krfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    int _$5(byte[] rawtext) {
        for (int i = 0; i < rawtext.length; ++i) {
            if (i + 3 >= rawtext.length || rawtext[i] != 27 || (char)rawtext[i + 1] != '$' || (char)rawtext[i + 2] != ')' || (char)rawtext[i + 3] != 'C') continue;
            return 100;
        }
        return 0;
    }

    int _$4(byte[] rawtext) {
        int rawtextlen = 0;
        int dbchars = 1;
        int jpchars = 1;
        long jpfreq = 0L;
        long totalfreq = 1L;
        float rangeval = 0.0f;
        float freqval = 0.0f;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen - 1; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -2 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                ++jpchars;
                totalfreq += 500L;
                int row = rawtext[i] + 256 - 161;
                int column = rawtext[i + 1] + 256 - 161;
                jpfreq = 3 <= row && row < 15 ? (jpfreq += 500L) : (15 <= row && row < 47 ? (jpfreq += 435L) : (jpfreq += 50L));
            }
            ++i;
        }
        rangeval = 50.0f * ((float)jpchars / (float)dbchars);
        freqval = 50.0f * ((float)jpfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    int _$3(byte[] rawtext) {
        for (int i = 0; i < rawtext.length; ++i) {
            if (i + 2 >= rawtext.length || rawtext[i] != 27 || (char)rawtext[i + 1] != '$' || (char)rawtext[i + 2] != 'B') continue;
            return 100;
        }
        return 0;
    }

    int _$2(byte[] rawtext) {
        int rawtextlen = 0;
        int dbchars = 1;
        int jpchars = 1;
        long jpfreq = 0L;
        long totalfreq = 1L;
        float rangeval = 0.0f;
        float freqval = 0.0f;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen - 1; ++i) {
            if (rawtext[i] >= 0) continue;
            ++dbchars;
            if (i + 1 < rawtext.length && (-127 <= rawtext[i] && rawtext[i] <= -97 || -32 <= rawtext[i] && rawtext[i] <= -17) && (64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 || -128 <= rawtext[i + 1] && rawtext[i + 1] <= -4)) {
                int adjust;
                ++jpchars;
                totalfreq += 500L;
                int row = rawtext[i] + 256;
                int column = rawtext[i + 1] + 256;
                if (column < 159) {
                    adjust = 1;
                    column = column > 127 ? (column -= 32) : (column -= 25);
                } else {
                    adjust = 0;
                    column -= 126;
                }
                row = row < 160 ? (row - 112 << 1) - adjust : (row - 176 << 1) - adjust;
                column = 32;
                jpfreq = 3 <= (row -= 32) && row < 15 ? (jpfreq += 500L) : (15 <= row && row < 47 ? (jpfreq += 435L) : (jpfreq += 50L));
                ++i;
                continue;
            }
            if (-95 <= rawtext[i] && rawtext[i] > -33) continue;
        }
        rangeval = 50.0f * ((float)jpchars / (float)dbchars);
        freqval = 50.0f * ((float)jpfreq / (float)totalfreq);
        return (int)(rangeval + freqval);
    }

    int _$1(byte[] rawtext) {
        int score = 0;
        int rawtextlen = 0;
        int goodbytes = 0;
        int asciibytes = 0;
        rawtextlen = rawtext.length;
        for (int i = 0; i < rawtextlen; ++i) {
            byte ch = rawtext[i];
            if (ch == 43) {
                ++asciibytes;
                continue;
            }
            if (65 <= ch && ch <= 90) {
                ++asciibytes;
                continue;
            }
            if (97 <= ch && ch <= 122) {
                ++asciibytes;
                continue;
            }
            if (48 <= ch && ch <= 57) {
                ++asciibytes;
                continue;
            }
            if (ch == 45 || ch == 95 || ch == 46 || ch == 33 || ch == 126 || ch == 42 || ch == 47 || ch == 40 || ch == 41) {
                ++asciibytes;
                continue;
            }
            if (ch != 37 && ch != 92) continue;
            if (117 != rawtext[i + 1]) {
                i += 2;
                goodbytes += 3;
                continue;
            }
            i += 5;
            goodbytes += 6;
        }
        score = (int)(100.0f * ((float)goodbytes / (float)rawtext.length));
        if (goodbytes == asciibytes) {
            score = 0;
        }
        if (goodbytes + asciibytes == rawtextlen) {
            return 100;
        }
        return score;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LANG {
        ALL,
        CHINESE,
        SIMPLIFIED_CHINESE,
        TRADITIONAL_CHINESE,
        JAPANESE,
        KOREAN;

    }
}

