/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.NumberArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Compare
extends Function {
    private Expression _$2;
    private Expression _$1;

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cmp" + mm.getMessage("function.missingParam"));
        }
        if (this.param.isLeaf()) {
            this._$2 = this.param.getLeafExpression();
        } else {
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cmp" + mm.getMessage("function.invalidParam"));
            }
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            if (sub1 == null || sub2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cmp" + mm.getMessage("function.invalidParam"));
            }
            this._$2 = sub1.getLeafExpression();
            this._$1 = sub2.getLeafExpression();
        }
    }

    private int _$1(Object result1, Object result2) {
        if (result1 instanceof BaseRecord) {
            if (result2 instanceof BaseRecord) {
                return ((BaseRecord)result1).compare((BaseRecord)result2);
            }
        } else if (result1 instanceof Sequence) {
            if (this.param.getType() == ';') {
                Sequence a = (Sequence)result1;
                if (result2 instanceof Sequence) {
                    Sequence b = (Sequence)result2;
                    if (a.length() > b.length()) {
                        return a.compareTo(b, b.length());
                    }
                    return a.compareTo(b);
                }
                if (a.length() != 0) {
                    return Variant.compare(a.getMem(1), result2, true);
                }
                return -1;
            }
            if (result2 instanceof Sequence) {
                return ((Sequence)result1).compareTo((Sequence)result2);
            }
            if (result2 instanceof Number && ((Number)result2).intValue() == 0) {
                return ((Sequence)result1).compare0();
            }
        }
        return Variant.compare(result1, result2, true);
    }

    public Object calculate(Context ctx) {
        if (this._$1 == null) {
            Object result1 = this._$2.calculate(ctx);
            if (!(result1 instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cmp" + mm.getMessage("function.paramTypeError"));
            }
            int cmp = ((Sequence)result1).compare0();
            return ObjectCache.getInteger(cmp);
        }
        Object result1 = this._$2.calculate(ctx);
        Object result2 = this._$1.calculate(ctx);
        int cmp = this._$1(result1, result2);
        return ObjectCache.getInteger(cmp);
    }

    public IArray calculateAll(Context ctx) {
        if (this._$1 == null) {
            IArray array = this._$2.calculateAll(ctx);
            int len = array.size();
            if (array instanceof ConstArray) {
                Object val = array.get(1);
                if (!(val instanceof Sequence)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("cmp" + mm.getMessage("function.paramTypeError"));
                }
                int cmp = ((Sequence)val).compare0();
                return new ConstArray(ObjectCache.getInteger(cmp), len);
            }
            IntArray result = new IntArray(len);
            for (int i = 1; i <= len; ++i) {
                Object val = array.get(i);
                if (!(val instanceof Sequence)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("cmp" + mm.getMessage("function.paramTypeError"));
                }
                int cmp = ((Sequence)val).compare0();
                result.pushInt(cmp);
            }
            return result;
        }
        IArray array1 = this._$2.calculateAll(ctx);
        IArray array2 = this._$1.calculateAll(ctx);
        if (array1 instanceof NumberArray && array2 instanceof NumberArray) {
            return ((NumberArray)array1).memberCompare((NumberArray)array2);
        }
        if (array1 instanceof ConstArray && array2 instanceof ConstArray) {
            int len = array1.size();
            int cmp = this._$1(array1.get(1), array2.get(1));
            return new ConstArray(ObjectCache.getInteger(cmp), len);
        }
        int len = array1.size();
        IntArray result = new IntArray(len);
        for (int i = 1; i <= len; ++i) {
            int cmp = this._$1(array1.get(i), array2.get(i));
            result.pushInt(cmp);
        }
        return result;
    }
}

