/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DfxManager;
import com.scudata.dm.FileObject;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.cursor.DFXCursor;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CellSetUtil;

public class CreateCursor
extends Function {
    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    private PgmCellSet _$1(INormalCell cell, Object[] args, Context ctx) {
        if (cell == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
        }
        ICellSet cs = cell.getCellSet();
        if (!(cs instanceof PgmCellSet)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
        }
        PgmCellSet pcs = (PgmCellSet)cs;
        PgmNormalCell pcell = (PgmNormalCell)cell;
        if (pcell.getCommand() == null || pcell.getCommand().getType() != 8) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.callNeedSub"));
        }
        return pcs.newCursorDFX(pcell, args);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object calculate(Context ctx) {
        PgmCellSet pcs;
        IParam param = this.param;
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.missingParam"));
        }
        boolean useCache = true;
        boolean isCode = false;
        boolean isCommand = false;
        if (this.option != null) {
            if (this.option.indexOf(114) != -1) {
                useCache = false;
            }
            if (this.option.indexOf(115) != -1) {
                isCode = true;
            }
            if (this.option.indexOf(99) != -1) {
                isCommand = true;
            }
        }
        DfxManager dfxManager = DfxManager.getInstance();
        if (param.isLeaf()) {
            Expression exp = param.getLeafExpression();
            if (isCommand) {
                INormalCell cell = exp.calculateCell(ctx);
                if (cell == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                }
                pcs = (PgmCellSet)this.cs;
                PgmCellSet.FuncInfo fi = pcs.getFuncInfo(cell);
                if (fi == null) {
                    pcs = this._$1(cell, null, ctx);
                    return new DFXCursor(pcs, ctx, useCache);
                }
                pcs = pcs.newCursorDFX(fi, fi.getDefaultValues());
                return new DFXCursor(pcs, ctx, useCache);
            }
            Object obj = exp.calculate(ctx);
            if (obj instanceof String) {
                if (isCode) {
                    pcs = CellSetUtil.toPgmCellSet((String)obj);
                    return new DFXCursor(pcs, ctx, useCache);
                }
                if (useCache) {
                    pcs = dfxManager.removeDfx((String)obj, ctx);
                    return new DFXCursor(pcs, ctx, useCache);
                }
                pcs = DfxManager.readDfx((String)obj, ctx);
                return new DFXCursor(pcs, ctx, useCache);
            }
            if (!(obj instanceof FileObject)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
            }
            if (useCache) {
                pcs = dfxManager.removeDfx((FileObject)obj, ctx);
                return new DFXCursor(pcs, ctx, useCache);
            }
            pcs = DfxManager.readDfx((FileObject)obj, ctx);
            return new DFXCursor(pcs, ctx, useCache);
        }
        int size = param.getSubSize();
        IParam sub0 = param.getSub(0);
        if (sub0 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
        }
        Expression exp = sub0.getLeafExpression();
        if (isCommand) {
            INormalCell cell = exp.calculateCell(ctx);
            if (cell == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
            }
            pcs = (PgmCellSet)this.cs;
            PgmCellSet.FuncInfo fi = pcs.getFuncInfo(cell);
            if (fi == null) {
                Object[] args = new Object[size - 1];
                int i = 1;
                while (true) {
                    if (i >= size) {
                        pcs = this._$1(cell, args, ctx);
                        return new DFXCursor(pcs, ctx, useCache);
                    }
                    IParam sub = param.getSub(i);
                    if (sub != null) {
                        args[i - 1] = sub.getLeafExpression().calculate(ctx);
                    }
                    ++i;
                }
            }
            Object[] args = fi.getDefaultValues();
            if (args == null || args.length < size - 1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(fi.getFnName() + mm.getMessage("function.invalidParam"));
            }
            int i = 1;
            while (true) {
                if (i >= size) {
                    pcs = pcs.newCursorDFX(fi, args);
                    return new DFXCursor(pcs, ctx, useCache);
                }
                IParam sub = param.getSub(i);
                if (sub != null) {
                    args[i - 1] = sub.getLeafExpression().calculate(ctx);
                }
                ++i;
            }
        }
        Object obj = exp.calculate(ctx);
        if (obj instanceof String) {
            if (isCode) {
                pcs = CellSetUtil.toPgmCellSet((String)obj);
                ParamList paramList = new ParamList();
                pcs.setParamList(paramList);
                for (int i = 1; i < size; ++i) {
                    paramList.add("arg" + i, (byte)1, null);
                }
            } else {
                pcs = useCache ? dfxManager.removeDfx((String)obj, ctx) : DfxManager.readDfx((String)obj, ctx);
            }
        } else {
            if (!(obj instanceof FileObject)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
            }
            pcs = useCache ? dfxManager.removeDfx((FileObject)obj, ctx) : DfxManager.readDfx((FileObject)obj, ctx);
        }
        ParamList list = pcs.getParamList();
        if (list == null) return new DFXCursor(pcs, ctx, useCache);
        if (size - 1 > list.count()) {
            size = list.count() + 1;
        }
        Context curCtx = pcs.getContext();
        int i = 1;
        while (i < size) {
            IParam sub = param.getSub(i);
            Param p = list.get(i - 1);
            if (sub != null) {
                Object val = sub.getLeafExpression().calculate(ctx);
                curCtx.setParamValue(p.getName(), val);
            } else {
                curCtx.setParamValue(p.getName(), null);
            }
            ++i;
        }
        return new DFXCursor(pcs, ctx, useCache);
    }
}

